import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [es](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonopensearchservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Es extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to the destination domain owner to accept an inbound cross-cluster search connection request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_AcceptInboundConnection.html
     */
    toAcceptInboundConnection(): this;
    /**
     * Grants permission to the destination domain owner to accept an inbound cross-cluster search connection request. This permission is deprecated. Use AcceptInboundConnection instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_AcceptInboundConnection.html
     */
    toAcceptInboundCrossClusterSearchConnection(): this;
    /**
     * Grants permission to add the data source for the OpenSearch Service domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_AddDataSource.html
     */
    toAddDataSource(): this;
    /**
     * Grants permission to add the data source for the provided OpenSearch arns
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_AddDirectQueryDataSource.html
     */
    toAddDirectQueryDataSource(): this;
    /**
     * Grants permission to attach resource tags to an OpenSearch Service domain, data source, or application
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_AddTags.html
     */
    toAddTags(): this;
    /**
     * Grants permission to associate a package with an OpenSearch Service domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_AssociatePackage.html
     */
    toAssociatePackage(): this;
    /**
     * Grants permission to associate multiple packages with an OpenSearch Service domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_AssociatePackages.html
     */
    toAssociatePackages(): this;
    /**
     * Grants permission to provide access to an Amazon OpenSearch Service domain through the use of an interface VPC endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_AuthorizeVpcEndpointAccess.html
     */
    toAuthorizeVpcEndpointAccess(): this;
    /**
     * Grants permission to cancel a change on an OpenSearch Service domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_CancelDomainConfigChange.html
     */
    toCancelDomainConfigChange(): this;
    /**
     * Grants permission to cancel a service software update of a domain. This permission is deprecated. Use CancelServiceSoftwareUpdate instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_CancelServiceSoftwareUpdate.html
     */
    toCancelElasticsearchServiceSoftwareUpdate(): this;
    /**
     * Grants permission to cancel a service software update of a domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_CancelServiceSoftwareUpdate.html
     */
    toCancelServiceSoftwareUpdate(): this;
    /**
     * Grants permission to create an OpenSearch Application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_CreateApplication.html
     */
    toCreateApplication(): this;
    /**
     * Grants permission to create an Amazon OpenSearch Service domain
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_CreateDomain.html
     */
    toCreateDomain(): this;
    /**
     * Grants permission to create an OpenSearch Service domain. This permission is deprecated. Use CreateDomain instead
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_CreateDomain.html
     */
    toCreateElasticsearchDomain(): this;
    /**
     * Grants permission to create the service-linked role required for OpenSearch Service domains that use VPC access. This permission is deprecated. OpenSearch Service creates the service-linked role for you
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/Welcome.html
     */
    toCreateElasticsearchServiceRole(): this;
    /**
     * Grants permission to create a new cross-cluster search connection from a source domain to a destination domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_CreateOutboundConnection.html
     */
    toCreateOutboundConnection(): this;
    /**
     * Grants permission to create a new cross-cluster search connection from a source domain to a destination domain. This permission is deprecated. Use CreateOutboundConnection instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_CreateOutboundConnection.html
     */
    toCreateOutboundCrossClusterSearchConnection(): this;
    /**
     * Grants permission to add a package for use with OpenSearch Service domains
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_CreatePackage.html
     */
    toCreatePackage(): this;
    /**
     * Grants permission to create the service-linked role required for Amazon OpenSearch Service domains that use VPC access
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/Welcome.html
     */
    toCreateServiceRole(): this;
    /**
     * Grants permission to create an Amazon OpenSearch Service-managed VPC endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_CreateVpcEndpoint.html
     */
    toCreateVpcEndpoint(): this;
    /**
     * Grants permission to delete an OpenSearch Application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DeleteApplication.html
     */
    toDeleteApplication(): this;
    /**
     * Grants permission to delete the data source for the OpenSearch Service domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DeleteDataSource.html
     */
    toDeleteDataSource(): this;
    /**
     * Grants permission to delete the data source for the provided OpenSearch arns
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DeleteDirectQueryDataSource.html
     */
    toDeleteDirectQueryDataSource(): this;
    /**
     * Grants permission to delete an Amazon OpenSearch Service domain and all of its data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DeleteDomain.html
     */
    toDeleteDomain(): this;
    /**
     * Grants permission to delete an OpenSearch Service domain and all of its data. This permission is deprecated. Use DeleteDomain instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DeleteDomain.html
     */
    toDeleteElasticsearchDomain(): this;
    /**
     * Grants permission to delete the service-linked role required for OpenSearch Service domains that use VPC access. This permission is deprecated. Use the IAM API to delete service-linked roles
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_Welcome.html
     */
    toDeleteElasticsearchServiceRole(): this;
    /**
     * Grants permission to the destination domain owner to delete an existing inbound cross-cluster search connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DeleteInboundConnection.html
     */
    toDeleteInboundConnection(): this;
    /**
     * Grants permission to the destination domain owner to delete an existing inbound cross-cluster search connection. This permission is deprecated. Use DeleteInboundConnection instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DeleteInboundConnection.html
     */
    toDeleteInboundCrossClusterSearchConnection(): this;
    /**
     * Grants permission to the source domain owner to delete an existing outbound cross-cluster search connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DeleteOutboundConnection.html
     */
    toDeleteOutboundConnection(): this;
    /**
     * Grants permission to the source domain owner to delete an existing outbound cross-cluster search connection. This permission is deprecated. Use DeleteOutboundConnection instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DeleteOutboundConnection.html
     */
    toDeleteOutboundCrossClusterSearchConnection(): this;
    /**
     * Grants permission to delete a package from OpenSearch Service. The package cannot be associated with any domains
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DeletePackage.html
     */
    toDeletePackage(): this;
    /**
     * Grants permission to delete an Amazon OpenSearch Service-managed interface VPC endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DeleteVpcEndpoint.html
     */
    toDeleteVpcEndpoint(): this;
    /**
     * Grants permission to view a description of the domain configuration for the specified OpenSearch Service domain, including the domain ID, service endpoint, and ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeDomain.html
     */
    toDescribeDomain(): this;
    /**
     * Grants permission to view the Auto-Tune configuration of the domain for the specified OpenSearch Service domain, including the Auto-Tune state and maintenance schedules
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeDomainAutoTunes.html
     */
    toDescribeDomainAutoTunes(): this;
    /**
     * Grants permission to view detail stage progress of an OpenSearch Service domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeDomainChangeProgress.html
     */
    toDescribeDomainChangeProgress(): this;
    /**
     * Grants permission to view a description of the configuration options and status of an OpenSearch Service domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeDomainConfig.html
     */
    toDescribeDomainConfig(): this;
    /**
     * Grants permission to view information about domain and node health, the standby Availability Zone, number of nodes per Availability Zone, and shard count per node
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeDomainHealth.html
     */
    toDescribeDomainHealth(): this;
    /**
     * Grants permission to view information about nodes configured for the domain and their configurations- the node id, type of node, status of node, Availability Zone, instance type and storage
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeDomainNodes.html
     */
    toDescribeDomainNodes(): this;
    /**
     * Grants permission to view a description of the domain configuration for up to five specified OpenSearch Service domains
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeDomains.html
     */
    toDescribeDomains(): this;
    /**
     * Grants permission to describe the status of a pre-update validation check on an OpenSearch Service domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeDryRunProgress.html
     */
    toDescribeDryRunProgress(): this;
    /**
     * Grants permission to view a description of the domain configuration for the specified OpenSearch Service domain, including the domain ID, service endpoint, and ARN. This permission is deprecated. Use DescribeDomain instead
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeDomain.html
     */
    toDescribeElasticsearchDomain(): this;
    /**
     * Grants permission to view a description of the configuration and status of an OpenSearch Service domain. This permission is deprecated. Use DescribeDomainConfig instead
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeDomainConfig.html
     */
    toDescribeElasticsearchDomainConfig(): this;
    /**
     * Grants permission to view a description of the domain configuration for up to five specified Amazon OpenSearch domains. This permission is deprecated. Use DescribeDomains instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeDomains.html
     */
    toDescribeElasticsearchDomains(): this;
    /**
     * Grants permission to view the instance count, storage, and master node limits for a given OpenSearch version and instance type. This permission is deprecated. Use DescribeInstanceTypeLimits instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeInstanceTypeLimits.html
     */
    toDescribeElasticsearchInstanceTypeLimits(): this;
    /**
     * Grants permission to list all the inbound cross-cluster search connections for a destination domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeInboundConnections.html
     */
    toDescribeInboundConnections(): this;
    /**
     * Grants permission to list all the inbound cross-cluster search connections for a destination domain. This permission is deprecated. Use DescribeInboundConnections instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeInboundConnections.html
     */
    toDescribeInboundCrossClusterSearchConnections(): this;
    /**
     * Grants permission to view the instance count, storage, and master node limits for a given engine version and instance type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeInstanceTypeLimits.html
     */
    toDescribeInstanceTypeLimits(): this;
    /**
     * Grants permission to list all the outbound cross-cluster search connections for a source domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeOutboundConnections.html
     */
    toDescribeOutboundConnections(): this;
    /**
     * Grants permission to list all the outbound cross-cluster search connections for a source domain. This permission is deprecated. Use DescribeOutboundConnections instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeOutboundConnections.html
     */
    toDescribeOutboundCrossClusterSearchConnections(): this;
    /**
     * Grants permission to describe all packages available to OpenSearch Service domains
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribePackages.html
     */
    toDescribePackages(): this;
    /**
     * Grants permission to fetch Reserved Instance offerings for Amazon OpenSearch Service. This permission is deprecated. Use DescribeReservedInstanceOfferings instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeReservedInstanceOfferings.html
     */
    toDescribeReservedElasticsearchInstanceOfferings(): this;
    /**
     * Grants permission to fetch OpenSearch Service Reserved Instances that have already been purchased. This permission is deprecated. Use DescribeReservedInstances instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeReservedInstances.html
     */
    toDescribeReservedElasticsearchInstances(): this;
    /**
     * Grants permission to fetch Reserved Instance offerings for OpenSearch Service
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeReservedInstanceOfferings.html
     */
    toDescribeReservedInstanceOfferings(): this;
    /**
     * Grants permission to fetch OpenSearch Service Reserved Instances that have already been purchased
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeReservedInstances.html
     */
    toDescribeReservedInstances(): this;
    /**
     * Grants permission to describe one or more Amazon OpenSearch Service-managed VPC endpoints
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DescribeVpcEndpoints.html
     */
    toDescribeVpcEndpoints(): this;
    /**
     * Grants permission to disassociate a package from the specified OpenSearch Service domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DissociatePackage.html
     */
    toDissociatePackage(): this;
    /**
     * Grants permission to disassociate multiple packages from the specified OpenSearch Service domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DissociatePackages.html
     */
    toDissociatePackages(): this;
    /**
     * Grants permission to send cross-cluster requests to a destination domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/Welcome.html
     */
    toESCrossClusterGet(): this;
    /**
     * Grants permission to send HTTP DELETE requests to the OpenSearch APIs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/Welcome.html
     */
    toESHttpDelete(): this;
    /**
     * Grants permission to send HTTP GET requests to the OpenSearch APIs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/Welcome.html
     */
    toESHttpGet(): this;
    /**
     * Grants permission to send HTTP HEAD requests to the OpenSearch APIs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/Welcome.html
     */
    toESHttpHead(): this;
    /**
     * Grants permission to send HTTP PATCH requests to the OpenSearch APIs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/Welcome.html
     */
    toESHttpPatch(): this;
    /**
     * Grants permission to send HTTP POST requests to the OpenSearch APIs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/Welcome.html
     */
    toESHttpPost(): this;
    /**
     * Grants permission to send HTTP PUT requests to the OpenSearch APIs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/Welcome.html
     */
    toESHttpPut(): this;
    /**
     * Grants permission to get information about an OpenSearch Application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_GetApplication.html
     */
    toGetApplication(): this;
    /**
     * Grants permission to fetch a list of compatible OpenSearch and Elasticsearch versions to which an OpenSearch Service domain can be upgraded. This permission is deprecated. Use GetCompatibleVersions instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_GetCompatibleVersions.html
     */
    toGetCompatibleElasticsearchVersions(): this;
    /**
     * Grants permission to fetch list of compatible engine versions to which an OpenSearch Service domain can be upgraded
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_GetCompatibleVersions.html
     */
    toGetCompatibleVersions(): this;
    /**
     * Grants permission to get the data source for the OpenSearch Service domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_GetDataSource.html
     */
    toGetDataSource(): this;
    /**
     * Grants permission to get the data source for the provided OpenSearch arns
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_GetDirectQueryDataSource.html
     */
    toGetDirectQueryDataSource(): this;
    /**
     * Grants permission to retrieve the status of maintenance action for the node
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_GetDomainMaintenanceStatus.html
     */
    toGetDomainMaintenanceStatus(): this;
    /**
     * Grants permission to fetch the version history for a package
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_GetPackageVersionHistory.html
     */
    toGetPackageVersionHistory(): this;
    /**
     * Grants permission to fetch the upgrade history of a given OpenSearch Service domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_GetUpgradeHistory.html
     */
    toGetUpgradeHistory(): this;
    /**
     * Grants permission to fetch the upgrade status of a given OpenSearch Service domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_GetUpgradeStatus.html
     */
    toGetUpgradeStatus(): this;
    /**
     * Grants permission to list OpenSearch Applications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListApplications.html
     */
    toListApplications(): this;
    /**
     * Grants permission to retrieve a list of data source for the OpenSearch Service domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListDataSources.html
     */
    toListDataSources(): this;
    /**
     * Grants permission to retrieve a list of data source for the provided OpenSearch arns
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListDirectQueryDataSources.html
     */
    toListDirectQueryDataSources(): this;
    /**
     * Grants permission to retrieve a list of maintenance actions for the OpenSearch Service domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListDomainMaintenances.html
     */
    toListDomainMaintenances(): this;
    /**
     * Grants permission to display the names of all OpenSearch Service domains that the current user owns
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListDomainNames.html
     */
    toListDomainNames(): this;
    /**
     * Grants permission to list all OpenSearch Service domains that a package is associated with
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListDomainsForPackage.html
     */
    toListDomainsForPackage(): this;
    /**
     * Grants permission to list all instance types and available features for a given OpenSearch version. This permission is deprecated. Use ListInstanceTypeDetails instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListInstanceTypeDetails.html
     */
    toListElasticsearchInstanceTypeDetails(): this;
    /**
     * Grants permission to list all EC2 instance types that are supported for a given OpenSearch version
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListInstanceTypeDetails.html
     */
    toListElasticsearchInstanceTypes(): this;
    /**
     * Grants permission to list all supported OpenSearch versions on Amazon OpenSearch Service. This permission is deprecated. Use ListVersions instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListVersions.html
     */
    toListElasticsearchVersions(): this;
    /**
     * Grants permission to list all instance types and available features for a given OpenSearch or Elasticsearch version
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListInstanceTypeDetails.html
     */
    toListInstanceTypeDetails(): this;
    /**
     * Grants permission to list all packages associated with the OpenSearch Service domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListPackagesForDomain.html
     */
    toListPackagesForDomain(): this;
    /**
     * Grants permission to retrieve a list of configuration changes that are scheduled for a OpenSearch Service domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html
     */
    toListScheduledActions(): this;
    /**
     * Grants permission to display all resource tags for an OpenSearch Service domain, data source, or application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListTags.html
     */
    toListTags(): this;
    /**
     * Grants permission to list all supported OpenSearch and Elasticsearch versions in Amazon OpenSearch Service
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListVersions.html
     */
    toListVersions(): this;
    /**
     * Grants permission to retrieve information about each AWS principal that is allowed to access a given Amazon OpenSearch Service domain through the use of an interface VPC endpoint
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListVpcEndpointAccess.html
     */
    toListVpcEndpointAccess(): this;
    /**
     * Grants permission to retrieve all Amazon OpenSearch Service-managed VPC endpoints in the current AWS account and Region
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListVpcEndpoints.html
     */
    toListVpcEndpoints(): this;
    /**
     * Grants permission to retrieve all Amazon OpenSearch Service-managed VPC endpoints associated with a particular domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListVpcEndpointsForDomain.html
     */
    toListVpcEndpointsForDomain(): this;
    /**
     * Grants permission to purchase OpenSearch Service Reserved Instances. This permission is deprecated. Use PurchaseReservedInstanceOffering instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_PurchaseReservedInstanceOffering.html
     */
    toPurchaseReservedElasticsearchInstanceOffering(): this;
    /**
     * Grants permission to purchase OpenSearch reserved instances
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_PurchaseReservedInstanceOffering.html
     */
    toPurchaseReservedInstanceOffering(): this;
    /**
     * Grants permission to the destination domain owner to reject an inbound cross-cluster search connection request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_RejectInboundConnection.html
     */
    toRejectInboundConnection(): this;
    /**
     * Grants permission to the destination domain owner to reject an inbound cross-cluster search connection request. This permission is deprecated. Use RejectInboundConnection instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_RejectInboundConnection.html
     */
    toRejectInboundCrossClusterSearchConnection(): this;
    /**
     * Grants permission to remove resource tags from an OpenSearch Service domain, data source, or application
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_RemoveTags.html
     */
    toRemoveTags(): this;
    /**
     * Grants permission to revoke access to an Amazon OpenSearch Service domain that was provided through an interface VPC endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_RevokeVpcEndpointAccess.html
     */
    toRevokeVpcEndpointAccess(): this;
    /**
     * Grants permission to initiate the maintenance on the node
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_StartDomainMaintenance.html
     */
    toStartDomainMaintenance(): this;
    /**
     * Grants permission to start a service software update of a domain. This permission is deprecated. Use StartServiceSoftwareUpdate instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_StartServiceSoftwareUpdate.html
     */
    toStartElasticsearchServiceSoftwareUpdate(): this;
    /**
     * Grants permission to start a service software update of a domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_StartServiceSoftwareUpdate.html
     */
    toStartServiceSoftwareUpdate(): this;
    /**
     * Grants permission to update an OpenSearch Application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_UpdateApplication.html
     */
    toUpdateApplication(): this;
    /**
     * Grants permission to update the data source for the OpenSearch Service domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_UpdateDataSource.html
     */
    toUpdateDataSource(): this;
    /**
     * Grants permission to update the data source for the provided OpenSearch arns
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_UpdateDirectQueryDataSource.html
     */
    toUpdateDirectQueryDataSource(): this;
    /**
     * Grants permission to modify the configuration of an OpenSearch Service domain, such as the instance type or number of instances
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_UpdateDomainConfig.html
     */
    toUpdateDomainConfig(): this;
    /**
     * Grants permission to modify the configuration of an OpenSearch Service domain, such as the instance type or number of instances. This permission is deprecated. Use UpdateDomainConfig instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_UpdateDomainConfig.html
     */
    toUpdateElasticsearchDomainConfig(): this;
    /**
     * Grants permission to update a package for use with OpenSearch Service domains
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_UpdatePackage.html
     */
    toUpdatePackage(): this;
    /**
     * Grants permission to update scope a package
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_UpdatePackageScope.html
     */
    toUpdatePackageScope(): this;
    /**
     * Grants permission to reschedule a planned OpenSearch Service domain configuration change for a later time
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_UpdateScheduledAction.html
     */
    toUpdateScheduledAction(): this;
    /**
     * Grants permission to modify an Amazon OpenSearch Service-managed interface VPC endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_UpdateVpcEndpoint.html
     */
    toUpdateVpcEndpoint(): this;
    /**
     * Grants permission to initiate upgrade of an OpenSearch Service domain to a given version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_UpgradeDomain.html
     */
    toUpgradeDomain(): this;
    /**
     * Grants permission to initiate upgrade of an OpenSearch Service domain to a specified version. This permission is deprecated. Use UpgradeDomain instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_UpgradeDomain.html
     */
    toUpgradeElasticsearchDomain(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type domain to the statement
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html
     *
     * @param domainName - Identifier for the domainName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDomain(domainName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type application to the statement
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplication(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type es_role to the statement
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/slr.html
     *
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEsRole(account?: string, partition?: string): this;
    /**
     * Adds a resource of type opensearchservice_role to the statement
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/slr.html
     *
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onOpensearchserviceRole(account?: string, partition?: string): this;
    /**
     * Adds a resource of type datasource to the statement
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/datasource.html
     *
     * @param dataSourceName - Identifier for the dataSourceName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDatasource(dataSourceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access based on the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toAddDirectQueryDataSource()
     * - .toAddTags()
     * - .toCreateApplication()
     * - .toCreateDomain()
     * - .toCreateElasticsearchDomain()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access based on the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - domain
     * - application
     * - es_role
     * - opensearchservice_role
     * - datasource
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access based on the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toAddDirectQueryDataSource()
     * - .toAddTags()
     * - .toCreateApplication()
     * - .toCreateDomain()
     * - .toCreateElasticsearchDomain()
     * - .toRemoveTags()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [es](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonopensearchservice.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
