import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [payment-cryptography](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspaymentcryptography.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class PaymentCryptography extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a user-friendly name for a Key
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateAlias.html
     */
    toCreateAlias(): this;
    /**
     * Grants permission to create a unique customer managed key in the caller's AWS account and region
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - payment-cryptography:TagResource
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html
     */
    toCreateKey(): this;
    /**
     * Grants permission to decrypt ciphertext data to plaintext using symmetric, asymmetric or DUKPT data encryption key
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_DecryptData.html
     */
    toDecryptData(): this;
    /**
     * Grants permission to delete the specified alias
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteAlias.html
     */
    toDeleteAlias(): this;
    /**
     * Grants permission to schedule the deletion of a Key
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteKey.html
     */
    toDeleteKey(): this;
    /**
     * Grants permission to encrypt plaintext data to ciphertext using symmetric, asymmetric or DUKPT data encryption key
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_EncryptData.html
     */
    toEncryptData(): this;
    /**
     * Grants permission to export a key from the service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ExportKey.html
     */
    toExportKey(): this;
    /**
     * Grants permission to generate card-related data using algorithms such as Card Verification Values (CVV/CVV2), Dynamic Card Verification Values (dCVV/dCVV2) or Card Security Codes (CSC) that check the validity of a magnetic stripe card
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_GenerateCardValidationData.html
     */
    toGenerateCardValidationData(): this;
    /**
     * Grants permission to generate a MAC (Message Authentication Code) cryptogram
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_GenerateMac.html
     */
    toGenerateMac(): this;
    /**
     * Grants permission to generate a MAC (Message Authentication Code) cryptogram
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_GenerateMacEmvPinChange.html
     */
    toGenerateMacEmvPinChange(): this;
    /**
     * Grants permission to generate pin-related data such as PIN, PIN Verification Value (PVV), PIN Block and PIN Offset during new card issuance or card re-issuance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_GeneratePinData.html
     */
    toGeneratePinData(): this;
    /**
     * Grants permission to return the keyArn associated with an aliasName
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetAlias.html
     */
    toGetAlias(): this;
    /**
     * Grants permission to return the detailed information about the specified key
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetKey.html
     */
    toGetKey(): this;
    /**
     * Grants permission to get the export token and the signing key certificate to initiate a TR-34 key export
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForExport.html
     */
    toGetParametersForExport(): this;
    /**
     * Grants permission to get the import token and the wrapping key certificate to initiate a TR-34 key import
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForImport.html
     */
    toGetParametersForImport(): this;
    /**
     * Grants permission to return the public key from a key of class PUBLIC_KEY
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetPublicKeyCertificate.html
     */
    toGetPublicKeyCertificate(): this;
    /**
     * Grants permission to imports keys and public key certificates
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - payment-cryptography:TagResource
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html
     */
    toImportKey(): this;
    /**
     * Grants permission to return a list of aliases created for all keys in the caller's AWS account and Region
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListAliases.html
     */
    toListAliases(): this;
    /**
     * Grants permission to return a list of keys created in the caller's AWS account and Region
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListKeys.html
     */
    toListKeys(): this;
    /**
     * Grants permission to return a list of tags created in the caller's AWS account and Region
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to re-encrypt ciphertext using DUKPT, Symmetric and Asymmetric Data Encryption Keys
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_ReEncryptData.html
     */
    toReEncryptData(): this;
    /**
     * Grants permission to cancel a scheduled key deletion if at any point during the waiting period a Key needs to be revived
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_RestoreKey.html
     */
    toRestoreKey(): this;
    /**
     * Grants permission to enable a disabled Key
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_StartKeyUsage.html
     */
    toStartKeyUsage(): this;
    /**
     * Grants permission to disable an enabled Key
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_StopKeyUsage.html
     */
    toStopKeyUsage(): this;
    /**
     * Grants permission to add or overwrites one or more tags for the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to translate encrypted PIN block from and to ISO 9564 formats 0,1,3,4
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_TranslatePinData.html
     */
    toTranslatePinData(): this;
    /**
     * Grants permission to remove the specified tag or tags from the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to change the key to which an alias is assigned, or unassign it from its current key
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UpdateAlias.html
     */
    toUpdateAlias(): this;
    /**
     * Grants permission to verify Authorization Request Cryptogram (ARQC) for a EMV chip payment card authorization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_VerifyAuthRequestCryptogram.html
     */
    toVerifyAuthRequestCryptogram(): this;
    /**
     * Grants permission to verify card-related validation data using algorithms such as Card Verification Values (CVV/CVV2), Dynamic Card Verification Values (dCVV/dCVV2) and Card Security Codes (CSC)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_VerifyCardValidationData.html
     */
    toVerifyCardValidationData(): this;
    /**
     * Grants permission to verify MAC (Message Authentication Code) of input data against a provided MAC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_VerifyMac.html
     */
    toVerifyMac(): this;
    /**
     * Grants permission to verify pin-related data such as PIN and PIN Offset using algorithms including VISA PVV and IBM3624
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_VerifyPinData.html
     */
    toVerifyPinData(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type key to the statement
     *
     * @param keyId - Identifier for the keyId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceAliases()
     */
    onKey(keyId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type alias to the statement
     *
     * @param alias - Identifier for the alias.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifResourceAliases()
     */
    onAlias(alias: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by both the key and value of the tag in the request for the specified operation
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateKey()
     * - .toDeleteAlias()
     * - .toGetAlias()
     * - .toImportKey()
     * - .toTagResource()
     * - .toUpdateAlias()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tags assigned to a key for the specified operation
     *
     * https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/security_iam_service-with-iam.html#security_iam_service-with-iam-tags
     *
     * Applies to resource types:
     * - key
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys in the request for the specified operation
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateKey()
     * - .toDeleteAlias()
     * - .toGetAlias()
     * - .toImportKey()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateAlias()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the CertificateAuthorityPublicKeyIdentifier specified in the request or the ImportKey, and ExportKey operations
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCertificateAuthorityPublicKeyIdentifier(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the type of key material being imported [RootCertificatePublicKey, TrustedCertificatePublicKey, Tr34KeyBlock, Tr31KeyBlock] for the ImportKey operation
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifImportKeyMaterial(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by KeyAlgorithm specified in the request for the CreateKey operation
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifKeyAlgorithm(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by KeyClass specified in the request for the CreateKey operation
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifKeyClass(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by KeyClass specified in the request or associated with a key for the CreateKey operation
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifKeyUsage(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by aliases in the request for the specified operation
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRequestAlias(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by aliases associated with a key for the specified operation
     *
     * Applies to resource types:
     * - key
     * - alias
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifResourceAliases(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the WrappingKeyIdentifier specified in the request for the ImportKey, and ExportKey operations
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifWrappingKeyIdentifier(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [payment-cryptography](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspaymentcryptography.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
