import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [pricing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspricelist.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Pricing extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to retrieve service details for all (paginated) services (if serviceCode is not set) or service detail for a particular service (if given serviceCode)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_DescribeServices.html
     */
    toDescribeServices(): this;
    /**
     * Grants permission to retrieve all (paginated) possible values for a given attribute
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetAttributeValues.html
     */
    toGetAttributeValues(): this;
    /**
     * Grants permission to retrieve the price list file URL for the given parameters
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetPriceListFileUrl.html
     */
    toGetPriceListFileUrl(): this;
    /**
     * Grants permission to retrieve all matching products with given search criteria
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetProducts.html
     */
    toGetProducts(): this;
    /**
     * Grants permission to list all (paginated) eligible price lists for the given parameters
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html
     */
    toListPriceLists(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [pricing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspricelist.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
