"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pricing = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [pricing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspricelist.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Pricing extends shared_1.PolicyStatement {
    /**
     * Grants permission to retrieve service details for all (paginated) services (if serviceCode is not set) or service detail for a particular service (if given serviceCode)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_DescribeServices.html
     */
    toDescribeServices() {
        return this.to('DescribeServices');
    }
    /**
     * Grants permission to retrieve all (paginated) possible values for a given attribute
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetAttributeValues.html
     */
    toGetAttributeValues() {
        return this.to('GetAttributeValues');
    }
    /**
     * Grants permission to retrieve the price list file URL for the given parameters
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetPriceListFileUrl.html
     */
    toGetPriceListFileUrl() {
        return this.to('GetPriceListFileUrl');
    }
    /**
     * Grants permission to retrieve all matching products with given search criteria
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetProducts.html
     */
    toGetProducts() {
        return this.to('GetProducts');
    }
    /**
     * Grants permission to list all (paginated) eligible price lists for the given parameters
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html
     */
    toListPriceLists() {
        return this.to('ListPriceLists');
    }
    /**
     * Statement provider for service [pricing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspricelist.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'pricing';
        this.accessLevelList = {
            Read: [
                'DescribeServices',
                'GetAttributeValues',
                'GetPriceListFileUrl',
                'GetProducts',
                'ListPriceLists'
            ]
        };
    }
}
exports.Pricing = Pricing;
//# sourceMappingURL=data:application/json;base64,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