import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [q](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonq.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Q extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to associate an AWS resource with an Amazon Q connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toAssociateConnectorResource(): this;
    /**
     * Grants permission to create a user or group assignment for an Amazon Q Developer Profile
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifIdentitystoreUserId()
     * - .ifIdentitystoreGroupId()
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toCreateAssignment(): this;
    /**
     * Grants permission to create OAuth user in Amazon Q
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kms:Decrypt
     * - kms:GenerateDataKeyWithoutPlaintext
     * - kms:ReEncryptFrom
     * - kms:ReEncryptTo
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toCreateAuthGrant(): this;
    /**
     * Grants permission to register an OAuth application in Amazon Q
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kms:Decrypt
     * - kms:GenerateDataKeyWithoutPlaintext
     * - kms:ReEncryptFrom
     * - kms:ReEncryptTo
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toCreateOAuthAppConnection(): this;
    /**
     * Grants permission to create and configure a third party plugin in Amazon Q
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toCreatePlugin(): this;
    /**
     * Grants permission to delete a user or group assignment for an Amazon Q Developer Profile
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifIdentitystoreUserId()
     * - .ifIdentitystoreGroupId()
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toDeleteAssignment(): this;
    /**
     * Grants permission to delete a conversation with Amazon Q
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toDeleteConversation(): this;
    /**
     * Grants permission to delete an OAuth application in Amazon Q
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kms:Decrypt
     * - kms:GenerateDataKeyWithoutPlaintext
     * - kms:ReEncryptFrom
     * - kms:ReEncryptTo
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toDeleteOAuthAppConnection(): this;
    /**
     * Grants permission to delete a configured plugin in Amazon Q
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toDeletePlugin(): this;
    /**
     * Grants permission to generate code from CLI commands in Amazon Q
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toGenerateCodeFromCommands(): this;
    /**
     * Grants permission to generate code recommendations in Amazon Q
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toGenerateCodeRecommendations(): this;
    /**
     * Grants permission to view information about a specific Amazon Q connector
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toGetConnector(): this;
    /**
     * Grants permission to get individual messages associated with a specific conversation with Amazon Q
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toGetConversation(): this;
    /**
     * Grants permission to Amazon Q to get the identity metadata
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toGetIdentityMetadata(): this;
    /**
     * Grants permission to view information about a specific configured Amazon Q plugin
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toGetPlugin(): this;
    /**
     * Grants permission to get troubleshooting results with Amazon Q
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toGetTroubleshootingResults(): this;
    /**
     * Grants permission to list individual conversations associated with a specific Amazon Q user
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toListConversations(): this;
    /**
     * Grants permission to read metrics to populate Amazon Q dashboard
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toListDashboardMetrics(): this;
    /**
     * Grants permission to list available plugins in Amazon Q
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toListPluginProviders(): this;
    /**
     * Grants permission to list configured plugins in Amazon Q
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toListPlugins(): this;
    /**
     * Grants permission to list all tags associated with an Amazon Q resource
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to allow Amazon Q to perform actions on your behalf
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toPassRequest(): this;
    /**
     * Grants permission to reject a connection request for an Amazon Q connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toRejectConnector(): this;
    /**
     * Grants permission to trigger asynchronous Amazon Q actions
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kms:Decrypt
     * - kms:GenerateDataKeyWithoutPlaintext
     * - kms:ReEncryptFrom
     * - kms:ReEncryptTo
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toSendEvent(): this;
    /**
     * Grants permission to send a message to Amazon Q
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toSendMessage(): this;
    /**
     * Grants permission to start a conversation with Amazon Q
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toStartConversation(): this;
    /**
     * Grants permission to start a troubleshooting analysis with Amazon Q
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toStartTroubleshootingAnalysis(): this;
    /**
     * Grants permission to start a troubleshooting resolution explanation with Amazon Q
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toStartTroubleshootingResolutionExplanation(): this;
    /**
     * Grants permission to associate tags with an Amazon Q resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags associated with an Amazon Q resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update OAuth user in Amazon Q
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kms:Decrypt
     * - kms:GenerateDataKeyWithoutPlaintext
     * - kms:ReEncryptFrom
     * - kms:ReEncryptTo
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toUpdateAuthGrant(): this;
    /**
     * Grants permission to update a conversation with Amazon Q
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toUpdateConversation(): this;
    /**
     * Grants permission to update an OAuth application in Amazon Q
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kms:Decrypt
     * - kms:GenerateDataKeyWithoutPlaintext
     * - kms:ReEncryptFrom
     * - kms:ReEncryptTo
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toUpdateOAuthAppConnection(): this;
    /**
     * Grants permission to update a third party plugin in Amazon Q
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toUpdatePlugin(): this;
    /**
     * Grants permission to update a troubleshooting command result with Amazon Q
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toUpdateTroubleshootingCommandResult(): this;
    /**
     * Grants permission to use Amazon Q plugins
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toUsePlugin(): this;
    /**
     * Grants permission to verify an OAuth application in Amazon Q
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kms:Decrypt
     * - kms:GenerateDataKeyWithoutPlaintext
     * - kms:ReEncryptFrom
     * - kms:ReEncryptTo
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_manage-access-with-policies.html
     */
    toVerifyOAuthAppConnection(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type profile to the statement
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/as-whisper-admin.html#about-profiles
     *
     * @param identifier - Identifier for the identifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onProfile(identifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type plugin to the statement
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/plugins.html
     *
     * @param identifier - Identifier for the identifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPlugin(identifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toCreatePlugin()
     * - .toTagResource()
     * - .toUpdatePlugin()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the Amazon Q resource
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toDeletePlugin()
     * - .toGetPlugin()
     * - .toListTagsForResource()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * Applies to resource types:
     * - plugin
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toCreatePlugin()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdatePlugin()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by IAM Identity Center Group ID
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toCreateAssignment()
     * - .toDeleteAssignment()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifIdentitystoreGroupId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by IAM Identity Center User ID
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toCreateAssignment()
     * - .toDeleteAssignment()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifIdentitystoreUserId(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [q](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonq.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
