import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [s3tables](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3tables.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class S3tables extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a namespace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_CreateNamespace.html
     */
    toCreateNamespace(): this;
    /**
     * Grants permission to create a table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifNamespace()
     * - .ifSSEAlgorithm()
     * - .ifKMSKeyArn()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_CreateTable.html
     */
    toCreateTable(): this;
    /**
     * Grants permission to create a table bucket
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifSSEAlgorithm()
     * - .ifKMSKeyArn()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_CreateTableBucket.html
     */
    toCreateTableBucket(): this;
    /**
     * Grants permission to delete a namespace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifNamespace()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_DeleteNamespace.html
     */
    toDeleteNamespace(): this;
    /**
     * Grants permission to delete a table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifNamespace()
     * - .ifTableName()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_DeleteTable.html
     */
    toDeleteTable(): this;
    /**
     * Grants permission to delete a table bucket
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_DeleteTableBucket.html
     */
    toDeleteTableBucket(): this;
    /**
     * Grants permission to delete encryption configuration on a table bucket
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_DeleteTableBucketEncryption.html
     */
    toDeleteTableBucketEncryption(): this;
    /**
     * Grants permission to delete a policy on a table bucket
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_DeleteTableBucketPolicy.html
     */
    toDeleteTableBucketPolicy(): this;
    /**
     * Grants permission to delete a policy on a table
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifNamespace()
     * - .ifTableName()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_DeleteTablePolicy.html
     */
    toDeleteTablePolicy(): this;
    /**
     * Grants permission to get a namespace
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifNamespace()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_GetNamespace.html
     */
    toGetNamespace(): this;
    /**
     * Grants permission to retrieve a table
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifNamespace()
     * - .ifTableName()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_GetTable.html
     */
    toGetTable(): this;
    /**
     * Grants permission to retrieve a table bucket
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_GetTableBucket.html
     */
    toGetTableBucket(): this;
    /**
     * Grants permission to retrieve encryption configuration on a table bucket
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_GetTableBucketEncryption.html
     */
    toGetTableBucketEncryption(): this;
    /**
     * Grants permission to retrieve a maintenance configuration on a table bucket
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_GetTableBucketMaintenanceConfiguration.html
     */
    toGetTableBucketMaintenanceConfiguration(): this;
    /**
     * Grants permission to retrieve a policy on a table bucket
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_GetTableBucketPolicy.html
     */
    toGetTableBucketPolicy(): this;
    /**
     * Grants permission to read metadata and data objects from a table storage endpoint using S3 APIs
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifNamespace()
     * - .ifTableName()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-setting-up.html#s3-tables-actions
     */
    toGetTableData(): this;
    /**
     * Grants permission to retrieve encryption configuration on a table
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifNamespace()
     * - .ifTableName()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_GetTableEncryption.html
     */
    toGetTableEncryption(): this;
    /**
     * Grants permission to retrieve a maintenance configuration on a table
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifNamespace()
     * - .ifTableName()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_GetTableMaintenanceConfiguration.html
     */
    toGetTableMaintenanceConfiguration(): this;
    /**
     * Grants permission to retrieve the status of maintenance jobs on a table
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifNamespace()
     * - .ifTableName()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_GetTableMaintenanceJobStatus.html
     */
    toGetTableMaintenanceJobStatus(): this;
    /**
     * Grants permission to retrieve the metadata location of a table
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifNamespace()
     * - .ifTableName()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_GetTableMetadataLocation.html
     */
    toGetTableMetadataLocation(): this;
    /**
     * Grants permission to retrieve a policy on a table
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifNamespace()
     * - .ifTableName()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_GetTablePolicy.html
     */
    toGetTablePolicy(): this;
    /**
     * Grants permission to list namespaces
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_ListNamespaces.html
     */
    toListNamespaces(): this;
    /**
     * Grants permission to list table buckets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_ListTableBuckets.html
     */
    toListTableBuckets(): this;
    /**
     * Grants permission to list tables
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifNamespace()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_ListTables.html
     */
    toListTables(): this;
    /**
     * Grants permission to put or overwrite encryption configuration on a table bucket
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifKMSKeyArn()
     * - .ifSSEAlgorithm()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_PutTableBucketEncryption.html
     */
    toPutTableBucketEncryption(): this;
    /**
     * Grants permission to put a maintenance configuration on a table bucket
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_PutTableBucketMaintenanceConfiguration.html
     */
    toPutTableBucketMaintenanceConfiguration(): this;
    /**
     * Grants permission to create or overwrite a policy on a table bucket
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_PutTableBucketPolicy.html
     */
    toPutTableBucketPolicy(): this;
    /**
     * Grants permission to write metadata and data objects to a table storage endpoint using S3 APIs
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifNamespace()
     * - .ifTableName()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-setting-up.html#s3-tables-actions
     */
    toPutTableData(): this;
    /**
     * Grants permission to put encryption configuration on a table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifNamespace()
     * - .ifSSEAlgorithm()
     * - .ifKMSKeyArn()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-setting-up.html#s3-tables-actions
     */
    toPutTableEncryption(): this;
    /**
     * Grants permission to put a maintenance configuration on a table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifNamespace()
     * - .ifTableName()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_PutTableMaintenanceConfiguration.html
     */
    toPutTableMaintenanceConfiguration(): this;
    /**
     * Grants permission to create or overwrite a policy on a table
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifNamespace()
     * - .ifTableName()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_PutTablePolicy.html
     */
    toPutTablePolicy(): this;
    /**
     * Grants permission to rename a table or move a table across namespaces
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifNamespace()
     * - .ifTableName()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_RenameTable.html
     */
    toRenameTable(): this;
    /**
     * Grants permission to update the metadata location of a table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifNamespace()
     * - .ifTableName()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3TableBuckets_UpdateTableMetadataLocation.html
     */
    toUpdateTableMetadataLocation(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type TableBucket to the statement
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-buckets.html
     *
     * @param tableBucketName - Identifier for the tableBucketName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTableBucket(tableBucketName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Table to the statement
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-tables.html
     *
     * @param tableBucketName - Identifier for the tableBucketName.
     * @param tableID - Identifier for the tableID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifNamespace()
     * - .ifTableName()
     */
    onTable(tableBucketName: string, tableID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the AWS KMS key ARN for the key used to encrypt a table
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-setting-up.htmls3-tables-setting-up.html
     *
     * Applies to actions:
     * - .toCreateTable()
     * - .toCreateTableBucket()
     * - .toPutTableBucketEncryption()
     * - .toPutTableEncryption()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifKMSKeyArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the server-side encryption algorithm used to encrypt a table
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-setting-up.htmls3-tables-setting-up.html
     *
     * Applies to actions:
     * - .toCreateTable()
     * - .toCreateTableBucket()
     * - .toPutTableBucketEncryption()
     * - .toPutTableEncryption()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSSEAlgorithm(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the namespaces created in the table bucket
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-setting-up.htmls3-tables-setting-up.html
     *
     * Applies to actions:
     * - .toCreateTable()
     * - .toDeleteNamespace()
     * - .toDeleteTable()
     * - .toDeleteTablePolicy()
     * - .toGetNamespace()
     * - .toGetTable()
     * - .toGetTableData()
     * - .toGetTableEncryption()
     * - .toGetTableMaintenanceConfiguration()
     * - .toGetTableMaintenanceJobStatus()
     * - .toGetTableMetadataLocation()
     * - .toGetTablePolicy()
     * - .toListTables()
     * - .toPutTableData()
     * - .toPutTableEncryption()
     * - .toPutTableMaintenanceConfiguration()
     * - .toPutTablePolicy()
     * - .toRenameTable()
     * - .toUpdateTableMetadataLocation()
     *
     * Applies to resource types:
     * - Table
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifNamespace(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the name of the tables in the table bucket
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-setting-up.htmls3-tables-setting-up.html
     *
     * Applies to actions:
     * - .toDeleteTable()
     * - .toDeleteTablePolicy()
     * - .toGetTable()
     * - .toGetTableData()
     * - .toGetTableEncryption()
     * - .toGetTableMaintenanceConfiguration()
     * - .toGetTableMaintenanceJobStatus()
     * - .toGetTableMetadataLocation()
     * - .toGetTablePolicy()
     * - .toPutTableData()
     * - .toPutTableMaintenanceConfiguration()
     * - .toPutTablePolicy()
     * - .toRenameTable()
     * - .toUpdateTableMetadataLocation()
     *
     * Applies to resource types:
     * - Table
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTableName(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [s3tables](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3tables.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
