import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [sagemaker-data-science-assistant](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemakerdatascienceassistant.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class SagemakerDataScienceAssistant extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to start a conversation with SageMaker data science assistant
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker-dsa/APIReference/
     */
    toSendConversation(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [sagemaker-data-science-assistant](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemakerdatascienceassistant.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
