import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [support-console](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportconsole.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class SupportConsole extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to check whether the account has access to given product
     *
     * Access Level: Read
     */
    toCheckSubscription(): this;
    /**
     * Grants permission to create or update case draft for the given case type
     *
     * Access Level: Write
     */
    toCreateCaseDraft(): this;
    /**
     * Grants permission to create an authenticated contact for the given contact type
     *
     * Access Level: Write
     */
    toCreateContact(): this;
    /**
     * Grants permission to delete a case draft for the given case type
     *
     * Access Level: Write
     */
    toDeleteCaseDraft(): this;
    /**
     * Grants permission to get dynamic help resources for given service and category
     *
     * Access Level: Read
     */
    toDescribeDynamicHelp(): this;
    /**
     * Grants permission to determines whether the calling account is GovCloud enabled
     *
     * Access Level: Read
     */
    toGetAccountGovCloudEnabled(): this;
    /**
     * Grants permission to get the state of the calling account
     *
     * Access Level: Read
     */
    toGetAccountState(): this;
    /**
     * Grants permission to get the support banner information
     *
     * Access Level: Read
     */
    toGetBanner(): this;
    /**
     * Grants permission to get a case draft for given case type
     *
     * Access Level: Read
     */
    toGetCaseDraft(): this;
    /**
     * Grants permission to get a feedback questionnaire
     *
     * Access Level: Read
     */
    toGetQuestionnaire(): this;
    /**
     * Grants permission to save questionnaire feedback
     *
     * Access Level: Write
     */
    toSaveFeedback(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [support-console](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportconsole.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
