import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [ssm-quicksetup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerquicksetup.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class SsmQuicksetup extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a Quick Setup configuration manager resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quick-setup/latest/APIReference/API_CreateConfigurationManager.html
     */
    toCreateConfigurationManager(): this;
    /**
     * Grants permission to delete a configuration manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quick-setup/latest/APIReference/API_DeleteConfigurationManager.html
     */
    toDeleteConfigurationManager(): this;
    /**
     * Grants permission to get Quick Setup configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quick-setup/latest/APIReference/API_GetConfiguration.html
     */
    toGetConfiguration(): this;
    /**
     * Grants permission to get a configuration manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quick-setup/latest/APIReference/API_GetConfigurationManager.html
     */
    toGetConfigurationManager(): this;
    /**
     * Grants permission to get settings configured for Quick Setup in the requesting AWS account and AWS Region
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quick-setup/latest/APIReference/API_GetServiceSettings.html
     */
    toGetServiceSettings(): this;
    /**
     * Grants permission to list Quick Setup configuration managers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quick-setup/latest/APIReference/API_ListConfigurationManagers.html
     */
    toListConfigurationManagers(): this;
    /**
     * Grants permission to list Quick Setup configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quick-setup/latest/APIReference/API_ListConfigurations.html
     */
    toListConfigurations(): this;
    /**
     * Grants permission to list the available Quick Setup types
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quick-setup/latest/APIReference/API_ListQuickSetupTypes.html
     */
    toListQuickSetupTypes(): this;
    /**
     * Grants permission to list tags assigned to the resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quick-setup/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to Assign key-value pairs of metadata to AWS resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/quick-setup/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quick-setup/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a Quick Setup configuration definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quick-setup/latest/APIReference/API_UpdateConfigurationDefinition.html
     */
    toUpdateConfigurationDefinition(): this;
    /**
     * Grants permission to update a Quick Setup configuration manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quick-setup/latest/APIReference/API_UpdateConfigurationManager.html
     */
    toUpdateConfigurationManager(): this;
    /**
     * Grants permission to update settings configured for Quick Setup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quick-setup/latest/APIReference/API_UpdateServiceSettings.html
     */
    toUpdateServiceSettings(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type configuration-manager to the statement
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-quick-setup.html
     *
     * @param configurationManagerId - Identifier for the configurationManagerId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConfigurationManager(configurationManagerId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateConfigurationManager()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toCreateConfigurationManager()
     *
     * Applies to resource types:
     * - configuration-manager
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateConfigurationManager()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [ssm-quicksetup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerquicksetup.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
