import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [verifiedpermissions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonverifiedpermissions.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Verifiedpermissions extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a reference to an external identity provider (IdP) that is compatible with OpenID Connect (OIDC) authentication protocol, such as Amazon Cognito
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html
     */
    toCreateIdentitySource(): this;
    /**
     * Grants permission to create a Cedar policy and save it in the specified policy store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html
     */
    toCreatePolicy(): this;
    /**
     * Grants permission to create a Cedar policy and save it in the specified policy store
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicyStore.html
     */
    toCreatePolicyStore(): this;
    /**
     * Grants permission to create a policy template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicyTemplate.html
     */
    toCreatePolicyTemplate(): this;
    /**
     * Grants permission to delete an identity source that references an identity provider (IdP) such as Amazon Cognito
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_DeleteIdentitySource.html
     */
    toDeleteIdentitySource(): this;
    /**
     * Grants permission to delete the specified policy from the policy store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_DeletePolicy.html
     */
    toDeletePolicy(): this;
    /**
     * Grants permission to delete the specified policy store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_DeletePolicyStore.html
     */
    toDeletePolicyStore(): this;
    /**
     * Grants permission to delete the specified policy template from the policy store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_DeletePolicyTemplate.html
     */
    toDeletePolicyTemplate(): this;
    /**
     * Grants permission to retrieve the details about the specified identity source
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html
     */
    toGetIdentitySource(): this;
    /**
     * Grants permission to retrieve information about the specified policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetPolicy.html
     */
    toGetPolicy(): this;
    /**
     * Grants permission to retrieve details about a policy store
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - verifiedpermissions:ListTagsForResource
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetPolicyStore.html
     */
    toGetPolicyStore(): this;
    /**
     * Grants permission to retrieve the details for the specified policy template in the specified policy store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetPolicyTemplate.html
     */
    toGetPolicyTemplate(): this;
    /**
     * Grants permission to retrieve the details for the specified schema in the specified policy store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetSchema.html
     */
    toGetSchema(): this;
    /**
     * Grants permission to make an authorization decision about a service request described in the parameters
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html
     */
    toIsAuthorized(): this;
    /**
     * Grants permission to make an authorization decision about a service request described in the parameters. The principal in this request comes from an external identity source
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html
     */
    toIsAuthorizedWithToken(): this;
    /**
     * Grants permission to return a paginated list of all of the identity sources defined in the specified policy store
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html
     */
    toListIdentitySources(): this;
    /**
     * Grants permission to return a paginated list of all policies stored in the specified policy store
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html
     */
    toListPolicies(): this;
    /**
     * Grants permission to return a paginated list of all policy stores in the calling Amazon Web Services account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicyStores.html
     */
    toListPolicyStores(): this;
    /**
     * Grants permission to return a paginated list of all policy templates in the specified policy store
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicyTemplates.html
     */
    toListPolicyTemplates(): this;
    /**
     * Grants permission to view a list of resource tags for the specified policy store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to create or update the policy schema in the specified policy store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PutSchema.html
     */
    toPutSchema(): this;
    /**
     * Grants permission to add tags to the specified policy store
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from the specified policy store
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the specified identity source to use a new identity provider (IdP) source, or to change the mapping of identities from the IdP to a different principal entity type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateIdentitySource.html
     */
    toUpdateIdentitySource(): this;
    /**
     * Grants permission to modify the specified Cedar static policy in the specified policy store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicy.html
     */
    toUpdatePolicy(): this;
    /**
     * Grants permission to modify the validation setting for a policy store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore.html
     */
    toUpdatePolicyStore(): this;
    /**
     * Grants permission to update the specified policy template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyTemplate.html
     */
    toUpdatePolicyTemplate(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type policy-store to the statement
     *
     * https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/policy-stores.html
     *
     * @param policyStoreId - Identifier for the policyStoreId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPolicyStore(policyStoreId: string, account?: string, partition?: string): this;
    /**
     * Filters access by a tag key and value pair that is allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreatePolicyStore()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a tag key and value pair of a resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toCreatePolicyStore()
     *
     * Applies to resource types:
     * - policy-store
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a list of tag keys that are allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreatePolicyStore()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [verifiedpermissions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonverifiedpermissions.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
