"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Workmailmessageflow = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [workmailmessageflow](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkmailmessageflow.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Workmailmessageflow extends shared_1.PolicyStatement {
    /**
     * Grants permission to read the content of email messages with the specified message ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_messageflow_GetRawMessageContent.html
     */
    toGetRawMessageContent() {
        return this.to('GetRawMessageContent');
    }
    /**
     * Grants permission to update the content of email messages with the specified message ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_messageflow_PutRawMessageContent.html
     */
    toPutRawMessageContent() {
        return this.to('PutRawMessageContent');
    }
    /**
     * Adds a resource of type RawMessage to the statement
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/lambda-content.html
     *
     * @param organizationId - Identifier for the organizationId.
     * @param context - Identifier for the context.
     * @param messageId - Identifier for the messageId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onRawMessage(organizationId, context, messageId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:workmailmessageflow:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:message/${organizationId}/${context}/${messageId}`);
    }
    /**
     * Statement provider for service [workmailmessageflow](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkmailmessageflow.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'workmailmessageflow';
        this.accessLevelList = {
            Read: [
                'GetRawMessageContent'
            ],
            Write: [
                'PutRawMessageContent'
            ]
        };
    }
}
exports.Workmailmessageflow = Workmailmessageflow;
//# sourceMappingURL=data:application/json;base64,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