"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessLevel = void 0;
/**
 * Access level classifications for the actions in a service
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_understand-policy-summary-access-level-summaries.html#access_policies_access-level
 */
var AccessLevel;
(function (AccessLevel) {
    /**
     * Permission to list resources within the service to determine whether an object exists.
     *
     * Actions with this level of access can list objects but cannot see the contents of a resource.
     *
     * For example, the Amazon S3 action `ListBucket` has the List access level.
     */
    AccessLevel["list"] = "List";
    /**
     * Permission to read but not edit the contents and attributes of resources in the service.
     *
     * For example, the Amazon S3 actions `GetObject` and `GetBucketLocation` have the Read access level.
     */
    AccessLevel["read"] = "Read";
    /**
     * Permission to create, delete, or modify resources in the service.
     *
     * For example, the Amazon S3 actions `CreateBucket`, `DeleteBucket` and `PutObject` have the Write access level.
     *
     * Write actions might also allow modifying a resource tag. However, an action that allows only changes to tags has the Tagging access level.
     */
    AccessLevel["write"] = "Write";
    /**
     * Permission to grant or modify resource permissions in the service.
     *
     * For example, most IAM and AWS Organizations actions, as well as actions like the Amazon S3 actions `PutBucketPolicy` and `DeleteBucketPolicy` have the Permissions management access level.
     */
    AccessLevel["permissionsManagement"] = "Permissions management";
    /**
     * Permission to perform actions that only change the state of resource tags.
     *
     * For example, the IAM actions `TagRole` and `UntagRole` have the Tagging access level because they allow only tagging or untagging a role. However, the `CreateRole` action allows tagging a role resource when you create that role. Because the action does not only add a tag, it has the Write access level.
     */
    AccessLevel["tagging"] = "Tagging";
})(AccessLevel || (exports.AccessLevel = AccessLevel = {}));
//# sourceMappingURL=data:application/json;base64,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