"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithArnDefaults = void 0;
const _5_effect_1 = require("./5-effect");
/**
 * Adds "arn defaults" functionality to the Policy Statement
 */
class PolicyStatementWithArnDefaults extends _5_effect_1.PolicyStatementWithEffect {
    constructor() {
        super(...arguments);
        /**
         * The default partition for ARNs (such as one of [`aws`, `aws-us-gov`,
         * `aws-cn`]). Defaults to `aws`.
         */
        this.defaultPartition = 'aws';
        /**
         * The default region for ARNs (such as `us-east-1`, `eu-central-1`,
         * `ap-east-1`, ...). Defaults to `*`.
         */
        this.defaultRegion = '*';
        /**
         * The default account for ARNs. Defaults to `*`.
         */
        this.defaultAccount = '*';
    }
    /**
     * Sets the default partition, region and account for ARNs of this statement
     *
     * @param partition Default partition for ARNs, e.g. `aws`, `aws-us-gov`, `aws-cn`
     * @param region Default region for ARNs, e.g. `us-east-1`, `eu-central-1`, `ap-east-1`
     * @param account Default account ID for ARN, e.g. `123456789012`
     */
    in(account, region, partition) {
        if (account)
            this.defaultAccount = account;
        if (region)
            this.defaultRegion = region;
        if (partition)
            this.defaultPartition = partition;
        return this;
    }
    /**
     * Sets the default partition for ARNs of this statement
     * @param partition Default partition for ARNs, e.g. `aws`, `aws-us-gov`, `aws-cn`
     * @returns this
     */
    inPartition(partition) {
        this.defaultPartition = partition;
        return this;
    }
    /**
     * Sets the default region for ARNs of this statement
     * @param region Default region for ARNs, e.g. `us-east-1`, `eu-central-1`, `ap-east-1`
     * @returns this
     */
    inRegion(region) {
        this.defaultRegion = region;
        return this;
    }
    /**
     * Sets the default account for ARNs of this statement
     * @param account Default account ID for ARN, e.g. `123456789012`
     * @returns this
     */
    inAccount(account) {
        this.defaultAccount = account;
        return this;
    }
}
exports.PolicyStatementWithArnDefaults = PolicyStatementWithArnDefaults;
//# sourceMappingURL=data:application/json;base64,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