"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithArnDefaultsForCdk = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const _6_arn_defaults_1 = require("./6-arn-defaults");
/**
 * Adds "arn defaults" functionality to the Policy Statement
 */
class PolicyStatementWithArnDefaultsForCdk extends _6_arn_defaults_1.PolicyStatementWithArnDefaults {
    constructor() {
        super(...arguments);
        /**
         * The default partition for ARNs (such as one of [`aws`, `aws-us-gov`,
         * `aws-cn`]). This is a reference to the partition of the stack.
         */
        this.defaultPartition = aws_cdk_lib_1.Aws.PARTITION;
        /**
         * The default region for ARNs (such as `us-east-1`, `eu-central-1`,
         * `ap-east-1`, ...). This is a reference to the region of the stack.
         */
        this.defaultRegion = aws_cdk_lib_1.Aws.REGION;
        /**
         * The default region for ARNs (such as `us-east-1`, `eu-central-1`,
         * `ap-east-1`, ...). This is a reference to the current account of the stack.
         */
        this.defaultAccount = aws_cdk_lib_1.Aws.ACCOUNT_ID;
    }
}
exports.PolicyStatementWithArnDefaultsForCdk = PolicyStatementWithArnDefaultsForCdk;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNy1hcm4tZGVmYXVsdHMtQ0RLLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiNy1hcm4tZGVmYXVsdHMtQ0RLLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDZDQUFrQztBQUVsQyxzREFBa0U7QUFFbEU7O0dBRUc7QUFDSCxNQUFhLG9DQUFxQyxTQUFRLGdEQUE4QjtJQUF4Rjs7UUFDRTs7O1dBR0c7UUFDTyxxQkFBZ0IsR0FBRyxpQkFBRyxDQUFDLFNBQVMsQ0FBQztRQUUzQzs7O1dBR0c7UUFDTyxrQkFBYSxHQUFHLGlCQUFHLENBQUMsTUFBTSxDQUFDO1FBRXJDOzs7V0FHRztRQUNPLG1CQUFjLEdBQUcsaUJBQUcsQ0FBQyxVQUFVLENBQUM7SUFDNUMsQ0FBQztDQUFBO0FBbEJELG9GQWtCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEF3cyB9IGZyb20gJ2F3cy1jZGstbGliJztcblxuaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50V2l0aEFybkRlZmF1bHRzIH0gZnJvbSAnLi82LWFybi1kZWZhdWx0cyc7XG5cbi8qKlxuICogQWRkcyBcImFybiBkZWZhdWx0c1wiIGZ1bmN0aW9uYWxpdHkgdG8gdGhlIFBvbGljeSBTdGF0ZW1lbnRcbiAqL1xuZXhwb3J0IGNsYXNzIFBvbGljeVN0YXRlbWVudFdpdGhBcm5EZWZhdWx0c0ZvckNkayBleHRlbmRzIFBvbGljeVN0YXRlbWVudFdpdGhBcm5EZWZhdWx0cyB7XG4gIC8qKlxuICAgKiBUaGUgZGVmYXVsdCBwYXJ0aXRpb24gZm9yIEFSTnMgKHN1Y2ggYXMgb25lIG9mIFtgYXdzYCwgYGF3cy11cy1nb3ZgLFxuICAgKiBgYXdzLWNuYF0pLiBUaGlzIGlzIGEgcmVmZXJlbmNlIHRvIHRoZSBwYXJ0aXRpb24gb2YgdGhlIHN0YWNrLlxuICAgKi9cbiAgcHJvdGVjdGVkIGRlZmF1bHRQYXJ0aXRpb24gPSBBd3MuUEFSVElUSU9OO1xuXG4gIC8qKlxuICAgKiBUaGUgZGVmYXVsdCByZWdpb24gZm9yIEFSTnMgKHN1Y2ggYXMgYHVzLWVhc3QtMWAsIGBldS1jZW50cmFsLTFgLFxuICAgKiBgYXAtZWFzdC0xYCwgLi4uKS4gVGhpcyBpcyBhIHJlZmVyZW5jZSB0byB0aGUgcmVnaW9uIG9mIHRoZSBzdGFjay5cbiAgICovXG4gIHByb3RlY3RlZCBkZWZhdWx0UmVnaW9uID0gQXdzLlJFR0lPTjtcblxuICAvKipcbiAgICogVGhlIGRlZmF1bHQgcmVnaW9uIGZvciBBUk5zIChzdWNoIGFzIGB1cy1lYXN0LTFgLCBgZXUtY2VudHJhbC0xYCxcbiAgICogYGFwLWVhc3QtMWAsIC4uLikuIFRoaXMgaXMgYSByZWZlcmVuY2UgdG8gdGhlIGN1cnJlbnQgYWNjb3VudCBvZiB0aGUgc3RhY2suXG4gICAqL1xuICBwcm90ZWN0ZWQgZGVmYXVsdEFjY291bnQgPSBBd3MuQUNDT1VOVF9JRDtcbn1cbiJdfQ==