import { aws_iam as iam } from 'aws-cdk-lib';
import { PolicyStatementWithPrincipal } from './8-principals';
/**
 * Adds CDK specific "principal" functionality to the Policy Statement
 */
export declare class PolicyStatementWithCDKPrincipal extends PolicyStatementWithPrincipal {
    protected cdkPrincipals: iam.IPrincipal[];
    private cdkPrincipalsApplied;
    /**
     * Adds any number of CDK principals to the statement
     * @param principals Principals to add to the statement
     */
    forCdkPrincipal(...principals: iam.IPrincipal[]): this;
    protected cdkApplyPrincipals(): void;
}
