"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithCDKPrincipal = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const _8_principals_1 = require("./8-principals");
/**
 * Adds CDK specific "principal" functionality to the Policy Statement
 */
class PolicyStatementWithCDKPrincipal extends _8_principals_1.PolicyStatementWithPrincipal {
    constructor() {
        super(...arguments);
        this.cdkPrincipals = [];
        this.cdkPrincipalsApplied = false;
    }
    /**
     * Adds any number of CDK principals to the statement
     * @param principals Principals to add to the statement
     */
    forCdkPrincipal(...principals) {
        this.skipAutoResource = true;
        this.cdkPrincipals.push(...principals);
        return this;
    }
    cdkApplyPrincipals() {
        if (!this.cdkPrincipalsApplied) {
            const mode = this.useNotPrincipal ? 'addNotPrincipals' : 'addPrincipals';
            // @ts-ignore only available after swapping 1-base
            this[mode](...this.cdkPrincipals);
            if (this.hasPrincipals()) {
                Object.keys(this.myPrincipals).forEach((prefix) => {
                    switch (prefix) {
                        case _8_principals_1.PrincipalType.aws:
                            this.myPrincipals[prefix]?.forEach((arn) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new aws_cdk_lib_1.aws_iam.ArnPrincipal(arn));
                            });
                            break;
                        case _8_principals_1.PrincipalType.canonicalUser:
                            this.myPrincipals[prefix]?.forEach((userId) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new aws_cdk_lib_1.aws_iam.CanonicalUserPrincipal(userId));
                            });
                            break;
                        case _8_principals_1.PrincipalType.federated:
                            this.myPrincipals[prefix]?.forEach((provider) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new aws_cdk_lib_1.aws_iam.FederatedPrincipal(provider, {}));
                            });
                            break;
                        case _8_principals_1.PrincipalType.service:
                            this.myPrincipals[prefix]?.forEach((service) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new aws_cdk_lib_1.aws_iam.ServicePrincipal(service));
                            });
                            break;
                        default:
                            throw Error(`Unhandled principal type: ${prefix}`);
                    }
                });
            }
            this.cdkPrincipalsApplied = true;
        }
    }
}
exports.PolicyStatementWithCDKPrincipal = PolicyStatementWithCDKPrincipal;
//# sourceMappingURL=data:application/json;base64,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