# -*- coding: latin-1 -*-
# J1939 data decodes (modified from TURP1210)

J1939BitDecodings = {
        1081: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        1082: {
            0: "no coolant load increase",
            1: "coolant load increase possible",
            2: "error",
            3: "not available"
        },
        1107: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        1108: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        1109: {
            0: "not approaching",
            1: "approaching",
            2: "error",
            3: "not available"
        },
        1110: {
            0: "no",
            1: "yes",
            2: "error",
            3: "not available"
        },
        1111: {
            0: "disabled in calibration",
            1: "enabled in calibration",
            2: "error",
            3: "not available"
        },
        1121: {
            0: "brake pedal is not being pressed",
            1: "brake pedal is being pressed",
            2: "error",
            3: "not available"
        },
        1194: {
            0: "random number is not present",
            1: "random number is present",
            2: "error",
            3: "not available"
        },
        1195: {
            0: "password is not a validated password",
            1: "password is a validated password",
            2: "error",
            3: "not available"
        },
        1196: {
            0: "b -  unlocked = this state indicates that the component can be started without the end user being required to enter a password.",
            1: "b - locked = this state indicates that the component can not be started (i.e., unlocked) without the end user being required to enter a password.",
            2: "b - blocked = this state indicates that a lock or unlock command cannot be executed because some other algorithm or command of higher priority is commanding differently.",
            3: " not defined"
        },
        1197: {
            0: "b - ok = this state indicates that the request was successfully performed.",
            1: "b - full_of_passwords = this state indicates that the component can not store any additional passwords in its memory.",
            2: "b - empty_of_passwords = this state indicates that the component would be empty of passwords (an unacceptable condition) if the password under which the end user is logged in, is deleted.  thus the delete password command is not successfully executed.",
            3: "b -  not_valid = this state indicates that the request is not a valid one."
        },
        1199: {
            0: "b - encryption_seed_request = this state represents a request to the component to provide a random number seed.",
            1: "b - encrypted_code_present = this state is used to indicate that an encrypted password is being provided to the component.",
            2: " not defined",
            3: "b - not_available = this state is used to indicate that a random number is not being requested nor is an encrypted password being provided to the component."
        },
        1200: {
            0: "b -   lock_upon_operator_request-this state is used to indicate that the end user would have to manually enter a password to lock the engine.",
            1: "b -  lock_when_keyoff-this state is used to indicate that the component would automatically transition to the locked state when the end user turns off the engine (i.e. without the end user being required to manually enter the password).",
            2: " not defined",
            3: "b - not_available-this state is indicates that the option is not selectable or changeable by the operator via using current tool."
        },
        1201: {
            0: "b - add_password-this state represents a request to the component to add a password to the list of passwords that the component has stored as valid codes.  this command will not be performed if the component has already stored, the maximum number of passwords that it is capable of storing.  the login command must precede this command.",
            1: "b - delete_password-this state represents a request to the component to delete the password (the same one used when the end-user logged in).  see spn 1197 for limitations.",
            2: "b - change_password-this state represents a request to the component to change the password (the same one that the end-user logged in with) to a different password, which is to be specified by the end user.  the login command must precede this command.",
            3: "b - lock_or_unlock-this state represents a request to the component to change from the locked state to the unlocked state or from the unlocked state to the locked state.",
            4: "b - check_status-this state represents a request to check to see if the component is in the locked or unlocked state.",
            5: "b -  login-this state represents a request to validate the end user, before performing commands such as add_password and change_password.",
            6: " not defined",
            7: " not defined"
        },
        1205: {
            0: "safety wire has not been activated",
            1: "safety wire has been activated",
            2: "error",
            3: "not available"
        },
        1206: {
            0: "not engaged",
            1: "engaged",
            2: "error",
            3: "not available"
        },
        1211: {
            0: " do not reset",
            1: " reset",
            2: " reserved",
            3: " take no action"
        },
        1213: {
            0: "lamp off",
            1: "lamp on",
            2: "short mil for wwh obd",
            3: "not available"
        },
        1230: {
            0: " stop broadcast",
            1: " start broadcast",
            2: " reserved",
            3: " don-t care/take no action (leave as is)"
        },
        1231: {
            0: " stop broadcast",
            1: " start broadcast",
            2: " reserved",
            3: " don-t care/take no action (leave as is)"
        },
        1232: {
            0: " stop broadcast",
            1: " start broadcast",
            2: " reserved",
            3: " don-t care/take no action (leave as is)"
        },
        1233: {
            0: " stop broadcast",
            1: " start broadcast",
            2: " reserved",
            3: " don-t care/take no action (leave as is)"
        },
        1234: {
            0: " stop broadcast",
            1: " start broadcast",
            2: " reserved",
            3: " don-t care/take no action (leave as is)"
        },
        1235: {
            0: " stop broadcast",
            1: " start broadcast",
            2: " reserved",
            3: " don-t care/take no action (leave as is)"
        },
        1236: {
            0: "  all devices",
            1: "  devices whose broadcast state has been modified",
            15: " not avai l abl e",
            2: " to 1110 reserved"
        },
        1237: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        1238: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available or not installed"
        },
        1239: {
            0: "no leakage detected",
            1: "leakage detected",
            2: "error",
            3: "not available"
        },
        1240: {
            0: "no leakage detected",
            1: "leakage detected",
            2: "error",
            3: "not available"
        },
        1243: {
            0: "not fully operational",
            1: "fully operational",
            2: "reserved",
            3: "not available"
        },
        1254: {
            0: "disabled",
            1: "enabled",
            2: "error",
            3: "not available"
        },
        1351: {
            0: "     compressor not active",
            1: "     compressor active",
            2: "     error indicator",
            3: "     not available"
        },
        1377: {
            0: " functionality is disabled (off)",
            1: " functionality is enabled (on)",
            2: " error",
            3: " not available or unused"
        },
        1437: {
            0: "active",
            1: "not active",
            2: "error",
            3: "not available"
        },
        1438: {
            0: " off",
            1: " on",
            2: " reserved",
            3: " take no action"
        },
        1439: {
            0: " off",
            1: " on",
            2: " reserved",
            3: " take no action"
        },
        1466: {
            0: " maintain",
            1: " inflate",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " error condition",
            15: " not available",
            2: " deflate",
            3: " confirm",
            4: " inflate wait - system will inflate when conditions allow",
            5: " deflate wait - system will deflate when conditions allow",
            6: " pressure check",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1467: {
            0: " maintain",
            1: " inflate",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " error condition",
            15: " not available",
            2: " deflate",
            3: " confirm",
            4: " inflate wait - system will inflate when conditions allow",
            5: " deflate wait - system will deflate when conditions allow",
            6: " pressure check",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1468: {
            0: " maintain",
            1: " inflate",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " error condition",
            15: " not available",
            2: " deflate",
            3: " confirm",
            4: " inflate wait - system will inflate when conditions allow",
            5: " deflate wait - system will deflate when conditions allow",
            6: " pressure check",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1469: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        1470: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        1471: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        1472: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        1473: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        1474: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        1475: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        1497: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available or not installed"
        },
        1498: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available or not installed"
        },
        1499: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available or not installed"
        },
        1503: {
            0: "off",
            1: "on",
            2: "reserved",
            3: "don't care/take no action"
        },
        1519: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available or not installed"
        },
        1520: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available or not installed"
        },
        1521: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available or not installed"
        },
        1522: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available or not installed"
        },
        1523: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available or not installed"
        },
        1524: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available or not installed"
        },
        1525: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available or not installed"
        },
        1526: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available or not installed"
        },
        1527: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available or not installed"
        },
        1528: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available or not installed"
        },
        1529: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available or not installed"
        },
        1530: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available or not installed"
        },
        1531: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available or not installed"
        },
        1532: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available or not installed"
        },
        1557: {
            0: " fan off",
            1: " engine system-general",
            10: " transmission retarder",
            11: " a/c system",
            12: " timer",
            13: " engine brake",
            14: " other",
            15: " not available",
            2: " excessive engine air temperature",
            3: " excessive engine oil temperature",
            4: " excessive engine coolant temperature",
            5: " excessive transmission oil temperature",
            6: " excessive hydraulic oil temperature",
            7: " default operation",
            8: " reverse operation",
            9: " manual control"
        },
        1573: {
            128: " low coarse",
            129: " low medium/coarse",
            130: " low medium",
            131: " low medium/fine",
            132: " low fine",
            144: " on grade",
            145: " high fine",
            146: " high medium/fine",
            147: " high medium",
            148: " high medium/coarse",
            149: " high coarse",
            159: " no data (i.e. no laser strikes)",
            16: " low fine led on",
            2: " high coarse led on",
            254: " error",
            255: " not available",
            32: " low coarse led on",
            4: " high fine led on",
            8: " on-grade led on"
        },
        1578: {
            0: " manual mode",
            1: " automatic mode",
            2: " inactive automatic mode"
        },
        1582: {
            1: " on-grade -a- led on",
            128: " low coarse",
            129: " low medium/coarse",
            130: " low medium",
            131: " low medium/fine",
            132: " low fine",
            144: " on grade",
            145: " high fine",
            146: " high medium/fine",
            147: " high medium",
            148: " high medium/coarse",
            149: " high coarse",
            159: " no data (i.e. no laser strikes)",
            16: " down led on",
            2: " on-grade -b- led on",
            254: " error",
            255: " not available",
            32: " left led on",
            4: " on-grade -c- led on",
            64: " right led on",
            8: " up led on"
        },
        1583: {
            1: " laser power is on",
            16: " stringline (1 = yes)",
            2: " laser is ready",
            32: " curb (1 = yes)",
            4: " valid target (1 = yes)",
            8: " previous pass (1 = yes)"
        },
        1589: {
            0: " acc distance mode #1 (largest distance)",
            1: " acc distance mode #2",
            2: " acc distance mode #3",
            3: " acc distance mode #4",
            4: " acc distance mode #5 (shortest distance)",
            5: " conventional cruise control mode",
            6: " error condition",
            7: " not available/not valid"
        },
        1590: {
            0: "b - off-used to indicate the acc is enabled in calibration or configuration and there are no faults that would prevent the system from operating.",
            1: "b - speed control active-used to indicate that acc is on but not currently sending control messages.  in other words, there is no target ahead and regular vehicle cruise control is controlling the vehicle speed to the driver-s set speed.",
            2: "b - distance control active-used to indicate that acc is on and actively sending control messages to maintain the appropriate following interval.",
            3: "b - overtake mode-used to indicate that acc is on but temporarily disabled because the driver is manually overriding cruise control by using either the accelerator pedal or the cruise control -accel- switch.",
            4: "b - hold mode-used to indicate that the acc has lost the previous target vehicle and is in hold mode. in this mode, the acc shall limit the speed to the speed held when the target was lost. for example,  if the driver activates the typical cruise buttons (resume/inc/dec) the hold mode shall be exited and normal cruise functionality resumed. if a new target is detected, the distance control active mode (010b) is again entered, unless existing conditions prohibit this.",
            5: "b - finish mode-used to indicate that acc is on with no target ahead, and acc is currently sending control messages to return to the driver-s set speed. this occurs when the target the acc system was tracking moves out of the way so acc returns the vehicle to the driver-s set speed.",
            6: "b - disabled or error condition-used to indicate that acc is in an error state and can not operate.",
            7: " not available/not valid"
        },
        1611: {
            0: " vehicle motion not detected",
            1: " vehicle motion detected",
            2: "error",
            3: "not available"
        },
        1612: {
            0: " rest - sleeping",
            1: " driver available - short break",
            2: " work - loading, unloading, working in an office",
            3: " drive - behind wheel ",
            4: " reserved",
            5: " reserved",
            6: " error",
            7: " not available"
        },
        1613: {
            0: " rest - sleeping",
            1: " driver available - short break",
            2: " work - loading, unloading, working in an office",
            3: " drive - behind wheel ",
            4: " reserved",
            5: " reserved",
            6: " error",
            7: " not available"
        },
        1614: {
            0: " no overspeed",
            1: " overspeed",
            2: " error",
            3: " not available"
        },
        1615: {
            0: "driver card not present",
            1: "driver card present",
            2: "error",
            3: "not available"
        },
        1616: {
            0: "driver card not present",
            1: "driver card present",
            2: "error",
            3: "not available"
        },
        1617: {
            0: " normal/no limits reached",
            1: " limit #1 - 15 min before 4 - h",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " other",
            14: " error",
            15: " not available",
            2: " limit #2 - 4 - h reached",
            3: " limit #3 - 15 min before 9 h",
            4: " limit #4 - 9 h reached",
            5: " limit #5 - 15 min before 16 h (not having 8h rest during the last 24h)",
            6: " limit #6 - 16 h reached",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1618: {
            0: " normal/no limits reached",
            1: " limit #1 - 15 min before 4 - h",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " other",
            14: " error",
            15: " not available",
            2: " limit #2 - 4 - h reached",
            3: " limit #3 - 15 min before 9 h",
            4: " limit #4 - 9 h reached",
            5: " limit #5 - 15 min before 16 h (not having 8h rest during the last 24h)",
            6: " limit #6 - 16 h reached",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1619: {
            0: "forward",
            1: "reverse",
            2: "error",
            3: "not available"
        },
        1620: {
            0: "normal performance",
            1: "performance analysis",
            2: "error",
            3: "not available"
        },
        1621: {
            0: "no handling information",
            1: "handling information",
            2: "error",
            3: "not available"
        },
        1622: {
            0: "no tachograph event",
            1: "tachograph event",
            2: "error",
            3: "not available"
        },
        1632: {
            0: " reserved",
            1: " highest torque rating",
            2: " first torque rating",
            3: " previous torque rating (rating prior to the current rating)",
            4: " current torque rating",
            5: " reserved",
            6: " reserved",
            7: " not available"
        },
        1633: {
            0: "off",
            1: "on",
            2: "error indicator",
            3: "take no action"
        },
        1641: {
            0: "   direct memory addressing",
            1: "   direct spatial addressing"
        },
        1653: {
            0: "switch disabled",
            1: "switched enabled",
            2: "error",
            3: "not available"
        },
        1654: {
            0: "switch in the off state",
            1: "switch in the on state - increase",
            2: "error",
            3: "not available"
        },
        1655: {
            0: "switch in the off state",
            1: "switch in the on state - decrease",
            2: "error",
            3: "not available"
        },
        1656: {
            0: "switch in the off state",
            1: "switch in the on state",
            2: "error",
            3: "not available"
        },
        1665: {
            0: "no oil present at turbocharger",
            1: "oil present at turbocharger",
            2: "error",
            3: "not available"
        },
        1666: {
            0: "automated gear shifting is disabled",
            1: "automated gear shifting is enabled",
            2: "error",
            3: "not available"
        },
        1667: {
            0: "retarder is not requesting that the brake lights are illuminated",
            1: "retarder is requesting that the brake lights are illuminated",
            2: "reserved",
            3: "not available/take no action"
        },
        1675: {
            0: "start not requested",
            1: "starter active, gear not engaged",
            10: "starter inhibited due to active scr inducement",
            11: "reserved",
            12: "starter inhibited - reason unknown",
            13: "error (legacy implementation only, use 1110)",
            14: "error",
            15: "not available",
            2: "starter active, gear engaged",
            3: "start finished; starter not active after having been actively engaged (after 50ms mode goes to 0000)",
            4: "starter inhibited due to engine already running",
            5: "starter inhibited due to engine not ready for start (preheating)",
            6: "starter inhibited due to driveline engaged or other transmission inhibit",
            7: "starter inhibited due to active immobilizer",
            8: "starter inhibited due to starter over-temp",
            9: "starter inhibited due to intake air shutoff valve being active"
        },
        1676: {
            0: " water pump is not running",
            1: " water pump is  running",
            2: " reserved",
            3: " not available"
        },
        1677: {
            0: " heater not active",
            1: " off due to adr per european regulations for transport of hazardous materials",
            10: " not defined",
            11: " not defined",
            12: " not defined",
            13: " not defined",
            14: " error",
            15: " not available",
            2: " economy mode",
            3: " normal mode",
            4: " not defined",
            5: " not defined",
            6: " not defined",
            7: " not defined",
            8: " not defined",
            9: " not defined"
        },
        1678: {
            0: " cab not ventilated",
            1: " cab is ventilated",
            2: " reserved",
            3: " not available"
        },
        1679: {
            0: " engine heating zone off",
            1: " engine heating zone on",
            2: " reserved",
            3: " not available"
        },
        1680: {
            0: " cab heating zone off",
            1: " cab heating zone on",
            2: " reserved",
            3: " not available"
        },
        1681: {
            0: " battery main switch not held",
            1: " battery main switch held",
            2: " reserved",
            3: " don't care/take no action"
        },
        1682: {
            0: " release battery main switch",
            1: " hold battery main switch",
            2: " undefined",
            3: " don't care/take no action"
        },
        1683: {
            0: " de-activate auxiliary heater",
            1: " off due to adr per european regulations for transport of hazardous materials",
            10: " not defined",
            11: " not defined",
            12: " not defined",
            13: " not defined",
            14: " reserved",
            15: " don't care/take no action",
            2: " economy mode",
            3: " normal mode",
            4: " not defined",
            5: " not defined",
            6: " not defined",
            7: " not defined",
            8: " not defined",
            9: " not defined"
        },
        1684: {
            0: " deactivate water pump",
            1: " activate water pump",
            2: " reserved",
            3: " don't care/take no action"
        },
        1685: {
            0: " do not heat engine zone",
            1: " heat engine zone",
            2: " reserved",
            3: " don't care/take no action"
        },
        1686: {
            0: " do not cab engine zone",
            1: " heat cab zone",
            2: " reserved",
            3: " don't care/take no action"
        },
        1696: {
            0: " engine not using the exhaust gas oxygen sensor (open loop)",
            1: " engine using the exhaust gas oxygen sensor for a closed loop operation",
            2: " reserved",
            3: " don't care/take no action"
        },
        1697: {
            0: " ok ( no fault)",
            1: " not defined",
            2: " error",
            3: " not supported"
        },
        1698: {
            0: " ok (no fault)",
            1: " tire leak detected",
            2: " error",
            3: " not supported"
        },
        1699: {
            0: " off / isolated from cti pressure controller",
            1: " on (tire is polled)",
            2: " not defined",
            3: " not supported"
        },
        1700: {
            0: " not imminent",
            1: " imminent",
            2: " reserved",
            3: " not used"
        },
        1701: {
            0: " not imminent",
            1: " imminent",
            2: " reserved",
            3: " not used"
        },
        1702: {
            0: " lane departure indication disabled",
            1: " lane departure indication enabled ",
            2: " reserved",
            3: " not used"
        },
        1706: {
            0: " means convert spns per the version 4 definition below ",
            1: ".  spn assumed to be sent most significant bit first",
            2: ".  spn represented as intel format for most significant 16 bits  with 3 least significant bits of 19 bits in with fmi value.",
            3: ".  spn represented as intel format for all 19 bits (least significant sent first) ",
            4: ".  spn represented as intel format for all 19 bits with the spn conversion method set to 0."
        },
        1710: {
            0: " not tracking left side",
            1: " tracking left side",
            2: " reserved",
            3: " don't care/take no action"
        },
        1711: {
            0: " not tracking right side",
            1: " tracking right side",
            2: " reserved",
            3: " don't care/take no action"
        },
        1713: {
            0: " no restriction",
            1: " restriction exists on oil filter",
            2: " error",
            3: " not available"
        },
        1714: {
            0: " operator seat not facing forward",
            1: " operator seat is facing forward",
            2: " error",
            3: " not available"
        },
        1733: {
            0: " level not specified,(i.e. the nominal level is none of the specified levels, no error condition)",
            1: " \"normal level 1,(i.e. the level prescribed for normal driving, given by design)",
            10: " lowering",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " error",
            15: " not available",
            2: " \"normal level 2,(i.e. a level permitted for driving, for example to lower the vehicle in case of high speed)",
            3: " \"normal level 3,(i.e. a level permitted for driving, for example to lift the vehicle in case of offroad)",
            4: " \"preset level,(i.e. a level to be defined externally via can)",
            5: " \"customer level,(i.e. a level to be defined by customer via parameter setting)",
            6: " \"upper level,(i.e. the highest level to be controlled)",
            7: " \"lower level,(i.e. the lowest level to be controlled)",
            8: " level change stopped",
            9: " raising"
        },
        1734: {
            0: " level not specified,(i.e. the nominal level is none of the specified levels, no error condition)",
            1: " \"normal level 1,(i.e. the level prescribed for normal driving, given by design)",
            10: " lowering",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " error",
            15: " not available",
            2: " \"normal level 2,(i.e. a level permitted for driving, for example to lower the vehicle in case of high speed)",
            3: " \"normal level 3,(i.e. a level permitted for driving, for example to lift the vehicle in case of offroad)",
            4: " \"preset level,(i.e. a level to be defined externally via can)",
            5: " \"customer level,(i.e. a level to be defined by customer via parameter setting)",
            6: " \"upper level,(i.e. the highest level to be controlled)",
            7: " \"lower level,(i.e. the lowest level to be controlled)",
            8: " level change stopped",
            9: " raising"
        },
        1736: {
            0: " not above",
            1: " above",
            2: " error",
            3: " not available"
        },
        1737: {
            0: " not above",
            1: " above",
            2: " error",
            3: " not available"
        },
        1738: {
            0: " not below",
            1: " below",
            2: " error",
            3: " not available"
        },
        1739: {
            0: " lifting not active",
            1: " lifting active",
            2: " error",
            3: " not available"
        },
        1740: {
            0: " lowering not active",
            1: " lowering active",
            2: " error",
            3: " not available"
        },
        1741: {
            0: "    normal operation; i.e. the system performs a \"\"pure\"\" control of the vehicle height",
            1: "    traction help (load transfer); i.e. the driven axle is loaded to a maximum value given by legislation or design",
            10: "    automatic air suspension control prohibited",
            11: "    force to bumper level request is in effect",
            12: "    not defined",
            13: "    not defined",
            14: "    error",
            15: "    not available",
            2: "    load fixing; i.e. the driven axlen is loaded to a value defined by the driver",
            3: "    pressure ratio 1; i.e. the ratio between the pressures at the driven axle and at the third axle is controlled, so that the ratio equals a fixed value 1",
            4: "    pressure ratio 2; i.e. the ratio between the pressures at the driven axle and at the third axle is controlled, so that the ratio equals a fixed value 2",
            5: "    optimum traction 1; i.e. the pressure at the driven axle is controlled at a fixed value 1",
            6: "    optimum traction 2; i.e. the pressure at the driven axle is controlled at a fixed value 2",
            7: "    traction help - load reduce; (i.e. the driven axle load is reduced to normal load condition)",
            8: "    exhausting bellow function; i.e. the bellows are exhausted totally",
            9: "    air suspension control prohibited ( i.e. hold current pressures in all suspension devices.)"
        },
        1742: {
            0: " not active,(i.e. the kneeling function is not active\")",
            1: "lowering active,(i.e. the vehicle is lowered due to a kneeling request)",
            10: " not defined",
            11: " not defined",
            12: " not defined",
            13: " not defined",
            14: " error",
            15: " not available",
            2: " kneeling level reached,(i.e. the vehicle is at the fixed kneeling level)",
            3: " lifting active,(i.e. the vehicle is lifted due to a recover request)",
            4: " kneeling aborted,(i.e. in case of manual actuation the request was dropped before the kneeling level was reached)",
            5: " not defined",
            6: " not defined",
            7: " not defined",
            8: " not defined",
            9: " not defined"
        },
        1743: {
            0: " lift axle position down / tag axle laden",
            1: " lift axle position up / tag axle unladen",
            2: " error",
            3: " not available"
        },
        1744: {
            0: " doors may not be opened",
            1: " doors may be opened",
            2: " error",
            3: " not available"
        },
        1745: {
            0: " vehicle may be moved",
            1: " vehicle motion is inhibited",
            2: " error",
            3: " not available"
        },
        1746: {
            0: " not active",
            1: " active",
            2: " error",
            3: " not available"
        },
        1747: {
            0: " automatically actuated",
            1: " manually actuated",
            2: " reserved",
            3: " don't care/take no action"
        },
        1748: {
            0: " no kneeling request",
            1: " kneeling request",
            2: " reserved",
            3: " don't care/take no action"
        },
        1749: {
            0: " no kneeling request",
            1: " kneeling request",
            2: " reserved",
            3: " don't care/take no action"
        },
        1750: {
            0: " no level request",
            1: " normal level 1,(i.e. the level prescribed for normal driving, given by design)",
            10: "  lower request (continuously lowering front axle, as long as active).",
            11: " not defined",
            12: " not defined",
            13: " not defined",
            14: " reserved",
            15: " don't care/take no action",
            2: " normal level 2,(i.e. a level permitted for driving, for example to lower the vehicle in case of high speed)",
            3: " normal level 3,(i.e. a level permitted for driving, for example to lift the vehicle in case of offroad)",
            4: " preset level,(i.e. a level to be defined externally via can)",
            5: " customer level,(i.e. a level to be defined by customer via parameter setting)",
            6: " upper level,(i.e. the highest level to be controlled)",
            7: " lower level,(i.e. the lowest level to be controlled)",
            8: " stop level change,(i.e. the level change in process shall be stopped immediately)",
            9: "  raise request (continuously raising front axle, as long as active)."
        },
        1751: {
            0: " no level request",
            1: " normal level 1,(i.e. the level prescribed for normal driving, given by design)",
            10: "  lower request (continuously lowering front axle, as long as active).",
            11: " not defined",
            12: " not defined",
            13: " not defined",
            14: " reserved",
            15: " don't care/take no action",
            2: " normal level 2,(i.e. a level permitted for driving, for example to lower the vehicle in case of high speed)",
            3: " normal level 3,(i.e. a level permitted for driving, for example to lift the vehicle in case of offroad)",
            4: " preset level,(i.e. a level to be defined externally via can)",
            5: " customer level,(i.e. a level to be defined by customer via parameter setting)",
            6: " upper level,(i.e. the highest level to be controlled)",
            7: " lower level,(i.e. the lowest level to be controlled)",
            8: " stop level change,(i.e. the level change in process shall be stopped immediately)",
            9: "  raise request (continuously raising front axle, as long as active)."
        },
        1752: {
            0: " lift axle position down / tag axle laden",
            1: " lift axle position up / tag axle unladen",
            2: " reserved",
            3: " don't care/take no action"
        },
        1753: {
            0: "    normal operation; i.e. the system performs a \"\"pure\"\" control of the vehicle height",
            1: "    traction help (load transfer); i.e. the driven axle is loaded to a maximum value given by legislation or design",
            10: "    not defined",
            11: "    not defined",
            12: "    not defined",
            13: "    not defined",
            14: "    reserved",
            15: "    don't care/take no action",
            2: "    load fixing; i.e. the driven axle is loaded to a value defined by the driver",
            3: "    pressure ratio 1; i.e. the ratio between the pressures at the driven axle and at the third axle is controlled, so that the ratio equals a fixed value 1",
            4: "    pressure ratio 2; i.e. the ratio between the pressures at the driven axle and at the third axle is controlled, so that the ratio equals a fixed value 2",
            5: "    optimum traction 1; i.e. the pressure at the driven axle is controlled at a fixed value 1",
            6: "    optimum traction 2; i.e. the pressure at the driven axle is controlled at a fixed value 2",
            7: "    traction help - load reduce; (i.e. reduce axle load of driven axle to normal load condition)",
            8: "    exhaust bellows",
            9: "    force to bumper level"
        },
        1754: {
            0: " not below",
            1: " below",
            2: " error",
            3: " not available"
        },
        1755: {
            0: " lowering not active",
            1: " lowering active",
            2: " error",
            3: " not available"
        },
        1756: {
            0: " lifting not active",
            1: " lifting active",
            2: " error",
            3: " not available"
        },
        1763: {
            0: " disabled",
            1: " enabled",
            2: " error indicator",
            3: " not available"
        },
        1764: {
            0: " pressure mode inactive",
            1: " pressure mode active",
            2: " error indicator",
            3: " not available"
        },
        1792: {
            0: " off",
            1: " on ",
            2: " reserved",
            3: " take no action"
        },
        1793: {
            0: " off",
            1: " on ",
            2: " reserved",
            3: " take no action"
        },
        1796: {
            0: " acc das not active",
            1: " acc das active",
            2: " reserved",
            3: " take no action"
        },
        1797: {
            0: " acc ssow not active",
            1: " acc ssow active",
            2: " reserved",
            3: " take no action"
        },
        1798: {
            0: " no targets detected",
            1: " target detected",
            2: " reserved",
            3: " take no action"
        },
        1799: {
            0: " requested acc distance mode #1 (largest distance)",
            1: " requested acc distance mode #2",
            2: " requested acc distance mode #3",
            3: " requested acc distance mode #4",
            4: " requested acc distance mode #5 (shortest distance)",
            5: " not defined",
            6: " error condition",
            7: " not available"
        },
        1804: {
            0: "start enable off",
            1: "start enable on",
            2: "reserved",
            3: "not available"
        },
        1805: {
            0: "center on-grade display mode 1 ( 5 channel )",
            1: "offset on-grade display mode ",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: "not available or not applicable",
            2: "center on-grade display mode 2 ( 7 channel )",
            3: " reserved",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1806: {
            0: "    +/- 4.5 mm  (0.015 feet, 0.18 inches)",
            1: "    +/- 12 mm   (0.040 feet, 0.45 inches)",
            10: "  reserved",
            11: "  reserved",
            12: "  reserved",
            13: "  reserved",
            14: "  reserved",
            15: "    not available or not applicable",
            2: "    +/- 24 mm   (0.080 feet, 0.96 inches)",
            3: "    +/- 5  mm    (0.017 feet, 0.2 inches)",
            4: "    +/- 1 mm     (0.003 feet, 0.04 inches)",
            5: "  reserved",
            6: "  reserved",
            7: "  reserved",
            8: "  reserved",
            9: "  reserved"
        },
        1812: {
            0: " relative measuring principle",
            1: " absolute measuring principle",
            2: " reserved",
            3: " not available"
        },
        1813: {
            0: " off",
            1: " on",
            2: " reserved",
            3: " don't care/take no action"
        },
        1814: {
            0: " not fully operational",
            1: " fully operational",
            2: " reserved",
            3: " don't care/take no action"
        },
        1815: {
            0: " turn brake light not on",
            1: " turn brake light on",
            2: " reserved",
            3: " don't care/take no action"
        },
        1816: {
            0: " rop engine control passive but installed",
            1: " rop engine control active",
            2: " reserved",
            3: " don't care/take no action"
        },
        1817: {
            0: " yc engine control passive but installed",
            1: " yc engine control active",
            2: " reserved",
            3: " don't care/take no action"
        },
        1818: {
            0: " rop brake control passive but installed",
            1: " rop brake control active",
            2: " reserved",
            3: " don't care/take no action"
        },
        1819: {
            0: " yc brake control passive but installed",
            1: " yc brake control active",
            2: " reserved",
            3: " don't care/take no action"
        },
        1820: {
            0: " inside bus",
            1: " outside bus",
            2: " error",
            3: " not available"
        },
        1821: {
            0: " at least 1 door is open",
            1: " closing last door",
            10: " not defined",
            11: " not defined",
            12: " not defined",
            13: " not defined",
            14: " error",
            15: " not available",
            2: " all doors closed",
            3: " not defined",
            4: " not defined",
            5: " not defined",
            6: " not defined",
            7: " not defined",
            8: " not defined",
            9: " not defined"
        },
        1822: {
            0: " lift axle position down / tag axle laden",
            1: " lift axle position up / tag axle unladen",
            2: " error",
            3: " not available"
        },
        1823: {
            0: " actual level out of bumper range",
            1: " actual level within bumper range",
            2: " error",
            3: " not available"
        },
        1824: {
            0: " actual level out of bumper range",
            1: " actual level within bumper range",
            2: " error",
            3: " not available"
        },
        1825: {
            0: " not active",
            1: " active",
            2: " error",
            3: " not available"
        },
        1826: {
            0: " not active",
            1: " active",
            2: " error",
            3: " not available"
        },
        1827: {
            0: " actual request not refused",
            1: " axle load limit reached  (load transfer)",
            10: "  not defined",
            11: "  not defined",
            12: "  not defined",
            13: "  not defined",
            14: " error",
            15: " not available",
            2: " would exceed axle load limit (tag axle)",
            3: " bogie differential not locked",
            4: " above speed limit",
            5: " below speed limit",
            6: " general reject; i.e. no specified reason applies",
            7: " requested level not available",
            8: "  not defined",
            9: "  not defined"
        },
        1828: {
            0: " lift axle position down / tag axle laden",
            1: " lift axle position up / tag axle unladen",
            2: " reserved",
            3: " don't care/take no action"
        },
        1829: {
            0: " deactivate kneeling",
            1: " activate kneeling",
            2: " reserved",
            3: " don't care/take no action"
        },
        1830: {
            0: " deactivate kneeling",
            1: " activate kneeling",
            2: " reserved",
            3: " don't care/take no action"
        },
        1831: {
            0: " normal operation dampers passive",
            1: " normal operation dampers active",
            2: " error",
            3: " not available"
        },
        1832: {
            0: " normal operation dampers passive",
            1: " normal operation dampers active",
            2: " error",
            3: " not available"
        },
        1833: {
            0: " normal operation dampers passive",
            1: " normal operation dampers active",
            2: " error",
            3: " not available"
        },
        1836: {
            0: " trailer abs status information available but not active",
            1: " trailer abs active",
            2: " reserved",
            3: " trailer abs status information not available or parameter not supported"
        },
        1837: {
            0: " off",
            1: " on",
            2: " reserved",
            3: " not supported"
        },
        1838: {
            0: " off",
            1: " on",
            2: " reserved",
            3: " not supported"
        },
        1839: {
            0: " off",
            1: " on",
            2: " reserved",
            3: " not supported"
        },
        1840: {
            0: " off",
            1: " on",
            2: " reserved",
            3: " not supported"
        },
        1841: {
            0: " off",
            1: " on",
            2: " reserved",
            3: " not supported"
        },
        1842: {
            0: " off",
            1: " on",
            2: " reserved",
            3: " not supported"
        },
        1843: {
            0: " off",
            1: " on",
            2: " reserved",
            3: " not supported"
        },
        1849: {
            0: " inactive; transmission requested range display should not be flashing",
            1: " active; transmission requested range display should be flashing",
            2: " reserved",
            3: " take no action"
        },
        1850: {
            0: " inactive; transmission requested range display should not be blanked",
            1: " active; transmission requested range display should be blanked",
            2: " reserved",
            3: " take no action"
        },
        1851: {
            0: " inactive; shift is not inhibited",
            1: " active (on continuously); shift is inhibited",
            2: " active (flashing)",
            3: " take no action"
        },
        1852: {
            0: " disable",
            1: " enable",
            2: " reserved",
            3: " take no action"
        },
        1853: {
            0: " disable",
            1: " enable",
            2: " reserved",
            3: " take no action"
        },
        1854: {
            0: " disable",
            1: " enable",
            2: " reserved",
            3: " take no action"
        },
        1855: {
            0: " disable",
            1: " enable",
            2: " reserved",
            3: " take no action"
        },
        1856: {
            0: " not buckled",
            1: " ok - seat belt is buckled",
            2: " error - switch state cannot be determined",
            3: " not available"
        },
        1857: {
            0: " not ok- oil pressure is too low",
            1: " ok - oil pressure is above minimum",
            2: " error - switch state cannot be determined",
            3: " not available"
        },
        1861: {
            0: " reverse",
            1: " forward",
            2: " error indication",
            3: " not available"
        },
        1864: {
            0: " reverse",
            1: " forward",
            2: " error indication",
            3: " not available"
        },
        1865: {
            0: " key switch off",
            1: " key switch not off",
            2: " error indication",
            3: " not available"
        },
        1867: {
            0: " no further requirement for ecu_pwr",
            1: " requirement for 2 more seconds of ecu_pwr",
            2: " reserved ",
            3: " don-t care"
        },
        1868: {
            0: " no further requirement for pwr",
            1: " requirement for 2 more seconds of pwr",
            2: " reserved ",
            3: " don-t care"
        },
        1869: {
            0: " implement may not be transported ",
            1: " implement may be transported",
            2: " error indication",
            3: " not available"
        },
        1870: {
            0: " implement may not be disconnected ",
            1: " implement may be disconnected",
            2: " error indication",
            3: " not available"
        },
        1871: {
            0: " implement is not ready for field work ",
            1: " implement is ready for field work",
            2: " error indication",
            3: " not available"
        },
        1876: {
            0: " hitch position is out-of-work ",
            1: " hitch position is in-work",
            2: " error indication",
            3: " not available"
        },
        1877: {
            0: " hitch position is out-of-work ",
            1: " hitch position is in-work",
            2: " error indication",
            3: " not available"
        },
        1888: {
            0: " power take off disengaged",
            1: " power take off engaged",
            2: " error indication",
            3: " not available"
        },
        1889: {
            0: " power take off mode is 540",
            1: " power take off mode is 1000",
            2: " error indication",
            3: " not available"
        },
        1890: {
            0: " power take off mode is 540",
            1: " power take off mode is 1000",
            2: " error indication",
            3: " not available"
        },
        1891: {
            0: " power take off economy mode is disengaged",
            1: " power take off economy mode is engaged",
            2: " error indication",
            3: " not available"
        },
        1892: {
            0: " power take off economy mode is disengaged",
            1: " power take off economy mode is engaged",
            2: " error indication",
            3: " not available"
        },
        1893: {
            0: " disengage power take off",
            1: " engage power take off ",
            2: " reserved",
            3: " don-t care"
        },
        1894: {
            0: " disengage power take off",
            1: " engage power take off ",
            2: " reserved",
            3: " don-t care"
        },
        1895: {
            0: " select 540 rpm mode",
            1: " select 1000 rpm mode ",
            2: " reserved",
            3: " don-t care"
        },
        1896: {
            0: " select 540 rpm mode",
            1: " select 1000 rpm mode ",
            2: " reserved",
            3: " don-t care"
        },
        1897: {
            0: " disengage power take off-s economy mode",
            1: " engage power take off-s economy mode",
            2: " reserved",
            3: " don-t care"
        },
        1898: {
            0: " disengage power take off-s economy mode",
            1: " engage power take off-s economy mode",
            2: " reserved",
            3: " don-t care"
        },
        1903: {
            0: " blocked",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " floating",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1908: {
            0: " block",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " float",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1909: {
            0: " block",
            1: " float",
            2: " reserved",
            3: " don-t care"
        },
        1910: {
            0: " block",
            1: " float",
            2: " reserved   <=== ???? should be error indicator since measured ???? =====",
            3: " don-t care"
        },
        1915: {
            0: " blocked",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " floating",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1920: {
            0: " block",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " float",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1921: {
            0: " block",
            1: " float",
            2: " reserved",
            3: " don-t care"
        },
        1922: {
            0: " block",
            1: " float",
            2: " reserved   <=== ???? should be error indicator since measured ???? =====",
            3: " don-t care"
        },
        1927: {
            0: " blocked",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " floating",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1932: {
            0: " block",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " float",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1933: {
            0: " block",
            1: " float",
            2: " reserved",
            3: " don-t care"
        },
        1934: {
            0: " block",
            1: " float",
            2: " reserved   <=== ???? should be error indicator since measured ???? =====",
            3: " don-t care"
        },
        1939: {
            0: " blocked",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " floating",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1944: {
            0: " block",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " float",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1945: {
            0: " block",
            1: " float",
            2: " reserved",
            3: " don-t care"
        },
        1946: {
            0: " block",
            1: " float",
            2: " reserved   <=== ???? should be error indicator since measured ???? =====",
            3: " don-t care"
        },
        1951: {
            0: " blocked",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " floating",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1956: {
            0: " block",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " float",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1957: {
            0: " block",
            1: " float",
            2: " reserved",
            3: " don-t care"
        },
        1958: {
            0: " block",
            1: " float",
            2: " reserved   <=== ???? should be error indicator since measured ???? =====",
            3: " don-t care"
        },
        1963: {
            0: " blocked",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " floating",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1968: {
            0: " block",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " float",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1969: {
            0: " block",
            1: " float",
            2: " reserved",
            3: " don-t care"
        },
        1970: {
            0: " block",
            1: " float",
            2: " reserved   <=== ???? should be error indicator since measured ???? =====",
            3: " don-t care"
        },
        1975: {
            0: " blocked",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " floating",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1980: {
            0: " block",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " float",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1981: {
            0: " block",
            1: " float",
            2: " reserved",
            3: " don-t care"
        },
        1982: {
            0: " block",
            1: " float",
            2: " reserved   <=== ???? should be error indicator since measured ???? =====",
            3: " don-t care"
        },
        1987: {
            0: " blocked",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " floating",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1992: {
            0: " block",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " float",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        1993: {
            0: " block",
            1: " float",
            2: " reserved",
            3: " don-t care"
        },
        1994: {
            0: " block",
            1: " float",
            2: " reserved   <=== ???? should be error indicator since measured ???? =====",
            3: " don-t care"
        },
        1999: {
            0: " blocked",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " floating",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        2260: {
            0: " block",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " float",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        2261: {
            0: " block",
            1: " float",
            2: " reserved",
            3: " don-t care"
        },
        2262: {
            0: " block",
            1: " float",
            2: " reserved   <=== ???? should be error indicator since measured ???? =====",
            3: " don-t care"
        },
        2267: {
            0: " blocked",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " floating",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        2272: {
            0: " block",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " float",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        2273: {
            0: " block",
            1: " float",
            2: " reserved",
            3: " don-t care"
        },
        2274: {
            0: " block",
            1: " float",
            2: " reserved   <=== ???? should be error indicator since measured ???? =====",
            3: " don-t care"
        },
        2279: {
            0: " blocked",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " floating",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        2284: {
            0: " block",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " float",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        2285: {
            0: " block",
            1: " float",
            2: " reserved",
            3: " don-t care"
        },
        2286: {
            0: " block",
            1: " float",
            2: " reserved   <=== ???? should be error indicator since measured ???? =====",
            3: " don-t care"
        },
        2291: {
            0: " blocked",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " floating",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        2296: {
            0: " block",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " float",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        2297: {
            0: " block",
            1: " float",
            2: " reserved",
            3: " don-t care"
        },
        2298: {
            0: " block",
            1: " float",
            2: " reserved   <=== ???? should be error indicator since measured ???? =====",
            3: " don-t care"
        },
        2303: {
            0: " blocked",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " floating",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        2308: {
            0: " block",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " float",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        2309: {
            0: " block",
            1: " float",
            2: " reserved",
            3: " don-t care"
        },
        2310: {
            0: " block",
            1: " float",
            2: " reserved   <=== ???? should be error indicator since measured ???? =====",
            3: " don-t care"
        },
        2315: {
            0: " blocked",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " floating",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        2320: {
            0: " block",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " float",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        2321: {
            0: " block",
            1: " float",
            2: " reserved",
            3: " don-t care"
        },
        2322: {
            0: " block",
            1: " float",
            2: " reserved   <=== ???? should be error indicator since measured ???? =====",
            3: " don-t care"
        },
        2327: {
            0: " blocked",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " floating",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        2332: {
            0: " block",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " float",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        2333: {
            0: " block",
            1: " float",
            2: " reserved",
            3: " don-t care"
        },
        2334: {
            0: " block",
            1: " float",
            2: " reserved   <=== ???? should be error indicator since measured ???? =====",
            3: " don-t care"
        },
        2339: {
            0: " blocked",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " floating",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        2344: {
            0: " block",
            1: " extend",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " don-t care",
            2: " retract",
            3: " float",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        2345: {
            0: " block",
            1: " float",
            2: " reserved",
            3: " don-t care"
        },
        2346: {
            0: " block",
            1: " float",
            2: " error",
            3: " not available"
        },
        2347: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2348: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2349: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2350: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2351: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2352: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2353: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2354: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2355: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2356: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2357: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2358: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2359: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2360: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2361: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2362: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2363: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2364: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2365: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2366: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2367: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2368: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2369: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2370: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2371: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2372: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2373: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2374: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2375: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2376: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2377: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2378: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2379: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2380: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2381: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2382: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2383: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2384: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2385: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2386: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2387: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2388: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2389: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2390: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2391: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2392: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2393: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2394: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2395: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2396: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2397: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2398: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2399: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2400: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2401: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2402: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2403: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2404: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2405: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2406: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2407: {
            0: " de-activated",
            1: " activated",
            2: " fault detected",
            3: " not available"
        },
        2408: {
            0: " power take off disengaged",
            1: " power take off engaged",
            2: " error indication",
            3: " not available"
        },
        2411: {
            0: " comma is used",
            1: " point is used",
            2: " reserved",
            3: " no action"
        },
        2413: {
            0: " 24 hour",
            1: " 12 hour (am/ pm)",
            2: " reserved",
            3: " no action"
        },
        2414: {
            0: " metric (km, m, -)",
            1: " imperial (miles, feet, ..)",
            2: " reserved",
            3: " no action"
        },
        2415: {
            0: " metric (ha or m2)",
            1: " imperial (acres or feet2)",
            2: " reserved",
            3: " no action"
        },
        2416: {
            0: " metric (litre)",
            1: " imperial (gallon)",
            2: " us (gallon)",
            3: " no action"
        },
        2417: {
            0: " metric (tonne, kg, -)",
            1: " imperial (long tons-uk, pounds, -.)",
            2: " tons/pounds (short tons-us, pounds, -)",
            3: " no action"
        },
        2419: {
            0: " data format is long integer",
            1: " data format is floating",
            2: " data format is unsigned long integer",
            3: " not available or error"
        },
        2420: {
            0: " data is set point",
            1: " data is actual values",
            2: " message is set point request",
            3: " message is actual value request"
        },
        2518: {
            0: " leading",
            1: " lagging",
            2: " error",
            3: " not available or not installed"
        },
        2519: {
            0: " leading",
            1: " lagging",
            2: " error",
            3: " not available or not installed"
        },
        2520: {
            0: " leading",
            1: " lagging",
            2: " error",
            3: " not available or not installed"
        },
        2521: {
            0: " leading",
            1: " lagging",
            2: " error",
            3: " not available or not installed"
        },
        2522: {
            0: " leading",
            1: " lagging",
            2: " error",
            3: " not available or not installed"
        },
        2523: {
            0: " leading",
            1: " lagging",
            2: " error",
            3: " not available or not installed"
        },
        2524: {
            0: " leading",
            1: " lagging",
            2: " error",
            3: " not available or not installed"
        },
        2525: {
            0: " leading",
            1: " lagging",
            2: " error",
            3: " not available or not installed"
        },
        2526: {
            0: " phases do not match",
            1: " phases match",
            2: " error",
            3: " not available or not installed"
        },
        2527: {
            0: " voltages do not match",
            1: " voltages match",
            2: " error",
            3: " not available or not installed"
        },
        2528: {
            0: " frequencies do not match",
            1: " frequencies match",
            2: " error",
            3: " not available or not installed"
        },
        2529: {
            0: " not synchronized",
            1: " synchronized",
            2: " error",
            3: " not available or not installed"
        },
        2530: {
            0: " bus is not dead",
            1: " bus is dead",
            2: " error",
            3: " not available or not installed"
        },
        2531: {
            0: " phases do not match",
            1: " phases match",
            2: " error",
            3: " not available or not installed"
        },
        2532: {
            0: " voltages do not match",
            1: " voltages match",
            2: " error",
            3: " not available or not installed"
        },
        2533: {
            0: " frequencies do not match",
            1: " frequencies match",
            2: " error",
            3: " not available or not installed"
        },
        2534: {
            0: " not synchronized",
            1: " synchronized",
            2: " error",
            3: " not available or not installed"
        },
        2535: {
            0: " bus is not dead",
            1: " bus is dead",
            2: " error",
            3: " not available or not installed"
        },
        2536: {
            0: " transmission mode 1 not active",
            1: " transmission mode 1 active",
            2: " error",
            3: " not available"
        },
        2537: {
            0: " transmission mode 2 not active",
            1: " transmission mode 2 active",
            2: " error",
            3: " not available"
        },
        2538: {
            0: " transmission mode 3 not active",
            1: " transmission mode 3 active",
            2: " error",
            3: " not available"
        },
        2539: {
            0: " transmission mode 4 not active",
            1: " transmission mode 4 active",
            2: " error",
            3: " not available"
        },
        2575: {
            0: " no",
            1: " yes",
            2: " undefined",
            3: " na"
        },
        2577: {
            0: "narrow = +/- 4.5mm",
            1: "standard = +/- 12mm",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " not available",
            2: "wide = +/- 24mm",
            3: " reserved",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        2582: {
            0: " supply is not reliable",
            1: " supply is reliable",
            2: " error indicator",
            3: " not available"
        },
        2583: {
            0: " supply is not reliable",
            1: " supply is reliable",
            2: " error indicator",
            3: " not available"
        },
        2584: {
            0: " pressure level sufficient",
            1: " pressure level below warning level",
            2: " error indicator",
            3: " not available"
        },
        2585: {
            0: " pressure level sufficient",
            1: " pressure level below warning level",
            2: " error indicator",
            3: " not available"
        },
        2587: {
            0: " extreme over pressure - the tire pressure is at a level where the safety of the vehicle may be jeopardised.",
            1: " over pressure - the tire pressure is higher than the pressure defined by the vehicle or tire manufacturer.",
            2: " no warning pressure - the tire pressure is within the thresholds defined by the vehicle or tire manufacturer.",
            3: " under pressure - the tire pressure is lower than the pressure defined by the vehicle or tire manufacturer.",
            4: " extreme under pressure - the tire pressure is at a level where the safety of the vehicle may be jeopardised.",
            5: " not defined",
            6: " error indicator",
            7: " not available"
        },
        2597: {
            0: " de-activate",
            1: " activate",
            2: " reserved",
            3: " don-t care"
        },
        2598: {
            0: " de-activate",
            1: " activate",
            2: " fault detected",
            3: " not available"
        },
        2599: {
            0: " pump not engaged",
            1: " pump engaged",
            2: " error",
            3: " not available or not installed"
        },
        2612: {
            0: " front wheel drive actuator not engaged",
            1: " front wheel drive actuator engaged",
            2: " error",
            3: " not available"
        },
        2615: {
            0: " not synchronized",
            1: " synchronized center",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " take no action",
            2: " synchronized port",
            3: " synchronized starboard",
            4: " synchronized master",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        2616: {
            0: " trolling mode is off.",
            1: " trolling mode is active.",
            2: " reserved",
            3: " take no action"
        },
        2617: {
            0: " slow vessel mode is off.",
            1: " slow vessel mode is active.",
            2: " reserved",
            3: " take no action"
        },
        2618: {
            0: " indefinite suspension of all broadcasts",
            1: " indefinite suspension of some messages",
            10: " sae reserved",
            11: " sae reserved",
            12: " sae reserved",
            13: " sae reserved",
            14: " sae reserved",
            15: " not available",
            2: " temporary suspension of all broadcasts",
            3: " temporary suspension of some messages",
            4: " sae reserved",
            5: " sae reserved",
            6: " sae reserved",
            7: " sae reserved",
            8: " sae reserved",
            9: " sae reserved"
        },
        2665: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2666: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2667: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2668: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2669: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2670: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2671: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2672: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2673: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2674: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2675: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        2676: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        2677: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        2678: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        2679: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        2680: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        2681: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        2682: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        2683: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        2684: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        2685: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2686: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2687: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2688: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2689: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2690: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2691: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2692: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2693: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2694: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2695: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2696: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2702: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2703: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2704: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2705: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2706: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2707: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2708: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2709: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2710: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2711: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2712: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        2713: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        2714: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2715: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        2716: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        2717: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        2718: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        2719: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        2720: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        2721: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        2722: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2723: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2724: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2725: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2726: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2727: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2728: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2729: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2730: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2731: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2732: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2733: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2739: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2740: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2741: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2742: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2743: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2744: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2745: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2746: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2747: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2748: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2749: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        2750: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        2751: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        2752: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        2753: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        2754: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        2755: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        2756: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        2757: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        2758: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        2759: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2760: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2761: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2762: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2763: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2764: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2765: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2766: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2767: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2768: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2769: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2770: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        2792: {
            0: "   vgt air control shutoff valve is off",
            1: "   vgt air control shutoff valve is on",
            2: "   reserved",
            3: "   not available"
        },
        2796: {
            0: "\t2 wheel high (normal or -on highway- range)",
            1: "\t4 wheel high (normal or -on highway- range)",
            2: "\tneutral",
            3: "\t2 wheel low (or -off highway- range)",
            4: "\t4 wheel low (or -off highway- range)",
            5: "\treserved for sae assignment",
            6: "\terror indicator",
            7: "\tnot available"
        },
        2804: {
            0: " diagnostics is not supported",
            1: " diagnostics is supported",
            2: " reserved",
            3: " don't care"
        },
        2805: {
            0: " on request mode is not supported",
            1: " on request mode is supported",
            2: " reserved",
            3: " don't care"
        },
        2807: {
            0: "open (fuel supplied to engine)",
            1: "closed (no fuel supplied to engine)",
            2: "reserved",
            3: "don't care / take no action"
        },
        2812: {
            0: " engine overspeed test not active",
            1: " engine overspeed test active",
            2: " reserved",
            3: " not available"
        },
        2813: {
            0: " air shutoff disabled, not attempting to shutoff engine air supply",
            1: " air shutoff enabled, attempting to shutoff engine air supply",
            2: " reserved",
            3: " not available"
        },
        2814: {
            0: " engine alarm output command not active",
            1: " engine alarm output command active",
            2: " reserved",
            3: " not available"
        },
        2815: {
            0: " engine alarm acknowledge  not active ",
            1: " engine alarm acknowledge active",
            2: " error",
            3: " not available"
        },
        2863: {
            0: " off",
            1: " low",
            10: "   reserved   ",
            11: "   reserved   ",
            12: "   reserved   ",
            13: "   reserved   ",
            14: "   reserved   ",
            15: " not available (do not change)",
            2: " medium",
            3: " high",
            4: " delayed 1 (used for the first delay choice when the wiper switch position controls the delay)",
            5: " delayed 2 (used for the second delay choice when the wiper switch position controls the delay)",
            6: " mist (position where external sensor  controls wiper rate)",
            7: "   reserved   ",
            8: "   reserved   ",
            9: "   reserved   "
        },
        2864: {
            0: " off",
            1: " low",
            10: "   reserved   ",
            11: "   reserved   ",
            12: "   reserved   ",
            13: "   reserved   ",
            14: "   reserved   ",
            15: " not available (do not change)",
            2: " medium",
            3: " high",
            4: " delayed 1 (used for the first delay choice when the wiper switch position controls the delay)",
            5: " delayed 2 (used for the second delay choice when the wiper switch position controls the delay)",
            6: " mist (position where external sensor  controls wiper rate)",
            7: "   reserved   ",
            8: "   reserved   ",
            9: "   reserved   "
        },
        2865: {
            0: " off",
            1: " low",
            10: "   reserved   ",
            11: "   reserved   ",
            12: "   reserved   ",
            13: "   reserved   ",
            14: "   reserved   ",
            15: " not available (do not change)",
            2: " medium",
            3: " high",
            4: " delayed 1 (used for the first delay choice when the wiper switch position controls the delay)",
            5: " delayed 2 (used for the second delay choice when the wiper switch position controls the delay)",
            6: " mist (position where external sensor  controls wiper rate)",
            7: "   reserved   ",
            8: "   reserved   ",
            9: "   reserved   "
        },
        2866: {
            0: " off",
            1: " low",
            2: " medium",
            3: " high",
            4: "   reserved   ",
            5: "   reserved   ",
            6: "   reserved   ",
            7: " not available (do not change)"
        },
        2867: {
            0: " off",
            1: " low",
            2: " medium",
            3: " high",
            4: "   reserved   ",
            5: "   reserved   ",
            6: "   reserved   ",
            7: " not available (do not change)"
        },
        2868: {
            0: " off",
            1: " low",
            2: " medium",
            3: " high",
            4: "   reserved   ",
            5: "   reserved   ",
            6: "   reserved   ",
            7: " not available (do not change)"
        },
        2872: {
            0: " off - the position by which the operator selects that none of the lamps are to be on.",
            1: " park on - the position by which the operator selects that the park lamps are to be on. ",
            10: "  reserved   ",
            11: "  reserved   ",
            12: "  reserved   ",
            13: "  reserved   ",
            14: "  error",
            15: "  not available (do not change)",
            2: " headlight on - the position by which the operator selects that the headlamps are to be on.",
            3: " headlight and park on - the position by which the operator selects that both the headlamps and the park lamps are to be on. ",
            4: "   reserved   ",
            5: "   reserved   ",
            6: "   reserved   ",
            7: "   reserved   ",
            8: "   delayed off - the position by which the operator selects that a certain set of lamps are to come on and then are to be turned off following a delay time (operators desired - delayed lamp off time).",
            9: "  reserved   "
        },
        2873: {
            0: "   off - the position by which the operator selects that none of the work lamps are to be on.",
            1: "   work light combination #1 on - the position by which the operator selects that the lamps in the combination defined as work light combination #1 are to be on.",
            10: "    reserved   ",
            11: "    reserved   ",
            12: "    reserved   ",
            13: "    reserved   ",
            14: "   error",
            15: "   not available (do not change)",
            2: "   work light combination #2 on - the position by which the operator selects that the lamps in the combination defined as work light combination #2 are to be on.",
            3: "   work light combination #3 on - the position by which the operator selects that the lamps in the combination defined as work light combination #3 are to be on.",
            4: "   work light combination #4 on - the position by which the operator selects that the lamps in the combination defined as work light combination #4 are to be on.",
            5: "    reserved   ",
            6: "    reserved   ",
            7: "    reserved   ",
            8: "    reserved   ",
            9: "    reserved   "
        },
        2874: {
            0: "  low beam selected",
            1: "  high beam selected",
            2: "  error",
            3: "  not available (do not change)"
        },
        2875: {
            0: "   hazard lamps to be off",
            1: "   hazard lamps to be flashing",
            2: "   error",
            3: "   not available (do not change)"
        },
        2876: {
            0: "   no turn being signaled",
            1: "   left turn to be flashing",
            10: "   reserved   ",
            11: "   reserved   ",
            12: "   reserved   ",
            13: "   reserved   ",
            14: "   error (to include both left and right selected simultaneously)",
            15: "   not available (do not change)",
            2: "   right turn to be flashing",
            3: "   reserved   ",
            4: "   reserved   ",
            5: "   reserved   ",
            6: "   reserved   ",
            7: "   reserved   ",
            8: "   reserved   ",
            9: "   reserved   "
        },
        2879: {
            0: "normal droop setting is selected",
            1: " thru 1101 - one of alternate droop setting 1 through 13 (in sequential order) is selected",
            14: "error condition",
            15: "not available"
        },
        2880: {
            0: "indicates that the isc functionality is not requested, engine operates normally",
            1: " thru 1101 - indicates that the isc setting 1 thru 13 (in sequential order) is selected",
            14: "error condition",
            15: "not available"
        },
        2881: {
            0: "normal droop setting is selected",
            1: " thru 1101 - one of alternate droop setting 1 through 13 (in sequential order) is selected",
            14: "error condition",
            15: "not available"
        },
        2883: {
            0: " default low idle point is selected",
            1: " alternate low idle point is selected",
            2: " error",
            3: " not available or unused"
        },
        2884: {
            0: "auxiliary governor is disabled",
            1: "auxiliary governor is enabled",
            2: "error condition",
            3: "not available"
        },
        2885: {
            0: "normal droop setting is selected",
            1: " thru 1101 - one of alternate droop setting 1 through 13 (in sequential order) is selected",
            14: "error condition",
            15: "not available"
        },
        2886: {
            0: "normal droop setting is selected",
            1: " thru 1101 - one of alternate droop setting 1 through 13 (in sequential order) is selected",
            14: "error condition",
            15: "not available"
        },
        2888: {
            0: "control state is maximum power fueling",
            1: "control state is alternate power fueling 1 ",
            10: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            100: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            101: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            102: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            103: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            104: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            105: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            106: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            107: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            108: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            109: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            11: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            110: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            111: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            112: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            113: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            114: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            115: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            116: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            117: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            118: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            119: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            12: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            120: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            121: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            122: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            123: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            124: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            125: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            126: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            127: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            128: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            129: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            13: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            130: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            131: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            132: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            133: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            134: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            135: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            136: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            137: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            138: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            139: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            14: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            140: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            141: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            142: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            143: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            144: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            145: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            146: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            147: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            148: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            149: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            15: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            150: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            151: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            152: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            153: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            154: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            155: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            156: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            157: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            158: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            159: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            16: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            160: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            161: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            162: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            163: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            164: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            165: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            166: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            167: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            168: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            169: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            17: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            170: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            171: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            172: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            173: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            174: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            175: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            176: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            177: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            178: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            179: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            18: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            180: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            181: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            182: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            183: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            184: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            185: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            186: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            187: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            188: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            189: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            19: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            190: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            191: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            192: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            193: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            194: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            195: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            196: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            197: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            198: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            199: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            2: "control state is alternate power fueling 2 ",
            20: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            200: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            201: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            202: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            203: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            204: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            205: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            206: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            207: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            208: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            209: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            21: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            210: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            211: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            212: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            213: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            214: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            215: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            216: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            217: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            218: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            219: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            22: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            220: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            221: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            222: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            223: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            224: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            225: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            226: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            227: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            228: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            229: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            23: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            230: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            231: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            232: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            233: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            234: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            235: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            236: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            237: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            238: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            239: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            24: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            240: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            241: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            242: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            243: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            244: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            245: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            246: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            247: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            248: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            249: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            25: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            250: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            251: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            252: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            253: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            254: "sae reserved",
            255: "not available",
            26: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            27: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            28: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            29: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            3: "control state is alternate power fueling 3",
            30: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            31: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            32: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            33: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            34: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            35: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            36: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            37: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            38: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            39: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            4: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            40: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            41: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            42: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            43: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            44: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            45: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            46: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            47: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            48: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            49: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            5: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            50: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            51: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            52: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            53: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            54: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            55: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            56: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            57: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            58: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            59: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            6: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            60: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            61: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            62: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            63: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            64: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            65: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            66: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            67: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            68: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            69: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            7: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            70: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            71: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            72: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            73: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            74: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            75: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            76: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            77: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            78: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            79: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            8: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            80: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            81: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            82: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            83: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            84: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            85: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            86: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            87: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            88: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            89: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            9: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            90: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            91: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            92: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            93: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            94: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            95: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            96: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            97: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            98: "control state is alternate power fueling 4 thru 253 (in sequential order) ",
            99: "control state is alternate power fueling 4 thru 253 (in sequential order) "
        },
        2889: {
            0: "control state is normal droop setting",
            1: " thru 1101 - control state is one of alternate droop setting 1 through 13 (in sequential order) ",
            14: "sae reserved",
            15: "not available"
        },
        2890: {
            0: " control state is functionality disabled (off)",
            1: " control state is functionality enabled (on)",
            2: " sae reserved",
            3: " not available"
        },
        2891: {
            0: "normal idle state",
            1: "alternate idle state",
            2: "sae reserved",
            3: "not available"
        },
        2892: {
            0: "control state is isc functionality is not requested, engine operates normally",
            1: " thru 1101 - control state is  isc setting 1 thru 13 (in sequential order) ",
            1110: "sae reserved",
            1111: "not available",
            13: " preprogrammed intermediate speed control settings are available for the controlling ecm to select.  if no speed setting is requested, the engine operates normally. the intermediate speed control is widely used in the industrial application to control the engine to an intermediate speed setting which can either replace the accelerator position control altogether, or limit the accelerator position control to a selectable speed point minimum or maximum. this parameter indicates which state has been selected by the controlling ecm."
        },
        2893: {
            0: "control's state is normal droop setting",
            1: " thru 1101 - control's state is one of alternate droop setting 1 through 13 (in sequential order)",
            14: "sae reserved",
            15: "not available"
        },
        2894: {
            0: "control state is normal droop setting",
            1: " thru 1101 - control state is one of alternate droop setting 1 through 13 (in sequential order) ",
            14: "sae reserved",
            15: "not available"
        },
        2895: {
            0: "control state is normal droop setting",
            1: " thru 1101 - control state is one of alternate droop setting 1 through 13 (in sequential order)",
            14: "sae reserved",
            15: "not available"
        },
        2896: {
            0: "control state is auxiliary governor disabled",
            1: "control state is auxiliary governor enabled",
            2: "sae reserved",
            3: "not available"
        },
        2897: {
            0: " pto set speed memory 1 selected",
            1: " pto set speed memory 2 selected",
            2: " error",
            3: " not available"
        },
        2898: {
            0: "no start enable device 2 installed",
            1: "glow plugs installed",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "not available",
            2: "fuelled start installed",
            3: "ether injection installed",
            4: "electric intake air heater installed",
            5: "reserved",
            6: "reserved",
            7: "reserved",
            8: "reserved",
            9: "reserved"
        },
        2899: {
            0: "no start enable device 1 installed",
            1: "glow plugs installed",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "not available",
            2: "fuelled start installed",
            3: "ether injection installed",
            4: "electric intake air heater installed",
            5: "reserved",
            6: "reserved",
            7: "reserved",
            8: "reserved",
            9: "reserved"
        },
        2900: {
            0: "cranking disabled; engine cranking is prohibited by the transmission",
            1: "cranking enabled; engine cranking is allowed by the transmission",
            2: "error",
            3: "not available"
        },
        2911: {
            0: "    halt brake switch passive",
            1: "    halt brake switch active",
            2: "    error",
            3: "    not available"
        },
        2912: {
            0: "            inactive",
            1: "            active",
            2: "            active, but will change to inactive in a short time.  (this mode may be used to warn the driver)",
            3: "  reserved",
            4: "  reserved",
            5: "  reserved",
            6: "            hill holder not functional",
            7: "            not available"
        },
        2913: {
            0: "            inactive",
            1: "            active",
            2: "            active, but not functioning properly.  (this mode may be used to warn the driver)",
            3: "  not defined",
            4: "  not defined",
            5: "  not defined",
            6: "            halt brake not functional",
            7: "            not available"
        },
        2914: {
            0: "no endurance brake integration allowed",
            1: "only endurance brakes allowed",
            2: "endurance brake integration allowed",
            3: "not defined"
        },
        2915: {
            0: "highest priority - used for emergency situations, e.g. for future collision avoidance system.  this mode overrides any brake protection measures of the brake system.",
            1: "high priority - not defined",
            2: "medium priority - used for acc-systems. this mode does not override brake protection measures of the brake system.",
            3: "low priority - used in -override disabled- xbr control mode"
        },
        2916: {
            0: "override disabled - disable any existing control commanded by the source of this command.",
            1: "acceleration control with addition mode - add the xbr acceleration demand to the driver-s acceleration demand.",
            2: "acceleration control with maximum mode - execute the xbr acceleration demand if it is higher than the driver-s acceleration demand.",
            3: "not defined"
        },
        2917: {
            0: "any external brake demand will be accepted (brake system fully operational)",
            1: "only external brake demand of highest xbr priority (00) will be accepted  (e.g. because the temperature limit of the brake system is exceeded)",
            2: "no external brake demand will be accepted (e.g. because of fault in brake system)",
            3: "not available"
        },
        2918: {
            0: "                no brake demand being executed (default mode)",
            1: "                driver's brake demand being executed, no external brake demand",
            10: "    reserved for sae assignment",
            11: "    reserved for sae assignment",
            12: "    reserved for sae assignment",
            13: "    reserved for sae assignment",
            14: "    reserved for sae assignment",
            15: "                not available",
            2: "                addition mode of xbr acceleration control being executed",
            3: "                maximum mode of xbr acceleration control being executed",
            4: "    reserved for sae assignment",
            5: "    reserved for sae assignment",
            6: "    reserved for sae assignment",
            7: "    reserved for sae assignment",
            8: "    reserved for sae assignment",
            9: "    reserved for sae assignment"
        },
        2919: {
            0: "   foundation brakes not in use",
            1: "   foundation brakes in use",
            2: "   reserved",
            3: "   not available"
        },
        2922: {
            0: "      lowering allowed",
            1: "      lowering inhibited",
            2: "      reserved",
            3: "      not available"
        },
        2923: {
            0: "               axle steering not active (adhesion steering)",
            1: "               axle steering active",
            10: "     reserved for sae assignment",
            11: "     reserved for sae assignment",
            12: "     reserved for sae assignment",
            13: "     reserved for sae assignment",
            14: "     reserved for sae assignment",
            15: "               not available",
            2: "               axle centered",
            3: "               axle centered, because of an error",
            4: "               axle not active because of an error (adhesion steering)",
            5: "               axle steering in special mode (diagnosis, calibration mode)",
            6: "     reserved for sae assignment",
            7: "     reserved for sae assignment",
            8: "     reserved for sae assignment",
            9: "     reserved for sae assignment"
        },
        2924: {
            0: "    main steering system - the steering equipment of a vehicle which is mainly responsible for determining the direction of travel.",
            1: "    auxiliary steering equipment - a system in which the wheels on axle(s) of vehicles of categories m and n are steered in addition to the wheels of the main steering equipment in the same or opposite direction to those of the main steering equipment and/or the steering angle of the front and/or the rear wheels may be adjusted relative to vehicle behaviour.",
            10: "   reserved for assignment by sae",
            11: "   reserved for assignment by sae",
            12: "   reserved for assignment by sae",
            13: "   reserved for assignment by sae",
            14: "   reserved for assignment by sae",
            15: "             not available",
            2: "   reserved for assignment by sae",
            3: "   reserved for assignment by sae",
            4: "   reserved for assignment by sae",
            5: "   reserved for assignment by sae",
            6: "   reserved for assignment by sae",
            7: "   reserved for assignment by sae",
            8: "   reserved for assignment by sae",
            9: "   reserved for assignment by sae"
        },
        2925: {
            0: "  manual steering equipment - the steering forces result solely from the muscular effort of the driver.",
            1: "  power assisted steering equipment - the steering forces result from both the muscular effort of the driver and the energy supply or supplies.",
            10: "   reserved for sae assignment",
            11: "   reserved for sae assignment",
            12: "   reserved for sae assignment",
            13: "   reserved for sae assignment",
            14: "   reserved for sae assignment",
            15: "             not available",
            2: "  full power steering equipment - the steering forces are provided solely by one or more energy supplies.",
            3: "  self tracking steering equipment - a system designed to create a change of steering angle on one or more wheels only when acted upon by forces and/or moments applied through the tire to road contact.",
            4: "   reserved for sae assignment",
            5: "   reserved for sae assignment",
            6: "   reserved for sae assignment",
            7: "   reserved for sae assignment",
            8: "   reserved for sae assignment",
            9: "   reserved for sae assignment"
        },
        2926: {
            0: "    purely mechanical steering transmission - a steering transmission in which the steering forces are transmitted entirely by mechanical means.",
            1: "    purely hydraulic steering transmission - a steering transmission in which the steering forces, somewhere in the transmission, are transmitted only by hydraulic means.",
            10: "   reserved for sae assignment",
            11: "   reserved for sae assignment",
            12: "   reserved for sae assignment",
            13: "   reserved for sae assignment",
            14: "   reserved for sae assignment",
            15: "             not available",
            2: "    purely electric steering transmission - a steering transmission in which the steering forces, somewhere in the transmission, are transmitted only through electric means.",
            3: "    hybrid steering transmission - a steering transmission in which part of the steering forces is transmitted through one and the other part through another of the above mentioned means.  however, in the case where any mechanical part of the transmission is designed only to give position feedback and is too weak to transmit the total sum of the steering forces, this system shall be considered to be purely hydraulic or purely electric steering transmission.",
            4: "   reserved for sae assignment",
            5: "   reserved for sae assignment",
            6: "   reserved for sae assignment",
            7: "   reserved for sae assignment",
            8: "   reserved for sae assignment",
            9: "   reserved for sae assignment"
        },
        2930: {
            0: "       audible warning off",
            1: "       audible warning on",
            2: "       reserved",
            3: "       don't care"
        },
        2931: {
            0: "      fluid level is not sufficient",
            1: "      fluid level is sufficient",
            2: "      error indicator",
            3: "      not available"
        },
        2932: {
            0: "            blocked",
            1: "            extend",
            10: "  reserved",
            11: "  reserved",
            12: "  reserved",
            13: "  reserved",
            14: "  reserved",
            15: "            don-t care",
            2: "            retract",
            3: "            floating",
            4: "  reserved",
            5: "  reserved",
            6: "  reserved",
            7: "  reserved",
            8: "  reserved",
            9: "  reserved"
        },
        2933: {
            0: "              block",
            1: "              extend",
            10: "    reserved",
            11: "    reserved",
            12: "    reserved",
            13: "    reserved",
            14: "    reserved",
            15: "              don-t care",
            2: "              retract",
            3: "              float",
            4: "    reserved",
            5: "    reserved",
            6: "    reserved",
            7: "    reserved",
            8: "    reserved",
            9: "    reserved"
        },
        2934: {
            0: " block",
            1: " float",
            2: " reserved",
            3: " don-t care"
        },
        2935: {
            0: " block",
            1: " float",
            2: " error",
            3: " not available"
        },
        2945: {
            0: "        primary shift console is active",
            1: "        secondary shift console is active",
            2: "        reserved",
            3: "        not available"
        },
        2970: {
            0: "    accelerator pedal 2 not in low idle condition",
            1: "    accelerator pedal 2 in low idle condition",
            2: "    error",
            3: "    not available"
        },
        2971: {
            0: "    accelerator pedal 3 not in low idle condition",
            1: "    accelerator pedal 3 in low idle condition",
            2: "    error",
            3: "    not available"
        },
        2979: {
            0: "     limit not active",
            1: "     limit active",
            2: "     reserved",
            3: "     not available"
        },
        2984: {
            0: "   disable automatic traction help ",
            1: "   enable automatic traction help ",
            2: "   reserved",
            3: "   don't care"
        },
        2985: {
            0: " off",
            1: " on",
            2: " error",
            3: " not available"
        },
        2992: {
            0: " stop",
            1: " move",
            2: " reserved",
            3: " don't care/take no action"
        },
        2993: {
            0: " stop",
            1: " move",
            2: " reserved",
            3: " don't care/take no action"
        },
        2994: {
            0: " stop",
            1: " raise",
            2: " reserved",
            3: " don't care/take no action"
        },
        2995: {
            0: " stop",
            1: " lower",
            2: " reserved",
            3: " don't care/take no action"
        },
        2996: {
            0: " stop",
            1: " raise",
            2: " reserved",
            3: " don't care/take no action"
        },
        2997: {
            0: " stop",
            1: " lower",
            2: " reserved",
            3: " don't care/take no action"
        },
        2998: {
            0: " stop",
            1: " raise",
            2: " reserved",
            3: " don't care/take no action"
        },
        2999: {
            0: " stop",
            1: " lower",
            2: " reserved",
            3: " don't care/take no action"
        },
        3000: {
            0: " stop",
            1: " tilt",
            2: " reserved",
            3: " don't care/take no action"
        },
        3001: {
            0: " stop",
            1: " tilt",
            2: " reserved",
            3: " don't care/take no action"
        },
        3002: {
            0: " stop ",
            1: " fold",
            2: " reserved",
            3: " don't care/take no action"
        },
        3003: {
            0: " stop",
            1: " unfold",
            2: " reserved",
            3: " don't care/take no action"
        },
        3004: {
            0: " stop ",
            1: " increase",
            2: " reserved",
            3: " don't care/take no action"
        },
        3005: {
            0: " stop",
            1: " decrease",
            2: " reserved",
            3: " don't care/take no action"
        },
        3006: {
            0: " stop ",
            1: " increase",
            2: " reserved",
            3: " don't care/take no action"
        },
        3007: {
            0: " stop",
            1: " decrease",
            2: " reserved",
            3: " don't care/take no action"
        },
        3008: {
            0: " stop ",
            1: " increase",
            2: " reserved",
            3: " don't care/take no action"
        },
        3009: {
            0: " stop",
            1: " decrease",
            2: " reserved",
            3: " don't care/take no action"
        },
        3010: {
            0: " stop ",
            1: " increase",
            2: " reserved",
            3: " don't care/take no action"
        },
        3011: {
            0: " stop",
            1: " decrease",
            2: " reserved",
            3: " don't care/take no action"
        },
        3012: {
            0: " stop ",
            1: " increase",
            2: " reserved",
            3: " don't care/take no action"
        },
        3013: {
            0: " stop",
            1: " decrease",
            2: " reserved",
            3: " don't care/take no action"
        },
        3015: {
            0: " stop",
            1: " move",
            2: " reserved",
            3: " don't care/take no action"
        },
        3016: {
            0: " stop",
            1: " move",
            2: " reserved",
            3: " don't care/take no action"
        },
        3017: {
            0: " stop",
            1: " raise",
            2: " reserved",
            3: " don't care/take no action"
        },
        3018: {
            0: " stop",
            1: " raise",
            2: " reserved",
            3: " don't care/take no action"
        },
        3019: {
            0: " disengage",
            1: " engage",
            2: " reserved",
            3: " don't care/take no action"
        },
        3020: {
            0: " disengage",
            1: " engage",
            2: " reserved",
            3: " don't care/take no action"
        },
        3021: {
            0: " not full",
            1: " full",
            2: " error",
            3: " not available"
        },
        3022: {
            0: " disable",
            1: " enable",
            2: " reserved",
            3: " don't care/take no action"
        },
        3023: {
            0: " not engaged",
            1: " engaged",
            2: " error",
            3: " not available"
        },
        3024: {
            0: " off",
            1: " on",
            2: " error",
            3: " not available"
        },
        3025: {
            0: " off",
            1: " on",
            2: " error",
            3: " not available"
        },
        3026: {
            0: " conditions valid for transmission oil level measurement",
            1: " conditions not valid - settling timer still counting down",
            10: " not defined",
            11: " not defined",
            12: " not defined",
            13: " conditions not valid - other",
            14: " error",
            15: " not available",
            2: " conditions not valid - transmission in gear",
            3: " conditions not valid - transmission fluid temperature too low",
            4: " conditions not valid - transmission fluid temperature too high",
            5: " conditions not valid - vehicle moving; output shaft speed too high",
            6: " conditions not valid - vehicle not level",
            7: " conditions not valid - engine speed too low",
            8: " conditions not valid - engine speed too high",
            9: " conditions not valid - no request for reading"
        },
        3028: {
            0: " less than 1 minute",
            1: " one minute",
            10: " ten minutes",
            11: " eleven minutes",
            12: " twelve minutes",
            13: " thirteen minutes",
            14: " error",
            15: " not available",
            2: " two minutes",
            3: " three minutes",
            4: " four minutes",
            5: " five minutes",
            6: " six minutes",
            7: " seven minutes",
            8: " eight minutes",
            9: " nine minutes"
        },
        3034: {
            0: "                                   reserved for sae assignment",
            1: "                                   request to clear/reset a specific previously active dtc",
            10: "                         reserved for sae assignment",
            100: "                       reserved for sae assignment",
            101: "                       reserved for sae assignment",
            102: "                       reserved for sae assignment",
            103: "                       reserved for sae assignment",
            104: "                       reserved for sae assignment",
            105: "                       reserved for sae assignment",
            106: "                       reserved for sae assignment",
            107: "                       reserved for sae assignment",
            108: "                       reserved for sae assignment",
            109: "                       reserved for sae assignment",
            11: "                         reserved for sae assignment",
            110: "                       reserved for sae assignment",
            111: "                       reserved for sae assignment",
            112: "                       reserved for sae assignment",
            113: "                       reserved for sae assignment",
            114: "                       reserved for sae assignment",
            115: "                       reserved for sae assignment",
            116: "                       reserved for sae assignment",
            117: "                       reserved for sae assignment",
            118: "                       reserved for sae assignment",
            119: "                       reserved for sae assignment",
            12: "                         reserved for sae assignment",
            120: "                       reserved for sae assignment",
            121: "                       reserved for sae assignment",
            122: "                       reserved for sae assignment",
            123: "                       reserved for sae assignment",
            124: "                       reserved for sae assignment",
            125: "                       reserved for sae assignment",
            126: "                       reserved for sae assignment",
            127: "                       reserved for sae assignment",
            128: "                       reserved for sae assignment",
            129: "                       reserved for sae assignment",
            13: "                         reserved for sae assignment",
            130: "                       reserved for sae assignment",
            131: "                       reserved for sae assignment",
            132: "                       reserved for sae assignment",
            133: "                       reserved for sae assignment",
            134: "                       reserved for sae assignment",
            135: "                       reserved for sae assignment",
            136: "                       reserved for sae assignment",
            137: "                       reserved for sae assignment",
            138: "                       reserved for sae assignment",
            139: "                       reserved for sae assignment",
            14: "                         reserved for sae assignment",
            140: "                       reserved for sae assignment",
            141: "                       reserved for sae assignment",
            142: "                       reserved for sae assignment",
            143: "                       reserved for sae assignment",
            144: "                       reserved for sae assignment",
            145: "                       reserved for sae assignment",
            146: "                       reserved for sae assignment",
            147: "                       reserved for sae assignment",
            148: "                       reserved for sae assignment",
            149: "                       reserved for sae assignment",
            15: "                         reserved for sae assignment",
            150: "                       reserved for sae assignment",
            151: "                       reserved for sae assignment",
            152: "                       reserved for sae assignment",
            153: "                       reserved for sae assignment",
            154: "                       reserved for sae assignment",
            155: "                       reserved for sae assignment",
            156: "                       reserved for sae assignment",
            157: "                       reserved for sae assignment",
            158: "                       reserved for sae assignment",
            159: "                       reserved for sae assignment",
            16: "                         reserved for sae assignment",
            160: "                       reserved for sae assignment",
            161: "                       reserved for sae assignment",
            162: "                       reserved for sae assignment",
            163: "                       reserved for sae assignment",
            164: "                       reserved for sae assignment",
            165: "                       reserved for sae assignment",
            166: "                       reserved for sae assignment",
            167: "                       reserved for sae assignment",
            168: "                       reserved for sae assignment",
            169: "                       reserved for sae assignment",
            17: "                                   request to clear/reset a specific active dtc",
            170: "                       reserved for sae assignment",
            171: "                       reserved for sae assignment",
            172: "                       reserved for sae assignment",
            173: "                       reserved for sae assignment",
            174: "                       reserved for sae assignment",
            175: "                       reserved for sae assignment",
            176: "                       reserved for sae assignment",
            177: "                       reserved for sae assignment",
            178: "                       reserved for sae assignment",
            179: "                       reserved for sae assignment",
            18: "                                   positive acknowledge of clear/reset of a specific active dtc",
            180: "                       reserved for sae assignment",
            181: "                       reserved for sae assignment",
            182: "                       reserved for sae assignment",
            183: "                       reserved for sae assignment",
            184: "                       reserved for sae assignment",
            185: "                       reserved for sae assignment",
            186: "                       reserved for sae assignment",
            187: "                       reserved for sae assignment",
            188: "                       reserved for sae assignment",
            189: "                       reserved for sae assignment",
            19: "                                   negative acknowledge of clear/reset of a specific active dtc",
            190: "                       reserved for sae assignment",
            191: "                       reserved for sae assignment",
            192: "                       reserved for sae assignment",
            193: "                       reserved for sae assignment",
            194: "                       reserved for sae assignment",
            195: "                       reserved for sae assignment",
            196: "                       reserved for sae assignment",
            197: "                       reserved for sae assignment",
            198: "                       reserved for sae assignment",
            199: "                       reserved for sae assignment",
            2: "                                   positive acknowledge of clear/reset of a specific previously active dtc",
            20: "                       reserved for sae assignment",
            200: "                       reserved for sae assignment",
            201: "                       reserved for sae assignment",
            202: "                       reserved for sae assignment",
            203: "                       reserved for sae assignment",
            204: "                       reserved for sae assignment",
            205: "                       reserved for sae assignment",
            206: "                       reserved for sae assignment",
            207: "                       reserved for sae assignment",
            208: "                       reserved for sae assignment",
            209: "                       reserved for sae assignment",
            21: "                       reserved for sae assignment",
            210: "                       reserved for sae assignment",
            211: "                       reserved for sae assignment",
            212: "                       reserved for sae assignment",
            213: "                       reserved for sae assignment",
            214: "                       reserved for sae assignment",
            215: "                       reserved for sae assignment",
            216: "                       reserved for sae assignment",
            217: "                       reserved for sae assignment",
            218: "                       reserved for sae assignment",
            219: "                       reserved for sae assignment",
            22: "                       reserved for sae assignment",
            220: "                       reserved for sae assignment",
            221: "                       reserved for sae assignment",
            222: "                       reserved for sae assignment",
            223: "                       reserved for sae assignment",
            224: "                       reserved for sae assignment",
            225: "                       reserved for sae assignment",
            226: "                       reserved for sae assignment",
            227: "                       reserved for sae assignment",
            228: "                       reserved for sae assignment",
            229: "                       reserved for sae assignment",
            23: "                       reserved for sae assignment",
            230: "                       reserved for sae assignment",
            231: "                       reserved for sae assignment",
            232: "                       reserved for sae assignment",
            233: "                       reserved for sae assignment",
            234: "                       reserved for sae assignment",
            235: "                       reserved for sae assignment",
            236: "                       reserved for sae assignment",
            237: "                       reserved for sae assignment",
            238: "                       reserved for sae assignment",
            239: "                       reserved for sae assignment",
            24: "                       reserved for sae assignment",
            240: "                       reserved for sae assignment",
            241: "                       reserved for sae assignment",
            242: "                       reserved for sae assignment",
            243: "                       reserved for sae assignment",
            244: "                       reserved for sae assignment",
            245: "                       reserved for sae assignment",
            246: "                       reserved for sae assignment",
            247: "                       reserved for sae assignment",
            248: "                       reserved for sae assignment",
            249: "                       reserved for sae assignment",
            25: "                       reserved for sae assignment",
            250: "                       reserved for sae assignment",
            251: "                       reserved for sae assignment",
            252: "                       reserved for sae assignment",
            253: "                       reserved for sae assignment",
            254: "                       reserved for sae assignment",
            255: "                                 not available",
            26: "                       reserved for sae assignment",
            27: "                       reserved for sae assignment",
            28: "                       reserved for sae assignment",
            29: "                       reserved for sae assignment",
            3: "                                   negative acknowledge of clear/reset of a specific previously active dtc",
            30: "                       reserved for sae assignment",
            31: "                       reserved for sae assignment",
            32: "                       reserved for sae assignment",
            33: "                       reserved for sae assignment",
            34: "                       reserved for sae assignment",
            35: "                       reserved for sae assignment",
            36: "                       reserved for sae assignment",
            37: "                       reserved for sae assignment",
            38: "                       reserved for sae assignment",
            39: "                       reserved for sae assignment",
            4: "                         reserved for sae assignment",
            40: "                       reserved for sae assignment",
            41: "                       reserved for sae assignment",
            42: "                       reserved for sae assignment",
            43: "                       reserved for sae assignment",
            44: "                       reserved for sae assignment",
            45: "                       reserved for sae assignment",
            46: "                       reserved for sae assignment",
            47: "                       reserved for sae assignment",
            48: "                       reserved for sae assignment",
            49: "                       reserved for sae assignment",
            5: "                         reserved for sae assignment",
            50: "                       reserved for sae assignment",
            51: "                       reserved for sae assignment",
            52: "                       reserved for sae assignment",
            53: "                       reserved for sae assignment",
            54: "                       reserved for sae assignment",
            55: "                       reserved for sae assignment",
            56: "                       reserved for sae assignment",
            57: "                       reserved for sae assignment",
            58: "                       reserved for sae assignment",
            59: "                       reserved for sae assignment",
            6: "                         reserved for sae assignment",
            60: "                       reserved for sae assignment",
            61: "                       reserved for sae assignment",
            62: "                       reserved for sae assignment",
            63: "                       reserved for sae assignment",
            64: "                       reserved for sae assignment",
            65: "                       reserved for sae assignment",
            66: "                       reserved for sae assignment",
            67: "                       reserved for sae assignment",
            68: "                       reserved for sae assignment",
            69: "                       reserved for sae assignment",
            7: "                         reserved for sae assignment",
            70: "                       reserved for sae assignment",
            71: "                       reserved for sae assignment",
            72: "                       reserved for sae assignment",
            73: "                       reserved for sae assignment",
            74: "                       reserved for sae assignment",
            75: "                       reserved for sae assignment",
            76: "                       reserved for sae assignment",
            77: "                       reserved for sae assignment",
            78: "                       reserved for sae assignment",
            79: "                       reserved for sae assignment",
            8: "                         reserved for sae assignment",
            80: "                       reserved for sae assignment",
            81: "                       reserved for sae assignment",
            82: "                       reserved for sae assignment",
            83: "                       reserved for sae assignment",
            84: "                       reserved for sae assignment",
            85: "                       reserved for sae assignment",
            86: "                       reserved for sae assignment",
            87: "                       reserved for sae assignment",
            88: "                       reserved for sae assignment",
            89: "                       reserved for sae assignment",
            9: "                         reserved for sae assignment",
            90: "                       reserved for sae assignment",
            91: "                       reserved for sae assignment",
            92: "                       reserved for sae assignment",
            93: "                       reserved for sae assignment",
            94: "                       reserved for sae assignment",
            95: "                       reserved for sae assignment",
            96: "                       reserved for sae assignment",
            97: "                       reserved for sae assignment",
            98: "                       reserved for sae assignment",
            99: "                       reserved for sae assignment"
        },
        3035: {
            0: "               general negative acknowledge",
            1: "               access denied (security denied access)",
            10: "   reserved for sae assignment",
            100: "   reserved for sae assignment",
            101: "   reserved for sae assignment",
            102: "   reserved for sae assignment",
            103: "   reserved for sae assignment",
            104: "   reserved for sae assignment",
            105: "   reserved for sae assignment",
            106: "   reserved for sae assignment",
            107: "   reserved for sae assignment",
            108: "   reserved for sae assignment",
            109: "   reserved for sae assignment",
            11: "   reserved for sae assignment",
            110: "   reserved for sae assignment",
            111: "   reserved for sae assignment",
            112: "   reserved for sae assignment",
            113: "   reserved for sae assignment",
            114: "   reserved for sae assignment",
            115: "   reserved for sae assignment",
            116: "   reserved for sae assignment",
            117: "   reserved for sae assignment",
            118: "   reserved for sae assignment",
            119: "   reserved for sae assignment",
            12: "   reserved for sae assignment",
            120: "   reserved for sae assignment",
            121: "   reserved for sae assignment",
            122: "   reserved for sae assignment",
            123: "   reserved for sae assignment",
            124: "   reserved for sae assignment",
            125: "   reserved for sae assignment",
            126: "   reserved for sae assignment",
            127: "   reserved for sae assignment",
            128: "   reserved for sae assignment",
            129: "   reserved for sae assignment",
            13: "   reserved for sae assignment",
            130: "   reserved for sae assignment",
            131: "   reserved for sae assignment",
            132: "   reserved for sae assignment",
            133: "   reserved for sae assignment",
            134: "   reserved for sae assignment",
            135: "   reserved for sae assignment",
            136: "   reserved for sae assignment",
            137: "   reserved for sae assignment",
            138: "   reserved for sae assignment",
            139: "   reserved for sae assignment",
            14: "   reserved for sae assignment",
            140: "   reserved for sae assignment",
            141: "   reserved for sae assignment",
            142: "   reserved for sae assignment",
            143: "   reserved for sae assignment",
            144: "   reserved for sae assignment",
            145: "   reserved for sae assignment",
            146: "   reserved for sae assignment",
            147: "   reserved for sae assignment",
            148: "   reserved for sae assignment",
            149: "   reserved for sae assignment",
            15: "   reserved for sae assignment",
            150: "   reserved for sae assignment",
            151: "   reserved for sae assignment",
            152: "   reserved for sae assignment",
            153: "   reserved for sae assignment",
            154: "   reserved for sae assignment",
            155: "   reserved for sae assignment",
            156: "   reserved for sae assignment",
            157: "   reserved for sae assignment",
            158: "   reserved for sae assignment",
            159: "   reserved for sae assignment",
            16: "   reserved for sae assignment",
            160: "   reserved for sae assignment",
            161: "   reserved for sae assignment",
            162: "   reserved for sae assignment",
            163: "   reserved for sae assignment",
            164: "   reserved for sae assignment",
            165: "   reserved for sae assignment",
            166: "   reserved for sae assignment",
            167: "   reserved for sae assignment",
            168: "   reserved for sae assignment",
            169: "   reserved for sae assignment",
            17: "   reserved for sae assignment",
            170: "   reserved for sae assignment",
            171: "   reserved for sae assignment",
            172: "   reserved for sae assignment",
            173: "   reserved for sae assignment",
            174: "   reserved for sae assignment",
            175: "   reserved for sae assignment",
            176: "   reserved for sae assignment",
            177: "   reserved for sae assignment",
            178: "   reserved for sae assignment",
            179: "   reserved for sae assignment",
            18: "   reserved for sae assignment",
            180: "   reserved for sae assignment",
            181: "   reserved for sae assignment",
            182: "   reserved for sae assignment",
            183: "   reserved for sae assignment",
            184: "   reserved for sae assignment",
            185: "   reserved for sae assignment",
            186: "   reserved for sae assignment",
            187: "   reserved for sae assignment",
            188: "   reserved for sae assignment",
            189: "   reserved for sae assignment",
            19: "   reserved for sae assignment",
            190: "   reserved for sae assignment",
            191: "   reserved for sae assignment",
            192: "   reserved for sae assignment",
            193: "   reserved for sae assignment",
            194: "   reserved for sae assignment",
            195: "   reserved for sae assignment",
            196: "   reserved for sae assignment",
            197: "   reserved for sae assignment",
            198: "   reserved for sae assignment",
            199: "   reserved for sae assignment",
            2: "               diagnostic trouble code unknown/does not exist",
            20: "   reserved for sae assignment",
            200: "   reserved for sae assignment",
            201: "   reserved for sae assignment",
            202: "   reserved for sae assignment",
            203: "   reserved for sae assignment",
            204: "   reserved for sae assignment",
            205: "   reserved for sae assignment",
            206: "   reserved for sae assignment",
            207: "   reserved for sae assignment",
            208: "   reserved for sae assignment",
            209: "   reserved for sae assignment",
            21: "   reserved for sae assignment",
            210: "   reserved for sae assignment",
            211: "   reserved for sae assignment",
            212: "   reserved for sae assignment",
            213: "   reserved for sae assignment",
            214: "   reserved for sae assignment",
            215: "   reserved for sae assignment",
            216: "   reserved for sae assignment",
            217: "   reserved for sae assignment",
            218: "   reserved for sae assignment",
            219: "   reserved for sae assignment",
            22: "   reserved for sae assignment",
            220: "   reserved for sae assignment",
            221: "   reserved for sae assignment",
            222: "   reserved for sae assignment",
            223: "   reserved for sae assignment",
            224: "   reserved for sae assignment",
            225: "   reserved for sae assignment",
            226: "   reserved for sae assignment",
            227: "   reserved for sae assignment",
            228: "   reserved for sae assignment",
            229: "   reserved for sae assignment",
            23: "   reserved for sae assignment",
            230: "   reserved for sae assignment",
            231: "   reserved for sae assignment",
            232: "   reserved for sae assignment",
            233: "   reserved for sae assignment",
            234: "   reserved for sae assignment",
            235: "   reserved for sae assignment",
            236: "   reserved for sae assignment",
            237: "   reserved for sae assignment",
            238: "   reserved for sae assignment",
            239: "   reserved for sae assignment",
            24: "   reserved for sae assignment",
            240: "   reserved for sae assignment",
            241: "   reserved for sae assignment",
            242: "   reserved for sae assignment",
            243: "   reserved for sae assignment",
            244: "   reserved for sae assignment",
            245: "   reserved for sae assignment",
            246: "   reserved for sae assignment",
            247: "   reserved for sae assignment",
            248: "   reserved for sae assignment",
            249: "   reserved for sae assignment",
            25: "   reserved for sae assignment",
            250: "   reserved for sae assignment",
            251: "   reserved for sae assignment",
            252: "   reserved for sae assignment",
            253: "   reserved for sae assignment",
            254: "   reserved for sae assignment",
            255: "             not available",
            26: "   reserved for sae assignment",
            27: "   reserved for sae assignment",
            28: "   reserved for sae assignment",
            29: "   reserved for sae assignment",
            3: "               diagnostic trouble code no longer previously active",
            30: "   reserved for sae assignment",
            31: "   reserved for sae assignment",
            32: "   reserved for sae assignment",
            33: "   reserved for sae assignment",
            34: "   reserved for sae assignment",
            35: "   reserved for sae assignment",
            36: "   reserved for sae assignment",
            37: "   reserved for sae assignment",
            38: "   reserved for sae assignment",
            39: "   reserved for sae assignment",
            4: "               diagnostic trouble code no longer active",
            40: "   reserved for sae assignment",
            41: "   reserved for sae assignment",
            42: "   reserved for sae assignment",
            43: "   reserved for sae assignment",
            44: "   reserved for sae assignment",
            45: "   reserved for sae assignment",
            46: "   reserved for sae assignment",
            47: "   reserved for sae assignment",
            48: "   reserved for sae assignment",
            49: "   reserved for sae assignment",
            5: "   reserved for sae assignment",
            50: "   reserved for sae assignment",
            51: "   reserved for sae assignment",
            52: "   reserved for sae assignment",
            53: "   reserved for sae assignment",
            54: "   reserved for sae assignment",
            55: "   reserved for sae assignment",
            56: "   reserved for sae assignment",
            57: "   reserved for sae assignment",
            58: "   reserved for sae assignment",
            59: "   reserved for sae assignment",
            6: "   reserved for sae assignment",
            60: "   reserved for sae assignment",
            61: "   reserved for sae assignment",
            62: "   reserved for sae assignment",
            63: "   reserved for sae assignment",
            64: "   reserved for sae assignment",
            65: "   reserved for sae assignment",
            66: "   reserved for sae assignment",
            67: "   reserved for sae assignment",
            68: "   reserved for sae assignment",
            69: "   reserved for sae assignment",
            7: "   reserved for sae assignment",
            70: "   reserved for sae assignment",
            71: "   reserved for sae assignment",
            72: "   reserved for sae assignment",
            73: "   reserved for sae assignment",
            74: "   reserved for sae assignment",
            75: "   reserved for sae assignment",
            76: "   reserved for sae assignment",
            77: "   reserved for sae assignment",
            78: "   reserved for sae assignment",
            79: "   reserved for sae assignment",
            8: "   reserved for sae assignment",
            80: "   reserved for sae assignment",
            81: "   reserved for sae assignment",
            82: "   reserved for sae assignment",
            83: "   reserved for sae assignment",
            84: "   reserved for sae assignment",
            85: "   reserved for sae assignment",
            86: "   reserved for sae assignment",
            87: "   reserved for sae assignment",
            88: "   reserved for sae assignment",
            89: "   reserved for sae assignment",
            9: "   reserved for sae assignment",
            90: "   reserved for sae assignment",
            91: "   reserved for sae assignment",
            92: "   reserved for sae assignment",
            93: "   reserved for sae assignment",
            94: "   reserved for sae assignment",
            95: "   reserved for sae assignment",
            96: "   reserved for sae assignment",
            97: "   reserved for sae assignment",
            98: "   reserved for sae assignment",
            99: "   reserved for sae assignment"
        },
        3038: {
            0: "slow flash (1 hz, 50 % duty cycle)",
            1: "fast flash (2 hz or faster, 50% duty cycle)",
            2: "class c dtc  ",
            3: "unavailable / do not flash"
        },
        3039: {
            0: "slow flash (1 hz, 50 % duty cycle)",
            1: "fast flash (2 hz or faster, 50% duty cycle)",
            2: "reserved",
            3: "unavailable / do not flash"
        },
        3040: {
            0: "slow flash (1 hz, 50 % duty cycle)",
            1: "fast flash (2 hz or faster, 50% duty cycle)",
            2: "reserved",
            3: "unavailable / do not flash"
        },
        3041: {
            0: "slow flash (1 hz, 50 % duty cycle)",
            1: "fast flash (2 hz or faster, 50% duty cycle)",
            2: "reserved",
            3: "unavailable / do not flash"
        },
        3043: {
            0: "absolute passenger count",
            1: "boarding passenger",
            2: "exiting passenger",
            251: " to 253 - reserved",
            254: "error indicator",
            255: "not available",
            3: "boarding passenger (second passenger stream)",
            4: "exiting passenger (second passenger stream)",
            5: " to 250 - reserved for future assignment"
        },
        3044: {
            0: "off",
            1: "on",
            2: "error condition",
            3: "not available"
        },
        3045: {
            0: "normal use",
            1: "unauthorized use",
            2: "error condition",
            3: "not available"
        },
        3046: {
            0: "off",
            1: "on",
            2: "error condition",
            3: "not available"
        },
        3079: {
            0: "message is a request directed to the emitter",
            1: "message is a response from the emitter",
            2: "error condition",
            3: "not available"
        },
        3080: {
            0: "transit route id not used for interleaved data",
            1: "transit route id used for interleaved data (if range code not enabled)",
            2: "error condition",
            3: "not available"
        },
        3081: {
            0: "range code not used for interleaved data",
            1: "range code used for interleaved data",
            2: "error condition",
            3: "not available"
        },
        3082: {
            0: "deactivate strobe",
            1: "activate strobe",
            2: "error condition",
            3: "not available"
        },
        3083: {
            0: "ignore transit door status",
            1: "transit door status will override strobe activation",
            2: "error condition",
            3: "not available"
        },
        3084: {
            0: "reserved",
            1: "low priority",
            10: "priority set by hardware to probe priority",
            11: "priority set by hardware to high priority",
            12: " to 1101 - reserved",
            14: "error condition",
            15: "not available",
            2: "probe priority",
            3: "high priority",
            4: " to 1000 - reserved",
            9: "priority set by hardware to low priority"
        },
        3086: {
            0: "transmission not ready for brake release",
            1: "transmission ready for brake release",
            2: "error",
            3: "not available"
        },
        3102: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3103: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3104: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3105: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3106: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3107: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3108: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3109: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3110: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3111: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3112: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3113: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3114: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3115: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3116: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3117: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3118: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3119: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3120: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3121: {
            0: "    off",
            1: "    on",
            2: "    reserved",
            3: "    don't care/take no action"
        },
        3156: {
            0: " no button pressed",
            1: ".   the switch state can be read in two ways.  one method uses the direct analog switch input to determine the switch state, while the second method relies on a secondary control to read the analog input, then relay the information on the data link.  the parameter is designed to provide the actual switch state to other controls that need the information.",
            10: " manual button pressed",
            11: " automatic button pressed",
            1110: " error indicator",
            1111: " not installed",
            2: ".   other systems with automated blade controls should be able to use this parameter, since it is a measured switch value.",
            3: ".    the momentary contact button pair may be used, where the default is no buttons being pressed.  the user can press the manual button, and when pressure is released, it will return to the no button pressed position.  the user may press the auto button, and when pressure is released, it will return to the no button pressed position.  momentary contact buttons (button pair) usage is as follows:",
            4: ".    the momentary contact single button may be used, where the default is no button being pressed.  the user can press the button, which is the button pressed position, and when pressure is released, it will return to the no button pressed position.  the controller receiving this command will keep track of what mode the blade is in, auto or manual.  when the button is pressed, the \"mode button pressed\" state is reported and the receiving controller then changes the current mode to its opposite value (i.e. manual to automatic or vise-versa).  momentary contact button (single button) usage is as follows:"
        },
        3157: {
            0: " no button pressed",
            1: ".   the switch state can be read in two ways.  one method uses the direct analog switch input to determine the switch state, while the second method relies on a secondary control to read the analog input, then relay the information on the data link.  the parameter is designed to provide the actual switch state to other controls that need the information.",
            10: " decrement button pressed",
            1110: " error indicator",
            1111: " not installed",
            2: ".   other systems with automated blade controls should be able to use this parameter, since it is a measured switch value."
        },
        3158: {
            0: " auto allowed",
            1: " activity allows auto - must detect operator before auto allowed",
            14: " error indicator",
            15: " not supported",
            2: " suspend auto - temporarily suspend auto mode",
            3: " service mode - auto allowed only during service modes",
            4: " auto not allowed"
        },
        3170: {
            0: "cash",
            1: "token",
            10: "reserved for assignment",
            11: "reserved for assignment",
            12: "agency defined",
            13: "agency defined",
            14: "agency defined",
            15: "agency defined",
            2: "ticket",
            3: "pass",
            4: "card",
            5: "permit",
            6: "transfer",
            7: "free",
            8: "reserved for assignment",
            9: "reserved for assignment"
        },
        3172: {
            0: "local service",
            1: "express service",
            2: "agency defined",
            3: "agency defined",
            4: "agency defined",
            5: "agency defined",
            6: "agency defined",
            7: "agency defined"
        },
        3173: {
            0: "north",
            1: "south",
            10: "agency defined",
            11: "agency defined",
            12: "agency defined",
            13: "agency defined",
            14: "agency defined",
            15: "agency defined",
            16: "agency defined",
            17: "agency defined",
            18: "agency defined",
            19: "agency defined",
            2: "east",
            20: "agency defined",
            21: "agency defined",
            22: "agency defined",
            23: "agency defined",
            24: "agency defined",
            25: "agency defined",
            26: "agency defined",
            27: "agency defined",
            28: "agency defined",
            29: "agency defined",
            3: "west",
            30: "agency defined",
            31: "agency defined",
            4: "in",
            5: "out",
            6: "agency defined",
            7: "agency defined",
            8: "agency defined",
            9: "agency defined"
        },
        3174: {
            0: "north",
            1: "south",
            10: "agency defined",
            11: "agency defined",
            12: "agency defined",
            13: "agency defined",
            14: "agency defined",
            15: "agency defined",
            2: "east",
            3: "west",
            4: "in",
            5: "out",
            6: "agency defined",
            7: "agency defined",
            8: "agency defined",
            9: "agency defined"
        },
        3175: {
            0: " to 00001111 = agency defined",
            16: " to 11111111 = reserved for assignment"
        },
        3176: {
            0: "cash/no detail",
            1: "token a",
            10: "reserved for assignment",
            11: "agency defined",
            12: "agency defined",
            13: "agency defined",
            14: "agency defined",
            15: "agency defined",
            2: "token b",
            3: "ticket a",
            4: "ticket b",
            5: "pass a",
            6: "pass b",
            7: "reserved for assignment",
            8: "reserved for assignment",
            9: "reserved for assignment"
        },
        3177: {
            0: "not an upgrade",
            1: "cash",
            10: "reserved for assignment",
            11: "agency defined",
            12: "agency defined",
            13: "agency defined",
            14: "agency defined",
            15: "agency defined",
            2: "token",
            3: "ticket",
            4: "pass",
            5: "card",
            6: "reserved for assignment",
            7: "reserved for assignment",
            8: "reserved for assignment",
            9: "reserved for assignment"
        },
        3178: {
            0: "farebox out of service",
            1: "farebox in service",
            2: "error condition",
            3: "not available"
        },
        3179: {
            0: "non-emergency condition",
            1: "emergency condition",
            2: "error condition",
            3: "not available"
        },
        3180: {
            0: "undefined",
            1: "trip start",
            2: "trip end",
            3: "undefined",
            4: "undefined",
            5: "layover start",
            6: "layover end",
            7: "undefined"
        },
        3181: {
            0: "voltage dropout",
            1: "voltage restored",
            10: "coinbox full",
            100: "agency defined",
            101: "agency defined",
            102: "agency defined",
            103: "agency defined",
            104: "agency defined",
            105: "agency defined",
            106: "agency defined",
            107: "agency defined",
            108: "agency defined",
            109: "agency defined",
            11: "currency box 75% full",
            110: "agency defined",
            111: "agency defined",
            112: "agency defined",
            113: "agency defined",
            114: "agency defined",
            115: "agency defined",
            116: "agency defined",
            117: "agency defined",
            118: "agency defined",
            119: "agency defined",
            12: "currency box less than 75% full",
            120: "agency defined",
            121: "agency defined",
            122: "agency defined",
            123: "agency defined",
            124: "agency defined",
            125: "agency defined",
            126: "agency defined",
            127: "agency defined",
            13: "currency box full",
            14: "card/pass box 75% full",
            15: "card/pass box less than 75% full",
            16: "card/pass box full",
            17: "coin de-jam operated",
            18: "farebox set in manual bypass",
            19: "farebox reset to automatic mode",
            2: "probe started",
            20: "pass/transfer jam",
            21: "pass/transfer jam cleared",
            22: "paper currency jam",
            23: "paper currency jam cleared",
            24: "maintenance access in service, considered an alarm condition",
            25: "maintenance access out of service",
            26: "reserved - to be assigned",
            27: "reserved - to be assigned",
            28: "reserved - to be assigned",
            29: "reserved - to be assigned",
            3: "probe completed",
            30: "reserved - to be assigned",
            31: "reserved - to be assigned",
            32: "reserved - to be assigned",
            33: "reserved - to be assigned",
            34: "reserved - to be assigned",
            35: "reserved - to be assigned",
            36: "reserved - to be assigned",
            37: "reserved - to be assigned",
            38: "reserved - to be assigned",
            39: "reserved - to be assigned",
            4: "cashbox removed",
            40: "reserved - to be assigned",
            41: "reserved - to be assigned",
            42: "reserved - to be assigned",
            43: "reserved - to be assigned",
            44: "reserved - to be assigned",
            45: "reserved - to be assigned",
            46: "reserved - to be assigned",
            47: "reserved - to be assigned",
            48: "reserved - to be assigned",
            49: "reserved - to be assigned",
            5: "cashbox restored",
            50: "reserved - to be assigned",
            51: "reserved - to be assigned",
            52: "reserved - to be assigned",
            53: "reserved - to be assigned",
            54: "reserved - to be assigned",
            55: "reserved - to be assigned",
            56: "reserved - to be assigned",
            57: "reserved - to be assigned",
            58: "reserved - to be assigned",
            59: "reserved - to be assigned",
            6: "cashbox door timeout",
            60: "reserved - to be assigned",
            61: "reserved - to be assigned",
            62: "reserved - to be assigned",
            63: "reserved - to be assigned",
            64: "reserved - to be assigned",
            65: "reserved - to be assigned",
            66: "reserved - to be assigned",
            67: "reserved - to be assigned",
            68: "reserved - to be assigned",
            69: "reserved - to be assigned",
            7: "cashbox opened in service, considered an alarm condition",
            70: "reserved - to be assigned",
            71: "reserved - to be assigned",
            72: "reserved - to be assigned",
            73: "reserved - to be assigned",
            74: "reserved - to be assigned",
            75: "reserved - to be assigned",
            76: "reserved - to be assigned",
            77: "reserved - to be assigned",
            78: "reserved - to be assigned",
            79: "reserved - to be assigned",
            8: "insufficient fare accepted",
            80: "reserved - to be assigned",
            81: "reserved - to be assigned",
            82: "reserved - to be assigned",
            83: "reserved - to be assigned",
            84: "reserved - to be assigned",
            85: "reserved - to be assigned",
            86: "reserved - to be assigned",
            87: "reserved - to be assigned",
            88: "reserved - to be assigned",
            89: "reserved - to be assigned",
            9: "coinbox 75% full",
            90: "reserved - to be assigned",
            91: "reserved - to be assigned",
            92: "reserved - to be assigned",
            93: "reserved - to be assigned",
            94: "reserved - to be assigned",
            95: "reserved - to be assigned",
            96: "reserved - to be assigned",
            97: "agency defined",
            98: "agency defined",
            99: "agency defined"
        },
        3215: {
            0: " no request ",
            1: " request prohibit air suspension control ",
            2: " error indicator ",
            3: " not available"
        },
        3218: {
            0: "not in range",
            1: "in range",
            2: "error",
            3: "not available"
        },
        3219: {
            0: "not in range",
            1: "in range",
            2: "error",
            3: "not available"
        },
        3220: {
            0: "not stable",
            1: "stable",
            2: "error",
            3: "not available"
        },
        3221: {
            0: "not stable",
            1: "stable",
            2: "error",
            3: "not available"
        },
        3223: {
            0: "automatic",
            1: "preheat 2",
            2: "preheat 1",
            3: "heater off"
        },
        3228: {
            0: "not in range",
            1: "in range",
            2: "error",
            3: "not available"
        },
        3229: {
            0: "not in range",
            1: "in range",
            2: "error",
            3: "not available"
        },
        3230: {
            0: "not stable",
            1: "stable",
            2: "error",
            3: "not available"
        },
        3231: {
            0: "not stable",
            1: "stable",
            2: "error",
            3: "not available"
        },
        3233: {
            0: "automatic",
            1: "preheat 2",
            2: "preheat 1",
            3: "heater off"
        },
        3237: {
            0: "not exceeded the dew point",
            1: "exceeded the dew point",
            2: "error",
            3: "not available"
        },
        3238: {
            0: "not exceeded the dew point",
            1: "exceeded the dew point",
            2: "error",
            3: "not available"
        },
        3239: {
            0: "not exceeded the dew point",
            1: "exceeded the dew point",
            2: "error",
            3: "not available"
        },
        3240: {
            0: "not exceeded the dew point",
            1: "exceeded the dew point",
            2: "error",
            3: "not available"
        },
        3257: {
            0: "not in range",
            1: "in range",
            2: "error",
            3: "not available"
        },
        3258: {
            0: "not in range",
            1: "in range",
            2: "error",
            3: "not available"
        },
        3259: {
            0: "not stable",
            1: "stable",
            2: "error",
            3: "not available"
        },
        3260: {
            0: "not stable",
            1: "stable",
            2: "error",
            3: "not available"
        },
        3262: {
            0: "automatic",
            1: "preheat 2",
            2: "preheat 1",
            3: "heater off"
        },
        3267: {
            0: "not in range",
            1: "in range",
            2: "error",
            3: "not available"
        },
        3268: {
            0: "not in range",
            1: "in range",
            2: "error",
            3: "not available"
        },
        3269: {
            0: "not stable",
            1: "stable",
            2: "error",
            3: "not available"
        },
        3270: {
            0: "not stable",
            1: "stable",
            2: "error",
            3: "not available"
        },
        3272: {
            0: "automatic",
            1: "preheat 2",
            2: "preheat 1",
            3: "heater off"
        },
        3307: {
            0: "    0 - improper couple",
            1: "    1 - locks closed / no kingpin at startup",
            10: "    10 - not used",
            11: "    11 - not used",
            12: "    12 - not used",
            13: "    13 - not used",
            14: "    14 - not used",
            15: "    15 - not available",
            2: "    2 - kingpin / locks open at startup",
            3: "    3 - not used",
            4: "    4 - not used",
            5: "    5 - coupling sequence error",
            6: "    6 - coupling sequence error / kingpin",
            7: "    7 - coupling timing error",
            8: "    8 - kingpin missing more than 5 seconds",
            9: "    9 - kingpin / lock open (handle pulled)"
        },
        3312: {
            0: "   lock not open, not ready to couple",
            1: "   lock open, ready to couple",
            2: "   error",
            3: "   not available"
        },
        3313: {
            0: "   incomplete or bad couple, truck should not be moved",
            1: "   successful couple detected",
            2: "   error",
            3: "   not available"
        },
        3314: {
            0: "   coupler locked",
            1: "   coupler unlocked, trailer can be unhitched or hitched",
            2: "   error",
            3: "   not available"
        },
        3315: {
            0: "    fifth wheel release disabled",
            1: "    fifth wheel release enabled",
            2: "    error   ",
            3: "    not available"
        },
        3316: {
            0: " not locked",
            1: " locked",
            2: " error",
            3: " not available"
        },
        3317: {
            0: " limit not exceeded",
            1: " limit exceeded",
            2: " error",
            3: " not available"
        },
        3323: {
            0: "           1  pitch angle degraded.  data is suspect due to environmental conditions.",
            1: "           1  not available"
        },
        3324: {
            0: "        1  roll angle degraded.  data is suspect due to environmental conditions.",
            1: "        1  not available"
        },
        3325: {
            0: "        1  pitch rate degraded.  data is suspect due to environmental conditions.",
            1: "        1  not available"
        },
        3326: {
            0: "        1   compensation on",
            1: "        1   not available"
        },
        3332: {
            0: "  blade rotation angle fully functional.  data is within sensor specification.   ",
            1: "  blade rotation angle  degraded.  data is suspect due to environmental conditions.",
            2: "  blade rotation angle failed.  roll sensor failed to operate correctly.",
            3: "  blade rotation angle not available"
        },
        3334: {
            0: "    no change",
            1: ".  the operator control state can be read in two ways.  one method uses the direct operator control input to determine the operator control state, while the second method relies on a secondary control to read the operator control input, then relay the information on the data link.  the parameter is designed to provide the actual operator control state to other controls that need the information.",
            10: "    manual operator control request",
            11: "    automatic operator control request",
            1100: "   reserved",
            1101: "   reserved",
            1110: "    error indicator",
            1111: "    not installed",
            2: ".  other systems with automated blade controls should be able to use this parameter, since it is an actual operator control value.",
            3: ".  the momentary contact button pair may be used, where the default is no buttons being pressed.  the user can press the manual button, and when pressure is released, it will return to the no button pressed position.  the user may press the auto button, and when pressure is released, it will return to the no button pressed position.",
            4: ".  the momentary contact single button may be used, where the default is no button being pressed.  the user can press the button, which is the button pressed position, and when pressure is released, it will return to the no button pressed position.  the controller receiving this command will keep track of what mode the blade is in, auto or manual.  if the blade is in manual mode to begin with, one press of the button will change to mode to auto.  if the button is pressed again, the blade will be put into manual mode."
        },
        3335: {
            0: "    no change",
            1: "    momentary operator control request",
            10: "    manual operator control request",
            11: "    automatic operator control request",
            1110: "    error indicator",
            1111: "    not installed",
            2: ". the momentary rocker switch may be used, where the default is the no button pressed position.  the user can press the rocker into the manual position, and when pressure is released, it will return to the no button pressed position.  the user may also press the rocker into the auto position, and when pressure is released, it will return to the no button pressed position.",
            3: ".  the momentary contact button pair may be used, where the default is no buttons being pressed.  the user can press the manual button, and when pressure is released, it will return to the no button pressed position.  the user may press the auto button, and when pressure is released, it will return to the no button pressed position.",
            4: ".  the momentary contact single button may be used, where the default is no button being pressed.  the user can press the button, which is the button pressed position, and when pressure is released, it will return to the no button pressed position.  the controller receiving this command will keep track of what mode the blade is in, auto or manual.  if the blade is in manual mode to begin with, one press of the button will change to mode to auto.  if the button is pressed again, the blade will be put into manual mode."
        },
        3336: {
            0: " no operator control request",
            1: ".  the operator control state can be read in two ways.  one method uses the direct operator control input to determine the operator control state, while the second method relies on a secondary control to read the operator control input, then relay the information on the data link.  the parameter is designed to provide the actual operator control state to other controls that need the information.",
            10: " decrement operator control request",
            100: "  reserved",
            1000: "  reserved",
            1001: "  reserved",
            1002: "  reserved",
            1003: "  reserved",
            1004: "  reserved",
            1005: "  reserved",
            1006: "  reserved",
            1007: "  reserved",
            1008: "  reserved",
            1009: "  reserved",
            101: "  reserved",
            1010: "  reserved",
            1011: "  reserved",
            1012: "  reserved",
            1013: "  reserved",
            1014: "  reserved",
            1015: "  reserved",
            1016: "  reserved",
            1017: "  reserved",
            1018: "  reserved",
            1019: "  reserved",
            102: "  reserved",
            1020: "  reserved",
            1021: "  reserved",
            1022: "  reserved",
            1023: "  reserved",
            1024: "  reserved",
            1025: "  reserved",
            1026: "  reserved",
            1027: "  reserved",
            1028: "  reserved",
            1029: "  reserved",
            103: "  reserved",
            1030: "  reserved",
            1031: "  reserved",
            1032: "  reserved",
            1033: "  reserved",
            1034: "  reserved",
            1035: "  reserved",
            1036: "  reserved",
            1037: "  reserved",
            1038: "  reserved",
            1039: "  reserved",
            104: "  reserved",
            1040: "  reserved",
            1041: "  reserved",
            1042: "  reserved",
            1043: "  reserved",
            1044: "  reserved",
            1045: "  reserved",
            1046: "  reserved",
            1047: "  reserved",
            1048: "  reserved",
            1049: "  reserved",
            105: "  reserved",
            1050: "  reserved",
            1051: "  reserved",
            1052: "  reserved",
            1053: "  reserved",
            1054: "  reserved",
            1055: "  reserved",
            1056: "  reserved",
            1057: "  reserved",
            1058: "  reserved",
            1059: "  reserved",
            106: "  reserved",
            1060: "  reserved",
            1061: "  reserved",
            1062: "  reserved",
            1063: "  reserved",
            1064: "  reserved",
            1065: "  reserved",
            1066: "  reserved",
            1067: "  reserved",
            1068: "  reserved",
            1069: "  reserved",
            107: "  reserved",
            1070: "  reserved",
            1071: "  reserved",
            1072: "  reserved",
            1073: "  reserved",
            1074: "  reserved",
            1075: "  reserved",
            1076: "  reserved",
            1077: "  reserved",
            1078: "  reserved",
            1079: "  reserved",
            108: "  reserved",
            1080: "  reserved",
            1081: "  reserved",
            1082: "  reserved",
            1083: "  reserved",
            1084: "  reserved",
            1085: "  reserved",
            1086: "  reserved",
            1087: "  reserved",
            1088: "  reserved",
            1089: "  reserved",
            109: "  reserved",
            1090: "  reserved",
            1091: "  reserved",
            1092: "  reserved",
            1093: "  reserved",
            1094: "  reserved",
            1095: "  reserved",
            1096: "  reserved",
            1097: "  reserved",
            1098: "  reserved",
            1099: "  reserved",
            11: "  reserved",
            110: "  reserved",
            1100: "  reserved",
            1101: "  reserved",
            111: "  reserved",
            1110: " error indicator",
            1111: " not installed",
            112: "  reserved",
            113: "  reserved",
            114: "  reserved",
            115: "  reserved",
            116: "  reserved",
            117: "  reserved",
            118: "  reserved",
            119: "  reserved",
            12: "  reserved",
            120: "  reserved",
            121: "  reserved",
            122: "  reserved",
            123: "  reserved",
            124: "  reserved",
            125: "  reserved",
            126: "  reserved",
            127: "  reserved",
            128: "  reserved",
            129: "  reserved",
            13: "  reserved",
            130: "  reserved",
            131: "  reserved",
            132: "  reserved",
            133: "  reserved",
            134: "  reserved",
            135: "  reserved",
            136: "  reserved",
            137: "  reserved",
            138: "  reserved",
            139: "  reserved",
            14: "  reserved",
            140: "  reserved",
            141: "  reserved",
            142: "  reserved",
            143: "  reserved",
            144: "  reserved",
            145: "  reserved",
            146: "  reserved",
            147: "  reserved",
            148: "  reserved",
            149: "  reserved",
            15: "  reserved",
            150: "  reserved",
            151: "  reserved",
            152: "  reserved",
            153: "  reserved",
            154: "  reserved",
            155: "  reserved",
            156: "  reserved",
            157: "  reserved",
            158: "  reserved",
            159: "  reserved",
            16: "  reserved",
            160: "  reserved",
            161: "  reserved",
            162: "  reserved",
            163: "  reserved",
            164: "  reserved",
            165: "  reserved",
            166: "  reserved",
            167: "  reserved",
            168: "  reserved",
            169: "  reserved",
            17: "  reserved",
            170: "  reserved",
            171: "  reserved",
            172: "  reserved",
            173: "  reserved",
            174: "  reserved",
            175: "  reserved",
            176: "  reserved",
            177: "  reserved",
            178: "  reserved",
            179: "  reserved",
            18: "  reserved",
            180: "  reserved",
            181: "  reserved",
            182: "  reserved",
            183: "  reserved",
            184: "  reserved",
            185: "  reserved",
            186: "  reserved",
            187: "  reserved",
            188: "  reserved",
            189: "  reserved",
            19: "  reserved",
            190: "  reserved",
            191: "  reserved",
            192: "  reserved",
            193: "  reserved",
            194: "  reserved",
            195: "  reserved",
            196: "  reserved",
            197: "  reserved",
            198: "  reserved",
            199: "  reserved",
            2: ".  other systems with automated blade controls should be able to use this parameter, since it is an actual operator control value.",
            20: "  reserved",
            200: "  reserved",
            201: "  reserved",
            202: "  reserved",
            203: "  reserved",
            204: "  reserved",
            205: "  reserved",
            206: "  reserved",
            207: "  reserved",
            208: "  reserved",
            209: "  reserved",
            21: "  reserved",
            210: "  reserved",
            211: "  reserved",
            212: "  reserved",
            213: "  reserved",
            214: "  reserved",
            215: "  reserved",
            216: "  reserved",
            217: "  reserved",
            218: "  reserved",
            219: "  reserved",
            22: "  reserved",
            220: "  reserved",
            221: "  reserved",
            222: "  reserved",
            223: "  reserved",
            224: "  reserved",
            225: "  reserved",
            226: "  reserved",
            227: "  reserved",
            228: "  reserved",
            229: "  reserved",
            23: "  reserved",
            230: "  reserved",
            231: "  reserved",
            232: "  reserved",
            233: "  reserved",
            234: "  reserved",
            235: "  reserved",
            236: "  reserved",
            237: "  reserved",
            238: "  reserved",
            239: "  reserved",
            24: "  reserved",
            240: "  reserved",
            241: "  reserved",
            242: "  reserved",
            243: "  reserved",
            244: "  reserved",
            245: "  reserved",
            246: "  reserved",
            247: "  reserved",
            248: "  reserved",
            249: "  reserved",
            25: "  reserved",
            250: "  reserved",
            251: "  reserved",
            252: "  reserved",
            253: "  reserved",
            254: "  reserved",
            255: "  reserved",
            256: "  reserved",
            257: "  reserved",
            258: "  reserved",
            259: "  reserved",
            26: "  reserved",
            260: "  reserved",
            261: "  reserved",
            262: "  reserved",
            263: "  reserved",
            264: "  reserved",
            265: "  reserved",
            266: "  reserved",
            267: "  reserved",
            268: "  reserved",
            269: "  reserved",
            27: "  reserved",
            270: "  reserved",
            271: "  reserved",
            272: "  reserved",
            273: "  reserved",
            274: "  reserved",
            275: "  reserved",
            276: "  reserved",
            277: "  reserved",
            278: "  reserved",
            279: "  reserved",
            28: "  reserved",
            280: "  reserved",
            281: "  reserved",
            282: "  reserved",
            283: "  reserved",
            284: "  reserved",
            285: "  reserved",
            286: "  reserved",
            287: "  reserved",
            288: "  reserved",
            289: "  reserved",
            29: "  reserved",
            290: "  reserved",
            291: "  reserved",
            292: "  reserved",
            293: "  reserved",
            294: "  reserved",
            295: "  reserved",
            296: "  reserved",
            297: "  reserved",
            298: "  reserved",
            299: "  reserved",
            30: "  reserved",
            300: "  reserved",
            301: "  reserved",
            302: "  reserved",
            303: "  reserved",
            304: "  reserved",
            305: "  reserved",
            306: "  reserved",
            307: "  reserved",
            308: "  reserved",
            309: "  reserved",
            31: "  reserved",
            310: "  reserved",
            311: "  reserved",
            312: "  reserved",
            313: "  reserved",
            314: "  reserved",
            315: "  reserved",
            316: "  reserved",
            317: "  reserved",
            318: "  reserved",
            319: "  reserved",
            32: "  reserved",
            320: "  reserved",
            321: "  reserved",
            322: "  reserved",
            323: "  reserved",
            324: "  reserved",
            325: "  reserved",
            326: "  reserved",
            327: "  reserved",
            328: "  reserved",
            329: "  reserved",
            33: "  reserved",
            330: "  reserved",
            331: "  reserved",
            332: "  reserved",
            333: "  reserved",
            334: "  reserved",
            335: "  reserved",
            336: "  reserved",
            337: "  reserved",
            338: "  reserved",
            339: "  reserved",
            34: "  reserved",
            340: "  reserved",
            341: "  reserved",
            342: "  reserved",
            343: "  reserved",
            344: "  reserved",
            345: "  reserved",
            346: "  reserved",
            347: "  reserved",
            348: "  reserved",
            349: "  reserved",
            35: "  reserved",
            350: "  reserved",
            351: "  reserved",
            352: "  reserved",
            353: "  reserved",
            354: "  reserved",
            355: "  reserved",
            356: "  reserved",
            357: "  reserved",
            358: "  reserved",
            359: "  reserved",
            36: "  reserved",
            360: "  reserved",
            361: "  reserved",
            362: "  reserved",
            363: "  reserved",
            364: "  reserved",
            365: "  reserved",
            366: "  reserved",
            367: "  reserved",
            368: "  reserved",
            369: "  reserved",
            37: "  reserved",
            370: "  reserved",
            371: "  reserved",
            372: "  reserved",
            373: "  reserved",
            374: "  reserved",
            375: "  reserved",
            376: "  reserved",
            377: "  reserved",
            378: "  reserved",
            379: "  reserved",
            38: "  reserved",
            380: "  reserved",
            381: "  reserved",
            382: "  reserved",
            383: "  reserved",
            384: "  reserved",
            385: "  reserved",
            386: "  reserved",
            387: "  reserved",
            388: "  reserved",
            389: "  reserved",
            39: "  reserved",
            390: "  reserved",
            391: "  reserved",
            392: "  reserved",
            393: "  reserved",
            394: "  reserved",
            395: "  reserved",
            396: "  reserved",
            397: "  reserved",
            398: "  reserved",
            399: "  reserved",
            40: "  reserved",
            400: "  reserved",
            401: "  reserved",
            402: "  reserved",
            403: "  reserved",
            404: "  reserved",
            405: "  reserved",
            406: "  reserved",
            407: "  reserved",
            408: "  reserved",
            409: "  reserved",
            41: "  reserved",
            410: "  reserved",
            411: "  reserved",
            412: "  reserved",
            413: "  reserved",
            414: "  reserved",
            415: "  reserved",
            416: "  reserved",
            417: "  reserved",
            418: "  reserved",
            419: "  reserved",
            42: "  reserved",
            420: "  reserved",
            421: "  reserved",
            422: "  reserved",
            423: "  reserved",
            424: "  reserved",
            425: "  reserved",
            426: "  reserved",
            427: "  reserved",
            428: "  reserved",
            429: "  reserved",
            43: "  reserved",
            430: "  reserved",
            431: "  reserved",
            432: "  reserved",
            433: "  reserved",
            434: "  reserved",
            435: "  reserved",
            436: "  reserved",
            437: "  reserved",
            438: "  reserved",
            439: "  reserved",
            44: "  reserved",
            440: "  reserved",
            441: "  reserved",
            442: "  reserved",
            443: "  reserved",
            444: "  reserved",
            445: "  reserved",
            446: "  reserved",
            447: "  reserved",
            448: "  reserved",
            449: "  reserved",
            45: "  reserved",
            450: "  reserved",
            451: "  reserved",
            452: "  reserved",
            453: "  reserved",
            454: "  reserved",
            455: "  reserved",
            456: "  reserved",
            457: "  reserved",
            458: "  reserved",
            459: "  reserved",
            46: "  reserved",
            460: "  reserved",
            461: "  reserved",
            462: "  reserved",
            463: "  reserved",
            464: "  reserved",
            465: "  reserved",
            466: "  reserved",
            467: "  reserved",
            468: "  reserved",
            469: "  reserved",
            47: "  reserved",
            470: "  reserved",
            471: "  reserved",
            472: "  reserved",
            473: "  reserved",
            474: "  reserved",
            475: "  reserved",
            476: "  reserved",
            477: "  reserved",
            478: "  reserved",
            479: "  reserved",
            48: "  reserved",
            480: "  reserved",
            481: "  reserved",
            482: "  reserved",
            483: "  reserved",
            484: "  reserved",
            485: "  reserved",
            486: "  reserved",
            487: "  reserved",
            488: "  reserved",
            489: "  reserved",
            49: "  reserved",
            490: "  reserved",
            491: "  reserved",
            492: "  reserved",
            493: "  reserved",
            494: "  reserved",
            495: "  reserved",
            496: "  reserved",
            497: "  reserved",
            498: "  reserved",
            499: "  reserved",
            50: "  reserved",
            500: "  reserved",
            501: "  reserved",
            502: "  reserved",
            503: "  reserved",
            504: "  reserved",
            505: "  reserved",
            506: "  reserved",
            507: "  reserved",
            508: "  reserved",
            509: "  reserved",
            51: "  reserved",
            510: "  reserved",
            511: "  reserved",
            512: "  reserved",
            513: "  reserved",
            514: "  reserved",
            515: "  reserved",
            516: "  reserved",
            517: "  reserved",
            518: "  reserved",
            519: "  reserved",
            52: "  reserved",
            520: "  reserved",
            521: "  reserved",
            522: "  reserved",
            523: "  reserved",
            524: "  reserved",
            525: "  reserved",
            526: "  reserved",
            527: "  reserved",
            528: "  reserved",
            529: "  reserved",
            53: "  reserved",
            530: "  reserved",
            531: "  reserved",
            532: "  reserved",
            533: "  reserved",
            534: "  reserved",
            535: "  reserved",
            536: "  reserved",
            537: "  reserved",
            538: "  reserved",
            539: "  reserved",
            54: "  reserved",
            540: "  reserved",
            541: "  reserved",
            542: "  reserved",
            543: "  reserved",
            544: "  reserved",
            545: "  reserved",
            546: "  reserved",
            547: "  reserved",
            548: "  reserved",
            549: "  reserved",
            55: "  reserved",
            550: "  reserved",
            551: "  reserved",
            552: "  reserved",
            553: "  reserved",
            554: "  reserved",
            555: "  reserved",
            556: "  reserved",
            557: "  reserved",
            558: "  reserved",
            559: "  reserved",
            56: "  reserved",
            560: "  reserved",
            561: "  reserved",
            562: "  reserved",
            563: "  reserved",
            564: "  reserved",
            565: "  reserved",
            566: "  reserved",
            567: "  reserved",
            568: "  reserved",
            569: "  reserved",
            57: "  reserved",
            570: "  reserved",
            571: "  reserved",
            572: "  reserved",
            573: "  reserved",
            574: "  reserved",
            575: "  reserved",
            576: "  reserved",
            577: "  reserved",
            578: "  reserved",
            579: "  reserved",
            58: "  reserved",
            580: "  reserved",
            581: "  reserved",
            582: "  reserved",
            583: "  reserved",
            584: "  reserved",
            585: "  reserved",
            586: "  reserved",
            587: "  reserved",
            588: "  reserved",
            589: "  reserved",
            59: "  reserved",
            590: "  reserved",
            591: "  reserved",
            592: "  reserved",
            593: "  reserved",
            594: "  reserved",
            595: "  reserved",
            596: "  reserved",
            597: "  reserved",
            598: "  reserved",
            599: "  reserved",
            60: "  reserved",
            600: "  reserved",
            601: "  reserved",
            602: "  reserved",
            603: "  reserved",
            604: "  reserved",
            605: "  reserved",
            606: "  reserved",
            607: "  reserved",
            608: "  reserved",
            609: "  reserved",
            61: "  reserved",
            610: "  reserved",
            611: "  reserved",
            612: "  reserved",
            613: "  reserved",
            614: "  reserved",
            615: "  reserved",
            616: "  reserved",
            617: "  reserved",
            618: "  reserved",
            619: "  reserved",
            62: "  reserved",
            620: "  reserved",
            621: "  reserved",
            622: "  reserved",
            623: "  reserved",
            624: "  reserved",
            625: "  reserved",
            626: "  reserved",
            627: "  reserved",
            628: "  reserved",
            629: "  reserved",
            63: "  reserved",
            630: "  reserved",
            631: "  reserved",
            632: "  reserved",
            633: "  reserved",
            634: "  reserved",
            635: "  reserved",
            636: "  reserved",
            637: "  reserved",
            638: "  reserved",
            639: "  reserved",
            64: "  reserved",
            640: "  reserved",
            641: "  reserved",
            642: "  reserved",
            643: "  reserved",
            644: "  reserved",
            645: "  reserved",
            646: "  reserved",
            647: "  reserved",
            648: "  reserved",
            649: "  reserved",
            65: "  reserved",
            650: "  reserved",
            651: "  reserved",
            652: "  reserved",
            653: "  reserved",
            654: "  reserved",
            655: "  reserved",
            656: "  reserved",
            657: "  reserved",
            658: "  reserved",
            659: "  reserved",
            66: "  reserved",
            660: "  reserved",
            661: "  reserved",
            662: "  reserved",
            663: "  reserved",
            664: "  reserved",
            665: "  reserved",
            666: "  reserved",
            667: "  reserved",
            668: "  reserved",
            669: "  reserved",
            67: "  reserved",
            670: "  reserved",
            671: "  reserved",
            672: "  reserved",
            673: "  reserved",
            674: "  reserved",
            675: "  reserved",
            676: "  reserved",
            677: "  reserved",
            678: "  reserved",
            679: "  reserved",
            68: "  reserved",
            680: "  reserved",
            681: "  reserved",
            682: "  reserved",
            683: "  reserved",
            684: "  reserved",
            685: "  reserved",
            686: "  reserved",
            687: "  reserved",
            688: "  reserved",
            689: "  reserved",
            69: "  reserved",
            690: "  reserved",
            691: "  reserved",
            692: "  reserved",
            693: "  reserved",
            694: "  reserved",
            695: "  reserved",
            696: "  reserved",
            697: "  reserved",
            698: "  reserved",
            699: "  reserved",
            70: "  reserved",
            700: "  reserved",
            701: "  reserved",
            702: "  reserved",
            703: "  reserved",
            704: "  reserved",
            705: "  reserved",
            706: "  reserved",
            707: "  reserved",
            708: "  reserved",
            709: "  reserved",
            71: "  reserved",
            710: "  reserved",
            711: "  reserved",
            712: "  reserved",
            713: "  reserved",
            714: "  reserved",
            715: "  reserved",
            716: "  reserved",
            717: "  reserved",
            718: "  reserved",
            719: "  reserved",
            72: "  reserved",
            720: "  reserved",
            721: "  reserved",
            722: "  reserved",
            723: "  reserved",
            724: "  reserved",
            725: "  reserved",
            726: "  reserved",
            727: "  reserved",
            728: "  reserved",
            729: "  reserved",
            73: "  reserved",
            730: "  reserved",
            731: "  reserved",
            732: "  reserved",
            733: "  reserved",
            734: "  reserved",
            735: "  reserved",
            736: "  reserved",
            737: "  reserved",
            738: "  reserved",
            739: "  reserved",
            74: "  reserved",
            740: "  reserved",
            741: "  reserved",
            742: "  reserved",
            743: "  reserved",
            744: "  reserved",
            745: "  reserved",
            746: "  reserved",
            747: "  reserved",
            748: "  reserved",
            749: "  reserved",
            75: "  reserved",
            750: "  reserved",
            751: "  reserved",
            752: "  reserved",
            753: "  reserved",
            754: "  reserved",
            755: "  reserved",
            756: "  reserved",
            757: "  reserved",
            758: "  reserved",
            759: "  reserved",
            76: "  reserved",
            760: "  reserved",
            761: "  reserved",
            762: "  reserved",
            763: "  reserved",
            764: "  reserved",
            765: "  reserved",
            766: "  reserved",
            767: "  reserved",
            768: "  reserved",
            769: "  reserved",
            77: "  reserved",
            770: "  reserved",
            771: "  reserved",
            772: "  reserved",
            773: "  reserved",
            774: "  reserved",
            775: "  reserved",
            776: "  reserved",
            777: "  reserved",
            778: "  reserved",
            779: "  reserved",
            78: "  reserved",
            780: "  reserved",
            781: "  reserved",
            782: "  reserved",
            783: "  reserved",
            784: "  reserved",
            785: "  reserved",
            786: "  reserved",
            787: "  reserved",
            788: "  reserved",
            789: "  reserved",
            79: "  reserved",
            790: "  reserved",
            791: "  reserved",
            792: "  reserved",
            793: "  reserved",
            794: "  reserved",
            795: "  reserved",
            796: "  reserved",
            797: "  reserved",
            798: "  reserved",
            799: "  reserved",
            80: "  reserved",
            800: "  reserved",
            801: "  reserved",
            802: "  reserved",
            803: "  reserved",
            804: "  reserved",
            805: "  reserved",
            806: "  reserved",
            807: "  reserved",
            808: "  reserved",
            809: "  reserved",
            81: "  reserved",
            810: "  reserved",
            811: "  reserved",
            812: "  reserved",
            813: "  reserved",
            814: "  reserved",
            815: "  reserved",
            816: "  reserved",
            817: "  reserved",
            818: "  reserved",
            819: "  reserved",
            82: "  reserved",
            820: "  reserved",
            821: "  reserved",
            822: "  reserved",
            823: "  reserved",
            824: "  reserved",
            825: "  reserved",
            826: "  reserved",
            827: "  reserved",
            828: "  reserved",
            829: "  reserved",
            83: "  reserved",
            830: "  reserved",
            831: "  reserved",
            832: "  reserved",
            833: "  reserved",
            834: "  reserved",
            835: "  reserved",
            836: "  reserved",
            837: "  reserved",
            838: "  reserved",
            839: "  reserved",
            84: "  reserved",
            840: "  reserved",
            841: "  reserved",
            842: "  reserved",
            843: "  reserved",
            844: "  reserved",
            845: "  reserved",
            846: "  reserved",
            847: "  reserved",
            848: "  reserved",
            849: "  reserved",
            85: "  reserved",
            850: "  reserved",
            851: "  reserved",
            852: "  reserved",
            853: "  reserved",
            854: "  reserved",
            855: "  reserved",
            856: "  reserved",
            857: "  reserved",
            858: "  reserved",
            859: "  reserved",
            86: "  reserved",
            860: "  reserved",
            861: "  reserved",
            862: "  reserved",
            863: "  reserved",
            864: "  reserved",
            865: "  reserved",
            866: "  reserved",
            867: "  reserved",
            868: "  reserved",
            869: "  reserved",
            87: "  reserved",
            870: "  reserved",
            871: "  reserved",
            872: "  reserved",
            873: "  reserved",
            874: "  reserved",
            875: "  reserved",
            876: "  reserved",
            877: "  reserved",
            878: "  reserved",
            879: "  reserved",
            88: "  reserved",
            880: "  reserved",
            881: "  reserved",
            882: "  reserved",
            883: "  reserved",
            884: "  reserved",
            885: "  reserved",
            886: "  reserved",
            887: "  reserved",
            888: "  reserved",
            889: "  reserved",
            89: "  reserved",
            890: "  reserved",
            891: "  reserved",
            892: "  reserved",
            893: "  reserved",
            894: "  reserved",
            895: "  reserved",
            896: "  reserved",
            897: "  reserved",
            898: "  reserved",
            899: "  reserved",
            90: "  reserved",
            900: "  reserved",
            901: "  reserved",
            902: "  reserved",
            903: "  reserved",
            904: "  reserved",
            905: "  reserved",
            906: "  reserved",
            907: "  reserved",
            908: "  reserved",
            909: "  reserved",
            91: "  reserved",
            910: "  reserved",
            911: "  reserved",
            912: "  reserved",
            913: "  reserved",
            914: "  reserved",
            915: "  reserved",
            916: "  reserved",
            917: "  reserved",
            918: "  reserved",
            919: "  reserved",
            92: "  reserved",
            920: "  reserved",
            921: "  reserved",
            922: "  reserved",
            923: "  reserved",
            924: "  reserved",
            925: "  reserved",
            926: "  reserved",
            927: "  reserved",
            928: "  reserved",
            929: "  reserved",
            93: "  reserved",
            930: "  reserved",
            931: "  reserved",
            932: "  reserved",
            933: "  reserved",
            934: "  reserved",
            935: "  reserved",
            936: "  reserved",
            937: "  reserved",
            938: "  reserved",
            939: "  reserved",
            94: "  reserved",
            940: "  reserved",
            941: "  reserved",
            942: "  reserved",
            943: "  reserved",
            944: "  reserved",
            945: "  reserved",
            946: "  reserved",
            947: "  reserved",
            948: "  reserved",
            949: "  reserved",
            95: "  reserved",
            950: "  reserved",
            951: "  reserved",
            952: "  reserved",
            953: "  reserved",
            954: "  reserved",
            955: "  reserved",
            956: "  reserved",
            957: "  reserved",
            958: "  reserved",
            959: "  reserved",
            96: "  reserved",
            960: "  reserved",
            961: "  reserved",
            962: "  reserved",
            963: "  reserved",
            964: "  reserved",
            965: "  reserved",
            966: "  reserved",
            967: "  reserved",
            968: "  reserved",
            969: "  reserved",
            97: "  reserved",
            970: "  reserved",
            971: "  reserved",
            972: "  reserved",
            973: "  reserved",
            974: "  reserved",
            975: "  reserved",
            976: "  reserved",
            977: "  reserved",
            978: "  reserved",
            979: "  reserved",
            98: "  reserved",
            980: "  reserved",
            981: "  reserved",
            982: "  reserved",
            983: "  reserved",
            984: "  reserved",
            985: "  reserved",
            986: "  reserved",
            987: "  reserved",
            988: "  reserved",
            989: "  reserved",
            99: "  reserved",
            990: "  reserved",
            991: "  reserved",
            992: "  reserved",
            993: "  reserved",
            994: "  reserved",
            995: "  reserved",
            996: "  reserved",
            997: "  reserved",
            998: "  reserved",
            999: "  reserved"
        },
        3337: {
            0: " no operator control request",
            1: ".  the operator control state can be read in two ways.  one method uses the direct operator control input to determine the operator control state, while the second method relies on a secondary control to read the operator control input, then relay the information on the data link.  the parameter is designed to provide the actual operator control state to other controls that need the information.",
            10: " decrement operator control request",
            100: "  reserved",
            1000: "  reserved",
            1001: "  reserved",
            1002: "  reserved",
            1003: "  reserved",
            1004: "  reserved",
            1005: "  reserved",
            1006: "  reserved",
            1007: "  reserved",
            1008: "  reserved",
            1009: "  reserved",
            101: "  reserved",
            1010: "  reserved",
            1011: "  reserved",
            1012: "  reserved",
            1013: "  reserved",
            1014: "  reserved",
            1015: "  reserved",
            1016: "  reserved",
            1017: "  reserved",
            1018: "  reserved",
            1019: "  reserved",
            102: "  reserved",
            1020: "  reserved",
            1021: "  reserved",
            1022: "  reserved",
            1023: "  reserved",
            1024: "  reserved",
            1025: "  reserved",
            1026: "  reserved",
            1027: "  reserved",
            1028: "  reserved",
            1029: "  reserved",
            103: "  reserved",
            1030: "  reserved",
            1031: "  reserved",
            1032: "  reserved",
            1033: "  reserved",
            1034: "  reserved",
            1035: "  reserved",
            1036: "  reserved",
            1037: "  reserved",
            1038: "  reserved",
            1039: "  reserved",
            104: "  reserved",
            1040: "  reserved",
            1041: "  reserved",
            1042: "  reserved",
            1043: "  reserved",
            1044: "  reserved",
            1045: "  reserved",
            1046: "  reserved",
            1047: "  reserved",
            1048: "  reserved",
            1049: "  reserved",
            105: "  reserved",
            1050: "  reserved",
            1051: "  reserved",
            1052: "  reserved",
            1053: "  reserved",
            1054: "  reserved",
            1055: "  reserved",
            1056: "  reserved",
            1057: "  reserved",
            1058: "  reserved",
            1059: "  reserved",
            106: "  reserved",
            1060: "  reserved",
            1061: "  reserved",
            1062: "  reserved",
            1063: "  reserved",
            1064: "  reserved",
            1065: "  reserved",
            1066: "  reserved",
            1067: "  reserved",
            1068: "  reserved",
            1069: "  reserved",
            107: "  reserved",
            1070: "  reserved",
            1071: "  reserved",
            1072: "  reserved",
            1073: "  reserved",
            1074: "  reserved",
            1075: "  reserved",
            1076: "  reserved",
            1077: "  reserved",
            1078: "  reserved",
            1079: "  reserved",
            108: "  reserved",
            1080: "  reserved",
            1081: "  reserved",
            1082: "  reserved",
            1083: "  reserved",
            1084: "  reserved",
            1085: "  reserved",
            1086: "  reserved",
            1087: "  reserved",
            1088: "  reserved",
            1089: "  reserved",
            109: "  reserved",
            1090: "  reserved",
            1091: "  reserved",
            1092: "  reserved",
            1093: "  reserved",
            1094: "  reserved",
            1095: "  reserved",
            1096: "  reserved",
            1097: "  reserved",
            1098: "  reserved",
            1099: "  reserved",
            11: "  reserved",
            110: "  reserved",
            1100: "  reserved",
            1101: "  reserved",
            111: "  reserved",
            1110: " error indicator",
            1111: " not installed",
            112: "  reserved",
            113: "  reserved",
            114: "  reserved",
            115: "  reserved",
            116: "  reserved",
            117: "  reserved",
            118: "  reserved",
            119: "  reserved",
            12: "  reserved",
            120: "  reserved",
            121: "  reserved",
            122: "  reserved",
            123: "  reserved",
            124: "  reserved",
            125: "  reserved",
            126: "  reserved",
            127: "  reserved",
            128: "  reserved",
            129: "  reserved",
            13: "  reserved",
            130: "  reserved",
            131: "  reserved",
            132: "  reserved",
            133: "  reserved",
            134: "  reserved",
            135: "  reserved",
            136: "  reserved",
            137: "  reserved",
            138: "  reserved",
            139: "  reserved",
            14: "  reserved",
            140: "  reserved",
            141: "  reserved",
            142: "  reserved",
            143: "  reserved",
            144: "  reserved",
            145: "  reserved",
            146: "  reserved",
            147: "  reserved",
            148: "  reserved",
            149: "  reserved",
            15: "  reserved",
            150: "  reserved",
            151: "  reserved",
            152: "  reserved",
            153: "  reserved",
            154: "  reserved",
            155: "  reserved",
            156: "  reserved",
            157: "  reserved",
            158: "  reserved",
            159: "  reserved",
            16: "  reserved",
            160: "  reserved",
            161: "  reserved",
            162: "  reserved",
            163: "  reserved",
            164: "  reserved",
            165: "  reserved",
            166: "  reserved",
            167: "  reserved",
            168: "  reserved",
            169: "  reserved",
            17: "  reserved",
            170: "  reserved",
            171: "  reserved",
            172: "  reserved",
            173: "  reserved",
            174: "  reserved",
            175: "  reserved",
            176: "  reserved",
            177: "  reserved",
            178: "  reserved",
            179: "  reserved",
            18: "  reserved",
            180: "  reserved",
            181: "  reserved",
            182: "  reserved",
            183: "  reserved",
            184: "  reserved",
            185: "  reserved",
            186: "  reserved",
            187: "  reserved",
            188: "  reserved",
            189: "  reserved",
            19: "  reserved",
            190: "  reserved",
            191: "  reserved",
            192: "  reserved",
            193: "  reserved",
            194: "  reserved",
            195: "  reserved",
            196: "  reserved",
            197: "  reserved",
            198: "  reserved",
            199: "  reserved",
            2: ".  other systems with automated blade controls should be able to use this parameter, since it is an actual operator control value.",
            20: "  reserved",
            200: "  reserved",
            201: "  reserved",
            202: "  reserved",
            203: "  reserved",
            204: "  reserved",
            205: "  reserved",
            206: "  reserved",
            207: "  reserved",
            208: "  reserved",
            209: "  reserved",
            21: "  reserved",
            210: "  reserved",
            211: "  reserved",
            212: "  reserved",
            213: "  reserved",
            214: "  reserved",
            215: "  reserved",
            216: "  reserved",
            217: "  reserved",
            218: "  reserved",
            219: "  reserved",
            22: "  reserved",
            220: "  reserved",
            221: "  reserved",
            222: "  reserved",
            223: "  reserved",
            224: "  reserved",
            225: "  reserved",
            226: "  reserved",
            227: "  reserved",
            228: "  reserved",
            229: "  reserved",
            23: "  reserved",
            230: "  reserved",
            231: "  reserved",
            232: "  reserved",
            233: "  reserved",
            234: "  reserved",
            235: "  reserved",
            236: "  reserved",
            237: "  reserved",
            238: "  reserved",
            239: "  reserved",
            24: "  reserved",
            240: "  reserved",
            241: "  reserved",
            242: "  reserved",
            243: "  reserved",
            244: "  reserved",
            245: "  reserved",
            246: "  reserved",
            247: "  reserved",
            248: "  reserved",
            249: "  reserved",
            25: "  reserved",
            250: "  reserved",
            251: "  reserved",
            252: "  reserved",
            253: "  reserved",
            254: "  reserved",
            255: "  reserved",
            256: "  reserved",
            257: "  reserved",
            258: "  reserved",
            259: "  reserved",
            26: "  reserved",
            260: "  reserved",
            261: "  reserved",
            262: "  reserved",
            263: "  reserved",
            264: "  reserved",
            265: "  reserved",
            266: "  reserved",
            267: "  reserved",
            268: "  reserved",
            269: "  reserved",
            27: "  reserved",
            270: "  reserved",
            271: "  reserved",
            272: "  reserved",
            273: "  reserved",
            274: "  reserved",
            275: "  reserved",
            276: "  reserved",
            277: "  reserved",
            278: "  reserved",
            279: "  reserved",
            28: "  reserved",
            280: "  reserved",
            281: "  reserved",
            282: "  reserved",
            283: "  reserved",
            284: "  reserved",
            285: "  reserved",
            286: "  reserved",
            287: "  reserved",
            288: "  reserved",
            289: "  reserved",
            29: "  reserved",
            290: "  reserved",
            291: "  reserved",
            292: "  reserved",
            293: "  reserved",
            294: "  reserved",
            295: "  reserved",
            296: "  reserved",
            297: "  reserved",
            298: "  reserved",
            299: "  reserved",
            30: "  reserved",
            300: "  reserved",
            301: "  reserved",
            302: "  reserved",
            303: "  reserved",
            304: "  reserved",
            305: "  reserved",
            306: "  reserved",
            307: "  reserved",
            308: "  reserved",
            309: "  reserved",
            31: "  reserved",
            310: "  reserved",
            311: "  reserved",
            312: "  reserved",
            313: "  reserved",
            314: "  reserved",
            315: "  reserved",
            316: "  reserved",
            317: "  reserved",
            318: "  reserved",
            319: "  reserved",
            32: "  reserved",
            320: "  reserved",
            321: "  reserved",
            322: "  reserved",
            323: "  reserved",
            324: "  reserved",
            325: "  reserved",
            326: "  reserved",
            327: "  reserved",
            328: "  reserved",
            329: "  reserved",
            33: "  reserved",
            330: "  reserved",
            331: "  reserved",
            332: "  reserved",
            333: "  reserved",
            334: "  reserved",
            335: "  reserved",
            336: "  reserved",
            337: "  reserved",
            338: "  reserved",
            339: "  reserved",
            34: "  reserved",
            340: "  reserved",
            341: "  reserved",
            342: "  reserved",
            343: "  reserved",
            344: "  reserved",
            345: "  reserved",
            346: "  reserved",
            347: "  reserved",
            348: "  reserved",
            349: "  reserved",
            35: "  reserved",
            350: "  reserved",
            351: "  reserved",
            352: "  reserved",
            353: "  reserved",
            354: "  reserved",
            355: "  reserved",
            356: "  reserved",
            357: "  reserved",
            358: "  reserved",
            359: "  reserved",
            36: "  reserved",
            360: "  reserved",
            361: "  reserved",
            362: "  reserved",
            363: "  reserved",
            364: "  reserved",
            365: "  reserved",
            366: "  reserved",
            367: "  reserved",
            368: "  reserved",
            369: "  reserved",
            37: "  reserved",
            370: "  reserved",
            371: "  reserved",
            372: "  reserved",
            373: "  reserved",
            374: "  reserved",
            375: "  reserved",
            376: "  reserved",
            377: "  reserved",
            378: "  reserved",
            379: "  reserved",
            38: "  reserved",
            380: "  reserved",
            381: "  reserved",
            382: "  reserved",
            383: "  reserved",
            384: "  reserved",
            385: "  reserved",
            386: "  reserved",
            387: "  reserved",
            388: "  reserved",
            389: "  reserved",
            39: "  reserved",
            390: "  reserved",
            391: "  reserved",
            392: "  reserved",
            393: "  reserved",
            394: "  reserved",
            395: "  reserved",
            396: "  reserved",
            397: "  reserved",
            398: "  reserved",
            399: "  reserved",
            40: "  reserved",
            400: "  reserved",
            401: "  reserved",
            402: "  reserved",
            403: "  reserved",
            404: "  reserved",
            405: "  reserved",
            406: "  reserved",
            407: "  reserved",
            408: "  reserved",
            409: "  reserved",
            41: "  reserved",
            410: "  reserved",
            411: "  reserved",
            412: "  reserved",
            413: "  reserved",
            414: "  reserved",
            415: "  reserved",
            416: "  reserved",
            417: "  reserved",
            418: "  reserved",
            419: "  reserved",
            42: "  reserved",
            420: "  reserved",
            421: "  reserved",
            422: "  reserved",
            423: "  reserved",
            424: "  reserved",
            425: "  reserved",
            426: "  reserved",
            427: "  reserved",
            428: "  reserved",
            429: "  reserved",
            43: "  reserved",
            430: "  reserved",
            431: "  reserved",
            432: "  reserved",
            433: "  reserved",
            434: "  reserved",
            435: "  reserved",
            436: "  reserved",
            437: "  reserved",
            438: "  reserved",
            439: "  reserved",
            44: "  reserved",
            440: "  reserved",
            441: "  reserved",
            442: "  reserved",
            443: "  reserved",
            444: "  reserved",
            445: "  reserved",
            446: "  reserved",
            447: "  reserved",
            448: "  reserved",
            449: "  reserved",
            45: "  reserved",
            450: "  reserved",
            451: "  reserved",
            452: "  reserved",
            453: "  reserved",
            454: "  reserved",
            455: "  reserved",
            456: "  reserved",
            457: "  reserved",
            458: "  reserved",
            459: "  reserved",
            46: "  reserved",
            460: "  reserved",
            461: "  reserved",
            462: "  reserved",
            463: "  reserved",
            464: "  reserved",
            465: "  reserved",
            466: "  reserved",
            467: "  reserved",
            468: "  reserved",
            469: "  reserved",
            47: "  reserved",
            470: "  reserved",
            471: "  reserved",
            472: "  reserved",
            473: "  reserved",
            474: "  reserved",
            475: "  reserved",
            476: "  reserved",
            477: "  reserved",
            478: "  reserved",
            479: "  reserved",
            48: "  reserved",
            480: "  reserved",
            481: "  reserved",
            482: "  reserved",
            483: "  reserved",
            484: "  reserved",
            485: "  reserved",
            486: "  reserved",
            487: "  reserved",
            488: "  reserved",
            489: "  reserved",
            49: "  reserved",
            490: "  reserved",
            491: "  reserved",
            492: "  reserved",
            493: "  reserved",
            494: "  reserved",
            495: "  reserved",
            496: "  reserved",
            497: "  reserved",
            498: "  reserved",
            499: "  reserved",
            50: "  reserved",
            500: "  reserved",
            501: "  reserved",
            502: "  reserved",
            503: "  reserved",
            504: "  reserved",
            505: "  reserved",
            506: "  reserved",
            507: "  reserved",
            508: "  reserved",
            509: "  reserved",
            51: "  reserved",
            510: "  reserved",
            511: "  reserved",
            512: "  reserved",
            513: "  reserved",
            514: "  reserved",
            515: "  reserved",
            516: "  reserved",
            517: "  reserved",
            518: "  reserved",
            519: "  reserved",
            52: "  reserved",
            520: "  reserved",
            521: "  reserved",
            522: "  reserved",
            523: "  reserved",
            524: "  reserved",
            525: "  reserved",
            526: "  reserved",
            527: "  reserved",
            528: "  reserved",
            529: "  reserved",
            53: "  reserved",
            530: "  reserved",
            531: "  reserved",
            532: "  reserved",
            533: "  reserved",
            534: "  reserved",
            535: "  reserved",
            536: "  reserved",
            537: "  reserved",
            538: "  reserved",
            539: "  reserved",
            54: "  reserved",
            540: "  reserved",
            541: "  reserved",
            542: "  reserved",
            543: "  reserved",
            544: "  reserved",
            545: "  reserved",
            546: "  reserved",
            547: "  reserved",
            548: "  reserved",
            549: "  reserved",
            55: "  reserved",
            550: "  reserved",
            551: "  reserved",
            552: "  reserved",
            553: "  reserved",
            554: "  reserved",
            555: "  reserved",
            556: "  reserved",
            557: "  reserved",
            558: "  reserved",
            559: "  reserved",
            56: "  reserved",
            560: "  reserved",
            561: "  reserved",
            562: "  reserved",
            563: "  reserved",
            564: "  reserved",
            565: "  reserved",
            566: "  reserved",
            567: "  reserved",
            568: "  reserved",
            569: "  reserved",
            57: "  reserved",
            570: "  reserved",
            571: "  reserved",
            572: "  reserved",
            573: "  reserved",
            574: "  reserved",
            575: "  reserved",
            576: "  reserved",
            577: "  reserved",
            578: "  reserved",
            579: "  reserved",
            58: "  reserved",
            580: "  reserved",
            581: "  reserved",
            582: "  reserved",
            583: "  reserved",
            584: "  reserved",
            585: "  reserved",
            586: "  reserved",
            587: "  reserved",
            588: "  reserved",
            589: "  reserved",
            59: "  reserved",
            590: "  reserved",
            591: "  reserved",
            592: "  reserved",
            593: "  reserved",
            594: "  reserved",
            595: "  reserved",
            596: "  reserved",
            597: "  reserved",
            598: "  reserved",
            599: "  reserved",
            60: "  reserved",
            600: "  reserved",
            601: "  reserved",
            602: "  reserved",
            603: "  reserved",
            604: "  reserved",
            605: "  reserved",
            606: "  reserved",
            607: "  reserved",
            608: "  reserved",
            609: "  reserved",
            61: "  reserved",
            610: "  reserved",
            611: "  reserved",
            612: "  reserved",
            613: "  reserved",
            614: "  reserved",
            615: "  reserved",
            616: "  reserved",
            617: "  reserved",
            618: "  reserved",
            619: "  reserved",
            62: "  reserved",
            620: "  reserved",
            621: "  reserved",
            622: "  reserved",
            623: "  reserved",
            624: "  reserved",
            625: "  reserved",
            626: "  reserved",
            627: "  reserved",
            628: "  reserved",
            629: "  reserved",
            63: "  reserved",
            630: "  reserved",
            631: "  reserved",
            632: "  reserved",
            633: "  reserved",
            634: "  reserved",
            635: "  reserved",
            636: "  reserved",
            637: "  reserved",
            638: "  reserved",
            639: "  reserved",
            64: "  reserved",
            640: "  reserved",
            641: "  reserved",
            642: "  reserved",
            643: "  reserved",
            644: "  reserved",
            645: "  reserved",
            646: "  reserved",
            647: "  reserved",
            648: "  reserved",
            649: "  reserved",
            65: "  reserved",
            650: "  reserved",
            651: "  reserved",
            652: "  reserved",
            653: "  reserved",
            654: "  reserved",
            655: "  reserved",
            656: "  reserved",
            657: "  reserved",
            658: "  reserved",
            659: "  reserved",
            66: "  reserved",
            660: "  reserved",
            661: "  reserved",
            662: "  reserved",
            663: "  reserved",
            664: "  reserved",
            665: "  reserved",
            666: "  reserved",
            667: "  reserved",
            668: "  reserved",
            669: "  reserved",
            67: "  reserved",
            670: "  reserved",
            671: "  reserved",
            672: "  reserved",
            673: "  reserved",
            674: "  reserved",
            675: "  reserved",
            676: "  reserved",
            677: "  reserved",
            678: "  reserved",
            679: "  reserved",
            68: "  reserved",
            680: "  reserved",
            681: "  reserved",
            682: "  reserved",
            683: "  reserved",
            684: "  reserved",
            685: "  reserved",
            686: "  reserved",
            687: "  reserved",
            688: "  reserved",
            689: "  reserved",
            69: "  reserved",
            690: "  reserved",
            691: "  reserved",
            692: "  reserved",
            693: "  reserved",
            694: "  reserved",
            695: "  reserved",
            696: "  reserved",
            697: "  reserved",
            698: "  reserved",
            699: "  reserved",
            70: "  reserved",
            700: "  reserved",
            701: "  reserved",
            702: "  reserved",
            703: "  reserved",
            704: "  reserved",
            705: "  reserved",
            706: "  reserved",
            707: "  reserved",
            708: "  reserved",
            709: "  reserved",
            71: "  reserved",
            710: "  reserved",
            711: "  reserved",
            712: "  reserved",
            713: "  reserved",
            714: "  reserved",
            715: "  reserved",
            716: "  reserved",
            717: "  reserved",
            718: "  reserved",
            719: "  reserved",
            72: "  reserved",
            720: "  reserved",
            721: "  reserved",
            722: "  reserved",
            723: "  reserved",
            724: "  reserved",
            725: "  reserved",
            726: "  reserved",
            727: "  reserved",
            728: "  reserved",
            729: "  reserved",
            73: "  reserved",
            730: "  reserved",
            731: "  reserved",
            732: "  reserved",
            733: "  reserved",
            734: "  reserved",
            735: "  reserved",
            736: "  reserved",
            737: "  reserved",
            738: "  reserved",
            739: "  reserved",
            74: "  reserved",
            740: "  reserved",
            741: "  reserved",
            742: "  reserved",
            743: "  reserved",
            744: "  reserved",
            745: "  reserved",
            746: "  reserved",
            747: "  reserved",
            748: "  reserved",
            749: "  reserved",
            75: "  reserved",
            750: "  reserved",
            751: "  reserved",
            752: "  reserved",
            753: "  reserved",
            754: "  reserved",
            755: "  reserved",
            756: "  reserved",
            757: "  reserved",
            758: "  reserved",
            759: "  reserved",
            76: "  reserved",
            760: "  reserved",
            761: "  reserved",
            762: "  reserved",
            763: "  reserved",
            764: "  reserved",
            765: "  reserved",
            766: "  reserved",
            767: "  reserved",
            768: "  reserved",
            769: "  reserved",
            77: "  reserved",
            770: "  reserved",
            771: "  reserved",
            772: "  reserved",
            773: "  reserved",
            774: "  reserved",
            775: "  reserved",
            776: "  reserved",
            777: "  reserved",
            778: "  reserved",
            779: "  reserved",
            78: "  reserved",
            780: "  reserved",
            781: "  reserved",
            782: "  reserved",
            783: "  reserved",
            784: "  reserved",
            785: "  reserved",
            786: "  reserved",
            787: "  reserved",
            788: "  reserved",
            789: "  reserved",
            79: "  reserved",
            790: "  reserved",
            791: "  reserved",
            792: "  reserved",
            793: "  reserved",
            794: "  reserved",
            795: "  reserved",
            796: "  reserved",
            797: "  reserved",
            798: "  reserved",
            799: "  reserved",
            80: "  reserved",
            800: "  reserved",
            801: "  reserved",
            802: "  reserved",
            803: "  reserved",
            804: "  reserved",
            805: "  reserved",
            806: "  reserved",
            807: "  reserved",
            808: "  reserved",
            809: "  reserved",
            81: "  reserved",
            810: "  reserved",
            811: "  reserved",
            812: "  reserved",
            813: "  reserved",
            814: "  reserved",
            815: "  reserved",
            816: "  reserved",
            817: "  reserved",
            818: "  reserved",
            819: "  reserved",
            82: "  reserved",
            820: "  reserved",
            821: "  reserved",
            822: "  reserved",
            823: "  reserved",
            824: "  reserved",
            825: "  reserved",
            826: "  reserved",
            827: "  reserved",
            828: "  reserved",
            829: "  reserved",
            83: "  reserved",
            830: "  reserved",
            831: "  reserved",
            832: "  reserved",
            833: "  reserved",
            834: "  reserved",
            835: "  reserved",
            836: "  reserved",
            837: "  reserved",
            838: "  reserved",
            839: "  reserved",
            84: "  reserved",
            840: "  reserved",
            841: "  reserved",
            842: "  reserved",
            843: "  reserved",
            844: "  reserved",
            845: "  reserved",
            846: "  reserved",
            847: "  reserved",
            848: "  reserved",
            849: "  reserved",
            85: "  reserved",
            850: "  reserved",
            851: "  reserved",
            852: "  reserved",
            853: "  reserved",
            854: "  reserved",
            855: "  reserved",
            856: "  reserved",
            857: "  reserved",
            858: "  reserved",
            859: "  reserved",
            86: "  reserved",
            860: "  reserved",
            861: "  reserved",
            862: "  reserved",
            863: "  reserved",
            864: "  reserved",
            865: "  reserved",
            866: "  reserved",
            867: "  reserved",
            868: "  reserved",
            869: "  reserved",
            87: "  reserved",
            870: "  reserved",
            871: "  reserved",
            872: "  reserved",
            873: "  reserved",
            874: "  reserved",
            875: "  reserved",
            876: "  reserved",
            877: "  reserved",
            878: "  reserved",
            879: "  reserved",
            88: "  reserved",
            880: "  reserved",
            881: "  reserved",
            882: "  reserved",
            883: "  reserved",
            884: "  reserved",
            885: "  reserved",
            886: "  reserved",
            887: "  reserved",
            888: "  reserved",
            889: "  reserved",
            89: "  reserved",
            890: "  reserved",
            891: "  reserved",
            892: "  reserved",
            893: "  reserved",
            894: "  reserved",
            895: "  reserved",
            896: "  reserved",
            897: "  reserved",
            898: "  reserved",
            899: "  reserved",
            90: "  reserved",
            900: "  reserved",
            901: "  reserved",
            902: "  reserved",
            903: "  reserved",
            904: "  reserved",
            905: "  reserved",
            906: "  reserved",
            907: "  reserved",
            908: "  reserved",
            909: "  reserved",
            91: "  reserved",
            910: "  reserved",
            911: "  reserved",
            912: "  reserved",
            913: "  reserved",
            914: "  reserved",
            915: "  reserved",
            916: "  reserved",
            917: "  reserved",
            918: "  reserved",
            919: "  reserved",
            92: "  reserved",
            920: "  reserved",
            921: "  reserved",
            922: "  reserved",
            923: "  reserved",
            924: "  reserved",
            925: "  reserved",
            926: "  reserved",
            927: "  reserved",
            928: "  reserved",
            929: "  reserved",
            93: "  reserved",
            930: "  reserved",
            931: "  reserved",
            932: "  reserved",
            933: "  reserved",
            934: "  reserved",
            935: "  reserved",
            936: "  reserved",
            937: "  reserved",
            938: "  reserved",
            939: "  reserved",
            94: "  reserved",
            940: "  reserved",
            941: "  reserved",
            942: "  reserved",
            943: "  reserved",
            944: "  reserved",
            945: "  reserved",
            946: "  reserved",
            947: "  reserved",
            948: "  reserved",
            949: "  reserved",
            95: "  reserved",
            950: "  reserved",
            951: "  reserved",
            952: "  reserved",
            953: "  reserved",
            954: "  reserved",
            955: "  reserved",
            956: "  reserved",
            957: "  reserved",
            958: "  reserved",
            959: "  reserved",
            96: "  reserved",
            960: "  reserved",
            961: "  reserved",
            962: "  reserved",
            963: "  reserved",
            964: "  reserved",
            965: "  reserved",
            966: "  reserved",
            967: "  reserved",
            968: "  reserved",
            969: "  reserved",
            97: "  reserved",
            970: "  reserved",
            971: "  reserved",
            972: "  reserved",
            973: "  reserved",
            974: "  reserved",
            975: "  reserved",
            976: "  reserved",
            977: "  reserved",
            978: "  reserved",
            979: "  reserved",
            98: "  reserved",
            980: "  reserved",
            981: "  reserved",
            982: "  reserved",
            983: "  reserved",
            984: "  reserved",
            985: "  reserved",
            986: "  reserved",
            987: "  reserved",
            988: "  reserved",
            989: "  reserved",
            99: "  reserved",
            990: "  reserved",
            991: "  reserved",
            992: "  reserved",
            993: "  reserved",
            994: "  reserved",
            995: "  reserved",
            996: "  reserved",
            997: "  reserved",
            998: "  reserved",
            999: "  reserved"
        },
        3338: {
            0: " no operator control request",
            1: " increment operator control request",
            10: " decrement operator control request",
            100: " reserved",
            1000: " reserved",
            1001: " reserved",
            1002: " reserved",
            1003: " reserved",
            1004: " reserved",
            1005: " reserved",
            1006: " reserved",
            1007: " reserved",
            1008: " reserved",
            1009: " reserved",
            101: " reserved",
            1010: " reserved",
            1011: " reserved",
            1012: " reserved",
            1013: " reserved",
            1014: " reserved",
            1015: " reserved",
            1016: " reserved",
            1017: " reserved",
            1018: " reserved",
            1019: " reserved",
            102: " reserved",
            1020: " reserved",
            1021: " reserved",
            1022: " reserved",
            1023: " reserved",
            1024: " reserved",
            1025: " reserved",
            1026: " reserved",
            1027: " reserved",
            1028: " reserved",
            1029: " reserved",
            103: " reserved",
            1030: " reserved",
            1031: " reserved",
            1032: " reserved",
            1033: " reserved",
            1034: " reserved",
            1035: " reserved",
            1036: " reserved",
            1037: " reserved",
            1038: " reserved",
            1039: " reserved",
            104: " reserved",
            1040: " reserved",
            1041: " reserved",
            1042: " reserved",
            1043: " reserved",
            1044: " reserved",
            1045: " reserved",
            1046: " reserved",
            1047: " reserved",
            1048: " reserved",
            1049: " reserved",
            105: " reserved",
            1050: " reserved",
            1051: " reserved",
            1052: " reserved",
            1053: " reserved",
            1054: " reserved",
            1055: " reserved",
            1056: " reserved",
            1057: " reserved",
            1058: " reserved",
            1059: " reserved",
            106: " reserved",
            1060: " reserved",
            1061: " reserved",
            1062: " reserved",
            1063: " reserved",
            1064: " reserved",
            1065: " reserved",
            1066: " reserved",
            1067: " reserved",
            1068: " reserved",
            1069: " reserved",
            107: " reserved",
            1070: " reserved",
            1071: " reserved",
            1072: " reserved",
            1073: " reserved",
            1074: " reserved",
            1075: " reserved",
            1076: " reserved",
            1077: " reserved",
            1078: " reserved",
            1079: " reserved",
            108: " reserved",
            1080: " reserved",
            1081: " reserved",
            1082: " reserved",
            1083: " reserved",
            1084: " reserved",
            1085: " reserved",
            1086: " reserved",
            1087: " reserved",
            1088: " reserved",
            1089: " reserved",
            109: " reserved",
            1090: " reserved",
            1091: " reserved",
            1092: " reserved",
            1093: " reserved",
            1094: " reserved",
            1095: " reserved",
            1096: " reserved",
            1097: " reserved",
            1098: " reserved",
            1099: " reserved",
            11: " reserved",
            110: " reserved",
            1100: " reserved",
            1101: " reserved",
            111: " reserved",
            1110: " error indicator",
            1111: " not installed",
            112: " reserved",
            113: " reserved",
            114: " reserved",
            115: " reserved",
            116: " reserved",
            117: " reserved",
            118: " reserved",
            119: " reserved",
            12: " reserved",
            120: " reserved",
            121: " reserved",
            122: " reserved",
            123: " reserved",
            124: " reserved",
            125: " reserved",
            126: " reserved",
            127: " reserved",
            128: " reserved",
            129: " reserved",
            13: " reserved",
            130: " reserved",
            131: " reserved",
            132: " reserved",
            133: " reserved",
            134: " reserved",
            135: " reserved",
            136: " reserved",
            137: " reserved",
            138: " reserved",
            139: " reserved",
            14: " reserved",
            140: " reserved",
            141: " reserved",
            142: " reserved",
            143: " reserved",
            144: " reserved",
            145: " reserved",
            146: " reserved",
            147: " reserved",
            148: " reserved",
            149: " reserved",
            15: " reserved",
            150: " reserved",
            151: " reserved",
            152: " reserved",
            153: " reserved",
            154: " reserved",
            155: " reserved",
            156: " reserved",
            157: " reserved",
            158: " reserved",
            159: " reserved",
            16: " reserved",
            160: " reserved",
            161: " reserved",
            162: " reserved",
            163: " reserved",
            164: " reserved",
            165: " reserved",
            166: " reserved",
            167: " reserved",
            168: " reserved",
            169: " reserved",
            17: " reserved",
            170: " reserved",
            171: " reserved",
            172: " reserved",
            173: " reserved",
            174: " reserved",
            175: " reserved",
            176: " reserved",
            177: " reserved",
            178: " reserved",
            179: " reserved",
            18: " reserved",
            180: " reserved",
            181: " reserved",
            182: " reserved",
            183: " reserved",
            184: " reserved",
            185: " reserved",
            186: " reserved",
            187: " reserved",
            188: " reserved",
            189: " reserved",
            19: " reserved",
            190: " reserved",
            191: " reserved",
            192: " reserved",
            193: " reserved",
            194: " reserved",
            195: " reserved",
            196: " reserved",
            197: " reserved",
            198: " reserved",
            199: " reserved",
            2: ". the momentary contact button pair may be used, where the default is the neutral position with no buttons pressed. the user can press the increment button, and when pressure is released, it will return to the neutral position. the user may press the decrement button, and when pressure is released, it will return to the neutral position. momentary contact button (button pair) usage is as follows:",
            20: " reserved",
            200: " reserved",
            201: " reserved",
            202: " reserved",
            203: " reserved",
            204: " reserved",
            205: " reserved",
            206: " reserved",
            207: " reserved",
            208: " reserved",
            209: " reserved",
            21: " reserved",
            210: " reserved",
            211: " reserved",
            212: " reserved",
            213: " reserved",
            214: " reserved",
            215: " reserved",
            216: " reserved",
            217: " reserved",
            218: " reserved",
            219: " reserved",
            22: " reserved",
            220: " reserved",
            221: " reserved",
            222: " reserved",
            223: " reserved",
            224: " reserved",
            225: " reserved",
            226: " reserved",
            227: " reserved",
            228: " reserved",
            229: " reserved",
            23: " reserved",
            230: " reserved",
            231: " reserved",
            232: " reserved",
            233: " reserved",
            234: " reserved",
            235: " reserved",
            236: " reserved",
            237: " reserved",
            238: " reserved",
            239: " reserved",
            24: " reserved",
            240: " reserved",
            241: " reserved",
            242: " reserved",
            243: " reserved",
            244: " reserved",
            245: " reserved",
            246: " reserved",
            247: " reserved",
            248: " reserved",
            249: " reserved",
            25: " reserved",
            250: " reserved",
            251: " reserved",
            252: " reserved",
            253: " reserved",
            254: " reserved",
            255: " reserved",
            256: " reserved",
            257: " reserved",
            258: " reserved",
            259: " reserved",
            26: " reserved",
            260: " reserved",
            261: " reserved",
            262: " reserved",
            263: " reserved",
            264: " reserved",
            265: " reserved",
            266: " reserved",
            267: " reserved",
            268: " reserved",
            269: " reserved",
            27: " reserved",
            270: " reserved",
            271: " reserved",
            272: " reserved",
            273: " reserved",
            274: " reserved",
            275: " reserved",
            276: " reserved",
            277: " reserved",
            278: " reserved",
            279: " reserved",
            28: " reserved",
            280: " reserved",
            281: " reserved",
            282: " reserved",
            283: " reserved",
            284: " reserved",
            285: " reserved",
            286: " reserved",
            287: " reserved",
            288: " reserved",
            289: " reserved",
            29: " reserved",
            290: " reserved",
            291: " reserved",
            292: " reserved",
            293: " reserved",
            294: " reserved",
            295: " reserved",
            296: " reserved",
            297: " reserved",
            298: " reserved",
            299: " reserved",
            30: " reserved",
            300: " reserved",
            301: " reserved",
            302: " reserved",
            303: " reserved",
            304: " reserved",
            305: " reserved",
            306: " reserved",
            307: " reserved",
            308: " reserved",
            309: " reserved",
            31: " reserved",
            310: " reserved",
            311: " reserved",
            312: " reserved",
            313: " reserved",
            314: " reserved",
            315: " reserved",
            316: " reserved",
            317: " reserved",
            318: " reserved",
            319: " reserved",
            32: " reserved",
            320: " reserved",
            321: " reserved",
            322: " reserved",
            323: " reserved",
            324: " reserved",
            325: " reserved",
            326: " reserved",
            327: " reserved",
            328: " reserved",
            329: " reserved",
            33: " reserved",
            330: " reserved",
            331: " reserved",
            332: " reserved",
            333: " reserved",
            334: " reserved",
            335: " reserved",
            336: " reserved",
            337: " reserved",
            338: " reserved",
            339: " reserved",
            34: " reserved",
            340: " reserved",
            341: " reserved",
            342: " reserved",
            343: " reserved",
            344: " reserved",
            345: " reserved",
            346: " reserved",
            347: " reserved",
            348: " reserved",
            349: " reserved",
            35: " reserved",
            350: " reserved",
            351: " reserved",
            352: " reserved",
            353: " reserved",
            354: " reserved",
            355: " reserved",
            356: " reserved",
            357: " reserved",
            358: " reserved",
            359: " reserved",
            36: " reserved",
            360: " reserved",
            361: " reserved",
            362: " reserved",
            363: " reserved",
            364: " reserved",
            365: " reserved",
            366: " reserved",
            367: " reserved",
            368: " reserved",
            369: " reserved",
            37: " reserved",
            370: " reserved",
            371: " reserved",
            372: " reserved",
            373: " reserved",
            374: " reserved",
            375: " reserved",
            376: " reserved",
            377: " reserved",
            378: " reserved",
            379: " reserved",
            38: " reserved",
            380: " reserved",
            381: " reserved",
            382: " reserved",
            383: " reserved",
            384: " reserved",
            385: " reserved",
            386: " reserved",
            387: " reserved",
            388: " reserved",
            389: " reserved",
            39: " reserved",
            390: " reserved",
            391: " reserved",
            392: " reserved",
            393: " reserved",
            394: " reserved",
            395: " reserved",
            396: " reserved",
            397: " reserved",
            398: " reserved",
            399: " reserved",
            40: " reserved",
            400: " reserved",
            401: " reserved",
            402: " reserved",
            403: " reserved",
            404: " reserved",
            405: " reserved",
            406: " reserved",
            407: " reserved",
            408: " reserved",
            409: " reserved",
            41: " reserved",
            410: " reserved",
            411: " reserved",
            412: " reserved",
            413: " reserved",
            414: " reserved",
            415: " reserved",
            416: " reserved",
            417: " reserved",
            418: " reserved",
            419: " reserved",
            42: " reserved",
            420: " reserved",
            421: " reserved",
            422: " reserved",
            423: " reserved",
            424: " reserved",
            425: " reserved",
            426: " reserved",
            427: " reserved",
            428: " reserved",
            429: " reserved",
            43: " reserved",
            430: " reserved",
            431: " reserved",
            432: " reserved",
            433: " reserved",
            434: " reserved",
            435: " reserved",
            436: " reserved",
            437: " reserved",
            438: " reserved",
            439: " reserved",
            44: " reserved",
            440: " reserved",
            441: " reserved",
            442: " reserved",
            443: " reserved",
            444: " reserved",
            445: " reserved",
            446: " reserved",
            447: " reserved",
            448: " reserved",
            449: " reserved",
            45: " reserved",
            450: " reserved",
            451: " reserved",
            452: " reserved",
            453: " reserved",
            454: " reserved",
            455: " reserved",
            456: " reserved",
            457: " reserved",
            458: " reserved",
            459: " reserved",
            46: " reserved",
            460: " reserved",
            461: " reserved",
            462: " reserved",
            463: " reserved",
            464: " reserved",
            465: " reserved",
            466: " reserved",
            467: " reserved",
            468: " reserved",
            469: " reserved",
            47: " reserved",
            470: " reserved",
            471: " reserved",
            472: " reserved",
            473: " reserved",
            474: " reserved",
            475: " reserved",
            476: " reserved",
            477: " reserved",
            478: " reserved",
            479: " reserved",
            48: " reserved",
            480: " reserved",
            481: " reserved",
            482: " reserved",
            483: " reserved",
            484: " reserved",
            485: " reserved",
            486: " reserved",
            487: " reserved",
            488: " reserved",
            489: " reserved",
            49: " reserved",
            490: " reserved",
            491: " reserved",
            492: " reserved",
            493: " reserved",
            494: " reserved",
            495: " reserved",
            496: " reserved",
            497: " reserved",
            498: " reserved",
            499: " reserved",
            50: " reserved",
            500: " reserved",
            501: " reserved",
            502: " reserved",
            503: " reserved",
            504: " reserved",
            505: " reserved",
            506: " reserved",
            507: " reserved",
            508: " reserved",
            509: " reserved",
            51: " reserved",
            510: " reserved",
            511: " reserved",
            512: " reserved",
            513: " reserved",
            514: " reserved",
            515: " reserved",
            516: " reserved",
            517: " reserved",
            518: " reserved",
            519: " reserved",
            52: " reserved",
            520: " reserved",
            521: " reserved",
            522: " reserved",
            523: " reserved",
            524: " reserved",
            525: " reserved",
            526: " reserved",
            527: " reserved",
            528: " reserved",
            529: " reserved",
            53: " reserved",
            530: " reserved",
            531: " reserved",
            532: " reserved",
            533: " reserved",
            534: " reserved",
            535: " reserved",
            536: " reserved",
            537: " reserved",
            538: " reserved",
            539: " reserved",
            54: " reserved",
            540: " reserved",
            541: " reserved",
            542: " reserved",
            543: " reserved",
            544: " reserved",
            545: " reserved",
            546: " reserved",
            547: " reserved",
            548: " reserved",
            549: " reserved",
            55: " reserved",
            550: " reserved",
            551: " reserved",
            552: " reserved",
            553: " reserved",
            554: " reserved",
            555: " reserved",
            556: " reserved",
            557: " reserved",
            558: " reserved",
            559: " reserved",
            56: " reserved",
            560: " reserved",
            561: " reserved",
            562: " reserved",
            563: " reserved",
            564: " reserved",
            565: " reserved",
            566: " reserved",
            567: " reserved",
            568: " reserved",
            569: " reserved",
            57: " reserved",
            570: " reserved",
            571: " reserved",
            572: " reserved",
            573: " reserved",
            574: " reserved",
            575: " reserved",
            576: " reserved",
            577: " reserved",
            578: " reserved",
            579: " reserved",
            58: " reserved",
            580: " reserved",
            581: " reserved",
            582: " reserved",
            583: " reserved",
            584: " reserved",
            585: " reserved",
            586: " reserved",
            587: " reserved",
            588: " reserved",
            589: " reserved",
            59: " reserved",
            590: " reserved",
            591: " reserved",
            592: " reserved",
            593: " reserved",
            594: " reserved",
            595: " reserved",
            596: " reserved",
            597: " reserved",
            598: " reserved",
            599: " reserved",
            60: " reserved",
            600: " reserved",
            601: " reserved",
            602: " reserved",
            603: " reserved",
            604: " reserved",
            605: " reserved",
            606: " reserved",
            607: " reserved",
            608: " reserved",
            609: " reserved",
            61: " reserved",
            610: " reserved",
            611: " reserved",
            612: " reserved",
            613: " reserved",
            614: " reserved",
            615: " reserved",
            616: " reserved",
            617: " reserved",
            618: " reserved",
            619: " reserved",
            62: " reserved",
            620: " reserved",
            621: " reserved",
            622: " reserved",
            623: " reserved",
            624: " reserved",
            625: " reserved",
            626: " reserved",
            627: " reserved",
            628: " reserved",
            629: " reserved",
            63: " reserved",
            630: " reserved",
            631: " reserved",
            632: " reserved",
            633: " reserved",
            634: " reserved",
            635: " reserved",
            636: " reserved",
            637: " reserved",
            638: " reserved",
            639: " reserved",
            64: " reserved",
            640: " reserved",
            641: " reserved",
            642: " reserved",
            643: " reserved",
            644: " reserved",
            645: " reserved",
            646: " reserved",
            647: " reserved",
            648: " reserved",
            649: " reserved",
            65: " reserved",
            650: " reserved",
            651: " reserved",
            652: " reserved",
            653: " reserved",
            654: " reserved",
            655: " reserved",
            656: " reserved",
            657: " reserved",
            658: " reserved",
            659: " reserved",
            66: " reserved",
            660: " reserved",
            661: " reserved",
            662: " reserved",
            663: " reserved",
            664: " reserved",
            665: " reserved",
            666: " reserved",
            667: " reserved",
            668: " reserved",
            669: " reserved",
            67: " reserved",
            670: " reserved",
            671: " reserved",
            672: " reserved",
            673: " reserved",
            674: " reserved",
            675: " reserved",
            676: " reserved",
            677: " reserved",
            678: " reserved",
            679: " reserved",
            68: " reserved",
            680: " reserved",
            681: " reserved",
            682: " reserved",
            683: " reserved",
            684: " reserved",
            685: " reserved",
            686: " reserved",
            687: " reserved",
            688: " reserved",
            689: " reserved",
            69: " reserved",
            690: " reserved",
            691: " reserved",
            692: " reserved",
            693: " reserved",
            694: " reserved",
            695: " reserved",
            696: " reserved",
            697: " reserved",
            698: " reserved",
            699: " reserved",
            70: " reserved",
            700: " reserved",
            701: " reserved",
            702: " reserved",
            703: " reserved",
            704: " reserved",
            705: " reserved",
            706: " reserved",
            707: " reserved",
            708: " reserved",
            709: " reserved",
            71: " reserved",
            710: " reserved",
            711: " reserved",
            712: " reserved",
            713: " reserved",
            714: " reserved",
            715: " reserved",
            716: " reserved",
            717: " reserved",
            718: " reserved",
            719: " reserved",
            72: " reserved",
            720: " reserved",
            721: " reserved",
            722: " reserved",
            723: " reserved",
            724: " reserved",
            725: " reserved",
            726: " reserved",
            727: " reserved",
            728: " reserved",
            729: " reserved",
            73: " reserved",
            730: " reserved",
            731: " reserved",
            732: " reserved",
            733: " reserved",
            734: " reserved",
            735: " reserved",
            736: " reserved",
            737: " reserved",
            738: " reserved",
            739: " reserved",
            74: " reserved",
            740: " reserved",
            741: " reserved",
            742: " reserved",
            743: " reserved",
            744: " reserved",
            745: " reserved",
            746: " reserved",
            747: " reserved",
            748: " reserved",
            749: " reserved",
            75: " reserved",
            750: " reserved",
            751: " reserved",
            752: " reserved",
            753: " reserved",
            754: " reserved",
            755: " reserved",
            756: " reserved",
            757: " reserved",
            758: " reserved",
            759: " reserved",
            76: " reserved",
            760: " reserved",
            761: " reserved",
            762: " reserved",
            763: " reserved",
            764: " reserved",
            765: " reserved",
            766: " reserved",
            767: " reserved",
            768: " reserved",
            769: " reserved",
            77: " reserved",
            770: " reserved",
            771: " reserved",
            772: " reserved",
            773: " reserved",
            774: " reserved",
            775: " reserved",
            776: " reserved",
            777: " reserved",
            778: " reserved",
            779: " reserved",
            78: " reserved",
            780: " reserved",
            781: " reserved",
            782: " reserved",
            783: " reserved",
            784: " reserved",
            785: " reserved",
            786: " reserved",
            787: " reserved",
            788: " reserved",
            789: " reserved",
            79: " reserved",
            790: " reserved",
            791: " reserved",
            792: " reserved",
            793: " reserved",
            794: " reserved",
            795: " reserved",
            796: " reserved",
            797: " reserved",
            798: " reserved",
            799: " reserved",
            80: " reserved",
            800: " reserved",
            801: " reserved",
            802: " reserved",
            803: " reserved",
            804: " reserved",
            805: " reserved",
            806: " reserved",
            807: " reserved",
            808: " reserved",
            809: " reserved",
            81: " reserved",
            810: " reserved",
            811: " reserved",
            812: " reserved",
            813: " reserved",
            814: " reserved",
            815: " reserved",
            816: " reserved",
            817: " reserved",
            818: " reserved",
            819: " reserved",
            82: " reserved",
            820: " reserved",
            821: " reserved",
            822: " reserved",
            823: " reserved",
            824: " reserved",
            825: " reserved",
            826: " reserved",
            827: " reserved",
            828: " reserved",
            829: " reserved",
            83: " reserved",
            830: " reserved",
            831: " reserved",
            832: " reserved",
            833: " reserved",
            834: " reserved",
            835: " reserved",
            836: " reserved",
            837: " reserved",
            838: " reserved",
            839: " reserved",
            84: " reserved",
            840: " reserved",
            841: " reserved",
            842: " reserved",
            843: " reserved",
            844: " reserved",
            845: " reserved",
            846: " reserved",
            847: " reserved",
            848: " reserved",
            849: " reserved",
            85: " reserved",
            850: " reserved",
            851: " reserved",
            852: " reserved",
            853: " reserved",
            854: " reserved",
            855: " reserved",
            856: " reserved",
            857: " reserved",
            858: " reserved",
            859: " reserved",
            86: " reserved",
            860: " reserved",
            861: " reserved",
            862: " reserved",
            863: " reserved",
            864: " reserved",
            865: " reserved",
            866: " reserved",
            867: " reserved",
            868: " reserved",
            869: " reserved",
            87: " reserved",
            870: " reserved",
            871: " reserved",
            872: " reserved",
            873: " reserved",
            874: " reserved",
            875: " reserved",
            876: " reserved",
            877: " reserved",
            878: " reserved",
            879: " reserved",
            88: " reserved",
            880: " reserved",
            881: " reserved",
            882: " reserved",
            883: " reserved",
            884: " reserved",
            885: " reserved",
            886: " reserved",
            887: " reserved",
            888: " reserved",
            889: " reserved",
            89: " reserved",
            890: " reserved",
            891: " reserved",
            892: " reserved",
            893: " reserved",
            894: " reserved",
            895: " reserved",
            896: " reserved",
            897: " reserved",
            898: " reserved",
            899: " reserved",
            90: " reserved",
            900: " reserved",
            901: " reserved",
            902: " reserved",
            903: " reserved",
            904: " reserved",
            905: " reserved",
            906: " reserved",
            907: " reserved",
            908: " reserved",
            909: " reserved",
            91: " reserved",
            910: " reserved",
            911: " reserved",
            912: " reserved",
            913: " reserved",
            914: " reserved",
            915: " reserved",
            916: " reserved",
            917: " reserved",
            918: " reserved",
            919: " reserved",
            92: " reserved",
            920: " reserved",
            921: " reserved",
            922: " reserved",
            923: " reserved",
            924: " reserved",
            925: " reserved",
            926: " reserved",
            927: " reserved",
            928: " reserved",
            929: " reserved",
            93: " reserved",
            930: " reserved",
            931: " reserved",
            932: " reserved",
            933: " reserved",
            934: " reserved",
            935: " reserved",
            936: " reserved",
            937: " reserved",
            938: " reserved",
            939: " reserved",
            94: " reserved",
            940: " reserved",
            941: " reserved",
            942: " reserved",
            943: " reserved",
            944: " reserved",
            945: " reserved",
            946: " reserved",
            947: " reserved",
            948: " reserved",
            949: " reserved",
            95: " reserved",
            950: " reserved",
            951: " reserved",
            952: " reserved",
            953: " reserved",
            954: " reserved",
            955: " reserved",
            956: " reserved",
            957: " reserved",
            958: " reserved",
            959: " reserved",
            96: " reserved",
            960: " reserved",
            961: " reserved",
            962: " reserved",
            963: " reserved",
            964: " reserved",
            965: " reserved",
            966: " reserved",
            967: " reserved",
            968: " reserved",
            969: " reserved",
            97: " reserved",
            970: " reserved",
            971: " reserved",
            972: " reserved",
            973: " reserved",
            974: " reserved",
            975: " reserved",
            976: " reserved",
            977: " reserved",
            978: " reserved",
            979: " reserved",
            98: " reserved",
            980: " reserved",
            981: " reserved",
            982: " reserved",
            983: " reserved",
            984: " reserved",
            985: " reserved",
            986: " reserved",
            987: " reserved",
            988: " reserved",
            989: " reserved",
            99: " reserved",
            990: " reserved",
            991: " reserved",
            992: " reserved",
            993: " reserved",
            994: " reserved",
            995: " reserved",
            996: " reserved",
            997: " reserved",
            998: " reserved",
            999: " reserved"
        },
        3339: {
            0: " no operator control request",
            1: " momentary operator control request",
            10: " manual operator control request",
            100: "   reserved",
            1000: "   reserved",
            1001: "   reserved",
            1002: "   reserved",
            1003: "   reserved",
            1004: "   reserved",
            1005: "   reserved",
            1006: "   reserved",
            1007: "   reserved",
            1008: "   reserved",
            1009: "   reserved",
            101: "   reserved",
            1010: "   reserved",
            1011: "   reserved",
            1012: "   reserved",
            1013: "   reserved",
            1014: "   reserved",
            1015: "   reserved",
            1016: "   reserved",
            1017: "   reserved",
            1018: "   reserved",
            1019: "   reserved",
            102: "   reserved",
            1020: "   reserved",
            1021: "   reserved",
            1022: "   reserved",
            1023: "   reserved",
            1024: "   reserved",
            1025: "   reserved",
            1026: "   reserved",
            1027: "   reserved",
            1028: "   reserved",
            1029: "   reserved",
            103: "   reserved",
            1030: "   reserved",
            1031: "   reserved",
            1032: "   reserved",
            1033: "   reserved",
            1034: "   reserved",
            1035: "   reserved",
            1036: "   reserved",
            1037: "   reserved",
            1038: "   reserved",
            1039: "   reserved",
            104: "   reserved",
            1040: "   reserved",
            1041: "   reserved",
            1042: "   reserved",
            1043: "   reserved",
            1044: "   reserved",
            1045: "   reserved",
            1046: "   reserved",
            1047: "   reserved",
            1048: "   reserved",
            1049: "   reserved",
            105: "   reserved",
            1050: "   reserved",
            1051: "   reserved",
            1052: "   reserved",
            1053: "   reserved",
            1054: "   reserved",
            1055: "   reserved",
            1056: "   reserved",
            1057: "   reserved",
            1058: "   reserved",
            1059: "   reserved",
            106: "   reserved",
            1060: "   reserved",
            1061: "   reserved",
            1062: "   reserved",
            1063: "   reserved",
            1064: "   reserved",
            1065: "   reserved",
            1066: "   reserved",
            1067: "   reserved",
            1068: "   reserved",
            1069: "   reserved",
            107: "   reserved",
            1070: "   reserved",
            1071: "   reserved",
            1072: "   reserved",
            1073: "   reserved",
            1074: "   reserved",
            1075: "   reserved",
            1076: "   reserved",
            1077: "   reserved",
            1078: "   reserved",
            1079: "   reserved",
            108: "   reserved",
            1080: "   reserved",
            1081: "   reserved",
            1082: "   reserved",
            1083: "   reserved",
            1084: "   reserved",
            1085: "   reserved",
            1086: "   reserved",
            1087: "   reserved",
            1088: "   reserved",
            1089: "   reserved",
            109: "   reserved",
            1090: "   reserved",
            1091: "   reserved",
            1092: "   reserved",
            1093: "   reserved",
            1094: "   reserved",
            1095: "   reserved",
            1096: "   reserved",
            1097: "   reserved",
            1098: "   reserved",
            1099: "   reserved",
            11: " automatic operator control request",
            110: "   reserved",
            1100: "   reserved",
            1101: "   reserved",
            111: "   reserved",
            1110: " error indicator",
            1111: " not installed",
            112: "   reserved",
            113: "   reserved",
            114: "   reserved",
            115: "   reserved",
            116: "   reserved",
            117: "   reserved",
            118: "   reserved",
            119: "   reserved",
            120: "   reserved",
            121: "   reserved",
            122: "   reserved",
            123: "   reserved",
            124: "   reserved",
            125: "   reserved",
            126: "   reserved",
            127: "   reserved",
            128: "   reserved",
            129: "   reserved",
            130: "   reserved",
            131: "   reserved",
            132: "   reserved",
            133: "   reserved",
            134: "   reserved",
            135: "   reserved",
            136: "   reserved",
            137: "   reserved",
            138: "   reserved",
            139: "   reserved",
            140: "   reserved",
            141: "   reserved",
            142: "   reserved",
            143: "   reserved",
            144: "   reserved",
            145: "   reserved",
            146: "   reserved",
            147: "   reserved",
            148: "   reserved",
            149: "   reserved",
            150: "   reserved",
            151: "   reserved",
            152: "   reserved",
            153: "   reserved",
            154: "   reserved",
            155: "   reserved",
            156: "   reserved",
            157: "   reserved",
            158: "   reserved",
            159: "   reserved",
            160: "   reserved",
            161: "   reserved",
            162: "   reserved",
            163: "   reserved",
            164: "   reserved",
            165: "   reserved",
            166: "   reserved",
            167: "   reserved",
            168: "   reserved",
            169: "   reserved",
            170: "   reserved",
            171: "   reserved",
            172: "   reserved",
            173: "   reserved",
            174: "   reserved",
            175: "   reserved",
            176: "   reserved",
            177: "   reserved",
            178: "   reserved",
            179: "   reserved",
            180: "   reserved",
            181: "   reserved",
            182: "   reserved",
            183: "   reserved",
            184: "   reserved",
            185: "   reserved",
            186: "   reserved",
            187: "   reserved",
            188: "   reserved",
            189: "   reserved",
            190: "   reserved",
            191: "   reserved",
            192: "   reserved",
            193: "   reserved",
            194: "   reserved",
            195: "   reserved",
            196: "   reserved",
            197: "   reserved",
            198: "   reserved",
            199: "   reserved",
            2: ".  the momentary rocker switch may be used, where the default is the no button pressed position.  the user can press the rocker into the manual position, and when pressure is released, it will return to the no button pressed position.  the user may also press the rocker into the auto position, and when pressure is released, it will return to the no button pressed position.  momentary rocker button usage is as follows:",
            200: "   reserved",
            201: "   reserved",
            202: "   reserved",
            203: "   reserved",
            204: "   reserved",
            205: "   reserved",
            206: "   reserved",
            207: "   reserved",
            208: "   reserved",
            209: "   reserved",
            210: "   reserved",
            211: "   reserved",
            212: "   reserved",
            213: "   reserved",
            214: "   reserved",
            215: "   reserved",
            216: "   reserved",
            217: "   reserved",
            218: "   reserved",
            219: "   reserved",
            220: "   reserved",
            221: "   reserved",
            222: "   reserved",
            223: "   reserved",
            224: "   reserved",
            225: "   reserved",
            226: "   reserved",
            227: "   reserved",
            228: "   reserved",
            229: "   reserved",
            230: "   reserved",
            231: "   reserved",
            232: "   reserved",
            233: "   reserved",
            234: "   reserved",
            235: "   reserved",
            236: "   reserved",
            237: "   reserved",
            238: "   reserved",
            239: "   reserved",
            240: "   reserved",
            241: "   reserved",
            242: "   reserved",
            243: "   reserved",
            244: "   reserved",
            245: "   reserved",
            246: "   reserved",
            247: "   reserved",
            248: "   reserved",
            249: "   reserved",
            250: "   reserved",
            251: "   reserved",
            252: "   reserved",
            253: "   reserved",
            254: "   reserved",
            255: "   reserved",
            256: "   reserved",
            257: "   reserved",
            258: "   reserved",
            259: "   reserved",
            260: "   reserved",
            261: "   reserved",
            262: "   reserved",
            263: "   reserved",
            264: "   reserved",
            265: "   reserved",
            266: "   reserved",
            267: "   reserved",
            268: "   reserved",
            269: "   reserved",
            270: "   reserved",
            271: "   reserved",
            272: "   reserved",
            273: "   reserved",
            274: "   reserved",
            275: "   reserved",
            276: "   reserved",
            277: "   reserved",
            278: "   reserved",
            279: "   reserved",
            280: "   reserved",
            281: "   reserved",
            282: "   reserved",
            283: "   reserved",
            284: "   reserved",
            285: "   reserved",
            286: "   reserved",
            287: "   reserved",
            288: "   reserved",
            289: "   reserved",
            290: "   reserved",
            291: "   reserved",
            292: "   reserved",
            293: "   reserved",
            294: "   reserved",
            295: "   reserved",
            296: "   reserved",
            297: "   reserved",
            298: "   reserved",
            299: "   reserved",
            3: ".  the momentary contact button pair may be used, where the default is no buttons being pressed.  the user can press the manual button, and when pressure is released, it will return to the no button pressed position.  the user may press the auto button, and when pressure is released, it will return to the no button pressed position.  momentary contact buttons (button pair) usage is as follows:",
            300: "   reserved",
            301: "   reserved",
            302: "   reserved",
            303: "   reserved",
            304: "   reserved",
            305: "   reserved",
            306: "   reserved",
            307: "   reserved",
            308: "   reserved",
            309: "   reserved",
            310: "   reserved",
            311: "   reserved",
            312: "   reserved",
            313: "   reserved",
            314: "   reserved",
            315: "   reserved",
            316: "   reserved",
            317: "   reserved",
            318: "   reserved",
            319: "   reserved",
            320: "   reserved",
            321: "   reserved",
            322: "   reserved",
            323: "   reserved",
            324: "   reserved",
            325: "   reserved",
            326: "   reserved",
            327: "   reserved",
            328: "   reserved",
            329: "   reserved",
            330: "   reserved",
            331: "   reserved",
            332: "   reserved",
            333: "   reserved",
            334: "   reserved",
            335: "   reserved",
            336: "   reserved",
            337: "   reserved",
            338: "   reserved",
            339: "   reserved",
            340: "   reserved",
            341: "   reserved",
            342: "   reserved",
            343: "   reserved",
            344: "   reserved",
            345: "   reserved",
            346: "   reserved",
            347: "   reserved",
            348: "   reserved",
            349: "   reserved",
            350: "   reserved",
            351: "   reserved",
            352: "   reserved",
            353: "   reserved",
            354: "   reserved",
            355: "   reserved",
            356: "   reserved",
            357: "   reserved",
            358: "   reserved",
            359: "   reserved",
            360: "   reserved",
            361: "   reserved",
            362: "   reserved",
            363: "   reserved",
            364: "   reserved",
            365: "   reserved",
            366: "   reserved",
            367: "   reserved",
            368: "   reserved",
            369: "   reserved",
            370: "   reserved",
            371: "   reserved",
            372: "   reserved",
            373: "   reserved",
            374: "   reserved",
            375: "   reserved",
            376: "   reserved",
            377: "   reserved",
            378: "   reserved",
            379: "   reserved",
            380: "   reserved",
            381: "   reserved",
            382: "   reserved",
            383: "   reserved",
            384: "   reserved",
            385: "   reserved",
            386: "   reserved",
            387: "   reserved",
            388: "   reserved",
            389: "   reserved",
            390: "   reserved",
            391: "   reserved",
            392: "   reserved",
            393: "   reserved",
            394: "   reserved",
            395: "   reserved",
            396: "   reserved",
            397: "   reserved",
            398: "   reserved",
            399: "   reserved",
            4: ".  the momentary contact single button may be used, where the default is no button being pressed.  the user can press the button, which is the button pressed position, and when pressure is released, it will return to the no button pressed position.  the controller receiving this command will keep track of what mode the blade is in, auto or manual.  if the blade is in manual mode to begin with, one press of the button will change to mode to auto.  if the button is pressed again, the blade will be put into manual mode.  momentary contact button (single button) usage is as follows:",
            400: "   reserved",
            401: "   reserved",
            402: "   reserved",
            403: "   reserved",
            404: "   reserved",
            405: "   reserved",
            406: "   reserved",
            407: "   reserved",
            408: "   reserved",
            409: "   reserved",
            410: "   reserved",
            411: "   reserved",
            412: "   reserved",
            413: "   reserved",
            414: "   reserved",
            415: "   reserved",
            416: "   reserved",
            417: "   reserved",
            418: "   reserved",
            419: "   reserved",
            420: "   reserved",
            421: "   reserved",
            422: "   reserved",
            423: "   reserved",
            424: "   reserved",
            425: "   reserved",
            426: "   reserved",
            427: "   reserved",
            428: "   reserved",
            429: "   reserved",
            430: "   reserved",
            431: "   reserved",
            432: "   reserved",
            433: "   reserved",
            434: "   reserved",
            435: "   reserved",
            436: "   reserved",
            437: "   reserved",
            438: "   reserved",
            439: "   reserved",
            440: "   reserved",
            441: "   reserved",
            442: "   reserved",
            443: "   reserved",
            444: "   reserved",
            445: "   reserved",
            446: "   reserved",
            447: "   reserved",
            448: "   reserved",
            449: "   reserved",
            450: "   reserved",
            451: "   reserved",
            452: "   reserved",
            453: "   reserved",
            454: "   reserved",
            455: "   reserved",
            456: "   reserved",
            457: "   reserved",
            458: "   reserved",
            459: "   reserved",
            460: "   reserved",
            461: "   reserved",
            462: "   reserved",
            463: "   reserved",
            464: "   reserved",
            465: "   reserved",
            466: "   reserved",
            467: "   reserved",
            468: "   reserved",
            469: "   reserved",
            470: "   reserved",
            471: "   reserved",
            472: "   reserved",
            473: "   reserved",
            474: "   reserved",
            475: "   reserved",
            476: "   reserved",
            477: "   reserved",
            478: "   reserved",
            479: "   reserved",
            480: "   reserved",
            481: "   reserved",
            482: "   reserved",
            483: "   reserved",
            484: "   reserved",
            485: "   reserved",
            486: "   reserved",
            487: "   reserved",
            488: "   reserved",
            489: "   reserved",
            490: "   reserved",
            491: "   reserved",
            492: "   reserved",
            493: "   reserved",
            494: "   reserved",
            495: "   reserved",
            496: "   reserved",
            497: "   reserved",
            498: "   reserved",
            499: "   reserved",
            500: "   reserved",
            501: "   reserved",
            502: "   reserved",
            503: "   reserved",
            504: "   reserved",
            505: "   reserved",
            506: "   reserved",
            507: "   reserved",
            508: "   reserved",
            509: "   reserved",
            510: "   reserved",
            511: "   reserved",
            512: "   reserved",
            513: "   reserved",
            514: "   reserved",
            515: "   reserved",
            516: "   reserved",
            517: "   reserved",
            518: "   reserved",
            519: "   reserved",
            520: "   reserved",
            521: "   reserved",
            522: "   reserved",
            523: "   reserved",
            524: "   reserved",
            525: "   reserved",
            526: "   reserved",
            527: "   reserved",
            528: "   reserved",
            529: "   reserved",
            530: "   reserved",
            531: "   reserved",
            532: "   reserved",
            533: "   reserved",
            534: "   reserved",
            535: "   reserved",
            536: "   reserved",
            537: "   reserved",
            538: "   reserved",
            539: "   reserved",
            540: "   reserved",
            541: "   reserved",
            542: "   reserved",
            543: "   reserved",
            544: "   reserved",
            545: "   reserved",
            546: "   reserved",
            547: "   reserved",
            548: "   reserved",
            549: "   reserved",
            550: "   reserved",
            551: "   reserved",
            552: "   reserved",
            553: "   reserved",
            554: "   reserved",
            555: "   reserved",
            556: "   reserved",
            557: "   reserved",
            558: "   reserved",
            559: "   reserved",
            560: "   reserved",
            561: "   reserved",
            562: "   reserved",
            563: "   reserved",
            564: "   reserved",
            565: "   reserved",
            566: "   reserved",
            567: "   reserved",
            568: "   reserved",
            569: "   reserved",
            570: "   reserved",
            571: "   reserved",
            572: "   reserved",
            573: "   reserved",
            574: "   reserved",
            575: "   reserved",
            576: "   reserved",
            577: "   reserved",
            578: "   reserved",
            579: "   reserved",
            580: "   reserved",
            581: "   reserved",
            582: "   reserved",
            583: "   reserved",
            584: "   reserved",
            585: "   reserved",
            586: "   reserved",
            587: "   reserved",
            588: "   reserved",
            589: "   reserved",
            590: "   reserved",
            591: "   reserved",
            592: "   reserved",
            593: "   reserved",
            594: "   reserved",
            595: "   reserved",
            596: "   reserved",
            597: "   reserved",
            598: "   reserved",
            599: "   reserved",
            600: "   reserved",
            601: "   reserved",
            602: "   reserved",
            603: "   reserved",
            604: "   reserved",
            605: "   reserved",
            606: "   reserved",
            607: "   reserved",
            608: "   reserved",
            609: "   reserved",
            610: "   reserved",
            611: "   reserved",
            612: "   reserved",
            613: "   reserved",
            614: "   reserved",
            615: "   reserved",
            616: "   reserved",
            617: "   reserved",
            618: "   reserved",
            619: "   reserved",
            620: "   reserved",
            621: "   reserved",
            622: "   reserved",
            623: "   reserved",
            624: "   reserved",
            625: "   reserved",
            626: "   reserved",
            627: "   reserved",
            628: "   reserved",
            629: "   reserved",
            630: "   reserved",
            631: "   reserved",
            632: "   reserved",
            633: "   reserved",
            634: "   reserved",
            635: "   reserved",
            636: "   reserved",
            637: "   reserved",
            638: "   reserved",
            639: "   reserved",
            640: "   reserved",
            641: "   reserved",
            642: "   reserved",
            643: "   reserved",
            644: "   reserved",
            645: "   reserved",
            646: "   reserved",
            647: "   reserved",
            648: "   reserved",
            649: "   reserved",
            650: "   reserved",
            651: "   reserved",
            652: "   reserved",
            653: "   reserved",
            654: "   reserved",
            655: "   reserved",
            656: "   reserved",
            657: "   reserved",
            658: "   reserved",
            659: "   reserved",
            660: "   reserved",
            661: "   reserved",
            662: "   reserved",
            663: "   reserved",
            664: "   reserved",
            665: "   reserved",
            666: "   reserved",
            667: "   reserved",
            668: "   reserved",
            669: "   reserved",
            670: "   reserved",
            671: "   reserved",
            672: "   reserved",
            673: "   reserved",
            674: "   reserved",
            675: "   reserved",
            676: "   reserved",
            677: "   reserved",
            678: "   reserved",
            679: "   reserved",
            680: "   reserved",
            681: "   reserved",
            682: "   reserved",
            683: "   reserved",
            684: "   reserved",
            685: "   reserved",
            686: "   reserved",
            687: "   reserved",
            688: "   reserved",
            689: "   reserved",
            690: "   reserved",
            691: "   reserved",
            692: "   reserved",
            693: "   reserved",
            694: "   reserved",
            695: "   reserved",
            696: "   reserved",
            697: "   reserved",
            698: "   reserved",
            699: "   reserved",
            700: "   reserved",
            701: "   reserved",
            702: "   reserved",
            703: "   reserved",
            704: "   reserved",
            705: "   reserved",
            706: "   reserved",
            707: "   reserved",
            708: "   reserved",
            709: "   reserved",
            710: "   reserved",
            711: "   reserved",
            712: "   reserved",
            713: "   reserved",
            714: "   reserved",
            715: "   reserved",
            716: "   reserved",
            717: "   reserved",
            718: "   reserved",
            719: "   reserved",
            720: "   reserved",
            721: "   reserved",
            722: "   reserved",
            723: "   reserved",
            724: "   reserved",
            725: "   reserved",
            726: "   reserved",
            727: "   reserved",
            728: "   reserved",
            729: "   reserved",
            730: "   reserved",
            731: "   reserved",
            732: "   reserved",
            733: "   reserved",
            734: "   reserved",
            735: "   reserved",
            736: "   reserved",
            737: "   reserved",
            738: "   reserved",
            739: "   reserved",
            740: "   reserved",
            741: "   reserved",
            742: "   reserved",
            743: "   reserved",
            744: "   reserved",
            745: "   reserved",
            746: "   reserved",
            747: "   reserved",
            748: "   reserved",
            749: "   reserved",
            750: "   reserved",
            751: "   reserved",
            752: "   reserved",
            753: "   reserved",
            754: "   reserved",
            755: "   reserved",
            756: "   reserved",
            757: "   reserved",
            758: "   reserved",
            759: "   reserved",
            760: "   reserved",
            761: "   reserved",
            762: "   reserved",
            763: "   reserved",
            764: "   reserved",
            765: "   reserved",
            766: "   reserved",
            767: "   reserved",
            768: "   reserved",
            769: "   reserved",
            770: "   reserved",
            771: "   reserved",
            772: "   reserved",
            773: "   reserved",
            774: "   reserved",
            775: "   reserved",
            776: "   reserved",
            777: "   reserved",
            778: "   reserved",
            779: "   reserved",
            780: "   reserved",
            781: "   reserved",
            782: "   reserved",
            783: "   reserved",
            784: "   reserved",
            785: "   reserved",
            786: "   reserved",
            787: "   reserved",
            788: "   reserved",
            789: "   reserved",
            790: "   reserved",
            791: "   reserved",
            792: "   reserved",
            793: "   reserved",
            794: "   reserved",
            795: "   reserved",
            796: "   reserved",
            797: "   reserved",
            798: "   reserved",
            799: "   reserved",
            800: "   reserved",
            801: "   reserved",
            802: "   reserved",
            803: "   reserved",
            804: "   reserved",
            805: "   reserved",
            806: "   reserved",
            807: "   reserved",
            808: "   reserved",
            809: "   reserved",
            810: "   reserved",
            811: "   reserved",
            812: "   reserved",
            813: "   reserved",
            814: "   reserved",
            815: "   reserved",
            816: "   reserved",
            817: "   reserved",
            818: "   reserved",
            819: "   reserved",
            820: "   reserved",
            821: "   reserved",
            822: "   reserved",
            823: "   reserved",
            824: "   reserved",
            825: "   reserved",
            826: "   reserved",
            827: "   reserved",
            828: "   reserved",
            829: "   reserved",
            830: "   reserved",
            831: "   reserved",
            832: "   reserved",
            833: "   reserved",
            834: "   reserved",
            835: "   reserved",
            836: "   reserved",
            837: "   reserved",
            838: "   reserved",
            839: "   reserved",
            840: "   reserved",
            841: "   reserved",
            842: "   reserved",
            843: "   reserved",
            844: "   reserved",
            845: "   reserved",
            846: "   reserved",
            847: "   reserved",
            848: "   reserved",
            849: "   reserved",
            850: "   reserved",
            851: "   reserved",
            852: "   reserved",
            853: "   reserved",
            854: "   reserved",
            855: "   reserved",
            856: "   reserved",
            857: "   reserved",
            858: "   reserved",
            859: "   reserved",
            860: "   reserved",
            861: "   reserved",
            862: "   reserved",
            863: "   reserved",
            864: "   reserved",
            865: "   reserved",
            866: "   reserved",
            867: "   reserved",
            868: "   reserved",
            869: "   reserved",
            870: "   reserved",
            871: "   reserved",
            872: "   reserved",
            873: "   reserved",
            874: "   reserved",
            875: "   reserved",
            876: "   reserved",
            877: "   reserved",
            878: "   reserved",
            879: "   reserved",
            880: "   reserved",
            881: "   reserved",
            882: "   reserved",
            883: "   reserved",
            884: "   reserved",
            885: "   reserved",
            886: "   reserved",
            887: "   reserved",
            888: "   reserved",
            889: "   reserved",
            890: "   reserved",
            891: "   reserved",
            892: "   reserved",
            893: "   reserved",
            894: "   reserved",
            895: "   reserved",
            896: "   reserved",
            897: "   reserved",
            898: "   reserved",
            899: "   reserved",
            900: "   reserved",
            901: "   reserved",
            902: "   reserved",
            903: "   reserved",
            904: "   reserved",
            905: "   reserved",
            906: "   reserved",
            907: "   reserved",
            908: "   reserved",
            909: "   reserved",
            910: "   reserved",
            911: "   reserved",
            912: "   reserved",
            913: "   reserved",
            914: "   reserved",
            915: "   reserved",
            916: "   reserved",
            917: "   reserved",
            918: "   reserved",
            919: "   reserved",
            920: "   reserved",
            921: "   reserved",
            922: "   reserved",
            923: "   reserved",
            924: "   reserved",
            925: "   reserved",
            926: "   reserved",
            927: "   reserved",
            928: "   reserved",
            929: "   reserved",
            930: "   reserved",
            931: "   reserved",
            932: "   reserved",
            933: "   reserved",
            934: "   reserved",
            935: "   reserved",
            936: "   reserved",
            937: "   reserved",
            938: "   reserved",
            939: "   reserved",
            940: "   reserved",
            941: "   reserved",
            942: "   reserved",
            943: "   reserved",
            944: "   reserved",
            945: "   reserved",
            946: "   reserved",
            947: "   reserved",
            948: "   reserved",
            949: "   reserved",
            950: "   reserved",
            951: "   reserved",
            952: "   reserved",
            953: "   reserved",
            954: "   reserved",
            955: "   reserved",
            956: "   reserved",
            957: "   reserved",
            958: "   reserved",
            959: "   reserved",
            960: "   reserved",
            961: "   reserved",
            962: "   reserved",
            963: "   reserved",
            964: "   reserved",
            965: "   reserved",
            966: "   reserved",
            967: "   reserved",
            968: "   reserved",
            969: "   reserved",
            970: "   reserved",
            971: "   reserved",
            972: "   reserved",
            973: "   reserved",
            974: "   reserved",
            975: "   reserved",
            976: "   reserved",
            977: "   reserved",
            978: "   reserved",
            979: "   reserved",
            980: "   reserved",
            981: "   reserved",
            982: "   reserved",
            983: "   reserved",
            984: "   reserved",
            985: "   reserved",
            986: "   reserved",
            987: "   reserved",
            988: "   reserved",
            989: "   reserved",
            990: "   reserved",
            991: "   reserved",
            992: "   reserved",
            993: "   reserved",
            994: "   reserved",
            995: "   reserved",
            996: "   reserved",
            997: "   reserved",
            998: "   reserved",
            999: "   reserved"
        },
        3344: {
            1: "                      1000 ms transmission rate    ",
            2: "                        750 ms transmission rate",
            3: "                        500 ms transmission rate",
            4: "                        250 ms transmission rate",
            5: "                        100 ms transmission rate",
            6: "                          50 ms transmission rate",
            7: "                          20 ms transmission rate",
            8: "                         reserved for sae assignment (set to one)"
        },
        3345: {
            1: "                             p1                          accelerator pedal/operator selection",
            2: "                             p2                          cruise control",
            3: "                             p3                          pto governor",
            4: "                             p4                          road speed governor",
            5: "                             p5                          engine protection",
            6: "                             p6                          reserved for assignment by sae",
            7: "                             p7                          reserved for assignment by sae",
            8: "                             p8                          reserved for assignment by sae"
        },
        3346: {
            1: "                             p9                          reserved for assignment by sae",
            2: "                             p10                          reserved for assignment by sae",
            3: "                             p11                        reserved for assignment by sae",
            4: "                             p12                        reserved for assignment by sae",
            5: "                             p13                        reserved for assignment by sae",
            6: "                             p14                        reserved for assignment by sae",
            7: "                             p15                        reserved for assignment by sae",
            8: "                             p16                        reserved for assignment by sae"
        },
        3347: {
            1: "                             p17                        reserved for assignment by sae",
            2: "                             p18                        reserved for assignment by sae",
            3: "                             p19                        reserved for assignment by sae",
            4: "                             p20                        reserved for assignment by sae",
            5: "                             p21                        reserved for assignment by sae",
            6: "                             p22                        reserved for assignment by sae",
            7: "                             p23                        reserved for assignment by sae",
            8: "                             p24                        reserved for assignment by sae"
        },
        3348: {
            1: "                             p25                        reserved for assignment by sae",
            2: "                             p26                        reserved for assignment by sae",
            3: "                             p27                        reserved for assignment by sae",
            4: "                             p28                        reserved for assignment by sae",
            5: "                             p29                        reserved for assignment by sae",
            6: "                             p30                        reserved for assignment by sae",
            7: "                             p31                        reserved for assignment by sae",
            8: "                             see note               not assignable, must always be set to 1.       "
        },
        3349: {
            0: " ms transmission rate",
            1: " ms transmission rate",
            10: " ms transmission rate",
            100: " ms transmission rate",
            1000: " ms transmission rate",
            101: " ms transmission rate",
            102: " ms transmission rate",
            103: " ms transmission rate",
            104: " ms transmission rate",
            105: " ms transmission rate",
            106: " ms transmission rate",
            107: " ms transmission rate",
            108: " ms transmission rate",
            109: " ms transmission rate",
            11: " ms transmission rate",
            110: " ms transmission rate",
            111: " ms transmission rate",
            112: " ms transmission rate",
            113: " ms transmission rate",
            114: " ms transmission rate",
            115: " ms transmission rate",
            116: " ms transmission rate",
            117: " ms transmission rate",
            118: " ms transmission rate",
            119: " ms transmission rate",
            12: " ms transmission rate",
            120: " ms transmission rate",
            121: " ms transmission rate",
            122: " ms transmission rate",
            123: " ms transmission rate",
            124: " ms transmission rate",
            125: " ms transmission rate",
            126: " ms transmission rate",
            127: " ms transmission rate",
            128: " ms transmission rate",
            129: " ms transmission rate",
            13: " ms transmission rate",
            130: " ms transmission rate",
            131: " ms transmission rate",
            132: " ms transmission rate",
            133: " ms transmission rate",
            134: " ms transmission rate",
            135: " ms transmission rate",
            136: " ms transmission rate",
            137: " ms transmission rate",
            138: " ms transmission rate",
            139: " ms transmission rate",
            14: " ms transmission rate",
            140: " ms transmission rate",
            141: " ms transmission rate",
            142: " ms transmission rate",
            143: " ms transmission rate",
            144: " ms transmission rate",
            145: " ms transmission rate",
            146: " ms transmission rate",
            147: " ms transmission rate",
            148: " ms transmission rate",
            149: " ms transmission rate",
            15: " ms transmission rate",
            150: " ms transmission rate",
            151: " ms transmission rate",
            152: " ms transmission rate",
            153: " ms transmission rate",
            154: " ms transmission rate",
            155: " ms transmission rate",
            156: " ms transmission rate",
            157: " ms transmission rate",
            158: " ms transmission rate",
            159: " ms transmission rate",
            16: " ms transmission rate",
            160: " ms transmission rate",
            161: " ms transmission rate",
            162: " ms transmission rate",
            163: " ms transmission rate",
            164: " ms transmission rate",
            165: " ms transmission rate",
            166: " ms transmission rate",
            167: " ms transmission rate",
            168: " ms transmission rate",
            169: " ms transmission rate",
            17: " ms transmission rate",
            170: " ms transmission rate",
            171: " ms transmission rate",
            172: " ms transmission rate",
            173: " ms transmission rate",
            174: " ms transmission rate",
            175: " ms transmission rate",
            176: " ms transmission rate",
            177: " ms transmission rate",
            178: " ms transmission rate",
            179: " ms transmission rate",
            18: " ms transmission rate",
            180: " ms transmission rate",
            181: " ms transmission rate",
            182: " ms transmission rate",
            183: " ms transmission rate",
            184: " ms transmission rate",
            185: " ms transmission rate",
            186: " ms transmission rate",
            187: " ms transmission rate",
            188: " ms transmission rate",
            189: " ms transmission rate",
            19: " ms transmission rate",
            190: " ms transmission rate",
            191: " ms transmission rate",
            192: " ms transmission rate",
            193: " ms transmission rate",
            194: " ms transmission rate",
            195: " ms transmission rate",
            196: " ms transmission rate",
            197: " ms transmission rate",
            198: " ms transmission rate",
            199: " ms transmission rate",
            2: " ms transmission rate",
            20: " ms transmission rate",
            200: " ms transmission rate",
            201: " ms transmission rate",
            202: " ms transmission rate",
            203: " ms transmission rate",
            204: " ms transmission rate",
            205: " ms transmission rate",
            206: " ms transmission rate",
            207: " ms transmission rate",
            208: " ms transmission rate",
            209: " ms transmission rate",
            21: " ms transmission rate",
            210: " ms transmission rate",
            211: " ms transmission rate",
            212: " ms transmission rate",
            213: " ms transmission rate",
            214: " ms transmission rate",
            215: " ms transmission rate",
            216: " ms transmission rate",
            217: " ms transmission rate",
            218: " ms transmission rate",
            219: " ms transmission rate",
            22: " ms transmission rate",
            220: " ms transmission rate",
            221: " ms transmission rate",
            222: " ms transmission rate",
            223: " ms transmission rate",
            224: " ms transmission rate",
            225: " ms transmission rate",
            226: " ms transmission rate",
            227: " ms transmission rate",
            228: " ms transmission rate",
            229: " ms transmission rate",
            23: " ms transmission rate",
            230: " ms transmission rate",
            231: " ms transmission rate",
            232: " ms transmission rate",
            233: " ms transmission rate",
            234: " ms transmission rate",
            235: " ms transmission rate",
            236: " ms transmission rate",
            237: " ms transmission rate",
            238: " ms transmission rate",
            239: " ms transmission rate",
            24: " ms transmission rate",
            240: " ms transmission rate",
            241: " ms transmission rate",
            242: " ms transmission rate",
            243: " ms transmission rate",
            244: " ms transmission rate",
            245: " ms transmission rate",
            246: " ms transmission rate",
            247: " ms transmission rate",
            248: " ms transmission rate",
            249: " ms transmission rate",
            25: " ms transmission rate",
            250: " ms transmission rate",
            251: " ms transmission rate",
            252: " ms transmission rate",
            253: " ms transmission rate",
            254: " ms transmission rate",
            255: " ms transmission rate",
            256: " ms transmission rate",
            257: " ms transmission rate",
            258: " ms transmission rate",
            259: " ms transmission rate",
            26: " ms transmission rate",
            260: " ms transmission rate",
            261: " ms transmission rate",
            262: " ms transmission rate",
            263: " ms transmission rate",
            264: " ms transmission rate",
            265: " ms transmission rate",
            266: " ms transmission rate",
            267: " ms transmission rate",
            268: " ms transmission rate",
            269: " ms transmission rate",
            27: " ms transmission rate",
            270: " ms transmission rate",
            271: " ms transmission rate",
            272: " ms transmission rate",
            273: " ms transmission rate",
            274: " ms transmission rate",
            275: " ms transmission rate",
            276: " ms transmission rate",
            277: " ms transmission rate",
            278: " ms transmission rate",
            279: " ms transmission rate",
            28: " ms transmission rate",
            280: " ms transmission rate",
            281: " ms transmission rate",
            282: " ms transmission rate",
            283: " ms transmission rate",
            284: " ms transmission rate",
            285: " ms transmission rate",
            286: " ms transmission rate",
            287: " ms transmission rate",
            288: " ms transmission rate",
            289: " ms transmission rate",
            29: " ms transmission rate",
            290: " ms transmission rate",
            291: " ms transmission rate",
            292: " ms transmission rate",
            293: " ms transmission rate",
            294: " ms transmission rate",
            295: " ms transmission rate",
            296: " ms transmission rate",
            297: " ms transmission rate",
            298: " ms transmission rate",
            299: " ms transmission rate",
            3: " ms transmission rate",
            30: " ms transmission rate",
            300: " ms transmission rate",
            301: " ms transmission rate",
            302: " ms transmission rate",
            303: " ms transmission rate",
            304: " ms transmission rate",
            305: " ms transmission rate",
            306: " ms transmission rate",
            307: " ms transmission rate",
            308: " ms transmission rate",
            309: " ms transmission rate",
            31: " ms transmission rate",
            310: " ms transmission rate",
            311: " ms transmission rate",
            312: " ms transmission rate",
            313: " ms transmission rate",
            314: " ms transmission rate",
            315: " ms transmission rate",
            316: " ms transmission rate",
            317: " ms transmission rate",
            318: " ms transmission rate",
            319: " ms transmission rate",
            32: " ms transmission rate",
            320: " ms transmission rate",
            321: " ms transmission rate",
            322: " ms transmission rate",
            323: " ms transmission rate",
            324: " ms transmission rate",
            325: " ms transmission rate",
            326: " ms transmission rate",
            327: " ms transmission rate",
            328: " ms transmission rate",
            329: " ms transmission rate",
            33: " ms transmission rate",
            330: " ms transmission rate",
            331: " ms transmission rate",
            332: " ms transmission rate",
            333: " ms transmission rate",
            334: " ms transmission rate",
            335: " ms transmission rate",
            336: " ms transmission rate",
            337: " ms transmission rate",
            338: " ms transmission rate",
            339: " ms transmission rate",
            34: " ms transmission rate",
            340: " ms transmission rate",
            341: " ms transmission rate",
            342: " ms transmission rate",
            343: " ms transmission rate",
            344: " ms transmission rate",
            345: " ms transmission rate",
            346: " ms transmission rate",
            347: " ms transmission rate",
            348: " ms transmission rate",
            349: " ms transmission rate",
            35: " ms transmission rate",
            350: " ms transmission rate",
            351: " ms transmission rate",
            352: " ms transmission rate",
            353: " ms transmission rate",
            354: " ms transmission rate",
            355: " ms transmission rate",
            356: " ms transmission rate",
            357: " ms transmission rate",
            358: " ms transmission rate",
            359: " ms transmission rate",
            36: " ms transmission rate",
            360: " ms transmission rate",
            361: " ms transmission rate",
            362: " ms transmission rate",
            363: " ms transmission rate",
            364: " ms transmission rate",
            365: " ms transmission rate",
            366: " ms transmission rate",
            367: " ms transmission rate",
            368: " ms transmission rate",
            369: " ms transmission rate",
            37: " ms transmission rate",
            370: " ms transmission rate",
            371: " ms transmission rate",
            372: " ms transmission rate",
            373: " ms transmission rate",
            374: " ms transmission rate",
            375: " ms transmission rate",
            376: " ms transmission rate",
            377: " ms transmission rate",
            378: " ms transmission rate",
            379: " ms transmission rate",
            38: " ms transmission rate",
            380: " ms transmission rate",
            381: " ms transmission rate",
            382: " ms transmission rate",
            383: " ms transmission rate",
            384: " ms transmission rate",
            385: " ms transmission rate",
            386: " ms transmission rate",
            387: " ms transmission rate",
            388: " ms transmission rate",
            389: " ms transmission rate",
            39: " ms transmission rate",
            390: " ms transmission rate",
            391: " ms transmission rate",
            392: " ms transmission rate",
            393: " ms transmission rate",
            394: " ms transmission rate",
            395: " ms transmission rate",
            396: " ms transmission rate",
            397: " ms transmission rate",
            398: " ms transmission rate",
            399: " ms transmission rate",
            4: " ms transmission rate",
            40: " ms transmission rate",
            400: " ms transmission rate",
            401: " ms transmission rate",
            402: " ms transmission rate",
            403: " ms transmission rate",
            404: " ms transmission rate",
            405: " ms transmission rate",
            406: " ms transmission rate",
            407: " ms transmission rate",
            408: " ms transmission rate",
            409: " ms transmission rate",
            41: " ms transmission rate",
            410: " ms transmission rate",
            411: " ms transmission rate",
            412: " ms transmission rate",
            413: " ms transmission rate",
            414: " ms transmission rate",
            415: " ms transmission rate",
            416: " ms transmission rate",
            417: " ms transmission rate",
            418: " ms transmission rate",
            419: " ms transmission rate",
            42: " ms transmission rate",
            420: " ms transmission rate",
            421: " ms transmission rate",
            422: " ms transmission rate",
            423: " ms transmission rate",
            424: " ms transmission rate",
            425: " ms transmission rate",
            426: " ms transmission rate",
            427: " ms transmission rate",
            428: " ms transmission rate",
            429: " ms transmission rate",
            43: " ms transmission rate",
            430: " ms transmission rate",
            431: " ms transmission rate",
            432: " ms transmission rate",
            433: " ms transmission rate",
            434: " ms transmission rate",
            435: " ms transmission rate",
            436: " ms transmission rate",
            437: " ms transmission rate",
            438: " ms transmission rate",
            439: " ms transmission rate",
            44: " ms transmission rate",
            440: " ms transmission rate",
            441: " ms transmission rate",
            442: " ms transmission rate",
            443: " ms transmission rate",
            444: " ms transmission rate",
            445: " ms transmission rate",
            446: " ms transmission rate",
            447: " ms transmission rate",
            448: " ms transmission rate",
            449: " ms transmission rate",
            45: " ms transmission rate",
            450: " ms transmission rate",
            451: " ms transmission rate",
            452: " ms transmission rate",
            453: " ms transmission rate",
            454: " ms transmission rate",
            455: " ms transmission rate",
            456: " ms transmission rate",
            457: " ms transmission rate",
            458: " ms transmission rate",
            459: " ms transmission rate",
            46: " ms transmission rate",
            460: " ms transmission rate",
            461: " ms transmission rate",
            462: " ms transmission rate",
            463: " ms transmission rate",
            464: " ms transmission rate",
            465: " ms transmission rate",
            466: " ms transmission rate",
            467: " ms transmission rate",
            468: " ms transmission rate",
            469: " ms transmission rate",
            47: " ms transmission rate",
            470: " ms transmission rate",
            471: " ms transmission rate",
            472: " ms transmission rate",
            473: " ms transmission rate",
            474: " ms transmission rate",
            475: " ms transmission rate",
            476: " ms transmission rate",
            477: " ms transmission rate",
            478: " ms transmission rate",
            479: " ms transmission rate",
            48: " ms transmission rate",
            480: " ms transmission rate",
            481: " ms transmission rate",
            482: " ms transmission rate",
            483: " ms transmission rate",
            484: " ms transmission rate",
            485: " ms transmission rate",
            486: " ms transmission rate",
            487: " ms transmission rate",
            488: " ms transmission rate",
            489: " ms transmission rate",
            49: " ms transmission rate",
            490: " ms transmission rate",
            491: " ms transmission rate",
            492: " ms transmission rate",
            493: " ms transmission rate",
            494: " ms transmission rate",
            495: " ms transmission rate",
            496: " ms transmission rate",
            497: " ms transmission rate",
            498: " ms transmission rate",
            499: " ms transmission rate",
            5: " ms transmission rate",
            50: " ms transmission rate",
            500: " ms transmission rate",
            501: " ms transmission rate",
            502: " ms transmission rate",
            503: " ms transmission rate",
            504: " ms transmission rate",
            505: " ms transmission rate",
            506: " ms transmission rate",
            507: " ms transmission rate",
            508: " ms transmission rate",
            509: " ms transmission rate",
            51: " ms transmission rate",
            510: " ms transmission rate",
            511: " ms transmission rate",
            512: " ms transmission rate",
            513: " ms transmission rate",
            514: " ms transmission rate",
            515: " ms transmission rate",
            516: " ms transmission rate",
            517: " ms transmission rate",
            518: " ms transmission rate",
            519: " ms transmission rate",
            52: " ms transmission rate",
            520: " ms transmission rate",
            521: " ms transmission rate",
            522: " ms transmission rate",
            523: " ms transmission rate",
            524: " ms transmission rate",
            525: " ms transmission rate",
            526: " ms transmission rate",
            527: " ms transmission rate",
            528: " ms transmission rate",
            529: " ms transmission rate",
            53: " ms transmission rate",
            530: " ms transmission rate",
            531: " ms transmission rate",
            532: " ms transmission rate",
            533: " ms transmission rate",
            534: " ms transmission rate",
            535: " ms transmission rate",
            536: " ms transmission rate",
            537: " ms transmission rate",
            538: " ms transmission rate",
            539: " ms transmission rate",
            54: " ms transmission rate",
            540: " ms transmission rate",
            541: " ms transmission rate",
            542: " ms transmission rate",
            543: " ms transmission rate",
            544: " ms transmission rate",
            545: " ms transmission rate",
            546: " ms transmission rate",
            547: " ms transmission rate",
            548: " ms transmission rate",
            549: " ms transmission rate",
            55: " ms transmission rate",
            550: " ms transmission rate",
            551: " ms transmission rate",
            552: " ms transmission rate",
            553: " ms transmission rate",
            554: " ms transmission rate",
            555: " ms transmission rate",
            556: " ms transmission rate",
            557: " ms transmission rate",
            558: " ms transmission rate",
            559: " ms transmission rate",
            56: " ms transmission rate",
            560: " ms transmission rate",
            561: " ms transmission rate",
            562: " ms transmission rate",
            563: " ms transmission rate",
            564: " ms transmission rate",
            565: " ms transmission rate",
            566: " ms transmission rate",
            567: " ms transmission rate",
            568: " ms transmission rate",
            569: " ms transmission rate",
            57: " ms transmission rate",
            570: " ms transmission rate",
            571: " ms transmission rate",
            572: " ms transmission rate",
            573: " ms transmission rate",
            574: " ms transmission rate",
            575: " ms transmission rate",
            576: " ms transmission rate",
            577: " ms transmission rate",
            578: " ms transmission rate",
            579: " ms transmission rate",
            58: " ms transmission rate",
            580: " ms transmission rate",
            581: " ms transmission rate",
            582: " ms transmission rate",
            583: " ms transmission rate",
            584: " ms transmission rate",
            585: " ms transmission rate",
            586: " ms transmission rate",
            587: " ms transmission rate",
            588: " ms transmission rate",
            589: " ms transmission rate",
            59: " ms transmission rate",
            590: " ms transmission rate",
            591: " ms transmission rate",
            592: " ms transmission rate",
            593: " ms transmission rate",
            594: " ms transmission rate",
            595: " ms transmission rate",
            596: " ms transmission rate",
            597: " ms transmission rate",
            598: " ms transmission rate",
            599: " ms transmission rate",
            6: " ms transmission rate",
            60: " ms transmission rate",
            600: " ms transmission rate",
            601: " ms transmission rate",
            602: " ms transmission rate",
            603: " ms transmission rate",
            604: " ms transmission rate",
            605: " ms transmission rate",
            606: " ms transmission rate",
            607: " ms transmission rate",
            608: " ms transmission rate",
            609: " ms transmission rate",
            61: " ms transmission rate",
            610: " ms transmission rate",
            611: " ms transmission rate",
            612: " ms transmission rate",
            613: " ms transmission rate",
            614: " ms transmission rate",
            615: " ms transmission rate",
            616: " ms transmission rate",
            617: " ms transmission rate",
            618: " ms transmission rate",
            619: " ms transmission rate",
            62: " ms transmission rate",
            620: " ms transmission rate",
            621: " ms transmission rate",
            622: " ms transmission rate",
            623: " ms transmission rate",
            624: " ms transmission rate",
            625: " ms transmission rate",
            626: " ms transmission rate",
            627: " ms transmission rate",
            628: " ms transmission rate",
            629: " ms transmission rate",
            63: " ms transmission rate",
            630: " ms transmission rate",
            631: " ms transmission rate",
            632: " ms transmission rate",
            633: " ms transmission rate",
            634: " ms transmission rate",
            635: " ms transmission rate",
            636: " ms transmission rate",
            637: " ms transmission rate",
            638: " ms transmission rate",
            639: " ms transmission rate",
            64: " ms transmission rate",
            640: " ms transmission rate",
            641: " ms transmission rate",
            642: " ms transmission rate",
            643: " ms transmission rate",
            644: " ms transmission rate",
            645: " ms transmission rate",
            646: " ms transmission rate",
            647: " ms transmission rate",
            648: " ms transmission rate",
            649: " ms transmission rate",
            65: " ms transmission rate",
            650: " ms transmission rate",
            651: " ms transmission rate",
            652: " ms transmission rate",
            653: " ms transmission rate",
            654: " ms transmission rate",
            655: " ms transmission rate",
            656: " ms transmission rate",
            657: " ms transmission rate",
            658: " ms transmission rate",
            659: " ms transmission rate",
            66: " ms transmission rate",
            660: " ms transmission rate",
            661: " ms transmission rate",
            662: " ms transmission rate",
            663: " ms transmission rate",
            664: " ms transmission rate",
            665: " ms transmission rate",
            666: " ms transmission rate",
            667: " ms transmission rate",
            668: " ms transmission rate",
            669: " ms transmission rate",
            67: " ms transmission rate",
            670: " ms transmission rate",
            671: " ms transmission rate",
            672: " ms transmission rate",
            673: " ms transmission rate",
            674: " ms transmission rate",
            675: " ms transmission rate",
            676: " ms transmission rate",
            677: " ms transmission rate",
            678: " ms transmission rate",
            679: " ms transmission rate",
            68: " ms transmission rate",
            680: " ms transmission rate",
            681: " ms transmission rate",
            682: " ms transmission rate",
            683: " ms transmission rate",
            684: " ms transmission rate",
            685: " ms transmission rate",
            686: " ms transmission rate",
            687: " ms transmission rate",
            688: " ms transmission rate",
            689: " ms transmission rate",
            69: " ms transmission rate",
            690: " ms transmission rate",
            691: " ms transmission rate",
            692: " ms transmission rate",
            693: " ms transmission rate",
            694: " ms transmission rate",
            695: " ms transmission rate",
            696: " ms transmission rate",
            697: " ms transmission rate",
            698: " ms transmission rate",
            699: " ms transmission rate",
            7: " ms transmission rate",
            70: " ms transmission rate",
            700: " ms transmission rate",
            701: " ms transmission rate",
            702: " ms transmission rate",
            703: " ms transmission rate",
            704: " ms transmission rate",
            705: " ms transmission rate",
            706: " ms transmission rate",
            707: " ms transmission rate",
            708: " ms transmission rate",
            709: " ms transmission rate",
            71: " ms transmission rate",
            710: " ms transmission rate",
            711: " ms transmission rate",
            712: " ms transmission rate",
            713: " ms transmission rate",
            714: " ms transmission rate",
            715: " ms transmission rate",
            716: " ms transmission rate",
            717: " ms transmission rate",
            718: " ms transmission rate",
            719: " ms transmission rate",
            72: " ms transmission rate",
            720: " ms transmission rate",
            721: " ms transmission rate",
            722: " ms transmission rate",
            723: " ms transmission rate",
            724: " ms transmission rate",
            725: " ms transmission rate",
            726: " ms transmission rate",
            727: " ms transmission rate",
            728: " ms transmission rate",
            729: " ms transmission rate",
            73: " ms transmission rate",
            730: " ms transmission rate",
            731: " ms transmission rate",
            732: " ms transmission rate",
            733: " ms transmission rate",
            734: " ms transmission rate",
            735: " ms transmission rate",
            736: " ms transmission rate",
            737: " ms transmission rate",
            738: " ms transmission rate",
            739: " ms transmission rate",
            74: " ms transmission rate",
            740: " ms transmission rate",
            741: " ms transmission rate",
            742: " ms transmission rate",
            743: " ms transmission rate",
            744: " ms transmission rate",
            745: " ms transmission rate",
            746: " ms transmission rate",
            747: " ms transmission rate",
            748: " ms transmission rate",
            749: " ms transmission rate",
            75: " ms transmission rate",
            750: " ms transmission rate",
            751: " ms transmission rate",
            752: " ms transmission rate",
            753: " ms transmission rate",
            754: " ms transmission rate",
            755: " ms transmission rate",
            756: " ms transmission rate",
            757: " ms transmission rate",
            758: " ms transmission rate",
            759: " ms transmission rate",
            76: " ms transmission rate",
            760: " ms transmission rate",
            761: " ms transmission rate",
            762: " ms transmission rate",
            763: " ms transmission rate",
            764: " ms transmission rate",
            765: " ms transmission rate",
            766: " ms transmission rate",
            767: " ms transmission rate",
            768: " ms transmission rate",
            769: " ms transmission rate",
            77: " ms transmission rate",
            770: " ms transmission rate",
            771: " ms transmission rate",
            772: " ms transmission rate",
            773: " ms transmission rate",
            774: " ms transmission rate",
            775: " ms transmission rate",
            776: " ms transmission rate",
            777: " ms transmission rate",
            778: " ms transmission rate",
            779: " ms transmission rate",
            78: " ms transmission rate",
            780: " ms transmission rate",
            781: " ms transmission rate",
            782: " ms transmission rate",
            783: " ms transmission rate",
            784: " ms transmission rate",
            785: " ms transmission rate",
            786: " ms transmission rate",
            787: " ms transmission rate",
            788: " ms transmission rate",
            789: " ms transmission rate",
            79: " ms transmission rate",
            790: " ms transmission rate",
            791: " ms transmission rate",
            792: " ms transmission rate",
            793: " ms transmission rate",
            794: " ms transmission rate",
            795: " ms transmission rate",
            796: " ms transmission rate",
            797: " ms transmission rate",
            798: " ms transmission rate",
            799: " ms transmission rate",
            8: " ms transmission rate",
            80: " ms transmission rate",
            800: " ms transmission rate",
            801: " ms transmission rate",
            802: " ms transmission rate",
            803: " ms transmission rate",
            804: " ms transmission rate",
            805: " ms transmission rate",
            806: " ms transmission rate",
            807: " ms transmission rate",
            808: " ms transmission rate",
            809: " ms transmission rate",
            81: " ms transmission rate",
            810: " ms transmission rate",
            811: " ms transmission rate",
            812: " ms transmission rate",
            813: " ms transmission rate",
            814: " ms transmission rate",
            815: " ms transmission rate",
            816: " ms transmission rate",
            817: " ms transmission rate",
            818: " ms transmission rate",
            819: " ms transmission rate",
            82: " ms transmission rate",
            820: " ms transmission rate",
            821: " ms transmission rate",
            822: " ms transmission rate",
            823: " ms transmission rate",
            824: " ms transmission rate",
            825: " ms transmission rate",
            826: " ms transmission rate",
            827: " ms transmission rate",
            828: " ms transmission rate",
            829: " ms transmission rate",
            83: " ms transmission rate",
            830: " ms transmission rate",
            831: " ms transmission rate",
            832: " ms transmission rate",
            833: " ms transmission rate",
            834: " ms transmission rate",
            835: " ms transmission rate",
            836: " ms transmission rate",
            837: " ms transmission rate",
            838: " ms transmission rate",
            839: " ms transmission rate",
            84: " ms transmission rate",
            840: " ms transmission rate",
            841: " ms transmission rate",
            842: " ms transmission rate",
            843: " ms transmission rate",
            844: " ms transmission rate",
            845: " ms transmission rate",
            846: " ms transmission rate",
            847: " ms transmission rate",
            848: " ms transmission rate",
            849: " ms transmission rate",
            85: " ms transmission rate",
            850: " ms transmission rate",
            851: " ms transmission rate",
            852: " ms transmission rate",
            853: " ms transmission rate",
            854: " ms transmission rate",
            855: " ms transmission rate",
            856: " ms transmission rate",
            857: " ms transmission rate",
            858: " ms transmission rate",
            859: " ms transmission rate",
            86: " ms transmission rate",
            860: " ms transmission rate",
            861: " ms transmission rate",
            862: " ms transmission rate",
            863: " ms transmission rate",
            864: " ms transmission rate",
            865: " ms transmission rate",
            866: " ms transmission rate",
            867: " ms transmission rate",
            868: " ms transmission rate",
            869: " ms transmission rate",
            87: " ms transmission rate",
            870: " ms transmission rate",
            871: " ms transmission rate",
            872: " ms transmission rate",
            873: " ms transmission rate",
            874: " ms transmission rate",
            875: " ms transmission rate",
            876: " ms transmission rate",
            877: " ms transmission rate",
            878: " ms transmission rate",
            879: " ms transmission rate",
            88: " ms transmission rate",
            880: " ms transmission rate",
            881: " ms transmission rate",
            882: " ms transmission rate",
            883: " ms transmission rate",
            884: " ms transmission rate",
            885: " ms transmission rate",
            886: " ms transmission rate",
            887: " ms transmission rate",
            888: " ms transmission rate",
            889: " ms transmission rate",
            89: " ms transmission rate",
            890: " ms transmission rate",
            891: " ms transmission rate",
            892: " ms transmission rate",
            893: " ms transmission rate",
            894: " ms transmission rate",
            895: " ms transmission rate",
            896: " ms transmission rate",
            897: " ms transmission rate",
            898: " ms transmission rate",
            899: " ms transmission rate",
            9: " ms transmission rate",
            90: " ms transmission rate",
            900: " ms transmission rate",
            901: " ms transmission rate",
            902: " ms transmission rate",
            903: " ms transmission rate",
            904: " ms transmission rate",
            905: " ms transmission rate",
            906: " ms transmission rate",
            907: " ms transmission rate",
            908: " ms transmission rate",
            909: " ms transmission rate",
            91: " ms transmission rate",
            910: " ms transmission rate",
            911: " ms transmission rate",
            912: " ms transmission rate",
            913: " ms transmission rate",
            914: " ms transmission rate",
            915: " ms transmission rate",
            916: " ms transmission rate",
            917: " ms transmission rate",
            918: " ms transmission rate",
            919: " ms transmission rate",
            92: " ms transmission rate",
            920: " ms transmission rate",
            921: " ms transmission rate",
            922: " ms transmission rate",
            923: " ms transmission rate",
            924: " ms transmission rate",
            925: " ms transmission rate",
            926: " ms transmission rate",
            927: " ms transmission rate",
            928: " ms transmission rate",
            929: " ms transmission rate",
            93: " ms transmission rate",
            930: " ms transmission rate",
            931: " ms transmission rate",
            932: " ms transmission rate",
            933: " ms transmission rate",
            934: " ms transmission rate",
            935: " ms transmission rate",
            936: " ms transmission rate",
            937: " ms transmission rate",
            938: " ms transmission rate",
            939: " ms transmission rate",
            94: " ms transmission rate",
            940: " ms transmission rate",
            941: " ms transmission rate",
            942: " ms transmission rate",
            943: " ms transmission rate",
            944: " ms transmission rate",
            945: " ms transmission rate",
            946: " ms transmission rate",
            947: " ms transmission rate",
            948: " ms transmission rate",
            949: " ms transmission rate",
            95: " ms transmission rate",
            950: " ms transmission rate",
            951: " ms transmission rate",
            952: " ms transmission rate",
            953: " ms transmission rate",
            954: " ms transmission rate",
            955: " ms transmission rate",
            956: " ms transmission rate",
            957: " ms transmission rate",
            958: " ms transmission rate",
            959: " ms transmission rate",
            96: " ms transmission rate",
            960: " ms transmission rate",
            961: " ms transmission rate",
            962: " ms transmission rate",
            963: " ms transmission rate",
            964: " ms transmission rate",
            965: " ms transmission rate",
            966: " ms transmission rate",
            967: " ms transmission rate",
            968: " ms transmission rate",
            969: " ms transmission rate",
            97: " ms transmission rate",
            970: " ms transmission rate",
            971: " ms transmission rate",
            972: " ms transmission rate",
            973: " ms transmission rate",
            974: " ms transmission rate",
            975: " ms transmission rate",
            976: " ms transmission rate",
            977: " ms transmission rate",
            978: " ms transmission rate",
            979: " ms transmission rate",
            98: " ms transmission rate",
            980: " ms transmission rate",
            981: " ms transmission rate",
            982: " ms transmission rate",
            983: " ms transmission rate",
            984: " ms transmission rate",
            985: " ms transmission rate",
            986: " ms transmission rate",
            987: " ms transmission rate",
            988: " ms transmission rate",
            989: " ms transmission rate",
            99: " ms transmission rate",
            990: " ms transmission rate",
            991: " ms transmission rate",
            992: " ms transmission rate",
            993: " ms transmission rate",
            994: " ms transmission rate",
            995: " ms transmission rate",
            996: " ms transmission rate",
            997: " ms transmission rate",
            998: " ms transmission rate",
            999: " ms transmission rate"
        },
        3350: {
            0: "p1 = accelerator pedal/operator selection",
            1: "p2 = cruise control",
            10: "p6-p31 = reserved for sae assignment ",
            11: "p6-p31 = reserved for sae assignment ",
            12: "p6-p31 = reserved for sae assignment ",
            13: "p6-p31 = reserved for sae assignment ",
            14: "p6-p31 = reserved for sae assignment ",
            15: "p6-p31 = reserved for sae assignment ",
            16: "p6-p31 = reserved for sae assignment ",
            17: "p6-p31 = reserved for sae assignment ",
            18: "p6-p31 = reserved for sae assignment ",
            19: "p6-p31 = reserved for sae assignment ",
            2: "p3 = pto governor",
            20: "p6-p31 = reserved for sae assignment ",
            21: "p6-p31 = reserved for sae assignment ",
            22: "p6-p31 = reserved for sae assignment ",
            23: "p6-p31 = reserved for sae assignment ",
            24: "p6-p31 = reserved for sae assignment ",
            25: "p6-p31 = reserved for sae assignment ",
            26: "p6-p31 = reserved for sae assignment ",
            27: "p6-p31 = reserved for sae assignment ",
            28: "p6-p31 = reserved for sae assignment ",
            29: "p6-p31 = reserved for sae assignment ",
            3: "p4 = road speed governor",
            30: "p6-p31 = reserved for sae assignment ",
            31: "p32 = temporary power train control (original use of tsc1 command) ",
            4: "p5 = engine protection",
            5: "p6-p31 = reserved for sae assignment ",
            6: "p6-p31 = reserved for sae assignment ",
            7: "p6-p31 = reserved for sae assignment ",
            8: "p6-p31 = reserved for sae assignment ",
            9: "p6-p31 = reserved for sae assignment "
        },
        3353: {
            0: " alternator 1 not charging",
            1: " alternator 1 charging",
            2: " error",
            3: " not available"
        },
        3354: {
            0: " alternator 2 not charging",
            1: " alternator 2 charging",
            2: " error",
            3: " not available"
        },
        3355: {
            0: " alternator 3 not charging",
            1: " alternator 3 charging",
            2: " error",
            3: " not available"
        },
        3356: {
            0: " alternator 4 not charging",
            1: " alternator 4 charging",
            2: " error",
            3: " not available"
        },
        3359: {
            0: "no restriction",
            1: "restriction exists on oil filter",
            2: "error",
            3: "not available"
        },
        3367: {
            0: "  relative blade height fully functional.  data is within sensor specification.   ",
            1: "  relative blade height degraded.  data is suspect due to environmental conditions.",
            2: "  relative blade height failed.  ",
            3: "  relative blade height not available"
        },
        3368: {
            0: "off",
            1: "on",
            10: "reserved for future assignment",
            100: "reserved for future assignment",
            101: "reserved for future assignment",
            102: "reserved for future assignment",
            103: "reserved for future assignment",
            104: "reserved for future assignment",
            105: "reserved for future assignment",
            106: "reserved for future assignment",
            107: "reserved for future assignment",
            108: "reserved for future assignment",
            109: "reserved for future assignment",
            11: "reserved for future assignment",
            110: "reserved for future assignment",
            111: "reserved for future assignment",
            112: "reserved for future assignment",
            113: "reserved for future assignment",
            114: "reserved for future assignment",
            115: "reserved for future assignment",
            116: "reserved for future assignment",
            117: "reserved for future assignment",
            118: "reserved for future assignment",
            119: "reserved for future assignment",
            12: "reserved for future assignment",
            120: "reserved for future assignment",
            121: "reserved for future assignment",
            122: "reserved for future assignment",
            123: "reserved for future assignment",
            124: "reserved for future assignment",
            125: "reserved for future assignment",
            126: "reserved for future assignment",
            127: "reserved for future assignment",
            128: "reserved for future assignment",
            129: "reserved for future assignment",
            13: "reserved for future assignment",
            130: "reserved for future assignment",
            131: "reserved for future assignment",
            132: "reserved for future assignment",
            133: "reserved for future assignment",
            134: "reserved for future assignment",
            135: "reserved for future assignment",
            136: "reserved for future assignment",
            137: "reserved for future assignment",
            138: "reserved for future assignment",
            139: "reserved for future assignment",
            14: "reserved for future assignment",
            140: "reserved for future assignment",
            141: "reserved for future assignment",
            142: "reserved for future assignment",
            143: "reserved for future assignment",
            144: "reserved for future assignment",
            145: "reserved for future assignment",
            146: "reserved for future assignment",
            147: "reserved for future assignment",
            148: "reserved for future assignment",
            149: "reserved for future assignment",
            15: "reserved for future assignment",
            150: "reserved for future assignment",
            151: "reserved for future assignment",
            152: "reserved for future assignment",
            153: "reserved for future assignment",
            154: "reserved for future assignment",
            155: "reserved for future assignment",
            156: "reserved for future assignment",
            157: "reserved for future assignment",
            158: "reserved for future assignment",
            159: "reserved for future assignment",
            16: "reserved for future assignment",
            160: "reserved for future assignment",
            161: "reserved for future assignment",
            162: "reserved for future assignment",
            163: "reserved for future assignment",
            164: "reserved for future assignment",
            165: "reserved for future assignment",
            166: "reserved for future assignment",
            167: "reserved for future assignment",
            168: "reserved for future assignment",
            169: "reserved for future assignment",
            17: "reserved for future assignment",
            170: "reserved for future assignment",
            171: "reserved for future assignment",
            172: "reserved for future assignment",
            173: "reserved for future assignment",
            174: "reserved for future assignment",
            175: "reserved for future assignment",
            176: "reserved for future assignment",
            177: "reserved for future assignment",
            178: "reserved for future assignment",
            179: "reserved for future assignment",
            18: "reserved for future assignment",
            180: "reserved for future assignment",
            181: "reserved for future assignment",
            182: "reserved for future assignment",
            183: "reserved for future assignment",
            184: "reserved for future assignment",
            185: "reserved for future assignment",
            186: "reserved for future assignment",
            187: "reserved for future assignment",
            188: "reserved for future assignment",
            189: "reserved for future assignment",
            19: "reserved for future assignment",
            190: "reserved for future assignment",
            191: "reserved for future assignment",
            192: "reserved for future assignment",
            193: "reserved for future assignment",
            194: "reserved for future assignment",
            195: "reserved for future assignment",
            196: "reserved for future assignment",
            197: "reserved for future assignment",
            198: "reserved for future assignment",
            199: "reserved for future assignment",
            2: "not authorized to operate on network",
            20: "reserved for future assignment",
            200: "reserved for future assignment",
            201: "reserved for future assignment",
            202: "reserved for future assignment",
            203: "reserved for future assignment",
            204: "reserved for future assignment",
            205: "reserved for future assignment",
            206: "reserved for future assignment",
            207: "reserved for future assignment",
            208: "reserved for future assignment",
            209: "reserved for future assignment",
            21: "reserved for future assignment",
            210: "reserved for future assignment",
            211: "reserved for future assignment",
            212: "reserved for future assignment",
            213: "reserved for future assignment",
            214: "reserved for future assignment",
            215: "reserved for future assignment",
            216: "reserved for future assignment",
            217: "reserved for future assignment",
            218: "reserved for future assignment",
            219: "reserved for future assignment",
            22: "reserved for future assignment",
            220: "reserved for future assignment",
            221: "reserved for future assignment",
            222: "reserved for future assignment",
            223: "reserved for future assignment",
            224: "reserved for future assignment",
            225: "reserved for future assignment",
            226: "reserved for future assignment",
            227: "reserved for future assignment",
            228: "reserved for future assignment",
            229: "reserved for future assignment",
            23: "reserved for future assignment",
            230: "reserved for future assignment",
            231: "reserved for future assignment",
            232: "reserved for future assignment",
            233: "reserved for future assignment",
            234: "reserved for future assignment",
            235: "reserved for future assignment",
            236: "reserved for future assignment",
            237: "reserved for future assignment",
            238: "reserved for future assignment",
            239: "reserved for future assignment",
            24: "reserved for future assignment",
            240: "reserved for future assignment",
            241: "reserved for future assignment",
            242: "reserved for future assignment",
            243: "reserved for future assignment",
            244: "reserved for future assignment",
            245: "reserved for future assignment",
            246: "reserved for future assignment",
            247: "reserved for future assignment",
            248: "reserved for future assignment",
            249: "reserved for future assignment",
            25: "reserved for future assignment",
            250: "reserved for future assignment",
            251: "reserved",
            252: "reserved",
            253: "reserved",
            254: "error",
            255: "not available",
            26: "reserved for future assignment",
            27: "reserved for future assignment",
            28: "reserved for future assignment",
            29: "reserved for future assignment",
            3: "reserved for future assignment",
            30: "reserved for future assignment",
            31: "reserved for future assignment",
            32: "reserved for future assignment",
            33: "reserved for future assignment",
            34: "reserved for future assignment",
            35: "reserved for future assignment",
            36: "reserved for future assignment",
            37: "reserved for future assignment",
            38: "reserved for future assignment",
            39: "reserved for future assignment",
            4: "reserved for future assignment",
            40: "reserved for future assignment",
            41: "reserved for future assignment",
            42: "reserved for future assignment",
            43: "reserved for future assignment",
            44: "reserved for future assignment",
            45: "reserved for future assignment",
            46: "reserved for future assignment",
            47: "reserved for future assignment",
            48: "reserved for future assignment",
            49: "reserved for future assignment",
            5: "reserved for future assignment",
            50: "reserved for future assignment",
            51: "reserved for future assignment",
            52: "reserved for future assignment",
            53: "reserved for future assignment",
            54: "reserved for future assignment",
            55: "reserved for future assignment",
            56: "reserved for future assignment",
            57: "reserved for future assignment",
            58: "reserved for future assignment",
            59: "reserved for future assignment",
            6: "reserved for future assignment",
            60: "reserved for future assignment",
            61: "reserved for future assignment",
            62: "reserved for future assignment",
            63: "reserved for future assignment",
            64: "reserved for future assignment",
            65: "reserved for future assignment",
            66: "reserved for future assignment",
            67: "reserved for future assignment",
            68: "reserved for future assignment",
            69: "reserved for future assignment",
            7: "reserved for future assignment",
            70: "reserved for future assignment",
            71: "reserved for future assignment",
            72: "reserved for future assignment",
            73: "reserved for future assignment",
            74: "reserved for future assignment",
            75: "reserved for future assignment",
            76: "reserved for future assignment",
            77: "reserved for future assignment",
            78: "reserved for future assignment",
            79: "reserved for future assignment",
            8: "reserved for future assignment",
            80: "reserved for future assignment",
            81: "reserved for future assignment",
            82: "reserved for future assignment",
            83: "reserved for future assignment",
            84: "reserved for future assignment",
            85: "reserved for future assignment",
            86: "reserved for future assignment",
            87: "reserved for future assignment",
            88: "reserved for future assignment",
            89: "reserved for future assignment",
            9: "reserved for future assignment",
            90: "reserved for future assignment",
            91: "reserved for future assignment",
            92: "reserved for future assignment",
            93: "reserved for future assignment",
            94: "reserved for future assignment",
            95: "reserved for future assignment",
            96: "reserved for future assignment",
            97: "reserved for future assignment",
            98: "reserved for future assignment",
            99: "reserved for future assignment"
        },
        3369: {
            0: "local service",
            1: "roaming service",
            10: "reserved for future assignment",
            100: "reserved for future assignment",
            101: "reserved for future assignment",
            102: "reserved for future assignment",
            103: "reserved for future assignment",
            104: "reserved for future assignment",
            105: "reserved for future assignment",
            106: "reserved for future assignment",
            107: "reserved for future assignment",
            108: "reserved for future assignment",
            109: "reserved for future assignment",
            11: "reserved for future assignment",
            110: "reserved for future assignment",
            111: "reserved for future assignment",
            112: "reserved for future assignment",
            113: "reserved for future assignment",
            114: "reserved for future assignment",
            115: "reserved for future assignment",
            116: "reserved for future assignment",
            117: "reserved for future assignment",
            118: "reserved for future assignment",
            119: "reserved for future assignment",
            12: "reserved for future assignment",
            120: "reserved for future assignment",
            121: "reserved for future assignment",
            122: "reserved for future assignment",
            123: "reserved for future assignment",
            124: "reserved for future assignment",
            125: "reserved for future assignment",
            126: "reserved for future assignment",
            127: "reserved for future assignment",
            128: "reserved for future assignment",
            129: "reserved for future assignment",
            13: "reserved for future assignment",
            130: "reserved for future assignment",
            131: "reserved for future assignment",
            132: "reserved for future assignment",
            133: "reserved for future assignment",
            134: "reserved for future assignment",
            135: "reserved for future assignment",
            136: "reserved for future assignment",
            137: "reserved for future assignment",
            138: "reserved for future assignment",
            139: "reserved for future assignment",
            14: "reserved for future assignment",
            140: "reserved for future assignment",
            141: "reserved for future assignment",
            142: "reserved for future assignment",
            143: "reserved for future assignment",
            144: "reserved for future assignment",
            145: "reserved for future assignment",
            146: "reserved for future assignment",
            147: "reserved for future assignment",
            148: "reserved for future assignment",
            149: "reserved for future assignment",
            15: "reserved for future assignment",
            150: "reserved for future assignment",
            151: "reserved for future assignment",
            152: "reserved for future assignment",
            153: "reserved for future assignment",
            154: "reserved for future assignment",
            155: "reserved for future assignment",
            156: "reserved for future assignment",
            157: "reserved for future assignment",
            158: "reserved for future assignment",
            159: "reserved for future assignment",
            16: "reserved for future assignment",
            160: "reserved for future assignment",
            161: "reserved for future assignment",
            162: "reserved for future assignment",
            163: "reserved for future assignment",
            164: "reserved for future assignment",
            165: "reserved for future assignment",
            166: "reserved for future assignment",
            167: "reserved for future assignment",
            168: "reserved for future assignment",
            169: "reserved for future assignment",
            17: "reserved for future assignment",
            170: "reserved for future assignment",
            171: "reserved for future assignment",
            172: "reserved for future assignment",
            173: "reserved for future assignment",
            174: "reserved for future assignment",
            175: "reserved for future assignment",
            176: "reserved for future assignment",
            177: "reserved for future assignment",
            178: "reserved for future assignment",
            179: "reserved for future assignment",
            18: "reserved for future assignment",
            180: "reserved for future assignment",
            181: "reserved for future assignment",
            182: "reserved for future assignment",
            183: "reserved for future assignment",
            184: "reserved for future assignment",
            185: "reserved for future assignment",
            186: "reserved for future assignment",
            187: "reserved for future assignment",
            188: "reserved for future assignment",
            189: "reserved for future assignment",
            19: "reserved for future assignment",
            190: "reserved for future assignment",
            191: "reserved for future assignment",
            192: "reserved for future assignment",
            193: "reserved for future assignment",
            194: "reserved for future assignment",
            195: "reserved for future assignment",
            196: "reserved for future assignment",
            197: "reserved for future assignment",
            198: "reserved for future assignment",
            199: "reserved for future assignment",
            2: "service not available",
            20: "reserved for future assignment",
            200: "reserved for future assignment",
            201: "reserved for future assignment",
            202: "reserved for future assignment",
            203: "reserved for future assignment",
            204: "reserved for future assignment",
            205: "reserved for future assignment",
            206: "reserved for future assignment",
            207: "reserved for future assignment",
            208: "reserved for future assignment",
            209: "reserved for future assignment",
            21: "reserved for future assignment",
            210: "reserved for future assignment",
            211: "reserved for future assignment",
            212: "reserved for future assignment",
            213: "reserved for future assignment",
            214: "reserved for future assignment",
            215: "reserved for future assignment",
            216: "reserved for future assignment",
            217: "reserved for future assignment",
            218: "reserved for future assignment",
            219: "reserved for future assignment",
            22: "reserved for future assignment",
            220: "reserved for future assignment",
            221: "reserved for future assignment",
            222: "reserved for future assignment",
            223: "reserved for future assignment",
            224: "reserved for future assignment",
            225: "reserved for future assignment",
            226: "reserved for future assignment",
            227: "reserved for future assignment",
            228: "reserved for future assignment",
            229: "reserved for future assignment",
            23: "reserved for future assignment",
            230: "reserved for future assignment",
            231: "reserved for future assignment",
            232: "reserved for future assignment",
            233: "reserved for future assignment",
            234: "reserved for future assignment",
            235: "reserved for future assignment",
            236: "reserved for future assignment",
            237: "reserved for future assignment",
            238: "reserved for future assignment",
            239: "reserved for future assignment",
            24: "reserved for future assignment",
            240: "reserved for future assignment",
            241: "reserved for future assignment",
            242: "reserved for future assignment",
            243: "reserved for future assignment",
            244: "reserved for future assignment",
            245: "reserved for future assignment",
            246: "reserved for future assignment",
            247: "reserved for future assignment",
            248: "reserved for future assignment",
            249: "reserved for future assignment",
            25: "reserved for future assignment",
            250: "reserved for future assignment",
            251: "reserved",
            252: "reserved",
            253: "reserved",
            254: "error",
            255: "not available",
            26: "reserved for future assignment",
            27: "reserved for future assignment",
            28: "reserved for future assignment",
            29: "reserved for future assignment",
            3: "not authorized to operate on service",
            30: "reserved for future assignment",
            31: "reserved for future assignment",
            32: "reserved for future assignment",
            33: "reserved for future assignment",
            34: "reserved for future assignment",
            35: "reserved for future assignment",
            36: "reserved for future assignment",
            37: "reserved for future assignment",
            38: "reserved for future assignment",
            39: "reserved for future assignment",
            4: "reserved for future assignment",
            40: "reserved for future assignment",
            41: "reserved for future assignment",
            42: "reserved for future assignment",
            43: "reserved for future assignment",
            44: "reserved for future assignment",
            45: "reserved for future assignment",
            46: "reserved for future assignment",
            47: "reserved for future assignment",
            48: "reserved for future assignment",
            49: "reserved for future assignment",
            5: "reserved for future assignment",
            50: "reserved for future assignment",
            51: "reserved for future assignment",
            52: "reserved for future assignment",
            53: "reserved for future assignment",
            54: "reserved for future assignment",
            55: "reserved for future assignment",
            56: "reserved for future assignment",
            57: "reserved for future assignment",
            58: "reserved for future assignment",
            59: "reserved for future assignment",
            6: "reserved for future assignment",
            60: "reserved for future assignment",
            61: "reserved for future assignment",
            62: "reserved for future assignment",
            63: "reserved for future assignment",
            64: "reserved for future assignment",
            65: "reserved for future assignment",
            66: "reserved for future assignment",
            67: "reserved for future assignment",
            68: "reserved for future assignment",
            69: "reserved for future assignment",
            7: "reserved for future assignment",
            70: "reserved for future assignment",
            71: "reserved for future assignment",
            72: "reserved for future assignment",
            73: "reserved for future assignment",
            74: "reserved for future assignment",
            75: "reserved for future assignment",
            76: "reserved for future assignment",
            77: "reserved for future assignment",
            78: "reserved for future assignment",
            79: "reserved for future assignment",
            8: "reserved for future assignment",
            80: "reserved for future assignment",
            81: "reserved for future assignment",
            82: "reserved for future assignment",
            83: "reserved for future assignment",
            84: "reserved for future assignment",
            85: "reserved for future assignment",
            86: "reserved for future assignment",
            87: "reserved for future assignment",
            88: "reserved for future assignment",
            89: "reserved for future assignment",
            9: "reserved for future assignment",
            90: "reserved for future assignment",
            91: "reserved for future assignment",
            92: "reserved for future assignment",
            93: "reserved for future assignment",
            94: "reserved for future assignment",
            95: "reserved for future assignment",
            96: "reserved for future assignment",
            97: "reserved for future assignment",
            98: "reserved for future assignment",
            99: "reserved for future assignment"
        },
        3370: {
            0: "off",
            1: "on",
            10: "reserved for future assignment",
            100: "reserved for future assignment",
            101: "reserved for future assignment",
            102: "reserved for future assignment",
            103: "reserved for future assignment",
            104: "reserved for future assignment",
            105: "reserved for future assignment",
            106: "reserved for future assignment",
            107: "reserved for future assignment",
            108: "reserved for future assignment",
            109: "reserved for future assignment",
            11: "reserved for future assignment",
            110: "reserved for future assignment",
            111: "reserved for future assignment",
            112: "reserved for future assignment",
            113: "reserved for future assignment",
            114: "reserved for future assignment",
            115: "reserved for future assignment",
            116: "reserved for future assignment",
            117: "reserved for future assignment",
            118: "reserved for future assignment",
            119: "reserved for future assignment",
            12: "reserved for future assignment",
            120: "reserved for future assignment",
            121: "reserved for future assignment",
            122: "reserved for future assignment",
            123: "reserved for future assignment",
            124: "reserved for future assignment",
            125: "reserved for future assignment",
            126: "reserved for future assignment",
            127: "reserved for future assignment",
            128: "reserved for future assignment",
            129: "reserved for future assignment",
            13: "reserved for future assignment",
            130: "reserved for future assignment",
            131: "reserved for future assignment",
            132: "reserved for future assignment",
            133: "reserved for future assignment",
            134: "reserved for future assignment",
            135: "reserved for future assignment",
            136: "reserved for future assignment",
            137: "reserved for future assignment",
            138: "reserved for future assignment",
            139: "reserved for future assignment",
            14: "reserved for future assignment",
            140: "reserved for future assignment",
            141: "reserved for future assignment",
            142: "reserved for future assignment",
            143: "reserved for future assignment",
            144: "reserved for future assignment",
            145: "reserved for future assignment",
            146: "reserved for future assignment",
            147: "reserved for future assignment",
            148: "reserved for future assignment",
            149: "reserved for future assignment",
            15: "reserved for future assignment",
            150: "reserved for future assignment",
            151: "reserved for future assignment",
            152: "reserved for future assignment",
            153: "reserved for future assignment",
            154: "reserved for future assignment",
            155: "reserved for future assignment",
            156: "reserved for future assignment",
            157: "reserved for future assignment",
            158: "reserved for future assignment",
            159: "reserved for future assignment",
            16: "reserved for future assignment",
            160: "reserved for future assignment",
            161: "reserved for future assignment",
            162: "reserved for future assignment",
            163: "reserved for future assignment",
            164: "reserved for future assignment",
            165: "reserved for future assignment",
            166: "reserved for future assignment",
            167: "reserved for future assignment",
            168: "reserved for future assignment",
            169: "reserved for future assignment",
            17: "reserved for future assignment",
            170: "reserved for future assignment",
            171: "reserved for future assignment",
            172: "reserved for future assignment",
            173: "reserved for future assignment",
            174: "reserved for future assignment",
            175: "reserved for future assignment",
            176: "reserved for future assignment",
            177: "reserved for future assignment",
            178: "reserved for future assignment",
            179: "reserved for future assignment",
            18: "reserved for future assignment",
            180: "reserved for future assignment",
            181: "reserved for future assignment",
            182: "reserved for future assignment",
            183: "reserved for future assignment",
            184: "reserved for future assignment",
            185: "reserved for future assignment",
            186: "reserved for future assignment",
            187: "reserved for future assignment",
            188: "reserved for future assignment",
            189: "reserved for future assignment",
            19: "reserved for future assignment",
            190: "reserved for future assignment",
            191: "reserved for future assignment",
            192: "reserved for future assignment",
            193: "reserved for future assignment",
            194: "reserved for future assignment",
            195: "reserved for future assignment",
            196: "reserved for future assignment",
            197: "reserved for future assignment",
            198: "reserved for future assignment",
            199: "reserved for future assignment",
            2: "reserved for future assignment",
            20: "reserved for future assignment",
            200: "reserved for future assignment",
            201: "reserved for future assignment",
            202: "reserved for future assignment",
            203: "reserved for future assignment",
            204: "reserved for future assignment",
            205: "reserved for future assignment",
            206: "reserved for future assignment",
            207: "reserved for future assignment",
            208: "reserved for future assignment",
            209: "reserved for future assignment",
            21: "reserved for future assignment",
            210: "reserved for future assignment",
            211: "reserved for future assignment",
            212: "reserved for future assignment",
            213: "reserved for future assignment",
            214: "reserved for future assignment",
            215: "reserved for future assignment",
            216: "reserved for future assignment",
            217: "reserved for future assignment",
            218: "reserved for future assignment",
            219: "reserved for future assignment",
            22: "reserved for future assignment",
            220: "reserved for future assignment",
            221: "reserved for future assignment",
            222: "reserved for future assignment",
            223: "reserved for future assignment",
            224: "reserved for future assignment",
            225: "reserved for future assignment",
            226: "reserved for future assignment",
            227: "reserved for future assignment",
            228: "reserved for future assignment",
            229: "reserved for future assignment",
            23: "reserved for future assignment",
            230: "reserved for future assignment",
            231: "reserved for future assignment",
            232: "reserved for future assignment",
            233: "reserved for future assignment",
            234: "reserved for future assignment",
            235: "reserved for future assignment",
            236: "reserved for future assignment",
            237: "reserved for future assignment",
            238: "reserved for future assignment",
            239: "reserved for future assignment",
            24: "reserved for future assignment",
            240: "reserved for future assignment",
            241: "reserved for future assignment",
            242: "reserved for future assignment",
            243: "reserved for future assignment",
            244: "reserved for future assignment",
            245: "reserved for future assignment",
            246: "reserved for future assignment",
            247: "reserved for future assignment",
            248: "reserved for future assignment",
            249: "reserved for future assignment",
            25: "reserved for future assignment",
            250: "reserved for future assignment",
            251: "reserved",
            252: "reserved",
            253: "reserved",
            254: "error",
            255: "not available",
            26: "reserved for future assignment",
            27: "reserved for future assignment",
            28: "reserved for future assignment",
            29: "reserved for future assignment",
            3: "reserved for future assignment",
            30: "reserved for future assignment",
            31: "reserved for future assignment",
            32: "reserved for future assignment",
            33: "reserved for future assignment",
            34: "reserved for future assignment",
            35: "reserved for future assignment",
            36: "reserved for future assignment",
            37: "reserved for future assignment",
            38: "reserved for future assignment",
            39: "reserved for future assignment",
            4: "reserved for future assignment",
            40: "reserved for future assignment",
            41: "reserved for future assignment",
            42: "reserved for future assignment",
            43: "reserved for future assignment",
            44: "reserved for future assignment",
            45: "reserved for future assignment",
            46: "reserved for future assignment",
            47: "reserved for future assignment",
            48: "reserved for future assignment",
            49: "reserved for future assignment",
            5: "reserved for future assignment",
            50: "reserved for future assignment",
            51: "reserved for future assignment",
            52: "reserved for future assignment",
            53: "reserved for future assignment",
            54: "reserved for future assignment",
            55: "reserved for future assignment",
            56: "reserved for future assignment",
            57: "reserved for future assignment",
            58: "reserved for future assignment",
            59: "reserved for future assignment",
            6: "reserved for future assignment",
            60: "reserved for future assignment",
            61: "reserved for future assignment",
            62: "reserved for future assignment",
            63: "reserved for future assignment",
            64: "reserved for future assignment",
            65: "reserved for future assignment",
            66: "reserved for future assignment",
            67: "reserved for future assignment",
            68: "reserved for future assignment",
            69: "reserved for future assignment",
            7: "reserved for future assignment",
            70: "reserved for future assignment",
            71: "reserved for future assignment",
            72: "reserved for future assignment",
            73: "reserved for future assignment",
            74: "reserved for future assignment",
            75: "reserved for future assignment",
            76: "reserved for future assignment",
            77: "reserved for future assignment",
            78: "reserved for future assignment",
            79: "reserved for future assignment",
            8: "reserved for future assignment",
            80: "reserved for future assignment",
            81: "reserved for future assignment",
            82: "reserved for future assignment",
            83: "reserved for future assignment",
            84: "reserved for future assignment",
            85: "reserved for future assignment",
            86: "reserved for future assignment",
            87: "reserved for future assignment",
            88: "reserved for future assignment",
            89: "reserved for future assignment",
            9: "reserved for future assignment",
            90: "reserved for future assignment",
            91: "reserved for future assignment",
            92: "reserved for future assignment",
            93: "reserved for future assignment",
            94: "reserved for future assignment",
            95: "reserved for future assignment",
            96: "reserved for future assignment",
            97: "reserved for future assignment",
            98: "reserved for future assignment",
            99: "reserved for future assignment"
        },
        3372: {
            0: "cellular network #1",
            1: "cellular network #2",
            10: "reserved for future assignment",
            100: "reserved for future assignment",
            101: "reserved for future assignment",
            102: "reserved for future assignment",
            103: "reserved for future assignment",
            104: "reserved for future assignment",
            105: "reserved for future assignment",
            106: "reserved for future assignment",
            107: "reserved for future assignment",
            108: "reserved for future assignment",
            109: "reserved for future assignment",
            11: "reserved for future assignment",
            110: "reserved for future assignment",
            111: "reserved for future assignment",
            112: "reserved for future assignment",
            113: "reserved for future assignment",
            114: "reserved for future assignment",
            115: "reserved for future assignment",
            116: "reserved for future assignment",
            117: "reserved for future assignment",
            118: "reserved for future assignment",
            119: "reserved for future assignment",
            12: "reserved for future assignment",
            120: "reserved for future assignment",
            121: "reserved for future assignment",
            122: "reserved for future assignment",
            123: "reserved for future assignment",
            124: "reserved for future assignment",
            125: "reserved for future assignment",
            126: "reserved for future assignment",
            127: "reserved for future assignment",
            128: "reserved for future assignment",
            129: "reserved for future assignment",
            13: "reserved for future assignment",
            130: "reserved for future assignment",
            131: "reserved for future assignment",
            132: "reserved for future assignment",
            133: "reserved for future assignment",
            134: "reserved for future assignment",
            135: "reserved for future assignment",
            136: "reserved for future assignment",
            137: "reserved for future assignment",
            138: "reserved for future assignment",
            139: "reserved for future assignment",
            14: "reserved for future assignment",
            140: "reserved for future assignment",
            141: "reserved for future assignment",
            142: "reserved for future assignment",
            143: "reserved for future assignment",
            144: "reserved for future assignment",
            145: "reserved for future assignment",
            146: "reserved for future assignment",
            147: "reserved for future assignment",
            148: "reserved for future assignment",
            149: "reserved for future assignment",
            15: "reserved for future assignment",
            150: "reserved for future assignment",
            151: "reserved for future assignment",
            152: "reserved for future assignment",
            153: "reserved for future assignment",
            154: "reserved for future assignment",
            155: "reserved for future assignment",
            156: "reserved for future assignment",
            157: "reserved for future assignment",
            158: "reserved for future assignment",
            159: "reserved for future assignment",
            16: "reserved for future assignment",
            160: "reserved for future assignment",
            161: "reserved for future assignment",
            162: "reserved for future assignment",
            163: "reserved for future assignment",
            164: "reserved for future assignment",
            165: "reserved for future assignment",
            166: "reserved for future assignment",
            167: "reserved for future assignment",
            168: "reserved for future assignment",
            169: "reserved for future assignment",
            17: "reserved for future assignment",
            170: "reserved for future assignment",
            171: "reserved for future assignment",
            172: "reserved for future assignment",
            173: "reserved for future assignment",
            174: "reserved for future assignment",
            175: "reserved for future assignment",
            176: "reserved for future assignment",
            177: "reserved for future assignment",
            178: "reserved for future assignment",
            179: "reserved for future assignment",
            18: "reserved for future assignment",
            180: "reserved for future assignment",
            181: "reserved for future assignment",
            182: "reserved for future assignment",
            183: "reserved for future assignment",
            184: "reserved for future assignment",
            185: "reserved for future assignment",
            186: "reserved for future assignment",
            187: "reserved for future assignment",
            188: "reserved for future assignment",
            189: "reserved for future assignment",
            19: "reserved for future assignment",
            190: "reserved for future assignment",
            191: "reserved for future assignment",
            192: "reserved for future assignment",
            193: "reserved for future assignment",
            194: "reserved for future assignment",
            195: "reserved for future assignment",
            196: "reserved for future assignment",
            197: "reserved for future assignment",
            198: "reserved for future assignment",
            199: "reserved for future assignment",
            2: "wireless lan #1",
            20: "reserved for future assignment",
            200: "reserved for future assignment",
            201: "reserved for future assignment",
            202: "reserved for future assignment",
            203: "reserved for future assignment",
            204: "reserved for future assignment",
            205: "reserved for future assignment",
            206: "reserved for future assignment",
            207: "reserved for future assignment",
            208: "reserved for future assignment",
            209: "reserved for future assignment",
            21: "reserved for future assignment",
            210: "reserved for future assignment",
            211: "reserved for future assignment",
            212: "reserved for future assignment",
            213: "reserved for future assignment",
            214: "reserved for future assignment",
            215: "reserved for future assignment",
            216: "reserved for future assignment",
            217: "reserved for future assignment",
            218: "reserved for future assignment",
            219: "reserved for future assignment",
            22: "reserved for future assignment",
            220: "reserved for future assignment",
            221: "reserved for future assignment",
            222: "reserved for future assignment",
            223: "reserved for future assignment",
            224: "reserved for future assignment",
            225: "reserved for future assignment",
            226: "reserved for future assignment",
            227: "reserved for future assignment",
            228: "reserved for future assignment",
            229: "reserved for future assignment",
            23: "reserved for future assignment",
            230: "reserved for future assignment",
            231: "reserved for future assignment",
            232: "reserved for future assignment",
            233: "reserved for future assignment",
            234: "reserved for future assignment",
            235: "reserved for future assignment",
            236: "reserved for future assignment",
            237: "reserved for future assignment",
            238: "reserved for future assignment",
            239: "reserved for future assignment",
            24: "reserved for future assignment",
            240: "reserved for future assignment",
            241: "reserved for future assignment",
            242: "reserved for future assignment",
            243: "reserved for future assignment",
            244: "reserved for future assignment",
            245: "reserved for future assignment",
            246: "reserved for future assignment",
            247: "reserved for future assignment",
            248: "reserved for future assignment",
            249: "reserved for future assignment",
            25: "reserved for future assignment",
            250: "reserved for future assignment",
            251: "reserved",
            252: "reserved",
            253: "reserved",
            254: "error",
            255: "not available",
            26: "reserved for future assignment",
            27: "reserved for future assignment",
            28: "reserved for future assignment",
            29: "reserved for future assignment",
            3: "wireless lan #2",
            30: "reserved for future assignment",
            31: "reserved for future assignment",
            32: "reserved for future assignment",
            33: "reserved for future assignment",
            34: "reserved for future assignment",
            35: "reserved for future assignment",
            36: "reserved for future assignment",
            37: "reserved for future assignment",
            38: "reserved for future assignment",
            39: "reserved for future assignment",
            4: "satellite network",
            40: "reserved for future assignment",
            41: "reserved for future assignment",
            42: "reserved for future assignment",
            43: "reserved for future assignment",
            44: "reserved for future assignment",
            45: "reserved for future assignment",
            46: "reserved for future assignment",
            47: "reserved for future assignment",
            48: "reserved for future assignment",
            49: "reserved for future assignment",
            5: "reserved for future assignment",
            50: "reserved for future assignment",
            51: "reserved for future assignment",
            52: "reserved for future assignment",
            53: "reserved for future assignment",
            54: "reserved for future assignment",
            55: "reserved for future assignment",
            56: "reserved for future assignment",
            57: "reserved for future assignment",
            58: "reserved for future assignment",
            59: "reserved for future assignment",
            6: "reserved for future assignment",
            60: "reserved for future assignment",
            61: "reserved for future assignment",
            62: "reserved for future assignment",
            63: "reserved for future assignment",
            64: "reserved for future assignment",
            65: "reserved for future assignment",
            66: "reserved for future assignment",
            67: "reserved for future assignment",
            68: "reserved for future assignment",
            69: "reserved for future assignment",
            7: "reserved for future assignment",
            70: "reserved for future assignment",
            71: "reserved for future assignment",
            72: "reserved for future assignment",
            73: "reserved for future assignment",
            74: "reserved for future assignment",
            75: "reserved for future assignment",
            76: "reserved for future assignment",
            77: "reserved for future assignment",
            78: "reserved for future assignment",
            79: "reserved for future assignment",
            8: "reserved for future assignment",
            80: "reserved for future assignment",
            81: "reserved for future assignment",
            82: "reserved for future assignment",
            83: "reserved for future assignment",
            84: "reserved for future assignment",
            85: "reserved for future assignment",
            86: "reserved for future assignment",
            87: "reserved for future assignment",
            88: "reserved for future assignment",
            89: "reserved for future assignment",
            9: "reserved for future assignment",
            90: "reserved for future assignment",
            91: "reserved for future assignment",
            92: "reserved for future assignment",
            93: "reserved for future assignment",
            94: "reserved for future assignment",
            95: "reserved for future assignment",
            96: "reserved for future assignment",
            97: "reserved for future assignment",
            98: "reserved for future assignment",
            99: "reserved for future assignment"
        },
        3375: {
            0: "load compensation disabled",
            1: "voltage droop compensation enabled",
            2: "ir line drop compensation enabled",
            3: "reserved",
            4: "reserved",
            5: "reserved",
            6: "reserved",
            7: "not available"
        },
        3376: {
            0: "var/power factor regulation disabled",
            1: "power factor regulation enabled",
            2: "var regulation enabled",
            3: "reserved",
            4: "reserved",
            5: "reserved",
            6: "reserved",
            7: "not available"
        },
        3377: {
            0: "underfrequency compensation disabled",
            1: "underfrequency compensation enabled",
            2: "reserved",
            3: "not available"
        },
        3378: {
            0: "soft start is inactive",
            1: "soft start is active",
            2: "reserved",
            3: "not available"
        },
        3379: {
            0: "not regulating voltage - unit disabled",
            1: "regulating voltage",
            2: "reserved",
            3: "not available"
        },
        3385: {
            0: "leading",
            1: "lagging",
            2: "reserved",
            3: "not available or not installed"
        },
        3387: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3388: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3389: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3390: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3391: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3392: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3393: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3394: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3395: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3396: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3397: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3398: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3399: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3400: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3401: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3402: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3403: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3404: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3405: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3406: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3407: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3408: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3409: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3410: {
            0: "        no combustion",
            1: "        combustion exists",
            2: "        error",
            3: "        not available"
        },
        3411: {
            0: "   all bus doors are disabled",
            1: "   at least 1 bus door enabled ",
            2: "   error",
            3: "   not available"
        },
        3412: {
            0: "  unlocked ",
            1: "  locked",
            2: "  error",
            3: "  not available"
        },
        3413: {
            0: "  door closed",
            1: "  door opened",
            2: "  error",
            3: "  not available"
        },
        3414: {
            0: "  door disabled",
            1: "  door enabled",
            2: "  error",
            3: "  not available"
        },
        3415: {
            0: "  unlocked ",
            1: "  locked",
            2: "  error",
            3: "  not available"
        },
        3416: {
            0: "  door closed",
            1: "  door opened",
            2: "  error",
            3: "  not available"
        },
        3417: {
            0: "  door disabled",
            1: "  door enabled",
            2: "  error",
            3: "  not available"
        },
        3418: {
            0: "  unlocked ",
            1: "  locked",
            2: "  error",
            3: "  not available"
        },
        3419: {
            0: "  door closed",
            1: "  door opened",
            2: "  error",
            3: "  not available"
        },
        3420: {
            0: "  door disabled",
            1: "  door enabled",
            2: "  error",
            3: "  not available"
        },
        3421: {
            0: "  unlocked ",
            1: "  locked",
            2: "  error",
            3: "  not available"
        },
        3422: {
            0: "  door closed",
            1: "  door opened",
            2: "  error",
            3: "  not available"
        },
        3423: {
            0: "  door disabled",
            1: "  door enabled",
            2: "  error",
            3: "  not available"
        },
        3424: {
            0: "  unlocked ",
            1: "  locked",
            2: "  error",
            3: "  not available"
        },
        3425: {
            0: "  door closed",
            1: "  door opened",
            2: "  error",
            3: "  not available"
        },
        3426: {
            0: "  door disabled",
            1: "  door enabled",
            2: "  error",
            3: "  not available"
        },
        3427: {
            0: "  unlocked ",
            1: "  locked",
            2: "  error",
            3: "  not available"
        },
        3428: {
            0: "  door closed",
            1: "  door opened",
            2: "  error",
            3: "  not available"
        },
        3429: {
            0: "  door disabled",
            1: "  door enabled",
            2: "  error",
            3: "  not available"
        },
        3430: {
            0: "  unlocked ",
            1: "  locked",
            2: "  error",
            3: "  not available"
        },
        3431: {
            0: "  door closed",
            1: "  door opened",
            2: "  error",
            3: "  not available"
        },
        3432: {
            0: "  door disabled",
            1: "  door enabled",
            2: "  error",
            3: "  not available"
        },
        3433: {
            0: "  unlocked ",
            1: "  locked",
            2: "  error",
            3: "  not available"
        },
        3434: {
            0: "  door closed",
            1: "  door opened",
            2: "  error",
            3: "  not available"
        },
        3435: {
            0: "  door disabled",
            1: "  door enabled",
            2: "  error",
            3: "  not available"
        },
        3436: {
            0: "  unlocked ",
            1: "  locked",
            2: "  error",
            3: "  not available"
        },
        3437: {
            0: "  door closed",
            1: "  door opened",
            2: "  error",
            3: "  not available"
        },
        3438: {
            0: "  door disabled",
            1: "  door enabled",
            2: "  error",
            3: "  not available"
        },
        3439: {
            0: "  unlocked ",
            1: "  locked",
            2: "  error",
            3: "  not available"
        },
        3440: {
            0: "  door closed",
            1: "  door opened",
            2: "  error",
            3: "  not available"
        },
        3441: {
            0: "  door disabled",
            1: "  door enabled",
            2: "  error",
            3: "  not available"
        },
        3442: {
            0: "off",
            1: "on",
            10: "reserved for future assignment",
            100: "reserved for future assignment",
            101: "reserved for future assignment",
            102: "reserved for future assignment",
            103: "reserved for future assignment",
            104: "reserved for future assignment",
            105: "reserved for future assignment",
            106: "reserved for future assignment",
            107: "reserved for future assignment",
            108: "reserved for future assignment",
            109: "reserved for future assignment",
            11: "reserved for future assignment",
            110: "reserved for future assignment",
            111: "reserved for future assignment",
            112: "reserved for future assignment",
            113: "reserved for future assignment",
            114: "reserved for future assignment",
            115: "reserved for future assignment",
            116: "reserved for future assignment",
            117: "reserved for future assignment",
            118: "reserved for future assignment",
            119: "reserved for future assignment",
            12: "reserved for future assignment",
            120: "reserved for future assignment",
            121: "reserved for future assignment",
            122: "reserved for future assignment",
            123: "reserved for future assignment",
            124: "reserved for future assignment",
            125: "reserved for future assignment",
            126: "reserved for future assignment",
            127: "reserved for future assignment",
            128: "reserved for future assignment",
            129: "reserved for future assignment",
            13: "reserved for future assignment",
            130: "reserved for future assignment",
            131: "reserved for future assignment",
            132: "reserved for future assignment",
            133: "reserved for future assignment",
            134: "reserved for future assignment",
            135: "reserved for future assignment",
            136: "reserved for future assignment",
            137: "reserved for future assignment",
            138: "reserved for future assignment",
            139: "reserved for future assignment",
            14: "reserved for future assignment",
            140: "reserved for future assignment",
            141: "reserved for future assignment",
            142: "reserved for future assignment",
            143: "reserved for future assignment",
            144: "reserved for future assignment",
            145: "reserved for future assignment",
            146: "reserved for future assignment",
            147: "reserved for future assignment",
            148: "reserved for future assignment",
            149: "reserved for future assignment",
            15: "reserved for future assignment",
            150: "reserved for future assignment",
            151: "reserved for future assignment",
            152: "reserved for future assignment",
            153: "reserved for future assignment",
            154: "reserved for future assignment",
            155: "reserved for future assignment",
            156: "reserved for future assignment",
            157: "reserved for future assignment",
            158: "reserved for future assignment",
            159: "reserved for future assignment",
            16: "reserved for future assignment",
            160: "reserved for future assignment",
            161: "reserved for future assignment",
            162: "reserved for future assignment",
            163: "reserved for future assignment",
            164: "reserved for future assignment",
            165: "reserved for future assignment",
            166: "reserved for future assignment",
            167: "reserved for future assignment",
            168: "reserved for future assignment",
            169: "reserved for future assignment",
            17: "reserved for future assignment",
            170: "reserved for future assignment",
            171: "reserved for future assignment",
            172: "reserved for future assignment",
            173: "reserved for future assignment",
            174: "reserved for future assignment",
            175: "reserved for future assignment",
            176: "reserved for future assignment",
            177: "reserved for future assignment",
            178: "reserved for future assignment",
            179: "reserved for future assignment",
            18: "reserved for future assignment",
            180: "reserved for future assignment",
            181: "reserved for future assignment",
            182: "reserved for future assignment",
            183: "reserved for future assignment",
            184: "reserved for future assignment",
            185: "reserved for future assignment",
            186: "reserved for future assignment",
            187: "reserved for future assignment",
            188: "reserved for future assignment",
            189: "reserved for future assignment",
            19: "reserved for future assignment",
            190: "reserved for future assignment",
            191: "reserved for future assignment",
            192: "reserved for future assignment",
            193: "reserved for future assignment",
            194: "reserved for future assignment",
            195: "reserved for future assignment",
            196: "reserved for future assignment",
            197: "reserved for future assignment",
            198: "reserved for future assignment",
            199: "reserved for future assignment",
            2: "not authorized to operate on network",
            20: "reserved for future assignment",
            200: "reserved for future assignment",
            201: "reserved for future assignment",
            202: "reserved for future assignment",
            203: "reserved for future assignment",
            204: "reserved for future assignment",
            205: "reserved for future assignment",
            206: "reserved for future assignment",
            207: "reserved for future assignment",
            208: "reserved for future assignment",
            209: "reserved for future assignment",
            21: "reserved for future assignment",
            210: "reserved for future assignment",
            211: "reserved for future assignment",
            212: "reserved for future assignment",
            213: "reserved for future assignment",
            214: "reserved for future assignment",
            215: "reserved for future assignment",
            216: "reserved for future assignment",
            217: "reserved for future assignment",
            218: "reserved for future assignment",
            219: "reserved for future assignment",
            22: "reserved for future assignment",
            220: "reserved for future assignment",
            221: "reserved for future assignment",
            222: "reserved for future assignment",
            223: "reserved for future assignment",
            224: "reserved for future assignment",
            225: "reserved for future assignment",
            226: "reserved for future assignment",
            227: "reserved for future assignment",
            228: "reserved for future assignment",
            229: "reserved for future assignment",
            23: "reserved for future assignment",
            230: "reserved for future assignment",
            231: "reserved for future assignment",
            232: "reserved for future assignment",
            233: "reserved for future assignment",
            234: "reserved for future assignment",
            235: "reserved for future assignment",
            236: "reserved for future assignment",
            237: "reserved for future assignment",
            238: "reserved for future assignment",
            239: "reserved for future assignment",
            24: "reserved for future assignment",
            240: "reserved for future assignment",
            241: "reserved for future assignment",
            242: "reserved for future assignment",
            243: "reserved for future assignment",
            244: "reserved for future assignment",
            245: "reserved for future assignment",
            246: "reserved for future assignment",
            247: "reserved for future assignment",
            248: "reserved for future assignment",
            249: "reserved for future assignment",
            25: "reserved for future assignment",
            250: "reserved for future assignment",
            251: "reserved",
            252: "reserved",
            253: "reserved",
            254: "error",
            255: "not available",
            26: "reserved for future assignment",
            27: "reserved for future assignment",
            28: "reserved for future assignment",
            29: "reserved for future assignment",
            3: "reserved for future assignment",
            30: "reserved for future assignment",
            31: "reserved for future assignment",
            32: "reserved for future assignment",
            33: "reserved for future assignment",
            34: "reserved for future assignment",
            35: "reserved for future assignment",
            36: "reserved for future assignment",
            37: "reserved for future assignment",
            38: "reserved for future assignment",
            39: "reserved for future assignment",
            4: "reserved for future assignment",
            40: "reserved for future assignment",
            41: "reserved for future assignment",
            42: "reserved for future assignment",
            43: "reserved for future assignment",
            44: "reserved for future assignment",
            45: "reserved for future assignment",
            46: "reserved for future assignment",
            47: "reserved for future assignment",
            48: "reserved for future assignment",
            49: "reserved for future assignment",
            5: "reserved for future assignment",
            50: "reserved for future assignment",
            51: "reserved for future assignment",
            52: "reserved for future assignment",
            53: "reserved for future assignment",
            54: "reserved for future assignment",
            55: "reserved for future assignment",
            56: "reserved for future assignment",
            57: "reserved for future assignment",
            58: "reserved for future assignment",
            59: "reserved for future assignment",
            6: "reserved for future assignment",
            60: "reserved for future assignment",
            61: "reserved for future assignment",
            62: "reserved for future assignment",
            63: "reserved for future assignment",
            64: "reserved for future assignment",
            65: "reserved for future assignment",
            66: "reserved for future assignment",
            67: "reserved for future assignment",
            68: "reserved for future assignment",
            69: "reserved for future assignment",
            7: "reserved for future assignment",
            70: "reserved for future assignment",
            71: "reserved for future assignment",
            72: "reserved for future assignment",
            73: "reserved for future assignment",
            74: "reserved for future assignment",
            75: "reserved for future assignment",
            76: "reserved for future assignment",
            77: "reserved for future assignment",
            78: "reserved for future assignment",
            79: "reserved for future assignment",
            8: "reserved for future assignment",
            80: "reserved for future assignment",
            81: "reserved for future assignment",
            82: "reserved for future assignment",
            83: "reserved for future assignment",
            84: "reserved for future assignment",
            85: "reserved for future assignment",
            86: "reserved for future assignment",
            87: "reserved for future assignment",
            88: "reserved for future assignment",
            89: "reserved for future assignment",
            9: "reserved for future assignment",
            90: "reserved for future assignment",
            91: "reserved for future assignment",
            92: "reserved for future assignment",
            93: "reserved for future assignment",
            94: "reserved for future assignment",
            95: "reserved for future assignment",
            96: "reserved for future assignment",
            97: "reserved for future assignment",
            98: "reserved for future assignment",
            99: "reserved for future assignment"
        },
        3443: {
            0: "local service",
            1: "roaming service",
            10: "reserved for future assignment",
            100: "reserved for future assignment",
            101: "reserved for future assignment",
            102: "reserved for future assignment",
            103: "reserved for future assignment",
            104: "reserved for future assignment",
            105: "reserved for future assignment",
            106: "reserved for future assignment",
            107: "reserved for future assignment",
            108: "reserved for future assignment",
            109: "reserved for future assignment",
            11: "reserved for future assignment",
            110: "reserved for future assignment",
            111: "reserved for future assignment",
            112: "reserved for future assignment",
            113: "reserved for future assignment",
            114: "reserved for future assignment",
            115: "reserved for future assignment",
            116: "reserved for future assignment",
            117: "reserved for future assignment",
            118: "reserved for future assignment",
            119: "reserved for future assignment",
            12: "reserved for future assignment",
            120: "reserved for future assignment",
            121: "reserved for future assignment",
            122: "reserved for future assignment",
            123: "reserved for future assignment",
            124: "reserved for future assignment",
            125: "reserved for future assignment",
            126: "reserved for future assignment",
            127: "reserved for future assignment",
            128: "reserved for future assignment",
            129: "reserved for future assignment",
            13: "reserved for future assignment",
            130: "reserved for future assignment",
            131: "reserved for future assignment",
            132: "reserved for future assignment",
            133: "reserved for future assignment",
            134: "reserved for future assignment",
            135: "reserved for future assignment",
            136: "reserved for future assignment",
            137: "reserved for future assignment",
            138: "reserved for future assignment",
            139: "reserved for future assignment",
            14: "reserved for future assignment",
            140: "reserved for future assignment",
            141: "reserved for future assignment",
            142: "reserved for future assignment",
            143: "reserved for future assignment",
            144: "reserved for future assignment",
            145: "reserved for future assignment",
            146: "reserved for future assignment",
            147: "reserved for future assignment",
            148: "reserved for future assignment",
            149: "reserved for future assignment",
            15: "reserved for future assignment",
            150: "reserved for future assignment",
            151: "reserved for future assignment",
            152: "reserved for future assignment",
            153: "reserved for future assignment",
            154: "reserved for future assignment",
            155: "reserved for future assignment",
            156: "reserved for future assignment",
            157: "reserved for future assignment",
            158: "reserved for future assignment",
            159: "reserved for future assignment",
            16: "reserved for future assignment",
            160: "reserved for future assignment",
            161: "reserved for future assignment",
            162: "reserved for future assignment",
            163: "reserved for future assignment",
            164: "reserved for future assignment",
            165: "reserved for future assignment",
            166: "reserved for future assignment",
            167: "reserved for future assignment",
            168: "reserved for future assignment",
            169: "reserved for future assignment",
            17: "reserved for future assignment",
            170: "reserved for future assignment",
            171: "reserved for future assignment",
            172: "reserved for future assignment",
            173: "reserved for future assignment",
            174: "reserved for future assignment",
            175: "reserved for future assignment",
            176: "reserved for future assignment",
            177: "reserved for future assignment",
            178: "reserved for future assignment",
            179: "reserved for future assignment",
            18: "reserved for future assignment",
            180: "reserved for future assignment",
            181: "reserved for future assignment",
            182: "reserved for future assignment",
            183: "reserved for future assignment",
            184: "reserved for future assignment",
            185: "reserved for future assignment",
            186: "reserved for future assignment",
            187: "reserved for future assignment",
            188: "reserved for future assignment",
            189: "reserved for future assignment",
            19: "reserved for future assignment",
            190: "reserved for future assignment",
            191: "reserved for future assignment",
            192: "reserved for future assignment",
            193: "reserved for future assignment",
            194: "reserved for future assignment",
            195: "reserved for future assignment",
            196: "reserved for future assignment",
            197: "reserved for future assignment",
            198: "reserved for future assignment",
            199: "reserved for future assignment",
            2: "service not available",
            20: "reserved for future assignment",
            200: "reserved for future assignment",
            201: "reserved for future assignment",
            202: "reserved for future assignment",
            203: "reserved for future assignment",
            204: "reserved for future assignment",
            205: "reserved for future assignment",
            206: "reserved for future assignment",
            207: "reserved for future assignment",
            208: "reserved for future assignment",
            209: "reserved for future assignment",
            21: "reserved for future assignment",
            210: "reserved for future assignment",
            211: "reserved for future assignment",
            212: "reserved for future assignment",
            213: "reserved for future assignment",
            214: "reserved for future assignment",
            215: "reserved for future assignment",
            216: "reserved for future assignment",
            217: "reserved for future assignment",
            218: "reserved for future assignment",
            219: "reserved for future assignment",
            22: "reserved for future assignment",
            220: "reserved for future assignment",
            221: "reserved for future assignment",
            222: "reserved for future assignment",
            223: "reserved for future assignment",
            224: "reserved for future assignment",
            225: "reserved for future assignment",
            226: "reserved for future assignment",
            227: "reserved for future assignment",
            228: "reserved for future assignment",
            229: "reserved for future assignment",
            23: "reserved for future assignment",
            230: "reserved for future assignment",
            231: "reserved for future assignment",
            232: "reserved for future assignment",
            233: "reserved for future assignment",
            234: "reserved for future assignment",
            235: "reserved for future assignment",
            236: "reserved for future assignment",
            237: "reserved for future assignment",
            238: "reserved for future assignment",
            239: "reserved for future assignment",
            24: "reserved for future assignment",
            240: "reserved for future assignment",
            241: "reserved for future assignment",
            242: "reserved for future assignment",
            243: "reserved for future assignment",
            244: "reserved for future assignment",
            245: "reserved for future assignment",
            246: "reserved for future assignment",
            247: "reserved for future assignment",
            248: "reserved for future assignment",
            249: "reserved for future assignment",
            25: "reserved for future assignment",
            250: "reserved for future assignment",
            251: "reserved",
            252: "reserved",
            253: "reserved",
            254: "error",
            255: "not available",
            26: "reserved for future assignment",
            27: "reserved for future assignment",
            28: "reserved for future assignment",
            29: "reserved for future assignment",
            3: "not authorized to operate on service",
            30: "reserved for future assignment",
            31: "reserved for future assignment",
            32: "reserved for future assignment",
            33: "reserved for future assignment",
            34: "reserved for future assignment",
            35: "reserved for future assignment",
            36: "reserved for future assignment",
            37: "reserved for future assignment",
            38: "reserved for future assignment",
            39: "reserved for future assignment",
            4: "reserved for future assignment",
            40: "reserved for future assignment",
            41: "reserved for future assignment",
            42: "reserved for future assignment",
            43: "reserved for future assignment",
            44: "reserved for future assignment",
            45: "reserved for future assignment",
            46: "reserved for future assignment",
            47: "reserved for future assignment",
            48: "reserved for future assignment",
            49: "reserved for future assignment",
            5: "reserved for future assignment",
            50: "reserved for future assignment",
            51: "reserved for future assignment",
            52: "reserved for future assignment",
            53: "reserved for future assignment",
            54: "reserved for future assignment",
            55: "reserved for future assignment",
            56: "reserved for future assignment",
            57: "reserved for future assignment",
            58: "reserved for future assignment",
            59: "reserved for future assignment",
            6: "reserved for future assignment",
            60: "reserved for future assignment",
            61: "reserved for future assignment",
            62: "reserved for future assignment",
            63: "reserved for future assignment",
            64: "reserved for future assignment",
            65: "reserved for future assignment",
            66: "reserved for future assignment",
            67: "reserved for future assignment",
            68: "reserved for future assignment",
            69: "reserved for future assignment",
            7: "reserved for future assignment",
            70: "reserved for future assignment",
            71: "reserved for future assignment",
            72: "reserved for future assignment",
            73: "reserved for future assignment",
            74: "reserved for future assignment",
            75: "reserved for future assignment",
            76: "reserved for future assignment",
            77: "reserved for future assignment",
            78: "reserved for future assignment",
            79: "reserved for future assignment",
            8: "reserved for future assignment",
            80: "reserved for future assignment",
            81: "reserved for future assignment",
            82: "reserved for future assignment",
            83: "reserved for future assignment",
            84: "reserved for future assignment",
            85: "reserved for future assignment",
            86: "reserved for future assignment",
            87: "reserved for future assignment",
            88: "reserved for future assignment",
            89: "reserved for future assignment",
            9: "reserved for future assignment",
            90: "reserved for future assignment",
            91: "reserved for future assignment",
            92: "reserved for future assignment",
            93: "reserved for future assignment",
            94: "reserved for future assignment",
            95: "reserved for future assignment",
            96: "reserved for future assignment",
            97: "reserved for future assignment",
            98: "reserved for future assignment",
            99: "reserved for future assignment"
        },
        3444: {
            0: "off",
            1: "on",
            10: "reserved for future assignment",
            100: "reserved for future assignment",
            101: "reserved for future assignment",
            102: "reserved for future assignment",
            103: "reserved for future assignment",
            104: "reserved for future assignment",
            105: "reserved for future assignment",
            106: "reserved for future assignment",
            107: "reserved for future assignment",
            108: "reserved for future assignment",
            109: "reserved for future assignment",
            11: "reserved for future assignment",
            110: "reserved for future assignment",
            111: "reserved for future assignment",
            112: "reserved for future assignment",
            113: "reserved for future assignment",
            114: "reserved for future assignment",
            115: "reserved for future assignment",
            116: "reserved for future assignment",
            117: "reserved for future assignment",
            118: "reserved for future assignment",
            119: "reserved for future assignment",
            12: "reserved for future assignment",
            120: "reserved for future assignment",
            121: "reserved for future assignment",
            122: "reserved for future assignment",
            123: "reserved for future assignment",
            124: "reserved for future assignment",
            125: "reserved for future assignment",
            126: "reserved for future assignment",
            127: "reserved for future assignment",
            128: "reserved for future assignment",
            129: "reserved for future assignment",
            13: "reserved for future assignment",
            130: "reserved for future assignment",
            131: "reserved for future assignment",
            132: "reserved for future assignment",
            133: "reserved for future assignment",
            134: "reserved for future assignment",
            135: "reserved for future assignment",
            136: "reserved for future assignment",
            137: "reserved for future assignment",
            138: "reserved for future assignment",
            139: "reserved for future assignment",
            14: "reserved for future assignment",
            140: "reserved for future assignment",
            141: "reserved for future assignment",
            142: "reserved for future assignment",
            143: "reserved for future assignment",
            144: "reserved for future assignment",
            145: "reserved for future assignment",
            146: "reserved for future assignment",
            147: "reserved for future assignment",
            148: "reserved for future assignment",
            149: "reserved for future assignment",
            15: "reserved for future assignment",
            150: "reserved for future assignment",
            151: "reserved for future assignment",
            152: "reserved for future assignment",
            153: "reserved for future assignment",
            154: "reserved for future assignment",
            155: "reserved for future assignment",
            156: "reserved for future assignment",
            157: "reserved for future assignment",
            158: "reserved for future assignment",
            159: "reserved for future assignment",
            16: "reserved for future assignment",
            160: "reserved for future assignment",
            161: "reserved for future assignment",
            162: "reserved for future assignment",
            163: "reserved for future assignment",
            164: "reserved for future assignment",
            165: "reserved for future assignment",
            166: "reserved for future assignment",
            167: "reserved for future assignment",
            168: "reserved for future assignment",
            169: "reserved for future assignment",
            17: "reserved for future assignment",
            170: "reserved for future assignment",
            171: "reserved for future assignment",
            172: "reserved for future assignment",
            173: "reserved for future assignment",
            174: "reserved for future assignment",
            175: "reserved for future assignment",
            176: "reserved for future assignment",
            177: "reserved for future assignment",
            178: "reserved for future assignment",
            179: "reserved for future assignment",
            18: "reserved for future assignment",
            180: "reserved for future assignment",
            181: "reserved for future assignment",
            182: "reserved for future assignment",
            183: "reserved for future assignment",
            184: "reserved for future assignment",
            185: "reserved for future assignment",
            186: "reserved for future assignment",
            187: "reserved for future assignment",
            188: "reserved for future assignment",
            189: "reserved for future assignment",
            19: "reserved for future assignment",
            190: "reserved for future assignment",
            191: "reserved for future assignment",
            192: "reserved for future assignment",
            193: "reserved for future assignment",
            194: "reserved for future assignment",
            195: "reserved for future assignment",
            196: "reserved for future assignment",
            197: "reserved for future assignment",
            198: "reserved for future assignment",
            199: "reserved for future assignment",
            2: "reserved for future assignment",
            20: "reserved for future assignment",
            200: "reserved for future assignment",
            201: "reserved for future assignment",
            202: "reserved for future assignment",
            203: "reserved for future assignment",
            204: "reserved for future assignment",
            205: "reserved for future assignment",
            206: "reserved for future assignment",
            207: "reserved for future assignment",
            208: "reserved for future assignment",
            209: "reserved for future assignment",
            21: "reserved for future assignment",
            210: "reserved for future assignment",
            211: "reserved for future assignment",
            212: "reserved for future assignment",
            213: "reserved for future assignment",
            214: "reserved for future assignment",
            215: "reserved for future assignment",
            216: "reserved for future assignment",
            217: "reserved for future assignment",
            218: "reserved for future assignment",
            219: "reserved for future assignment",
            22: "reserved for future assignment",
            220: "reserved for future assignment",
            221: "reserved for future assignment",
            222: "reserved for future assignment",
            223: "reserved for future assignment",
            224: "reserved for future assignment",
            225: "reserved for future assignment",
            226: "reserved for future assignment",
            227: "reserved for future assignment",
            228: "reserved for future assignment",
            229: "reserved for future assignment",
            23: "reserved for future assignment",
            230: "reserved for future assignment",
            231: "reserved for future assignment",
            232: "reserved for future assignment",
            233: "reserved for future assignment",
            234: "reserved for future assignment",
            235: "reserved for future assignment",
            236: "reserved for future assignment",
            237: "reserved for future assignment",
            238: "reserved for future assignment",
            239: "reserved for future assignment",
            24: "reserved for future assignment",
            240: "reserved for future assignment",
            241: "reserved for future assignment",
            242: "reserved for future assignment",
            243: "reserved for future assignment",
            244: "reserved for future assignment",
            245: "reserved for future assignment",
            246: "reserved for future assignment",
            247: "reserved for future assignment",
            248: "reserved for future assignment",
            249: "reserved for future assignment",
            25: "reserved for future assignment",
            250: "reserved for future assignment",
            251: "reserved",
            252: "reserved",
            253: "reserved",
            254: "error",
            255: "not available",
            26: "reserved for future assignment",
            27: "reserved for future assignment",
            28: "reserved for future assignment",
            29: "reserved for future assignment",
            3: "reserved for future assignment",
            30: "reserved for future assignment",
            31: "reserved for future assignment",
            32: "reserved for future assignment",
            33: "reserved for future assignment",
            34: "reserved for future assignment",
            35: "reserved for future assignment",
            36: "reserved for future assignment",
            37: "reserved for future assignment",
            38: "reserved for future assignment",
            39: "reserved for future assignment",
            4: "reserved for future assignment",
            40: "reserved for future assignment",
            41: "reserved for future assignment",
            42: "reserved for future assignment",
            43: "reserved for future assignment",
            44: "reserved for future assignment",
            45: "reserved for future assignment",
            46: "reserved for future assignment",
            47: "reserved for future assignment",
            48: "reserved for future assignment",
            49: "reserved for future assignment",
            5: "reserved for future assignment",
            50: "reserved for future assignment",
            51: "reserved for future assignment",
            52: "reserved for future assignment",
            53: "reserved for future assignment",
            54: "reserved for future assignment",
            55: "reserved for future assignment",
            56: "reserved for future assignment",
            57: "reserved for future assignment",
            58: "reserved for future assignment",
            59: "reserved for future assignment",
            6: "reserved for future assignment",
            60: "reserved for future assignment",
            61: "reserved for future assignment",
            62: "reserved for future assignment",
            63: "reserved for future assignment",
            64: "reserved for future assignment",
            65: "reserved for future assignment",
            66: "reserved for future assignment",
            67: "reserved for future assignment",
            68: "reserved for future assignment",
            69: "reserved for future assignment",
            7: "reserved for future assignment",
            70: "reserved for future assignment",
            71: "reserved for future assignment",
            72: "reserved for future assignment",
            73: "reserved for future assignment",
            74: "reserved for future assignment",
            75: "reserved for future assignment",
            76: "reserved for future assignment",
            77: "reserved for future assignment",
            78: "reserved for future assignment",
            79: "reserved for future assignment",
            8: "reserved for future assignment",
            80: "reserved for future assignment",
            81: "reserved for future assignment",
            82: "reserved for future assignment",
            83: "reserved for future assignment",
            84: "reserved for future assignment",
            85: "reserved for future assignment",
            86: "reserved for future assignment",
            87: "reserved for future assignment",
            88: "reserved for future assignment",
            89: "reserved for future assignment",
            9: "reserved for future assignment",
            90: "reserved for future assignment",
            91: "reserved for future assignment",
            92: "reserved for future assignment",
            93: "reserved for future assignment",
            94: "reserved for future assignment",
            95: "reserved for future assignment",
            96: "reserved for future assignment",
            97: "reserved for future assignment",
            98: "reserved for future assignment",
            99: "reserved for future assignment"
        },
        3446: {
            0: "cellular network #1",
            1: "cellular network #2",
            10: "reserved for future assignment",
            100: "reserved for future assignment",
            101: "reserved for future assignment",
            102: "reserved for future assignment",
            103: "reserved for future assignment",
            104: "reserved for future assignment",
            105: "reserved for future assignment",
            106: "reserved for future assignment",
            107: "reserved for future assignment",
            108: "reserved for future assignment",
            109: "reserved for future assignment",
            11: "reserved for future assignment",
            110: "reserved for future assignment",
            111: "reserved for future assignment",
            112: "reserved for future assignment",
            113: "reserved for future assignment",
            114: "reserved for future assignment",
            115: "reserved for future assignment",
            116: "reserved for future assignment",
            117: "reserved for future assignment",
            118: "reserved for future assignment",
            119: "reserved for future assignment",
            12: "reserved for future assignment",
            120: "reserved for future assignment",
            121: "reserved for future assignment",
            122: "reserved for future assignment",
            123: "reserved for future assignment",
            124: "reserved for future assignment",
            125: "reserved for future assignment",
            126: "reserved for future assignment",
            127: "reserved for future assignment",
            128: "reserved for future assignment",
            129: "reserved for future assignment",
            13: "reserved for future assignment",
            130: "reserved for future assignment",
            131: "reserved for future assignment",
            132: "reserved for future assignment",
            133: "reserved for future assignment",
            134: "reserved for future assignment",
            135: "reserved for future assignment",
            136: "reserved for future assignment",
            137: "reserved for future assignment",
            138: "reserved for future assignment",
            139: "reserved for future assignment",
            14: "reserved for future assignment",
            140: "reserved for future assignment",
            141: "reserved for future assignment",
            142: "reserved for future assignment",
            143: "reserved for future assignment",
            144: "reserved for future assignment",
            145: "reserved for future assignment",
            146: "reserved for future assignment",
            147: "reserved for future assignment",
            148: "reserved for future assignment",
            149: "reserved for future assignment",
            15: "reserved for future assignment",
            150: "reserved for future assignment",
            151: "reserved for future assignment",
            152: "reserved for future assignment",
            153: "reserved for future assignment",
            154: "reserved for future assignment",
            155: "reserved for future assignment",
            156: "reserved for future assignment",
            157: "reserved for future assignment",
            158: "reserved for future assignment",
            159: "reserved for future assignment",
            16: "reserved for future assignment",
            160: "reserved for future assignment",
            161: "reserved for future assignment",
            162: "reserved for future assignment",
            163: "reserved for future assignment",
            164: "reserved for future assignment",
            165: "reserved for future assignment",
            166: "reserved for future assignment",
            167: "reserved for future assignment",
            168: "reserved for future assignment",
            169: "reserved for future assignment",
            17: "reserved for future assignment",
            170: "reserved for future assignment",
            171: "reserved for future assignment",
            172: "reserved for future assignment",
            173: "reserved for future assignment",
            174: "reserved for future assignment",
            175: "reserved for future assignment",
            176: "reserved for future assignment",
            177: "reserved for future assignment",
            178: "reserved for future assignment",
            179: "reserved for future assignment",
            18: "reserved for future assignment",
            180: "reserved for future assignment",
            181: "reserved for future assignment",
            182: "reserved for future assignment",
            183: "reserved for future assignment",
            184: "reserved for future assignment",
            185: "reserved for future assignment",
            186: "reserved for future assignment",
            187: "reserved for future assignment",
            188: "reserved for future assignment",
            189: "reserved for future assignment",
            19: "reserved for future assignment",
            190: "reserved for future assignment",
            191: "reserved for future assignment",
            192: "reserved for future assignment",
            193: "reserved for future assignment",
            194: "reserved for future assignment",
            195: "reserved for future assignment",
            196: "reserved for future assignment",
            197: "reserved for future assignment",
            198: "reserved for future assignment",
            199: "reserved for future assignment",
            2: "wireless lan #1",
            20: "reserved for future assignment",
            200: "reserved for future assignment",
            201: "reserved for future assignment",
            202: "reserved for future assignment",
            203: "reserved for future assignment",
            204: "reserved for future assignment",
            205: "reserved for future assignment",
            206: "reserved for future assignment",
            207: "reserved for future assignment",
            208: "reserved for future assignment",
            209: "reserved for future assignment",
            21: "reserved for future assignment",
            210: "reserved for future assignment",
            211: "reserved for future assignment",
            212: "reserved for future assignment",
            213: "reserved for future assignment",
            214: "reserved for future assignment",
            215: "reserved for future assignment",
            216: "reserved for future assignment",
            217: "reserved for future assignment",
            218: "reserved for future assignment",
            219: "reserved for future assignment",
            22: "reserved for future assignment",
            220: "reserved for future assignment",
            221: "reserved for future assignment",
            222: "reserved for future assignment",
            223: "reserved for future assignment",
            224: "reserved for future assignment",
            225: "reserved for future assignment",
            226: "reserved for future assignment",
            227: "reserved for future assignment",
            228: "reserved for future assignment",
            229: "reserved for future assignment",
            23: "reserved for future assignment",
            230: "reserved for future assignment",
            231: "reserved for future assignment",
            232: "reserved for future assignment",
            233: "reserved for future assignment",
            234: "reserved for future assignment",
            235: "reserved for future assignment",
            236: "reserved for future assignment",
            237: "reserved for future assignment",
            238: "reserved for future assignment",
            239: "reserved for future assignment",
            24: "reserved for future assignment",
            240: "reserved for future assignment",
            241: "reserved for future assignment",
            242: "reserved for future assignment",
            243: "reserved for future assignment",
            244: "reserved for future assignment",
            245: "reserved for future assignment",
            246: "reserved for future assignment",
            247: "reserved for future assignment",
            248: "reserved for future assignment",
            249: "reserved for future assignment",
            25: "reserved for future assignment",
            250: "reserved for future assignment",
            251: "reserved",
            252: "reserved",
            253: "reserved",
            254: "error",
            255: "not available",
            26: "reserved for future assignment",
            27: "reserved for future assignment",
            28: "reserved for future assignment",
            29: "reserved for future assignment",
            3: "wireless lan #2",
            30: "reserved for future assignment",
            31: "reserved for future assignment",
            32: "reserved for future assignment",
            33: "reserved for future assignment",
            34: "reserved for future assignment",
            35: "reserved for future assignment",
            36: "reserved for future assignment",
            37: "reserved for future assignment",
            38: "reserved for future assignment",
            39: "reserved for future assignment",
            4: "satellite network",
            40: "reserved for future assignment",
            41: "reserved for future assignment",
            42: "reserved for future assignment",
            43: "reserved for future assignment",
            44: "reserved for future assignment",
            45: "reserved for future assignment",
            46: "reserved for future assignment",
            47: "reserved for future assignment",
            48: "reserved for future assignment",
            49: "reserved for future assignment",
            5: "reserved for future assignment",
            50: "reserved for future assignment",
            51: "reserved for future assignment",
            52: "reserved for future assignment",
            53: "reserved for future assignment",
            54: "reserved for future assignment",
            55: "reserved for future assignment",
            56: "reserved for future assignment",
            57: "reserved for future assignment",
            58: "reserved for future assignment",
            59: "reserved for future assignment",
            6: "reserved for future assignment",
            60: "reserved for future assignment",
            61: "reserved for future assignment",
            62: "reserved for future assignment",
            63: "reserved for future assignment",
            64: "reserved for future assignment",
            65: "reserved for future assignment",
            66: "reserved for future assignment",
            67: "reserved for future assignment",
            68: "reserved for future assignment",
            69: "reserved for future assignment",
            7: "reserved for future assignment",
            70: "reserved for future assignment",
            71: "reserved for future assignment",
            72: "reserved for future assignment",
            73: "reserved for future assignment",
            74: "reserved for future assignment",
            75: "reserved for future assignment",
            76: "reserved for future assignment",
            77: "reserved for future assignment",
            78: "reserved for future assignment",
            79: "reserved for future assignment",
            8: "reserved for future assignment",
            80: "reserved for future assignment",
            81: "reserved for future assignment",
            82: "reserved for future assignment",
            83: "reserved for future assignment",
            84: "reserved for future assignment",
            85: "reserved for future assignment",
            86: "reserved for future assignment",
            87: "reserved for future assignment",
            88: "reserved for future assignment",
            89: "reserved for future assignment",
            9: "reserved for future assignment",
            90: "reserved for future assignment",
            91: "reserved for future assignment",
            92: "reserved for future assignment",
            93: "reserved for future assignment",
            94: "reserved for future assignment",
            95: "reserved for future assignment",
            96: "reserved for future assignment",
            97: "reserved for future assignment",
            98: "reserved for future assignment",
            99: "reserved for future assignment"
        },
        3447: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        3448: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        3452: {
            0: "   enable switch off - pto operation not desired",
            1: "   enable switch off - pto operation desired",
            2: "   error",
            3: "   not available"
        },
        3453: {
            0: "   enable switch off - pto operation not desired",
            1: "   enable switch off - pto operation desired",
            2: "   error",
            3: "   not available"
        },
        3454: {
            0: "   enable switch off - pto operation not desired",
            1: "   enable switch off - pto operation desired",
            2: "   error",
            3: "   not available"
        },
        3455: {
            0: "   enable switch off - pto operation not desired",
            1: "   enable switch off - pto operation desired",
            2: "   error",
            3: "   not available"
        },
        3456: {
            0: "   consent not given - pto drive should not be engaged",
            1: "   consent given - pto drive may be engaged",
            2: "   error",
            3: "   not available"
        },
        3457: {
            0: "   consent not given - pto drive should not be engaged",
            1: "   consent given - pto drive may be engaged",
            2: "   error",
            3: "   not available"
        },
        3458: {
            0: "   consent not given - pto drive should not be engaged",
            1: "   consent given - pto drive may be engaged",
            2: "   error",
            3: "   not available"
        },
        3459: {
            0: "   consent not given - pto drive should not be engaged",
            1: "   consent given - pto drive may be engaged",
            2: "   error",
            3: "   not available"
        },
        3460: {
            0: "   drive not engaged",
            1: "   drive is engaged",
            2: "   error",
            3: "   not available"
        },
        3461: {
            0: "   drive not engaged",
            1: "   drive is engaged",
            2: "   error",
            3: "   not available"
        },
        3462: {
            0: "   drive not engaged",
            1: "   drive is engaged",
            2: "   error",
            3: "   not available"
        },
        3463: {
            0: "   drive not engaged",
            1: "   drive is engaged",
            2: "   error",
            3: "   not available"
        },
        3482: {
            0: "   not active",
            1: "   active",
            2: "   reserved for sae assignment",
            3: "   not available"
        },
        3483: {
            0: "   not active",
            1: "   active",
            2: "   reserved for sae assignment",
            3: "   not available"
        },
        3484: {
            0: "   not active",
            1: "   active",
            2: "   reserved for sae assignment",
            3: "   not available"
        },
        3489: {
            0: "   not active",
            1: "   active",
            2: "   reserved for sae assignment",
            3: "   not available"
        },
        3490: {
            0: "   not active",
            1: "   active",
            2: "   reserved for sae assignment",
            3: "   not available"
        },
        3491: {
            0: "   not active",
            1: "   active",
            2: "   reserved for sae assignment",
            3: "   not available"
        },
        3492: {
            0: "   not active",
            1: "   active",
            2: "   reserved for sae assignment",
            3: "   not available"
        },
        3496: {
            0: "   not active",
            1: "   active",
            2: "   reserved for sae assignment",
            3: "   not available"
        },
        3497: {
            0: "   not active",
            1: "   active",
            2: "   reserved for sae assignment",
            3: "   not available"
        },
        3498: {
            0: "   not active",
            1: "   active",
            2: "   reserved for sae assignment",
            3: "   not available"
        },
        3503: {
            0: "   not active",
            1: "   active",
            2: "   reserved for sae assignment",
            3: "   not available"
        },
        3504: {
            0: "   not active",
            1: "   active",
            2: "   reserved for sae assignment",
            3: "   not available"
        },
        3505: {
            0: "   not active",
            1: "   active",
            2: "   reserved for sae assignment",
            3: "   not available"
        },
        3506: {
            0: "   not active",
            1: "   active",
            2: "   reserved for sae assignment",
            3: "   not available"
        },
        3521: {
            0: "urea concentration too high",
            1: "urea concentration too low",
            13: "not able to determine diesel exhaust fluid property (fluid type unknown)",
            14: "error with diesel exhaust fluid property detection",
            15: "not available",
            2: "fluid is diesel",
            3: "diesel exhaust fluid is proper mixture",
            5: " to 1100 - reserved for sae assignment"
        },
        3533: {
            0: "empty",
            1: "full or not empty",
            2: "error",
            3: "not available"
        },
        3550: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available or not installed"
        },
        3551: {
            0: "not sufficiently lubricated",
            1: "sufficiently lubricated",
            2: "unable to determine if sufficiently lubricated",
            3: "not available or not installed"
        },
        3552: {
            0: "not sufficiently pre-heated",
            1: "sufficiently pre-heated",
            2: "unable to determine if engine oil is pre-heated sufficiently",
            3: "not available or not installed"
        },
        3553: {
            0: "not sufficiently pre-heated",
            1: "sufficiently pre-heated",
            2: "unable to determine  engine coolant pre-heated sufficiently",
            3: "not available or not installed"
        },
        3554: {
            0: "sufficiently vented (all combustible gases have been evacuated from intake and exhaust systems)",
            1: "ventilation needed (combustible gases may be present in intake and exhaust systems)",
            2: "ventilation delay (delay without cranking between ventilation and start engine states)",
            3: "currently venting (engine cranks w/o gas or ignition to clear intake and exhaust systems with air)",
            4: "reserved for sae assignment",
            5: "reserved for sae assignment ",
            6: "not able to determine if sufficiently vented",
            7: "not available or not installe"
        },
        3557: {
            0: "off",
            1: "on",
            2: "reserved ",
            3: "take no action"
        },
        3558: {
            0: "             sae j1995",
            1: "   not defined",
            10: "   not defined",
            11: "   not defined",
            12: "   not defined",
            13: "   not defined",
            15: "             not available",
            2: "   not defined",
            3: "   not defined",
            4: "   not defined",
            5: "   not defined",
            6: "   not defined",
            7: "   not defined",
            8: "   not defined",
            9: "   not defined"
        },
        3564: {
            0: "   disable lane departure warning",
            1: "   enable lane departure warning",
            2: "   reserved",
            3: "   don-t care"
        },
        3565: {
            0: "   middle of the vehicle does not depart the lane to the left side",
            1: "   middle of the vehicle departs the lane to the left side",
            2: "   reserved",
            3: "   take no action"
        },
        3566: {
            0: "   middle of the vehicle does not depart the lane to the right side",
            1: "   middle of the vehicle departs the lane to the right side",
            2: "   reserved",
            3: "   take no action"
        },
        3567: {
            0: "inactive (ready to start automatically)",
            1: "active (not ready to start automatically)",
            2: "error",
            3: "not available"
        },
        3568: {
            0: "inactive (ready to parallel)",
            1: "active (not ready to parallel)",
            2: "error",
            3: "not available"
        },
        3589: {
            0: "off",
            1: "on",
            2: "reserved",
            3: "unavailable"
        },
        3600: {
            0: " take no action - do not reset",
            1: " reset",
            2: " reserved, take no action",
            3: " not applicable"
        },
        3601: {
            0: "off (reset / no test in process)",
            1: "on (test in process / test complete)",
            2: "reserved",
            3: "don't care / take no action"
        },
        3602: {
            0: "off",
            1: "on",
            2: "reserved",
            3: "don't care / take no action"
        },
        3603: {
            0: "off (no power conservation; all systems with supply power available)",
            1: "on (power conservation active; certain systems have supply power witheld)",
            2: "reserved",
            3: "unavailable"
        },
        3604: {
            0: "off ",
            1: "on",
            2: "reserved",
            3: "unavailable"
        },
        3605: {
            0: "off",
            1: "on",
            2: "reserved",
            3: "don't care / take no action"
        },
        3606: {
            0: "off (no shutdown requested)",
            1: "on (shutdown requested)",
            2: "reserved",
            3: "don't care / take no action"
        },
        3607: {
            0: "off (no shutdown requested)",
            1: "on (shutdown requested)",
            2: "reserved",
            3: "don't care / take no action"
        },
        3608: {
            0: "closed (vent closed)",
            1: "open (vent open)",
            2: "reserved",
            3: "don't care / take no action"
        },
        3613: {
            0: " clear display - the displayed information should be deleted or not displayed any more.",
            1: " hold display - the presently displayed information should be retained",
            10: "  reserved",
            11: "  reserved",
            12: "  reserved",
            13: "  reserved",
            14: "  reserved",
            15: "not applicable",
            2: " append at end of display - the transmitted information should be displayed at the end of the presently displayed information",
            3: " overwrite display - the presently displayed information is to be overwritten with the transmitted information",
            4: " overwrite substring - a portion of the presently displayed information is to be overwritten with the transmitted information starting at display text index (spn 3614)",
            5: " highlight substring",
            6: " blink substring",
            7: "  reserved",
            8: "  reserved",
            9: "  reserved"
        },
        3621: {
            0: "dtc is previously active",
            1: "dtc is active"
        },
        3645: {
            0: " 2 wheel high (normal or `'on highway' range)",
            1: " 4 wheel high (normal or  'on highway' range",
            2: " neutral",
            3: " 2 wheel low (or `'off highway' range)",
            4: " 4 wheel low (or `'off highway' range)",
            5: " transfer case shift in progress or gear not confirmed",
            6: " error",
            7: " not available"
        },
        3667: {
            0: "air flow allowed to engine",
            1: "air flow restricted",
            2: "error",
            3: "not available"
        },
        3669: {
            0: "counterclockwise (ccw)",
            1: "clockwise (cw)",
            2: "reserved",
            3: "not available"
        },
        3685: {
            0: "relative number of counts",
            1: "absolute number of counts",
            2: "not defined",
            3: "signal not available"
        },
        3687: {
            0: "programming mode active",
            1: "normal mode active",
            2: "reserved",
            3: "not available"
        },
        3688: {
            0: "sas not calibrated",
            1: "sas calibrated",
            2: "reserved",
            3: "not available"
        },
        3691: {
            0: "   dynamic bending light deactivated.  there is no problem but for some reasons (e.g. daylight present) the bending light is deactivated.",
            1: "   dynamic bending light is working properly.  normal operation mode. bending light is working properly.",
            2: "   dynamic bending light fail safe position.  bending light is damaged, current position does not affect oncoming traffic.",
            3: "   dynamic bending light failure.  bending light does not work, current position may affect oncoming traffic.",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: "   not available"
        },
        3692: {
            0: "   dynamic bending light deactivated.  there is no problem but for some reasons (e.g. daylight present) the bending light is deactivated.",
            1: "   dynamic bending light is working properly.  normal operation mode. bending light is working properly.",
            2: "   dynamic bending light fail safe position.  bending light is damaged, current position does not affect oncoming traffic.",
            3: "   dynamic bending light failure.  bending light does not work, current position may affect oncoming traffic.",
            4: " reserved",
            5: " reserved",
            6: " reserved",
            7: "   not available"
        },
        3693: {
            0: "   light distribution town - the basic light distribution for town light is generated with a symmetrical cut-off line (class v)",
            1: "   light distribution country - country light is mostly similar to the actual sae low beam pattern. (class c)",
            10: "   reserved",
            11: "   reserved",
            12: "   reserved",
            13: "   reserved",
            14: "   reserved",
            15: "   not available",
            2: "   light distribution motorway - the task of motorway light is an improved overall viewing distance and an optimum of illumination of the second lane on roads with more than one lane and without oncoming traffic. (class e)",
            3: "   light distribution high beam - the high beam distribution of the module generates an illumination level that an additional high beam spot is not necessary.",
            4: "   light distribution adverse weather - the adverse weather light improves the viewing situation for the driver on wet roads and reduces the amount of glare from reflections on wed reads for the oncoming traffic. (class w) ",
            5: "   light distribution fail safe position - module is damaged, current light distribution does not affect oncoming traffic.",
            6: "   light distribution failure - module is damaged, current position may affect oncoming traffic.",
            7: "   different light distributions not available -  no afs distributions available. head lamp has only one distribution.",
            8: "   reserved",
            9: "   reserved"
        },
        3694: {
            0: "   light distribution town - the basic light distribution for town light is generated with a symmetrical cut-off line (class v)",
            1: "   light distribution country - country light is mostly similar to the actual sae low beam pattern. (class c)",
            10: "   reserved",
            11: "   reserved",
            12: "   reserved",
            13: "   reserved",
            14: "   reserved",
            15: "   not available",
            2: "   light distribution motorway - the task of motorway light is an improved overall viewing distance and an optimum of illumination of the second lane on roads with more than one lane and without oncoming traffic. (class e)",
            3: "   light distribution high beam - the high beam distribution of the module generates an illumination level that an additional high beam spot is not necessary.",
            4: "   light distribution adverse weather - the adverse weather light improves the viewing situation for the driver on wet roads and reduces the amount of glare from reflections on wed reads for the oncoming traffic. (class w) ",
            5: "   light distribution fail safe position - module is damaged, current light distribution does not affect oncoming traffic.",
            6: "   light distribution failure - module is damaged, current position may affect oncoming traffic.",
            7: "   different light distributions not available -  no afs distributions available. head lamp has only one distribution.",
            8: "   reserved",
            9: "   reserved"
        },
        3695: {
            0: " not active",
            1: " active",
            2: " error",
            3: " not available"
        },
        3696: {
            0: " not active",
            1: " active",
            2: " error",
            3: " not available"
        },
        3697: {
            0: " off",
            1: " on - solid",
            2: " reserved for sae assignment ",
            3: " reserved for sae assignment",
            4: " on - fast blink (1 hz)",
            5: " reserved for sae assignment",
            6: " reserved for sae assignment",
            7: " not available"
        },
        3698: {
            0: " off",
            1: " on - solid ",
            2: " reserved for sae assignment ",
            3: " reserved for sae assignment",
            4: " reserved for sae assignment",
            5: " reserved for sae assignment",
            6: " reserved for sae assignment",
            7: " not available"
        },
        3699: {
            0: " not active",
            1: " active",
            2: " reserved for sae assignment",
            3: " not available"
        },
        3700: {
            0: " not active",
            1: " active",
            2: " regeneration needed - automatically initiated active regeneration imminent",
            3: " not available"
        },
        3701: {
            0: " regeneration not needed",
            1: " regeneration needed - lowest level",
            2: " regeneration needed - moderate level",
            3: " regeneration needed - highest level",
            4: " reserved for sae assignment",
            5: " reserved for sae assignment",
            6: " reserved for sae assignment",
            7: " not available"
        },
        3702: {
            0: " not inhibited",
            1: " inhibited",
            2: " reserved for sae assignment",
            3: " not available"
        },
        3703: {
            0: " not inhibited",
            1: " inhibited",
            2: " reserved for sae assignment",
            3: " not available"
        },
        3704: {
            0: " not inhibited",
            1: " inhibited",
            2: " reserved for sae assignment",
            3: " not available"
        },
        3705: {
            0: " not inhibited",
            1: " inhibited",
            2: " reserved for sae assignment",
            3: " not available"
        },
        3706: {
            0: " not inhibited",
            1: " inhibited",
            2: " reserved for sae assignment",
            3: " not available"
        },
        3707: {
            0: " not inhibited",
            1: " inhibited",
            2: " reserved for sae assignment",
            3: " not available"
        },
        3708: {
            0: " not inhibited",
            1: " inhibited",
            2: " reserved for sae assignment",
            3: " not available"
        },
        3709: {
            0: " not inhibited",
            1: " inhibited",
            2: " reserved for sae assignment",
            3: " not available"
        },
        3710: {
            0: " not inhibited",
            1: " inhibited",
            2: " reserved for sae assignment",
            3: " not available"
        },
        3711: {
            0: " not inhibited",
            1: " inhibited",
            2: " reserved for sae assignment",
            3: " not available"
        },
        3712: {
            0: " not inhibited",
            1: " inhibited",
            2: " reserved for sae assignment",
            3: " not available"
        },
        3713: {
            0: " not inhibited",
            1: " inhibited",
            2: " reserved for sae assignment",
            3: " not available"
        },
        3714: {
            0: " not inhibited",
            1: " inhibited",
            2: " reserved for sae assignment",
            3: " not available"
        },
        3715: {
            0: " not inhibited",
            1: " inhibited",
            2: " reserved for sae assignment",
            3: " not available"
        },
        3716: {
            0: " not inhibited",
            1: " inhibited",
            2: " reserved for sae assignment",
            3: " not available"
        },
        3717: {
            0: " not inhibited",
            1: " inhibited",
            2: " reserved for sae assignment",
            3: " not available"
        },
        3718: {
            0: " not enabled",
            1: " enabled",
            2: " reserved for sae assignment",
            3: " not available"
        },
        3750: {
            0: " active dpf regeneration not inhibited",
            1: " active dpf regeneration inhibited",
            2: " reserved for sae assignment",
            3: " not available"
        },
        3785: {
            0: "ok (normal operation)  ",
            1: "non-functioning",
            2: "overstroke ",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3786: {
            0: "ok (normal operation)",
            1: "non-functioning",
            2: "overstroke",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3787: {
            0: "ok (normal operation)",
            1: "non-functioning",
            2: "overstroke",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3788: {
            0: "ok (normal operation)",
            1: "non-functioning",
            2: "overstroke",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3789: {
            0: "ok (normal operation)",
            1: "non-functioning",
            2: "overstroke",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3790: {
            0: "ok (normal operation)",
            1: "non-functioning",
            2: "overstroke",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3791: {
            0: "ok (normal operation)",
            1: "non-functioning",
            2: "overstroke",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3792: {
            0: "ok (normal operation)",
            1: "non-functioning",
            2: "overstroke",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3793: {
            0: "ok (normal operation)",
            1: "non-functioning",
            2: "overstroke",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3794: {
            0: "ok (normal operation)",
            1: "non-functioning",
            2: "overstroke",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3795: {
            0: "ok (normal operation)",
            1: "non-functioning",
            2: "overstroke",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3796: {
            0: "ok (normal operation)",
            1: "non-functioning",
            2: "overstroke",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3797: {
            0: "ok (normal operation)",
            1: "non-functioning",
            2: "overstroke",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3798: {
            0: "ok (normal operation)",
            1: "non-functioning",
            2: "overstroke",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3799: {
            0: "ok (normal operation)",
            1: "non-functioning",
            2: "overstroke",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3800: {
            0: "ok (normal operation)",
            1: "non-functioning",
            2: "overstroke",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3801: {
            0: "ok (normal operation)",
            1: "non-functioning",
            2: "overstroke",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3802: {
            0: "ok (normal operation)",
            1: "non-functioning",
            2: "overstroke",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3803: {
            0: "ok (normal operation)",
            1: "non-functioning",
            2: "overstroke",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3804: {
            0: "ok (normal operation)",
            1: "non-functioning",
            2: "overstroke",
            3: "dragging brake",
            4: "reserved",
            5: "reserved",
            6: "sensor error",
            7: "not available"
        },
        3807: {
            0: "park brake release inhibit not requested",
            1: "park brake release inhibit requested",
            2: "sae reserved",
            3: "unavailable"
        },
        3808: {
            0: "park brake release is not inhibited",
            1: "park brake release is inhibited",
            2: "error (for example: park brake release is not inhibited, but is requested to be inhibited)",
            3: "unavailable"
        },
        3809: {
            0: "no transmission oil level reading desired",
            1: "transmission oil level reading desired",
            2: "reserved",
            3: "don't care / take no action"
        },
        3810: {
            0: " ramp retracted",
            1: " ramp extended",
            2: " error",
            3: " not available"
        },
        3811: {
            0: " ramp disabled",
            1: " ramp enabled ",
            2: " error ",
            3: " not available"
        },
        3812: {
            0: " ramp not being moved",
            1: " ramp being moved",
            2: " error",
            3: " not available"
        },
        3813: {
            0: " ramp retracted",
            1: " ramp extended",
            2: " error",
            3: " not available"
        },
        3814: {
            0: " ramp disabled",
            1: " ramp enabled ",
            2: " error ",
            3: " not available"
        },
        3815: {
            0: " ramp not being moved",
            1: " ramp being moved",
            2: " error",
            3: " not available"
        },
        3816: {
            0: " ramp retracted",
            1: " ramp extended",
            2: " error",
            3: " not available"
        },
        3817: {
            0: " ramp disabled",
            1: " ramp enabled ",
            2: " error ",
            3: " not available"
        },
        3818: {
            0: " ramp not being moved",
            1: " ramp being moved",
            2: " error",
            3: " not available"
        },
        3819: {
            0: " front axle group disengaged ",
            1: " front axle group engaged",
            2: " error",
            3: " not available"
        },
        3820: {
            0: " rear axle group disengaged ",
            1: " rear axle group engaged",
            2: " error",
            3: " not available"
        },
        3839: {
            0: " not active",
            1: " active",
            2: " reserved",
            3: " not available"
        },
        3840: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3841: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3842: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3843: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3844: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3845: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3846: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3847: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3848: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3849: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3850: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3851: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3852: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3853: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3854: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3855: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3856: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3857: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3858: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3859: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3860: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3861: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3862: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3863: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3864: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3865: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3866: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3867: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3868: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3869: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3870: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3871: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3872: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3873: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3874: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3875: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3876: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3877: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3878: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3879: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3880: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3881: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3882: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3883: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3884: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3885: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3886: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3887: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3888: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3889: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3890: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3891: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3892: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3893: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3894: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3895: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3896: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3897: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3898: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3899: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3900: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3901: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3902: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3903: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3904: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3905: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3906: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3907: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3908: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3909: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3910: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3911: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3912: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3913: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3914: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3915: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3916: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3917: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3918: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3919: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3920: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3921: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3922: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3923: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3924: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3925: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3926: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3927: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3928: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3929: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3930: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3931: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3932: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3933: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3934: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3935: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error indicator or not used , depending on application",
            3: "not available or take no action, depending on application"
        },
        3939: {
            0: " enable switch off - pto operation not desired",
            1: " enable switch on - pto operation desired ",
            2: " error",
            3: " not available"
        },
        3940: {
            0: " consent not given - pto drive may not be engaged",
            1: " consent given - pto drive may be engaged",
            2: " error",
            3: " not available"
        },
        3941: {
            0: " drive not engaged",
            1: " drive engaged",
            2: " error",
            3: " not available"
        },
        3942: {
            0: " enable switch off - pto operation not desired",
            1: " enable switch on - pto operation desired",
            2: " error",
            3: " not available"
        },
        3943: {
            0: " consent not given - pto drive may not be engaged",
            1: " consent given - pto drive may be engaged",
            2: " error",
            3: " not available"
        },
        3944: {
            0: " drive not engaged",
            1: " drive engaged",
            2: " error",
            3: " not available"
        },
        3945: {
            0: " enable switch off - pto operation not desired",
            1: " enable switch on - pto operation desired",
            2: " error",
            3: " not available"
        },
        3946: {
            0: " consent not given - pto drive may not be engaged",
            1: " consent given - pto drive may be engaged",
            2: " error",
            3: " not available"
        },
        3947: {
            0: " drive not engaged",
            1: " drive engaged",
            2: " error",
            3: " not available"
        },
        3948: {
            0: " no pto drive is engaged",
            1: " at least one pto drive is engaged",
            2: " error",
            3: " not available"
        },
        3987: {
            0: "lamp off",
            1: "lamp on",
            2: "reserved",
            3: "not available"
        },
        4059: {
            0: "steer axle group not present",
            1: "steer axle group present",
            2: "reserved",
            3: "not available / not applicable"
        },
        4060: {
            0: "lift axle group not present",
            1: "lift axle group present",
            2: "reserved",
            3: "not available / not applicable"
        },
        4061: {
            0: "drive axle group not present",
            1: "drive axle group present",
            2: "reserved",
            3: "not available / not applicable"
        },
        4062: {
            0: "tag axle group not present",
            1: "tag axle group present",
            2: "reserved",
            3: "not available / not applicable"
        },
        4063: {
            0: "additional tractor axle group not present",
            1: "additional tractor axle group present",
            2: "reserved",
            3: "not available / not applicable"
        },
        4064: {
            0: "trailer a axle group not present",
            1: "trailer a axle group present",
            2: "reserved",
            3: "not available / not applicable"
        },
        4065: {
            0: "trailer b axle group not present",
            1: "trailer b axle group present",
            2: "reserved",
            3: "not available / not applicable"
        },
        4066: {
            0: "trailer c axle group not present",
            1: "trailer c axle group present",
            2: "reserved",
            3: "not available / not applicable"
        },
        4067: {
            0: "trailer d axle group not present",
            1: "trailer d axle group present",
            2: "reserved",
            3: "not available / not applicable"
        },
        4068: {
            0: "trailer e axle group not present",
            1: "trailer e axle group present",
            2: "reserved",
            3: "not available / not applicable"
        },
        4069: {
            0: "trailer f axle group not present",
            1: "trailer f axle group present",
            2: "reserved",
            3: "not available / not applicable"
        },
        4070: {
            0: "trailer g axle group not present",
            1: "trailer g axle group present",
            2: "reserved",
            3: "not available / not applicable"
        },
        4071: {
            0: "trailer h axle group not present",
            1: "trailer h axle group present",
            2: "reserved",
            3: "not available / not applicable"
        },
        4072: {
            0: "additional trailer axle group not present",
            1: "additional trailer axle group present",
            2: "reserved",
            3: "not available / not applicable"
        },
        4073: {
            0: "reserved",
            1: "steer axle group",
            10: "trailer e axle group",
            11: "trailer f axle group",
            12: "trailer g axle group",
            13: "trailer h axle group",
            14: "additional trailer axle group",
            15: "reserved",
            2: "lift axle group",
            3: "drive axle group",
            4: "tag axle group",
            5: "additional tractor axle group",
            6: "trailer a axle group",
            7: "trailer b axle group",
            8: "trailer c axle group",
            9: "trailer d axle group"
        },
        4074: {
            0: "reserved",
            1: "steer axle group",
            10: "trailer e axle group",
            11: "trailer f axle group",
            12: "trailer g axle group",
            13: "trailer h axle group",
            14: "additional trailer axle group",
            15: "reserved",
            2: "lift axle group",
            3: "drive axle group",
            4: "tag axle group",
            5: "additional tractor axle group",
            6: "trailer a axle group",
            7: "trailer b axle group",
            8: "trailer c axle group",
            9: "trailer d axle group"
        },
        4075: {
            0: "no change to net vehicle weight change ",
            1: "zero net vehicle weight change",
            2: "reserved",
            3: "not available / not applicable"
        },
        4079: {
            0: "rated speed",
            1: "low idle speed",
            2: "reserved",
            3: "don't care / take no action"
        },
        4080: {
            0: " hz",
            1: " hz",
            10: " hz",
            100: "sae reserved",
            1000: "sae reserved",
            1001: "sae reserved",
            1002: "sae reserved",
            1003: "sae reserved",
            1004: "sae reserved",
            1005: "sae reserved",
            1006: "sae reserved",
            1007: "sae reserved",
            1008: "sae reserved",
            1009: "sae reserved",
            101: "sae reserved",
            1010: "sae reserved",
            1011: "sae reserved",
            1012: "sae reserved",
            1013: "sae reserved",
            1014: "sae reserved",
            1015: "sae reserved",
            1016: "sae reserved",
            1017: "sae reserved",
            1018: "sae reserved",
            1019: "sae reserved",
            102: "sae reserved",
            1020: "sae reserved",
            1021: "sae reserved",
            1022: "sae reserved",
            1023: "sae reserved",
            1024: "sae reserved",
            1025: "sae reserved",
            1026: "sae reserved",
            1027: "sae reserved",
            1028: "sae reserved",
            1029: "sae reserved",
            103: "sae reserved",
            1030: "sae reserved",
            1031: "sae reserved",
            1032: "sae reserved",
            1033: "sae reserved",
            1034: "sae reserved",
            1035: "sae reserved",
            1036: "sae reserved",
            1037: "sae reserved",
            1038: "sae reserved",
            1039: "sae reserved",
            104: "sae reserved",
            1040: "sae reserved",
            1041: "sae reserved",
            1042: "sae reserved",
            1043: "sae reserved",
            1044: "sae reserved",
            1045: "sae reserved",
            1046: "sae reserved",
            1047: "sae reserved",
            1048: "sae reserved",
            1049: "sae reserved",
            105: "sae reserved",
            1050: "sae reserved",
            1051: "sae reserved",
            1052: "sae reserved",
            1053: "sae reserved",
            1054: "sae reserved",
            1055: "sae reserved",
            1056: "sae reserved",
            1057: "sae reserved",
            1058: "sae reserved",
            1059: "sae reserved",
            106: "sae reserved",
            1060: "sae reserved",
            1061: "sae reserved",
            1062: "sae reserved",
            1063: "sae reserved",
            1064: "sae reserved",
            1065: "sae reserved",
            1066: "sae reserved",
            1067: "sae reserved",
            1068: "sae reserved",
            1069: "sae reserved",
            107: "sae reserved",
            1070: "sae reserved",
            1071: "sae reserved",
            1072: "sae reserved",
            1073: "sae reserved",
            1074: "sae reserved",
            1075: "sae reserved",
            1076: "sae reserved",
            1077: "sae reserved",
            1078: "sae reserved",
            1079: "sae reserved",
            108: "sae reserved",
            1080: "sae reserved",
            1081: "sae reserved",
            1082: "sae reserved",
            1083: "sae reserved",
            1084: "sae reserved",
            1085: "sae reserved",
            1086: "sae reserved",
            1087: "sae reserved",
            1088: "sae reserved",
            1089: "sae reserved",
            109: "sae reserved",
            1090: "sae reserved",
            1091: "sae reserved",
            1092: "sae reserved",
            1093: "sae reserved",
            1094: "sae reserved",
            1095: "sae reserved",
            1096: "sae reserved",
            1097: "sae reserved",
            1098: "sae reserved",
            1099: "sae reserved",
            11: "sae reserved",
            110: "sae reserved",
            1100: "sae reserved",
            1101: "sae reserved",
            111: "sae reserved",
            1110: "unknown",
            1111: "don't care /take no action",
            112: "sae reserved",
            113: "sae reserved",
            114: "sae reserved",
            115: "sae reserved",
            116: "sae reserved",
            117: "sae reserved",
            118: "sae reserved",
            119: "sae reserved",
            12: "sae reserved",
            120: "sae reserved",
            121: "sae reserved",
            122: "sae reserved",
            123: "sae reserved",
            124: "sae reserved",
            125: "sae reserved",
            126: "sae reserved",
            127: "sae reserved",
            128: "sae reserved",
            129: "sae reserved",
            13: "sae reserved",
            130: "sae reserved",
            131: "sae reserved",
            132: "sae reserved",
            133: "sae reserved",
            134: "sae reserved",
            135: "sae reserved",
            136: "sae reserved",
            137: "sae reserved",
            138: "sae reserved",
            139: "sae reserved",
            14: "sae reserved",
            140: "sae reserved",
            141: "sae reserved",
            142: "sae reserved",
            143: "sae reserved",
            144: "sae reserved",
            145: "sae reserved",
            146: "sae reserved",
            147: "sae reserved",
            148: "sae reserved",
            149: "sae reserved",
            15: "sae reserved",
            150: "sae reserved",
            151: "sae reserved",
            152: "sae reserved",
            153: "sae reserved",
            154: "sae reserved",
            155: "sae reserved",
            156: "sae reserved",
            157: "sae reserved",
            158: "sae reserved",
            159: "sae reserved",
            16: "sae reserved",
            160: "sae reserved",
            161: "sae reserved",
            162: "sae reserved",
            163: "sae reserved",
            164: "sae reserved",
            165: "sae reserved",
            166: "sae reserved",
            167: "sae reserved",
            168: "sae reserved",
            169: "sae reserved",
            17: "sae reserved",
            170: "sae reserved",
            171: "sae reserved",
            172: "sae reserved",
            173: "sae reserved",
            174: "sae reserved",
            175: "sae reserved",
            176: "sae reserved",
            177: "sae reserved",
            178: "sae reserved",
            179: "sae reserved",
            18: "sae reserved",
            180: "sae reserved",
            181: "sae reserved",
            182: "sae reserved",
            183: "sae reserved",
            184: "sae reserved",
            185: "sae reserved",
            186: "sae reserved",
            187: "sae reserved",
            188: "sae reserved",
            189: "sae reserved",
            19: "sae reserved",
            190: "sae reserved",
            191: "sae reserved",
            192: "sae reserved",
            193: "sae reserved",
            194: "sae reserved",
            195: "sae reserved",
            196: "sae reserved",
            197: "sae reserved",
            198: "sae reserved",
            199: "sae reserved",
            2: " hz",
            20: "sae reserved",
            200: "sae reserved",
            201: "sae reserved",
            202: "sae reserved",
            203: "sae reserved",
            204: "sae reserved",
            205: "sae reserved",
            206: "sae reserved",
            207: "sae reserved",
            208: "sae reserved",
            209: "sae reserved",
            21: "sae reserved",
            210: "sae reserved",
            211: "sae reserved",
            212: "sae reserved",
            213: "sae reserved",
            214: "sae reserved",
            215: "sae reserved",
            216: "sae reserved",
            217: "sae reserved",
            218: "sae reserved",
            219: "sae reserved",
            22: "sae reserved",
            220: "sae reserved",
            221: "sae reserved",
            222: "sae reserved",
            223: "sae reserved",
            224: "sae reserved",
            225: "sae reserved",
            226: "sae reserved",
            227: "sae reserved",
            228: "sae reserved",
            229: "sae reserved",
            23: "sae reserved",
            230: "sae reserved",
            231: "sae reserved",
            232: "sae reserved",
            233: "sae reserved",
            234: "sae reserved",
            235: "sae reserved",
            236: "sae reserved",
            237: "sae reserved",
            238: "sae reserved",
            239: "sae reserved",
            24: "sae reserved",
            240: "sae reserved",
            241: "sae reserved",
            242: "sae reserved",
            243: "sae reserved",
            244: "sae reserved",
            245: "sae reserved",
            246: "sae reserved",
            247: "sae reserved",
            248: "sae reserved",
            249: "sae reserved",
            25: "sae reserved",
            250: "sae reserved",
            251: "sae reserved",
            252: "sae reserved",
            253: "sae reserved",
            254: "sae reserved",
            255: "sae reserved",
            256: "sae reserved",
            257: "sae reserved",
            258: "sae reserved",
            259: "sae reserved",
            26: "sae reserved",
            260: "sae reserved",
            261: "sae reserved",
            262: "sae reserved",
            263: "sae reserved",
            264: "sae reserved",
            265: "sae reserved",
            266: "sae reserved",
            267: "sae reserved",
            268: "sae reserved",
            269: "sae reserved",
            27: "sae reserved",
            270: "sae reserved",
            271: "sae reserved",
            272: "sae reserved",
            273: "sae reserved",
            274: "sae reserved",
            275: "sae reserved",
            276: "sae reserved",
            277: "sae reserved",
            278: "sae reserved",
            279: "sae reserved",
            28: "sae reserved",
            280: "sae reserved",
            281: "sae reserved",
            282: "sae reserved",
            283: "sae reserved",
            284: "sae reserved",
            285: "sae reserved",
            286: "sae reserved",
            287: "sae reserved",
            288: "sae reserved",
            289: "sae reserved",
            29: "sae reserved",
            290: "sae reserved",
            291: "sae reserved",
            292: "sae reserved",
            293: "sae reserved",
            294: "sae reserved",
            295: "sae reserved",
            296: "sae reserved",
            297: "sae reserved",
            298: "sae reserved",
            299: "sae reserved",
            3: " hz",
            30: "sae reserved",
            300: "sae reserved",
            301: "sae reserved",
            302: "sae reserved",
            303: "sae reserved",
            304: "sae reserved",
            305: "sae reserved",
            306: "sae reserved",
            307: "sae reserved",
            308: "sae reserved",
            309: "sae reserved",
            31: "sae reserved",
            310: "sae reserved",
            311: "sae reserved",
            312: "sae reserved",
            313: "sae reserved",
            314: "sae reserved",
            315: "sae reserved",
            316: "sae reserved",
            317: "sae reserved",
            318: "sae reserved",
            319: "sae reserved",
            32: "sae reserved",
            320: "sae reserved",
            321: "sae reserved",
            322: "sae reserved",
            323: "sae reserved",
            324: "sae reserved",
            325: "sae reserved",
            326: "sae reserved",
            327: "sae reserved",
            328: "sae reserved",
            329: "sae reserved",
            33: "sae reserved",
            330: "sae reserved",
            331: "sae reserved",
            332: "sae reserved",
            333: "sae reserved",
            334: "sae reserved",
            335: "sae reserved",
            336: "sae reserved",
            337: "sae reserved",
            338: "sae reserved",
            339: "sae reserved",
            34: "sae reserved",
            340: "sae reserved",
            341: "sae reserved",
            342: "sae reserved",
            343: "sae reserved",
            344: "sae reserved",
            345: "sae reserved",
            346: "sae reserved",
            347: "sae reserved",
            348: "sae reserved",
            349: "sae reserved",
            35: "sae reserved",
            350: "sae reserved",
            351: "sae reserved",
            352: "sae reserved",
            353: "sae reserved",
            354: "sae reserved",
            355: "sae reserved",
            356: "sae reserved",
            357: "sae reserved",
            358: "sae reserved",
            359: "sae reserved",
            36: "sae reserved",
            360: "sae reserved",
            361: "sae reserved",
            362: "sae reserved",
            363: "sae reserved",
            364: "sae reserved",
            365: "sae reserved",
            366: "sae reserved",
            367: "sae reserved",
            368: "sae reserved",
            369: "sae reserved",
            37: "sae reserved",
            370: "sae reserved",
            371: "sae reserved",
            372: "sae reserved",
            373: "sae reserved",
            374: "sae reserved",
            375: "sae reserved",
            376: "sae reserved",
            377: "sae reserved",
            378: "sae reserved",
            379: "sae reserved",
            38: "sae reserved",
            380: "sae reserved",
            381: "sae reserved",
            382: "sae reserved",
            383: "sae reserved",
            384: "sae reserved",
            385: "sae reserved",
            386: "sae reserved",
            387: "sae reserved",
            388: "sae reserved",
            389: "sae reserved",
            39: "sae reserved",
            390: "sae reserved",
            391: "sae reserved",
            392: "sae reserved",
            393: "sae reserved",
            394: "sae reserved",
            395: "sae reserved",
            396: "sae reserved",
            397: "sae reserved",
            398: "sae reserved",
            399: "sae reserved",
            4: " hz",
            40: "sae reserved",
            400: "sae reserved",
            401: "sae reserved",
            402: "sae reserved",
            403: "sae reserved",
            404: "sae reserved",
            405: "sae reserved",
            406: "sae reserved",
            407: "sae reserved",
            408: "sae reserved",
            409: "sae reserved",
            41: "sae reserved",
            410: "sae reserved",
            411: "sae reserved",
            412: "sae reserved",
            413: "sae reserved",
            414: "sae reserved",
            415: "sae reserved",
            416: "sae reserved",
            417: "sae reserved",
            418: "sae reserved",
            419: "sae reserved",
            42: "sae reserved",
            420: "sae reserved",
            421: "sae reserved",
            422: "sae reserved",
            423: "sae reserved",
            424: "sae reserved",
            425: "sae reserved",
            426: "sae reserved",
            427: "sae reserved",
            428: "sae reserved",
            429: "sae reserved",
            43: "sae reserved",
            430: "sae reserved",
            431: "sae reserved",
            432: "sae reserved",
            433: "sae reserved",
            434: "sae reserved",
            435: "sae reserved",
            436: "sae reserved",
            437: "sae reserved",
            438: "sae reserved",
            439: "sae reserved",
            44: "sae reserved",
            440: "sae reserved",
            441: "sae reserved",
            442: "sae reserved",
            443: "sae reserved",
            444: "sae reserved",
            445: "sae reserved",
            446: "sae reserved",
            447: "sae reserved",
            448: "sae reserved",
            449: "sae reserved",
            45: "sae reserved",
            450: "sae reserved",
            451: "sae reserved",
            452: "sae reserved",
            453: "sae reserved",
            454: "sae reserved",
            455: "sae reserved",
            456: "sae reserved",
            457: "sae reserved",
            458: "sae reserved",
            459: "sae reserved",
            46: "sae reserved",
            460: "sae reserved",
            461: "sae reserved",
            462: "sae reserved",
            463: "sae reserved",
            464: "sae reserved",
            465: "sae reserved",
            466: "sae reserved",
            467: "sae reserved",
            468: "sae reserved",
            469: "sae reserved",
            47: "sae reserved",
            470: "sae reserved",
            471: "sae reserved",
            472: "sae reserved",
            473: "sae reserved",
            474: "sae reserved",
            475: "sae reserved",
            476: "sae reserved",
            477: "sae reserved",
            478: "sae reserved",
            479: "sae reserved",
            48: "sae reserved",
            480: "sae reserved",
            481: "sae reserved",
            482: "sae reserved",
            483: "sae reserved",
            484: "sae reserved",
            485: "sae reserved",
            486: "sae reserved",
            487: "sae reserved",
            488: "sae reserved",
            489: "sae reserved",
            49: "sae reserved",
            490: "sae reserved",
            491: "sae reserved",
            492: "sae reserved",
            493: "sae reserved",
            494: "sae reserved",
            495: "sae reserved",
            496: "sae reserved",
            497: "sae reserved",
            498: "sae reserved",
            499: "sae reserved",
            5: " hz",
            50: "sae reserved",
            500: "sae reserved",
            501: "sae reserved",
            502: "sae reserved",
            503: "sae reserved",
            504: "sae reserved",
            505: "sae reserved",
            506: "sae reserved",
            507: "sae reserved",
            508: "sae reserved",
            509: "sae reserved",
            51: "sae reserved",
            510: "sae reserved",
            511: "sae reserved",
            512: "sae reserved",
            513: "sae reserved",
            514: "sae reserved",
            515: "sae reserved",
            516: "sae reserved",
            517: "sae reserved",
            518: "sae reserved",
            519: "sae reserved",
            52: "sae reserved",
            520: "sae reserved",
            521: "sae reserved",
            522: "sae reserved",
            523: "sae reserved",
            524: "sae reserved",
            525: "sae reserved",
            526: "sae reserved",
            527: "sae reserved",
            528: "sae reserved",
            529: "sae reserved",
            53: "sae reserved",
            530: "sae reserved",
            531: "sae reserved",
            532: "sae reserved",
            533: "sae reserved",
            534: "sae reserved",
            535: "sae reserved",
            536: "sae reserved",
            537: "sae reserved",
            538: "sae reserved",
            539: "sae reserved",
            54: "sae reserved",
            540: "sae reserved",
            541: "sae reserved",
            542: "sae reserved",
            543: "sae reserved",
            544: "sae reserved",
            545: "sae reserved",
            546: "sae reserved",
            547: "sae reserved",
            548: "sae reserved",
            549: "sae reserved",
            55: "sae reserved",
            550: "sae reserved",
            551: "sae reserved",
            552: "sae reserved",
            553: "sae reserved",
            554: "sae reserved",
            555: "sae reserved",
            556: "sae reserved",
            557: "sae reserved",
            558: "sae reserved",
            559: "sae reserved",
            56: "sae reserved",
            560: "sae reserved",
            561: "sae reserved",
            562: "sae reserved",
            563: "sae reserved",
            564: "sae reserved",
            565: "sae reserved",
            566: "sae reserved",
            567: "sae reserved",
            568: "sae reserved",
            569: "sae reserved",
            57: "sae reserved",
            570: "sae reserved",
            571: "sae reserved",
            572: "sae reserved",
            573: "sae reserved",
            574: "sae reserved",
            575: "sae reserved",
            576: "sae reserved",
            577: "sae reserved",
            578: "sae reserved",
            579: "sae reserved",
            58: "sae reserved",
            580: "sae reserved",
            581: "sae reserved",
            582: "sae reserved",
            583: "sae reserved",
            584: "sae reserved",
            585: "sae reserved",
            586: "sae reserved",
            587: "sae reserved",
            588: "sae reserved",
            589: "sae reserved",
            59: "sae reserved",
            590: "sae reserved",
            591: "sae reserved",
            592: "sae reserved",
            593: "sae reserved",
            594: "sae reserved",
            595: "sae reserved",
            596: "sae reserved",
            597: "sae reserved",
            598: "sae reserved",
            599: "sae reserved",
            6: " hz",
            60: "sae reserved",
            600: "sae reserved",
            601: "sae reserved",
            602: "sae reserved",
            603: "sae reserved",
            604: "sae reserved",
            605: "sae reserved",
            606: "sae reserved",
            607: "sae reserved",
            608: "sae reserved",
            609: "sae reserved",
            61: "sae reserved",
            610: "sae reserved",
            611: "sae reserved",
            612: "sae reserved",
            613: "sae reserved",
            614: "sae reserved",
            615: "sae reserved",
            616: "sae reserved",
            617: "sae reserved",
            618: "sae reserved",
            619: "sae reserved",
            62: "sae reserved",
            620: "sae reserved",
            621: "sae reserved",
            622: "sae reserved",
            623: "sae reserved",
            624: "sae reserved",
            625: "sae reserved",
            626: "sae reserved",
            627: "sae reserved",
            628: "sae reserved",
            629: "sae reserved",
            63: "sae reserved",
            630: "sae reserved",
            631: "sae reserved",
            632: "sae reserved",
            633: "sae reserved",
            634: "sae reserved",
            635: "sae reserved",
            636: "sae reserved",
            637: "sae reserved",
            638: "sae reserved",
            639: "sae reserved",
            64: "sae reserved",
            640: "sae reserved",
            641: "sae reserved",
            642: "sae reserved",
            643: "sae reserved",
            644: "sae reserved",
            645: "sae reserved",
            646: "sae reserved",
            647: "sae reserved",
            648: "sae reserved",
            649: "sae reserved",
            65: "sae reserved",
            650: "sae reserved",
            651: "sae reserved",
            652: "sae reserved",
            653: "sae reserved",
            654: "sae reserved",
            655: "sae reserved",
            656: "sae reserved",
            657: "sae reserved",
            658: "sae reserved",
            659: "sae reserved",
            66: "sae reserved",
            660: "sae reserved",
            661: "sae reserved",
            662: "sae reserved",
            663: "sae reserved",
            664: "sae reserved",
            665: "sae reserved",
            666: "sae reserved",
            667: "sae reserved",
            668: "sae reserved",
            669: "sae reserved",
            67: "sae reserved",
            670: "sae reserved",
            671: "sae reserved",
            672: "sae reserved",
            673: "sae reserved",
            674: "sae reserved",
            675: "sae reserved",
            676: "sae reserved",
            677: "sae reserved",
            678: "sae reserved",
            679: "sae reserved",
            68: "sae reserved",
            680: "sae reserved",
            681: "sae reserved",
            682: "sae reserved",
            683: "sae reserved",
            684: "sae reserved",
            685: "sae reserved",
            686: "sae reserved",
            687: "sae reserved",
            688: "sae reserved",
            689: "sae reserved",
            69: "sae reserved",
            690: "sae reserved",
            691: "sae reserved",
            692: "sae reserved",
            693: "sae reserved",
            694: "sae reserved",
            695: "sae reserved",
            696: "sae reserved",
            697: "sae reserved",
            698: "sae reserved",
            699: "sae reserved",
            7: " hz",
            70: "sae reserved",
            700: "sae reserved",
            701: "sae reserved",
            702: "sae reserved",
            703: "sae reserved",
            704: "sae reserved",
            705: "sae reserved",
            706: "sae reserved",
            707: "sae reserved",
            708: "sae reserved",
            709: "sae reserved",
            71: "sae reserved",
            710: "sae reserved",
            711: "sae reserved",
            712: "sae reserved",
            713: "sae reserved",
            714: "sae reserved",
            715: "sae reserved",
            716: "sae reserved",
            717: "sae reserved",
            718: "sae reserved",
            719: "sae reserved",
            72: "sae reserved",
            720: "sae reserved",
            721: "sae reserved",
            722: "sae reserved",
            723: "sae reserved",
            724: "sae reserved",
            725: "sae reserved",
            726: "sae reserved",
            727: "sae reserved",
            728: "sae reserved",
            729: "sae reserved",
            73: "sae reserved",
            730: "sae reserved",
            731: "sae reserved",
            732: "sae reserved",
            733: "sae reserved",
            734: "sae reserved",
            735: "sae reserved",
            736: "sae reserved",
            737: "sae reserved",
            738: "sae reserved",
            739: "sae reserved",
            74: "sae reserved",
            740: "sae reserved",
            741: "sae reserved",
            742: "sae reserved",
            743: "sae reserved",
            744: "sae reserved",
            745: "sae reserved",
            746: "sae reserved",
            747: "sae reserved",
            748: "sae reserved",
            749: "sae reserved",
            75: "sae reserved",
            750: "sae reserved",
            751: "sae reserved",
            752: "sae reserved",
            753: "sae reserved",
            754: "sae reserved",
            755: "sae reserved",
            756: "sae reserved",
            757: "sae reserved",
            758: "sae reserved",
            759: "sae reserved",
            76: "sae reserved",
            760: "sae reserved",
            761: "sae reserved",
            762: "sae reserved",
            763: "sae reserved",
            764: "sae reserved",
            765: "sae reserved",
            766: "sae reserved",
            767: "sae reserved",
            768: "sae reserved",
            769: "sae reserved",
            77: "sae reserved",
            770: "sae reserved",
            771: "sae reserved",
            772: "sae reserved",
            773: "sae reserved",
            774: "sae reserved",
            775: "sae reserved",
            776: "sae reserved",
            777: "sae reserved",
            778: "sae reserved",
            779: "sae reserved",
            78: "sae reserved",
            780: "sae reserved",
            781: "sae reserved",
            782: "sae reserved",
            783: "sae reserved",
            784: "sae reserved",
            785: "sae reserved",
            786: "sae reserved",
            787: "sae reserved",
            788: "sae reserved",
            789: "sae reserved",
            79: "sae reserved",
            790: "sae reserved",
            791: "sae reserved",
            792: "sae reserved",
            793: "sae reserved",
            794: "sae reserved",
            795: "sae reserved",
            796: "sae reserved",
            797: "sae reserved",
            798: "sae reserved",
            799: "sae reserved",
            8: " hz",
            80: "sae reserved",
            800: "sae reserved",
            801: "sae reserved",
            802: "sae reserved",
            803: "sae reserved",
            804: "sae reserved",
            805: "sae reserved",
            806: "sae reserved",
            807: "sae reserved",
            808: "sae reserved",
            809: "sae reserved",
            81: "sae reserved",
            810: "sae reserved",
            811: "sae reserved",
            812: "sae reserved",
            813: "sae reserved",
            814: "sae reserved",
            815: "sae reserved",
            816: "sae reserved",
            817: "sae reserved",
            818: "sae reserved",
            819: "sae reserved",
            82: "sae reserved",
            820: "sae reserved",
            821: "sae reserved",
            822: "sae reserved",
            823: "sae reserved",
            824: "sae reserved",
            825: "sae reserved",
            826: "sae reserved",
            827: "sae reserved",
            828: "sae reserved",
            829: "sae reserved",
            83: "sae reserved",
            830: "sae reserved",
            831: "sae reserved",
            832: "sae reserved",
            833: "sae reserved",
            834: "sae reserved",
            835: "sae reserved",
            836: "sae reserved",
            837: "sae reserved",
            838: "sae reserved",
            839: "sae reserved",
            84: "sae reserved",
            840: "sae reserved",
            841: "sae reserved",
            842: "sae reserved",
            843: "sae reserved",
            844: "sae reserved",
            845: "sae reserved",
            846: "sae reserved",
            847: "sae reserved",
            848: "sae reserved",
            849: "sae reserved",
            85: "sae reserved",
            850: "sae reserved",
            851: "sae reserved",
            852: "sae reserved",
            853: "sae reserved",
            854: "sae reserved",
            855: "sae reserved",
            856: "sae reserved",
            857: "sae reserved",
            858: "sae reserved",
            859: "sae reserved",
            86: "sae reserved",
            860: "sae reserved",
            861: "sae reserved",
            862: "sae reserved",
            863: "sae reserved",
            864: "sae reserved",
            865: "sae reserved",
            866: "sae reserved",
            867: "sae reserved",
            868: "sae reserved",
            869: "sae reserved",
            87: "sae reserved",
            870: "sae reserved",
            871: "sae reserved",
            872: "sae reserved",
            873: "sae reserved",
            874: "sae reserved",
            875: "sae reserved",
            876: "sae reserved",
            877: "sae reserved",
            878: "sae reserved",
            879: "sae reserved",
            88: "sae reserved",
            880: "sae reserved",
            881: "sae reserved",
            882: "sae reserved",
            883: "sae reserved",
            884: "sae reserved",
            885: "sae reserved",
            886: "sae reserved",
            887: "sae reserved",
            888: "sae reserved",
            889: "sae reserved",
            89: "sae reserved",
            890: "sae reserved",
            891: "sae reserved",
            892: "sae reserved",
            893: "sae reserved",
            894: "sae reserved",
            895: "sae reserved",
            896: "sae reserved",
            897: "sae reserved",
            898: "sae reserved",
            899: "sae reserved",
            9: " hz",
            90: "sae reserved",
            900: "sae reserved",
            901: "sae reserved",
            902: "sae reserved",
            903: "sae reserved",
            904: "sae reserved",
            905: "sae reserved",
            906: "sae reserved",
            907: "sae reserved",
            908: "sae reserved",
            909: "sae reserved",
            91: "sae reserved",
            910: "sae reserved",
            911: "sae reserved",
            912: "sae reserved",
            913: "sae reserved",
            914: "sae reserved",
            915: "sae reserved",
            916: "sae reserved",
            917: "sae reserved",
            918: "sae reserved",
            919: "sae reserved",
            92: "sae reserved",
            920: "sae reserved",
            921: "sae reserved",
            922: "sae reserved",
            923: "sae reserved",
            924: "sae reserved",
            925: "sae reserved",
            926: "sae reserved",
            927: "sae reserved",
            928: "sae reserved",
            929: "sae reserved",
            93: "sae reserved",
            930: "sae reserved",
            931: "sae reserved",
            932: "sae reserved",
            933: "sae reserved",
            934: "sae reserved",
            935: "sae reserved",
            936: "sae reserved",
            937: "sae reserved",
            938: "sae reserved",
            939: "sae reserved",
            94: "sae reserved",
            940: "sae reserved",
            941: "sae reserved",
            942: "sae reserved",
            943: "sae reserved",
            944: "sae reserved",
            945: "sae reserved",
            946: "sae reserved",
            947: "sae reserved",
            948: "sae reserved",
            949: "sae reserved",
            95: "sae reserved",
            950: "sae reserved",
            951: "sae reserved",
            952: "sae reserved",
            953: "sae reserved",
            954: "sae reserved",
            955: "sae reserved",
            956: "sae reserved",
            957: "sae reserved",
            958: "sae reserved",
            959: "sae reserved",
            96: "sae reserved",
            960: "sae reserved",
            961: "sae reserved",
            962: "sae reserved",
            963: "sae reserved",
            964: "sae reserved",
            965: "sae reserved",
            966: "sae reserved",
            967: "sae reserved",
            968: "sae reserved",
            969: "sae reserved",
            97: "sae reserved",
            970: "sae reserved",
            971: "sae reserved",
            972: "sae reserved",
            973: "sae reserved",
            974: "sae reserved",
            975: "sae reserved",
            976: "sae reserved",
            977: "sae reserved",
            978: "sae reserved",
            979: "sae reserved",
            98: "sae reserved",
            980: "sae reserved",
            981: "sae reserved",
            982: "sae reserved",
            983: "sae reserved",
            984: "sae reserved",
            985: "sae reserved",
            986: "sae reserved",
            987: "sae reserved",
            988: "sae reserved",
            989: "sae reserved",
            99: "sae reserved",
            990: "sae reserved",
            991: "sae reserved",
            992: "sae reserved",
            993: "sae reserved",
            994: "sae reserved",
            995: "sae reserved",
            996: "sae reserved",
            997: "sae reserved",
            998: "sae reserved",
            999: "sae reserved"
        },
        4082: {
            0: "deactivate",
            1: "activate",
            2: "reserved",
            3: "unavailable"
        },
        4083: {
            0: "off",
            1: "on",
            2: "error",
            3: "unavailable"
        },
        4097: {
            0: "   not active",
            1: "   active",
            2: "   reserved for sae assignment",
            3: "   not available"
        },
        4098: {
            0: "   not active",
            1: "   active",
            2: "   reserved for sae assignment",
            3: "   not available"
        },
        4175: {
            0: " not active",
            1: " active - forced by switch (see spn 3696)",
            2: " active - forced by service tool ",
            3: " reserved for sae assignment",
            4: " reserved for sae assignment",
            5: " reserved for sae assignment",
            6: " reserved for sae assignment",
            7: " not available"
        },
        4176: {
            0: "not blanked",
            1: "blanked",
            2: "error",
            3: "not supported"
        },
        4178: {
            0: "  transmission service indicator is off",
            1: "  transmission service indicator is on continuously",
            2: "  transmission service indicator is flashing",
            3: "  not available"
        },
        4195: {
            0: "temperature control mode",
            1: "position control mode (used for service only)",
            2: "reserved",
            3: "don't care/reserved"
        },
        4198: {
            0: "temperature control mode",
            1: "position control mode (used for service only)",
            2: "reserved",
            3: "don't care/reserved"
        },
        4203: {
            0: "not ok",
            1: "ok",
            2: "error",
            3: "not available"
        },
        4204: {
            0: "not ok",
            1: "ok",
            2: "error",
            3: "not available"
        },
        4205: {
            0: "not ok",
            1: "ok",
            2: "error",
            3: "not available"
        },
        4233: {
            0: "   road speed limiting by retarder is disabled",
            1: "   road speed limiting by retarder is enabled.  the road speed that the retarder will limit will be determined when the switch transitions from 00 to 01",
            2: "   error indicator",
            3: "   not available"
        },
        4234: {
            0: "   road speed is below threshold ",
            1: "   road speed is above threshold and retarder is allowed to be activated",
            2: "   reserved",
            3: "   don't care/take no action"
        },
        4240: {
            0: "open loop - has not yet satisfied conditions to go closed loop",
            1: "closed loop - using oxygen sensor(s) as feedback for fuel control",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "not supported",
            2: "open loop due to driving conditions (e.g., power enrichment, deceleration enleanment)",
            3: "open loop - due to detected system fault ",
            4: "closed loop, but fault with at least one oxygen sensor - may be using single oxygen sensor for fuel control",
            5: "reserved",
            6: "reserved",
            7: "reserved",
            8: "reserved",
            9: "reserved"
        },
        4241: {
            0: "open loop - has not yet satisfied conditions to go closed loop",
            1: "closed loop - using oxygen sensor(s) as feedback for fuel control",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "not supported",
            2: "open loop due to driving conditions (e.g., power enrichment, deceleration enleanment)",
            3: "open loop - due to detected system fault ",
            4: "closed loop, but fault with at least one oxygen sensor - may be using single oxygen sensor for fuel control",
            5: "reserved",
            6: "reserved",
            7: "reserved",
            8: "reserved",
            9: "reserved"
        },
        4242: {
            0: "allow shifts into reverse gear",
            1: "inhibit shifts into reverse gear, and shift transmission to neutral if already in reverse or attempting to shift to reverse",
            2: "reserved ",
            3: "take no action"
        },
        4246: {
            0: "  disable",
            1: "  enable",
            2: "  reserved",
            3: "  take no action"
        },
        4247: {
            0: "  disable",
            1: "  enable",
            2: "  reserved",
            3: "  take no action"
        },
        4248: {
            0: "  disable",
            1: "  enable",
            2: "  reserved",
            3: "  take no action"
        },
        4249: {
            0: "  disable",
            1: "  enable",
            2: "  reserved",
            3: "  take no action"
        },
        4250: {
            0: "  disable",
            1: "  enable",
            2: "  reserved",
            3: "  take no action"
        },
        4251: {
            0: "  disable",
            1: "  enable",
            2: "  reserved",
            3: "  take no action"
        },
        4252: {
            0: "  disable",
            1: "  enable",
            2: "  reserved",
            3: "  take no action"
        },
        4253: {
            0: "  disable",
            1: "  enable",
            2: "  reserved",
            3: "  take no action"
        },
        4255: {
            0: "no specific launch gear requested; use default launch gear",
            1: "launch the vehicle in 1st gear",
            10: "launch the vehicle in reverse 2",
            11: "launch the vehicle in reverse 3",
            12: "launch the vehicle in reverse 4 ",
            13: "reserved",
            14: "error",
            15: "not available",
            2: "launch the vehicle in 2nd gear",
            3: "launch the vehicle in 3rd gear",
            4: "launch the vehicle in 4th gear",
            5: "launch the vehicle in 5th gear",
            6: "launch the vehicle in 6th gear",
            7: "launch the vehicle in 7th gear",
            8: "launch the vehicle in 8th gear",
            9: "launch the vehicle in reverse 1"
        },
        4261: {
            0: "reverse gear shifts are currently allowed",
            1: "reverse gear shifts are currently inhibited",
            2: "error",
            3: "not available"
        },
        4307: {
            0: "not limited",
            1: "operator limited/controlled (request cannot be implemented)",
            2: "limited high (only lower command values result in change)",
            3: "limited low (only high command values result in change)",
            4: "reserved",
            5: "reserved",
            6: "non-recoverable fault",
            7: "not available (parameter not supported)"
        },
        4308: {
            0: "wheel-based speed",
            1: "ground-based speed",
            2: "navigation-based speed",
            3: "'blended' speed",
            4: "'simulated' speed",
            5: "reserved",
            6: "reserved",
            7: "not available"
        },
        4309: {
            0: "reverse",
            1: "forward",
            2: "error indication",
            3: "not available"
        },
        4312: {
            0: "reverse",
            1: "forward",
            2: "reserved",
            3: "don't care, take no action"
        },
        4314: {
            0: "first revision (no suffix)",
            1: "second revision (suffix a)",
            2: "third revision (suffix b)",
            3: "fourth revision (suffix c)",
            4: "reserved",
            5: "reserved",
            6: "reserved",
            7: "not available"
        },
        4315: {
            0: "non-certified laboratory/ self certification",
            1: "eu certified laboratory",
            2: "na certified laboratory",
            3: "reserved",
            4: "reserved",
            5: "reserved",
            6: "reserved",
            7: "not available (not certified)"
        },
        4317: {
            0: "    not certified ",
            1: "    certified"
        },
        4318: {
            0: "    not certified ",
            1: "    certified"
        },
        4319: {
            0: "    not certified ",
            1: "    certified"
        },
        4320: {
            0: "    not certified ",
            1: "    certified"
        },
        4321: {
            0: "    not certified ",
            1: "    certified"
        },
        4322: {
            0: "    not certified ",
            1: "    certified"
        },
        4323: {
            0: "    not certified ",
            1: "    certified"
        },
        4324: {
            0: "    not certified ",
            1: "    certified"
        },
        4325: {
            0: "    not certified ",
            1: "    certified"
        },
        4326: {
            0: "    not certified ",
            1: "    certified"
        },
        4327: {
            0: "    not certified ",
            1: "    certified"
        },
        4328: {
            0: "    not certified ",
            1: "    certified"
        },
        4329: {
            0: "    not certified ",
            1: "    certified"
        },
        4332: {
            0: "    dormant (sleep mode)",
            1: "    preparing dosing readiness (wake up; prepare to operate; wait for start)",
            10: "    service test mode, dosing not allowed",
            11: " reserved for future assignment by sae",
            12: " reserved for future assignment by sae",
            13: " reserved for future assignment by sae",
            14: "    error",
            15: "    not available",
            2: "    normal dosing operation",
            3: "    system error pending",
            4: "    reserved for future assignment by sae",
            5: "    protect mode against heat  (pressure buildup)",
            6: "    protect mode against cold  (defreeze)",
            7: "    shutoff  (wait for afterrun)",
            8: "    diagnosis (afterrun)",
            9: "    service test mode, dosing allowed "
        },
        4338: {
            0: "no request ",
            1: "reduction request stage 1",
            2: "reduction request stage 2",
            3: "reserved for future assignment by sae",
            4: "reserved for future assignment by sae",
            5: "reserved for future assignment by sae",
            6: "error",
            7: "not available"
        },
        4339: {
            0: " open loop control active ",
            1: " closed loop control active ",
            2: " reserved for future assignment by sae ",
            3: " reserved for future assignment by sae ",
            4: " reserved for future assignment by sae ",
            5: " reserved for future assignment by sae ",
            6: " error ",
            7: " not available"
        },
        4340: {
            0: " heater inactive ",
            1: " heater active ",
            2: " error ",
            3: " not available"
        },
        4342: {
            0: " heater inactive ",
            1: " heater active ",
            2: " error ",
            3: " not available"
        },
        4344: {
            0: " heater inactive ",
            1: " heater active ",
            2: " error ",
            3: " not available"
        },
        4346: {
            0: " heater inactive ",
            1: " heater active ",
            2: " error ",
            3: " not available"
        },
        4349: {
            0: " dormant (sleep mode) ",
            1: " preparing dosing readiness (wake up; prepare to operate; wait for start) ",
            10: " service test mode, dosing not allowed",
            11: " reserved for future assignment by sae",
            12: " reserved for future assignment by sae",
            13: " reserved for future assignment by sae",
            14: " error",
            15: " not available",
            2: " normal dosing operation ",
            3: " system error pending ",
            4: " reserved for future assignment by sae ",
            5: " protect mode against heat (pressure buildup) ",
            6: " protect mode against cold (defreeze) ",
            7: " shutoff (wait for afterrun) ",
            8: " diagnosis (afterrun) ",
            9: " service test mode, dosing allowed "
        },
        4352: {
            0: "    error suppression off",
            1: "    error suppression on",
            2: "    reserved",
            3: "    not available"
        },
        4353: {
            0: "   heater off",
            1: "   heater economy mode",
            2: "   heater automatic mode",
            3: "   heater on",
            4: "    reserved",
            5: "    reserved",
            6: "    reserved",
            7: "   not available"
        },
        4354: {
            0: " request for heater to be inactive ",
            1: " request for heater to be active ",
            2: " reserved for future assignment by sae ",
            3: " not available"
        },
        4355: {
            0: " request for heater to be inactive ",
            1: " request for heater to be active ",
            2: " reserved for future assignment by sae ",
            3: " not available"
        },
        4356: {
            0: " request for heater to be inactive ",
            1: " request for heater to be active ",
            2: " reserved for future assignment by sae ",
            3: " not available"
        },
        4357: {
            0: " request for heater to be inactive ",
            1: " request for heater to be active ",
            2: " reserved for future assignment by sae ",
            3: " not available"
        },
        4379: {
            0: "reading is not stable",
            1: "reading is stable",
            2: "error",
            3: "not available"
        },
        4380: {
            0: "power is not in range",
            1: "power is in range",
            2: "error",
            3: "not available"
        },
        4381: {
            0: "heater element is not in range",
            1: "heater element is in range",
            2: "error",
            3: "not available"
        },
        4383: {
            0: "automatic ",
            1: "preheat 2 ",
            2: "preheat 1 ",
            3: "heater off or not available"
        },
        4385: {
            0: "    dormant (sleep mode)",
            1: "    preparing dosing readiness (wake up; prepare to operate; wait for start)",
            10: "    service test mode, dosing not allowed",
            11: " reserved for future assignment by sae",
            12: " reserved for future assignment by sae",
            13: " reserved for future assignment by sae",
            14: "    error",
            15: "    not available",
            2: "    normal dosing operation",
            3: "    system error pending",
            4: "    reserved for future assignment by sae",
            5: "    protect mode against heat (pressure buildup) ",
            6: "    protect mode against cold (defreeze) ",
            7: "    shutoff (wait for afterrun) ",
            8: "    diagnosis (afterrun)",
            9: "    service test mode, dosing allowed "
        },
        4391: {
            0: "no request ",
            1: "reduction request stage 1",
            2: "reduction request stage 2",
            3: "reserved for future assignment by sae",
            4: "reserved for future assignment by sae",
            5: "reserved for future assignment by sae",
            6: "error",
            7: "not available"
        },
        4392: {
            0: " open loop control active ",
            1: " closed loop control active ",
            2: " reserved for future assignment by sae ",
            3: " reserved for future assignment by sae ",
            4: " reserved for future assignment by sae ",
            5: " reserved for future assignment by sae ",
            6: " error ",
            7: " not available"
        },
        4393: {
            0: " heater inactive ",
            1: " heater active ",
            2: " error ",
            3: " not available"
        },
        4395: {
            0: " heater inactive ",
            1: " heater active ",
            2: " error ",
            3: " not available"
        },
        4397: {
            0: " heater inactive ",
            1: " heater active ",
            2: " error ",
            3: " not available"
        },
        4399: {
            0: " heater inactive ",
            1: " heater active ",
            2: " error ",
            3: " not available"
        },
        4402: {
            0: " dormant (sleep mode) ",
            1: " preparing dosing readiness (wake up; prepare to operate; wait for start) ",
            10: " service test mode, dosing not allowed",
            11: " reserved for future assignment by sae",
            12: " reserved for future assignment by sae",
            13: " reserved for future assignment by sae",
            14: " error",
            15: " not available",
            2: " normal dosing operation ",
            3: " system error pending ",
            4: " reserved for future assignment by sae ",
            5: " protect mode against heat (pressure buildup) ",
            6: " protect mode against cold (defreeze) ",
            7: " shutoff (wait for afterrun) ",
            8: " diagnosis (afterrun)",
            9: " service test mode, dosing allowed "
        },
        4405: {
            0: "    error suppression off",
            1: "    error suppression on",
            2: "    reserved",
            3: "    not available"
        },
        4406: {
            0: "   heater off",
            1: "   heater economy mode",
            2: "   heater automatic mode",
            3: "   heater on",
            4: "    reserved",
            5: "    reserved",
            6: "    reserved",
            7: "   not available"
        },
        4407: {
            0: " request for heater to be inactive ",
            1: " request for heater to be active ",
            2: " reserved for future assignment by sae ",
            3: " not available"
        },
        4408: {
            0: " request for heater to be inactive ",
            1: " request for heater to be active ",
            2: " reserved for future assignment by sae ",
            3: " not available"
        },
        4409: {
            0: " request for heater to be inactive ",
            1: " request for heater to be active ",
            2: " reserved for future assignment by sae ",
            3: " not available"
        },
        4410: {
            0: " request for heater to be inactive ",
            1: " request for heater to be active ",
            2: " reserved for future assignment by sae ",
            3: " not available"
        },
        4425: {
            0: "urea concentration too high",
            1: "urea concentration too low",
            13: "not able to determine diesel exhaust fluid property (fluid type unknown)",
            14: "error with diesel exhaust fluid property detection",
            15: "not available",
            2: "fluid is diesel",
            3: "diesel exhaust fluid is proper mixture",
            5: " to 1100 - reserved for sae assignment"
        },
        4445: {
            0: "reading is not stable",
            1: "reading is stable",
            2: "error",
            3: "not available"
        },
        4446: {
            0: "heater element is not in range",
            1: "heater element is in range",
            2: "error",
            3: "not available"
        },
        4447: {
            0: "heater element is not in range",
            1: "heater element is in range",
            2: "error",
            3: "not available"
        },
        4449: {
            0: "automatic ",
            1: "preheat 2 ",
            2: "preheat 1 ",
            3: "heater off or not available"
        },
        4454: {
            0: " ramp retracted",
            1: " ramp extended",
            2: " error",
            3: " not available"
        },
        4455: {
            0: " ramp disabled",
            1: " ramp enabled ",
            2: " error ",
            3: " not available"
        },
        4456: {
            0: " ramp not being moved",
            1: " ramp being moved",
            2: " error",
            3: " not available"
        },
        4457: {
            0: " ramp retracted",
            1: " ramp extended",
            2: " error",
            3: " not available"
        },
        4458: {
            0: " ramp disabled",
            1: " ramp enabled ",
            2: " error ",
            3: " not available"
        },
        4459: {
            0: " ramp not being moved",
            1: " ramp being moved",
            2: " error",
            3: " not available"
        },
        4460: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4461: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4462: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4463: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4464: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4465: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4466: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4467: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4468: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4469: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4470: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4471: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4472: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4473: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4474: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4475: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4476: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4477: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4478: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4479: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4480: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4481: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4482: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4483: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4484: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4485: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4486: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4487: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4488: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4489: {
            0: "off",
            1: "on",
            2: "blinking",
            3: "not available or not installed"
        },
        4491: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4492: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4493: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4495: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4496: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4497: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4499: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4500: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4501: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4502: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4503: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4504: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4505: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4506: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4507: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4508: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4509: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4510: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4511: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4512: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4513: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4514: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4515: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4517: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4518: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4519: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4521: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4522: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4523: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4525: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4526: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4527: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4528: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4529: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4530: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4532: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4533: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4534: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4536: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4537: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4538: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4539: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4540: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4541: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4542: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4543: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4544: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4545: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4546: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4547: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4548: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4549: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4550: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4551: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4552: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4554: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4555: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4556: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4558: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4559: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4560: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4562: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4563: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4564: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4565: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4566: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4567: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4569: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4570: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4571: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4573: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4574: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4575: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4576: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4577: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4578: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4579: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4580: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4581: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4582: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4583: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4584: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4585: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4586: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4587: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4588: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4589: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4591: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4592: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4593: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4595: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4596: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4597: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4599: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4600: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4601: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4602: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4603: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4604: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4606: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4607: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4608: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4610: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4611: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4612: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4613: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4614: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4615: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4616: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4617: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4618: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4619: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4620: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4621: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4622: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4623: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4624: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4625: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4626: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4628: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4629: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4630: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4632: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4633: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4634: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4636: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4637: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4638: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4639: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4640: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4641: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4643: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4644: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4645: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4647: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4648: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4649: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4650: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4651: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4652: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4653: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4654: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4655: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4656: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4657: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4658: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4659: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4660: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4661: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4662: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4663: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4665: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4666: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4667: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4669: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4670: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4671: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4673: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4674: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4675: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4676: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4677: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4678: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4680: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4681: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4682: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4684: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4685: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4686: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4687: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4688: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4689: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4690: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4691: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4692: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4693: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4694: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4695: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4696: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4697: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4698: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4699: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4700: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4702: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4703: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4704: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4706: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4707: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4708: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4710: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4711: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4712: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4713: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4714: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4715: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4717: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4718: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4719: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4721: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4722: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4723: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4724: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4725: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4726: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4727: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4728: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4729: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4730: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4731: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4732: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4733: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4734: {
            0: " button not pressed",
            1: " button pressed",
            2: " error indicator",
            3: " not available"
        },
        4735: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4736: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4737: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4739: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4740: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4741: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4743: {
            0: " not in neutral position",
            1: " in neutral position",
            2: " error indicator",
            3: " not available"
        },
        4744: {
            0: " not on negative side of neutral",
            1: " on negative side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4745: {
            0: " not on positive side of neutral",
            1: " on positive side of neutral",
            2: " error indicator",
            3: " not available"
        },
        4747: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4748: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4749: {
            0: " not in the detent position",
            1: " in the detent position",
            2: " error indicator",
            3: " not available"
        },
        4815: {
            0: "off (cooling flow not needed)",
            1: "on (cooling flow demanded)",
            2: "error",
            3: "not available"
        },
        4816: {
            0: "transition is not in process",
            1: "transition is in process",
            2: "error",
            3: "not available"
        },
        4918: {
            0: "acceleration sensor",
            1: "pressure sensor",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "error - type of sensor cannot be determined (unknown sensor)",
            15: "not available",
            2: "rollrate sensor",
            3: "sonic sensor",
            4: "fiber-optic sensor",
            5: "radar sensor",
            6: "lidar sensor",
            7: "optical sensor",
            8: "reserved",
            9: "reserved"
        },
        4919: {
            0: "acceleration sensor",
            1: "pressure sensor",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "error - type of sensor cannot be determined (unknown sensor)",
            15: "not available",
            2: "rollrate sensor",
            3: "sonic sensor",
            4: "fiber-optic sensor",
            5: "radar sensor",
            6: "lidar sensor",
            7: "optical sensor",
            8: "reserved",
            9: "reserved"
        },
        4920: {
            0: "acceleration sensor",
            1: "pressure sensor",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "error - type of sensor cannot be determined (unknown sensor)",
            15: "not available",
            2: "rollrate sensor",
            3: "sonic sensor",
            4: "fiber-optic sensor",
            5: "radar sensor",
            6: "lidar sensor",
            7: "optical sensor",
            8: "reserved",
            9: "reserved"
        },
        4921: {
            0: "acceleration sensor",
            1: "pressure sensor",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "error - type of sensor cannot be determined (unknown sensor)",
            15: "not available",
            2: "rollrate sensor",
            3: "sonic sensor",
            4: "fiber-optic sensor",
            5: "radar sensor",
            6: "lidar sensor",
            7: "optical sensor",
            8: "reserved",
            9: "reserved"
        },
        4922: {
            0: "acceleration sensor",
            1: "pressure sensor",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "error - type of sensor cannot be determined (unknown sensor)",
            15: "not available",
            2: "rollrate sensor",
            3: "sonic sensor",
            4: "fiber-optic sensor",
            5: "radar sensor",
            6: "lidar sensor",
            7: "optical sensor",
            8: "reserved",
            9: "reserved"
        },
        4923: {
            0: "acceleration sensor",
            1: "pressure sensor",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "error - type of sensor cannot be determined (unknown sensor)",
            15: "not available",
            2: "rollrate sensor",
            3: "sonic sensor",
            4: "fiber-optic sensor",
            5: "radar sensor",
            6: "lidar sensor",
            7: "optical sensor",
            8: "reserved",
            9: "reserved"
        },
        4924: {
            0: "acceleration sensor",
            1: "pressure sensor",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "error - type of sensor cannot be determined (unknown sensor)",
            15: "not available",
            2: "rollrate sensor",
            3: "sonic sensor",
            4: "fiber-optic sensor",
            5: "radar sensor",
            6: "lidar sensor",
            7: "optical sensor",
            8: "reserved",
            9: "reserved"
        },
        4925: {
            0: "acceleration sensor",
            1: "pressure sensor",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "error - type of sensor cannot be determined (unknown sensor)",
            15: "not available",
            2: "rollrate sensor",
            3: "sonic sensor",
            4: "fiber-optic sensor",
            5: "radar sensor",
            6: "lidar sensor",
            7: "optical sensor",
            8: "reserved",
            9: "reserved"
        },
        4926: {
            0: "acceleration sensor",
            1: "pressure sensor",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "error - type of sensor cannot be determined (unknown sensor)",
            15: "not available",
            2: "rollrate sensor",
            3: "sonic sensor",
            4: "fiber-optic sensor",
            5: "radar sensor",
            6: "lidar sensor",
            7: "optical sensor",
            8: "reserved",
            9: "reserved"
        },
        4927: {
            0: "acceleration sensor",
            1: "pressure sensor",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "error - type of sensor cannot be determined (unknown sensor)",
            15: "not available",
            2: "rollrate sensor",
            3: "sonic sensor",
            4: "fiber-optic sensor",
            5: "radar sensor",
            6: "lidar sensor",
            7: "optical sensor",
            8: "reserved",
            9: "reserved"
        },
        4928: {
            0: "acceleration sensor",
            1: "pressure sensor",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "error - type of sensor cannot be determined (unknown sensor)",
            15: "not available",
            2: "rollrate sensor",
            3: "sonic sensor",
            4: "fiber-optic sensor",
            5: "radar sensor",
            6: "lidar sensor",
            7: "optical sensor",
            8: "reserved",
            9: "reserved"
        },
        4929: {
            0: "acceleration sensor",
            1: "pressure sensor",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "error - type of sensor cannot be determined (unknown sensor)",
            15: "not available",
            2: "rollrate sensor",
            3: "sonic sensor",
            4: "fiber-optic sensor",
            5: "radar sensor",
            6: "lidar sensor",
            7: "optical sensor",
            8: "reserved",
            9: "reserved"
        },
        4930: {
            0: "acceleration sensor",
            1: "pressure sensor",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "error - type of sensor cannot be determined (unknown sensor)",
            15: "not available",
            2: "rollrate sensor",
            3: "sonic sensor",
            4: "fiber-optic sensor",
            5: "radar sensor",
            6: "lidar sensor",
            7: "optical sensor",
            8: "reserved",
            9: "reserved"
        },
        4931: {
            0: "acceleration sensor",
            1: "pressure sensor",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "error - type of sensor cannot be determined (unknown sensor)",
            15: "not available",
            2: "rollrate sensor",
            3: "sonic sensor",
            4: "fiber-optic sensor",
            5: "radar sensor",
            6: "lidar sensor",
            7: "optical sensor",
            8: "reserved",
            9: "reserved"
        },
        4932: {
            0: "acceleration sensor",
            1: "pressure sensor",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "error - type of sensor cannot be determined (unknown sensor)",
            15: "not available",
            2: "rollrate sensor",
            3: "sonic sensor",
            4: "fiber-optic sensor",
            5: "radar sensor",
            6: "lidar sensor",
            7: "optical sensor",
            8: "reserved",
            9: "reserved"
        },
        4933: {
            0: "acceleration sensor",
            1: "pressure sensor",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "error - type of sensor cannot be determined (unknown sensor)",
            15: "not available",
            2: "rollrate sensor",
            3: "sonic sensor",
            4: "fiber-optic sensor",
            5: "radar sensor",
            6: "lidar sensor",
            7: "optical sensor",
            8: "reserved",
            9: "reserved"
        },
        4934: {
            0: "acceleration sensor",
            1: "pressure sensor",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "error - type of sensor cannot be determined (unknown sensor)",
            15: "not available",
            2: "rollrate sensor",
            3: "sonic sensor",
            4: "fiber-optic sensor",
            5: "radar sensor",
            6: "lidar sensor",
            7: "optical sensor",
            8: "reserved",
            9: "reserved"
        },
        4952: {
            0: "unlocked",
            1: "locked",
            2: "error - beltlock state cannot be determined",
            3: "not available"
        },
        4953: {
            0: "unlocked",
            1: "locked",
            2: "error - beltlock state cannot be determined",
            3: "not available"
        },
        4954: {
            0: "unlocked",
            1: "locked",
            2: "error - beltlock state cannot be determined",
            3: "not available"
        },
        4955: {
            0: "unlocked",
            1: "locked",
            2: "error - beltlock state cannot be determined",
            3: "not available"
        },
        4956: {
            0: "unlocked",
            1: "locked",
            2: "error - beltlock state cannot be determined",
            3: "not available"
        },
        4957: {
            0: "unlocked",
            1: "locked",
            2: "error - beltlock state cannot be determined",
            3: "not available"
        },
        4958: {
            0: "unlocked",
            1: "locked",
            2: "error - beltlock state cannot be determined",
            3: "not available"
        },
        4959: {
            0: "unlocked",
            1: "locked",
            2: "error - beltlock state cannot be determined",
            3: "not available"
        },
        4960: {
            0: "unlocked",
            1: "locked",
            2: "error - beltlock state cannot be determined",
            3: "not available"
        },
        4961: {
            0: "unlocked",
            1: "locked",
            2: "error - beltlock state cannot be determined",
            3: "not available"
        },
        4962: {
            0: "passenger airbag activated",
            1: "passenger airbag deactivated",
            2: "error - state of deactivation switch cannot be determined",
            3: "not available"
        },
        4963: {
            0: "empty",
            1: "child",
            2: "small adult",
            3: "adult",
            4: "large adult",
            5: "reserved",
            6: "error - classification of occupant cannot be determined",
            7: "not available"
        },
        4964: {
            0: "empty",
            1: "child",
            2: "small adult",
            3: "adult",
            4: "large adult",
            5: "error - classification of occupant cannot be determined",
            7: "not available"
        },
        4965: {
            0: "empty",
            1: "occupied",
            2: "error - classification cannot be determined",
            3: "not available"
        },
        4966: {
            0: "empty",
            1: "occupied",
            2: "error - classification cannot be determined",
            3: "not available"
        },
        4967: {
            0: "empty",
            1: "occupied",
            2: "error - classification cannot be determined",
            3: "not available"
        },
        4968: {
            0: "empty",
            1: "occupied",
            2: "error - classification cannot be determined",
            3: "not available"
        },
        4969: {
            0: "empty",
            1: "occupied",
            2: "error - classification cannot be determined",
            3: "not available"
        },
        4970: {
            0: "empty",
            1: "occupied",
            2: "error - classification cannot be determined",
            3: "not available"
        },
        4971: {
            0: "empty",
            1: "occupied",
            2: "error - classification cannot be determined",
            3: "not available"
        },
        4972: {
            0: "empty",
            1: "occupied",
            2: "error - classification cannot be determined",
            3: "not available"
        },
        4978: {
            0: "on",
            1: "off",
            2: "error",
            3: "not available"
        },
        4979: {
            0: "pitch angle fully functional. data is within sensor specification.",
            1: "pitch angle degraded. data is suspect due to environmental conditions.",
            2: "error",
            3: "not available"
        },
        4980: {
            0: "on",
            1: "off",
            2: "error",
            3: "not available"
        },
        4981: {
            0: "roll angle fully functional. data is within sensor specification.",
            1: "roll angle degraded. data is suspect due to environmental conditions.",
            2: "error",
            3: "not available"
        },
        4986: {
            0: "pitch rate fully functional. data is within sensor specification.",
            1: "pitch rate degraded. data is suspect due to environmental conditions.",
            2: "error",
            3: "not available"
        },
        4987: {
            0: "roll rate fully functional. data is within sensor specification.",
            1: "roll rate degraded. data is suspect due to environmental conditions.",
            2: "error",
            3: "not available"
        },
        4988: {
            0: "yaw rate fully functional. data is within sensor specification.",
            1: "yaw rate degraded. data is suspect due to environmental conditions.",
            2: "error",
            3: "not available"
        },
        4990: {
            0: "idling. the power line or the battery is disconnected from the charger.",
            1: "charging the battery.",
            13: "battery failure. an error condition due to the battery state (high temperature, etc.)",
            14: "charger failure. an error condition due to the charger state.",
            15: "not available.",
            2: "stand-by or maintaining the battery charge.",
            3: " to 12 - reserved"
        },
        4991: {
            0: "disconnected. the power line is disconnected from the charger.",
            1: "connected. the power line is connected to the charger.",
            2: "error",
            3: "not available"
        },
        4994: {
            0: "idling. the power line or the battery is disconnected from the charger.",
            1: "charging the battery.",
            13: "battery failure. an error condition due to the battery state (high temperature, etc.)",
            14: "charger failure. an error condition due to the charger state.",
            15: "not available.",
            2: "stand-by or maintaining the battery charge.",
            3: " to 12 - reserved"
        },
        4995: {
            0: "disconnected. the power line is disconnected from the charger.",
            1: "connected. the power line is connected to the charger.",
            2: "error",
            3: "not available"
        },
        5000: {
            0: "not overheat",
            1: "overheat",
            2: "error",
            3: "not available"
        },
        5001: {
            0: "out of range ",
            1: "in range",
            2: "error",
            3: "not available"
        },
        5002: {
            0: "1",
            1: "2",
            10: "11",
            11: "12",
            12: "13",
            13: "14",
            14: "15",
            15: "16",
            16: "not used",
            17: "not used",
            18: "not used",
            19: "not used",
            2: "3",
            20: "not used",
            21: "not used",
            22: "not used",
            23: "not used",
            24: "not used",
            25: "not used",
            26: "not used",
            27: "not used",
            28: "not used",
            29: "not used",
            3: "4",
            30: "error",
            31: "not available",
            4: "5",
            5: "6",
            6: "7",
            7: "8",
            8: "9",
            9: "10"
        },
        5003: {
            0: "grapple selected",
            1: "magnet selected",
            2: "error",
            3: "not available"
        },
        5004: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        5005: {
            0: "not enabled",
            1: "enabled",
            2: "error",
            3: "not avaialble"
        },
        5006: {
            0: "monitor is off",
            1: "monitor is on",
            2: "error",
            3: "not available"
        },
        5007: {
            0: "duty cycle not exceed",
            1: "duty cycle exceed",
            2: "error",
            3: "not avaiable"
        },
        5010: {
            0: "don't lift",
            1: "lift",
            2: "error",
            3: "not available"
        },
        5011: {
            0: "don't drop",
            1: "drop",
            2: "error",
            3: "not available"
        },
        5012: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        5013: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        5014: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        5015: {
            0: " not requesting maximum power available",
            1: " momentarily requesting maximum power available",
            2: " fault",
            3: " not available"
        },
        5021: {
            0: " disabled",
            1: " supported ",
            2: " reserved",
            3: " don't care"
        },
        5022: {
            0: " no warning",
            1: " collision is imminent",
            2: " error indicator",
            3: " not available"
        },
        5023: {
            0: " driver demand for not using acc distance keeping control",
            1: " driver demand for using acc distance keeping control",
            2: " reserved",
            3: " don't care"
        },
        5057: {
            0: "take cab noise control system off line",
            1: "bring cab noise control system on line",
            2: "reserved",
            3: "don't care/not commanded"
        },
        5058: {
            0: "activate manual tuning, wait for save and exit commands",
            1: "activate automatic tuning, wait for save and exit commands",
            2: "activate automatic tuning state, saving parameters, exit on completion",
            3: "remain in tuning, save current parameters",
            4: "exit tuning, not saving parameters",
            5: "exit tuning, saving parameters",
            6: "reserved",
            7: "don't care, not commanded"
        },
        5059: {
            0: "cab noise control system on-line",
            1: "cab noise control system off-line",
            2: "error indicator",
            3: "not available/not requested"
        },
        5060: {
            0: "manual tuning mode",
            1: "manual tuning mode - command complete",
            10: "automatic tuning mode - saving data",
            11: "reserved ",
            12: "reserved",
            13: "reserved",
            14: "tuning mode - error",
            15: "not available/not tuning/not requested",
            2: "manual tuning mode - saving data",
            3: "reserved",
            4: "reserved ",
            5: "reserved",
            6: "reserved",
            7: "manual tuning denied - requires security verification",
            8: "automatic tuning mode",
            9: "automatic tuning mode - command complete"
        },
        5077: {
            0: "lamp off",
            1: "lamp on",
            2: "reserved",
            3: "not available"
        },
        5078: {
            0: "lamp off",
            1: "lamp on",
            2: "reserved",
            3: "not available"
        },
        5079: {
            0: "lamp off",
            1: "lamp on",
            2: "reserved",
            3: "not available"
        },
        5080: {
            0: "lamp off",
            1: "lamp on",
            2: "reserved",
            3: "not available"
        },
        5081: {
            0: "lamp off",
            1: "lamp on",
            2: "reserved",
            3: "not available"
        },
        5082: {
            0: "lamp off",
            1: "lamp on",
            2: "reserved",
            3: "not available"
        },
        5083: {
            0: "lamp off",
            1: "lamp on",
            2: "reserved",
            3: "not available"
        },
        5084: {
            0: "lamp off",
            1: "lamp on",
            2: "reserved",
            3: "not available"
        },
        5085: {
            0: "lamp off",
            1: "lamp on",
            2: "reserved",
            3: "not available"
        },
        5086: {
            0: "lamp off",
            1: "lamp on",
            2: "reserved",
            3: "not available"
        },
        5087: {
            0: "lamp off",
            1: "lamp on",
            2: "reserved",
            3: "not available"
        },
        5088: {
            0: "lamp off",
            1: "lamp on",
            2: "reserved",
            3: "not available"
        },
        5089: {
            0: "lamp off",
            1: "lamp on",
            2: "reserved",
            3: "not available"
        },
        5090: {
            0: "lamp off",
            1: "lamp on",
            2: "reserved",
            3: "not available"
        },
        5091: {
            0: "lamp off",
            1: "lamp on",
            2: "reserved",
            3: "not available"
        },
        5093: {
            0: "lamp deactivated (off)",
            1: "lamp activated (on)",
            2: "error",
            3: "not available"
        },
        5094: {
            0: "lamp deactivated (off)",
            1: "lamp activated (on)",
            2: "error",
            3: "not available"
        },
        5095: {
            0: "lamp deactivated (off)",
            1: "lamp activated (on)",
            2: "error",
            3: "not available"
        },
        5096: {
            0: "lamp deactivated (off)",
            1: "lamp activated (on)",
            2: "error",
            3: "not available"
        },
        5097: {
            0: "lamp deactivated (off)",
            1: "lamp activated (on)",
            2: "error",
            3: "not available"
        },
        5098: {
            0: "lamp deactivated (off)",
            1: "lamp activated (on)",
            2: "error",
            3: "not available"
        },
        5099: {
            0: "lamp deactivated (off)",
            1: "lamp activated (on)",
            2: "error",
            3: "not available"
        },
        5100: {
            0: "lamp deactivated (off)",
            1: "lamp activated (on)",
            2: "error",
            3: "not available"
        },
        5101: {
            0: "lamp deactivated (off)",
            1: "lamp activated (on)",
            2: "error",
            3: "not available"
        },
        5102: {
            0: "lamp deactivated (off)",
            1: "lamp activated (on)",
            2: "error",
            3: "not available"
        },
        5103: {
            0: "lamp deactivated (off)",
            1: "lamp activated (on)",
            2: "error",
            3: "not available"
        },
        5104: {
            0: "lamp deactivated (off)",
            1: "lamp activated (on)",
            2: "error",
            3: "not available"
        },
        5105: {
            0: "lamp deactivated (off)",
            1: "lamp activated (on)",
            2: "error",
            3: "not available"
        },
        5106: {
            0: "lamp deactivated (off)",
            1: "lamp activated (on)",
            2: "error",
            3: "not available"
        },
        5107: {
            0: "lamp deactivated (off)",
            1: "lamp activated (on)",
            2: "error",
            3: "not available"
        },
        5108: {
            0: "lamp deactivated (off)",
            1: "lamp activated (on)",
            2: "error",
            3: "not available"
        },
        5139: {
            0: "  set implement to field working state",
            1: "  set implement to transport state",
            2: "  set implement to park state",
            3: "  not available   [ed note, should this be \"no change/don't care\""
        },
        5140: {
            0: "  all implements stop operations switch off",
            1: "  all implements stop operations switch on",
            2: "  error indication",
            3: "  not available"
        },
        5141: {
            0: "input off",
            1: "input on",
            2: "error",
            3: "not installed"
        },
        5142: {
            0: "input off",
            1: "input on",
            2: "error",
            3: "not installed"
        },
        5143: {
            0: "automatic",
            1: "reserved",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "not available",
            2: "reserved",
            3: "reserved",
            4: "manual disconnect via j1939 request",
            5: "manual connect via j1939 request",
            6: "reserved",
            7: "reserved",
            8: "manual disconnect via hardwired input",
            9: "manual connect via hardwired input"
        },
        5144: {
            0: "output off or disconnected",
            1: "output on or connected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "output fault",
            15: "not available or not installed",
            2: "disconnect alarm expired, output off or disconnected",
            3: "disconnect pending, alarm active",
            4: "connect pending, alarm active",
            5: "reserved",
            6: "reserved",
            7: "reserved",
            8: "reserved",
            9: "reserved"
        },
        5145: {
            0: "output off or disconnected",
            1: "output on or connected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "output fault",
            15: "not available or not installed",
            2: "disconnect alarm expired, output off or disconnected",
            3: "disconnect pending, alarm active",
            4: "connect pending, alarm active",
            5: "reserved",
            6: "reserved",
            7: "reserved",
            8: "reserved",
            9: "reserved"
        },
        5146: {
            0: "output off or disconnected",
            1: "output on or connected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "output fault",
            15: "not available or not installed",
            2: "disconnect alarm expired, output off or disconnected",
            3: "disconnect pending, alarm active",
            4: "connect pending, alarm active",
            5: "reserved",
            6: "reserved",
            7: "reserved",
            8: "reserved",
            9: "reserved"
        },
        5147: {
            0: "output off or disconnected",
            1: "output on or connected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "output fault",
            15: "not available or not installed",
            2: "disconnect alarm expired, output off or disconnected",
            3: "disconnect pending, alarm active",
            4: "connect pending, alarm active",
            5: "reserved",
            6: "reserved",
            7: "reserved",
            8: "reserved",
            9: "reserved"
        },
        5149: {
            0: "automatic",
            1: "reserved",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "no change",
            2: "reserved",
            3: "reserved",
            4: "manual disconnect",
            5: "manual connect",
            6: "reserved",
            7: "reserved",
            8: "reserved",
            9: "reserved"
        },
        5245: {
            0: "off -  indicates adequate def level",
            1: "on solid -  indicates low def level",
            2: "reserved for sae assignment",
            3: "reserved for sae assignment",
            4: "on fast blink (1 hz) indicates the def level is lower than the level indicated by the solid illumination (state 001)",
            5: "reserved for sae assignment",
            6: "reserved for sae assignment",
            7: "not available"
        },
        5246: {
            0: "driver warning, low-level inducement, and severe inducement non-active",
            1: "inducement level 1 - epa defined scr inducement - def warning  ...................... fmi 15",
            2: "inducement level 2 - def warning, second level (optional) .................................. fmi 15",
            3: "inducement level 3 - epa defined scr inducement - engine derate ..................... fmi 16",
            4: "inducement level 4 ... severe inducement pre-trigger (optional) ---.................. fmi 16",
            5: "inducement level 5 ... epa defined scr inducement - severe inducement --......  fmi 0",
            6: "temporary override of inducement  -  the scr inducement has been temporarily interrupted.",
            7: "not available / not supported"
        },
        527: {
            0: "off/disabled",
            1: "hold",
            2: "accelerate",
            3: "decelerate",
            4: "resume",
            5: "set",
            6: "accelerator override",
            7: "not available"
        },
        5274: {
            0: " no request ",
            1: " request prohibit automatic air suspension control ",
            2: " error indicator ",
            3: " not available"
        },
        5275: {
            0: "parking brake actuator not fully activated",
            1: "parking brake actuator fully activated",
            2: "error",
            3: "not available"
        },
        5293: {
            0: "disallow level control during braking (normal operation)",
            1: "allow level control during braking",
            2: "reserved",
            3: "don-t' care/take no action"
        },
        5294: {
            0: "deactivated",
            1: "activated",
            2: "reserved",
            3: "don-t care/take no action"
        },
        5295: {
            0: "deactivate",
            1: "activate",
            2: "reserved",
            3: "don-t care/take no action"
        },
        5296: {
            0: "inactive",
            1: "active",
            2: "reserved",
            3: "don-t' care/take no action"
        },
        5323: {
            0: "     open loop",
            1: "     closed loop",
            2: "     sae reserved",
            3: "     not available"
        },
        5324: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5325: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5326: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5327: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5328: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5329: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5330: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5331: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5332: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5333: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5334: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5335: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5336: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5337: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5338: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5339: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5340: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5341: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5342: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5343: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        5344: {
            0: "transmission warning indicator is off",
            1: "transmission warning indicator is on continuously",
            2: "transmission warning indicator is flashing",
            3: "not available"
        },
        5345: {
            0: "transmission overheat indicator is off",
            1: "transmission overheat indicator is on continuously",
            2: "transmission overheat indicator is flashing",
            3: "not available"
        },
        5346: {
            0: "driveline retarder overheat indicator is off",
            1: "driveline retarder overheat indicator is on continuously",
            2: "driveline retarder overheat indicator is flashing",
            3: "not available"
        },
        5350: {
            0: "lateral acceleration is fully functional.  data is within sensor specification",
            1: "lateral acceleration is degraded.  data is suspect due to enviromental conditions",
            2: "error",
            3: "not available"
        },
        5351: {
            0: "longitudinal acceleration is fully functional.  data is within sensor specification",
            1: "longitudinal acceleration is degraded.  data is suspect due to enviromental conditions",
            2: "error",
            3: "not available"
        },
        5352: {
            0: "vertical acceleration is fully functional.  data is within sensor specification",
            1: "verticalacceleration is degraded.  data is suspect due to enviromental conditions",
            2: "error",
            3: "not available"
        },
        5353: {
            1: " ms rate not supported ",
            10: " ms rate not supported ",
            11: " ms rate not supported ",
            12: " ms rate not supported ",
            13: " ms rate not supported ",
            14: " ms rate not supported ",
            15: " ms rate not supported ",
            16: " ms rate not supported ",
            17: " ms rate not supported ",
            18: " ms rate not supported ",
            19: " ms rate not supported ",
            2: " ms rate not supported ",
            20: " ms rate not supported ",
            3: " ms rate not supported ",
            4: " ms rate not supported ",
            5: " ms rate not supported ",
            6: " ms rate not supported ",
            7: " ms rate not supported ",
            8: " ms rate not supported ",
            9: " ms rate not supported "
        },
        5368: {
            0: "high most severe",
            1: "high least severe",
            2: "in range",
            3: "low least severe",
            4: "low most severe",
            5: "not defined",
            6: "error",
            7: "not available"
        },
        5372: {
            0: "high most severe",
            1: "high least severe",
            2: "in range",
            3: "low least severe",
            4: "low most severe",
            5: "not defined",
            6: "error",
            7: "not available"
        },
        5376: {
            0: "high most severe",
            1: "high least severe",
            2: "in range",
            3: "low least severe",
            4: "low most severe",
            5: "not defined",
            6: "error",
            7: "not available"
        },
        5379: {
            0: "high most severe",
            1: "high least severe",
            2: "in range",
            3: "low least severe",
            4: "low most severe",
            5: "not defined",
            6: "error",
            7: "not available"
        },
        5381: {
            0: "high most severe",
            1: "high least severe",
            2: "in range",
            3: "low least severe",
            4: "low most severe",
            5: "not defined",
            6: "error",
            7: "not available"
        },
        5383: {
            0: "high most severe",
            1: "high least severe",
            2: "in range",
            3: "low least severe",
            4: "low most severe",
            5: "not defined",
            6: "error",
            7: "not available"
        },
        5385: {
            0: "high most severe",
            1: "high least severe",
            2: "in range",
            3: "low least severe",
            4: "low most severe",
            5: "not defined",
            6: "error",
            7: "not available"
        },
        5391: {
            0: "high most severe",
            1: "high least severe",
            2: "in range",
            3: "low least severe",
            4: "low most severe",
            5: "not defined",
            6: "error",
            7: "not available"
        },
        5399: {
            0: "dpf thermal management is not active",
            1: "dpf thermal management is active",
            2: "reserved",
            3: "don't care"
        },
        5400: {
            0: "scr thermal management is not active",
            1: "scr thermal management is active",
            2: "reserved",
            3: "don't care"
        },
        5402: {
            0: "off, disable lift relay request ",
            1: "on, enable lift relay request",
            2: "reserved",
            3: "take no action"
        },
        5403: {
            0: "off, disable drop relay request",
            1: "on, enable drop relay request",
            2: "reserved",
            3: "take no action"
        },
        5404: {
            0: "no",
            1: "yes",
            2: "error",
            3: "not available"
        },
        5405: {
            0: "do not set reference elevation",
            1: "set reference elevation",
            2: "reserved",
            3: "don't care / take no action"
        },
        5406: {
            0: "do not set reference elevation",
            1: "set reference elevation",
            2: "reserved",
            3: "don't care / take no action"
        },
        5407: {
            0: "manual",
            1: "auto ",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "error",
            15: "not available",
            2: "inactive auto",
            3: "reserved",
            4: "reserved",
            5: "reserved",
            6: "reserved",
            7: "reserved",
            8: "reserved",
            9: "reserved"
        },
        5408: {
            0: "manual",
            1: "auto ",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "error",
            15: "not available",
            2: "inactive auto",
            3: "reserved",
            4: "reserved",
            5: "reserved",
            6: "reserved",
            7: "reserved",
            8: "reserved",
            9: "reserved"
        },
        5409: {
            0: "disabled",
            1: "enabled",
            2: "error",
            3: "not available / not installed"
        },
        5416: {
            0: "lamp deactived (off)",
            1: "lamp actived (on)",
            2: "error",
            3: "not available"
        },
        5423: {
            0: " off",
            1: " on",
            2: " reserved for sae assignment",
            3: " not available"
        },
        5424: {
            0: " off",
            1: " on",
            2: " reserved for sae assignment",
            3: " not available"
        },
        5426: {
            0: " off",
            1: " on",
            2: " reserved for sae assignment",
            3: " not available"
        },
        5427: {
            0: " off",
            1: " on",
            2: " reserved for sae assignment",
            3: " not available"
        },
        5432: {
            0: "no memory level ",
            1: "memory level 1 selected ",
            10: "memory level  2 stored",
            11: "memory level  3 stored",
            12: "memory level  4 stored",
            13: "memory level  5 stored",
            14: "error indicator",
            15: "not available",
            2: "memory level 2 selected",
            3: "memory level 3 selected",
            4: "memory level 4 selected",
            5: "memory level 5 selected",
            6: "reserved",
            7: "reserved",
            8: "reserved",
            9: "memory level  1 stored"
        },
        5433: {
            0: "no memory level request",
            1: "memory level 1 request",
            10: "store memory level  2",
            11: "store memory level  3",
            12: "store memory level  4",
            13: "store memory level  5",
            14: "reserved",
            15: "don't care",
            2: "memory level 2 request",
            3: "memory level 3 request",
            4: "memory level 4 request",
            5: "memory level 5 request",
            6: "reserved",
            7: "reserved",
            8: "reserved",
            9: "store memory level  1"
        },
        5435: {
            0: "  pump operational",
            1: "  pump error",
            2: "  reserved for sae assignment",
            3: " not available"
        },
        5438: {
            0: "  pump operational",
            1: "  pump error",
            2: "  reserved for sae assignment",
            3: " not available"
        },
        5445: {
            0: "normal",
            1: "alarm (fully operational but needs service)",
            10: "   reserved for future assignment",
            11: "   reserved for future assignment",
            12: "   reserved for future assignment",
            13: "   reserved for future assignment",
            14: "error",
            15: "not available",
            2: "alarm high severity (functional but transient performance may be reduced)",
            3: "derate active (torque output reduced due to environmental conditions)",
            4: "controlled shutdown active (driving to the default position - usually this means closed)",
            5: "uncontrolled shutdown active (actuator current is off so it is limp)",
            6: "   reserved for future assignment",
            7: "   reserved for future assignment",
            8: "   reserved for future assignment",
            9: "   reserved for future assignment"
        },
        5446: {
            0: "normal",
            1: "alarm (fully operational but needs service)",
            10: "   reserved for future assignment",
            11: "   reserved for future assignment",
            12: "   reserved for future assignment",
            13: "   reserved for future assignment",
            14: "error",
            2: "alarm high severity (functional but transient performance may be reduced)",
            3: "derate active (torque output reduced due to environmental conditions)",
            4: "controlled shutdown active (driving to the default position - usually this means closed)",
            5: "uncontrolled shutdown active (actuator current is off so it is limp)",
            6: "   reserved for future assignment",
            7: "   reserved for future assignment",
            8: "   reserved for future assignment",
            9: "   reserved for future assignment"
        },
        5447: {
            0: "normal",
            1: "alarm (fully operational but needs service)",
            10: "   reserved for future assignment",
            11: "   reserved for future assignment",
            12: "   reserved for future assignment",
            13: "   reserved for future assignment",
            14: "error",
            2: "alarm high severity (functional but transient performance may be reduced)",
            3: "derate active (torque output reduced due to environmental conditions)",
            4: "controlled shutdown active (driving to the default position - usually this means closed)",
            5: "uncontrolled shutdown active (actuator current is off so it is limp)",
            6: "   reserved for future assignment",
            7: "   reserved for future assignment",
            8: "   reserved for future assignment",
            9: "   reserved for future assignment"
        },
        5448: {
            0: "normal",
            1: "alarm (fully operational but needs service)",
            10: "   reserved for future assignment",
            11: "   reserved for future assignment",
            12: "   reserved for future assignment",
            13: "   reserved for future assignment",
            14: "error",
            2: "alarm high severity (functional but transient performance may be reduced)",
            3: "derate active (torque output reduced due to environmental conditions)",
            4: "controlled shutdown active (driving to the default position - usually this means closed)",
            5: "uncontrolled shutdown active (actuator current is off so it is limp)",
            6: "   reserved for future assignment",
            7: "   reserved for future assignment",
            8: "   reserved for future assignment",
            9: "   reserved for future assignment"
        },
        5449: {
            0: "normal",
            1: "alarm (fully operational but needs service)",
            10: "   reserved for future assignment",
            11: "   reserved for future assignment",
            12: "   reserved for future assignment",
            13: "   reserved for future assignment",
            14: "error",
            2: "alarm high severity (functional but transient performance may be reduced)",
            3: "derate active (torque output reduced due to environmental conditions)",
            4: "controlled shutdown active (driving to the default position - usually this means closed)",
            5: "uncontrolled shutdown active (actuator current is off so it is limp)",
            6: "   reserved for future assignment",
            7: "   reserved for future assignment",
            8: "   reserved for future assignment",
            9: "   reserved for future assignment"
        },
        5450: {
            0: "normal",
            1: "alarm (fully operational but needs service)",
            10: "   reserved for future assignment",
            11: "   reserved for future assignment",
            12: "   reserved for future assignment",
            13: "   reserved for future assignment",
            14: "error",
            2: "alarm high severity (functional but transient performance may be reduced)",
            3: "derate active (torque output reduced due to environmental conditions)",
            4: "controlled shutdown active (driving to the default position - usually this means closed)",
            5: "uncontrolled shutdown active (actuator current is off so it is limp)",
            6: "   reserved for future assignment",
            7: "   reserved for future assignment",
            8: "   reserved for future assignment",
            9: "   reserved for future assignment"
        },
        5451: {
            0: "normal",
            1: "alarm (fully operational but needs service)",
            10: "   reserved for future assignment",
            11: "   reserved for future assignment",
            12: "   reserved for future assignment",
            13: "   reserved for future assignment",
            14: "error",
            2: "alarm high severity (functional but transient performance may be reduced)",
            3: "derate active (torque output reduced due to environmental conditions)",
            4: "controlled shutdown active (driving to the default position - usually this means closed)",
            5: "uncontrolled shutdown active (actuator current is off so it is limp)",
            6: "   reserved for future assignment",
            7: "   reserved for future assignment",
            8: "   reserved for future assignment",
            9: "   reserved for future assignment"
        },
        5452: {
            0: "normal",
            1: "alarm (fully operational but needs service)",
            10: "   reserved for future assignment",
            11: "   reserved for future assignment",
            12: "   reserved for future assignment",
            13: "   reserved for future assignment",
            14: "error",
            2: "alarm high severity (functional but transient performance may be reduced)",
            3: "derate active (torque output reduced due to environmental conditions)",
            4: "controlled shutdown active (driving to the default position - usually this means closed)",
            5: "uncontrolled shutdown active (actuator current is off so it is limp)",
            6: "   reserved for future assignment",
            7: "   reserved for future assignment",
            8: "   reserved for future assignment",
            9: "   reserved for future assignment"
        },
        5457: {
            0: " open loop",
            1: " closed loop",
            2: " sae reserved",
            3: " not available"
        },
        5459: {
            0: "  inactive",
            1: "  active",
            2: "  error indicator",
            3: "  not available"
        },
        5460: {
            0: "  inactive",
            1: "  active",
            2: "  error indicator",
            3: "  not available"
        },
        5461: {
            0: "  inactive",
            1: "  active",
            2: "  error indicator",
            3: "  not available"
        },
        5462: {
            0: "  inactive",
            1: "  active",
            2: "  error indicator",
            3: "  not available"
        },
        5465: {
            0: "  open loop ",
            1: "  closed loop ",
            2: "  sae reserved",
            3: "  not available"
        },
        5469: {
            0: "lamp off",
            1: "lamp on",
            2: "flash (1 hz)",
            3: "not available"
        },
        5470: {
            0: "lamp deactivated (off)",
            1: "lamp activated (on)",
            2: "error",
            3: "not available"
        },
        5488: {
            0: " heater inactive ",
            1: " heater active ",
            2: " error ",
            3: " not available"
        },
        5490: {
            0: " request for heater to be inactive ",
            1: " request for heater to be active ",
            2: " reserved for future assignment by sae ",
            3: " not available"
        },
        5492: {
            0: "off",
            1: "on",
            2: "reserved",
            3: "don't care/take no action"
        },
        5493: {
            0: "off",
            1: "on",
            2: "reserved",
            3: "don't care/take no action"
        },
        5494: {
            0: "off",
            1: "on",
            2: "reserved",
            3: "don't care/take no action"
        },
        5499: {
            0: " off",
            1: " on",
            2: " reserved for sae assignment",
            3: " not available"
        },
        5500: {
            0: " off",
            1: " on",
            2: " reserved for sae assignment",
            3: " not available"
        },
        5504: {
            0: " purging not enabled",
            1: " purging enabled - less urgent",
            2: " purging enabled - urgent",
            3: " not available"
        },
        5506: {
            0: " hc doser disabled",
            1: " hc doser active",
            2: " sae reserved",
            3: " hc doser enabled, waiting for regeneration",
            4: " sae reserved",
            5: " sae reserved",
            6: " error",
            7: " not available"
        },
        5507: {
            0: " injecting not active",
            1: " injecting active",
            2: " error",
            3: " not available"
        },
        5508: {
            0: " system test has executed and passed or system test has not yet executed",
            1: " internal system test is in process",
            2: "  sae reserved",
            3: "  sae reserved",
            4: "  sae reserved",
            5: "  sae reserved",
            6: " error  --  system test has failed",
            7: " not available"
        },
        5509: {
            0: "   purging not required",
            1: "   purging required - less urgent",
            2: "   purging required - urgent",
            3: "   not available"
        },
        5510: {
            0: "not locked",
            1: "locked",
            2: "reserved",
            3: "no action"
        },
        5511: {
            0: "cycle mode # 1 (lowest lubrication frequency)",
            1: "cycle mode # 2",
            2: "cycle mode # 3 (highest lubrication frequency)",
            3: " to 110 - reserved ",
            7: "no action"
        },
        5512: {
            0: "automatic mode",
            1: "manual service mode",
            2: "test mode # 1",
            3: "test mode # 2",
            4: "test mode # 3",
            5: "reserved",
            6: "reserved",
            7: "take no action"
        },
        5513: {
            0: "no action (normal pump operation)",
            1: "reset pump operation  ",
            2: "reserved",
            3: "take no action"
        },
        5514: {
            0: "pause",
            1: "enable",
            2: "reserved ",
            3: "take no action     "
        },
        5515: {
            0: "not locked",
            1: "locked",
            2: "error",
            3: "not available"
        },
        5516: {
            0: "cycle mode # 1 (lowest lubrication frequency)",
            1: "cycle mode # 2",
            2: "cycle mode # 3 (highest lubrication frequency)",
            3: " to 101 - reserved ",
            6: "error",
            7: "not available"
        },
        5517: {
            0: "automatic mode",
            1: "manual service mode",
            2: "test mode # 1",
            3: "test mode # 2",
            4: "test mode # 3",
            5: "reserved",
            6: "error",
            7: "not available"
        },
        5518: {
            0: "disabled",
            1: "enabled",
            2: "error",
            3: "not available"
        },
        5519: {
            0: "reservoir not low",
            1: "reservoir low",
            2: "error ",
            3: "not available or not installed"
        },
        5520: {
            0: "paused ",
            1: "enabled",
            2: "error ",
            3: "not available or not installed"
        },
        5549: {
            0: "  off",
            1: "  on",
            2: "  reserved",
            3: "  don't care/take no action"
        },
        5550: {
            0: "  off",
            1: "  on",
            2: "  error",
            3: "  not available"
        },
        5551: {
            0: "  off, disable generator",
            1: "  on, enable generator",
            2: "  reserved",
            3: "  take no action"
        },
        5552: {
            0: "  disable ",
            1: "  enable",
            2: "  reserved ",
            3: "  don't care/take no action"
        },
        5553: {
            0: "   forward",
            1: "   reverse",
            2: "   reserved",
            3: "   don't care/take no action (leave function as is)"
        },
        5555: {
            0: "   disable",
            1: "   enable",
            2: "   reserved",
            3: "   don't care/take no action"
        },
        5556: {
            0: "   disabled",
            1: "   enabled",
            2: "   error",
            3: "   not available/not installed"
        },
        5557: {
            0: "   forward",
            1: "   reverse",
            2: "   error",
            3: "   not available/not installed"
        },
        5558: {
            0: "   at velocity (fan ok)",
            1: "   velocity error  (unable to achieve commanded speed)",
            10: "   reserved",
            11: "   reserved",
            12: "   reserved",
            13: "   reserved",
            14: "   error",
            15: "   not available",
            2: "   fan spin up",
            3: "   fan spin down",
            4: "   fan stall",
            5: "   reserved",
            6: "   reserved",
            7: "   reserved",
            8: "   reserved",
            9: "   reserved"
        },
        5559: {
            0: "   high most severe ",
            1: "   high least severe ",
            2: "   in range ",
            3: "   low least severe ",
            4: "   low most severe ",
            5: "   not defined ",
            6: "   error ",
            7: "   not available"
        },
        5560: {
            0: "   normal = \"ok\"",
            1: "   alarm = fully operational but needs service",
            10: "   reserved for future assignment = not used",
            11: "   reserved for future assignment = not used",
            12: "   reserved for future assignment = not used",
            13: "   reserved for future assignment = not used",
            14: "   error",
            15: "   not available",
            2: "   alarm high severity = functional but transient performance may be reduced",
            3: "   derate active = torque output reduced due to environmental conditions",
            4: "   controlled shutdown active = driving to the default position - usually this means closed",
            5: "   uncontrolled shutdown active = actuator current is off so it is limp",
            6: "   reserved for future assignment = not used",
            7: "   reserved for future assignment = not used",
            8: "   reserved for future assignment = not used",
            9: "   reserved for future assignment = not used"
        },
        5565: {
            0: "disable engine protection shutdown override due to low coolant level",
            1: "enable engine protection shutdown override due to low coolant level",
            2: "reserved",
            3: "don't care/take no action"
        },
        5566: {
            0: "disabled - calibration does not allow engine protection due to low coolant level or the override is currently active",
            1: "enabled - calibration allows engine protection due to low coolant level and the override is currently not active",
            2: "reserved",
            3: "not available"
        },
        558: {
            0: "accelerator pedal 1 not in low idle condition",
            1: "accelerator pedal 1 in low idle condition",
            2: "error",
            3: "not available"
        },
        5583: {
            0: "sensor busy",
            1: "sensor ok",
            2: "sensor defect",
            3: "sensor reboots",
            4: "angle data invalid",
            5: "reserved",
            6: "error",
            7: "not available"
        },
        559: {
            0: "kickdown passive",
            1: "kickdown active",
            2: "error",
            3: "not available"
        },
        560: {
            0: "driveline disengaged",
            1: "driveline engaged",
            2: "error",
            3: "not available"
        },
        5603: {
            0: "cruise control is allowed",
            1: "cruise control is not allowed",
            2: "reserved",
            3: "don't care/take no action"
        },
        5604: {
            0: "cruise control resume not requested",
            1: "cruise control resume requested",
            2: "reserved",
            3: "don't care/take no action"
        },
        5605: {
            0: "cruise control is allowed",
            1: "cruise control is not allowed",
            2: "reserved",
            3: "don't care/take no action"
        },
        5606: {
            0: "off -- cruise control system is not configured to accept commands from an adaptive cruise controller",
            1: "on -- cruise control system is configured to accept commands from an adaptive cruise controller.",
            2: "error condition -- prevents system from responding to adaptive cruise controller commands even though it is configured.",
            3: "not available/not supported"
        },
        5607: {
            0: "no cruise control system command",
            1: "cruise control has been disabled by cruise control disable command (spn 5603)",
            2: "cruise control  has been disabled by cruise control pause command (spn 5605)",
            3: "cruise control has been re-activated by cruise control resume command (spn 5604) and cruise control states (spn 527) is equal to resume (100).  cruise control system command state will be equal to 011 as long as cruise control states is equal to resume.  cruise control system command state will change to the appropriate value when cruise control states is no longer equal to resume.",
            4: "cruise control device has received a cruise control resume command (spn 5604), but there is no previous set speed.",
            5: "- sae reserved",
            6: "- sae reserved",
            7: "not supported"
        },
        561: {
            0: "asr engine control passive but installed",
            1: "asr engine control active",
            2: "reserved",
            3: "not available"
        },
        562: {
            0: "asr brake control passive but installed",
            1: "asr brake control active",
            2: "reserved",
            3: "not available"
        },
        5624: {
            0: "vdc passive, but installed",
            1: "vdc active",
            2: "reserved",
            3: "not availble or not installed"
        },
        5627: {
            0: "high most severe",
            1: "high least severe",
            2: "in range",
            3: "low least severe",
            4: "low most severe",
            5: "not defined",
            6: "error",
            7: "not available"
        },
        5628: {
            0: "normal",
            1: "alarm (fully operational but needs service)",
            10: " reserved for future assignment",
            11: " reserved for future assignment",
            12: " reserved for future assignment",
            13: " reserved for future assignment",
            14: "error",
            15: "not available",
            2: "alarm high severity (functional but transient performance may be reduced)",
            3: "derate active (torque output reduced due to environmental conditions)",
            4: "controlled shutdown active (driving to the default position - usually this means closed)",
            5: "uncontrolled shutdown active (actuator current is off so it is limp)",
            6: " reserved for future assignment",
            7: " reserved for future assignment",
            8: " reserved for future assignment",
            9: " reserved for future assignment"
        },
        5629: {
            0: " not inhibited",
            1: " inhibited",
            2: " reserved for sae assignment",
            3: " not available"
        },
        563: {
            0: "abs passive but installed",
            1: "abs active",
            2: "reserved",
            3: "not available"
        },
        5630: {
            0: "park brake apply not requested",
            1: "park brake apply requested",
            2: "sae reserved  ",
            3: "don't care/take no action"
        },
        564: {
            0: " differential lock disengaged",
            1: " differential lock engaged",
            2: " error",
            3: " not available"
        },
        565: {
            0: " differential lock disengaged",
            1: " differential lock engaged",
            2: " error",
            3: " not available"
        },
        5657: {
            0: "security not satisfied. different sa for adopt pending than set pending",
            1: "item(s) not allowed to change.  set qualifier flag of disallowed items.",
            10: "reserved ",
            100: "reserved ",
            101: "reserved ",
            102: "reserved ",
            103: "reserved ",
            104: "reserved ",
            105: "reserved ",
            106: "reserved ",
            107: "reserved ",
            108: "reserved ",
            109: "reserved ",
            11: "reserved ",
            110: "reserved ",
            111: "reserved ",
            112: "reserved ",
            113: "reserved ",
            114: "reserved ",
            115: "reserved ",
            116: "reserved ",
            117: "reserved ",
            118: "reserved ",
            119: "reserved ",
            12: "reserved ",
            120: "reserved ",
            121: "reserved ",
            122: "reserved ",
            123: "reserved ",
            124: "reserved ",
            125: "reserved ",
            126: "reserved ",
            127: "reserved ",
            128: "reserved ",
            129: "reserved ",
            13: "reserved ",
            130: "reserved ",
            131: "reserved ",
            132: "reserved ",
            133: "reserved ",
            134: "reserved ",
            135: "reserved ",
            136: "reserved ",
            137: "reserved ",
            138: "reserved ",
            139: "reserved ",
            14: "reserved ",
            140: "reserved ",
            141: "reserved ",
            142: "reserved ",
            143: "reserved ",
            144: "reserved ",
            145: "reserved ",
            146: "reserved ",
            147: "reserved ",
            148: "reserved ",
            149: "reserved ",
            15: "reserved ",
            150: "reserved ",
            151: "reserved ",
            152: "reserved ",
            153: "reserved ",
            154: "reserved ",
            155: "reserved ",
            156: "reserved ",
            157: "reserved ",
            158: "reserved ",
            159: "reserved ",
            16: "reserved ",
            160: "reserved ",
            161: "reserved ",
            162: "reserved ",
            163: "reserved ",
            164: "reserved ",
            165: "reserved ",
            166: "reserved ",
            167: "reserved ",
            168: "reserved ",
            169: "reserved ",
            17: "reserved ",
            170: "reserved ",
            171: "reserved ",
            172: "reserved ",
            173: "reserved ",
            174: "reserved ",
            175: "reserved ",
            176: "reserved ",
            177: "reserved ",
            178: "reserved ",
            179: "reserved ",
            18: "reserved ",
            180: "reserved ",
            181: "reserved ",
            182: "reserved ",
            183: "reserved ",
            184: "reserved ",
            185: "reserved ",
            186: "reserved ",
            187: "reserved ",
            188: "reserved ",
            189: "reserved ",
            19: "reserved ",
            190: "reserved ",
            191: "reserved ",
            192: "reserved ",
            193: "reserved ",
            194: "reserved ",
            195: "reserved ",
            196: "reserved ",
            197: "reserved ",
            198: "reserved ",
            199: "reserved ",
            2: "item conflict. cannot perform function assigned, cannot perform as arbitrary address capable, etc. qualifier flags of disallowed items are set.",
            20: "reserved ",
            200: "reserved ",
            201: "reserved ",
            202: "reserved ",
            203: "reserved ",
            204: "reserved ",
            205: "reserved ",
            206: "reserved ",
            207: "reserved ",
            208: "reserved ",
            209: "reserved ",
            21: "reserved ",
            210: "reserved ",
            211: "reserved ",
            212: "reserved ",
            213: "reserved ",
            214: "reserved ",
            215: "reserved ",
            216: "reserved ",
            217: "reserved ",
            218: "reserved ",
            219: "reserved ",
            22: "reserved ",
            220: "reserved ",
            221: "reserved ",
            222: "reserved ",
            223: "reserved ",
            224: "reserved ",
            225: "reserved ",
            226: "reserved ",
            227: "reserved ",
            228: "reserved ",
            229: "reserved ",
            23: "reserved ",
            230: "reserved ",
            231: "reserved ",
            232: "reserved ",
            233: "reserved ",
            234: "reserved ",
            235: "reserved ",
            236: "reserved ",
            237: "reserved ",
            238: "reserved ",
            239: "reserved ",
            24: "reserved ",
            240: "reserved ",
            241: "reserved ",
            242: "reserved ",
            243: "reserved ",
            244: "reserved ",
            245: "reserved ",
            246: "reserved ",
            247: "reserved ",
            248: "reserved ",
            249: "reserved ",
            25: "reserved ",
            250: "reserved ",
            251: "reserved ",
            252: "reserved ",
            253: "reserved ",
            254: "reserved ",
            255: "not available",
            26: "reserved ",
            27: "reserved ",
            28: "reserved ",
            29: "reserved ",
            3: "checksum does not match",
            30: "reserved ",
            31: "reserved ",
            32: "reserved ",
            33: "reserved ",
            34: "reserved ",
            35: "reserved ",
            36: "reserved ",
            37: "reserved ",
            38: "reserved ",
            39: "reserved ",
            4: "other",
            40: "reserved ",
            41: "reserved ",
            42: "reserved ",
            43: "reserved ",
            44: "reserved ",
            45: "reserved ",
            46: "reserved ",
            47: "reserved ",
            48: "reserved ",
            49: "reserved ",
            5: "reserved ",
            50: "reserved ",
            51: "reserved ",
            52: "reserved ",
            53: "reserved ",
            54: "reserved ",
            55: "reserved ",
            56: "reserved ",
            57: "reserved ",
            58: "reserved ",
            59: "reserved ",
            6: "reserved ",
            60: "reserved ",
            61: "reserved ",
            62: "reserved ",
            63: "reserved ",
            64: "reserved ",
            65: "reserved ",
            66: "reserved ",
            67: "reserved ",
            68: "reserved ",
            69: "reserved ",
            7: "reserved ",
            70: "reserved ",
            71: "reserved ",
            72: "reserved ",
            73: "reserved ",
            74: "reserved ",
            75: "reserved ",
            76: "reserved ",
            77: "reserved ",
            78: "reserved ",
            79: "reserved ",
            8: "reserved ",
            80: "reserved ",
            81: "reserved ",
            82: "reserved ",
            83: "reserved ",
            84: "reserved ",
            85: "reserved ",
            86: "reserved ",
            87: "reserved ",
            88: "reserved ",
            89: "reserved ",
            9: "reserved ",
            90: "reserved ",
            91: "reserved ",
            92: "reserved ",
            93: "reserved ",
            94: "reserved ",
            95: "reserved ",
            96: "reserved ",
            97: "reserved ",
            98: "reserved ",
            99: "reserved "
        },
        5658: {
            0: "manufacturer code is to be changed",
            1: "manufacturer code shall not be changed"
        },
        5659: {
            0: "ecu instance is to be changed",
            1: "ecu instance shall not be changed"
        },
        566: {
            0: " differential lock disengaged",
            1: " differential lock engaged",
            2: " error",
            3: " not available"
        },
        5660: {
            0: "function instance is to be changed",
            1: "function instance shall not be changed"
        },
        5661: {
            0: "function is to be changed",
            1: "function shall not be changed"
        },
        5662: {
            0: "vehicle system is to be changed",
            1: "vehicle system shall not be changed"
        },
        5663: {
            0: "vehicle system instance is to be changed",
            1: "vehicle system instance shall not be changed"
        },
        5664: {
            0: "industry group is to be changed",
            1: "industry group shall not be changed"
        },
        5665: {
            0: "arbitrary address capable is to be changed",
            1: "arbitrary address capable shall not be changed"
        },
        567: {
            0: " differential lock disengaged",
            1: " differential lock engaged",
            2: " error",
            3: " not available"
        },
        5675: {
            0: "indicator(s) inactive",
            1: "upshift indicator active",
            2: "downshift indicator active",
            3: "don't care/take no action"
        },
        5676: {
            0: "system is not ready (initialization not finished)",
            1: "system is temporarily not available (e.g. due to boundary conditions necessary for operation)",
            10: "reserved for future use",
            11: "reserved for future use",
            12: "reserved for future use",
            13: "reserved for future use",
            14: "error indication",
            15: "not available / not installed",
            2: "system is deactivated by driver",
            3: "system is ready (no warning and no braking active)",
            4: "driver overrides system",
            5: "collision warning active (not affecting vehicle dynamics)",
            6: "collision warning with braking (e.g. brake jerk or partial braking)",
            7: "emergency braking active",
            8: "reserved for future use",
            9: "reserved for future use"
        },
        5677: {
            0: "no warning",
            1: "warning level 1 - lowest",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "don-t care / take no action",
            2: "warning level 2",
            3: "warning level 3",
            4: "warning level 4",
            5: "warning level 5",
            6: "warning level 6",
            7: "warning level 7 - highest",
            8: "reserved",
            9: "reserved"
        },
        5678: {
            0: "no relevant object monitored",
            1: "relevant object is being monitored",
            2: "relevant object is not being detected reliably",
            3: "..101 - reserved",
            6: "error indication",
            7: "signal not available / not installed"
        },
        5679: {
            0: "no indication for a bend off maneuver of the relevant object",
            1: "low probability for a bend off maneuver of the relevant object",
            2: "medium probability for a bend off maneuver of the relevant object",
            3: "high probability for a bend off maneuver of the relevant object",
            4: "highest probability for a bend off maneuver of the relevant object",
            5: "relevant object is already in a turning maneuver",
            6: "error indication",
            7: "signal not available / not installed"
        },
        568: {
            0: " differential lock disengaged",
            1: " differential lock engaged",
            2: " error",
            3: " not available"
        },
        5681: {
            0: "the driver does not want the advanced emergency braking system to warn or intervene at any time (deactivation of system)",
            1: "the driver wants the advanced emergency braking system to warn or intervene if necessary (no deactivation of system)",
            2: "reserved",
            3: "don-t' care / take no action"
        },
        569: {
            0: " differential lock disengaged",
            1: " differential lock engaged",
            2: " error",
            3: " not available"
        },
        570: {
            0: " differential lock disengaged",
            1: " differential lock engaged",
            2: " error",
            3: " not available"
        },
        5709: {
            0: " diagnostic mode disabled",
            1: " nox sensor ato1 self diagnosis request at lambda=1.0",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " not supported",
            2: " nox sensor ato1 self diagnosis request at partial load",
            3: " nox sensor ato1 self diagnosis request at fuel cut",
            4: " nox sensor ato1 self diagnosis request at after run",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        571: {
            0: " retarder - brake assist disabled",
            1: " retarder - brake assist enabled",
            2: " error",
            3: " not available"
        },
        5710: {
            0: " diagnostic mode disabled",
            1: " nox sensor ati1 self diagnosis request at lambda=1.0",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " not supported",
            2: " nox sensor ati1 self diagnosis request at partial load",
            3: " nox sensor ati1 self diagnosis request at fuel cut",
            4: " nox sensor ati1 self diagnosis request at after run",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        5711: {
            0: " diagnostic mode disabled",
            1: " nox sensor ato2 self diagnosis request at lambda=1.0",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " not supported",
            2: " nox sensor ato2 self diagnosis request at partial load",
            3: " nox sensor ato2 self diagnosis request at fuel cut",
            4: " nox sensor ato2 self diagnosis request at after run",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        5712: {
            0: " diagnostic mode disabled",
            1: " nox sensor ati2 self diagnosis request at lambda=1.0",
            10: " reserved",
            11: " reserved",
            12: " reserved",
            13: " reserved",
            14: " reserved",
            15: " not supported",
            2: " nox sensor ati2 self diagnosis request at partial load",
            3: " nox sensor ati2 self diagnosis request at fuel cut",
            4: " nox sensor ati2 self diagnosis request at after run",
            5: " reserved",
            6: " reserved",
            7: " reserved",
            8: " reserved",
            9: " reserved"
        },
        5713: {
            0: " diagnosis not active",
            1: " nox sensor ato1 self diagnosis active flag",
            2: " nox sensor ato1 self diagnosis result complete",
            3: " nox sensor ato1 self diagnosis aborted",
            4: " nox sensor ato1 self diagnosis not possible",
            5: " reserved",
            6: " reserved",
            7: " not supported"
        },
        5714: {
            0: " diagnosis not active",
            1: " nox sensor ati1 self diagnosis active flag",
            2: " nox sensor ati1 self diagnosis result complete",
            3: " nox sensor ati1 self diagnosis aborted",
            4: " nox sensor ati1 self diagnosis not possible",
            5: " reserved",
            6: " reserved",
            7: " not supported"
        },
        5715: {
            0: " diagnosis not active",
            1: " nox sensor ato2 self diagnosis active flag",
            2: " nox sensor ato2 self diagnosis result complete",
            3: " nox sensor ato2 self diagnosis aborted",
            4: " nox sensor ato2 self diagnosis not possible",
            5: " reserved",
            6: " reserved",
            7: " not supported"
        },
        5716: {
            0: " diagnosis not active",
            1: " nox sensor ati2 self diagnosis active flag",
            2: " nox sensor ati2 self diagnosis result complete",
            3: " nox sensor ati2 self diagnosis aborted",
            4: " nox sensor ati2 self diagnosis not possible",
            5: " reserved",
            6: " reserved",
            7: " not supported"
        },
        572: {
            0: " retarder - shift assist disabled",
            1: " retarder - shift assist enabled",
            2: " error",
            3: " not available"
        },
        573: {
            0: " torque converter lockup disengaged",
            1: " torque converter lockup engaged",
            2: " error",
            3: " not available"
        },
        574: {
            0: "shift is not in process ",
            1: "shift in process",
            2: "error",
            3: "not available"
        },
        575: {
            0: "abs off-road switch passive",
            1: "abs off-road switch active",
            2: "error",
            3: "not available"
        },
        5751: {
            0: "b - stop - received an rf messsage from a transmitter requesting a machine level \"stop.\"",
            1: "b - clear - received an rf message from a transmitter clearing a machine level \"stop\" request.",
            14: "b - error - device error",
            15: "b - don't care",
            2: "b - field test - used to request an acknowledgement of an rf signal from the onboard ecu, without adversely affecting the operation of the vehicle",
            3: "b - transmitter test - a transmitter test rf message was requested by a transmitter, used to diagnose transmitter behaviors",
            4: "b - standby - no new status message received at the time the message was communicated",
            5: "b to 1101b - reserved"
        },
        5755: {
            0: "b - beacon request - an ecu requests that a beacon message be transmitted from a wireless device on a machine. this status will always originate from the ecu, and be sent to a wireless device. the message associated with this state will not have an associated transmitter id, or signal strength.",
            1: "b - beacon received acknowledgement - acknowledgement of a beacon transmission detected by an onboard wireless device. this status will always originate from the wireless device, and be sent to the ecu. the message associated with this state will have an associated transmitter id and signal strength.",
            2: "b - reserved",
            3: "b - don't care"
        },
        5758: {
            0: "off",
            1: "on: the ecu is powering the aftertreatment 1 intake gas sensor",
            2: "error",
            3: "unavailable"
        },
        5759: {
            0: "off",
            1: "on: the ecu is powering the aftertreatment 1 outlet gas sensor",
            2: "error",
            3: "unavailable"
        },
        576: {
            0: "asr off-road switch passive",
            1: "asr off-road switch active",
            2: "error",
            3: "not available"
        },
        5760: {
            0: "off",
            1: "on: the ecu is powering the aftertreatment 2 intake gas sensor",
            2: "error",
            3: "unavailable"
        },
        5761: {
            0: "off",
            1: "on: the ecu is powering the aftertreatment 2 outlet gas sensor",
            2: "error",
            3: "unavailable"
        },
        5762: {
            0: "allow or resume transmission load reduction functions",
            1: "inhibit or abort transmission load reduction functions",
            2: "reserved",
            3: "don't care/take no action"
        },
        5764: {
            0: "high most severe",
            1: "high least severe",
            2: "in range ",
            3: "low least severe",
            4: "low most severe",
            5: "not defined",
            6: "error",
            7: "not available"
        },
        5768: {
            0: "high most severe",
            1: "high least severe",
            2: "in range ",
            3: "low least severe",
            4: "low most severe",
            5: "not defined",
            6: "error",
            7: "not available"
        },
        577: {
            0: "asr -hill holder- switch passive",
            1: "asr -hill holder- switch active",
            2: "error",
            3: "not available"
        },
        5771: {
            0: "normal",
            1: "alarm (fully operational but needs service)",
            10: " reserved for future assignment",
            11: " reserved for future assignment",
            12: " reserved for future assignment",
            13: " reserved for future assignment",
            14: "error",
            15: "not available",
            2: "alarm high severity (functional but transient performance may be reduced)",
            3: "derate active (torque output reduced due to environmental conditions)",
            4: "controlled shutdown active (driving to the default position - usually this means closed)",
            5: "uncontrolled shutdown active (actuator current is off so it is limp)",
            6: " reserved for future assignment",
            7: " reserved for future assignment",
            8: " reserved for future assignment",
            9: " reserved for future assignment"
        },
        5772: {
            0: "normal",
            1: "alarm (fully operational but needs service)",
            10: " reserved for future assignment",
            11: " reserved for future assignment",
            12: " reserved for future assignment",
            13: " reserved for future assignment",
            14: "error",
            15: "not available",
            2: "alarm high severity (functional but transient performance may be reduced)",
            3: "derate active (torque output reduced due to environmental conditions)",
            4: "controlled shutdown active (driving to the default position - usually this means closed)",
            5: "uncontrolled shutdown active (actuator current is off so it is limp)",
            6: " reserved for future assignment",
            7: " reserved for future assignment",
            8: " reserved for future assignment",
            9: " reserved for future assignment"
        },
        5774: {
            0: "high most severe",
            1: "high least severe",
            2: "in range ",
            3: "low least severe",
            4: "low most severe",
            5: "not defined",
            6: "error",
            7: "not available"
        },
        5778: {
            0: "high most severe",
            1: "high least severe",
            2: "in range ",
            3: "low least severe",
            4: "low most severe",
            5: "not defined",
            6: "error",
            7: "not available"
        },
        5781: {
            0: "normal",
            1: "alarm (fully operational but needs service)",
            10: " reserved for future assignment",
            11: " reserved for future assignment",
            12: " reserved for future assignment",
            13: " reserved for future assignment",
            14: "error",
            15: "not available",
            2: "alarm high severity (functional but transient performance may be reduced)",
            3: "derate active (torque output reduced due to environmental conditions)",
            4: "controlled shutdown active (driving to the default position - usually this means closed)",
            5: "uncontrolled shutdown active (actuator current is off so it is limp)",
            6: " reserved for future assignment",
            7: " reserved for future assignment",
            8: " reserved for future assignment",
            9: " reserved for future assignment"
        },
        5782: {
            0: "normal",
            1: "alarm (fully operational but needs service)",
            10: " reserved for future assignment",
            11: " reserved for future assignment",
            12: " reserved for future assignment",
            13: " reserved for future assignment",
            14: "error",
            15: "not available",
            2: "alarm high severity (functional but transient performance may be reduced)",
            3: "derate active (torque output reduced due to environmental conditions)",
            4: "controlled shutdown active (driving to the default position - usually this means closed)",
            5: "uncontrolled shutdown active (actuator current is off so it is limp)",
            6: " reserved for future assignment",
            7: " reserved for future assignment",
            8: " reserved for future assignment",
            9: " reserved for future assignment"
        },
        5793: {
            0: " fueling not desired (shut off engine fueling)",
            1: " fueling desired (keep engine running)",
            2: " parameter supported, but no request",
            3: " don't care / take no action"
        },
        5794: {
            0: " fueling is or will be inhibited (spn 5793 desired engine fueling state = 00)",
            1: " engine will be kept running (spn 5793 desired engine fueling state = 01)",
            2: " no active request per spn 5793 desired engine fueling state",
            3: " not supported"
        },
        5795: {
            0: "   engine currently will not stop fueling in response to spn 5793 desired engine fueling state",
            1: "   engine will stop fueling in response to spn 5793 desired engine fueling state",
            2: "   sae reserved",
            3: "   not supported"
        },
        5800: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5801: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5802: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5803: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5804: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5805: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5806: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5807: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5808: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5809: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5810: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5811: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5812: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5813: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5814: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5815: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5816: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5817: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5818: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5819: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5820: {
            0: "no reason/all clear",
            1: "operator presence not detected",
            10: "reserved",
            11: "reserved",
            12: "reserved",
            13: "reserved",
            14: "reserved",
            15: "reserved",
            16: "reserved",
            17: "reserved",
            18: "reserved",
            19: "reserved",
            2: "implement released control of function",
            20: "hydraulic oil level too low",
            21: "valve locked out",
            22: "reserved",
            23: "reserved",
            24: "reserved",
            25: "reserved",
            26: "reserved",
            27: "reserved",
            28: "reserved",
            29: "reserved",
            3: "operator override of function",
            30: "reserved",
            31: "reserved",
            32: "reserved",
            33: "reserved",
            34: "reserved",
            35: "reserved",
            36: "reserved",
            37: "reserved",
            38: "reserved",
            39: "reserved",
            4: "operator control not in valid position",
            40: "reserved",
            41: "manufacturer specific",
            42: "manufacturer specific",
            43: "manufacturer specific",
            44: "manufacturer specific",
            45: "manufacturer specific",
            46: "manufacturer specific",
            47: "manufacturer specific",
            48: "manufacturer specific",
            49: "manufacturer specific",
            5: "remote command timeout",
            50: "manufacturer specific",
            51: "manufacturer specific",
            52: "manufacturer specific",
            53: "manufacturer specific",
            54: "manufacturer specific",
            55: "manufacturer specific",
            56: "manufacturer specific",
            57: "manufacturer specific",
            58: "manufacturer specific",
            59: "manufacturer specific",
            6: "remote command out of range/invalid",
            60: "manufacturer specific",
            61: "manufacturer specific",
            62: "error",
            63: "not available/not installed",
            7: "function not calibrated",
            8: "operator control fault",
            9: "function fault"
        },
        5822: {
            0: "    sensor fully functional",
            1: "    sensor degraded",
            2: "    sensor failed",
            3: "    sensor not available"
        },
        5824: {
            0: "    sensor fully functional",
            1: "    sensor degraded",
            2: "    sensor failed",
            3: "    sensor not available"
        },
        5825: {
            0: "off - used when driver warning system is non-active - which, by requirement, means the low-level and severe inducement systems are also non-active",
            1: "on - solid - used when driver warning system is activated for any relevant malfunction",
            2: "reserved for sae assignment",
            3: "reserved for sae assignment",
            4: "on - fast blink (1 hz) - used for the second driver warning system detection threshold for diesel exhaust fluid level, where the visual alarm of the driver warning system is required to \"escalate in intensity\"",
            5: "reserved for sae assignment",
            6: "reserved for sae assignment",
            7: "not available"
        },
        5826: {
            0: "driver warning, low-level inducement, and severe inducement non-active",
            1: "inducement level 1... euro vi defined driver warning system active ............................ fmi 15",
            2: "inducement level 2 ... euro vi defined low-level inducement enabled ......................... fmi 15",
            3: "inducement level 3 ... euro vi defined low-level inducement active ............................ fmi 16",
            4: "inducement level 4 ... euro vi defined severe inducement enabled .............................. fmi 16",
            5: "inducement level 5 ... euro vi defined severe inducement active ................................. fmi 0",
            6: "temporary override of inducement",
            7: "not available / not supported"
        },
        5837: {
            0: "xff - not available"
        },
        5843: {
            0: "a warm-up cycle has not occurred on this engine start",
            1: "a warm-up cycle has occurred on this engine start",
            2: "sae reserved",
            3: "not supported or not available"
        },
        5850: {
            0: "reading is not stable",
            1: "reading is stable",
            2: "error",
            3: "not available"
        },
        5851: {
            0: "power is not in range",
            1: "power is in range",
            2: "error",
            3: "not available"
        },
        5852: {
            0: "heater element is not in range",
            1: "heater element is in range",
            2: "error",
            3: "not available"
        },
        5854: {
            0: "automatic ",
            1: "preheat 2 ",
            2: "preheat 1 ",
            3: "heater off or not available"
        },
        5857: {
            0: "reading is not stable",
            1: "reading is stable",
            2: "error",
            3: "not available"
        },
        5858: {
            0: "heater element is not in range",
            1: "heater element is in range",
            2: "error",
            3: "not available"
        },
        5859: {
            0: "heater element is not in range",
            1: "heater element is in range",
            2: "error",
            3: "not available"
        },
        5861: {
            0: "automatic ",
            1: "preheat 2 ",
            2: "preheat 1 ",
            3: "heater off or not available"
        },
        5866: {
            0: "fueling inhibit allowed (spn 5795 = 01)",
            1: "dpf regeneration is active or preparing to be active",
            15: "not supported",
            2: "oil distribution in engine is incomplete",
            3: "engine coolant temperature too low",
            4: "service override",
            5: " to 14 - reserved"
        },
        5872: {
            0: "hybrid system warning indicator is off",
            1: "hybrid system warning indicator is on continuously",
            2: "hybrid system warning indicator is flashing",
            3: "not available"
        },
        5873: {
            0: "hybrid system temperature indicator is off",
            1: "hybrid system temperature indicator is on continuously",
            2: "hybrid system temperature indicator is flashing",
            3: "not available"
        },
        5874: {
            0: "hybrid system stop indicator is off",
            1: "hybrid system stop indicator is on continuously",
            2: "hybrid system stop indicator is flashing",
            3: "not available"
        },
        590: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        591: {
            0: "disabled in calibration",
            1: "enabled in calibration",
            2: "error",
            3: "not available"
        },
        5915: {
            0: " less than 1 minute",
            1: " one minute",
            10: " ten minutes",
            11: " eleven minutes",
            12: " twelve minutes",
            13: " thirteen minutes",
            14: " error",
            15: " not available",
            2: " two minutes",
            3: " three minutes",
            4: " four minutes",
            5: " five minutes",
            6: " six minutes",
            7: " seven minutes",
            8: " eight minutes",
            9: " nine minutes"
        },
        5916: {
            0: " conditions valid for transmission oil level measurement",
            1: " conditions not valid - settling timer still counting down",
            10: " not defined",
            11: " not defined",
            12: " not defined",
            13: " conditions not valid - other",
            14: " error",
            15: " not available",
            2: " conditions not valid - transmission in gear",
            3: " conditions not valid - transmission fluid temperature too low",
            4: " conditions not valid - transmission fluid temperature too high",
            5: " conditions not valid - vehicle moving; output shaft speed too high",
            6: " conditions not valid - vehicle not level",
            7: " conditions not valid - engine speed too low",
            8: " conditions not valid - engine speed too high",
            9: " conditions not valid - no request for reading"
        },
        592: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        593: {
            0: "no",
            1: "yes",
            2: "error",
            3: "not available"
        },
        594: {
            0: "inactive",
            1: "active",
            2: "error",
            3: "not available"
        },
        595: {
            0: "cruise control switched off",
            1: "cruise control switched on",
            2: "error",
            3: "not available"
        },
        596: {
            0: "cruise control disabled",
            1: "cruise control enabled",
            2: "error",
            3: "not available"
        },
        597: {
            0: "brake pedal released",
            1: "brake pedal depressed",
            2: "error",
            3: "not available"
        },
        598: {
            0: "clutch pedal released",
            1: "clutch pedal depressed",
            2: "error",
            3: "not available"
        },
        599: {
            0: "cruise control activator not in the position -set-",
            1: "cruise control activator in position -set-",
            2: "error",
            3: "not available"
        },
        600: {
            0: "cruise control activator not in the position -coast-",
            1: "cruise control activator in position -coast-",
            2: "error",
            3: "not available"
        },
        601: {
            0: "cruise control activator not in the position -resume-",
            1: "cruise control activator in position -resume-",
            2: "error",
            3: "not available"
        },
        602: {
            0: "cruise control activator not in the position -accelerate-",
            1: "cruise control activator in position -accelerate-",
            2: "error",
            3: "not available"
        },
        604: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        605: {
            0: "pressure normal",
            1: "pressure too high, compressor clutch may be disengaged",
            2: "error",
            3: "not available"
        },
        606: {
            0: " momentary engine overspeed is disabled",
            1: " momentary engine overspeed is enabled",
            2: " reserved",
            3: " take no action"
        },
        607: {
            0: " progressive shift is not disabled",
            1: " progressive shift is disabled",
            2: " reserved",
            3: " take no action"
        },
        608: {
            0: " stop broadcast",
            1: " start broadcast",
            2: " reserved",
            3: " don-t care/take no action (leave as is)"
        },
        619: {
            0: "parking brake actuator inactive",
            1: "parking brake actuator active",
            2: "error",
            3: "not available"
        },
        622: {
            0: " stop broadcast",
            1: " start broadcast",
            2: " reserved",
            3: " don-t care/take no action (leave as is)"
        },
        623: {
            0: "     lamp off",
            1: "     lamp on",
            2: "     reserved",
            3: "     not available"
        },
        624: {
            0: "     lamp off",
            1: "     lamp on",
            2: "     reserved",
            3: "     not available"
        },
        626: {
            0: "start enable off",
            1: "start enable on",
            2: "reserved",
            3: "not available"
        },
        632: {
            0: "open (fuel supplied to engine)",
            1: "closed (no fuel supplied to engine)",
            2: "reserved",
            3: "don't care / take no action"
        },
        639: {
            0: " stop broadcast",
            1: " start broadcast",
            2: " reserved",
            3: " don-t care/take no action (leave as is)"
        },
        681: {
            0: " gear shifts are allowed  (disable function)",
            1: " gear shifts are inhibited  (enable function)",
            2: " reserved",
            3: " take no action  (leave function as is)"
        },
        682: {
            0: " allow torque converter lockup",
            1: " disable torque converter lockup",
            2: " reserved",
            3: " take no action"
        },
        683: {
            0: " allow driveline engagement",
            1: " disengage driveline",
            2: " reserved",
            3: " take no action"
        },
        685: {
            0: " engage differential lock",
            1: " disengage differential lock",
            2: " reserved",
            3: " take no action"
        },
        686: {
            0: " engage differential lock",
            1: " disengage differential lock",
            2: " reserved",
            3: " take no action"
        },
        687: {
            0: " engage differential lock",
            1: " disengage differential lock",
            2: " reserved",
            3: " take no action"
        },
        688: {
            0: " engage differential lock",
            1: " disengage differential lock",
            2: " reserved",
            3: " take no action"
        },
        689: {
            0: " engage differential lock",
            1: " disengage differential lock",
            2: " reserved",
            3: " take no action"
        },
        69: {
            0: "low speed range",
            1: "high speed range",
            2: "error",
            3: "not available"
        },
        690: {
            0: " engage differential lock",
            1: " disengage differential lock",
            2: " reserved",
            3: " take no action"
        },
        691: {
            0: " engage differential lock",
            1: " disengage differential lock",
            2: " reserved",
            3: " take no action"
        },
        692: {
            0: " switch off abs offroad function",
            1: " switch on abs offroad function",
            2: " reserved",
            3: " take no action"
        },
        693: {
            0: " switch off asr offroad function",
            1: " switch on asr offroad function",
            2: " reserved",
            3: " take no action"
        },
        694: {
            0: " switch off asr special function",
            1: " switch on asr special function",
            2: " reserved",
            3: " take no action"
        },
        695: {
            0: " override disabled - disable any existing control commanded by the source of this command.",
            1: " speed control - govern speed to the included -desired speed- value.",
            2: " torque control - control torque to the included -desired torque- value.",
            3: " speed/torque limit control - limit speed and/or torque based on the included limit values.  the speed limit governor is a droop governor where the speed limit value defines the speed at the maximum torque available during this operation."
        },
        696: {
            0: "b - this speed governor gain selection is adjusted to provide rapid transition between speed setpoints.  rpm overshoot and undershoot may be greater than what is seen when the -speed control characteristic- is set to be stability optimized.",
            1: "b - this control condition has been optimized to minimize rpm overshoot and undershoot given an expected plant consisting of the engine and its accessory loads.  this gain adjustment is not intended to compensate for driveline characteristics.  this characteristic is most appropriate when no driveline is connected.",
            2: "b - this control condition has been optimized to minimize rpm overshoot and undershoot given a more complex plant.  for instance, the more complex plant would contain the engine, its accessory loads and the driveline characteristics.  as an example, the driveline characteristics might include the effective spring mass relationship of pumps, tires, clutches, axles, driveshafts, and multiple gear ratios.  this characteristic is most appropriate when a driveline is engaged.",
            3: "b - this speed control characteristic is available for applications requiring compensation for more than one driveline characteristic.  it has been optimized to minimize rpm overshoot and undershoot given a more complex plant of the second variety.  this more complex plant would again contain the engine, its accessory loads and a second driveline characteristic unique from the one described in speed control characteristic 10b."
        },
        70: {
            0: "parking brake not set",
            1: "parking brake set",
            2: "error",
            3: "not available"
        },
        701: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error",
            3: "not available"
        },
        702: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error",
            3: "not available"
        },
        703: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error",
            3: "not available"
        },
        704: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error",
            3: "not available"
        },
        705: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error",
            3: "not available"
        },
        706: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error",
            3: "not available"
        },
        707: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error",
            3: "not available"
        },
        708: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error",
            3: "not available"
        },
        709: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error",
            3: "not available"
        },
        710: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error",
            3: "not available"
        },
        711: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error",
            3: "not available"
        },
        712: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error",
            3: "not available"
        },
        713: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error",
            3: "not available"
        },
        714: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error",
            3: "not available"
        },
        715: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error",
            3: "not available"
        },
        716: {
            0: "auxiliary channel off",
            1: "auxiliary channel on",
            2: "error",
            3: "not available"
        },
        740: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        748: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        767: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        768: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        769: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        770: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        771: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        772: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        773: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        778: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        779: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        780: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        781: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        782: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        783: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        784: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        786: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        787: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        788: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        875: {
            0: "pressure normal",
            1: "pressure too low, compressor clutch may be disengaged",
            2: "error",
            3: "not available"
        },
        897: {
            0: "b - highest priority = used for situations that require immediate action by the receiving device in order to provide safe vehicle operation (i.e., braking systems).  this level of priority should only be used in safety critical conditions.",
            1: "b -  high priority  =  used for control situations that require prompt action in order to provide safe vehicle operation.  an example is when the transmission is performing a shift and requires control of the engine in order to control driveline reengagement.",
            2: "b - medium priority = used for powertrain control operations which are related to assuring that the vehicle is in a stable operating condition.  an example is when the traction control system is commanding the engine in order to achieve traction stability.",
            3: "b - low priority = used to indicate that the associated command desires powertrain control but is needed for function which improves the driver comfort which may be overridden by other devices.  an example is cruise control or the non-critical part of a transmission shift to a new gear."
        },
        899: {
            0: " low idle governor/no request (default mode)",
            1: " accelerator pedal/operator selection",
            10: " braking system",
            11: " remote accelerator",
            12: " service procedure",
            13: " not defined",
            14: " other",
            15: " not available",
            2: " cruise control",
            3: " pto governor",
            4: " road speed governor",
            5: " asr control",
            6: " transmission control",
            7: " abs control",
            8: " torque limiting",
            9: " high speed governor"
        },
        901: {
            0: "      electric/magnetic",
            1: "      hydraulic",
            10: "   not defined",
            11: "   not defined",
            12: "   not defined",
            13: "   not defined",
            14: "      other",
            15: "      not available",
            2: "      cooled friction",
            3: "      compression release (engine retarder)",
            4: "      exhaust",
            5: "   not defined",
            6: "   not defined",
            7: "   not defined",
            8: "   not defined",
            9: "   not defined"
        },
        902: {
            0: "   (primary)         engine compression release brake (engine rpm)",
            1: "   (primary)         engine exhaust brake (exhaust pressure)",
            10: "                  not defined",
            11: "                  not defined",
            12: "                  not defined",
            13: "                  not defined",
            14: "                           other",
            15: "                           not available",
            2: "   (primary)         transmission input (engine rpm)",
            3: "   (secondary)    transmission output (output shaft rpm)",
            4: "   (secondary)    driveline (output shaft rpm)",
            5: "                           trailer (vehicle speed)",
            6: "                  not defined",
            7: "                  not defined",
            8: "                  not defined",
            9: "                  not defined"
        },
        903: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        966: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        967: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        968: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        969: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        97: {
            0: "no",
            1: "yes",
            2: "error",
            3: "not available"
        },
        970: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        971: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        972: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        976: {
            0: "     off/disabled",
            1: "     hold",
            10: "     preprogrammed set speed 1",
            11: "     preprogrammed set speed 2",
            12: "     preprogrammed set speed 3",
            13: "     preprogrammed set speed 4",
            14: "     preprogrammed set speed 5",
            15: "     preprogrammed set speed 6",
            16: "     preprogrammed set speed 7",
            17: "     preprogrammed set speed 8",
            18: "     pto set speed memory 1",
            19: "     pto set speed memory 2",
            2: "     remote hold",
            20: "      not defined",
            21: "      not defined",
            22: "      not defined",
            23: "      not defined",
            24: "      not defined",
            25: "      not defined",
            26: "      not defined",
            27: "      not defined",
            28: "      not defined",
            29: "      not defined",
            3: "     standby",
            30: "      not defined",
            31: "     not available",
            4: "     remote standby",
            5: "     set",
            6: "     decelerate/coast",
            7: "     resume",
            8: "     accelerate",
            9: "     accelerator override"
        },
        977: {
            0: " fan off",
            1: " engine system-general",
            10: " transmission retarder",
            11: " a/c system",
            12: " timer",
            13: " engine brake",
            14: " other",
            15: " not available",
            2: " excessive engine air temperature",
            3: " excessive engine oil temperature",
            4: " excessive engine coolant temperature",
            5: " excessive transmission oil temperature",
            6: " excessive hydraulic oil temperature",
            7: " default operation",
            8: " reverse operation",
            9: " manual control"
        },
        978: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        979: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        980: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        981: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        982: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        983: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        984: {
            0: "off",
            1: "on",
            2: "error",
            3: "not available"
        },
        985: {
            0: "pressure normal",
            1: "pressure high, fan may be engaged",
            2: "error",
            3: "not available"
        },
        987: {
            0: "     lamp off",
            1: "     lamp on",
            2: "     reserved",
            3: "     not available"
        },
        988: {
            0: " take no action",
            1: " reset",
            2: " reserved",
            3: " not applicable"
        },
        989: {
            0: " take no action",
            1: " reset",
            2: " reserved",
            3: " not applicable"
        }
    }

J1939FMITabledbr = {
        0: {
            "Name": "Data Valid But Above Normal Operational Range",
            "Severity": "Most Severe Level"
        },
        1: {
            "Name": "Data Valid But Below Normal Operational Range",
            "Severity": "Most Severe Level"
        },
        10: {
            "Name": "Abnormal Rate Of Change",
            "Severity": "N/A"
        },
        11: {
            "Name": "Root Cause Not Known",
            "Severity": "N/A"
        },
        12: {
            "Name": "Bad Intelligent Device Or Component",
            "Severity": "N/A"
        },
        13: {
            "Name": "Out Of Calibration",
            "Severity": "N/A"
        },
        14: {
            "Name": "Special Instructions",
            "Severity": "N/A"
        },
        15: {
            "Name": "Data Valid But Above Normal Operating Range",
            "Severity": "Least Severe Level"
        },
        16: {
            "Name": "Data Valid But Above Normal Operating Range",
            "Severity": "Moderately Severe Level"
        },
        17: {
            "Name": "Data Valid But Below Normal Operating Range",
            "Severity": "Least Severe Level"
        },
        18: {
            "Name": "Data Valid But Below Normal Operating Range",
            "Severity": "Moderately Severe Level"
        },
        19: {
            "Name": "Received Network Data In Error",
            "Severity": "N/A"
        },
        2: {
            "Name": "Data Erratic, Intermittent Or Incorrect",
            "Severity": "N/A"
        },
        20: {
            "Name": "Data Drifted High",
            "Severity": "N/A"
        },
        21: {
            "Name": "Data Drifted Low",
            "Severity": "N/A"
        },
        22: {
            "Name": "Reserved For SAE Assignment",
            "Severity": "N/A"
        },
        23: {
            "Name": "Reserved For SAE Assignment",
            "Severity": "N/A"
        },
        24: {
            "Name": "Reserved For SAE Assignment",
            "Severity": "N/A"
        },
        25: {
            "Name": "Reserved For SAE Assignment",
            "Severity": "N/A"
        },
        26: {
            "Name": "Reserved For SAE Assignment",
            "Severity": "N/A"
        },
        27: {
            "Name": "Reserved For SAE Assignment",
            "Severity": "N/A"
        },
        28: {
            "Name": "Reserved For SAE Assignment",
            "Severity": "N/A"
        },
        29: {
            "Name": "Reserved For SAE Assignment",
            "Severity": "N/A"
        },
        3: {
            "Name": "Voltage Above Normal, Or Shorted To High Source",
            "Severity": "N/A"
        },
        30: {
            "Name": "Reserved For SAE Assignment",
            "Severity": "N/A"
        },
        31: {
            "Name": "Condition Exists",
            "Severity": "N/A"
        },
        4: {
            "Name": "Voltage Below Normal, Or Shorted To Low Source",
            "Severity": "N/A"
        },
        5: {
            "Name": "Current Below Normal Or Open Circuit",
            "Severity": "N/A"
        },
        6: {
            "Name": "Current Above Normal Or Grounded Circuit",
            "Severity": "N/A"
        },
        7: {
            "Name": "Mechanical System Not Responding Or Out Of Adjustment",
            "Severity": "N/A"
        },
        8: {
            "Name": "Abnormal Frequency Or Pulse Width Or Period",
            "Severity": "N/A"
        },
        9: {
            "Name": "Abnormal Update Rate",
            "Severity": "N/A"
        }
    }

J1939LampFlashTabledb = {
        0: {
            "AWL": "Off",
            "Flash": 0,
            "Lamp": 0,
            "MIL": "Off",
            "Protected": "Off",
            "RSL": "Off"
        },
        1: {
            "AWL": "Off",
            "Flash": 1,
            "Lamp": 0,
            "MIL": "Off",
            "Protected": "Off",
            "RSL": "Off"
        },
        10: {
            "AWL": "SAE reserved",
            "Flash": 2,
            "Lamp": 2,
            "MIL": "SAE reserved",
            "Protected": "SAE reserved",
            "RSL": "SAE reserved"
        },
        11: {
            "AWL": "SAE reserved",
            "Flash": 3,
            "Lamp": 2,
            "MIL": "SAE reserved",
            "Protected": "SAE reserved",
            "RSL": "SAE reserved"
        },
        12: {
            "AWL": "SAE reserved",
            "Flash": 0,
            "Lamp": 3,
            "MIL": "SAE reserved",
            "Protected": "SAE reserved",
            "RSL": "SAE reserved"
        },
        13: {
            "AWL": "SAE reserved",
            "Flash": 1,
            "Lamp": 3,
            "MIL": "SAE reserved",
            "Protected": "SAE reserved",
            "RSL": "SAE reserved"
        },
        14: {
            "AWL": "SAE reserved",
            "Flash": 2,
            "Lamp": 3,
            "MIL": "SAE reserved",
            "Protected": "SAE reserved",
            "RSL": "SAE reserved"
        },
        15: {
            "AWL": "Don't Care",
            "Flash": 3,
            "Lamp": 3,
            "MIL": "Don't Care",
            "Protected": "Don't Care",
            "RSL": "Don't Care"
        },
        2: {
            "AWL": "SAE reserved",
            "Flash": 2,
            "Lamp": 0,
            "MIL": "Off, class C not active",
            "Protected": "SAE reserved",
            "RSL": "SAE reserved"
        },
        3: {
            "AWL": "Off",
            "Flash": 3,
            "Lamp": 0,
            "MIL": "Off",
            "Protected": "Off",
            "RSL": "Off"
        },
        4: {
            "AWL": "On, slow flash",
            "Flash": 0,
            "Lamp": 1,
            "MIL": "On, slow flash",
            "Protected": "On, slow flash",
            "RSL": "On, slow flash"
        },
        5: {
            "AWL": "On, fast flash",
            "Flash": 1,
            "Lamp": 1,
            "MIL": "On, fast flash",
            "Protected": "On, fast flash",
            "RSL": "On, fast flash"
        },
        6: {
            "AWL": "SAE reserved",
            "Flash": 2,
            "Lamp": 1,
            "MIL": "Off, class C not active",
            "Protected": "SAE reserved",
            "RSL": "SAE reserved"
        },
        7: {
            "AWL": "On, don't flash",
            "Flash": 3,
            "Lamp": 1,
            "MIL": "On, don't flash",
            "Protected": "On, don't flash",
            "RSL": "On, don't flash"
        },
        8: {
            "AWL": "SAE reserved",
            "Flash": 0,
            "Lamp": 2,
            "MIL": "Short MI not active",
            "Protected": "SAE reserved",
            "RSL": "SAE reserved"
        },
        9: {
            "AWL": "SAE reserved",
            "Flash": 1,
            "Lamp": 2,
            "MIL": "Short MI active",
            "Protected": "SAE reserved",
            "RSL": "SAE reserved"
        }
    }

J1939OBDTabledb = {
        0: {
            "Acronym": "Reserved",
            "Description": "Reserved for assignment by SAE"
        },
        1: {
            "Acronym": "OBD II",
            "Description": "OBD II (California Air Resources Board)"
        },
        10: {
            "Acronym": "JOBD",
            "Description": "JOBD"
        },
        11: {
            "Acronym": "JOBD and OBD II",
            "Description": "JOBD and OBD II"
        },
        12: {
            "Acronym": "JOBD and EOBD",
            "Description": "JOBD and EOBD"
        },
        13: {
            "Acronym": "JOBD, EOBD and OBD II",
            "Description": "JOBD, EOBD and OBD II"
        },
        14: {
            "Acronym": "B1",
            "Description": "Heavy Duty Vehicles (EURO IV) B1"
        },
        15: {
            "Acronym": "B2",
            "Description": "Heavy Duty Vehicles (EURO V) B2"
        },
        16: {
            "Acronym": "C",
            "Description": "Heavy Duty Vehicles (EURO EEC) C (gas engines)"
        },
        17: {
            "Acronym": "EMD",
            "Description": "Engine Manufacturer Diagnostics (EMD)"
        },
        18: {
            "Acronym": "EMD+",
            "Description": "Engine Manufacturer Diagnostics Enhanced (EMD+),"
        },
        19: {
            "Acronym": "HD OBD p",
            "Description": "Heavy Duty/On-Board Diagnostics Partial"
        },
        2: {
            "Acronym": "OBD",
            "Description": "OBD (Federal, EPA)"
        },
        20: {
            "Acronym": "HD OBD",
            "Description": "Heavy Duty/On-Board Diagnostics"
        },
        21: {
            "Acronym": "WWH OBD",
            "Description": "World Wide Harmonized OBD"
        },
        22: {
            "Acronym": "OBD II",
            "Description": "OBD II (Califronia Air Resources Board, CCR 1968.2,2007/2008/2009/2010 revisions)"
        },
        23: {
            "Acronym": "OD EOBD",
            "Description": "Heavy Duty Vehicle"
        },
        24: {
            "Acronym": "Reserved",
            "Description": "SAE reserved to be assigned"
        },
        25: {
            "Acronym": "OBD-M (SI-SD/I)",
            "Description": "OBD-M Compliance for Spark-Ignition Sterndrive and Inboard Engines"
        },
        3: {
            "Acronym": "OBD and OBDII",
            "Description": "OBD and OBD II"
        },
        4: {
            "Acronym": "OBD I",
            "Description": "OBD I"
        },
        5: {
            "Acronym": "No OBD II",
            "Description": "Not intended to meet OBD II requirements"
        },
        6: {
            "Acronym": "EOBD",
            "Description": "EOBD"
        },
        7: {
            "Acronym": "EOBD and OBD II",
            "Description": "EOBD and OBD II"
        },
        8: {
            "Acronym": "EOBD and OBD",
            "Description": "EOBD and OBD"
        },
        9: {
            "Acronym": "EOBD, OBD and OBD II",
            "Description": "EOBD, OBD and OBD II"
        }
    }

J1939PGNdb = {
        0: {
            "Label": "TSC1",
            "Name": "Torque/Speed Control 1",
            "PGNLength": 8,
            "Rate": "To engine: Control Purpose dependent or 10 ms To retarder: 50 ms",
            "SPNs": [
                695,
                696,
                897,
                518,
                3349,
                3350,
                4191,
                4206,
                4207,
                898
            ]
        },
        1024: {
            "Label": "XBR",
            "Name": "External Brake Request",
            "PGNLength": 8,
            "Rate": "When active: 20 ms; else 200 ms",
            "SPNs": [
                2914,
                2915,
                2916,
                4099,
                3189,
                3188,
                2920
            ]
        },
        126208: {
            "Label": "",
            "Name": "NMEA - Request/Command/Acknowledge group function",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        126464: {
            "Label": "",
            "Name": "PGN List - Transmit/Receive PGN's group function",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        126720: {
            "Label": "PropA2",
            "Name": "Proprietary A2",
            "PGNLength": "Variable",
            "Rate": "Per user requirements",
            "SPNs": [
                3328
            ]
        },
        126992: {
            "Label": "",
            "Name": "System Time",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        126996: {
            "Label": "",
            "Name": "Product Information",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        126998: {
            "Label": "",
            "Name": "Configuration Information",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        127237: {
            "Label": "",
            "Name": "Heading/Track Control",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        127245: {
            "Label": "",
            "Name": "Rudder",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        127250: {
            "Label": "",
            "Name": "Vessel Heading",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        127251: {
            "Label": "",
            "Name": "Rate of Turn",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        127257: {
            "Label": "",
            "Name": "Attitude",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        127488: {
            "Label": "",
            "Name": "Engine Parameters: Rapid Update",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        127489: {
            "Label": "",
            "Name": "Engine Parameters: Dynamic",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        127493: {
            "Label": "",
            "Name": "Transmission Parameters: Dynamic",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        127497: {
            "Label": "",
            "Name": "Trip Parameters: Small Craft",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        127498: {
            "Label": "",
            "Name": "Engine Parameters: Static",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        127501: {
            "Label": "",
            "Name": "Binary Switch Bank Status",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        127502: {
            "Label": "",
            "Name": "Switch Bank Control",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        127505: {
            "Label": "",
            "Name": "Fluid Level",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        127508: {
            "Label": "",
            "Name": "Battery Status",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        1280: {
            "Label": "CAM11",
            "Name": "Reserved for CANopen",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": []
        },
        128259: {
            "Label": "",
            "Name": "Speed",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        128267: {
            "Label": "",
            "Name": "Water Depth",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        128275: {
            "Label": "",
            "Name": "Distance Log",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        128520: {
            "Label": "",
            "Name": "Tracked Target Data",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129025: {
            "Label": "",
            "Name": "Position: Rapid Update",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129026: {
            "Label": "",
            "Name": "COG & SOG: Rapid Update",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129029: {
            "Label": "",
            "Name": "GNSS Position Data",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129033: {
            "Label": "",
            "Name": "Time & Date",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129044: {
            "Label": "",
            "Name": "Datum",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129045: {
            "Label": "",
            "Name": "User Datum Settings",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129283: {
            "Label": "",
            "Name": "Cross Track Error",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129284: {
            "Label": "",
            "Name": "Navigation Data",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129291: {
            "Label": "",
            "Name": "Set & Drift: Rapid Update",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129301: {
            "Label": "",
            "Name": "Time to/from Mark",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129302: {
            "Label": "",
            "Name": "Bearing and Distance between two Marks",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129538: {
            "Label": "",
            "Name": "GNSS Control Status",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129539: {
            "Label": "",
            "Name": "GNSS DOPs",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129540: {
            "Label": "",
            "Name": "GNSS Sats in View",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129541: {
            "Label": "",
            "Name": "GPS Almanac Data",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129542: {
            "Label": "",
            "Name": "GNSS Pseudorange Noise Statistics",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129545: {
            "Label": "",
            "Name": "GNSS RAIM Output",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129546: {
            "Label": "",
            "Name": "GNSS RAIM Settings",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129547: {
            "Label": "",
            "Name": "GNSS Pseudorange Error Statistics",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129549: {
            "Label": "",
            "Name": "DGNSS Corrections",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129550: {
            "Label": "",
            "Name": "GNSS Differential Correction Receiver Interface",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129551: {
            "Label": "",
            "Name": "GNSS Differential Correction Receiver Signal",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129556: {
            "Label": "",
            "Name": "GLONASS Almanac Data",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129799: {
            "Label": "",
            "Name": "Radio Frequency/Mode/Power",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        129808: {
            "Label": "",
            "Name": "DSC Call Information",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        130052: {
            "Label": "",
            "Name": "Loran-C TD Data",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        130053: {
            "Label": "",
            "Name": "Loran-C Range Data",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        130054: {
            "Label": "",
            "Name": "Loran-C Signal Data",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        130306: {
            "Label": "",
            "Name": "Wind Data",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        130310: {
            "Label": "",
            "Name": "Environmental Parameters",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        130320: {
            "Label": "",
            "Name": "Tide Station Data",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        130321: {
            "Label": "",
            "Name": "Salinity Station Data",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        130322: {
            "Label": "",
            "Name": "Current Station Data",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        130323: {
            "Label": "",
            "Name": "Meteorological Station Data",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        130324: {
            "Label": "",
            "Name": "Moored Buoy Station Data",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        130576: {
            "Label": "",
            "Name": "Small Craft Status",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        130577: {
            "Label": "",
            "Name": "Direction Data",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        130578: {
            "Label": "",
            "Name": "Vessel Speed Components",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        1536: {
            "Label": "CAM21",
            "Name": "Reserved for CANopen",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": []
        },
        1792: {
            "Label": "GPV4",
            "Name": "General Purpose Valve Pressure",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                4087,
                4086,
                4088,
                4089
            ]
        },
        2048: {
            "Label": "AUXIO5",
            "Name": "Auxiliary Input/Output Status 5:8",
            "PGNLength": "Manufacturer defined",
            "Rate": " not faster than 20 ms",
            "SPNs": [
                4155,
                4156,
                4157,
                4158
            ]
        },
        2304: {
            "Label": "SRASI",
            "Name": "Static Roll Angle Sensor Information",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                5582,
                5583
            ]
        },
        256: {
            "Label": "TC1",
            "Name": "Transmission Control 1",
            "PGNLength": 8,
            "Rate": "When active; 50 ms to transmission and axles",
            "SPNs": [
                681,
                682,
                683,
                4242,
                684,
                525,
                685,
                686,
                687,
                688,
                689,
                690,
                691,
                5762,
                1852,
                1853,
                1854,
                1855,
                4255,
                2985,
                4246,
                4247,
                4248,
                4249
            ]
        },
        2560: {
            "Label": "CCVS2",
            "Name": "Cruise Control / Vehicle Speed 2",
            "PGNLength": 8,
            "Rate": "Every 100 ms and on change but no faster than 20 ms",
            "SPNs": [
                5603,
                5604,
                5605
            ]
        },
        2816: {
            "Label": "AEBS2",
            "Name": "Advanced Emergency Braking System 2",
            "PGNLength": 8,
            "Rate": "Every 50ms and if new SPN Driver activation demand for Advanced Emergency Braking System has changed but no faster than every 10 ms",
            "SPNs": [
                5681,
                5682,
                5683
            ]
        },
        34560: {
            "Label": "ESR",
            "Name": "Engine State Requests",
            "PGNLength": 8,
            "Rate": "Every 1 sec and on change but no faster than 100 ms",
            "SPNs": [
                5793
            ]
        },
        34816: {
            "Label": "RBR",
            "Name": "Radio Beacon Request",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                5755,
                5757,
                5754,
                5756
            ]
        },
        35072: {
            "Label": "RGE24",
            "Name": "Reserved for ISO 11992",
            "PGNLength": 8,
            "Rate": "1 sec",
            "SPNs": []
        },
        35328: {
            "Label": "RGE12",
            "Name": "Reserved for ISO 11992",
            "PGNLength": 8,
            "Rate": "1 sec",
            "SPNs": []
        },
        35584: {
            "Label": "CCP DTO",
            "Name": "CCP Data Transmission Object",
            "PGNLength": 8,
            "Rate": "As defined in protocol",
            "SPNs": []
        },
        35840: {
            "Label": "CCP CRO",
            "Name": "CCP Command Receive Object",
            "PGNLength": 8,
            "Rate": "As defined in protocol",
            "SPNs": []
        },
        36096: {
            "Label": "SCCCM",
            "Name": "Sequence Control Client-to-Sequence Control Master",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        36352: {
            "Label": "SCMCC",
            "Name": "Sequence Control Master-to-Sequence Control Client",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        36608: {
            "Label": "ECC",
            "Name": "Engine Configuration Commands",
            "PGNLength": 8,
            "Rate": "Every 10 seconds and on change but no faster than 1 second.",
            "SPNs": [
                5565
            ]
        },
        36864: {
            "Label": "SFC",
            "Name": "Supplemental Fan Command",
            "PGNLength": 8,
            "Rate": "1 second",
            "SPNs": [
                5552,
                5553,
                5555,
                5554
            ]
        },
        37120: {
            "Label": "VLS1",
            "Name": "Vehicle/Chassis Lubrication System 1",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                5510,
                5511,
                5512,
                5513,
                5514
            ]
        },
        37376: {
            "Label": "HCDI1",
            "Name": "Aftertreatment 1 Hydrocarbon Doser Information 1",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                5506,
                5507,
                5508,
                5509,
                5505
            ]
        },
        37632: {
            "Label": "NM",
            "Name": "NAME Management Message",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                5657,
                5658,
                5659,
                5660,
                5661,
                5662,
                5663,
                5664,
                5665,
                5666,
                5668,
                5669,
                5670,
                5671,
                5672,
                5673,
                5674,
                5667
            ]
        },
        37888: {
            "Label": "AT1DPFSSC",
            "Name": "Aftertreatment 1 DPF Soot Sensor Calibration",
            "PGNLength": 8,
            "Rate": "On powerup and on request",
            "SPNs": [
                5495,
                5496
            ]
        },
        38144: {
            "Label": "AT2DPFSSC",
            "Name": "Aftertreatment 2 DPF Soot Sensor Calibration",
            "PGNLength": 8,
            "Rate": "On powerup and on request",
            "SPNs": [
                5497,
                5498
            ]
        },
        38400: {
            "Label": "LVDSOM",
            "Name": "Low Voltage Disconnect Set Operating Mode",
            "PGNLength": 8,
            "Rate": "As required but no more often than 500 ms",
            "SPNs": [
                5149
            ]
        },
        38656: {
            "Label": "NCS",
            "Name": "Noise Control Status:8",
            "PGNLength": "Every 10 seconds and on change of state",
            "Rate": " but not faster than 1 second.  Every second when in tuning mode.",
            "SPNs": [
                5059,
                5060
            ]
        },
        38912: {
            "Label": "NC1",
            "Name": "Noise Control 1:8",
            "PGNLength": "Every 10 seconds and on change of state",
            "Rate": " but not faster than every 1 second.",
            "SPNs": [
                5057,
                5058
            ]
        },
        39168: {
            "Label": "JLCM",
            "Name": "Joystick Lamp Command Message",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                4460,
                4461,
                4462,
                4463,
                4464,
                4465,
                4466,
                4467,
                4468,
                4469,
                4470,
                4471,
                4472,
                4473,
                4474,
                4475,
                4476,
                4477,
                4478,
                4479,
                4480,
                4481,
                4482,
                4483,
                4484,
                4485,
                4486,
                4487,
                4488,
                4489
            ]
        },
        39424: {
            "Label": "GPM18",
            "Name": "Reserved for ISO 11992",
            "PGNLength": 8,
            "Rate": "5 sec",
            "SPNs": []
        },
        39680: {
            "Label": "PMI",
            "Name": "Proprietary Method Identification",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": [
                4180,
                4181
            ]
        },
        39936: {
            "Label": "AUXIO7",
            "Name": "Auxiliary Input/Output Status 7:8",
            "PGNLength": "manufacturer defined",
            "Rate": " not faster than 100 ms",
            "SPNs": [
                4167,
                4168,
                4169,
                4170,
                4171,
                4172,
                4173,
                4174
            ]
        },
        40192: {
            "Label": "AUXIO6",
            "Name": "Auxiliary Input/Output Status 6:8",
            "PGNLength": "manufacturer defined",
            "Rate": " not faster than 100 ms",
            "SPNs": [
                4159,
                4160,
                4161,
                4162,
                4163,
                4164,
                4165,
                4166
            ]
        },
        40448: {
            "Label": "DM29",
            "Name": "DTC Counts",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        40704: {
            "Label": "DM35",
            "Name": "Immediate Fault Status",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": [
                987,
                624,
                623,
                1213,
                3041,
                3040,
                3039,
                3038,
                1215,
                1216,
                1706,
                1214
            ]
        },
        40960: {
            "Label": "DM34",
            "Name": "NTE Status",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": []
        },
        41216: {
            "Label": "DM33",
            "Name": "Emission Increasing Auxiliary Emission Control Device Active Time",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        41472: {
            "Label": "DM32",
            "Name": "Regulated Exhaust Emission Level Exceedance",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        41728: {
            "Label": "DM31",
            "Name": "DTC To Lamp Association",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        41984: {
            "Label": "DM30",
            "Name": "Scaled Test Results",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        42240: {
            "Label": "AUXIO4",
            "Name": "Auxiliary Input/Output Status 4:8",
            "PGNLength": "Manufacturer defined",
            "Rate": " not faster than 100 ms",
            "SPNs": [
                3907,
                3906,
                3905,
                3904,
                3911,
                3910,
                3909,
                3908,
                3915,
                3914,
                3913,
                3912,
                3919,
                3918,
                3917,
                3916,
                3923,
                3922,
                3921,
                3920,
                3927,
                3926,
                3925,
                3924,
                3931,
                3930,
                3929,
                3928,
                3935,
                3934,
                3933,
                3932
            ]
        },
        42496: {
            "Label": "AUXIO3",
            "Name": "Auxiliary Input/Output Status 3:8",
            "PGNLength": "Manufacturer defined",
            "Rate": " not faster than 100 ms",
            "SPNs": [
                3875,
                3874,
                3873,
                3872,
                3879,
                3878,
                3877,
                3876,
                3883,
                3882,
                3881,
                3880,
                3887,
                3886,
                3885,
                3884,
                3891,
                3890,
                3889,
                3888,
                3895,
                3894,
                3893,
                3892,
                3899,
                3898,
                3897,
                3896,
                3903,
                3902,
                3901,
                3900
            ]
        },
        42752: {
            "Label": "AUXIO2",
            "Name": "Auxiliary Input/Output Status 2:8",
            "PGNLength": "Manufacturer defined",
            "Rate": " not faster than 100 ms",
            "SPNs": [
                3843,
                3842,
                3841,
                3840,
                3847,
                3846,
                3845,
                3844,
                3851,
                3850,
                3849,
                3848,
                3855,
                3854,
                3853,
                3852,
                3859,
                3858,
                3857,
                3856,
                3863,
                3862,
                3861,
                3860,
                3867,
                3866,
                3865,
                3864,
                3871,
                3870,
                3869,
                3868
            ]
        },
        43008: {
            "Label": "DISP1",
            "Name": "Text Display",
            "PGNLength": "Variable - up to 200 characters",
            "Rate": "As required",
            "SPNs": [
                3613,
                3614,
                3615
            ]
        },
        43264: {
            "Label": "FLIC",
            "Name": "Forward Lane Image Command",
            "PGNLength": 8,
            "Rate": "On event",
            "SPNs": [
                3564
            ]
        },
        43520: {
            "Label": "CFS",
            "Name": "Client (ECU) to File Server message",
            "PGNLength": "",
            "Rate": "On request",
            "SPNs": []
        },
        43776: {
            "Label": "FSC",
            "Name": "File Server to Client (ECU) message",
            "PGNLength": "",
            "Rate": "On request",
            "SPNs": []
        },
        44032: {
            "Label": "GMS",
            "Name": "Agricultural Guidance Machine Info",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": []
        },
        44288: {
            "Label": "GSC",
            "Name": "Agricultural Guidance System Command",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": []
        },
        44544: {
            "Label": "TPRS",
            "Name": "Tire Pressure Reference Setting",
            "PGNLength": 8,
            "Rate": "As needed",
            "SPNs": [
                3192,
                3193
            ]
        },
        44800: {
            "Label": "PLM",
            "Name": "Parameter Locate Message",
            "PGNLength": 8,
            "Rate": "As required",
            "SPNs": []
        },
        45056: {
            "Label": "CIM",
            "Name": "Configuration Identification Message",
            "PGNLength": 8,
            "Rate": "As required",
            "SPNs": []
        },
        45312: {
            "Label": "PCM1",
            "Name": "Proprietarily Configurable Message #1",
            "PGNLength": "Variable",
            "Rate": "As required",
            "SPNs": []
        },
        45568: {
            "Label": "PCM2",
            "Name": "Proprietarily Configurable Message #2",
            "PGNLength": "Variable",
            "Rate": "As required",
            "SPNs": []
        },
        45824: {
            "Label": "PCM3",
            "Name": "Proprietarily Configurable Message #3",
            "PGNLength": "Variable",
            "Rate": "As required",
            "SPNs": []
        },
        46080: {
            "Label": "PCM4",
            "Name": "Proprietarily Configurable Message #4",
            "PGNLength": "Variable",
            "Rate": "As required",
            "SPNs": []
        },
        46336: {
            "Label": "PCM5",
            "Name": "Proprietarily Configurable Message #5",
            "PGNLength": "Variable",
            "Rate": "As required",
            "SPNs": []
        },
        46592: {
            "Label": "PCM6",
            "Name": "Proprietarily Configurable Message #6",
            "PGNLength": "Variable",
            "Rate": "As required",
            "SPNs": []
        },
        46848: {
            "Label": "PCM7",
            "Name": "Proprietarily Configurable Message #7",
            "PGNLength": "Variable",
            "Rate": "As required",
            "SPNs": []
        },
        47104: {
            "Label": "PCM8",
            "Name": "Proprietarily Configurable Message #8",
            "PGNLength": "Variable",
            "Rate": "As required",
            "SPNs": []
        },
        47360: {
            "Label": "PCM9",
            "Name": "Proprietarily Configurable Message #9",
            "PGNLength": "Variable",
            "Rate": "As required",
            "SPNs": []
        },
        47616: {
            "Label": "PCM10",
            "Name": "Proprietarily Configurable Message #10",
            "PGNLength": "Variable",
            "Rate": "As required",
            "SPNs": []
        },
        47872: {
            "Label": "PCM11",
            "Name": "Proprietarily Configurable Message #11",
            "PGNLength": "Variable",
            "Rate": "As required",
            "SPNs": []
        },
        48128: {
            "Label": "PCM12",
            "Name": "Proprietarily Configurable Message #12",
            "PGNLength": "Variable",
            "Rate": "As required",
            "SPNs": []
        },
        48384: {
            "Label": "PCM13",
            "Name": "Proprietarily Configurable Message #13",
            "PGNLength": "Variable",
            "Rate": "As required",
            "SPNs": []
        },
        48640: {
            "Label": "PCM14",
            "Name": "Proprietarily Configurable Message #14",
            "PGNLength": "Variable",
            "Rate": "As required",
            "SPNs": []
        },
        48896: {
            "Label": "PCM15",
            "Name": "Proprietarily Configurable Message #15",
            "PGNLength": "Variable",
            "Rate": "As required",
            "SPNs": []
        },
        49152: {
            "Label": "PCM16",
            "Name": "Proprietarily Configurable Message #16",
            "PGNLength": "Variable",
            "Rate": "As required",
            "SPNs": []
        },
        49408: {
            "Label": "DM21",
            "Name": "Diagnostic Readiness 2",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                3069,
                3294,
                3295,
                3296
            ]
        },
        49664: {
            "Label": "DM20",
            "Name": "Monitor Performance Ratio",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": [
                3048,
                3049,
                3067,
                3068,
                3066
            ]
        },
        49920: {
            "Label": "DM22",
            "Name": "Individual Clear/Reset Of Active And Previously Active DTC",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                3034,
                3035,
                3037,
                3036
            ]
        },
        50176: {
            "Label": "GPV3",
            "Name": "General Purpose Valve Command",
            "PGNLength": 8,
            "Rate": "1 s for each valve or on change of state.",
            "SPNs": [
                2944
            ]
        },
        50432: {
            "Label": "GPV2",
            "Name": "General Purpose Valve Measured Flow",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                2937,
                2938,
                2943,
                2941,
                2942
            ]
        },
        50688: {
            "Label": "GPV1",
            "Name": "General Purpose Valve Estimated Flow",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                2939,
                2940,
                2932,
                2934
            ]
        },
        50944: {
            "Label": "ETP.DT",
            "Name": "Extended Transport Protocol - Data Transfer",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        512: {
            "Label": "EBS11",
            "Name": "Reserved for ISO 11992",
            "PGNLength": 8,
            "Rate": "10 ms +/- 1 ms",
            "SPNs": []
        },
        51200: {
            "Label": "ETP.CM",
            "Name": "Extended Transport Protocol - Connection Management",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        51456: {
            "Label": " see PGN 59392",
            "Name": "Request 2:8 bytes (multipacket  supported)",
            "PGNLength": "Per user requirements ",
            "Rate": " generally recommended that requests occur no more than 2 or 3 times per second. A NACK is required if the PG being asked for with a destination specifc address and it is not supported",
            "SPNs": [
                2575,
                2574
            ]
        },
        51712: {
            "Label": "XFER",
            "Name": "Transfer",
            "PGNLength": "9 to 1785 bytes (multipacket supported)",
            "Rate": "In response to a Request2 PGN with \u201cUse Transfer PGN\u201d = 01",
            "SPNs": [
                2553,
                2552,
                2554,
                2555
            ]
        },
        51968: {
            "Label": "PD",
            "Name": "Process Data Message",
            "PGNLength": 8,
            "Rate": "As Events Require",
            "SPNs": [
                2421,
                2420,
                2419,
                2422,
                2426,
                2425,
                2428,
                2427,
                2429
            ]
        },
        52224: {
            "Label": "REQRR",
            "Name": "Request for Repetition Rate",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                2421,
                2420,
                2419,
                2426,
                2425,
                2428,
                2427,
                2418
            ]
        },
        52480: {
            "Label": "KWP4",
            "Name": "Reserved for ISO 15765",
            "PGNLength": 8,
            "Rate": "User requirements",
            "SPNs": []
        },
        52736: {
            "Label": "KWP3",
            "Name": "Reserved for ISO 15765",
            "PGNLength": 8,
            "Rate": "User requirements",
            "SPNs": []
        },
        52992: {
            "Label": "CTL",
            "Name": "Continuous Torque & Speed Limit Request",
            "PGNLength": 8,
            "Rate": "5 s",
            "SPNs": [
                1784,
                1785,
                1786,
                1787,
                1788,
                1789,
                1790,
                1791
            ]
        },
        53248: {
            "Label": "CL",
            "Name": "Cab Illumination Message",
            "PGNLength": 8,
            "Rate": "Every 5 s and on change of state but no faster than every 100 ms",
            "SPNs": [
                1487,
                5532
            ]
        },
        53504: {
            "Label": "ASC6",
            "Name": "Air Suspension Control 6",
            "PGNLength": 8,
            "Rate": "100 ms when active",
            "SPNs": [
                1732,
                1757,
                1758,
                1735
            ]
        },
        53760: {
            "Label": "ASC2",
            "Name": "Air Suspension Control 2",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                2984,
                1749,
                1748,
                1747,
                1751,
                1750,
                1753,
                1752,
                1828,
                1718,
                1719,
                1720,
                1830,
                1829,
                3215,
                5293,
                5295,
                5274,
                5433
            ]
        },
        54016: {
            "Label": "DM19",
            "Name": "Calibration Information",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": [
                1634,
                1635
            ]
        },
        54272: {
            "Label": "DM18",
            "Name": "Data Security",
            "PGNLength": "Variable",
            "Rate": "As needed",
            "SPNs": [
                1479,
                1596,
                1597
            ]
        },
        54528: {
            "Label": "TDA",
            "Name": "Time/Date Adjust",
            "PGNLength": 8,
            "Rate": "As needed",
            "SPNs": [
                1603,
                1604,
                1605,
                1606,
                1607,
                1608,
                1609,
                1610
            ]
        },
        54784: {
            "Label": "DM17",
            "Name": "Boot Load Data",
            "PGNLength": 8,
            "Rate": "As needed",
            "SPNs": [
                1652
            ]
        },
        55040: {
            "Label": "DM16",
            "Name": "Binary Data Transfer",
            "PGNLength": "Variable",
            "Rate": "As needed",
            "SPNs": [
                1650,
                1651,
                1651
            ]
        },
        55296: {
            "Label": "DM15",
            "Name": "Memory Access Response",
            "PGNLength": 8,
            "Rate": "As needed",
            "SPNs": [
                1646,
                1647,
                1648,
                1599,
                1649
            ]
        },
        55552: {
            "Label": "DM14",
            "Name": "Memory Access Request",
            "PGNLength": 8,
            "Rate": "As needed",
            "SPNs": [
                1642,
                1641,
                1643,
                1644,
                1645,
                1640
            ]
        },
        55808: {
            "Label": "KWP2",
            "Name": "Reserved for ISO 15765",
            "PGNLength": 8,
            "Rate": "",
            "SPNs": []
        },
        56064: {
            "Label": "KWP1",
            "Name": "Reserved for ISO 15765",
            "PGNLength": 8,
            "Rate": "",
            "SPNs": []
        },
        56320: {
            "Label": "ATS",
            "Name": "Anti-theft Status",
            "PGNLength": 8,
            "Rate": "This message is transmitted in response to an Anti-Theft Request message. This message is also sent when the component has an abnormal power interruption.  In this situation the Anti-Theft Status Report is sent without the Anti-Theft Request.",
            "SPNs": [
                1194,
                1195,
                1196,
                1197,
                1198
            ]
        },
        56576: {
            "Label": "ATR",
            "Name": "Anti-theft Request",
            "PGNLength": 8,
            "Rate": "Transmission of this message is interrupt driven.  This message is also transmitted upon power-up of the interfacing device sending this message.",
            "SPNs": [
                1199,
                1200,
                1201,
                1202
            ]
        },
        56832: {
            "Label": "RESET",
            "Name": "Reset",
            "PGNLength": 8,
            "Rate": "When needed",
            "SPNs": [
                988,
                989,
                1584,
                1211,
                3600
            ]
        },
        57088: {
            "Label": "DM13",
            "Name": "Stop Start Broadcast",
            "PGNLength": 8,
            "Rate": "Sent when ever a Stop or Start broadcast event is necessary. To maintain the modified state of the vehicle network(s) the commanding device must send the Hold Signal once every 5 seconds.",
            "SPNs": [
                639,
                622,
                608,
                1230,
                1234,
                1233,
                1232,
                1231,
                1235,
                2618,
                1236,
                2619
            ]
        },
        57344: {
            "Label": "CM1",
            "Name": "Cab Message 1",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                986,
                1684,
                1682,
                1714,
                1856,
                5630,
                1655,
                1654,
                1653,
                3695,
                3696,
                1666,
                1656,
                1683,
                1685,
                1686,
                2596,
                1691
            ]
        },
        57600: {
            "Label": "GPM21",
            "Name": "Reserved for ISO 11992",
            "PGNLength": 8,
            "Rate": "",
            "SPNs": []
        },
        57856: {
            "Label": "GPM11",
            "Name": "Reserved for ISO 11992",
            "PGNLength": 8,
            "Rate": "",
            "SPNs": []
        },
        58112: {
            "Label": "DM07",
            "Name": "Command Non-continuously Monitored Test",
            "PGNLength": 8,
            "Rate": "Sent whenever a test is desired",
            "SPNs": [
                1224,
                4149,
                4148
            ]
        },
        58368: {
            "Label": "RGE11",
            "Name": "Reserved for ISO 11992",
            "PGNLength": 8,
            "Rate": "100 ms +/- 10 ms",
            "SPNs": []
        },
        58624: {
            "Label": "RGE21",
            "Name": "Reserved for ISO 11992",
            "PGNLength": 8,
            "Rate": "100 ms +/- 10 ms",
            "SPNs": []
        },
        58880: {
            "Label": "VT12",
            "Name": "Virtual Terminal-to-Node",
            "PGNLength": "Variable",
            "Rate": "",
            "SPNs": []
        },
        59136: {
            "Label": "VT21",
            "Name": "Node-to-Virtual Terminal",
            "PGNLength": "Variable",
            "Rate": "",
            "SPNs": []
        },
        59392: {
            "Label": "ACKM",
            "Name": "Acknowledgment Message",
            "PGNLength": 8,
            "Rate": "Upon reception of a Parameter Group Number that requires this form of acknowledgment.",
            "SPNs": [
                2541,
                2542,
                2543,
                2544,
                2545,
                2546,
                2547,
                2548,
                2549
            ]
        },
        59904: {
            "Label": "RQST",
            "Name": "Request:3",
            "PGNLength": "Per user requirements",
            "Rate": " generally recommended that requests occur no more than 2 or 3 times per second.",
            "SPNs": [
                2540
            ]
        },
        60160: {
            "Label": "TP.DT",
            "Name": "Transport Protocol - Data Transfer",
            "PGNLength": 8,
            "Rate": "Per the Parameter Group to be transferred",
            "SPNs": [
                2572,
                2573
            ]
        },
        60416: {
            "Label": "TP.CM.xx",
            "Name": "Transport Protocol - Connection Mgmt",
            "PGNLength": 8,
            "Rate": "Per the Parameter Group to be transferred",
            "SPNs": [
                2556,
                2560,
                2561,
                2563,
                2566,
                2569,
                2571
            ]
        },
        60672: {
            "Label": "N.xx",
            "Name": "Network Layer",
            "PGNLength": "Variable",
            "Rate": "100 ms",
            "SPNs": []
        },
        60928: {
            "Label": "AC",
            "Name": "Address Claimed",
            "PGNLength": 8,
            "Rate": "As required",
            "SPNs": [
                2848
            ]
        },
        61184: {
            "Label": "PropA",
            "Name": "Proprietary A",
            "PGNLength": "Variable",
            "Rate": "Per user requirements",
            "SPNs": [
                2550
            ]
        },
        61440: {
            "Label": "ERC1",
            "Name": "Electronic Retarder Controller 1",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                900,
                571,
                572,
                520,
                1085,
                1082,
                1667,
                4233,
                4234,
                1480,
                1715,
                1716,
                1717
            ]
        },
        61441: {
            "Label": "EBC1",
            "Name": "Electronic Brake Controller 1",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                561,
                562,
                563,
                1121,
                521,
                575,
                576,
                577,
                1238,
                972,
                971,
                970,
                969,
                973,
                1243,
                1439,
                1438,
                1793,
                1481,
                2911,
                1836,
                1792
            ]
        },
        61442: {
            "Label": "ETC1",
            "Name": "Electronic Transmission Controller 1",
            "PGNLength": 8,
            "Rate": "10 ms",
            "SPNs": [
                560,
                573,
                574,
                4816,
                522,
                606,
                607,
                5015,
                1482,
                191,
                161
            ]
        },
        61443: {
            "Label": "EEC2",
            "Name": "Electronic Engine Controller 2",
            "PGNLength": 8,
            "Rate": "50 msec (preferred) or Engine Speed Dependent (if required by application)",
            "SPNs": [
                558,
                559,
                1437,
                2970,
                91,
                92,
                974,
                29,
                2979,
                5021,
                5399,
                5400,
                3357,
                5398
            ]
        },
        61444: {
            "Label": "EEC1",
            "Name": "Electronic Engine Controller 1",
            "PGNLength": 8,
            "Rate": "engine speed dependent",
            "SPNs": [
                899,
                4154,
                512,
                513,
                1483,
                1675,
                2432,
                190
            ]
        },
        61445: {
            "Label": "ETC2",
            "Name": "Electronic Transmission Controller 2",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                524,
                523,
                526,
                162,
                163
            ]
        },
        61446: {
            "Label": "EAC1",
            "Name": "Electronic Axle Controller 1",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                927,
                567,
                568,
                569,
                570,
                564,
                565,
                566,
                3819,
                3820
            ]
        },
        61447: {
            "Label": "FLI1",
            "Name": "Forward Lane Image urgent msg",
            "PGNLength": 8,
            "Rate": "50 ms (only when active)",
            "SPNs": [
                3565,
                3566,
                1701,
                1700
            ]
        },
        61448: {
            "Label": "HPG",
            "Name": "Hydraulic Pressure Governor Info",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": [
                1763,
                1764,
                2599,
                1762
            ]
        },
        61449: {
            "Label": "VDC2",
            "Name": "Vehicle Dynamic Stability Control 2",
            "PGNLength": 8,
            "Rate": "10 ms",
            "SPNs": [
                1811,
                1812,
                1810,
                1807,
                1808,
                1809
            ]
        },
        61450: {
            "Label": "EGF1",
            "Name": "Engine Gas Flow Rate",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": [
                2659,
                132,
                5257
            ]
        },
        61451: {
            "Label": "ESC1",
            "Name": "Electronic Steering Control",
            "PGNLength": 8,
            "Rate": "20 ms",
            "SPNs": [
                2928,
                2923,
                2922,
                2924,
                2925,
                2926,
                2927
            ]
        },
        61452: {
            "Label": "ETC8",
            "Name": "Electronic Transmission Controller #8:8",
            "PGNLength": "20 ms when torque converter unlocked",
            "Rate": " 100 ms when torque converter locked",
            "SPNs": [
                3030,
                5052
            ]
        },
        61453: {
            "Label": "LOI",
            "Name": "Land Leveling System Operational Information",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                3156,
                3157,
                3158,
                3334,
                3335,
                3336,
                3337,
                3338,
                3339,
                5405,
                5406
            ]
        },
        61454: {
            "Label": "AT1IG1",
            "Name": "Aftertreatment 1 Intake Gas 1",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": [
                3218,
                3219,
                3220,
                3221,
                3222,
                3223,
                3224,
                5713,
                3225,
                3216,
                3217
            ]
        },
        61455: {
            "Label": "AT1OG1",
            "Name": "Aftertreatment 1 Outlet Gas 1",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": [
                3228,
                3229,
                3230,
                3231,
                3232,
                3233,
                3234,
                5714,
                3235,
                3226,
                3227
            ]
        },
        61456: {
            "Label": "AT2IG1",
            "Name": "Aftertreatment 2 Intake Gas 1",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": [
                3257,
                3258,
                3259,
                3260,
                3261,
                3262,
                3263,
                5715,
                3264,
                3255,
                3256
            ]
        },
        61457: {
            "Label": "AT2OG1",
            "Name": "Aftertreatment 2 Outlet Gas 1",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": [
                3267,
                3268,
                3269,
                3270,
                3271,
                3272,
                3273,
                5716,
                3274,
                3265,
                3266
            ]
        },
        61458: {
            "Label": "FWSS1",
            "Name": "Fifth Wheel Smart Systems 1",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": [
                3317,
                3308,
                3309,
                3310
            ]
        },
        61459: {
            "Label": "SSI",
            "Name": "Slope Sensor Information",
            "PGNLength": 8,
            "Rate": "10 ms",
            "SPNs": [
                3323,
                3324,
                3325,
                3326,
                3327,
                3318,
                3319,
                3322
            ]
        },
        61460: {
            "Label": "BI",
            "Name": "Blade Information",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": [
                3366,
                3367,
                3332,
                3365,
                3331
            ]
        },
        61461: {
            "Label": "RGTACRP",
            "Name": "Requested Generator Total AC Reactive Power",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                3385,
                3383,
                3384
            ]
        },
        61462: {
            "Label": "CCS",
            "Name": "Cylinder Combustion Status:8",
            "PGNLength": "Engine speed dependent when there is no combustion",
            "Rate": " once every 5 seconds otherwise",
            "SPNs": [
                3387,
                3388,
                3389,
                3390,
                3391,
                3392,
                3393,
                3394,
                3395,
                3396,
                3397,
                3398,
                3399,
                3400,
                3401,
                3402,
                3403,
                3404,
                3405,
                3406,
                3407,
                3408,
                3409,
                3410
            ]
        },
        61463: {
            "Label": "KL1",
            "Name": "Engine Knock Level #1:8",
            "PGNLength": "Engine speed dependent when knock present",
            "Rate": " once every 5 seconds otherwise",
            "SPNs": [
                1352,
                1353,
                1354,
                1355,
                1356,
                1357,
                1358,
                1359
            ]
        },
        61464: {
            "Label": "KL2",
            "Name": "Engine Knock Level #2:8",
            "PGNLength": "Engine speed dependent when knock present",
            "Rate": " once every 5 seconds otherwise",
            "SPNs": [
                1360,
                1361,
                1362,
                1363,
                1364,
                1365,
                1366,
                1367
            ]
        },
        61465: {
            "Label": "KL3",
            "Name": "Engine Knock Level #3:8",
            "PGNLength": "Engine speed dependent when knock present",
            "Rate": " once every 5 seconds otherwise",
            "SPNs": [
                1368,
                1369,
                1370,
                1371,
                1372,
                1373,
                1374,
                1375
            ]
        },
        61466: {
            "Label": "TFAC",
            "Name": "Engine Throttle / Fuel Actuator Control Command",
            "PGNLength": 8,
            "Rate": "50 msec (preferred) or Engine Speed Dependent (if required by application)",
            "SPNs": [
                3464,
                3465,
                633,
                1244
            ]
        },
        61467: {
            "Label": "GPM17",
            "Name": "General Purpose Message #1/7",
            "PGNLength": 8,
            "Rate": "10 ms",
            "SPNs": []
        },
        61468: {
            "Label": "RGAAC",
            "Name": "Requested Generator Average Basic AC Quantities",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                3386
            ]
        },
        61469: {
            "Label": "SAS",
            "Name": "Steering Angle Sensor Information",
            "PGNLength": 8,
            "Rate": "10 ms",
            "SPNs": [
                3684,
                3685,
                3687,
                3688,
                3689,
                3690,
                3683,
                3686
            ]
        },
        61470: {
            "Label": "GC2",
            "Name": "Generator Control 2",
            "PGNLength": 8,
            "Rate": "20 ms",
            "SPNs": [
                3938
            ]
        },
        61471: {
            "Label": "EBS26",
            "Name": "Electronic Brake System #2/6",
            "PGNLength": 8,
            "Rate": "10 ms +/- 1 ms",
            "SPNs": []
        },
        61472: {
            "Label": "EBS25",
            "Name": "Electronic Brake System #2/5",
            "PGNLength": 8,
            "Rate": "10 ms +/- 1 ms",
            "SPNs": []
        },
        61473: {
            "Label": "ESSI",
            "Name": "Engine Speed Sensor Information:8",
            "PGNLength": "Transmitted only after requested.  After request",
            "Rate": " broadcast rate is engine speed dependent.  Update stopped after key switch cycle.",
            "SPNs": [
                4205,
                4204,
                4203,
                4201,
                723,
                4202
            ]
        },
        61474: {
            "Label": "MSS",
            "Name": "Machine Selected Speed",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                4309,
                4308,
                4307,
                4305,
                4306
            ]
        },
        61475: {
            "Label": "A1SCRDSI1",
            "Name": "Aftertreatment 1 SCR Dosing System Information 1",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": [
                4332,
                4334,
                4331,
                4333
            ]
        },
        61476: {
            "Label": "A1SCRDSR1",
            "Name": "Aftertreatment 1 SCR Dosing System Requests 1",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": [
                4349,
                4348,
                4350
            ]
        },
        61477: {
            "Label": "A1SCRAI",
            "Name": "Aftertreatment 1 SCR Ammonia Information",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": [
                4378,
                4379,
                4380,
                4381,
                4382,
                4383,
                4377
            ]
        },
        61478: {
            "Label": "A2SCRDSI1",
            "Name": "Aftertreatment 2 SCR Dosing System Information 1",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": [
                4385,
                4387,
                4384,
                4386
            ]
        },
        61479: {
            "Label": "A2SCRDSR1",
            "Name": "Aftertreatment 2 SCR Dosing System Requests 1",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": [
                4402,
                4401,
                4403
            ]
        },
        61480: {
            "Label": "A2SCRAI",
            "Name": "Aftertreatment 2 SCR Ammonia Information",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": [
                4444,
                4445,
                4446,
                4447,
                4448,
                4449,
                4443
            ]
        },
        61481: {
            "Label": "SSI2",
            "Name": "Slope Sensor Information 2",
            "PGNLength": 8,
            "Rate": "10 ms",
            "SPNs": [
                4978,
                4979,
                4980,
                4981,
                4982,
                4976,
                4977
            ]
        },
        61482: {
            "Label": "ARI",
            "Name": "Angular Rate Information",
            "PGNLength": 8,
            "Rate": "10 ms",
            "SPNs": [
                4986,
                4987,
                4988,
                4989,
                4983,
                4984,
                4985
            ]
        },
        61483: {
            "Label": "CN",
            "Name": "Crash Notification",
            "PGNLength": 8,
            "Rate": "Transmitted every 20 msec for the first 100 msec and then broadcast every 1 sec for 10 sec in case of a crash event",
            "SPNs": [
                4973,
                4974,
                4975
            ]
        },
        61484: {
            "Label": "MSI2",
            "Name": "Magnet Status Information 2",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": [
                5009,
                5010,
                5011,
                5012,
                5013,
                5014,
                5402,
                5403,
                5551,
                5008
            ]
        },
        61485: {
            "Label": "ACCS",
            "Name": "Acceleration Sensor",
            "PGNLength": 8,
            "Rate": "10 ms (default) or 20 ms",
            "SPNs": [
                5350,
                5351,
                5352,
                5353,
                5347,
                5348,
                5349
            ]
        },
        61486: {
            "Label": "ETWAC",
            "Name": "Engine Turbocharger Wastegate Actuator and Exhaust Back Pressure Regulator Command",
            "PGNLength": 8,
            "Rate": "Engine speed dependent",
            "SPNs": [
                5386,
                5387,
                649
            ]
        },
        61487: {
            "Label": "AEBS1",
            "Name": "Advanced Emergency Braking System 1",
            "PGNLength": 8,
            "Rate": "Every 50ms and on change of AEBS system state or change of Collision warning status but no faster than every 10 ms",
            "SPNs": [
                5676,
                5677,
                5678,
                5679,
                5680
            ]
        },
        61488: {
            "Label": "WS",
            "Name": "Wireless Status",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": [
                5751,
                5753,
                5750,
                5752
            ]
        },
        61489: {
            "Label": "WAND",
            "Name": "Wand Sensor",
            "PGNLength": 8,
            "Rate": "20 ms",
            "SPNs": [
                5822,
                5821
            ]
        },
        61490: {
            "Label": "LDISP",
            "Name": "Linear Displacement Sensor",
            "PGNLength": 8,
            "Rate": "20 ms",
            "SPNs": [
                5824,
                5823
            ]
        },
        61491: {
            "Label": "A1SCRAI2",
            "Name": "Aftertreatment 1 SCR Ammonia Information 2",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": [
                5849,
                5850,
                5851,
                5852,
                5853,
                5854,
                5848
            ]
        },
        61492: {
            "Label": "A2SCRAI2",
            "Name": "Aftertreatment 2 SCR Ammonia Information 2",
            "PGNLength": 8,
            "Rate": "50 ms",
            "SPNs": [
                5856,
                5857,
                5858,
                5859,
                5860,
                5861,
                5855
            ]
        },
        64706: {
            "Label": "HSS",
            "Name": "Hybrid System Status",
            "PGNLength": 8,
            "Rate": "Every 1 sec and on change but no faster than 100 ms",
            "SPNs": [
                5872,
                5873,
                5874
            ]
        },
        64707: {
            "Label": "GFI4",
            "Name": "Fuel Information 4 (Gaseous)",
            "PGNLength": "8 bytes",
            "Rate": "200 ms",
            "SPNs": [
                5867
            ]
        },
        64708: {
            "Label": "A2SCREGT2",
            "Name": "Aftertreatment 2 SCR Exhaust Gas Temperature 2",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                5865,
                5864
            ]
        },
        64709: {
            "Label": "A1SCREGT2",
            "Name": "Aftertreatment 1 SCR Exhaust Gas Temperature 2",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                5863,
                5862
            ]
        },
        64710: {
            "Label": "DM57",
            "Name": "OBD Information",
            "PGNLength": 0,
            "Rate": "On request",
            "SPNs": [
                5843
            ]
        },
        64711: {
            "Label": "DM56",
            "Name": "Engine Emissions Certification Information",
            "PGNLength": 0,
            "Rate": "On request",
            "SPNs": [
                5844,
                5845
            ]
        },
        64712: {
            "Label": "EEC13",
            "Name": "Electronic Engine Controller 13",
            "PGNLength": 8,
            "Rate": "Every 1 sec and on change but no faster than 100 ms",
            "SPNs": [
                5794,
                5795,
                5866
            ]
        },
        64713: {
            "Label": "EF/TVI2",
            "Name": "Engine Fuel/Throttle Valve Information 2",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                5783,
                5784,
                5785,
                5786,
                5787
            ]
        },
        64714: {
            "Label": "EEGR1A",
            "Name": "Engine Exhaust Gas Recirculation 2 Actuator",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                5773,
                5774,
                5775,
                5776,
                5777,
                5778,
                5779,
                5780,
                5781,
                5782
            ]
        },
        64715: {
            "Label": "EEGR1A",
            "Name": "Engine Exhaust Gas Recirculation 1 Actuator",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                5763,
                5764,
                5765,
                5766,
                5767,
                5768,
                5769,
                5770,
                5771,
                5772
            ]
        },
        64716: {
            "Label": "EEC12",
            "Name": "Electronic Engine Controller 12",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                5758,
                5759,
                5760,
                5761
            ]
        },
        64717: {
            "Label": "DSS",
            "Name": "Drive Strategy Status",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": []
        },
        64718: {
            "Label": "DSC",
            "Name": "Drive Strategy Command",
            "PGNLength": 8,
            "Rate": "Every 500 ms and on change of data in the PGN but no faster than 100 ms",
            "SPNs": []
        },
        64719: {
            "Label": "NSSR",
            "Name": "NOx Sensor Self-Diagnosis Request",
            "PGNLength": 8,
            "Rate": "As required",
            "SPNs": [
                5709,
                5710,
                5711,
                5712
            ]
        },
        64720: {
            "Label": "EPSI",
            "Name": "Engine Particulate Sensor Information",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                5835,
                5836
            ]
        },
        64721: {
            "Label": "DM53",
            "Name": "Active Service Only DTCs",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": []
        },
        64722: {
            "Label": "DM54",
            "Name": "Previously Active Service Only DTCs",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": []
        },
        64723: {
            "Label": "DM55",
            "Name": "Diagnostic Data Clear/Reset for All Service Only DTCs",
            "PGNLength": 0,
            "Rate": "On request",
            "SPNs": []
        },
        64724: {
            "Label": "XCP ID",
            "Name": "XCP Get Slave ID",
            "PGNLength": 8,
            "Rate": "As defined in protocol",
            "SPNs": []
        },
        64725: {
            "Label": "AT1P1I",
            "Name": "Aftertreatment 1 Diesel Exhaust Fluid Pump 1 Information",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                5706
            ]
        },
        64726: {
            "Label": "AT1DPF2S5",
            "Name": "Aftertreatment 1 DPF 2 Soot 5",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                5652,
                5653,
                5654,
                5655
            ]
        },
        64727: {
            "Label": "AT1DPF2S4",
            "Name": "Aftertreatment 1 DPF 2 Soot 4",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                5648,
                5649,
                5650,
                5651
            ]
        },
        64728: {
            "Label": "AT1DPF2S3",
            "Name": "Aftertreatment 1 DPF 2 Soot 3",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                5644,
                5645,
                5646,
                5647
            ]
        },
        64729: {
            "Label": "AT1DPF1S5",
            "Name": "Aftertreatment 1 DPF 1 Soot 5",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                5640,
                5641,
                5642,
                5643
            ]
        },
        64730: {
            "Label": "AT1DPF1S4",
            "Name": "Aftertreatment 1 DPF 1 Soot 4",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                5636,
                5637,
                5638,
                5639
            ]
        },
        64731: {
            "Label": "AT1DPF1S3",
            "Name": "Aftertreatment 1 DPF 1 Soot 3",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                5632,
                5633,
                5634,
                5635
            ]
        },
        64732: {
            "Label": "CCVS3",
            "Name": "Cruise Control 3",
            "PGNLength": 8,
            "Rate": "Every 1 sec and on change but no faster than 100 ms",
            "SPNs": [
                5606,
                5607,
                5608,
                5609
            ]
        },
        64733: {
            "Label": "AT2AC3",
            "Name": "Aftertreatment 2 Air Control 3",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                5590
            ]
        },
        64734: {
            "Label": "AT1AC3",
            "Name": "Aftertreatment 1 Air Control 3",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                5589
            ]
        },
        64735: {
            "Label": "EFL/P12",
            "Name": "Engine Fluid Level/Pressure 12",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                5578,
                5579,
                5580,
                5584
            ]
        },
        64736: {
            "Label": "DPFC2",
            "Name": "DPF Control 2",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                5501,
                5502,
                5503,
                5834
            ]
        },
        64737: {
            "Label": "LFE2",
            "Name": "Fuel Economy 2 (Liquid)",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                1600
            ]
        },
        64738: {
            "Label": "SFS",
            "Name": "Supplemental Fan Status",
            "PGNLength": 8,
            "Rate": "1 second",
            "SPNs": [
                5556,
                5557,
                5558,
                5559,
                5560,
                5561,
                5563,
                5562,
                5564
            ]
        },
        64739: {
            "Label": "EBCC",
            "Name": "Engine Exhaust Brake Control",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                5541,
                5542,
                5543,
                5544,
                5545
            ]
        },
        64740: {
            "Label": "EFP",
            "Name": "Engine Fuel Properties",
            "PGNLength": 8,
            "Rate": "30 seconds",
            "SPNs": [
                5537,
                5538,
                5539,
                5540
            ]
        },
        64741: {
            "Label": "HOP",
            "Name": "Hydraulic Oil Properties",
            "PGNLength": 8,
            "Rate": "30 seconds",
            "SPNs": [
                5533,
                5534,
                5535,
                5536
            ]
        },
        64742: {
            "Label": "VLS2",
            "Name": "Vehicle/Chassis Lubrication System 2",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                5515,
                5516,
                5517,
                5518,
                5519,
                5520
            ]
        },
        64743: {
            "Label": "EC3",
            "Name": "Engine Configuration 3",
            "PGNLength": 8,
            "Rate": "Every 5 s and on change of torque/speed points of more than 10% since last transmission but no faster than every 500 ms",
            "SPNs": [
                5471,
                5472,
                5473,
                5474,
                5475,
                5476,
                5477
            ]
        },
        64744: {
            "Label": "IVAC",
            "Name": "Intake Valve Actuation Control",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                5499,
                5500
            ]
        },
        64745: {
            "Label": "ARMSWIMC",
            "Name": "Armrest Switch Matrix Commands",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                1503,
                5492,
                5493,
                5494
            ]
        },
        64746: {
            "Label": "VEP4",
            "Name": "Vehicle Electrical Power #4",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                5464
            ]
        },
        64747: {
            "Label": "AFT2NAI",
            "Name": "Aftertreatment 2 NOx Adsorber Information",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                5460,
                5462
            ]
        },
        64748: {
            "Label": "AFT1NAI",
            "Name": "Aftertreatment 1 NOx Adsorber Information",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                5459,
                5461
            ]
        },
        64749: {
            "Label": "AT2WUDOC",
            "Name": "Aftertreatment 2 Warm Up Diesel Oxidation Catalyst Information",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                5315,
                5316
            ]
        },
        64750: {
            "Label": "LLRE",
            "Name": "Land Leveling System Reference Elevation Data",
            "PGNLength": 8,
            "Rate": "200 ms",
            "SPNs": [
                5410,
                5411,
                5412,
                5413
            ]
        },
        64751: {
            "Label": "EFL/P11",
            "Name": "Engine Fluid Level/Pressure 11",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                5430,
                5431
            ]
        },
        64752: {
            "Label": "EFS2",
            "Name": "Engine Fuel/lube systems 2",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                5417
            ]
        },
        64753: {
            "Label": "ETWAI",
            "Name": "Engine Turbocharger Wastegate Actuator and Exhaust Back Pressure Regulator Information",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                5384,
                5385,
                5451,
                5452,
                5625,
                5626,
                5627,
                5628,
                5788,
                5789,
                5790
            ]
        },
        64754: {
            "Label": "EFTVI",
            "Name": "Engine Fuel/Throttle Valve Information",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                5374,
                5375,
                5376,
                5377,
                5378,
                5379,
                5380,
                5381,
                5382,
                5383,
                5445,
                5446,
                5447,
                5448
            ]
        },
        64755: {
            "Label": "ETCBI",
            "Name": "Engine Turbocharger Compressor Bypass Information",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                5388,
                5389,
                5390,
                5391,
                5449,
                5450,
                5791,
                5792
            ]
        },
        64756: {
            "Label": "CAC2",
            "Name": "Charge Air Cooler 2",
            "PGNLength": 8,
            "Rate": "1 sec",
            "SPNs": [
                5292,
                5289,
                5290,
                5291
            ]
        },
        64757: {
            "Label": "CAC2P",
            "Name": "Charge Air Cooler 2 Precooler",
            "PGNLength": 8,
            "Rate": "1 sec",
            "SPNs": [
                5288,
                5286,
                5287
            ]
        },
        64758: {
            "Label": "CAC1",
            "Name": "Charge Air Cooler 1",
            "PGNLength": 8,
            "Rate": "1 sec",
            "SPNs": [
                5285,
                5283,
                5284
            ]
        },
        64759: {
            "Label": "CAC1P",
            "Name": "Charge Air Cooler 1 Precooler",
            "PGNLength": 8,
            "Rate": "1 sec",
            "SPNs": [
                5282,
                5280,
                5281
            ]
        },
        64760: {
            "Label": "DPF2S2",
            "Name": "DPF 2 Soot 2",
            "PGNLength": 8,
            "Rate": "1 sec",
            "SPNs": [
                5269,
                5270,
                5271
            ]
        },
        64761: {
            "Label": "DPF1S2",
            "Name": "DPF 1 Soot 2",
            "PGNLength": 8,
            "Rate": "1 sec",
            "SPNs": [
                5266,
                5267,
                5268
            ]
        },
        64762: {
            "Label": "EEC11",
            "Name": "Electronic Engine Controller 11",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                5264,
                5265,
                5831,
                5832
            ]
        },
        64763: {
            "Label": "EMAP",
            "Name": "Engine Manifold Actuator Position",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                5277,
                5279
            ]
        },
        64764: {
            "Label": "EMAC",
            "Name": "Engine Manifold Actuator Control",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                5276,
                5278
            ]
        },
        64765: {
            "Label": "EEC9",
            "Name": "Electronic Engine Controller 9",
            "PGNLength": 8,
            "Rate": "100 msec",
            "SPNs": [
                5262,
                5263,
                5313,
                5314
            ]
        },
        64766: {
            "Label": "EEC10",
            "Name": "Electronic Engine Controller 10",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                5260,
                5261,
                5258,
                5259
            ]
        },
        64767: {
            "Label": "ET5",
            "Name": "Engine Temperature 5",
            "PGNLength": 8,
            "Rate": "1 sec",
            "SPNs": [
                5255,
                5256
            ]
        },
        64768: {
            "Label": "EFL/P10",
            "Name": "Engine Fluid Level/Pressure 10",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                5253,
                5708,
                5252,
                5254,
                5429
            ]
        },
        64769: {
            "Label": "LVDS",
            "Name": "Low Voltage Disconnect  Status",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                5141,
                5142,
                5143,
                5144,
                5145,
                5146,
                5147,
                5148
            ]
        },
        64770: {
            "Label": "AISO",
            "Name": "All implements stop operations switch state",
            "PGNLength": 8,
            "Rate": "Every 1 s and on change of state but no faster than every 100 ms",
            "SPNs": [
                5140
            ]
        },
        64771: {
            "Label": "IOS",
            "Name": "Implement Operating State Command",
            "PGNLength": 8,
            "Rate": "Every 1 s and on change of state but no faster than every 100 ms",
            "SPNs": [
                5139
            ]
        },
        64772: {
            "Label": "DLCD2",
            "Name": "Direct Lamp Control Data 2",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                5104,
                5105,
                5106,
                5107,
                5108
            ]
        },
        64773: {
            "Label": "DLCD1",
            "Name": "Direct Lamp Control Data 1",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                5093,
                5094,
                5095,
                5096,
                5097,
                5098,
                5099,
                5100,
                5101,
                5102,
                5103,
                5470,
                5416
            ]
        },
        64774: {
            "Label": "DLCC2",
            "Name": "Direct Lamp Control Command 2",
            "PGNLength": 8,
            "Rate": "Every 1 s and on change of state but no faster than every 100 ms",
            "SPNs": [
                5087,
                5088,
                5089,
                5090,
                5091
            ]
        },
        64775: {
            "Label": "DLCC1",
            "Name": "Direct Lamp Control Command 1",
            "PGNLength": 8,
            "Rate": "Every 1 s and on change of state but no faster than every 100 ms",
            "SPNs": [
                5077,
                5078,
                5079,
                5080,
                5081,
                3987,
                5082,
                5083,
                5084,
                5085,
                5086,
                5469
            ]
        },
        64776: {
            "Label": "EOM",
            "Name": "Engine oil message",
            "PGNLength": 8,
            "Rate": "30 seconds",
            "SPNs": [
                5055,
                5056,
                5468
            ]
        },
        64777: {
            "Label": "HRLFC",
            "Name": "High Resolution Fuel Consumption (Liquid)",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                5053,
                5054
            ]
        },
        64778: {
            "Label": "AT2OGC2",
            "Name": "Aftertreatment 2 Outlet Gas NOx Sensor correction data 2",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                5048,
                5049,
                5050,
                5051,
                5719
            ]
        },
        64779: {
            "Label": "AT2OGC1",
            "Name": "Aftertreatment 2 Outlet Gas NOx Sensor correction data:8",
            "PGNLength": "On start-up",
            "Rate": " and every second until the dewpoint signal state = 1 (SPN 3240) has been received by the transmitter",
            "SPNs": [
                5047,
                5045,
                5046,
                5723
            ]
        },
        64780: {
            "Label": "AT2IGC2",
            "Name": "Aftertreatment 2 Intake Gas NOx Sensor correction data 2",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                5041,
                5042,
                5043,
                5044,
                5720
            ]
        },
        64781: {
            "Label": "AT2IGC1",
            "Name": "Aftertreatment 2 Intake Gas NOx Sensor correction data:8",
            "PGNLength": "On start-up",
            "Rate": " and every second until the dewpoint signal state = 1 (SPN 3239) has been received by the transmitter",
            "SPNs": [
                5040,
                5038,
                5039,
                5724
            ]
        },
        64782: {
            "Label": "AT1OGC2",
            "Name": "Aftertreatment 1 Outlet Gas NOx Sensor correction data 2",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                5034,
                5035,
                5036,
                5037,
                5717
            ]
        },
        64783: {
            "Label": "AT1OGC1",
            "Name": "Aftertreatment 1 Outlet Gas NOx Sensor correction data:8",
            "PGNLength": "On start-up",
            "Rate": " and every second until the dewpoint signal state = 1 (SPN 3238) has been received by the transmitter",
            "SPNs": [
                5033,
                5031,
                5032,
                5721
            ]
        },
        64784: {
            "Label": "AT1IGC2",
            "Name": "Aftertreatment 1 Intake Gas NOx Sensor correction data 2",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                5027,
                5028,
                5029,
                5030,
                5718
            ]
        },
        64785: {
            "Label": "AT1IGC1",
            "Name": "Aftertreatment 1 Intake Gas  NOx Sensor correction data:8",
            "PGNLength": "On start-up",
            "Rate": " and every second until the dewpoint signal state = 1 (SPN 3237) has been received by the transmitter",
            "SPNs": [
                5026,
                5024,
                5025,
                5722
            ]
        },
        64786: {
            "Label": "MSI1",
            "Name": "Magnet Status Information 1",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                5000,
                5001,
                5003,
                5004,
                5002,
                5005,
                5006,
                5007
            ]
        },
        64787: {
            "Label": "MSCI",
            "Name": "Magnet System Configuration Information",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                4998,
                4999
            ]
        },
        64788: {
            "Label": "BCH2",
            "Name": "Battery Charger 2",
            "PGNLength": 8,
            "Rate": "1 sec",
            "SPNs": [
                4994,
                4995,
                4996,
                4997
            ]
        },
        64789: {
            "Label": "BCH1",
            "Name": "Battery Charger 1",
            "PGNLength": 8,
            "Rate": "1 sec",
            "SPNs": [
                4990,
                4991,
                4992,
                4993
            ]
        },
        64790: {
            "Label": "OCSI",
            "Name": "Occupant Classification System Information",
            "PGNLength": 8,
            "Rate": "Transmitted every 5 sec and on change of PGN 64791 but no faster than every 250 msec",
            "SPNs": [
                4963,
                4964,
                4965,
                4966,
                4967,
                4968,
                4969,
                4970,
                4971,
                4972
            ]
        },
        64791: {
            "Label": "BDS",
            "Name": "Beltlock and Airbag Deactivation Switch Information",
            "PGNLength": 8,
            "Rate": "250 msec",
            "SPNs": [
                4952,
                4953,
                4954,
                4955,
                4956,
                4957,
                4958,
                4959,
                4960,
                4961,
                4962
            ]
        },
        64792: {
            "Label": "CSI",
            "Name": "Collision Sensor Information",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": [
                4918,
                4919,
                4920,
                4921,
                4922,
                4923,
                4924,
                4925,
                4926,
                4927,
                4928,
                4929,
                4930,
                4931,
                4932,
                4933,
                4934,
                4935,
                4936,
                4937,
                4938,
                4939,
                4940,
                4941,
                4942,
                4943,
                4944,
                4945,
                4946,
                4947,
                4948,
                4949,
                4950,
                4951
            ]
        },
        64793: {
            "Label": "ILI",
            "Name": "Ignitor Loop Information",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": [
                4818,
                4819,
                4820,
                4821,
                4822,
                4823,
                4824,
                4825,
                4826,
                4827,
                4828,
                4829,
                4830,
                4831,
                4832,
                4833,
                4834,
                4835,
                4836,
                4837,
                4838,
                4839,
                4840,
                4841,
                4842,
                4843,
                4844,
                4845,
                4846,
                4847,
                4848,
                4849,
                4850,
                4851,
                4852,
                4853,
                4854,
                4855,
                4856,
                4857,
                4858,
                4859,
                4860,
                4861,
                4862,
                4863,
                4864,
                4865,
                4866,
                4867,
                4868,
                4869,
                4870,
                4871,
                4872,
                4873,
                4874,
                4875,
                4876,
                4877,
                4878,
                4879,
                4880,
                4881,
                4882,
                4883,
                4884,
                4885,
                4886,
                4887,
                4888,
                4889,
                4890,
                4891,
                4892,
                4893,
                4894,
                4895,
                4896,
                4897,
                4898,
                4899,
                4900,
                4901,
                4902,
                4903,
                4904,
                4905,
                4906,
                4907,
                4908,
                4909,
                4910,
                4911,
                4912,
                4913,
                4914,
                4915,
                4916,
                4917
            ]
        },
        64794: {
            "Label": "AT1WUDOC",
            "Name": "Aftertreatment 1 Warm Up Diesel Oxidation Catalyst Information",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                4809,
                4810
            ]
        },
        64795: {
            "Label": "DPF2S",
            "Name": "DPF 2 Soot",
            "PGNLength": 8,
            "Rate": "1 sec",
            "SPNs": [
                4786,
                4787,
                4790,
                5570,
                4788,
                4789
            ]
        },
        64796: {
            "Label": "DPF1S",
            "Name": "DPF 1 Soot",
            "PGNLength": 8,
            "Rate": "1 sec",
            "SPNs": [
                4781,
                4782,
                4785,
                5569,
                4783,
                4784
            ]
        },
        64797: {
            "Label": "ATDT2",
            "Name": "Aftertreatment Differential Temperature 2",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                4779,
                4780
            ]
        },
        64798: {
            "Label": "ATDT1",
            "Name": "Aftertreatment Differential Temperature 1",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                4777,
                4778
            ]
        },
        64799: {
            "Label": "A2DOC",
            "Name": "Aftertreatment 2 Diesel Oxidation Catalyst",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                4774,
                4776,
                4771,
                4772,
                4773,
                4775
            ]
        },
        64800: {
            "Label": "A1DOC",
            "Name": "Aftertreatment 1 Diesel Oxidation Catalyst",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                4768,
                4770,
                4765,
                4766,
                4767,
                4769
            ]
        },
        64801: {
            "Label": "A2GOC",
            "Name": "Aftertreatment 2 Gas Oxidation Catalyst",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                4762,
                4764,
                4759,
                4760,
                4761,
                4763
            ]
        },
        64802: {
            "Label": "A1GOC",
            "Name": "Aftertreatment 1 Gas Oxidation Catalyst",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                4756,
                4758,
                4753,
                4754,
                4755,
                4757
            ]
        },
        64803: {
            "Label": " 2010: Every 100 ms or on change of state",
            "Name": "Extended Joystick Message 10:8",
            "PGNLength": "Every 100 ms and on change of state",
            "Rate": " but no faster than every 20 ms.  Grandfathered definition for systems that implemented this message prior to July",
            "SPNs": [
                4735,
                4736,
                4737,
                4739,
                4740,
                4741,
                4743,
                4744,
                4745,
                4747,
                4748,
                4749,
                4738,
                4742,
                4746
            ]
        },
        64804: {
            "Label": " 2010: Every 100 ms or on change of state",
            "Name": "Basic Joystick Message 10:8",
            "PGNLength": "Every 100 ms and on change of state",
            "Rate": " but no faster than every 20 ms. Grandfathered definition for systems that implemented this message prior to July",
            "SPNs": [
                4713,
                4714,
                4715,
                4717,
                4718,
                4719,
                4721,
                4722,
                4723,
                4724,
                4725,
                4726,
                4727,
                4728,
                4729,
                4730,
                4731,
                4732,
                4733,
                4734,
                4716,
                4720
            ]
        },
        64805: {
            "Label": " 2010: Every 100 ms or on change of state",
            "Name": "Extended Joystick Message 9:8",
            "PGNLength": "Every 100 ms and on change of state",
            "Rate": " but no faster than every 20 ms. Grandfathered definition for systems that implemented this message prior to July",
            "SPNs": [
                4698,
                4699,
                4700,
                4702,
                4703,
                4704,
                4706,
                4707,
                4708,
                4710,
                4711,
                4712,
                4701,
                4705,
                4709
            ]
        },
        64806: {
            "Label": " 2010: Every 100 ms or on change of state",
            "Name": "Basic Joystick Message 9:8",
            "PGNLength": "Every 100 ms and on change of state",
            "Rate": " but no faster than every 20 ms. Grandfathered definition for systems that implemented this message prior to July",
            "SPNs": [
                4676,
                4677,
                4678,
                4680,
                4681,
                4682,
                4684,
                4685,
                4686,
                4687,
                4688,
                4689,
                4690,
                4691,
                4692,
                4693,
                4694,
                4695,
                4696,
                4697,
                4679,
                4683
            ]
        },
        64807: {
            "Label": " 2010: Every 100 ms or on change of state",
            "Name": "Extended Joystick Message 8:8",
            "PGNLength": "Every 100 ms and on change of state",
            "Rate": " but no faster than every 20 ms.  Grandfathered definition for systems that implemented this message prior to July",
            "SPNs": [
                4661,
                4662,
                4663,
                4665,
                4666,
                4667,
                4669,
                4670,
                4671,
                4673,
                4674,
                4675,
                4664,
                4668,
                4672
            ]
        },
        64808: {
            "Label": " 2010: Every 100 ms or on change of state",
            "Name": "Basic Joystick Message 8:8",
            "PGNLength": "Every 100 ms and on change of state",
            "Rate": " but no faster than every 20 ms.  Grandfathered definition for systems that implemented this message prior to July",
            "SPNs": [
                4639,
                4640,
                4641,
                4643,
                4644,
                4645,
                4647,
                4648,
                4649,
                4650,
                4651,
                4652,
                4653,
                4654,
                4655,
                4656,
                4657,
                4658,
                4659,
                4660,
                4642,
                4646
            ]
        },
        64809: {
            "Label": " 2010: Every 100 ms or on change of state",
            "Name": "Extended Joystick Message 7:8",
            "PGNLength": "Every 100 ms and on change of state",
            "Rate": " but no faster than every 20 ms.  Grandfathered definition for systems that implemented this message prior to July",
            "SPNs": [
                4624,
                4625,
                4626,
                4628,
                4629,
                4630,
                4632,
                4633,
                4634,
                4636,
                4637,
                4638,
                4627,
                4631,
                4635
            ]
        },
        64810: {
            "Label": " 2010: Every 100 ms or on change of state",
            "Name": "Basic Joystick Message 7:8",
            "PGNLength": "Every 100 ms and on change of state",
            "Rate": " but no faster than every 20 ms.  Grandfathered definition for systems that implemented this message prior to July",
            "SPNs": [
                4602,
                4603,
                4604,
                4606,
                4607,
                4608,
                4610,
                4611,
                4612,
                4613,
                4614,
                4615,
                4616,
                4617,
                4618,
                4619,
                4620,
                4621,
                4622,
                4623,
                4605,
                4609
            ]
        },
        64811: {
            "Label": " 2010: Every 100 ms or on change of state",
            "Name": "Extended Joystick Message 6:8",
            "PGNLength": "Every 100 ms and on change of state",
            "Rate": " but no faster than every 20 ms.  Grandfathered definition for systems that implemented this message prior to July",
            "SPNs": [
                4587,
                4588,
                4589,
                4591,
                4592,
                4593,
                4595,
                4596,
                4597,
                4599,
                4600,
                4601,
                4590,
                4594,
                4598
            ]
        },
        64812: {
            "Label": " 2010: Every 100 ms or on change of state",
            "Name": "Basic Joystick Message 6:8",
            "PGNLength": "Every 100 ms and on change of state",
            "Rate": " but no faster than every 20 ms.  Grandfathered definition for systems that implemented this message prior to July",
            "SPNs": [
                4565,
                4566,
                4567,
                4569,
                4570,
                4571,
                4573,
                4574,
                4575,
                4576,
                4577,
                4578,
                4579,
                4580,
                4581,
                4582,
                4583,
                4584,
                4585,
                4586,
                4568,
                4572
            ]
        },
        64813: {
            "Label": " 2010: Every 100 ms or on change of state",
            "Name": "Extended Joystick Message 5:8",
            "PGNLength": "Every 100 ms and on change of state",
            "Rate": " but no faster than every 20 ms.  Grandfathered definition for systems that implemented this message prior to July",
            "SPNs": [
                4550,
                4551,
                4552,
                4554,
                4555,
                4556,
                4558,
                4559,
                4560,
                4562,
                4563,
                4564,
                4553,
                4557,
                4561
            ]
        },
        64814: {
            "Label": " 2010: Every 100 ms or on change of state",
            "Name": "Basic Joystick Message 5:8",
            "PGNLength": "Every 100 ms and on change of state",
            "Rate": " but no faster than every 20 ms.  Grandfathered definition for systems that implemented this message prior to July",
            "SPNs": [
                4528,
                4529,
                4530,
                4532,
                4533,
                4534,
                4536,
                4537,
                4538,
                4539,
                4540,
                4541,
                4542,
                4543,
                4544,
                4545,
                4546,
                4547,
                4548,
                4549,
                4531,
                4535
            ]
        },
        64815: {
            "Label": " 2010: Every 100 ms or on change of state",
            "Name": "Extended Joystick Message 4:8",
            "PGNLength": "Every 100 ms and on change of state",
            "Rate": " but no faster than every 20 ms.  Grandfathered definition for systems that implemented this message prior to July",
            "SPNs": [
                4513,
                4514,
                4515,
                4517,
                4518,
                4519,
                4521,
                4522,
                4523,
                4525,
                4526,
                4527,
                4516,
                4520,
                4524
            ]
        },
        64816: {
            "Label": " 2010: Every 100 ms or on change of state",
            "Name": "Basic Joystick Message 4:8",
            "PGNLength": "Every 100 ms and on change of state",
            "Rate": " but no faster than every 20 ms.  Grandfathered definition for systems that implemented this message prior to July",
            "SPNs": [
                4491,
                4492,
                4493,
                4495,
                4496,
                4497,
                4499,
                4500,
                4501,
                4502,
                4503,
                4504,
                4505,
                4506,
                4507,
                4508,
                4509,
                4510,
                4511,
                4512,
                4494,
                4498
            ]
        },
        64817: {
            "Label": "FD2",
            "Name": "Fan Drive #2",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                1550,
                1557,
                1708,
                1598,
                1707
            ]
        },
        64818: {
            "Label": "TBD",
            "Name": "Reserved for ISOBUS ECU diagnostic protocol",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": []
        },
        64819: {
            "Label": "A2DEFSI",
            "Name": "Aftertreatment 2 Diesel Exhaust Fluid Supply Information",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                4441,
                4442,
                5437,
                5438,
                5439,
                4440
            ]
        },
        64820: {
            "Label": "A2SCRRT2I",
            "Name": "Aftertreatment 2 SCR Reagant Tank 2 Information",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                4433,
                4434,
                4436,
                4437,
                4438,
                4439,
                4435
            ]
        },
        64821: {
            "Label": "A2SCRRT1I",
            "Name": "Aftertreatment 2 SCR Reagant Tank 1 Information",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                4426,
                4427,
                4429,
                4430,
                4431,
                4432,
                4428
            ]
        },
        64822: {
            "Label": "A2DEFI",
            "Name": "Aftertreatment 2 Diesel Exhaust Fluid Information",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                4420,
                4421,
                4422,
                4423,
                4424,
                4425
            ]
        },
        64823: {
            "Label": "A2SCRSI",
            "Name": "Aftertreatment 2 SCR Service Information",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                4419,
                4417,
                4418
            ]
        },
        64824: {
            "Label": "A2SCREGT",
            "Name": "Aftertreatment 2 SCR Exhaust Gas Temperature",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                4414,
                4416,
                4413,
                4415
            ]
        },
        64825: {
            "Label": "A2SCREGP",
            "Name": "Aftertreatment 2 SCR Exhaust Gas Pressures",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                4412,
                4411
            ]
        },
        64826: {
            "Label": "A2SCRDSR2",
            "Name": "Aftertreatment 2 SCR Dosing System Requests 2",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                4405,
                4406,
                4407,
                4408,
                4409,
                4410,
                5138,
                5415
            ]
        },
        64827: {
            "Label": "A2SCRDSI2",
            "Name": "Aftertreatment 2 SCR Dosing System Information 2",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                4388,
                4389,
                4390,
                4391,
                4392,
                4393,
                4394,
                4395,
                4396,
                4397,
                4398,
                4399,
                4400
            ]
        },
        64828: {
            "Label": "A1DEFSI",
            "Name": "Aftertreatment 1 Diesel Exhaust Fluid Supply Information",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                4375,
                4376,
                5434,
                5435,
                5436,
                4374
            ]
        },
        64829: {
            "Label": "A1SCRRT2I",
            "Name": "Aftertreatment 1 SCR Reagant Tank 2 Information",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                4367,
                4368,
                4370,
                4371,
                4372,
                4373,
                4369
            ]
        },
        64830: {
            "Label": "A1SCREGT",
            "Name": "Aftertreatment 1 SCR Exhaust Gas Temperature",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                4361,
                4362,
                4360,
                4363
            ]
        },
        64831: {
            "Label": "A1SCREGP",
            "Name": "Aftertreatment 1 SCR Exhaust Gas Pressures",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                4359,
                4358
            ]
        },
        64832: {
            "Label": "A1SCRDSR2",
            "Name": "Aftertreatment 1 SCR Dosing System Requests 2",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                4352,
                4353,
                4354,
                4355,
                4356,
                4357,
                5137,
                5414,
                5707
            ]
        },
        64833: {
            "Label": "A1SCRDSI2",
            "Name": "Aftertreatment 1 SCR Dosing System Information 2",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                4335,
                4336,
                4337,
                4338,
                4339,
                4340,
                4341,
                4342,
                4343,
                4344,
                4345,
                4346,
                4347
            ]
        },
        64834: {
            "Label": "ICC",
            "Name": "ISOBUS compliance certification",
            "PGNLength": 8,
            "Rate": "On request",
            "SPNs": [
                4313,
                4315,
                4324,
                4323,
                4322,
                4321,
                4320,
                4319,
                4318,
                4317,
                4329,
                4328,
                4327,
                4326,
                4325,
                4330,
                4314,
                4316
            ]
        },
        64835: {
            "Label": "MSSC",
            "Name": "Machine Selected Speed Command",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": [
                5818,
                4312,
                4310,
                4311
            ]
        },
        64836: {
            "Label": "AT2FC2",
            "Name": "Aftertreatment 2 Fuel Control 2",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                5426,
                5427,
                4303,
                5428
            ]
        },
        64837: {
            "Label": "AT2TWCC",
            "Name": "Aftertreatment 2 Three Way Catalytic Converter",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                4298,
                4300,
                4295,
                4296,
                4297,
                4299
            ]
        },
        64838: {
            "Label": "AT1TWCC",
            "Name": "Aftertreatment 1 Three Way Catalytic Converter",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                4292,
                4294,
                4289,
                4290,
                4291,
                4293
            ]
        },
        64839: {
            "Label": "TML",
            "Name": "Transmission Mode Labels",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": [
                4254
            ]
        },
        64840: {
            "Label": "O2FT2",
            "Name": "Engine Exhaust Bank 2 O2 Fuel Trim",
            "PGNLength": 8,
            "Rate": "On Request",
            "SPNs": [
                4241,
                4239,
                4238
            ]
        },
        64841: {
            "Label": "O2FT1",
            "Name": "Engine Exhaust Bank 1 O2 Fuel Trim",
            "PGNLength": 8,
            "Rate": "On Request",
            "SPNs": [
                4240,
                4237,
                4236
            ]
        },
        64842: {
            "Label": "GPM211",
            "Name": "Reserved for ISO 11992",
            "PGNLength": 8,
            "Rate": "5 sec",
            "SPNs": []
        },
        64843: {
            "Label": "GPM210",
            "Name": "Reserved for ISO 11992",
            "PGNLength": 8,
            "Rate": "10 sec",
            "SPNs": []
        },
        64844: {
            "Label": "GPM29",
            "Name": "Reserved for ISO 11992",
            "PGNLength": 8,
            "Rate": "10 sec",
            "SPNs": []
        },
        64845: {
            "Label": "GPM28",
            "Name": "Reserved for ISO 11992",
            "PGNLength": 8,
            "Rate": "5 sec",
            "SPNs": []
        },
        64846: {
            "Label": "GPM27",
            "Name": "Reserved for ISO 11992",
            "PGNLength": 8,
            "Rate": "5 sec",
            "SPNs": []
        },
        64847: {
            "Label": "GPM26",
            "Name": "Reserved for ISO 11992",
            "PGNLength": 8,
            "Rate": "5 sec",
            "SPNs": []
        },
        64848: {
            "Label": "GPM19",
            "Name": "Reserved for ISO 11992",
            "PGNLength": 8,
            "Rate": "100 ms",
            "SPNs": []
        },
        64849: {
            "Label": "ACCVC",
            "Name": "Aftercooler Coolant Control Valve Command",
            "PGNLength": 8,
            "Rate": "1 sec",
            "SPNs": [
                4198,
                4199,
                4200
            ]
        },
        64850: {
            "Label": "ECCVC",
            "Name": "Engine Coolant Control Valve Command",
            "PGNLength": 8,
            "Rate": "1 sec",
            "SPNs": [
                4195,
                4196,
                4197,
                5546,
                5547
            ]
        },
        64851: {
            "Label": "EAI",
            "Name": "Engine Average Information",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                4151,
                4153,
                4152
            ]
        },
        64852: {
            "Label": "DM52",
            "Name": "DTCs - C: Previously Active",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": [
                987,
                624,
                623,
                1213,
                3041,
                3040,
                3039,
                3038,
                1215,
                1216,
                1706,
                1214
            ]
        },
        64853: {
            "Label": "DM51",
            "Name": "DTCs - C: Confirmed and Active",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": [
                987,
                624,
                623,
                1213,
                3041,
                3040,
                3039,
                3038,
                1215,
                1216,
                1706,
                1214
            ]
        },
        64854: {
            "Label": "DM50",
            "Name": "DTCs - C: Pending",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": [
                987,
                624,
                623,
                1213,
                3041,
                3040,
                3039,
                3038,
                1215,
                1216,
                1706,
                1214
            ]
        },
        64855: {
            "Label": "DM49",
            "Name": "DTCs - B2: Previously Active",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": [
                987,
                624,
                623,
                1213,
                3041,
                3040,
                3039,
                3038,
                1215,
                1216,
                1706,
                1214
            ]
        },
        64856: {
            "Label": "DM48",
            "Name": "DTCs - B2: Confirmed and Active",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": [
                987,
                624,
                623,
                1213,
                3041,
                3040,
                3039,
                3038,
                1215,
                1216,
                1706,
                1214
            ]
        },
        64857: {
            "Label": "DM47",
            "Name": "DTCs - B2: Pending",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": [
                987,
                624,
                623,
                1213,
                3041,
                3040,
                3039,
                3038,
                1215,
                1216,
                1706,
                1214
            ]
        },
        64858: {
            "Label": "DM46",
            "Name": "DTCs - B1: Previously Active",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": [
                987,
                624,
                623,
                1213,
                3041,
                3040,
                3039,
                3038,
                1215,
                1216,
                1706,
                1214
            ]
        },
        64859: {
            "Label": "DM45",
            "Name": "DTCs - B1: Confirmed and Active",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": [
                987,
                624,
                623,
                1213,
                3041,
                3040,
                3039,
                3038,
                1215,
                1216,
                1706,
                1214
            ]
        },
        64860: {
            "Label": "DM44",
            "Name": "DTCs - B1: Pending",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": [
                987,
                624,
                623,
                1213,
                3041,
                3040,
                3039,
                3038,
                1215,
                1216,
                1706,
                1214
            ]
        },
        64861: {
            "Label": "DM43",
            "Name": "DTCs - A: Previously Active",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": [
                987,
                624,
                623,
                1213,
                3041,
                3040,
                3039,
                3038,
                1215,
                1216,
                1706,
                1214
            ]
        },
        64862: {
            "Label": "DM42",
            "Name": "DTCs - A: Confirmed and Active",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": [
                987,
                624,
                623,
                1213,
                3041,
                3040,
                3039,
                3038,
                1215,
                1216,
                1706,
                1214
            ]
        },
        64863: {
            "Label": "DM41",
            "Name": "DTCs - A: Pending",
            "PGNLength": "Variable",
            "Rate": "On request",
            "SPNs": [
                987,
                624,
                623,
                1213,
                3041,
                3040,
                3039,
                3038,
                1215,
                1216,
                1706,
                1214
            ]
        },
        64864: {
            "Label": "DM40",
            "Name": "Harmonized B1 Failure Counts (HB1C)",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        64865: {
            "Label": "DM39",
            "Name": "Cumulative Continuous MI \u2013 System (HCMI)",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        64866: {
            "Label": "DM38",
            "Name": "Harmonized Global Regulation Description (HGRD)",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        64867: {
            "Label": "DM37",
            "Name": "Harmonized Roadworthiness \u2013 System (HRWS)",
            "PGNLength": "",
            "Rate": "",
            "SPNs": []
        },
        64868: {
            "Label": "DM36",
            "Name": "Harmonized Roadworthiness - Vehicle (HRWV)",
            "PGNLength": "",
            "Rate": "",
            "SPNs": [
                4138
            ]
        },
        64869: {
            "Label": "AT1FC2",
            "Name": "Aftertreatment 1 Fuel Control 2",
            "PGNLength": 8,
            "Rate": "500 ms",
            "SPNs": [
                5423,
                5424,
                5456,
                4077,
                5425
            ]
        },
        64870: {
            "Label": "ET4",
            "Name": "Engine Temperature 4",
            "PGNLength": 8,
            "Rate": "1 s",
            "SPNs": [
                4076,
                4193,
                4194,
                4288,
                5020
            ]
        },
        64871: {
            "Label": "ZNVW",
            "Name": "Zero Net Vehicle Weight Change",
            "PGNLength": 8,
            "Rate": "As needed",
            "SPNs": [
                4075
            ]
        },
        64872: {
            "Label": "GCVW",
            "Name": "Gross Combination Vehicle Weight",
            "PGNLength": 8,
    