# Version: 6.2
# Architecture: i386
from past.builtins import xrange

import vstruct
from vstruct.primitives import *

KPROCESS_STATE = v_enum()
KPROCESS_STATE.ProcessInMemory = 0
KPROCESS_STATE.ProcessOutOfMemory = 1
KPROCESS_STATE.ProcessInTransition = 2
KPROCESS_STATE.ProcessOutTransition = 3
KPROCESS_STATE.ProcessInSwap = 4
KPROCESS_STATE.ProcessOutSwap = 5
KPROCESS_STATE.ProcessAllSwapStates = 6


MI_STORE_BIT_TYPE = v_enum()
MI_STORE_BIT_TYPE.MiStoreBitTypeInStore = 0
MI_STORE_BIT_TYPE.MiStoreBitTypeEvicted = 1
MI_STORE_BIT_TYPE.MiStoreBitTypeMax = 2


IO_ALLOCATION_ACTION = v_enum()
IO_ALLOCATION_ACTION.KeepObject = 1
IO_ALLOCATION_ACTION.DeallocateObject = 2
IO_ALLOCATION_ACTION.DeallocateObjectKeepRegisters = 3


EX_GEN_RANDOM_DOMAIN = v_enum()
EX_GEN_RANDOM_DOMAIN.ExGenRandomDomainKernel = 0
EX_GEN_RANDOM_DOMAIN.ExGenRandomDomainFirst = 0
EX_GEN_RANDOM_DOMAIN.ExGenRandomDomainUserVisible = 1
EX_GEN_RANDOM_DOMAIN.ExGenRandomDomainMax = 2


LOCK_OPERATION = v_enum()
LOCK_OPERATION.IoReadAccess = 0
LOCK_OPERATION.IoWriteAccess = 1
LOCK_OPERATION.IoModifyAccess = 2


CM_SHARE_DISPOSITION = v_enum()
CM_SHARE_DISPOSITION.CmResourceShareUndetermined = 0
CM_SHARE_DISPOSITION.CmResourceShareDeviceExclusive = 1
CM_SHARE_DISPOSITION.CmResourceShareDriverExclusive = 2
CM_SHARE_DISPOSITION.CmResourceShareShared = 3


KWAIT_BLOCK_STATE = v_enum()
KWAIT_BLOCK_STATE.WaitBlockBypassStart = 0
KWAIT_BLOCK_STATE.WaitBlockBypassComplete = 1
KWAIT_BLOCK_STATE.WaitBlockActive = 2
KWAIT_BLOCK_STATE.WaitBlockInactive = 3
KWAIT_BLOCK_STATE.WaitBlockAllStates = 4


PROCESSOR_CACHE_TYPE = v_enum()
PROCESSOR_CACHE_TYPE.CacheUnified = 0
PROCESSOR_CACHE_TYPE.CacheInstruction = 1
PROCESSOR_CACHE_TYPE.CacheData = 2
PROCESSOR_CACHE_TYPE.CacheTrace = 3


EVENT_TYPE = v_enum()
EVENT_TYPE.NotificationEvent = 0
EVENT_TYPE.SynchronizationEvent = 1


KSPIN_LOCK_QUEUE_NUMBER = v_enum()
KSPIN_LOCK_QUEUE_NUMBER.LockQueueUnusedSpare0 = 0
KSPIN_LOCK_QUEUE_NUMBER.LockQueueExpansionLock = 1
KSPIN_LOCK_QUEUE_NUMBER.LockQueueUnusedSpare2 = 2
KSPIN_LOCK_QUEUE_NUMBER.LockQueueSystemSpaceLock = 3
KSPIN_LOCK_QUEUE_NUMBER.LockQueueVacbLock = 4
KSPIN_LOCK_QUEUE_NUMBER.LockQueueMasterLock = 5
KSPIN_LOCK_QUEUE_NUMBER.LockQueueNonPagedPoolLock = 6
KSPIN_LOCK_QUEUE_NUMBER.LockQueueIoCancelLock = 7
KSPIN_LOCK_QUEUE_NUMBER.LockQueueWorkQueueLock = 8
KSPIN_LOCK_QUEUE_NUMBER.LockQueueIoVpbLock = 9
KSPIN_LOCK_QUEUE_NUMBER.LockQueueIoDatabaseLock = 10
KSPIN_LOCK_QUEUE_NUMBER.LockQueueIoCompletionLock = 11
KSPIN_LOCK_QUEUE_NUMBER.LockQueueNtfsStructLock = 12
KSPIN_LOCK_QUEUE_NUMBER.LockQueueAfdWorkQueueLock = 13
KSPIN_LOCK_QUEUE_NUMBER.LockQueueBcbLock = 14
KSPIN_LOCK_QUEUE_NUMBER.LockQueueMmNonPagedPoolLock = 15
KSPIN_LOCK_QUEUE_NUMBER.LockQueueUnusedSpare16 = 16
KSPIN_LOCK_QUEUE_NUMBER.LockQueueMaximumLock = 17


WHEA_ERROR_TYPE = v_enum()
WHEA_ERROR_TYPE.WheaErrTypeProcessor = 0
WHEA_ERROR_TYPE.WheaErrTypeMemory = 1
WHEA_ERROR_TYPE.WheaErrTypePCIExpress = 2
WHEA_ERROR_TYPE.WheaErrTypeNMI = 3
WHEA_ERROR_TYPE.WheaErrTypePCIXBus = 4
WHEA_ERROR_TYPE.WheaErrTypePCIXDevice = 5
WHEA_ERROR_TYPE.WheaErrTypeGeneric = 6


PROFILE_DEPARTURE_STYLE = v_enum()
PROFILE_DEPARTURE_STYLE.PDS_UPDATE_DEFAULT = 1
PROFILE_DEPARTURE_STYLE.PDS_UPDATE_ON_REMOVE = 2
PROFILE_DEPARTURE_STYLE.PDS_UPDATE_ON_INTERFACE = 3
PROFILE_DEPARTURE_STYLE.PDS_UPDATE_ON_EJECT = 4


OB_OPEN_REASON = v_enum()
OB_OPEN_REASON.ObCreateHandle = 0
OB_OPEN_REASON.ObOpenHandle = 1
OB_OPEN_REASON.ObDuplicateHandle = 2
OB_OPEN_REASON.ObInheritHandle = 3
OB_OPEN_REASON.ObMaxOpenReason = 4


CPU_VENDORS = v_enum()
CPU_VENDORS.CPU_NONE = 0
CPU_VENDORS.CPU_INTEL = 1
CPU_VENDORS.CPU_AMD = 2
CPU_VENDORS.CPU_CYRIX = 3
CPU_VENDORS.CPU_TRANSMETA = 4
CPU_VENDORS.CPU_VIA = 5
CPU_VENDORS.CPU_CENTAUR = 5
CPU_VENDORS.CPU_RISE = 6
CPU_VENDORS.CPU_UNKNOWN = 7


POWER_STATE_TYPE = v_enum()
POWER_STATE_TYPE.SystemPowerState = 0
POWER_STATE_TYPE.DevicePowerState = 1


TYPE_OF_MEMORY = v_enum()
TYPE_OF_MEMORY.LoaderExceptionBlock = 0
TYPE_OF_MEMORY.LoaderSystemBlock = 1
TYPE_OF_MEMORY.LoaderFree = 2
TYPE_OF_MEMORY.LoaderBad = 3
TYPE_OF_MEMORY.LoaderLoadedProgram = 4
TYPE_OF_MEMORY.LoaderFirmwareTemporary = 5
TYPE_OF_MEMORY.LoaderFirmwarePermanent = 6
TYPE_OF_MEMORY.LoaderOsloaderHeap = 7
TYPE_OF_MEMORY.LoaderOsloaderStack = 8
TYPE_OF_MEMORY.LoaderSystemCode = 9
TYPE_OF_MEMORY.LoaderHalCode = 10
TYPE_OF_MEMORY.LoaderBootDriver = 11
TYPE_OF_MEMORY.LoaderConsoleInDriver = 12
TYPE_OF_MEMORY.LoaderConsoleOutDriver = 13
TYPE_OF_MEMORY.LoaderStartupDpcStack = 14
TYPE_OF_MEMORY.LoaderStartupKernelStack = 15
TYPE_OF_MEMORY.LoaderStartupPanicStack = 16
TYPE_OF_MEMORY.LoaderStartupPcrPage = 17
TYPE_OF_MEMORY.LoaderStartupPdrPage = 18
TYPE_OF_MEMORY.LoaderRegistryData = 19
TYPE_OF_MEMORY.LoaderMemoryData = 20
TYPE_OF_MEMORY.LoaderNlsData = 21
TYPE_OF_MEMORY.LoaderSpecialMemory = 22
TYPE_OF_MEMORY.LoaderBBTMemory = 23
TYPE_OF_MEMORY.LoaderReserve = 24
TYPE_OF_MEMORY.LoaderXIPRom = 25
TYPE_OF_MEMORY.LoaderHALCachedMemory = 26
TYPE_OF_MEMORY.LoaderLargePageFiller = 27
TYPE_OF_MEMORY.LoaderErrorLogMemory = 28
TYPE_OF_MEMORY.LoaderMaximum = 29


ETW_NOTIFICATION_TYPE = v_enum()
ETW_NOTIFICATION_TYPE.EtwNotificationTypeNoReply = 1
ETW_NOTIFICATION_TYPE.EtwNotificationTypeLegacyEnable = 2
ETW_NOTIFICATION_TYPE.EtwNotificationTypeEnable = 3
ETW_NOTIFICATION_TYPE.EtwNotificationTypePrivateLogger = 4
ETW_NOTIFICATION_TYPE.EtwNotificationTypePerflib = 5
ETW_NOTIFICATION_TYPE.EtwNotificationTypeAudio = 6
ETW_NOTIFICATION_TYPE.EtwNotificationTypeSession = 7
ETW_NOTIFICATION_TYPE.EtwNotificationTypeReserved = 8
ETW_NOTIFICATION_TYPE.EtwNotificationTypeCredentialUI = 9
ETW_NOTIFICATION_TYPE.EtwNotificationTypeMax = 10


KTM_STATE = v_enum()
KTM_STATE.KKtmUninitialized = 0
KTM_STATE.KKtmInitialized = 1
KTM_STATE.KKtmRecovering = 2
KTM_STATE.KKtmOnline = 3
KTM_STATE.KKtmRecoveryFailed = 4
KTM_STATE.KKtmOffline = 5


PP_NPAGED_LOOKASIDE_NUMBER = v_enum()
PP_NPAGED_LOOKASIDE_NUMBER.LookasideSmallIrpList = 0
PP_NPAGED_LOOKASIDE_NUMBER.LookasideMediumIrpList = 1
PP_NPAGED_LOOKASIDE_NUMBER.LookasideLargeIrpList = 2
PP_NPAGED_LOOKASIDE_NUMBER.LookasideMdlList = 3
PP_NPAGED_LOOKASIDE_NUMBER.LookasideCreateInfoList = 4
PP_NPAGED_LOOKASIDE_NUMBER.LookasideNameBufferList = 5
PP_NPAGED_LOOKASIDE_NUMBER.LookasideTwilightList = 6
PP_NPAGED_LOOKASIDE_NUMBER.LookasideCompletionList = 7
PP_NPAGED_LOOKASIDE_NUMBER.LookasideScratchBufferList = 8
PP_NPAGED_LOOKASIDE_NUMBER.LookasideMaximumList = 9


PPM_IDLE_BUCKET_TIME_TYPE = v_enum()
PPM_IDLE_BUCKET_TIME_TYPE.PpmIdleBucketTimeInQpc = 0
PPM_IDLE_BUCKET_TIME_TYPE.PpmIdleBucketTimeIn100ns = 1
PPM_IDLE_BUCKET_TIME_TYPE.PpmIdleBucketTimeMaximum = 2


PLUGPLAY_EVENT_CATEGORY = v_enum()
PLUGPLAY_EVENT_CATEGORY.HardwareProfileChangeEvent = 0
PLUGPLAY_EVENT_CATEGORY.TargetDeviceChangeEvent = 1
PLUGPLAY_EVENT_CATEGORY.DeviceClassChangeEvent = 2
PLUGPLAY_EVENT_CATEGORY.CustomDeviceEvent = 3
PLUGPLAY_EVENT_CATEGORY.DeviceInstallEvent = 4
PLUGPLAY_EVENT_CATEGORY.DeviceArrivalEvent = 5
PLUGPLAY_EVENT_CATEGORY.VetoEvent = 6
PLUGPLAY_EVENT_CATEGORY.BlockedDriverEvent = 7
PLUGPLAY_EVENT_CATEGORY.InvalidIDEvent = 8
PLUGPLAY_EVENT_CATEGORY.DevicePropertyChangeEvent = 9
PLUGPLAY_EVENT_CATEGORY.DeviceInstanceRemovalEvent = 10
PLUGPLAY_EVENT_CATEGORY.DeviceInstanceStartedEvent = 11
PLUGPLAY_EVENT_CATEGORY.MaxPlugEventCategory = 12


IO_SESSION_STATE = v_enum()
IO_SESSION_STATE.IoSessionStateCreated = 1
IO_SESSION_STATE.IoSessionStateInitialized = 2
IO_SESSION_STATE.IoSessionStateConnected = 3
IO_SESSION_STATE.IoSessionStateDisconnected = 4
IO_SESSION_STATE.IoSessionStateDisconnectedLoggedOn = 5
IO_SESSION_STATE.IoSessionStateLoggedOn = 6
IO_SESSION_STATE.IoSessionStateLoggedOff = 7
IO_SESSION_STATE.IoSessionStateTerminated = 8
IO_SESSION_STATE.IoSessionStateMax = 9


PF_FILE_ACCESS_TYPE = v_enum()
PF_FILE_ACCESS_TYPE.PfFileAccessTypeRead = 0
PF_FILE_ACCESS_TYPE.PfFileAccessTypeWrite = 1
PF_FILE_ACCESS_TYPE.PfFileAccessTypeMax = 2


ARBITER_RESULT = v_enum()
ARBITER_RESULT.ArbiterResultUndefined = -1
ARBITER_RESULT.ArbiterResultSuccess = 0
ARBITER_RESULT.ArbiterResultExternalConflict = 1
ARBITER_RESULT.ArbiterResultNullRequest = 2


POWER_REQUEST_TYPE = v_enum()
POWER_REQUEST_TYPE.PowerRequestDisplayRequired = 0
POWER_REQUEST_TYPE.PowerRequestSystemRequired = 1
POWER_REQUEST_TYPE.PowerRequestAwayModeRequired = 2
POWER_REQUEST_TYPE.PowerRequestExecutionRequired = 3


POWER_REQUEST_TYPE_INTERNAL = v_enum()
POWER_REQUEST_TYPE_INTERNAL.PowerRequestDisplayRequiredInternal = 0
POWER_REQUEST_TYPE_INTERNAL.PowerRequestSystemRequiredInternal = 1
POWER_REQUEST_TYPE_INTERNAL.PowerRequestAwayModeRequiredInternal = 2
POWER_REQUEST_TYPE_INTERNAL.PowerRequestExecutionRequiredInternal = 3
POWER_REQUEST_TYPE_INTERNAL.PowerRequestPerfBoostRequiredInternal = 4
POWER_REQUEST_TYPE_INTERNAL.PowerRequestAudioAnyInternal = 5
POWER_REQUEST_TYPE_INTERNAL.PowerRequestAudioOffloadInternal = 6
POWER_REQUEST_TYPE_INTERNAL.PowerRequestVideoBatchingInternal = 7
POWER_REQUEST_TYPE_INTERNAL.PowerRequestFullScreenVideoInternal = 8
POWER_REQUEST_TYPE_INTERNAL.PowerRequestInternalInvalid = 9


POWER_ACTION = v_enum()
POWER_ACTION.PowerActionNone = 0
POWER_ACTION.PowerActionReserved = 1
POWER_ACTION.PowerActionSleep = 2
POWER_ACTION.PowerActionHibernate = 3
POWER_ACTION.PowerActionShutdown = 4
POWER_ACTION.PowerActionShutdownReset = 5
POWER_ACTION.PowerActionShutdownOff = 6
POWER_ACTION.PowerActionWarmEject = 7


ARBITER_REQUEST_SOURCE = v_enum()
ARBITER_REQUEST_SOURCE.ArbiterRequestUndefined = -1
ARBITER_REQUEST_SOURCE.ArbiterRequestLegacyReported = 0
ARBITER_REQUEST_SOURCE.ArbiterRequestHalReported = 1
ARBITER_REQUEST_SOURCE.ArbiterRequestLegacyAssigned = 2
ARBITER_REQUEST_SOURCE.ArbiterRequestPnpDetected = 3
ARBITER_REQUEST_SOURCE.ArbiterRequestPnpEnumerated = 4


KOBJECTS = v_enum()
KOBJECTS.EventNotificationObject = 0
KOBJECTS.EventSynchronizationObject = 1
KOBJECTS.MutantObject = 2
KOBJECTS.ProcessObject = 3
KOBJECTS.QueueObject = 4
KOBJECTS.SemaphoreObject = 5
KOBJECTS.ThreadObject = 6
KOBJECTS.GateObject = 7
KOBJECTS.TimerNotificationObject = 8
KOBJECTS.TimerSynchronizationObject = 9
KOBJECTS.Spare2Object = 10
KOBJECTS.Spare3Object = 11
KOBJECTS.Spare4Object = 12
KOBJECTS.Spare5Object = 13
KOBJECTS.Spare6Object = 14
KOBJECTS.Spare7Object = 15
KOBJECTS.Spare8Object = 16
KOBJECTS.ProfileCallbackObject = 17
KOBJECTS.ApcObject = 18
KOBJECTS.DpcObject = 19
KOBJECTS.DeviceQueueObject = 20
KOBJECTS.EventPairObject = 21
KOBJECTS.InterruptObject = 22
KOBJECTS.ProfileObject = 23
KOBJECTS.ThreadedDpcObject = 24
KOBJECTS.MaximumKernelObject = 25


CM_LOAD_FAILURE_TYPE = v_enum()
CM_LOAD_FAILURE_TYPE._None = 0
CM_LOAD_FAILURE_TYPE.CmInitializeHive = 1
CM_LOAD_FAILURE_TYPE.HvInitializeHive = 2
CM_LOAD_FAILURE_TYPE.HvpBuildMap = 3
CM_LOAD_FAILURE_TYPE.HvpBuildMapAndCopy = 4
CM_LOAD_FAILURE_TYPE.HvpInitMap = 5
CM_LOAD_FAILURE_TYPE.HvLoadHive = 6
CM_LOAD_FAILURE_TYPE.HvpReadFileImageAndBuildMap = 7
CM_LOAD_FAILURE_TYPE.HvpRecoverData = 8
CM_LOAD_FAILURE_TYPE.CmpValidateHiveSecurityDescriptors = 9
CM_LOAD_FAILURE_TYPE.HvpEnlistBinInMap = 10
CM_LOAD_FAILURE_TYPE.CmCheckRegistry = 11
CM_LOAD_FAILURE_TYPE.CmRegistryIO = 12
CM_LOAD_FAILURE_TYPE.CmCheckRegistry2 = 13
CM_LOAD_FAILURE_TYPE.CmpCheckKey = 14
CM_LOAD_FAILURE_TYPE.CmpCheckValueList = 15
CM_LOAD_FAILURE_TYPE.HvCheckHive = 16
CM_LOAD_FAILURE_TYPE.HvCheckBin = 17


ETW_BUFFER_STATE = v_enum()
ETW_BUFFER_STATE.EtwBufferStateFree = 0
ETW_BUFFER_STATE.EtwBufferStateGeneralLogging = 1
ETW_BUFFER_STATE.EtwBufferStateCSwitch = 2
ETW_BUFFER_STATE.EtwBufferStateFlush = 3
ETW_BUFFER_STATE.EtwBufferStateMaximum = 4


USER_ACTIVITY_PRESENCE = v_enum()
USER_ACTIVITY_PRESENCE.PowerUserPresent = 0
USER_ACTIVITY_PRESENCE.PowerUserNotPresent = 1
USER_ACTIVITY_PRESENCE.PowerUserInactive = 2
USER_ACTIVITY_PRESENCE.PowerUserMaximum = 3
USER_ACTIVITY_PRESENCE.PowerUserInvalid = 3


POWER_POLICY_DEVICE_TYPE = v_enum()
POWER_POLICY_DEVICE_TYPE.PolicyDeviceSystemButton = 0
POWER_POLICY_DEVICE_TYPE.PolicyDeviceThermalZone = 1
POWER_POLICY_DEVICE_TYPE.PolicyDeviceBattery = 2
POWER_POLICY_DEVICE_TYPE.PolicyDeviceMemory = 3
POWER_POLICY_DEVICE_TYPE.PolicyInitiatePowerActionAPI = 4
POWER_POLICY_DEVICE_TYPE.PolicySetPowerStateAPI = 5
POWER_POLICY_DEVICE_TYPE.PolicyImmediateDozeS4 = 6
POWER_POLICY_DEVICE_TYPE.PolicySystemIdle = 7
POWER_POLICY_DEVICE_TYPE.PolicyDeviceWakeAlarm = 8
POWER_POLICY_DEVICE_TYPE.PolicyDeviceMax = 9


UoWActionType = v_enum()
UoWActionType.UoWAddThisKey = 0
UoWActionType.UoWAddChildKey = 1
UoWActionType.UoWDeleteThisKey = 2
UoWActionType.UoWDeleteChildKey = 3
UoWActionType.UoWSetValueNew = 4
UoWActionType.UoWSetValueExisting = 5
UoWActionType.UoWDeleteValue = 6
UoWActionType.UoWSetKeyUserFlags = 7
UoWActionType.UoWSetLastWriteTime = 8
UoWActionType.UoWSetSecurityDescriptor = 9
UoWActionType.UoWRenameSubKey = 10
UoWActionType.UoWRenameOldSubKey = 11
UoWActionType.UoWRenameNewSubKey = 12
UoWActionType.UoWIsolation = 13
UoWActionType.UoWInvalid = 14


PERFINFO_MM_STAT = v_enum()
PERFINFO_MM_STAT.PerfInfoMMStatNotUsed = 0
PERFINFO_MM_STAT.PerfInfoMMStatAggregatePageCombine = 1
PERFINFO_MM_STAT.PerfInfoMMStatIterationPageCombine = 2
PERFINFO_MM_STAT.PerfInfoMMStatMax = 3


WHEA_ERROR_PACKET_DATA_FORMAT = v_enum()
WHEA_ERROR_PACKET_DATA_FORMAT.WheaDataFormatIPFSalRecord = 0
WHEA_ERROR_PACKET_DATA_FORMAT.WheaDataFormatXPFMCA = 1
WHEA_ERROR_PACKET_DATA_FORMAT.WheaDataFormatMemory = 2
WHEA_ERROR_PACKET_DATA_FORMAT.WheaDataFormatPCIExpress = 3
WHEA_ERROR_PACKET_DATA_FORMAT.WheaDataFormatNMIPort = 4
WHEA_ERROR_PACKET_DATA_FORMAT.WheaDataFormatPCIXBus = 5
WHEA_ERROR_PACKET_DATA_FORMAT.WheaDataFormatPCIXDevice = 6
WHEA_ERROR_PACKET_DATA_FORMAT.WheaDataFormatGeneric = 7
WHEA_ERROR_PACKET_DATA_FORMAT.WheaDataFormatMax = 8


DPFLTR_TYPE = v_enum()
DPFLTR_TYPE.DPFLTR_SYSTEM_ID = 0
DPFLTR_TYPE.DPFLTR_SMSS_ID = 1
DPFLTR_TYPE.DPFLTR_SETUP_ID = 2
DPFLTR_TYPE.DPFLTR_NTFS_ID = 3
DPFLTR_TYPE.DPFLTR_FSTUB_ID = 4
DPFLTR_TYPE.DPFLTR_CRASHDUMP_ID = 5
DPFLTR_TYPE.DPFLTR_CDAUDIO_ID = 6
DPFLTR_TYPE.DPFLTR_CDROM_ID = 7
DPFLTR_TYPE.DPFLTR_CLASSPNP_ID = 8
DPFLTR_TYPE.DPFLTR_DISK_ID = 9
DPFLTR_TYPE.DPFLTR_REDBOOK_ID = 10
DPFLTR_TYPE.DPFLTR_STORPROP_ID = 11
DPFLTR_TYPE.DPFLTR_SCSIPORT_ID = 12
DPFLTR_TYPE.DPFLTR_SCSIMINIPORT_ID = 13
DPFLTR_TYPE.DPFLTR_CONFIG_ID = 14
DPFLTR_TYPE.DPFLTR_I8042PRT_ID = 15
DPFLTR_TYPE.DPFLTR_SERMOUSE_ID = 16
DPFLTR_TYPE.DPFLTR_LSERMOUS_ID = 17
DPFLTR_TYPE.DPFLTR_KBDHID_ID = 18
DPFLTR_TYPE.DPFLTR_MOUHID_ID = 19
DPFLTR_TYPE.DPFLTR_KBDCLASS_ID = 20
DPFLTR_TYPE.DPFLTR_MOUCLASS_ID = 21
DPFLTR_TYPE.DPFLTR_TWOTRACK_ID = 22
DPFLTR_TYPE.DPFLTR_WMILIB_ID = 23
DPFLTR_TYPE.DPFLTR_ACPI_ID = 24
DPFLTR_TYPE.DPFLTR_AMLI_ID = 25
DPFLTR_TYPE.DPFLTR_HALIA64_ID = 26
DPFLTR_TYPE.DPFLTR_VIDEO_ID = 27
DPFLTR_TYPE.DPFLTR_SVCHOST_ID = 28
DPFLTR_TYPE.DPFLTR_VIDEOPRT_ID = 29
DPFLTR_TYPE.DPFLTR_TCPIP_ID = 30
DPFLTR_TYPE.DPFLTR_DMSYNTH_ID = 31
DPFLTR_TYPE.DPFLTR_NTOSPNP_ID = 32
DPFLTR_TYPE.DPFLTR_FASTFAT_ID = 33
DPFLTR_TYPE.DPFLTR_SAMSS_ID = 34
DPFLTR_TYPE.DPFLTR_PNPMGR_ID = 35
DPFLTR_TYPE.DPFLTR_NETAPI_ID = 36
DPFLTR_TYPE.DPFLTR_SCSERVER_ID = 37
DPFLTR_TYPE.DPFLTR_SCCLIENT_ID = 38
DPFLTR_TYPE.DPFLTR_SERIAL_ID = 39
DPFLTR_TYPE.DPFLTR_SERENUM_ID = 40
DPFLTR_TYPE.DPFLTR_UHCD_ID = 41
DPFLTR_TYPE.DPFLTR_RPCPROXY_ID = 42
DPFLTR_TYPE.DPFLTR_AUTOCHK_ID = 43
DPFLTR_TYPE.DPFLTR_DCOMSS_ID = 44
DPFLTR_TYPE.DPFLTR_UNIMODEM_ID = 45
DPFLTR_TYPE.DPFLTR_SIS_ID = 46
DPFLTR_TYPE.DPFLTR_FLTMGR_ID = 47
DPFLTR_TYPE.DPFLTR_WMICORE_ID = 48
DPFLTR_TYPE.DPFLTR_BURNENG_ID = 49
DPFLTR_TYPE.DPFLTR_IMAPI_ID = 50
DPFLTR_TYPE.DPFLTR_SXS_ID = 51
DPFLTR_TYPE.DPFLTR_FUSION_ID = 52
DPFLTR_TYPE.DPFLTR_IDLETASK_ID = 53
DPFLTR_TYPE.DPFLTR_SOFTPCI_ID = 54
DPFLTR_TYPE.DPFLTR_TAPE_ID = 55
DPFLTR_TYPE.DPFLTR_MCHGR_ID = 56
DPFLTR_TYPE.DPFLTR_IDEP_ID = 57
DPFLTR_TYPE.DPFLTR_PCIIDE_ID = 58
DPFLTR_TYPE.DPFLTR_FLOPPY_ID = 59
DPFLTR_TYPE.DPFLTR_FDC_ID = 60
DPFLTR_TYPE.DPFLTR_TERMSRV_ID = 61
DPFLTR_TYPE.DPFLTR_W32TIME_ID = 62
DPFLTR_TYPE.DPFLTR_PREFETCHER_ID = 63
DPFLTR_TYPE.DPFLTR_RSFILTER_ID = 64
DPFLTR_TYPE.DPFLTR_FCPORT_ID = 65
DPFLTR_TYPE.DPFLTR_PCI_ID = 66
DPFLTR_TYPE.DPFLTR_DMIO_ID = 67
DPFLTR_TYPE.DPFLTR_DMCONFIG_ID = 68
DPFLTR_TYPE.DPFLTR_DMADMIN_ID = 69
DPFLTR_TYPE.DPFLTR_WSOCKTRANSPORT_ID = 70
DPFLTR_TYPE.DPFLTR_VSS_ID = 71
DPFLTR_TYPE.DPFLTR_PNPMEM_ID = 72
DPFLTR_TYPE.DPFLTR_PROCESSOR_ID = 73
DPFLTR_TYPE.DPFLTR_DMSERVER_ID = 74
DPFLTR_TYPE.DPFLTR_SR_ID = 75
DPFLTR_TYPE.DPFLTR_INFINIBAND_ID = 76
DPFLTR_TYPE.DPFLTR_IHVDRIVER_ID = 77
DPFLTR_TYPE.DPFLTR_IHVVIDEO_ID = 78
DPFLTR_TYPE.DPFLTR_IHVAUDIO_ID = 79
DPFLTR_TYPE.DPFLTR_IHVNETWORK_ID = 80
DPFLTR_TYPE.DPFLTR_IHVSTREAMING_ID = 81
DPFLTR_TYPE.DPFLTR_IHVBUS_ID = 82
DPFLTR_TYPE.DPFLTR_HPS_ID = 83
DPFLTR_TYPE.DPFLTR_RTLTHREADPOOL_ID = 84
DPFLTR_TYPE.DPFLTR_LDR_ID = 85
DPFLTR_TYPE.DPFLTR_TCPIP6_ID = 86
DPFLTR_TYPE.DPFLTR_ISAPNP_ID = 87
DPFLTR_TYPE.DPFLTR_SHPC_ID = 88
DPFLTR_TYPE.DPFLTR_STORPORT_ID = 89
DPFLTR_TYPE.DPFLTR_STORMINIPORT_ID = 90
DPFLTR_TYPE.DPFLTR_PRINTSPOOLER_ID = 91
DPFLTR_TYPE.DPFLTR_VSSDYNDISK_ID = 92
DPFLTR_TYPE.DPFLTR_VERIFIER_ID = 93
DPFLTR_TYPE.DPFLTR_VDS_ID = 94
DPFLTR_TYPE.DPFLTR_VDSBAS_ID = 95
DPFLTR_TYPE.DPFLTR_VDSDYN_ID = 96
DPFLTR_TYPE.DPFLTR_VDSDYNDR_ID = 97
DPFLTR_TYPE.DPFLTR_VDSLDR_ID = 98
DPFLTR_TYPE.DPFLTR_VDSUTIL_ID = 99
DPFLTR_TYPE.DPFLTR_DFRGIFC_ID = 100
DPFLTR_TYPE.DPFLTR_DEFAULT_ID = 101
DPFLTR_TYPE.DPFLTR_MM_ID = 102
DPFLTR_TYPE.DPFLTR_DFSC_ID = 103
DPFLTR_TYPE.DPFLTR_WOW64_ID = 104
DPFLTR_TYPE.DPFLTR_ALPC_ID = 105
DPFLTR_TYPE.DPFLTR_WDI_ID = 106
DPFLTR_TYPE.DPFLTR_PERFLIB_ID = 107
DPFLTR_TYPE.DPFLTR_KTM_ID = 108
DPFLTR_TYPE.DPFLTR_IOSTRESS_ID = 109
DPFLTR_TYPE.DPFLTR_HEAP_ID = 110
DPFLTR_TYPE.DPFLTR_WHEA_ID = 111
DPFLTR_TYPE.DPFLTR_USERGDI_ID = 112
DPFLTR_TYPE.DPFLTR_MMCSS_ID = 113
DPFLTR_TYPE.DPFLTR_TPM_ID = 114
DPFLTR_TYPE.DPFLTR_THREADORDER_ID = 115
DPFLTR_TYPE.DPFLTR_ENVIRON_ID = 116
DPFLTR_TYPE.DPFLTR_EMS_ID = 117
DPFLTR_TYPE.DPFLTR_WDT_ID = 118
DPFLTR_TYPE.DPFLTR_FVEVOL_ID = 119
DPFLTR_TYPE.DPFLTR_NDIS_ID = 120
DPFLTR_TYPE.DPFLTR_NVCTRACE_ID = 121
DPFLTR_TYPE.DPFLTR_LUAFV_ID = 122
DPFLTR_TYPE.DPFLTR_APPCOMPAT_ID = 123
DPFLTR_TYPE.DPFLTR_USBSTOR_ID = 124
DPFLTR_TYPE.DPFLTR_SBP2PORT_ID = 125
DPFLTR_TYPE.DPFLTR_COVERAGE_ID = 126
DPFLTR_TYPE.DPFLTR_CACHEMGR_ID = 127
DPFLTR_TYPE.DPFLTR_MOUNTMGR_ID = 128
DPFLTR_TYPE.DPFLTR_CFR_ID = 129
DPFLTR_TYPE.DPFLTR_TXF_ID = 130
DPFLTR_TYPE.DPFLTR_KSECDD_ID = 131
DPFLTR_TYPE.DPFLTR_FLTREGRESS_ID = 132
DPFLTR_TYPE.DPFLTR_MPIO_ID = 133
DPFLTR_TYPE.DPFLTR_MSDSM_ID = 134
DPFLTR_TYPE.DPFLTR_UDFS_ID = 135
DPFLTR_TYPE.DPFLTR_PSHED_ID = 136
DPFLTR_TYPE.DPFLTR_STORVSP_ID = 137
DPFLTR_TYPE.DPFLTR_LSASS_ID = 138
DPFLTR_TYPE.DPFLTR_SSPICLI_ID = 139
DPFLTR_TYPE.DPFLTR_CNG_ID = 140
DPFLTR_TYPE.DPFLTR_EXFAT_ID = 141
DPFLTR_TYPE.DPFLTR_FILETRACE_ID = 142
DPFLTR_TYPE.DPFLTR_XSAVE_ID = 143
DPFLTR_TYPE.DPFLTR_SE_ID = 144
DPFLTR_TYPE.DPFLTR_DRIVEEXTENDER_ID = 145
DPFLTR_TYPE.DPFLTR_POWER_ID = 146
DPFLTR_TYPE.DPFLTR_CRASHDUMPXHCI_ID = 147
DPFLTR_TYPE.DPFLTR_GPIO_ID = 148
DPFLTR_TYPE.DPFLTR_REFS_ID = 149
DPFLTR_TYPE.DPFLTR_ENDOFTABLE_ID = 150


DMA_SPEED = v_enum()
DMA_SPEED.Compatible = 0
DMA_SPEED.TypeA = 1
DMA_SPEED.TypeB = 2
DMA_SPEED.TypeC = 3
DMA_SPEED.TypeF = 4
DMA_SPEED.MaximumDmaSpeed = 5


IO_PRIORITY_HINT = v_enum()
IO_PRIORITY_HINT.IoPriorityVeryLow = 0
IO_PRIORITY_HINT.IoPriorityLow = 1
IO_PRIORITY_HINT.IoPriorityNormal = 2
IO_PRIORITY_HINT.IoPriorityHigh = 3
IO_PRIORITY_HINT.IoPriorityCritical = 4
IO_PRIORITY_HINT.MaxIoPriorityTypes = 5


SYSTEM_POWER_CONDITION = v_enum()
SYSTEM_POWER_CONDITION.PoAc = 0
SYSTEM_POWER_CONDITION.PoDc = 1
SYSTEM_POWER_CONDITION.PoHot = 2
SYSTEM_POWER_CONDITION.PoConditionMaximum = 3


KTRANSACTION_OUTCOME = v_enum()
KTRANSACTION_OUTCOME.KTxOutcomeUninitialized = 0
KTRANSACTION_OUTCOME.KTxOutcomeUndetermined = 1
KTRANSACTION_OUTCOME.KTxOutcomeCommitted = 2
KTRANSACTION_OUTCOME.KTxOutcomeAborted = 3
KTRANSACTION_OUTCOME.KTxOutcomeUnavailable = 4


KENLISTMENT_STATE = v_enum()
KENLISTMENT_STATE.KEnlistmentUninitialized = 0
KENLISTMENT_STATE.KEnlistmentActive = 256
KENLISTMENT_STATE.KEnlistmentPreparing = 257
KENLISTMENT_STATE.KEnlistmentPrepared = 258
KENLISTMENT_STATE.KEnlistmentInDoubt = 259
KENLISTMENT_STATE.KEnlistmentCommitted = 260
KENLISTMENT_STATE.KEnlistmentCommittedNotify = 261
KENLISTMENT_STATE.KEnlistmentCommitRequested = 262
KENLISTMENT_STATE.KEnlistmentAborted = 263
KENLISTMENT_STATE.KEnlistmentDelegated = 264
KENLISTMENT_STATE.KEnlistmentDelegatedDisconnected = 265
KENLISTMENT_STATE.KEnlistmentPrePreparing = 266
KENLISTMENT_STATE.KEnlistmentForgotten = 267
KENLISTMENT_STATE.KEnlistmentRecovering = 268
KENLISTMENT_STATE.KEnlistmentAborting = 269
KENLISTMENT_STATE.KEnlistmentReadOnly = 270
KENLISTMENT_STATE.KEnlistmentOutcomeUnavailable = 271
KENLISTMENT_STATE.KEnlistmentOffline = 272
KENLISTMENT_STATE.KEnlistmentPrePrepared = 273
KENLISTMENT_STATE.KEnlistmentInitialized = 274


SE_WS_APPX_SIGNATURE_ORIGIN = v_enum()
SE_WS_APPX_SIGNATURE_ORIGIN.SE_WS_APPX_SIGNATURE_ORIGIN_NOT_VALIDATED = 0
SE_WS_APPX_SIGNATURE_ORIGIN.SE_WS_APPX_SIGNATURE_ORIGIN_UNKNOWN = 1
SE_WS_APPX_SIGNATURE_ORIGIN.SE_WS_APPX_SIGNATURE_ORIGIN_APPSTORE = 2
SE_WS_APPX_SIGNATURE_ORIGIN.SE_WS_APPX_SIGNATURE_ORIGIN_WINDOWS = 3


DMA_WIDTH = v_enum()
DMA_WIDTH.Width8Bits = 0
DMA_WIDTH.Width16Bits = 1
DMA_WIDTH.Width32Bits = 2
DMA_WIDTH.Width64Bits = 3
DMA_WIDTH.WidthNoWrap = 4
DMA_WIDTH.MaximumDmaWidth = 5


EX_POOL_PRIORITY = v_enum()
EX_POOL_PRIORITY.LowPoolPriority = 0
EX_POOL_PRIORITY.LowPoolPrioritySpecialPoolOverrun = 8
EX_POOL_PRIORITY.LowPoolPrioritySpecialPoolUnderrun = 9
EX_POOL_PRIORITY.NormalPoolPriority = 16
EX_POOL_PRIORITY.NormalPoolPrioritySpecialPoolOverrun = 24
EX_POOL_PRIORITY.NormalPoolPrioritySpecialPoolUnderrun = 25
EX_POOL_PRIORITY.HighPoolPriority = 32
EX_POOL_PRIORITY.HighPoolPrioritySpecialPoolOverrun = 40
EX_POOL_PRIORITY.HighPoolPrioritySpecialPoolUnderrun = 41


DUMP_EVENTS = v_enum()
DUMP_EVENTS.DUMP_EVENT_NONE = 0
DUMP_EVENTS.DUMP_EVENT_HIBER_RESUME = 1
DUMP_EVENTS.DUMP_EVENT_HIBER_RESUME_END = 2


KINTERRUPT_POLARITY = v_enum()
KINTERRUPT_POLARITY.InterruptPolarityUnknown = 0
KINTERRUPT_POLARITY.InterruptActiveHigh = 1
KINTERRUPT_POLARITY.InterruptRisingEdge = 1
KINTERRUPT_POLARITY.InterruptActiveLow = 2
KINTERRUPT_POLARITY.InterruptFallingEdge = 2
KINTERRUPT_POLARITY.InterruptActiveBoth = 3


PNP_VETO_TYPE = v_enum()
PNP_VETO_TYPE.PNP_VetoTypeUnknown = 0
PNP_VETO_TYPE.PNP_VetoLegacyDevice = 1
PNP_VETO_TYPE.PNP_VetoPendingClose = 2
PNP_VETO_TYPE.PNP_VetoWindowsApp = 3
PNP_VETO_TYPE.PNP_VetoWindowsService = 4
PNP_VETO_TYPE.PNP_VetoOutstandingOpen = 5
PNP_VETO_TYPE.PNP_VetoDevice = 6
PNP_VETO_TYPE.PNP_VetoDriver = 7
PNP_VETO_TYPE.PNP_VetoIllegalDeviceRequest = 8
PNP_VETO_TYPE.PNP_VetoInsufficientPower = 9
PNP_VETO_TYPE.PNP_VetoNonDisableable = 10
PNP_VETO_TYPE.PNP_VetoLegacyDriver = 11
PNP_VETO_TYPE.PNP_VetoInsufficientRights = 12


LDR_DLL_LOAD_REASON = v_enum()
LDR_DLL_LOAD_REASON.LoadReasonStaticDependency = 0
LDR_DLL_LOAD_REASON.LoadReasonStaticForwarderDependency = 1
LDR_DLL_LOAD_REASON.LoadReasonDynamicForwarderDependency = 2
LDR_DLL_LOAD_REASON.LoadReasonDelayloadDependency = 3
LDR_DLL_LOAD_REASON.LoadReasonDynamicLoad = 4
LDR_DLL_LOAD_REASON.LoadReasonAsImageLoad = 5
LDR_DLL_LOAD_REASON.LoadReasonAsDataLoad = 6
LDR_DLL_LOAD_REASON.LoadReasonUnknown = -1


KTHREAD_STATE = v_enum()
KTHREAD_STATE.Initialized = 0
KTHREAD_STATE.Ready = 1
KTHREAD_STATE.Running = 2
KTHREAD_STATE.Standby = 3
KTHREAD_STATE.Terminated = 4
KTHREAD_STATE.Waiting = 5
KTHREAD_STATE.Transition = 6
KTHREAD_STATE.DeferredReady = 7
KTHREAD_STATE.GateWaitObsolete = 8


DEVPROP_OPERATOR = v_enum()
DEVPROP_OPERATOR.DEVPROP_OPERATOR_MODIFIER_NOT = 65536
DEVPROP_OPERATOR.DEVPROP_OPERATOR_MODIFIER_IGNORE_CASE = 131072
DEVPROP_OPERATOR.DEVPROP_OPERATOR_NONE = 0
DEVPROP_OPERATOR.DEVPROP_OPERATOR_EXISTS = 1
DEVPROP_OPERATOR.DEVPROP_OPERATOR_EQUALS = 2
DEVPROP_OPERATOR.DEVPROP_OPERATOR_NOT_EQUALS = 65538
DEVPROP_OPERATOR.DEVPROP_OPERATOR_GREATER_THAN = 3
DEVPROP_OPERATOR.DEVPROP_OPERATOR_LESS_THAN = 4
DEVPROP_OPERATOR.DEVPROP_OPERATOR_GREATER_THAN_EQUALS = 5
DEVPROP_OPERATOR.DEVPROP_OPERATOR_LESS_THAN_EQUALS = 6
DEVPROP_OPERATOR.DEVPROP_OPERATOR_EQUALS_IGNORE_CASE = 131074
DEVPROP_OPERATOR.DEVPROP_OPERATOR_NOT_EQUALS_IGNORE_CASE = 196610
DEVPROP_OPERATOR.DEVPROP_OPERATOR_BITWISE_AND = 7
DEVPROP_OPERATOR.DEVPROP_OPERATOR_BITWISE_OR = 8
DEVPROP_OPERATOR.DEVPROP_OPERATOR_LIST_CONTAINS = 4096
DEVPROP_OPERATOR.DEVPROP_OPERATOR_LIST_CONTAINS_IGNORE_CASE = 135168
DEVPROP_OPERATOR.DEVPROP_OPERATOR_AND_OPEN = 1048576
DEVPROP_OPERATOR.DEVPROP_OPERATOR_AND_CLOSE = 2097152
DEVPROP_OPERATOR.DEVPROP_OPERATOR_OR_OPEN = 3145728
DEVPROP_OPERATOR.DEVPROP_OPERATOR_OR_CLOSE = 4194304
DEVPROP_OPERATOR.DEVPROP_OPERATOR_NOT_OPEN = 5242880
DEVPROP_OPERATOR.DEVPROP_OPERATOR_NOT_CLOSE = 6291456
DEVPROP_OPERATOR.DEVPROP_OPERATOR_MASK_EVAL = 4095
DEVPROP_OPERATOR.DEVPROP_OPERATOR_MASK_LIST = 61440
DEVPROP_OPERATOR.DEVPROP_OPERATOR_MASK_MODIFIER = 983040
DEVPROP_OPERATOR.DEVPROP_OPERATOR_MASK_NOT_LOGICAL = 1048575
DEVPROP_OPERATOR.DEVPROP_OPERATOR_MASK_LOGICAL = -1048576


SECURITY_IMPERSONATION_LEVEL = v_enum()
SECURITY_IMPERSONATION_LEVEL.SecurityAnonymous = 0
SECURITY_IMPERSONATION_LEVEL.SecurityIdentification = 1
SECURITY_IMPERSONATION_LEVEL.SecurityImpersonation = 2
SECURITY_IMPERSONATION_LEVEL.SecurityDelegation = 3


TOKEN_INFORMATION_CLASS = v_enum()
TOKEN_INFORMATION_CLASS.TokenUser = 1
TOKEN_INFORMATION_CLASS.TokenGroups = 2
TOKEN_INFORMATION_CLASS.TokenPrivileges = 3
TOKEN_INFORMATION_CLASS.TokenOwner = 4
TOKEN_INFORMATION_CLASS.TokenPrimaryGroup = 5
TOKEN_INFORMATION_CLASS.TokenDefaultDacl = 6
TOKEN_INFORMATION_CLASS.TokenSource = 7
TOKEN_INFORMATION_CLASS.TokenType = 8
TOKEN_INFORMATION_CLASS.TokenImpersonationLevel = 9
TOKEN_INFORMATION_CLASS.TokenStatistics = 10
TOKEN_INFORMATION_CLASS.TokenRestrictedSids = 11
TOKEN_INFORMATION_CLASS.TokenSessionId = 12
TOKEN_INFORMATION_CLASS.TokenGroupsAndPrivileges = 13
TOKEN_INFORMATION_CLASS.TokenSessionReference = 14
TOKEN_INFORMATION_CLASS.TokenSandBoxInert = 15
TOKEN_INFORMATION_CLASS.TokenAuditPolicy = 16
TOKEN_INFORMATION_CLASS.TokenOrigin = 17
TOKEN_INFORMATION_CLASS.TokenElevationType = 18
TOKEN_INFORMATION_CLASS.TokenLinkedToken = 19
TOKEN_INFORMATION_CLASS.TokenElevation = 20
TOKEN_INFORMATION_CLASS.TokenHasRestrictions = 21
TOKEN_INFORMATION_CLASS.TokenAccessInformation = 22
TOKEN_INFORMATION_CLASS.TokenVirtualizationAllowed = 23
TOKEN_INFORMATION_CLASS.TokenVirtualizationEnabled = 24
TOKEN_INFORMATION_CLASS.TokenIntegrityLevel = 25
TOKEN_INFORMATION_CLASS.TokenUIAccess = 26
TOKEN_INFORMATION_CLASS.TokenMandatoryPolicy = 27
TOKEN_INFORMATION_CLASS.TokenLogonSid = 28
TOKEN_INFORMATION_CLASS.TokenIsAppContainer = 29
TOKEN_INFORMATION_CLASS.TokenCapabilities = 30
TOKEN_INFORMATION_CLASS.TokenAppContainerSid = 31
TOKEN_INFORMATION_CLASS.TokenAppContainerNumber = 32
TOKEN_INFORMATION_CLASS.TokenUserClaimAttributes = 33
TOKEN_INFORMATION_CLASS.TokenDeviceClaimAttributes = 34
TOKEN_INFORMATION_CLASS.TokenRestrictedUserClaimAttributes = 35
TOKEN_INFORMATION_CLASS.TokenRestrictedDeviceClaimAttributes = 36
TOKEN_INFORMATION_CLASS.TokenDeviceGroups = 37
TOKEN_INFORMATION_CLASS.TokenRestrictedDeviceGroups = 38
TOKEN_INFORMATION_CLASS.TokenSecurityAttributes = 39
TOKEN_INFORMATION_CLASS.TokenIsRestricted = 40
TOKEN_INFORMATION_CLASS.MaxTokenInfoClass = 41


KRESOURCEMANAGER_STATE = v_enum()
KRESOURCEMANAGER_STATE.KResourceManagerUninitialized = 0
KRESOURCEMANAGER_STATE.KResourceManagerOffline = 1
KRESOURCEMANAGER_STATE.KResourceManagerOnline = 2


ALTERNATIVE_ARCHITECTURE_TYPE = v_enum()
ALTERNATIVE_ARCHITECTURE_TYPE.StandardDesign = 0
ALTERNATIVE_ARCHITECTURE_TYPE.NEC98x86 = 1
ALTERNATIVE_ARCHITECTURE_TYPE.EndAlternatives = 2


PCW_CALLBACK_TYPE = v_enum()
PCW_CALLBACK_TYPE.PcwCallbackAddCounter = 0
PCW_CALLBACK_TYPE.PcwCallbackRemoveCounter = 1
PCW_CALLBACK_TYPE.PcwCallbackEnumerateInstances = 2
PCW_CALLBACK_TYPE.PcwCallbackCollectData = 3


REQUESTER_TYPE = v_enum()
REQUESTER_TYPE.KernelRequester = 0
REQUESTER_TYPE.UserProcessRequester = 1
REQUESTER_TYPE.UserSharedServiceRequester = 2


JOBOBJECTINFOCLASS = v_enum()
JOBOBJECTINFOCLASS.JobObjectBasicAccountingInformation = 1
JOBOBJECTINFOCLASS.JobObjectBasicLimitInformation = 2
JOBOBJECTINFOCLASS.JobObjectBasicProcessIdList = 3
JOBOBJECTINFOCLASS.JobObjectBasicUIRestrictions = 4
JOBOBJECTINFOCLASS.JobObjectSecurityLimitInformation = 5
JOBOBJECTINFOCLASS.JobObjectEndOfJobTimeInformation = 6
JOBOBJECTINFOCLASS.JobObjectAssociateCompletionPortInformation = 7
JOBOBJECTINFOCLASS.JobObjectBasicAndIoAccountingInformation = 8
JOBOBJECTINFOCLASS.JobObjectExtendedLimitInformation = 9
JOBOBJECTINFOCLASS.JobObjectJobSetInformation = 10
JOBOBJECTINFOCLASS.JobObjectGroupInformation = 11
JOBOBJECTINFOCLASS.JobObjectNotificationLimitInformation = 12
JOBOBJECTINFOCLASS.JobObjectLimitViolationInformation = 13
JOBOBJECTINFOCLASS.JobObjectGroupInformationEx = 14
JOBOBJECTINFOCLASS.JobObjectCpuRateControlInformation = 15
JOBOBJECTINFOCLASS.JobObjectCompletionFilter = 16
JOBOBJECTINFOCLASS.JobObjectCompletionCounter = 17
JOBOBJECTINFOCLASS.JobObjectFreezeInformation = 18
JOBOBJECTINFOCLASS.JobObjectExtendedAccountingInformation = 19
JOBOBJECTINFOCLASS.JobObjectWakeInformation = 20
JOBOBJECTINFOCLASS.JobObjectBackgroundInformation = 21
JOBOBJECTINFOCLASS.JobObjectSchedulingRankBiasInformation = 22
JOBOBJECTINFOCLASS.JobObjectTimerVirtualizationInformation = 23
JOBOBJECTINFOCLASS.JobObjectCycleTimeNotification = 24
JOBOBJECTINFOCLASS.JobObjectClearEvent = 25
JOBOBJECTINFOCLASS.JobObjectReserved1Information = 18
JOBOBJECTINFOCLASS.JobObjectReserved2Information = 19
JOBOBJECTINFOCLASS.JobObjectReserved3Information = 20
JOBOBJECTINFOCLASS.JobObjectReserved4Information = 21
JOBOBJECTINFOCLASS.JobObjectReserved5Information = 22
JOBOBJECTINFOCLASS.JobObjectReserved6Information = 23
JOBOBJECTINFOCLASS.JobObjectReserved7Information = 24
JOBOBJECTINFOCLASS.JobObjectReserved8Information = 25
JOBOBJECTINFOCLASS.MaxJobObjectInfoClass = 26


SYSTEM_POWER_STATE = v_enum()
SYSTEM_POWER_STATE.PowerSystemUnspecified = 0
SYSTEM_POWER_STATE.PowerSystemWorking = 1
SYSTEM_POWER_STATE.PowerSystemSleeping1 = 2
SYSTEM_POWER_STATE.PowerSystemSleeping2 = 3
SYSTEM_POWER_STATE.PowerSystemSleeping3 = 4
SYSTEM_POWER_STATE.PowerSystemHibernate = 5
SYSTEM_POWER_STATE.PowerSystemShutdown = 6
SYSTEM_POWER_STATE.PowerSystemMaximum = 7


MEMORY_CACHING_TYPE_ORIG = v_enum()
MEMORY_CACHING_TYPE_ORIG.MmFrameBufferCached = 2


PROFILE_STATUS = v_enum()
PROFILE_STATUS.DOCK_NOTDOCKDEVICE = 0
PROFILE_STATUS.DOCK_QUIESCENT = 1
PROFILE_STATUS.DOCK_ARRIVING = 2
PROFILE_STATUS.DOCK_DEPARTING = 3
PROFILE_STATUS.DOCK_EJECTIRP_COMPLETED = 4


MM_POOL_PRIORITIES = v_enum()
MM_POOL_PRIORITIES.MmHighPriority = 0
MM_POOL_PRIORITIES.MmNormalPriority = 1
MM_POOL_PRIORITIES.MmLowPriority = 2
MM_POOL_PRIORITIES.MmMaximumPoolPriority = 3


BLOB_ID = v_enum()
BLOB_ID.BLOB_TYPE_UNKNOWN = 0
BLOB_ID.BLOB_TYPE_CONNECTION_INFO = 1
BLOB_ID.BLOB_TYPE_MESSAGE = 2
BLOB_ID.BLOB_TYPE_SECURITY_CONTEXT = 3
BLOB_ID.BLOB_TYPE_SECTION = 4
BLOB_ID.BLOB_TYPE_REGION = 5
BLOB_ID.BLOB_TYPE_VIEW = 6
BLOB_ID.BLOB_TYPE_RESERVE = 7
BLOB_ID.BLOB_TYPE_DIRECT_TRANSFER = 8
BLOB_ID.BLOB_TYPE_HANDLE_DATA = 9
BLOB_ID.BLOB_TYPE_MAX_ID = 10


WHEA_ERROR_SOURCE_STATE = v_enum()
WHEA_ERROR_SOURCE_STATE.WheaErrSrcStateStopped = 1
WHEA_ERROR_SOURCE_STATE.WheaErrSrcStateStarted = 2


REG_NOTIFY_CLASS = v_enum()
REG_NOTIFY_CLASS.RegNtDeleteKey = 0
REG_NOTIFY_CLASS.RegNtPreDeleteKey = 0
REG_NOTIFY_CLASS.RegNtSetValueKey = 1
REG_NOTIFY_CLASS.RegNtPreSetValueKey = 1
REG_NOTIFY_CLASS.RegNtDeleteValueKey = 2
REG_NOTIFY_CLASS.RegNtPreDeleteValueKey = 2
REG_NOTIFY_CLASS.RegNtSetInformationKey = 3
REG_NOTIFY_CLASS.RegNtPreSetInformationKey = 3
REG_NOTIFY_CLASS.RegNtRenameKey = 4
REG_NOTIFY_CLASS.RegNtPreRenameKey = 4
REG_NOTIFY_CLASS.RegNtEnumerateKey = 5
REG_NOTIFY_CLASS.RegNtPreEnumerateKey = 5
REG_NOTIFY_CLASS.RegNtEnumerateValueKey = 6
REG_NOTIFY_CLASS.RegNtPreEnumerateValueKey = 6
REG_NOTIFY_CLASS.RegNtQueryKey = 7
REG_NOTIFY_CLASS.RegNtPreQueryKey = 7
REG_NOTIFY_CLASS.RegNtQueryValueKey = 8
REG_NOTIFY_CLASS.RegNtPreQueryValueKey = 8
REG_NOTIFY_CLASS.RegNtQueryMultipleValueKey = 9
REG_NOTIFY_CLASS.RegNtPreQueryMultipleValueKey = 9
REG_NOTIFY_CLASS.RegNtPreCreateKey = 10
REG_NOTIFY_CLASS.RegNtPostCreateKey = 11
REG_NOTIFY_CLASS.RegNtPreOpenKey = 12
REG_NOTIFY_CLASS.RegNtPostOpenKey = 13
REG_NOTIFY_CLASS.RegNtKeyHandleClose = 14
REG_NOTIFY_CLASS.RegNtPreKeyHandleClose = 14
REG_NOTIFY_CLASS.RegNtPostDeleteKey = 15
REG_NOTIFY_CLASS.RegNtPostSetValueKey = 16
REG_NOTIFY_CLASS.RegNtPostDeleteValueKey = 17
REG_NOTIFY_CLASS.RegNtPostSetInformationKey = 18
REG_NOTIFY_CLASS.RegNtPostRenameKey = 19
REG_NOTIFY_CLASS.RegNtPostEnumerateKey = 20
REG_NOTIFY_CLASS.RegNtPostEnumerateValueKey = 21
REG_NOTIFY_CLASS.RegNtPostQueryKey = 22
REG_NOTIFY_CLASS.RegNtPostQueryValueKey = 23
REG_NOTIFY_CLASS.RegNtPostQueryMultipleValueKey = 24
REG_NOTIFY_CLASS.RegNtPostKeyHandleClose = 25
REG_NOTIFY_CLASS.RegNtPreCreateKeyEx = 26
REG_NOTIFY_CLASS.RegNtPostCreateKeyEx = 27
REG_NOTIFY_CLASS.RegNtPreOpenKeyEx = 28
REG_NOTIFY_CLASS.RegNtPostOpenKeyEx = 29
REG_NOTIFY_CLASS.RegNtPreFlushKey = 30
REG_NOTIFY_CLASS.RegNtPostFlushKey = 31
REG_NOTIFY_CLASS.RegNtPreLoadKey = 32
REG_NOTIFY_CLASS.RegNtPostLoadKey = 33
REG_NOTIFY_CLASS.RegNtPreUnLoadKey = 34
REG_NOTIFY_CLASS.RegNtPostUnLoadKey = 35
REG_NOTIFY_CLASS.RegNtPreQueryKeySecurity = 36
REG_NOTIFY_CLASS.RegNtPostQueryKeySecurity = 37
REG_NOTIFY_CLASS.RegNtPreSetKeySecurity = 38
REG_NOTIFY_CLASS.RegNtPostSetKeySecurity = 39
REG_NOTIFY_CLASS.RegNtCallbackObjectContextCleanup = 40
REG_NOTIFY_CLASS.RegNtPreRestoreKey = 41
REG_NOTIFY_CLASS.RegNtPostRestoreKey = 42
REG_NOTIFY_CLASS.RegNtPreSaveKey = 43
REG_NOTIFY_CLASS.RegNtPostSaveKey = 44
REG_NOTIFY_CLASS.RegNtPreReplaceKey = 45
REG_NOTIFY_CLASS.RegNtPostReplaceKey = 46
REG_NOTIFY_CLASS.MaxRegNtNotifyClass = 47


MM_POOL_FAILURE_REASONS = v_enum()
MM_POOL_FAILURE_REASONS.MmNonPagedNoPtes = 0
MM_POOL_FAILURE_REASONS.MmPriorityTooLow = 1
MM_POOL_FAILURE_REASONS.MmNonPagedNoPagesAvailable = 2
MM_POOL_FAILURE_REASONS.MmPagedNoPtes = 3
MM_POOL_FAILURE_REASONS.MmSessionPagedNoPtes = 4
MM_POOL_FAILURE_REASONS.MmPagedNoPagesAvailable = 5
MM_POOL_FAILURE_REASONS.MmSessionPagedNoPagesAvailable = 6
MM_POOL_FAILURE_REASONS.MmPagedNoCommit = 7
MM_POOL_FAILURE_REASONS.MmSessionPagedNoCommit = 8
MM_POOL_FAILURE_REASONS.MmNonPagedNoResidentAvailable = 9
MM_POOL_FAILURE_REASONS.MmNonPagedNoCommit = 10
MM_POOL_FAILURE_REASONS.MmMaximumFailureReason = 11


BUS_QUERY_ID_TYPE = v_enum()
BUS_QUERY_ID_TYPE.BusQueryDeviceID = 0
BUS_QUERY_ID_TYPE.BusQueryHardwareIDs = 1
BUS_QUERY_ID_TYPE.BusQueryCompatibleIDs = 2
BUS_QUERY_ID_TYPE.BusQueryInstanceID = 3
BUS_QUERY_ID_TYPE.BusQueryDeviceSerialNumber = 4
BUS_QUERY_ID_TYPE.BusQueryContainerID = 5


PROC_HYPERVISOR_STATE = v_enum()
PROC_HYPERVISOR_STATE.ProcHypervisorNone = 0
PROC_HYPERVISOR_STATE.ProcHypervisorPresent = 1
PROC_HYPERVISOR_STATE.ProcHypervisorPower = 2


MM_PREEMPTIVE_TRIMS = v_enum()
MM_PREEMPTIVE_TRIMS.MmPreemptForNonPaged = 0
MM_PREEMPTIVE_TRIMS.MmPreemptForPaged = 1
MM_PREEMPTIVE_TRIMS.MmPreemptForNonPagedPriority = 2
MM_PREEMPTIVE_TRIMS.MmPreemptForPagedPriority = 3
MM_PREEMPTIVE_TRIMS.MmMaximumPreempt = 4


TRACE_INFORMATION_CLASS = v_enum()
TRACE_INFORMATION_CLASS.TraceIdClass = 0
TRACE_INFORMATION_CLASS.TraceHandleClass = 1
TRACE_INFORMATION_CLASS.TraceEnableFlagsClass = 2
TRACE_INFORMATION_CLASS.TraceEnableLevelClass = 3
TRACE_INFORMATION_CLASS.GlobalLoggerHandleClass = 4
TRACE_INFORMATION_CLASS.EventLoggerHandleClass = 5
TRACE_INFORMATION_CLASS.AllLoggerHandlesClass = 6
TRACE_INFORMATION_CLASS.TraceHandleByNameClass = 7
TRACE_INFORMATION_CLASS.LoggerEventsLostClass = 8
TRACE_INFORMATION_CLASS.TraceSessionSettingsClass = 9
TRACE_INFORMATION_CLASS.LoggerEventsLoggedClass = 10
TRACE_INFORMATION_CLASS.DiskIoNotifyRoutinesClass = 11
TRACE_INFORMATION_CLASS.TraceInformationClassReserved1 = 12
TRACE_INFORMATION_CLASS.AllPossibleNotifyRoutinesClass = 12
TRACE_INFORMATION_CLASS.FltIoNotifyRoutinesClass = 13
TRACE_INFORMATION_CLASS.TraceInformationClassReserved2 = 14
TRACE_INFORMATION_CLASS.HypervisorStackwalkRoutineClass = 14
TRACE_INFORMATION_CLASS.WdfNotifyRoutinesClass = 15
TRACE_INFORMATION_CLASS.MaxTraceInformationClass = 16


WHEA_ERROR_SEVERITY = v_enum()
WHEA_ERROR_SEVERITY.WheaErrSevRecoverable = 0
WHEA_ERROR_SEVERITY.WheaErrSevFatal = 1
WHEA_ERROR_SEVERITY.WheaErrSevCorrected = 2
WHEA_ERROR_SEVERITY.WheaErrSevInformational = 3


VI_DEADLOCK_RESOURCE_TYPE = v_enum()
VI_DEADLOCK_RESOURCE_TYPE.VfDeadlockUnknown = 0
VI_DEADLOCK_RESOURCE_TYPE.VfDeadlockMutex = 1
VI_DEADLOCK_RESOURCE_TYPE.VfDeadlockMutexAbandoned = 2
VI_DEADLOCK_RESOURCE_TYPE.VfDeadlockFastMutex = 3
VI_DEADLOCK_RESOURCE_TYPE.VfDeadlockFastMutexUnsafe = 4
VI_DEADLOCK_RESOURCE_TYPE.VfDeadlockSpinLock = 5
VI_DEADLOCK_RESOURCE_TYPE.VfDeadlockInStackQueuedSpinLock = 6
VI_DEADLOCK_RESOURCE_TYPE.VfDeadlockUnusedSpinLock = 7
VI_DEADLOCK_RESOURCE_TYPE.VfDeadlockEresource = 8
VI_DEADLOCK_RESOURCE_TYPE.VfDeadlockTypeMaximum = 9


KWAIT_STATE = v_enum()
KWAIT_STATE.WaitInProgress = 0
KWAIT_STATE.WaitCommitted = 1
KWAIT_STATE.WaitAborted = 2
KWAIT_STATE.MaximumWaitState = 3


OBJECT_INFORMATION_CLASS = v_enum()
OBJECT_INFORMATION_CLASS.ObjectBasicInformation = 0
OBJECT_INFORMATION_CLASS.ObjectNameInformation = 1
OBJECT_INFORMATION_CLASS.ObjectTypeInformation = 2
OBJECT_INFORMATION_CLASS.ObjectTypesInformation = 3
OBJECT_INFORMATION_CLASS.ObjectHandleFlagInformation = 4
OBJECT_INFORMATION_CLASS.ObjectSessionInformation = 5
OBJECT_INFORMATION_CLASS.MaxObjectInfoClass = 6


ARBITER_ACTION = v_enum()
ARBITER_ACTION.ArbiterActionTestAllocation = 0
ARBITER_ACTION.ArbiterActionRetestAllocation = 1
ARBITER_ACTION.ArbiterActionCommitAllocation = 2
ARBITER_ACTION.ArbiterActionRollbackAllocation = 3
ARBITER_ACTION.ArbiterActionQueryAllocatedResources = 4
ARBITER_ACTION.ArbiterActionWriteReservedResources = 5
ARBITER_ACTION.ArbiterActionQueryConflict = 6
ARBITER_ACTION.ArbiterActionQueryArbitrate = 7
ARBITER_ACTION.ArbiterActionAddReserved = 8
ARBITER_ACTION.ArbiterActionBootAllocation = 9


PROCESS_VA_TYPE = v_enum()
PROCESS_VA_TYPE.ProcessVAImage = 0
PROCESS_VA_TYPE.ProcessVASection = 1
PROCESS_VA_TYPE.ProcessVAPrivate = 2
PROCESS_VA_TYPE.ProcessVAMax = 3


HEAP_FAILURE_TYPE = v_enum()
HEAP_FAILURE_TYPE.heap_failure_internal = 0
HEAP_FAILURE_TYPE.heap_failure_unknown = 1
HEAP_FAILURE_TYPE.heap_failure_generic = 2
HEAP_FAILURE_TYPE.heap_failure_entry_corruption = 3
HEAP_FAILURE_TYPE.heap_failure_multiple_entries_corruption = 4
HEAP_FAILURE_TYPE.heap_failure_virtual_block_corruption = 5
HEAP_FAILURE_TYPE.heap_failure_buffer_overrun = 6
HEAP_FAILURE_TYPE.heap_failure_buffer_underrun = 7
HEAP_FAILURE_TYPE.heap_failure_block_not_busy = 8
HEAP_FAILURE_TYPE.heap_failure_invalid_argument = 9
HEAP_FAILURE_TYPE.heap_failure_usage_after_free = 10
HEAP_FAILURE_TYPE.heap_failure_cross_heap_operation = 11
HEAP_FAILURE_TYPE.heap_failure_freelists_corruption = 12
HEAP_FAILURE_TYPE.heap_failure_listentry_corruption = 13
HEAP_FAILURE_TYPE.heap_failure_lfh_bitmap_mismatch = 14


MM_POOL_TYPES = v_enum()
MM_POOL_TYPES.MmNonPagedPool = 0
MM_POOL_TYPES.MmPagedPool = 1
MM_POOL_TYPES.MmSessionPagedPool = 2
MM_POOL_TYPES.MmMaximumPoolType = 3


POP_DEVICE_IDLE_TYPE = v_enum()
POP_DEVICE_IDLE_TYPE.DeviceIdleNormal = 0
POP_DEVICE_IDLE_TYPE.DeviceIdleDisk = 1


PS_WAKE_REASON = v_enum()
PS_WAKE_REASON.PsWakeReasonUser = 0
PS_WAKE_REASON.PsWakeReasonExecutionRequired = 1
PS_WAKE_REASON.PsWakeReasonKernel = 2
PS_WAKE_REASON.PsWakeReasonInstrumentation = 3
PS_WAKE_REASON.PsMaxWakeReasons = 4


WORK_QUEUE_TYPE = v_enum()
WORK_QUEUE_TYPE.CriticalWorkQueue = 0
WORK_QUEUE_TYPE.DelayedWorkQueue = 1
WORK_QUEUE_TYPE.HyperCriticalWorkQueue = 2
WORK_QUEUE_TYPE.NormalWorkQueue = 3
WORK_QUEUE_TYPE.BackgroundWorkQueue = 4
WORK_QUEUE_TYPE.RealTimeWorkQueue = 5
WORK_QUEUE_TYPE.SuperCriticalWorkQueue = 6
WORK_QUEUE_TYPE.MaximumWorkQueue = 7
WORK_QUEUE_TYPE.CustomPriorityWorkQueue = 32


KTRANSACTION_STATE = v_enum()
KTRANSACTION_STATE.KTransactionUninitialized = 0
KTRANSACTION_STATE.KTransactionActive = 1
KTRANSACTION_STATE.KTransactionPreparing = 2
KTRANSACTION_STATE.KTransactionPrepared = 3
KTRANSACTION_STATE.KTransactionInDoubt = 4
KTRANSACTION_STATE.KTransactionCommitted = 5
KTRANSACTION_STATE.KTransactionAborted = 6
KTRANSACTION_STATE.KTransactionDelegated = 7
KTRANSACTION_STATE.KTransactionPrePreparing = 8
KTRANSACTION_STATE.KTransactionForgotten = 9
KTRANSACTION_STATE.KTransactionRecovering = 10
KTRANSACTION_STATE.KTransactionPrePrepared = 11


EXCEPTION_DISPOSITION = v_enum()
EXCEPTION_DISPOSITION.ExceptionContinueExecution = 0
EXCEPTION_DISPOSITION.ExceptionContinueSearch = 1
EXCEPTION_DISPOSITION.ExceptionNestedException = 2
EXCEPTION_DISPOSITION.ExceptionCollidedUnwind = 3


SECURITY_OPERATION_CODE = v_enum()
SECURITY_OPERATION_CODE.SetSecurityDescriptor = 0
SECURITY_OPERATION_CODE.QuerySecurityDescriptor = 1
SECURITY_OPERATION_CODE.DeleteSecurityDescriptor = 2
SECURITY_OPERATION_CODE.AssignSecurityDescriptor = 3


IRPLOCK = v_enum()
IRPLOCK.IRPLOCK_CANCELABLE = 0
IRPLOCK.IRPLOCK_CANCEL_STARTED = 1
IRPLOCK.IRPLOCK_CANCEL_COMPLETE = 2
IRPLOCK.IRPLOCK_COMPLETED = 3


FS_FILTER_STREAM_FO_NOTIFICATION_TYPE = v_enum()
FS_FILTER_STREAM_FO_NOTIFICATION_TYPE.NotifyTypeCreate = 0
FS_FILTER_STREAM_FO_NOTIFICATION_TYPE.NotifyTypeRetired = 1


_unnamed_36553 = v_enum()
_unnamed_36553.KTMOH_CommitTransaction_Result = 1
_unnamed_36553.KTMOH_RollbackTransaction_Result = 2


DEVICE_USAGE_NOTIFICATION_TYPE = v_enum()
DEVICE_USAGE_NOTIFICATION_TYPE.DeviceUsageTypeUndefined = 0
DEVICE_USAGE_NOTIFICATION_TYPE.DeviceUsageTypePaging = 1
DEVICE_USAGE_NOTIFICATION_TYPE.DeviceUsageTypeHibernation = 2
DEVICE_USAGE_NOTIFICATION_TYPE.DeviceUsageTypeDumpFile = 3
DEVICE_USAGE_NOTIFICATION_TYPE.DeviceUsageTypeBoot = 4
DEVICE_USAGE_NOTIFICATION_TYPE.DeviceUsageTypePostDisplay = 5


ETW_HEADER_TYPE = v_enum()
ETW_HEADER_TYPE.EtwHeaderTypeNative = 0
ETW_HEADER_TYPE.EtwHeaderTypeMax = 1


INTERFACE_TYPE = v_enum()
INTERFACE_TYPE.InterfaceTypeUndefined = -1
INTERFACE_TYPE.Internal = 0
INTERFACE_TYPE.Isa = 1
INTERFACE_TYPE.Eisa = 2
INTERFACE_TYPE.MicroChannel = 3
INTERFACE_TYPE.TurboChannel = 4
INTERFACE_TYPE.PCIBus = 5
INTERFACE_TYPE.VMEBus = 6
INTERFACE_TYPE.NuBus = 7
INTERFACE_TYPE.PCMCIABus = 8
INTERFACE_TYPE.CBus = 9
INTERFACE_TYPE.MPIBus = 10
INTERFACE_TYPE.MPSABus = 11
INTERFACE_TYPE.ProcessorInternal = 12
INTERFACE_TYPE.InternalPowerBus = 13
INTERFACE_TYPE.PNPISABus = 14
INTERFACE_TYPE.PNPBus = 15
INTERFACE_TYPE.Vmcs = 16
INTERFACE_TYPE.ACPIBus = 17
INTERFACE_TYPE.MaximumInterfaceType = 18


KWAIT_REASON = v_enum()
KWAIT_REASON.Executive = 0
KWAIT_REASON.FreePage = 1
KWAIT_REASON.PageIn = 2
KWAIT_REASON.PoolAllocation = 3
KWAIT_REASON.DelayExecution = 4
KWAIT_REASON.Suspended = 5
KWAIT_REASON.UserRequest = 6
KWAIT_REASON.WrExecutive = 7
KWAIT_REASON.WrFreePage = 8
KWAIT_REASON.WrPageIn = 9
KWAIT_REASON.WrPoolAllocation = 10
KWAIT_REASON.WrDelayExecution = 11
KWAIT_REASON.WrSuspended = 12
KWAIT_REASON.WrUserRequest = 13
KWAIT_REASON.WrEventPair = 14
KWAIT_REASON.WrQueue = 15
KWAIT_REASON.WrLpcReceive = 16
KWAIT_REASON.WrLpcReply = 17
KWAIT_REASON.WrVirtualMemory = 18
KWAIT_REASON.WrPageOut = 19
KWAIT_REASON.WrRendezvous = 20
KWAIT_REASON.WrKeyedEvent = 21
KWAIT_REASON.WrTerminated = 22
KWAIT_REASON.WrProcessInSwap = 23
KWAIT_REASON.WrCpuRateControl = 24
KWAIT_REASON.WrCalloutStack = 25
KWAIT_REASON.WrKernel = 26
KWAIT_REASON.WrResource = 27
KWAIT_REASON.WrPushLock = 28
KWAIT_REASON.WrMutex = 29
KWAIT_REASON.WrQuantumEnd = 30
KWAIT_REASON.WrDispatchInt = 31
KWAIT_REASON.WrPreempted = 32
KWAIT_REASON.WrYieldExecution = 33
KWAIT_REASON.WrFastMutex = 34
KWAIT_REASON.WrGuardedMutex = 35
KWAIT_REASON.WrRundown = 36
KWAIT_REASON.WrAlertByThreadId = 37
KWAIT_REASON.WrDeferredPreempt = 38
KWAIT_REASON.MaximumWaitReason = 39


PS_RESOURCE_TYPE = v_enum()
PS_RESOURCE_TYPE.PsResourceNonPagedPool = 0
PS_RESOURCE_TYPE.PsResourcePagedPool = 1
PS_RESOURCE_TYPE.PsResourcePageFile = 2
PS_RESOURCE_TYPE.PsResourceWorkingSet = 3
PS_RESOURCE_TYPE.PsResourceCpuRate = 4
PS_RESOURCE_TYPE.PsResourceMax = 5


MM_PAGE_ACCESS_TYPE = v_enum()
MM_PAGE_ACCESS_TYPE.MmPteAccessType = 0
MM_PAGE_ACCESS_TYPE.MmCcReadAheadType = 1
MM_PAGE_ACCESS_TYPE.MmPfnRepurposeType = 2
MM_PAGE_ACCESS_TYPE.MmMaximumPageAccessType = 3


ReplacesCorHdrNumericDefines = v_enum()
ReplacesCorHdrNumericDefines.COMIMAGE_FLAGS_ILONLY = 1
ReplacesCorHdrNumericDefines.COMIMAGE_FLAGS_32BITREQUIRED = 2
ReplacesCorHdrNumericDefines.COMIMAGE_FLAGS_IL_LIBRARY = 4
ReplacesCorHdrNumericDefines.COMIMAGE_FLAGS_STRONGNAMESIGNED = 8
ReplacesCorHdrNumericDefines.COMIMAGE_FLAGS_NATIVE_ENTRYPOINT = 16
ReplacesCorHdrNumericDefines.COMIMAGE_FLAGS_TRACKDEBUGDATA = 65536
ReplacesCorHdrNumericDefines.COR_VERSION_MAJOR_V2 = 2
ReplacesCorHdrNumericDefines.COR_VERSION_MAJOR = 2
ReplacesCorHdrNumericDefines.COR_VERSION_MINOR = 5
ReplacesCorHdrNumericDefines.COR_DELETED_NAME_LENGTH = 8
ReplacesCorHdrNumericDefines.COR_VTABLEGAP_NAME_LENGTH = 8
ReplacesCorHdrNumericDefines.NATIVE_TYPE_MAX_CB = 1
ReplacesCorHdrNumericDefines.COR_ILMETHOD_SECT_SMALL_MAX_DATASIZE = 255
ReplacesCorHdrNumericDefines.IMAGE_COR_MIH_METHODRVA = 1
ReplacesCorHdrNumericDefines.IMAGE_COR_MIH_EHRVA = 2
ReplacesCorHdrNumericDefines.IMAGE_COR_MIH_BASICBLOCK = 8
ReplacesCorHdrNumericDefines.COR_VTABLE_32BIT = 1
ReplacesCorHdrNumericDefines.COR_VTABLE_64BIT = 2
ReplacesCorHdrNumericDefines.COR_VTABLE_FROM_UNMANAGED = 4
ReplacesCorHdrNumericDefines.COR_VTABLE_FROM_UNMANAGED_RETAIN_APPDOMAIN = 8
ReplacesCorHdrNumericDefines.COR_VTABLE_CALL_MOST_DERIVED = 16
ReplacesCorHdrNumericDefines.IMAGE_COR_EATJ_THUNK_SIZE = 32
ReplacesCorHdrNumericDefines.MAX_CLASS_NAME = 1024
ReplacesCorHdrNumericDefines.MAX_PACKAGE_NAME = 1024


HSTORAGE_TYPE = v_enum()
HSTORAGE_TYPE.Stable = 0
HSTORAGE_TYPE.Volatile = 1
HSTORAGE_TYPE.InvalidStorage = 2


MI_PFN_CACHE_ATTRIBUTE = v_enum()
MI_PFN_CACHE_ATTRIBUTE.MiNonCached = 0
MI_PFN_CACHE_ATTRIBUTE.MiCached = 1
MI_PFN_CACHE_ATTRIBUTE.MiWriteCombined = 2
MI_PFN_CACHE_ATTRIBUTE.MiNotMapped = 3


CREATE_FILE_TYPE = v_enum()
CREATE_FILE_TYPE.CreateFileTypeNone = 0
CREATE_FILE_TYPE.CreateFileTypeNamedPipe = 1
CREATE_FILE_TYPE.CreateFileTypeMailslot = 2


POLICY_AUDIT_EVENT_TYPE = v_enum()
POLICY_AUDIT_EVENT_TYPE.AuditCategorySystem = 0
POLICY_AUDIT_EVENT_TYPE.AuditCategoryLogon = 1
POLICY_AUDIT_EVENT_TYPE.AuditCategoryObjectAccess = 2
POLICY_AUDIT_EVENT_TYPE.AuditCategoryPrivilegeUse = 3
POLICY_AUDIT_EVENT_TYPE.AuditCategoryDetailedTracking = 4
POLICY_AUDIT_EVENT_TYPE.AuditCategoryPolicyChange = 5
POLICY_AUDIT_EVENT_TYPE.AuditCategoryAccountManagement = 6
POLICY_AUDIT_EVENT_TYPE.AuditCategoryDirectoryServiceAccess = 7
POLICY_AUDIT_EVENT_TYPE.AuditCategoryAccountLogon = 8


ETW_RT_EVENT_LOSS = v_enum()
ETW_RT_EVENT_LOSS.EtwRtEventNoLoss = 0
ETW_RT_EVENT_LOSS.EtwRtEventLost = 1
ETW_RT_EVENT_LOSS.EtwRtBufferLost = 2
ETW_RT_EVENT_LOSS.EtwRtBackupLost = 3
ETW_RT_EVENT_LOSS.EtwRtEventLossMax = 4


DEVICE_WAKE_DEPTH = v_enum()
DEVICE_WAKE_DEPTH.DeviceWakeDepthNotWakeable = 0
DEVICE_WAKE_DEPTH.DeviceWakeDepthD0 = 1
DEVICE_WAKE_DEPTH.DeviceWakeDepthD1 = 2
DEVICE_WAKE_DEPTH.DeviceWakeDepthD2 = 3
DEVICE_WAKE_DEPTH.DeviceWakeDepthD3hot = 4
DEVICE_WAKE_DEPTH.DeviceWakeDepthD3cold = 5
DEVICE_WAKE_DEPTH.DeviceWakeDepthMaximum = 6


POP_IO_STATUS = v_enum()
POP_IO_STATUS.IoReady = 0
POP_IO_STATUS.IoPending = 1
POP_IO_STATUS.IoDone = 2


WOW64_SHARED_INFORMATION = v_enum()
WOW64_SHARED_INFORMATION.SharedNtdll32LdrInitializeThunk = 0
WOW64_SHARED_INFORMATION.SharedNtdll32KiUserExceptionDispatcher = 1
WOW64_SHARED_INFORMATION.SharedNtdll32KiUserApcDispatcher = 2
WOW64_SHARED_INFORMATION.SharedNtdll32KiUserCallbackDispatcher = 3
WOW64_SHARED_INFORMATION.SharedNtdll32LdrHotPatchRoutine = 4
WOW64_SHARED_INFORMATION.SharedNtdll32ExpInterlockedPopEntrySListFault = 5
WOW64_SHARED_INFORMATION.SharedNtdll32ExpInterlockedPopEntrySListResume = 6
WOW64_SHARED_INFORMATION.SharedNtdll32ExpInterlockedPopEntrySListEnd = 7
WOW64_SHARED_INFORMATION.SharedNtdll32RtlUserThreadStart = 8
WOW64_SHARED_INFORMATION.SharedNtdll32pQueryProcessDebugInformationRemote = 9
WOW64_SHARED_INFORMATION.SharedNtdll32EtwpNotificationThread = 10
WOW64_SHARED_INFORMATION.SharedNtdll32BaseAddress = 11
WOW64_SHARED_INFORMATION.SharedNtdll32RtlpWnfNotificationThread = 12
WOW64_SHARED_INFORMATION.SharedNtdll32LdrSystemDllInitBlock = 13
WOW64_SHARED_INFORMATION.Wow64SharedPageEntriesCount = 14


PNP_DEVICE_ACTION_REQUEST = v_enum()
PNP_DEVICE_ACTION_REQUEST.AssignResources = 0
PNP_DEVICE_ACTION_REQUEST.ClearDeviceProblem = 1
PNP_DEVICE_ACTION_REQUEST.ClearProblem = 2
PNP_DEVICE_ACTION_REQUEST.ClearEjectProblem = 3
PNP_DEVICE_ACTION_REQUEST.HaltDevice = 4
PNP_DEVICE_ACTION_REQUEST.QueryPowerRelations = 5
PNP_DEVICE_ACTION_REQUEST.Rebalance = 6
PNP_DEVICE_ACTION_REQUEST.ReenumerateBootDevices = 7
PNP_DEVICE_ACTION_REQUEST.ReenumerateDeviceOnly = 8
PNP_DEVICE_ACTION_REQUEST.ReenumerateDeviceTree = 9
PNP_DEVICE_ACTION_REQUEST.ReenumerateRootDevices = 10
PNP_DEVICE_ACTION_REQUEST.RequeryDeviceState = 11
PNP_DEVICE_ACTION_REQUEST.ResetDevice = 12
PNP_DEVICE_ACTION_REQUEST.ResourceRequirementsChanged = 13
PNP_DEVICE_ACTION_REQUEST.RestartEnumeration = 14
PNP_DEVICE_ACTION_REQUEST.SetDeviceProblem = 15
PNP_DEVICE_ACTION_REQUEST.StartDevice = 16
PNP_DEVICE_ACTION_REQUEST.StartSystemDevicesPass0 = 17
PNP_DEVICE_ACTION_REQUEST.StartSystemDevicesPass1 = 18
PNP_DEVICE_ACTION_REQUEST.NotifyTransportRelationsChange = 19
PNP_DEVICE_ACTION_REQUEST.NotifyEjectionRelationsChange = 20
PNP_DEVICE_ACTION_REQUEST.ConfigureDevice = 21
PNP_DEVICE_ACTION_REQUEST.ConfigureDeviceClass = 22


DEVICE_RELATION_TYPE = v_enum()
DEVICE_RELATION_TYPE.BusRelations = 0
DEVICE_RELATION_TYPE.EjectionRelations = 1
DEVICE_RELATION_TYPE.PowerRelations = 2
DEVICE_RELATION_TYPE.RemovalRelations = 3
DEVICE_RELATION_TYPE.TargetDeviceRelation = 4
DEVICE_RELATION_TYPE.SingleBusRelations = 5
DEVICE_RELATION_TYPE.TransportRelations = 6


FILE_INFORMATION_CLASS = v_enum()
FILE_INFORMATION_CLASS.FileDirectoryInformation = 1
FILE_INFORMATION_CLASS.FileFullDirectoryInformation = 2
FILE_INFORMATION_CLASS.FileBothDirectoryInformation = 3
FILE_INFORMATION_CLASS.FileBasicInformation = 4
FILE_INFORMATION_CLASS.FileStandardInformation = 5
FILE_INFORMATION_CLASS.FileInternalInformation = 6
FILE_INFORMATION_CLASS.FileEaInformation = 7
FILE_INFORMATION_CLASS.FileAccessInformation = 8
FILE_INFORMATION_CLASS.FileNameInformation = 9
FILE_INFORMATION_CLASS.FileRenameInformation = 10
FILE_INFORMATION_CLASS.FileLinkInformation = 11
FILE_INFORMATION_CLASS.FileNamesInformation = 12
FILE_INFORMATION_CLASS.FileDispositionInformation = 13
FILE_INFORMATION_CLASS.FilePositionInformation = 14
FILE_INFORMATION_CLASS.FileFullEaInformation = 15
FILE_INFORMATION_CLASS.FileModeInformation = 16
FILE_INFORMATION_CLASS.FileAlignmentInformation = 17
FILE_INFORMATION_CLASS.FileAllInformation = 18
FILE_INFORMATION_CLASS.FileAllocationInformation = 19
FILE_INFORMATION_CLASS.FileEndOfFileInformation = 20
FILE_INFORMATION_CLASS.FileAlternateNameInformation = 21
FILE_INFORMATION_CLASS.FileStreamInformation = 22
FILE_INFORMATION_CLASS.FilePipeInformation = 23
FILE_INFORMATION_CLASS.FilePipeLocalInformation = 24
FILE_INFORMATION_CLASS.FilePipeRemoteInformation = 25
FILE_INFORMATION_CLASS.FileMailslotQueryInformation = 26
FILE_INFORMATION_CLASS.FileMailslotSetInformation = 27
FILE_INFORMATION_CLASS.FileCompressionInformation = 28
FILE_INFORMATION_CLASS.FileObjectIdInformation = 29
FILE_INFORMATION_CLASS.FileCompletionInformation = 30
FILE_INFORMATION_CLASS.FileMoveClusterInformation = 31
FILE_INFORMATION_CLASS.FileQuotaInformation = 32
FILE_INFORMATION_CLASS.FileReparsePointInformation = 33
FILE_INFORMATION_CLASS.FileNetworkOpenInformation = 34
FILE_INFORMATION_CLASS.FileAttributeTagInformation = 35
FILE_INFORMATION_CLASS.FileTrackingInformation = 36
FILE_INFORMATION_CLASS.FileIdBothDirectoryInformation = 37
FILE_INFORMATION_CLASS.FileIdFullDirectoryInformation = 38
FILE_INFORMATION_CLASS.FileValidDataLengthInformation = 39
FILE_INFORMATION_CLASS.FileShortNameInformation = 40
FILE_INFORMATION_CLASS.FileIoCompletionNotificationInformation = 41
FILE_INFORMATION_CLASS.FileIoStatusBlockRangeInformation = 42
FILE_INFORMATION_CLASS.FileIoPriorityHintInformation = 43
FILE_INFORMATION_CLASS.FileSfioReserveInformation = 44
FILE_INFORMATION_CLASS.FileSfioVolumeInformation = 45
FILE_INFORMATION_CLASS.FileHardLinkInformation = 46
FILE_INFORMATION_CLASS.FileProcessIdsUsingFileInformation = 47
FILE_INFORMATION_CLASS.FileNormalizedNameInformation = 48
FILE_INFORMATION_CLASS.FileNetworkPhysicalNameInformation = 49
FILE_INFORMATION_CLASS.FileIdGlobalTxDirectoryInformation = 50
FILE_INFORMATION_CLASS.FileIsRemoteDeviceInformation = 51
FILE_INFORMATION_CLASS.FileAttributeCacheInformation = 52
FILE_INFORMATION_CLASS.FileNumaNodeInformation = 53
FILE_INFORMATION_CLASS.FileStandardLinkInformation = 54
FILE_INFORMATION_CLASS.FileRemoteProtocolInformation = 55
FILE_INFORMATION_CLASS.FileRenameInformationBypassAccessCheck = 56
FILE_INFORMATION_CLASS.FileLinkInformationBypassAccessCheck = 57
FILE_INFORMATION_CLASS.FileVolumeNameInformation = 58
FILE_INFORMATION_CLASS.FileIdInformation = 59
FILE_INFORMATION_CLASS.FileIdExtdDirectoryInformation = 60
FILE_INFORMATION_CLASS.FileMaximumInformation = 61


DEVICE_POWER_STATE = v_enum()
DEVICE_POWER_STATE.PowerDeviceUnspecified = 0
DEVICE_POWER_STATE.PowerDeviceD0 = 1
DEVICE_POWER_STATE.PowerDeviceD1 = 2
DEVICE_POWER_STATE.PowerDeviceD2 = 3
DEVICE_POWER_STATE.PowerDeviceD3 = 4
DEVICE_POWER_STATE.PowerDeviceMaximum = 5


MEMORY_CACHING_TYPE = v_enum()
MEMORY_CACHING_TYPE.MmNonCached = 0
MEMORY_CACHING_TYPE.MmCached = 1
MEMORY_CACHING_TYPE.MmWriteCombined = 2
MEMORY_CACHING_TYPE.MmHardwareCoherentCached = 3
MEMORY_CACHING_TYPE.MmNonCachedUnordered = 4
MEMORY_CACHING_TYPE.MmUSWCCached = 5
MEMORY_CACHING_TYPE.MmMaximumCacheType = 6


NT_PRODUCT_TYPE = v_enum()
NT_PRODUCT_TYPE.NtProductWinNt = 1
NT_PRODUCT_TYPE.NtProductLanManNt = 2
NT_PRODUCT_TYPE.NtProductServer = 3


IOP_PRIORITY_HINT = v_enum()
IOP_PRIORITY_HINT.IopIoPriorityNotSet = 0
IOP_PRIORITY_HINT.IopIoPriorityVeryLow = 1
IOP_PRIORITY_HINT.IopIoPriorityLow = 2
IOP_PRIORITY_HINT.IopIoPriorityNormal = 3
IOP_PRIORITY_HINT.IopIoPriorityHigh = 4
IOP_PRIORITY_HINT.IopIoPriorityCritical = 5
IOP_PRIORITY_HINT.MaxIopIoPriorityTypes = 6


WHEA_ERROR_SOURCE_TYPE = v_enum()
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeMCE = 0
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeCMC = 1
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeCPE = 2
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeNMI = 3
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypePCIe = 4
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeGeneric = 5
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeINIT = 6
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeBOOT = 7
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeSCIGeneric = 8
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeIPFMCA = 9
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeIPFCMC = 10
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeIPFCPE = 11
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeMax = 12


RTL_GENERIC_COMPARE_RESULTS = v_enum()
RTL_GENERIC_COMPARE_RESULTS.GenericLessThan = 0
RTL_GENERIC_COMPARE_RESULTS.GenericGreaterThan = 1
RTL_GENERIC_COMPARE_RESULTS.GenericEqual = 2


TP_CALLBACK_PRIORITY = v_enum()
TP_CALLBACK_PRIORITY.TP_CALLBACK_PRIORITY_HIGH = 0
TP_CALLBACK_PRIORITY.TP_CALLBACK_PRIORITY_NORMAL = 1
TP_CALLBACK_PRIORITY.TP_CALLBACK_PRIORITY_LOW = 2
TP_CALLBACK_PRIORITY.TP_CALLBACK_PRIORITY_INVALID = 3
TP_CALLBACK_PRIORITY.TP_CALLBACK_PRIORITY_COUNT = 3


FSINFOCLASS = v_enum()
FSINFOCLASS.FileFsVolumeInformation = 1
FSINFOCLASS.FileFsLabelInformation = 2
FSINFOCLASS.FileFsSizeInformation = 3
FSINFOCLASS.FileFsDeviceInformation = 4
FSINFOCLASS.FileFsAttributeInformation = 5
FSINFOCLASS.FileFsControlInformation = 6
FSINFOCLASS.FileFsFullSizeInformation = 7
FSINFOCLASS.FileFsObjectIdInformation = 8
FSINFOCLASS.FileFsDriverPathInformation = 9
FSINFOCLASS.FileFsVolumeFlagsInformation = 10
FSINFOCLASS.FileFsSectorSizeInformation = 11
FSINFOCLASS.FileFsDataCopyInformation = 12
FSINFOCLASS.FileFsMaximumInformation = 13


WORKING_SET_TYPE = v_enum()
WORKING_SET_TYPE.WorkingSetTypeUser = 0
WORKING_SET_TYPE.WorkingSetTypeSession = 1
WORKING_SET_TYPE.WorkingSetTypeSystemTypes = 2
WORKING_SET_TYPE.WorkingSetTypeSystemCache = 2
WORKING_SET_TYPE.WorkingSetTypePagedPool = 3
WORKING_SET_TYPE.WorkingSetTypeSystemPtes = 4
WORKING_SET_TYPE.WorkingSetTypeMaximum = 5


POOL_TYPE = v_enum()
POOL_TYPE.NonPagedPool = 0
POOL_TYPE.NonPagedPoolExecute = 0
POOL_TYPE.PagedPool = 1
POOL_TYPE.NonPagedPoolMustSucceed = 2
POOL_TYPE.DontUseThisType = 3
POOL_TYPE.NonPagedPoolCacheAligned = 4
POOL_TYPE.PagedPoolCacheAligned = 5
POOL_TYPE.NonPagedPoolCacheAlignedMustS = 6
POOL_TYPE.MaxPoolType = 7
POOL_TYPE.NonPagedPoolBase = 0
POOL_TYPE.NonPagedPoolBaseMustSucceed = 2
POOL_TYPE.NonPagedPoolBaseCacheAligned = 4
POOL_TYPE.NonPagedPoolBaseCacheAlignedMustS = 6
POOL_TYPE.NonPagedPoolSession = 32
POOL_TYPE.PagedPoolSession = 33
POOL_TYPE.NonPagedPoolMustSucceedSession = 34
POOL_TYPE.DontUseThisTypeSession = 35
POOL_TYPE.NonPagedPoolCacheAlignedSession = 36
POOL_TYPE.PagedPoolCacheAlignedSession = 37
POOL_TYPE.NonPagedPoolCacheAlignedMustSSession = 38
POOL_TYPE.NonPagedPoolNx = 512
POOL_TYPE.NonPagedPoolNxCacheAligned = 516
POOL_TYPE.NonPagedPoolSessionNx = 544


MODE = v_enum()
MODE.KernelMode = 0
MODE.UserMode = 1
MODE.MaximumMode = 2


FS_FILTER_SECTION_SYNC_TYPE = v_enum()
FS_FILTER_SECTION_SYNC_TYPE.SyncTypeOther = 0
FS_FILTER_SECTION_SYNC_TYPE.SyncTypeCreateSection = 1


PERFINFO_KERNELMEMORY_USAGE_TYPE = v_enum()
PERFINFO_KERNELMEMORY_USAGE_TYPE.PerfInfoMemUsagePfnMetadata = 0
PERFINFO_KERNELMEMORY_USAGE_TYPE.PerfInfoMemUsageMax = 1


FILE_OBJECT_EXTENSION_TYPE = v_enum()
FILE_OBJECT_EXTENSION_TYPE.FoExtTypeTransactionParams = 0
FILE_OBJECT_EXTENSION_TYPE.FoExtTypeInternal = 1
FILE_OBJECT_EXTENSION_TYPE.FoExtTypeIosbRange = 2
FILE_OBJECT_EXTENSION_TYPE.FoExtTypeGeneric = 3
FILE_OBJECT_EXTENSION_TYPE.FoExtTypeSfio = 4
FILE_OBJECT_EXTENSION_TYPE.FoExtTypeSymlink = 5
FILE_OBJECT_EXTENSION_TYPE.FoExtTypeOplockKey = 6
FILE_OBJECT_EXTENSION_TYPE.MaxFoExtTypes = 7


IRQ_PRIORITY = v_enum()
IRQ_PRIORITY.IrqPriorityUndefined = 0
IRQ_PRIORITY.IrqPriorityLow = 1
IRQ_PRIORITY.IrqPriorityNormal = 2
IRQ_PRIORITY.IrqPriorityHigh = 3


KPROFILE_SOURCE = v_enum()
KPROFILE_SOURCE.ProfileTime = 0
KPROFILE_SOURCE.ProfileAlignmentFixup = 1
KPROFILE_SOURCE.ProfileTotalIssues = 2
KPROFILE_SOURCE.ProfilePipelineDry = 3
KPROFILE_SOURCE.ProfileLoadInstructions = 4
KPROFILE_SOURCE.ProfilePipelineFrozen = 5
KPROFILE_SOURCE.ProfileBranchInstructions = 6
KPROFILE_SOURCE.ProfileTotalNonissues = 7
KPROFILE_SOURCE.ProfileDcacheMisses = 8
KPROFILE_SOURCE.ProfileIcacheMisses = 9
KPROFILE_SOURCE.ProfileCacheMisses = 10
KPROFILE_SOURCE.ProfileBranchMispredictions = 11
KPROFILE_SOURCE.ProfileStoreInstructions = 12
KPROFILE_SOURCE.ProfileFpInstructions = 13
KPROFILE_SOURCE.ProfileIntegerInstructions = 14
KPROFILE_SOURCE.Profile2Issue = 15
KPROFILE_SOURCE.Profile3Issue = 16
KPROFILE_SOURCE.Profile4Issue = 17
KPROFILE_SOURCE.ProfileSpecialInstructions = 18
KPROFILE_SOURCE.ProfileTotalCycles = 19
KPROFILE_SOURCE.ProfileIcacheIssues = 20
KPROFILE_SOURCE.ProfileDcacheAccesses = 21
KPROFILE_SOURCE.ProfileMemoryBarrierCycles = 22
KPROFILE_SOURCE.ProfileLoadLinkedIssues = 23
KPROFILE_SOURCE.ProfileMaximum = 24


MI_SYSTEM_VA_TYPE = v_enum()
MI_SYSTEM_VA_TYPE.MiVaUnused = 0
MI_SYSTEM_VA_TYPE.MiVaSessionSpace = 1
MI_SYSTEM_VA_TYPE.MiVaProcessSpace = 2
MI_SYSTEM_VA_TYPE.MiVaBootLoaded = 3
MI_SYSTEM_VA_TYPE.MiVaPfnDatabase = 4
MI_SYSTEM_VA_TYPE.MiVaNonPagedPool = 5
MI_SYSTEM_VA_TYPE.MiVaPagedPool = 6
MI_SYSTEM_VA_TYPE.MiVaSpecialPoolPaged = 7
MI_SYSTEM_VA_TYPE.MiVaSystemCache = 8
MI_SYSTEM_VA_TYPE.MiVaSystemPtes = 9
MI_SYSTEM_VA_TYPE.MiVaHal = 10
MI_SYSTEM_VA_TYPE.MiVaSessionGlobalSpace = 11
MI_SYSTEM_VA_TYPE.MiVaDriverImages = 12
MI_SYSTEM_VA_TYPE.MiVaSpecialPoolNonPaged = 13
MI_SYSTEM_VA_TYPE.MiVaPagedProtoPool = 14
MI_SYSTEM_VA_TYPE.MiVaMaximumType = 15


PROCESS_SECTION_TYPE = v_enum()
PROCESS_SECTION_TYPE.ProcessSectionData = 0
PROCESS_SECTION_TYPE.ProcessSectionImage = 1
PROCESS_SECTION_TYPE.ProcessSectionImageNx = 2
PROCESS_SECTION_TYPE.ProcessSectionPagefileBacked = 3
PROCESS_SECTION_TYPE.ProcessSectionMax = 4


LSA_FOREST_TRUST_RECORD_TYPE = v_enum()
LSA_FOREST_TRUST_RECORD_TYPE.ForestTrustTopLevelName = 0
LSA_FOREST_TRUST_RECORD_TYPE.ForestTrustTopLevelNameEx = 1
LSA_FOREST_TRUST_RECORD_TYPE.ForestTrustDomainInfo = 2
LSA_FOREST_TRUST_RECORD_TYPE.ForestTrustRecordTypeLast = 2


LDR_DDAG_STATE = v_enum()
LDR_DDAG_STATE.LdrModulesMerged = -5
LDR_DDAG_STATE.LdrModulesInitError = -4
LDR_DDAG_STATE.LdrModulesSnapError = -3
LDR_DDAG_STATE.LdrModulesUnloaded = -2
LDR_DDAG_STATE.LdrModulesUnloading = -1
LDR_DDAG_STATE.LdrModulesPlaceHolder = 0
LDR_DDAG_STATE.LdrModulesMapping = 1
LDR_DDAG_STATE.LdrModulesMapped = 2
LDR_DDAG_STATE.LdrModulesWaitingForDependencies = 3
LDR_DDAG_STATE.LdrModulesSnapping = 4
LDR_DDAG_STATE.LdrModulesSnapped = 5
LDR_DDAG_STATE.LdrModulesCondensed = 6
LDR_DDAG_STATE.LdrModulesReadyToInit = 7
LDR_DDAG_STATE.LdrModulesInitializing = 8
LDR_DDAG_STATE.LdrModulesReadyToRun = 9


MI_MEMORY_HIGHLOW = v_enum()
MI_MEMORY_HIGHLOW.MiMemoryHigh = 0
MI_MEMORY_HIGHLOW.MiMemoryLow = 1
MI_MEMORY_HIGHLOW.MiMemoryHighLow = 2


DEVICE_TEXT_TYPE = v_enum()
DEVICE_TEXT_TYPE.DeviceTextDescription = 0
DEVICE_TEXT_TYPE.DeviceTextLocationInformation = 1


MMLISTS = v_enum()
MMLISTS.ZeroedPageList = 0
MMLISTS.FreePageList = 1
MMLISTS.StandbyPageList = 2
MMLISTS.ModifiedPageList = 3
MMLISTS.ModifiedNoWritePageList = 4
MMLISTS.BadPageList = 5
MMLISTS.ActiveAndValid = 6
MMLISTS.TransitionPage = 7


KINTERRUPT_MODE = v_enum()
KINTERRUPT_MODE.LevelSensitive = 0
KINTERRUPT_MODE.Latched = 1


TOKEN_TYPE = v_enum()
TOKEN_TYPE.TokenPrimary = 1
TOKEN_TYPE.TokenImpersonation = 2


HARDWARE_COUNTER_TYPE = v_enum()
HARDWARE_COUNTER_TYPE.PMCCounter = 0
HARDWARE_COUNTER_TYPE.MaxHardwareCounterType = 1


TRANSFER_TYPE = v_enum()
TRANSFER_TYPE.ReadTransfer = 0
TRANSFER_TYPE.WriteTransfer = 1
TRANSFER_TYPE.OtherTransfer = 2


PNP_DEVNODE_STATE = v_enum()
PNP_DEVNODE_STATE.DeviceNodeUnspecified = 768
PNP_DEVNODE_STATE.DeviceNodeUninitialized = 769
PNP_DEVNODE_STATE.DeviceNodeInitialized = 770
PNP_DEVNODE_STATE.DeviceNodeDriversAdded = 771
PNP_DEVNODE_STATE.DeviceNodeResourcesAssigned = 772
PNP_DEVNODE_STATE.DeviceNodeStartPending = 773
PNP_DEVNODE_STATE.DeviceNodeStartCompletion = 774
PNP_DEVNODE_STATE.DeviceNodeStartPostWork = 775
PNP_DEVNODE_STATE.DeviceNodeStarted = 776
PNP_DEVNODE_STATE.DeviceNodeQueryStopped = 777
PNP_DEVNODE_STATE.DeviceNodeStopped = 778
PNP_DEVNODE_STATE.DeviceNodeRestartCompletion = 779
PNP_DEVNODE_STATE.DeviceNodeEnumeratePending = 780
PNP_DEVNODE_STATE.DeviceNodeEnumerateCompletion = 781
PNP_DEVNODE_STATE.DeviceNodeAwaitingQueuedDeletion = 782
PNP_DEVNODE_STATE.DeviceNodeAwaitingQueuedRemoval = 783
PNP_DEVNODE_STATE.DeviceNodeQueryRemoved = 784
PNP_DEVNODE_STATE.DeviceNodeRemovePendingCloses = 785
PNP_DEVNODE_STATE.DeviceNodeRemoved = 786
PNP_DEVNODE_STATE.DeviceNodeDeletePendingCloses = 787
PNP_DEVNODE_STATE.DeviceNodeDeleted = 788
PNP_DEVNODE_STATE.MaxDeviceNodeState = 789


class KEXECUTE_OPTIONS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ExecuteDisable = v_uint8()


class IO_PRIORITY_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Size = v_uint32()
        self.ThreadPriority = v_uint32()
        self.PagePriority = v_uint32()
        self.IoPriority = v_uint32()


class IOV_FORCED_PENDING_TRACE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Irp = v_ptr32()
        self.Thread = v_ptr32()
        self.StackTrace = vstruct.VArray([ v_ptr32() for i in xrange(62) ])


class SEGMENT_OBJECT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BaseAddress = v_ptr32()
        self.TotalNumberOfPtes = v_uint32()
        self.SizeOfSegment = LARGE_INTEGER()
        self.NonExtendedPtes = v_uint32()
        self.ImageCommitment = v_uint32()
        self.ControlArea = v_ptr32()
        self.Subsection = v_ptr32()
        self.MmSectionFlags = v_ptr32()
        self.MmSubSectionFlags = v_ptr32()


class DUAL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.Map = v_ptr32()
        self.SmallDir = v_ptr32()
        self.Guard = v_uint32()
        self.FreeDisplay = vstruct.VArray([ FREE_DISPLAY() for i in xrange(24) ])
        self.FreeBins = LIST_ENTRY()
        self.FreeSummary = v_uint32()


class SID(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Revision = v_uint8()
        self.SubAuthorityCount = v_uint8()
        self.IdentifierAuthority = SID_IDENTIFIER_AUTHORITY()
        self.SubAuthority = vstruct.VArray([ v_uint32() for i in xrange(1) ])


class MMPTE_HARDWARE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Valid = v_uint64()


class POP_CPU_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Eax = v_uint32()
        self.Ebx = v_uint32()
        self.Ecx = v_uint32()
        self.Edx = v_uint32()


class _unnamed_29146(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Failure = v_uint32()
        self.Status = v_uint32()
        self.Point = v_uint32()


class _unnamed_29147(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Action = v_uint32()
        self.Handle = v_ptr32()
        self.Status = v_uint32()


class WHEA_ERROR_PACKET_V2(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint32()
        self.Version = v_uint32()
        self.Length = v_uint32()
        self.Flags = WHEA_ERROR_PACKET_FLAGS()
        self.ErrorType = v_uint32()
        self.ErrorSeverity = v_uint32()
        self.ErrorSourceId = v_uint32()
        self.ErrorSourceType = v_uint32()
        self.NotifyType = GUID()
        self.Context = v_uint64()
        self.DataFormat = v_uint32()
        self.Reserved1 = v_uint32()
        self.DataOffset = v_uint32()
        self.DataLength = v_uint32()
        self.PshedDataOffset = v_uint32()
        self.PshedDataLength = v_uint32()


class CC_EXTERNAL_CACHE_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Callback = v_ptr32()
        self.DirtyPageStatistics = DIRTY_PAGE_STATISTICS()
        self.Links = LIST_ENTRY()


class GROUP_AFFINITY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Mask = v_uint32()
        self.Group = v_uint16()
        self.Reserved = vstruct.VArray([ v_uint16() for i in xrange(3) ])


class VI_VERIFIER_ISSUE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.IssueType = v_uint32()
        self.Address = v_ptr32()
        self.Parameters = vstruct.VArray([ v_uint32() for i in xrange(2) ])


class POP_IRP_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Link = LIST_ENTRY()
        self.Irp = v_ptr32()
        self.Pdo = v_ptr32()
        self.TargetDevice = v_ptr32()
        self.CurrentDevice = v_ptr32()
        self.WatchdogStart = v_uint64()
        self.WatchdogTimer = KTIMER()
        self.WatchdogDpc = KDPC()
        self.MinorFunction = v_uint8()
        self._pad006c = v_bytes(size=3)
        self.PowerStateType = v_uint32()
        self.PowerState = POWER_STATE()
        self.WatchdogEnabled = v_uint8()
        self._pad0078 = v_bytes(size=3)
        self.FxDevice = v_ptr32()
        self.SystemTransition = v_uint8()
        self.NotifyPEP = v_uint8()
        self._pad0080 = v_bytes(size=2)
        self.Device = _unnamed_34060()


class HEAP_STOP_ON_VALUES(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AllocAddress = v_uint32()
        self.AllocTag = HEAP_STOP_ON_TAG()
        self.ReAllocAddress = v_uint32()
        self.ReAllocTag = HEAP_STOP_ON_TAG()
        self.FreeAddress = v_uint32()
        self.FreeTag = HEAP_STOP_ON_TAG()


class _unnamed_29148(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CheckStack = v_ptr32()


class _unnamed_29149(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Cell = v_uint32()
        self.CellPoint = v_ptr32()
        self.RootPoint = v_ptr32()
        self.Index = v_uint32()


class KTSS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Backlink = v_uint16()
        self.Reserved0 = v_uint16()
        self.Esp0 = v_uint32()
        self.Ss0 = v_uint16()
        self.Reserved1 = v_uint16()
        self.NotUsed1 = vstruct.VArray([ v_uint32() for i in xrange(4) ])
        self.CR3 = v_uint32()
        self.Eip = v_uint32()
        self.EFlags = v_uint32()
        self.Eax = v_uint32()
        self.Ecx = v_uint32()
        self.Edx = v_uint32()
        self.Ebx = v_uint32()
        self.Esp = v_uint32()
        self.Ebp = v_uint32()
        self.Esi = v_uint32()
        self.Edi = v_uint32()
        self.Es = v_uint16()
        self.Reserved2 = v_uint16()
        self.Cs = v_uint16()
        self.Reserved3 = v_uint16()
        self.Ss = v_uint16()
        self.Reserved4 = v_uint16()
        self.Ds = v_uint16()
        self.Reserved5 = v_uint16()
        self.Fs = v_uint16()
        self.Reserved6 = v_uint16()
        self.Gs = v_uint16()
        self.Reserved7 = v_uint16()
        self.LDT = v_uint16()
        self.Reserved8 = v_uint16()
        self.Flags = v_uint16()
        self.IoMapBase = v_uint16()
        self.IoMaps = vstruct.VArray([ KiIoAccessMap() for i in xrange(1) ])
        self.IntDirectionMap = vstruct.VArray([ v_uint8() for i in xrange(32) ])


class CURDIR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DosPath = UNICODE_STRING()
        self.Handle = v_ptr32()


class DBGKD_GET_INTERNAL_BREAKPOINT32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BreakpointAddress = v_uint32()
        self.Flags = v_uint32()
        self.Calls = v_uint32()
        self.MaxCallsPerPeriod = v_uint32()
        self.MinInstructions = v_uint32()
        self.MaxInstructions = v_uint32()
        self.TotalInstructions = v_uint32()


class PO_IRP_MANAGER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DeviceIrpQueue = PO_IRP_QUEUE()
        self.SystemIrpQueue = PO_IRP_QUEUE()


class DBGKD_MANIPULATE_STATE32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ApiNumber = v_uint32()
        self.ProcessorLevel = v_uint16()
        self.Processor = v_uint16()
        self.ReturnStatus = v_uint32()
        self.u = _unnamed_30210()


class ETW_BUFFER_QUEUE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.QueueHead = v_ptr32()
        self.QueueTail = v_ptr32()
        self.QueueEntry = SINGLE_LIST_ENTRY()


class SEP_TOKEN_PRIVILEGES(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Present = v_uint64()
        self.Enabled = v_uint64()
        self.EnabledByDefault = v_uint64()


class KALPC_SECTION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SectionObject = v_ptr32()
        self.Size = v_uint32()
        self.HandleTable = v_ptr32()
        self.SectionHandle = v_ptr32()
        self.OwnerProcess = v_ptr32()
        self.OwnerPort = v_ptr32()
        self.u1 = _unnamed_30828()
        self.NumberOfRegions = v_uint32()
        self.RegionListHead = LIST_ENTRY()


class _unnamed_30905(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Secure = v_uint32()


class _unnamed_30902(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.s1 = _unnamed_30905()


class PERFINFO_GROUPMASK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Masks = vstruct.VArray([ v_uint32() for i in xrange(8) ])


class HARDWARE_PTE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Valid = v_uint64()


class ETW_PERF_COUNTERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TotalActiveSessions = v_uint32()
        self.TotalBufferMemoryNonPagedPool = v_uint32()
        self.TotalBufferMemoryPagedPool = v_uint32()
        self.TotalGuidsEnabled = v_uint32()
        self.TotalGuidsNotEnabled = v_uint32()
        self.TotalGuidsPreEnabled = v_uint32()


class HANDLE_TABLE_ENTRY_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AuditMask = v_uint32()


class DBGKD_WRITE_MEMORY32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TargetBaseAddress = v_uint32()
        self.TransferCount = v_uint32()
        self.ActualBytesWritten = v_uint32()


class POP_FX_WORK_ORDER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.WorkItem = WORK_QUEUE_ITEM()
        self.WorkCount = v_uint32()


class _unnamed_34666(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Group = v_uint16()
        self.MessageCount = v_uint16()
        self.Vector = v_uint32()
        self.Affinity = v_uint32()


class _unnamed_28148(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PowerSequence = v_ptr32()


class WHEA_ERROR_RECORD_SECTION_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SectionOffset = v_uint32()
        self.SectionLength = v_uint32()
        self.Revision = WHEA_REVISION()
        self.ValidBits = WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_VALIDBITS()
        self.Reserved = v_uint8()
        self.Flags = WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_FLAGS()
        self.SectionType = GUID()
        self.FRUId = GUID()
        self.SectionSeverity = v_uint32()
        self.FRUText = vstruct.VArray([ v_uint8() for i in xrange(20) ])


class EX_WORK_QUEUE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.WorkerQueue = KQUEUE()
        self.WorkItemsProcessed = v_uint32()
        self.WorkItemsProcessedLastPass = v_uint32()
        self.ThreadCount = v_uint32()
        self.TryFailed = v_uint8()
        self._pad0038 = v_bytes(size=3)


class MMWSLENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Valid = v_uint32()


class PNP_DEVICE_COMPLETION_REQUEST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self.DeviceNode = v_ptr32()
        self.Context = v_ptr32()
        self.CompletionState = v_uint32()
        self.IrpPended = v_uint32()
        self.Status = v_uint32()
        self.Information = v_ptr32()
        self.ReferenceCount = v_uint32()


class CHILD_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Count = v_uint32()
        self.List = v_uint32()


class _unnamed_31482(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MajorVersion = v_uint8()
        self.MinorVersion = v_uint8()
        self.SubVersion = v_uint8()
        self.SubMinorVersion = v_uint8()


class PROC_FEEDBACK_COUNTER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.InstantaneousRead = v_ptr32()
        self._pad0008 = v_bytes(size=4)
        self.LastActualCount = v_uint64()
        self.LastReferenceCount = v_uint64()
        self.CachedValue = v_uint32()
        self._pad0020 = v_bytes(size=4)
        self.Affinitized = v_uint8()
        self.Differential = v_uint8()
        self.DisableInterrupts = v_uint8()
        self._pad0024 = v_bytes(size=1)
        self.Context = v_uint32()


class CM_PARTIAL_RESOURCE_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Version = v_uint16()
        self.Revision = v_uint16()
        self.Count = v_uint32()
        self.PartialDescriptors = vstruct.VArray([ CM_PARTIAL_RESOURCE_DESCRIPTOR() for i in xrange(1) ])


class _unnamed_29717(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Disk = _unnamed_34794()


class DBGKD_RESTORE_BREAKPOINT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BreakPointHandle = v_uint32()


class PEPHANDLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.unused = v_uint32()


class IMAGE_SECURITY_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PageHashes = v_ptr32()


class DEVICE_CAPABILITIES(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Size = v_uint16()
        self.Version = v_uint16()
        self.DeviceD1 = v_uint32()
        self.Address = v_uint32()
        self.UINumber = v_uint32()
        self.DeviceState = vstruct.VArray([ DEVICE_POWER_STATE() for i in xrange(7) ])
        self.SystemWake = v_uint32()
        self.DeviceWake = v_uint32()
        self.D1Latency = v_uint32()
        self.D2Latency = v_uint32()
        self.D3Latency = v_uint32()


class IOP_FILE_OBJECT_EXTENSION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.FoExtFlags = v_uint32()
        self.FoExtPerTypeExtension = vstruct.VArray([ v_ptr32() for i in xrange(7) ])
        self.FoIoPriorityHint = v_uint32()


class IOP_IRP_EXTENSION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ExtensionFlags = v_uint16()
        self.TypesAllocated = v_uint16()
        self.ActivityId = GUID()
        self._pad0018 = v_bytes(size=4)
        self.Timestamp = LARGE_INTEGER()


class _unnamed_34061(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NotifyDevice = v_ptr32()
        self.FxDeviceActivated = v_uint8()
        self._pad0008 = v_bytes(size=3)


class _unnamed_34060(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CallerCompletion = v_ptr32()
        self.CallerContext = v_ptr32()
        self.CallerDevice = v_ptr32()
        self.SystemWake = v_uint8()
        self._pad0010 = v_bytes(size=3)


class ACL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AclRevision = v_uint8()
        self.Sbz1 = v_uint8()
        self.AclSize = v_uint16()
        self.AceCount = v_uint16()
        self.Sbz2 = v_uint16()


class PCW_INSTANCE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class VOLUME_CACHE_MAP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NodeTypeCode = v_uint16()
        self.NodeByteCode = v_uint16()
        self.UseCount = v_uint32()
        self.DeviceObject = v_ptr32()
        self.VolumeCacheMapLinks = LIST_ENTRY()
        self.DirtyPages = v_uint32()
        self.LogHandleContext = LOG_HANDLE_CONTEXT()
        self.Flags = v_uint32()
        self.PagesQueuedToDisk = v_uint32()
        self.LoggedPagesQueuedToDisk = v_uint32()
        self._pad0078 = v_bytes(size=4)


class CALLBACK_OBJECT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class RTL_RANGE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Start = v_uint64()
        self.End = v_uint64()
        self.UserData = v_ptr32()
        self.Owner = v_ptr32()
        self.Attributes = v_uint8()
        self.Flags = v_uint8()
        self._pad0020 = v_bytes(size=6)


class _unnamed_34324(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SnapSharedExportsFailed = v_uint32()


class HEAP_FREE_ENTRY_EXTRA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TagIndex = v_uint16()
        self.FreeBackTraceIndex = v_uint16()


class EXCEPTION_RECORD64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ExceptionCode = v_uint32()
        self.ExceptionFlags = v_uint32()
        self.ExceptionRecord = v_uint64()
        self.ExceptionAddress = v_uint64()
        self.NumberParameters = v_uint32()
        self.unusedAlignment = v_uint32()
        self.ExceptionInformation = vstruct.VArray([ v_uint64() for i in xrange(15) ])


class SEP_LOWBOX_NUMBER_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.HashEntry = RTL_DYNAMIC_HASH_TABLE_ENTRY()
        self.ReferenceCount = v_uint32()
        self.PackageSid = v_ptr32()
        self.LowboxNumber = v_uint32()
        self.AtomTable = v_ptr32()


class KPROCESS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Header = DISPATCHER_HEADER()
        self.ProfileListHead = LIST_ENTRY()
        self.DirectoryTableBase = v_uint32()
        self.LdtDescriptor = KGDTENTRY()
        self.Int21Descriptor = KIDTENTRY()
        self.ThreadListHead = LIST_ENTRY()
        self.ProcessLock = v_uint32()
        self.Affinity = KAFFINITY_EX()
        self.ReadyListHead = LIST_ENTRY()
        self.SwapListEntry = SINGLE_LIST_ENTRY()
        self.ActiveProcessors = KAFFINITY_EX()
        self.AutoAlignment = v_uint32()
        self.BasePriority = v_uint8()
        self.QuantumReset = v_uint8()
        self.Visited = v_uint8()
        self.Flags = KEXECUTE_OPTIONS()
        self.ThreadSeed = vstruct.VArray([ v_uint32() for i in xrange(1) ])
        self.IdealNode = vstruct.VArray([ v_uint16() for i in xrange(1) ])
        self.IdealGlobalNode = v_uint16()
        self.Spare1 = v_uint16()
        self.IopmOffset = v_uint16()
        self.SchedulingGroup = v_ptr32()
        self.StackCount = KSTACK_COUNT()
        self.ProcessListEntry = LIST_ENTRY()
        self.CycleTime = v_uint64()
        self.ContextSwitches = v_uint64()
        self.FreezeCount = v_uint32()
        self.KernelTime = v_uint32()
        self.UserTime = v_uint32()
        self.VdmTrapcHandler = v_ptr32()


class ALPC_COMMUNICATION_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ConnectionPort = v_ptr32()
        self.ServerCommunicationPort = v_ptr32()
        self.ClientCommunicationPort = v_ptr32()
        self.CommunicationList = LIST_ENTRY()
        self.HandleTable = ALPC_HANDLE_TABLE()


class DEVICE_OBJECT_POWER_EXTENSION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.IdleCount = v_uint32()
        self.BusyCount = v_uint32()
        self.BusyReference = v_uint32()
        self.TotalBusyCount = v_uint32()
        self.ConservationIdleTime = v_uint32()
        self.PerformanceIdleTime = v_uint32()
        self.DeviceObject = v_ptr32()
        self.IdleList = LIST_ENTRY()
        self.IdleType = v_uint32()
        self.IdleState = v_uint32()
        self.CurrentState = v_uint32()
        self.Volume = LIST_ENTRY()
        self.Specific = _unnamed_29717()


class _unnamed_27983(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_ptr32()
        self.Key = v_uint32()
        self.ByteOffset = LARGE_INTEGER()


class _unnamed_30991(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Initialized = v_uint32()


class _unnamed_27988(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.OutputBufferLength = v_uint32()
        self.InputBufferLength = v_uint32()
        self.IoControlCode = v_uint32()
        self.Type3InputBuffer = v_ptr32()


class HEAP_TAG_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Allocs = v_uint32()
        self.Frees = v_uint32()
        self.Size = v_uint32()
        self.TagIndex = v_uint16()
        self.CreatorBackTraceIndex = v_uint16()
        self.TagName = vstruct.VArray([ v_uint16() for i in xrange(24) ])


class VI_DEADLOCK_RESOURCE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint32()
        self.NodeCount = v_uint32()
        self.ResourceAddress = v_ptr32()
        self.ThreadOwner = v_ptr32()
        self.ResourceList = LIST_ENTRY()
        self.HashChainList = LIST_ENTRY()
        self.StackTrace = vstruct.VArray([ v_ptr32() for i in xrange(8) ])
        self.LastAcquireTrace = vstruct.VArray([ v_ptr32() for i in xrange(8) ])
        self.LastReleaseTrace = vstruct.VArray([ v_ptr32() for i in xrange(8) ])


class PROCESSOR_IDLE_PREPARE_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Context = v_ptr32()
        self._pad0008 = v_bytes(size=4)
        self.Constraints = PROCESSOR_IDLE_CONSTRAINTS()
        self.DependencyCount = v_uint32()
        self.DependencyUsed = v_uint32()
        self.DependencyArray = v_ptr32()
        self.PlatformIdleStateIndex = v_uint32()
        self.ProcessorIdleStateIndex = v_uint32()
        self.IdleSelectFailureMask = v_uint32()


class ALPC_COMPLETION_LIST_STATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.u1 = _unnamed_34963()


class WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Primary = v_uint32()


class TP_CALLBACK_ENVIRON_V3(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Version = v_uint32()
        self.Pool = v_ptr32()
        self.CleanupGroup = v_ptr32()
        self.CleanupGroupCancelCallback = v_ptr32()
        self.RaceDll = v_ptr32()
        self.ActivationContext = v_ptr32()
        self.FinalizationCallback = v_ptr32()
        self.u = _unnamed_25485()
        self.CallbackPriority = v_uint32()
        self.Size = v_uint32()


class WHEAP_INFO_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ErrorSourceCount = v_uint32()
        self.ErrorSourceTable = v_ptr32()
        self.WorkQueue = v_ptr32()


class SEP_LOWBOX_HANDLES_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.HashEntry = RTL_DYNAMIC_HASH_TABLE_ENTRY()
        self.ReferenceCount = v_uint32()
        self.PackageSid = v_ptr32()
        self.HandleCount = v_uint32()
        self.Handles = v_ptr32()


class VI_POOL_ENTRY_INUSE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.VirtualAddress = v_ptr32()
        self.CallingAddress = v_ptr32()
        self.NumberOfBytes = v_uint32()
        self.Tag = v_uint32()


class MEMORY_ALLOCATION_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self.MemoryType = v_uint32()
        self.BasePage = v_uint32()
        self.PageCount = v_uint32()


class MMPTE_TRANSITION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Valid = v_uint64()


class WHEA_ERROR_PACKET_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PreviousError = v_uint32()


class ARM_DBGKD_CONTROL_SET(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Continue = v_uint32()
        self.CurrentSymbolStart = v_uint32()
        self.CurrentSymbolEnd = v_uint32()


class ALPC_PROCESS_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Lock = EX_PUSH_LOCK()
        self.ViewListHead = LIST_ENTRY()
        self.PagedPoolQuotaCache = v_uint32()


class DIAGNOSTIC_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CallerType = v_uint32()
        self.Process = v_ptr32()
        self.ServiceTag = v_uint32()
        self.ReasonSize = v_uint32()


class OBJECT_HANDLE_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.HandleAttributes = v_uint32()
        self.GrantedAccess = v_uint32()


class KSPIN_LOCK_QUEUE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Next = v_ptr32()
        self.Lock = v_ptr32()


class _unnamed_34394(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NotificationCode = v_uint32()
        self.NotificationData = v_uint32()


class _unnamed_34397(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.VetoType = v_uint32()
        self.DeviceIdVetoNameBuffer = vstruct.VArray([ v_uint16() for i in xrange(1) ])
        self._pad0008 = v_bytes(size=2)


class HEAP_LOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Lock = _unnamed_30634()


class XSTATE_CONFIGURATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.EnabledFeatures = v_uint64()
        self.EnabledVolatileFeatures = v_uint64()
        self.Size = v_uint32()
        self.OptimizedSave = v_uint32()
        self.Features = vstruct.VArray([ XSTATE_FEATURE() for i in xrange(64) ])


class PS_CLIENT_SECURITY_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ImpersonationData = v_uint32()


class RTL_AVL_TABLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BalancedRoot = RTL_BALANCED_LINKS()
        self.OrderedPointer = v_ptr32()
        self.WhichOrderedElement = v_uint32()
        self.NumberGenericTableElements = v_uint32()
        self.DepthOfTree = v_uint32()
        self.RestartKey = v_ptr32()
        self.DeleteCount = v_uint32()
        self.CompareRoutine = v_ptr32()
        self.AllocateRoutine = v_ptr32()
        self.FreeRoutine = v_ptr32()
        self.TableContext = v_ptr32()


class POP_FX_DEPENDENT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Index = v_uint32()
        self.ProviderIndex = v_uint32()


class RTL_SPLAY_LINKS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Parent = v_ptr32()
        self.LeftChild = v_ptr32()
        self.RightChild = v_ptr32()


class _unnamed_26252(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Bytes = _unnamed_32530()


class PNP_ASSIGN_RESOURCES_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.IncludeFailedDevices = v_uint32()
        self.DeviceCount = v_uint32()
        self.DeviceList = vstruct.VArray([ v_ptr32() for i in xrange(1) ])


class AUTHZBASEP_CLAIM_ATTRIBUTES_COLLECTION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DeviceGroupsCount = v_uint32()
        self.pDeviceGroups = v_ptr32()
        self.RestrictedDeviceGroupsCount = v_uint32()
        self.pRestrictedDeviceGroups = v_ptr32()
        self.DeviceGroupsHash = SID_AND_ATTRIBUTES_HASH()
        self.RestrictedDeviceGroupsHash = SID_AND_ATTRIBUTES_HASH()
        self.pUserSecurityAttributes = v_ptr32()
        self.pDeviceSecurityAttributes = v_ptr32()
        self.pRestrictedUserSecurityAttributes = v_ptr32()
        self.pRestrictedDeviceSecurityAttributes = v_ptr32()


class MAPPED_FILE_SEGMENT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ControlArea = v_ptr32()
        self.TotalNumberOfPtes = v_uint32()
        self.SegmentFlags = SEGMENT_FLAGS()
        self.NumberOfCommittedPages = v_uint32()
        self.SizeOfSegment = v_uint64()
        self.ExtendInfo = v_ptr32()
        self.SegmentLock = EX_PUSH_LOCK()


class OWNER_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.OwnerThread = v_uint32()
        self.IoPriorityBoosted = v_uint32()


class EX_PUSH_LOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Locked = v_uint32()


class DEVOBJ_EXTENSION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Size = v_uint16()
        self.DeviceObject = v_ptr32()
        self.PowerFlags = v_uint32()
        self.Dope = v_ptr32()
        self.ExtensionFlags = v_uint32()
        self.DeviceNode = v_ptr32()
        self.AttachedTo = v_ptr32()
        self.StartIoCount = v_uint32()
        self.StartIoKey = v_uint32()
        self.StartIoFlags = v_uint32()
        self.Vpb = v_ptr32()
        self.DependentList = LIST_ENTRY()
        self.ProviderList = LIST_ENTRY()


class _unnamed_28186(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AllocatedResources = v_ptr32()
        self.AllocatedResourcesTranslated = v_ptr32()


class KSTACK_CONTROL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.StackBase = v_uint32()
        self.ActualLimit = v_uint32()
        self.PreviousTrapFrame = v_ptr32()
        self.PreviousExceptionList = v_ptr32()
        self.Previous = KERNEL_STACK_SEGMENT()


class ARBITER_ALLOCATION_STATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Start = v_uint64()
        self.End = v_uint64()
        self.CurrentMinimum = v_uint64()
        self.CurrentMaximum = v_uint64()
        self.Entry = v_ptr32()
        self.CurrentAlternative = v_ptr32()
        self.AlternativeCount = v_uint32()
        self.Alternatives = v_ptr32()
        self.Flags = v_uint16()
        self.RangeAttributes = v_uint8()
        self.RangeAvailableAttributes = v_uint8()
        self.WorkSpace = v_uint32()


class BLOB_TYPE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ResourceId = v_uint32()
        self.PoolTag = v_uint32()
        self.LookasideIndex = v_uint32()
        self.Flags = v_uint32()
        self.Counters = v_ptr32()
        self.DeleteProcedure = v_ptr32()
        self.DestroyProcedure = v_ptr32()
        self.UsualSize = v_uint32()


class PNP_DEVICE_ACTION_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self.DeviceObject = v_ptr32()
        self.RequestType = v_uint32()
        self.ReorderingBarrier = v_uint8()
        self._pad0014 = v_bytes(size=3)
        self.RequestArgument = v_uint32()
        self.CompletionEvent = v_ptr32()
        self.CompletionStatus = v_ptr32()


class OPEN_PACKET(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Size = v_uint16()
        self.FileObject = v_ptr32()
        self.FinalStatus = v_uint32()
        self.Information = v_uint32()
        self.ParseCheck = v_uint32()
        self.RelatedFileObject = v_ptr32()
        self.OriginalAttributes = v_ptr32()
        self._pad0020 = v_bytes(size=4)
        self.AllocationSize = LARGE_INTEGER()
        self.CreateOptions = v_uint32()
        self.FileAttributes = v_uint16()
        self.ShareAccess = v_uint16()
        self.EaBuffer = v_ptr32()
        self.EaLength = v_uint32()
        self.Options = v_uint32()
        self.Disposition = v_uint32()
        self.BasicInformation = v_ptr32()
        self.NetworkInformation = v_ptr32()
        self.CreateFileType = v_uint32()
        self.MailslotOrPipeParameters = v_ptr32()
        self.Override = v_uint8()
        self.QueryOnly = v_uint8()
        self.DeleteOnly = v_uint8()
        self.FullAttributes = v_uint8()
        self.LocalFileObject = v_ptr32()
        self.InternalFlags = v_uint32()
        self.AccessMode = v_uint8()
        self._pad0060 = v_bytes(size=3)
        self.DriverCreateContext = IO_DRIVER_CREATE_CONTEXT()


class HANDLE_TABLE_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.VolatileLowValue = v_uint32()
        self.HighValue = v_uint32()


class HEAP_COUNTERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TotalMemoryReserved = v_uint32()
        self.TotalMemoryCommitted = v_uint32()
        self.TotalMemoryLargeUCR = v_uint32()
        self.TotalSizeInVirtualBlocks = v_uint32()
        self.TotalSegments = v_uint32()
        self.TotalUCRs = v_uint32()
        self.CommittOps = v_uint32()
        self.DeCommitOps = v_uint32()
        self.LockAcquires = v_uint32()
        self.LockCollisions = v_uint32()
        self.CommitRate = v_uint32()
        self.DecommittRate = v_uint32()
        self.CommitFailures = v_uint32()
        self.InBlockCommitFailures = v_uint32()
        self.PollIntervalCounter = v_uint32()
        self.DecommitsSinceLastCheck = v_uint32()
        self.HeapPollInterval = v_uint32()
        self.AllocAndFreeOps = v_uint32()
        self.AllocationIndicesActive = v_uint32()
        self.InBlockDeccommits = v_uint32()
        self.InBlockDeccomitSize = v_uint32()
        self.HighWatermarkSize = v_uint32()
        self.LastPolledSize = v_uint32()


class WHEA_MEMORY_ERROR_SECTION_VALIDBITS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ErrorStatus = v_uint64()


class BLOB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ResourceList = LIST_ENTRY()
        self.u1 = _unnamed_30805()
        self.ResourceId = v_uint8()
        self.CachedReferences = v_uint16()
        self.ReferenceCount = v_uint32()
        self.Pad = v_uint32()
        self.Lock = EX_PUSH_LOCK()


class WORK_QUEUE_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.WorkQueueLinks = LIST_ENTRY()
        self.Parameters = _unnamed_30472()
        self.Function = v_uint8()
        self._pad0010 = v_bytes(size=3)


class PI_BUS_EXTENSION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flags = v_uint32()
        self.NumberCSNs = v_uint8()
        self._pad0008 = v_bytes(size=3)
        self.ReadDataPort = v_ptr32()
        self.DataPortMapped = v_uint8()
        self._pad0010 = v_bytes(size=3)
        self.AddressPort = v_ptr32()
        self.AddrPortMapped = v_uint8()
        self._pad0018 = v_bytes(size=3)
        self.CommandPort = v_ptr32()
        self.CmdPortMapped = v_uint8()
        self._pad0020 = v_bytes(size=3)
        self.NextSlotNumber = v_uint32()
        self.DeviceList = SINGLE_LIST_ENTRY()
        self.CardList = SINGLE_LIST_ENTRY()
        self.PhysicalBusDevice = v_ptr32()
        self.FunctionalBusDevice = v_ptr32()
        self.AttachedDevice = v_ptr32()
        self.BusNumber = v_uint32()
        self.SystemPowerState = v_uint32()
        self.DevicePowerState = v_uint32()


class MAILSLOT_CREATE_PARAMETERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MailslotQuota = v_uint32()
        self.MaximumMessageSize = v_uint32()
        self.ReadTimeout = LARGE_INTEGER()
        self.TimeoutSpecified = v_uint8()
        self._pad0018 = v_bytes(size=7)


class _unnamed_28043(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.InterfaceType = v_ptr32()
        self.Size = v_uint16()
        self.Version = v_uint16()
        self.Interface = v_ptr32()
        self.InterfaceSpecificData = v_ptr32()


class FS_FILTER_CALLBACK_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SizeOfFsFilterCallbackData = v_uint32()
        self.Operation = v_uint8()
        self.Reserved = v_uint8()
        self._pad0008 = v_bytes(size=2)
        self.DeviceObject = v_ptr32()
        self.FileObject = v_ptr32()
        self.Parameters = FS_FILTER_PARAMETERS()


class PPM_IDLE_STATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DomainMembers = KAFFINITY_EX()
        self.Latency = v_uint32()
        self.Power = v_uint32()
        self.StateFlags = v_uint32()
        self.StateType = v_uint8()
        self.InterruptsEnabled = v_uint8()
        self.Interruptible = v_uint8()
        self.ContextRetained = v_uint8()
        self.CacheCoherent = v_uint8()
        self._pad0020 = v_bytes(size=3)


class IO_RESOURCE_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Option = v_uint8()
        self.Type = v_uint8()
        self.ShareDisposition = v_uint8()
        self.Spare1 = v_uint8()
        self.Flags = v_uint16()
        self.Spare2 = v_uint16()
        self.u = _unnamed_33989()


class ACCESS_STATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.OperationID = LUID()
        self.SecurityEvaluated = v_uint8()
        self.GenerateAudit = v_uint8()
        self.GenerateOnClose = v_uint8()
        self.PrivilegesAllocated = v_uint8()
        self.Flags = v_uint32()
        self.RemainingDesiredAccess = v_uint32()
        self.PreviouslyGrantedAccess = v_uint32()
        self.OriginalDesiredAccess = v_uint32()
        self.SubjectSecurityContext = SECURITY_SUBJECT_CONTEXT()
        self.SecurityDescriptor = v_ptr32()
        self.AuxData = v_ptr32()
        self.Privileges = _unnamed_27432()
        self.AuditPrivileges = v_uint8()
        self._pad0064 = v_bytes(size=3)
        self.ObjectName = UNICODE_STRING()
        self.ObjectTypeName = UNICODE_STRING()


class RTL_ATOM_TABLE_REFERENCE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LowBoxList = LIST_ENTRY()
        self.LowBoxID = v_uint32()
        self.ReferenceCount = v_uint16()
        self.Flags = v_uint16()


class DBGKD_SWITCH_PARTITION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Partition = v_uint32()


class TP_CALLBACK_INSTANCE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class _unnamed_27809(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DeviceQueueEntry = KDEVICE_QUEUE_ENTRY()
        self.Thread = v_ptr32()
        self.AuxiliaryBuffer = v_ptr32()
        self.ListEntry = LIST_ENTRY()
        self.CurrentStackLocation = v_ptr32()
        self.OriginalFileObject = v_ptr32()
        self.IrpExtension = v_ptr32()


class PROC_IDLE_ACCOUNTING(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.StateCount = v_uint32()
        self.TotalTransitions = v_uint32()
        self.ResetCount = v_uint32()
        self.AbortCount = v_uint32()
        self.StartTime = v_uint64()
        self.PriorIdleTime = v_uint64()
        self.TimeUnit = v_uint32()
        self._pad0028 = v_bytes(size=4)
        self.State = vstruct.VArray([ PROC_IDLE_STATE_ACCOUNTING() for i in xrange(1) ])


class _unnamed_32010(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.XpfMceDescriptor = WHEA_XPF_MCE_DESCRIPTOR()
        self._pad03a4 = v_bytes(size=12)


class GDI_TEB_BATCH(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Offset = v_uint32()
        self.HDC = v_uint32()
        self.Buffer = vstruct.VArray([ v_uint32() for i in xrange(310) ])


class DBGKD_SET_SPECIAL_CALL32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SpecialCall = v_uint32()


class STRING32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint16()
        self.MaximumLength = v_uint16()
        self.Buffer = v_uint32()


class DBGKD_LOAD_SYMBOLS32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PathNameLength = v_uint32()
        self.BaseOfDll = v_uint32()
        self.ProcessId = v_uint32()
        self.CheckSum = v_uint32()
        self.SizeOfImage = v_uint32()
        self.UnloadSymbols = v_uint8()
        self._pad0018 = v_bytes(size=3)


class tagSWITCH_CONTEXT_ATTRIBUTE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ulContextUpdateCounter = v_uint64()
        self.fAllowContextUpdate = v_uint32()
        self.fEnableTrace = v_uint32()
        self.EtwHandle = v_uint64()


class DBGKM_EXCEPTION32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ExceptionRecord = EXCEPTION_RECORD32()
        self.FirstChance = v_uint32()


class _unnamed_29100(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.IoStatus = IO_STATUS_BLOCK()


class PAGEFAULT_HISTORY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class PNP_RESERVED_PROVIDER_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self.DependentList = LIST_ENTRY()
        self.ReservationId = UNICODE_STRING()
        self.ReferenceCount = v_uint32()


class ECP_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint32()
        self.Flags = v_uint32()
        self.EcpList = LIST_ENTRY()


class ENODE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Ncb = KNODE()
        self.ExWorkerQueues = vstruct.VArray([ EX_WORK_QUEUE() for i in xrange(7) ])
        self.ExpThreadSetManagerEvent = KEVENT()
        self.ExpWorkerThreadBalanceManagerPtr = v_ptr32()
        self.ExpWorkerSeed = v_uint32()
        self.ExWorkerFullInit = v_uint32()
        self._pad0280 = v_bytes(size=28)


class PROCESSOR_PERFSTATE_POLICY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Revision = v_uint32()
        self.MaxThrottle = v_uint8()
        self.MinThrottle = v_uint8()
        self.BusyAdjThreshold = v_uint8()
        self.Spare = v_uint8()
        self.TimeCheck = v_uint32()
        self.IncreaseTime = v_uint32()
        self.DecreaseTime = v_uint32()
        self.IncreasePercent = v_uint32()
        self.DecreasePercent = v_uint32()


class NT_TIB64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ExceptionList = v_uint64()
        self.StackBase = v_uint64()
        self.StackLimit = v_uint64()
        self.SubSystemTib = v_uint64()
        self.FiberData = v_uint64()
        self.ArbitraryUserPointer = v_uint64()
        self.Self = v_uint64()


class SECTION_OBJECT_POINTERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DataSectionObject = v_ptr32()
        self.SharedCacheMap = v_ptr32()
        self.ImageSectionObject = v_ptr32()


class MDL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Next = v_ptr32()
        self.Size = v_uint16()
        self.MdlFlags = v_uint16()
        self.Process = v_ptr32()
        self.MappedSystemVa = v_ptr32()
        self.StartVa = v_ptr32()
        self.ByteCount = v_uint32()
        self.ByteOffset = v_uint32()


class _unnamed_30472(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Read = _unnamed_30473()


class KTRAP_FRAME(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DbgEbp = v_uint32()
        self.DbgEip = v_uint32()
        self.DbgArgMark = v_uint32()
        self.DbgArgPointer = v_uint32()
        self.TempSegCs = v_uint16()
        self.Logging = v_uint8()
        self.FrameType = v_uint8()
        self.TempEsp = v_uint32()
        self.Dr0 = v_uint32()
        self.Dr1 = v_uint32()
        self.Dr2 = v_uint32()
        self.Dr3 = v_uint32()
        self.Dr6 = v_uint32()
        self.Dr7 = v_uint32()
        self.SegGs = v_uint32()
        self.SegEs = v_uint32()
        self.SegDs = v_uint32()
        self.Edx = v_uint32()
        self.Ecx = v_uint32()
        self.Eax = v_uint32()
        self.PreviousPreviousMode = v_uint8()
        self.EntropyQueueDpc = v_uint8()
        self.Reserved = vstruct.VArray([ v_uint8() for i in xrange(2) ])
        self.ExceptionList = v_ptr32()
        self.SegFs = v_uint32()
        self.Edi = v_uint32()
        self.Esi = v_uint32()
        self.Ebx = v_uint32()
        self.Ebp = v_uint32()
        self.ErrCode = v_uint32()
        self.Eip = v_uint32()
        self.SegCs = v_uint32()
        self.EFlags = v_uint32()
        self.HardwareEsp = v_uint32()
        self.HardwareSegSs = v_uint32()
        self.V86Es = v_uint32()
        self.V86Ds = v_uint32()
        self.V86Fs = v_uint32()
        self.V86Gs = v_uint32()


class _unnamed_34931(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TestAllocation = ARBITER_TEST_ALLOCATION_PARAMETERS()
        self._pad0010 = v_bytes(size=4)


class _unnamed_30475(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SharedCacheMap = v_ptr32()


class CM_INDEX_HINT_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Count = v_uint32()
        self.HashKey = vstruct.VArray([ v_uint32() for i in xrange(1) ])


class _unnamed_30477(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Event = v_ptr32()


class PRIVATE_CACHE_MAP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NodeTypeCode = v_uint16()
        self._pad0004 = v_bytes(size=2)
        self.ReadAheadMask = v_uint32()
        self.FileObject = v_ptr32()
        self._pad0010 = v_bytes(size=4)
        self.FileOffset1 = LARGE_INTEGER()
        self.BeyondLastByte1 = LARGE_INTEGER()
        self.FileOffset2 = LARGE_INTEGER()
        self.BeyondLastByte2 = LARGE_INTEGER()
        self.SequentialReadCount = v_uint32()
        self.ReadAheadLength = v_uint32()
        self.ReadAheadOffset = LARGE_INTEGER()
        self.ReadAheadBeyondLastByte = LARGE_INTEGER()
        self.PrevReadAheadBeyondLastByte = v_uint64()
        self.ReadAheadSpinLock = v_uint32()
        self.PipelinedReadAheadRequestSize = v_uint32()
        self.ReadAheadGrowth = v_uint32()
        self.PrivateLinks = LIST_ENTRY()
        self.ReadAheadWorkItem = v_ptr32()


class MMPTE_SOFTWARE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Valid = v_uint64()


class IO_TIMER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.TimerFlag = v_uint16()
        self.TimerList = LIST_ENTRY()
        self.TimerRoutine = v_ptr32()
        self.Context = v_ptr32()
        self.DeviceObject = v_ptr32()


class MM_STORE_KEY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.KeyLow = v_uint32()


class OBJECT_CREATE_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Attributes = v_uint32()
        self.RootDirectory = v_ptr32()
        self.ProbeMode = v_uint8()
        self._pad000c = v_bytes(size=3)
        self.PagedPoolCharge = v_uint32()
        self.NonPagedPoolCharge = v_uint32()
        self.SecurityDescriptorCharge = v_uint32()
        self.SecurityDescriptor = v_ptr32()
        self.SecurityQos = v_ptr32()
        self.SecurityQualityOfService = SECURITY_QUALITY_OF_SERVICE()


class WHEA_REVISION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MinorRevision = v_uint8()
        self.MajorRevision = v_uint8()


class KSECONDARY_IDT_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SpinLock = v_uint32()
        self.ConnectLock = KEVENT()
        self.LineMasked = v_uint8()
        self._pad0018 = v_bytes(size=3)
        self.InterruptList = v_ptr32()


class TP_CLEANUP_GROUP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class MM_SESSION_SPACE_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Initialized = v_uint32()


class CVDD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint32()
        self._pad001c = v_bytes(size=24)


class EVENT_FILTER_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Id = v_uint16()
        self.Version = v_uint8()
        self.Reserved = vstruct.VArray([ v_uint8() for i in xrange(5) ])
        self.InstanceId = v_uint64()
        self.Size = v_uint32()
        self.NextOffset = v_uint32()


class PROC_IDLE_SNAP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Time = v_uint64()
        self.Idle = v_uint64()


class POP_FX_DRIVER_CALLBACKS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ComponentActive = v_ptr32()
        self.ComponentIdle = v_ptr32()
        self.ComponentIdleState = v_ptr32()
        self.DevicePowerRequired = v_ptr32()
        self.DevicePowerNotRequired = v_ptr32()
        self.PowerControl = v_ptr32()
        self.ComponentCriticalTransition = v_ptr32()


class PO_NOTIFY_ORDER_LEVEL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DeviceCount = v_uint32()
        self.ActiveCount = v_uint32()
        self.WaitSleep = LIST_ENTRY()
        self.ReadySleep = LIST_ENTRY()
        self.ReadyS0 = LIST_ENTRY()
        self.WaitS0 = LIST_ENTRY()


class SECURITY_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Revision = v_uint8()
        self.Sbz1 = v_uint8()
        self.Control = v_uint16()
        self.Owner = v_ptr32()
        self.Group = v_ptr32()
        self.Sacl = v_ptr32()
        self.Dacl = v_ptr32()


class PCW_PROCESSOR_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.IdleTime = v_uint64()
        self.AvailableTime = v_uint64()
        self.UserTime = v_uint64()
        self.KernelTime = v_uint64()
        self.Interrupts = v_uint32()
        self._pad0028 = v_bytes(size=4)
        self.DpcTime = v_uint64()
        self.InterruptTime = v_uint64()
        self.ClockInterrupts = v_uint32()
        self.DpcCount = v_uint32()
        self.DpcRate = v_uint32()
        self._pad0048 = v_bytes(size=4)
        self.C1Time = v_uint64()
        self.C2Time = v_uint64()
        self.C3Time = v_uint64()
        self.C1Transitions = v_uint64()
        self.C2Transitions = v_uint64()
        self.C3Transitions = v_uint64()
        self.ParkingStatus = v_uint32()
        self.CurrentFrequency = v_uint32()
        self.PercentMaxFrequency = v_uint32()
        self.StateFlags = v_uint32()
        self.NominalThroughput = v_uint32()
        self.ActiveThroughput = v_uint32()
        self.ScaledThroughput = v_uint64()
        self.ScaledKernelThroughput = v_uint64()
        self.AverageIdleTime = v_uint64()
        self.IdleBreakEvents = v_uint64()
        self.PerformanceLimit = v_uint32()
        self.PerformanceLimitFlags = v_uint32()


class OBJECT_TYPE_INITIALIZER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint16()
        self.ObjectTypeFlags = v_uint8()
        self._pad0004 = v_bytes(size=1)
        self.ObjectTypeCode = v_uint32()
        self.InvalidAttributes = v_uint32()
        self.GenericMapping = GENERIC_MAPPING()
        self.ValidAccessMask = v_uint32()
        self.RetainAccess = v_uint32()
        self.PoolType = v_uint32()
        self.DefaultPagedPoolCharge = v_uint32()
        self.DefaultNonPagedPoolCharge = v_uint32()
        self.DumpProcedure = v_ptr32()
        self.OpenProcedure = v_ptr32()
        self.CloseProcedure = v_ptr32()
        self.DeleteProcedure = v_ptr32()
        self.ParseProcedure = v_ptr32()
        self.SecurityProcedure = v_ptr32()
        self.QueryNameProcedure = v_ptr32()
        self.OkayToCloseProcedure = v_ptr32()
        self.WaitObjectFlagMask = v_uint32()
        self.WaitObjectFlagOffset = v_uint16()
        self.WaitObjectPointerOffset = v_uint16()


class VACB_LEVEL_REFERENCE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Reference = v_uint32()
        self.SpecialReference = v_uint32()


class XSTATE_SAVE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Reserved1 = v_uint64()
        self.Reserved2 = v_uint32()
        self.Prev = v_ptr32()
        self.Reserved3 = v_ptr32()
        self.Thread = v_ptr32()
        self.Reserved4 = v_ptr32()
        self.Level = v_uint8()
        self._pad0020 = v_bytes(size=3)


class PTE_TRACKER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self.Mdl = v_ptr32()
        self.Count = v_uint32()
        self.SystemVa = v_ptr32()
        self.StartVa = v_ptr32()
        self.Offset = v_uint32()
        self.Length = v_uint32()
        self.Page = v_uint32()
        self.IoMapping = v_uint32()
        self.StackTrace = vstruct.VArray([ v_ptr32() for i in xrange(7) ])


class HEAP_ENTRY_EXTRA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AllocatorBackTraceIndex = v_uint16()
        self.TagIndex = v_uint16()
        self.Settable = v_uint32()


class _unnamed_27861(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SecurityContext = v_ptr32()
        self.Options = v_uint32()
        self.Reserved = v_uint16()
        self.ShareAccess = v_uint16()
        self.Parameters = v_ptr32()


class _unnamed_34023(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.UserData = v_uint32()


class HEAP_PSEUDO_TAG_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Allocs = v_uint32()
        self.Frees = v_uint32()
        self.Size = v_uint32()


class _unnamed_34026(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.u = _unnamed_34023()


class CM_KEY_REFERENCE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.KeyCell = v_uint32()
        self.KeyHive = v_ptr32()


class MMSECTION_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BeingDeleted = v_uint32()


class MI_SPECIAL_POOL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Lock = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.Paged = MI_PTE_CHAIN_HEAD()
        self.NonPaged = MI_PTE_CHAIN_HEAD()
        self.PagesInUse = v_uint32()
        self.SpecialPoolPdes = RTL_BITMAP()
        self._pad0048 = v_bytes(size=4)


class DBGKD_GET_INTERNAL_BREAKPOINT64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BreakpointAddress = v_uint64()
        self.Flags = v_uint32()
        self.Calls = v_uint32()
        self.MaxCallsPerPeriod = v_uint32()
        self.MinInstructions = v_uint32()
        self.MaxInstructions = v_uint32()
        self.TotalInstructions = v_uint32()


class CONTROL_AREA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Segment = v_ptr32()
        self.ListHead = LIST_ENTRY()
        self.NumberOfSectionReferences = v_uint32()
        self.NumberOfPfnReferences = v_uint32()
        self.NumberOfMappedViews = v_uint32()
        self.NumberOfUserReferences = v_uint32()
        self.u = _unnamed_28971()
        self.FlushInProgressCount = v_uint32()
        self.FilePointer = EX_FAST_REF()
        self.ControlAreaLock = v_uint32()
        self.ModifiedWriteCount = v_uint32()
        self.WaitList = v_ptr32()
        self.u2 = _unnamed_28974()
        self.LockedPages = v_uint64()


class MODWRITER_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.KeepForever = v_uint32()


class _unnamed_35375(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.EndingOffset = v_ptr32()
        self.ResourceToRelease = v_ptr32()


class _unnamed_35376(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ResourceToRelease = v_ptr32()


class CM_TRANS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TransactionListEntry = LIST_ENTRY()
        self.KCBUoWListHead = LIST_ENTRY()
        self.LazyCommitListEntry = LIST_ENTRY()
        self.KtmTrans = v_ptr32()
        self.CmRm = v_ptr32()
        self.KtmEnlistmentObject = v_ptr32()
        self.KtmEnlistmentHandle = v_ptr32()
        self.KtmUow = GUID()
        self.StartLsn = v_uint64()
        self.TransState = v_uint32()
        self.HiveCount = v_uint32()
        self.HiveArray = vstruct.VArray([ v_ptr32() for i in xrange(7) ])
        self._pad0068 = v_bytes(size=4)


class POP_POWER_ACTION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Updates = v_uint8()
        self.State = v_uint8()
        self.Shutdown = v_uint8()
        self._pad0004 = v_bytes(size=1)
        self.Action = v_uint32()
        self.LightestState = v_uint32()
        self.Flags = v_uint32()
        self.Status = v_uint32()
        self.DeviceType = v_uint32()
        self.DeviceTypeFlags = v_uint32()
        self.IrpMinor = v_uint8()
        self.Waking = v_uint8()
        self._pad0020 = v_bytes(size=2)
        self.SystemState = v_uint32()
        self.NextSystemState = v_uint32()
        self.EffectiveSystemState = v_uint32()
        self.CurrentSystemState = v_uint32()
        self.ShutdownBugCode = v_ptr32()
        self.DevState = v_ptr32()
        self.HiberContext = v_ptr32()
        self._pad0040 = v_bytes(size=4)
        self.WakeTime = v_uint64()
        self.SleepTime = v_uint64()
        self.WakeAlarmSignaled = v_uint32()
        self._pad0058 = v_bytes(size=4)
        self.WakeAlarm = vstruct.VArray([ _unnamed_35222() for i in xrange(3) ])
        self.FilteredCapabilities = SYSTEM_POWER_CAPABILITIES()
        self._pad00d8 = v_bytes(size=4)


class _unnamed_35379(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Argument1 = v_ptr32()
        self.Argument2 = v_ptr32()
        self.Argument3 = v_ptr32()
        self.Argument4 = v_ptr32()
        self.Argument5 = v_ptr32()


class EPROCESS_VALUES(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.KernelTime = v_uint64()
        self.UserTime = v_uint64()
        self.CycleTime = v_uint64()
        self.ContextSwitches = v_uint64()
        self.ReadOperationCount = v_uint64()
        self.WriteOperationCount = v_uint64()
        self.OtherOperationCount = v_uint64()
        self.ReadTransferCount = v_uint64()
        self.WriteTransferCount = v_uint64()
        self.OtherTransferCount = v_uint64()


class OBJECT_HEADER_CREATOR_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TypeList = LIST_ENTRY()
        self.CreatorUniqueProcess = v_ptr32()
        self.CreatorBackTraceIndex = v_uint16()
        self.Reserved = v_uint16()


class PAGED_LOOKASIDE_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.L = GENERAL_LOOKASIDE()
        self.Lock__ObsoleteButDoNotDelete = FAST_MUTEX()
        self._pad00c0 = v_bytes(size=32)


class MBCB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NodeTypeCode = v_uint16()
        self.NodeIsInZone = v_uint16()
        self.PagesToWrite = v_uint32()
        self.DirtyPages = v_uint32()
        self.Reserved = v_uint32()
        self.BitmapRanges = LIST_ENTRY()
        self.ResumeWritePage = v_uint64()
        self.MostRecentlyDirtiedPage = v_uint64()
        self.BitmapRange1 = BITMAP_RANGE()
        self.BitmapRange2 = BITMAP_RANGE()
        self.BitmapRange3 = BITMAP_RANGE()


class PROCESS_DISK_COUNTERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BytesRead = v_uint64()
        self.BytesWritten = v_uint64()
        self.ReadOperationCount = v_uint64()
        self.WriteOperationCount = v_uint64()
        self.FlushOperationCount = v_uint64()


class RTL_BITMAP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SizeOfBitMap = v_uint32()
        self.Buffer = v_ptr32()


class LARGE_INTEGER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LowPart = v_uint32()
        self.HighPart = v_uint32()


class IA64_DBGKD_CONTROL_SET(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Continue = v_uint32()
        self.CurrentSymbolStart = v_uint64()
        self.CurrentSymbolEnd = v_uint64()


class PCW_REGISTRATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class _unnamed_27868(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.Key = v_uint32()
        self.ByteOffset = LARGE_INTEGER()


class HBIN(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint32()
        self.FileOffset = v_uint32()
        self.Size = v_uint32()
        self.Reserved1 = vstruct.VArray([ v_uint32() for i in xrange(2) ])
        self.TimeStamp = LARGE_INTEGER()
        self.Spare = v_uint32()


class _unnamed_28130(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.InPath = v_uint8()
        self.Reserved = vstruct.VArray([ v_uint8() for i in xrange(3) ])
        self.Type = v_uint32()


class WHEA_AER_ENDPOINT_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Enabled = v_uint8()
        self.Reserved = v_uint8()
        self.BusNumber = v_uint32()
        self.Slot = WHEA_PCI_SLOT_NUMBER()
        self.DeviceControl = v_uint16()
        self.Flags = AER_ENDPOINT_DESCRIPTOR_FLAGS()
        self.UncorrectableErrorMask = v_uint32()
        self.UncorrectableErrorSeverity = v_uint32()
        self.CorrectableErrorMask = v_uint32()
        self.AdvancedCapsAndControl = v_uint32()


class NPAGED_LOOKASIDE_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.L = GENERAL_LOOKASIDE()
        self.Lock__ObsoleteButDoNotDelete = v_uint32()
        self._pad00c0 = v_bytes(size=60)


class LEARNING_MODE_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Settings = v_uint32()
        self.Enabled = v_uint8()
        self.PermissiveModeEnabled = v_uint8()
        self._pad0008 = v_bytes(size=2)


class RTL_DYNAMIC_HASH_TABLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flags = v_uint32()
        self.Shift = v_uint32()
        self.TableSize = v_uint32()
        self.Pivot = v_uint32()
        self.DivisorMask = v_uint32()
        self.NumEntries = v_uint32()
        self.NonEmptyBuckets = v_uint32()
        self.NumEnumerators = v_uint32()
        self.Directory = v_ptr32()


class BITMAP_RANGE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Links = LIST_ENTRY()
        self.BasePage = v_uint64()
        self.FirstDirtyPage = v_uint32()
        self.LastDirtyPage = v_uint32()
        self.DirtyPages = v_uint32()
        self.Bitmap = v_ptr32()


class ETW_REG_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.RegList = LIST_ENTRY()
        self.GuidEntry = v_ptr32()
        self.ReplyQueue = v_ptr32()
        self.SessionId = v_uint32()
        self._pad001c = v_bytes(size=8)
        self.Process = v_ptr32()
        self.Callback = v_ptr32()
        self.Index = v_uint16()
        self.Flags = v_uint8()
        self.EnableMask = v_uint8()


class PLATFORM_IDLE_STATE_ACCOUNTING(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CancelCount = v_uint32()
        self.FailureCount = v_uint32()
        self.SuccessCount = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.MaxTime = v_uint64()
        self.MinTime = v_uint64()
        self.TotalTime = v_uint64()
        self.InvalidBucketIndex = v_uint32()
        self._pad0030 = v_bytes(size=4)
        self.IdleTimeBuckets = vstruct.VArray([ PROC_IDLE_STATE_BUCKET() for i in xrange(26) ])


class KLOCK_QUEUE_HANDLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LockQueue = KSPIN_LOCK_QUEUE()
        self.OldIrql = v_uint8()
        self._pad000c = v_bytes(size=3)


class TRACE_LOGFILE_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BufferSize = v_uint32()
        self.Version = v_uint32()
        self.ProviderVersion = v_uint32()
        self.NumberOfProcessors = v_uint32()
        self.EndTime = LARGE_INTEGER()
        self.TimerResolution = v_uint32()
        self.MaximumFileSize = v_uint32()
        self.LogFileMode = v_uint32()
        self.BuffersWritten = v_uint32()
        self.LogInstanceGuid = GUID()
        self.LoggerName = v_ptr32()
        self.LogFileName = v_ptr32()
        self.TimeZone = RTL_TIME_ZONE_INFORMATION()
        self._pad00f0 = v_bytes(size=4)
        self.BootTime = LARGE_INTEGER()
        self.PerfFreq = LARGE_INTEGER()
        self.StartTime = LARGE_INTEGER()
        self.ReservedFlags = v_uint32()
        self.BuffersLost = v_uint32()


class CLIENT_ID32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.UniqueProcess = v_uint32()
        self.UniqueThread = v_uint32()


class CLS_LSN(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.offset = _unnamed_36524()


class _unnamed_27432(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.InitialPrivilegeSet = INITIAL_PRIVILEGE_SET()


class VPB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Size = v_uint16()
        self.Flags = v_uint16()
        self.VolumeLabelLength = v_uint16()
        self.DeviceObject = v_ptr32()
        self.RealDevice = v_ptr32()
        self.SerialNumber = v_uint32()
        self.ReferenceCount = v_uint32()
        self.VolumeLabel = vstruct.VArray([ v_uint16() for i in xrange(32) ])


class _unnamed_34115(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.MinBusNumber = v_uint32()
        self.MaxBusNumber = v_uint32()
        self.Reserved = v_uint32()


class WHEAP_ERROR_SOURCE_TABLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint32()
        self.Count = v_uint32()
        self.Items = LIST_ENTRY()
        self.InsertLock = KEVENT()


class OBP_LOOKUP_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Directory = v_ptr32()
        self.Object = v_ptr32()
        self.EntryLink = v_ptr32()
        self.HashValue = v_uint32()
        self.HashIndex = v_uint16()
        self.DirectoryLocked = v_uint8()
        self.LockedExclusive = v_uint8()
        self.LockStateSignature = v_uint32()


class OB_DUPLICATE_OBJECT_STATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SourceProcess = v_ptr32()
        self.SourceHandle = v_ptr32()
        self.Object = v_ptr32()
        self.TargetAccess = v_uint32()
        self.ObjectInfo = HANDLE_TABLE_ENTRY_INFO()
        self.HandleAttributes = v_uint32()


class PP_LOOKASIDE_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.P = v_ptr32()
        self.L = v_ptr32()


class SEP_LOGON_SESSION_REFERENCES(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Next = v_ptr32()
        self.LogonId = LUID()
        self.BuddyLogonId = LUID()
        self.ReferenceCount = v_uint32()
        self.Flags = v_uint32()
        self.pDeviceMap = v_ptr32()
        self.Token = v_ptr32()
        self.AccountName = UNICODE_STRING()
        self.AuthorityName = UNICODE_STRING()
        self.LowBoxHandlesTable = SEP_LOWBOX_HANDLES_TABLE()


class JOBOBJECT_WAKE_FILTER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.HighEdgeFilter = v_uint32()
        self.LowEdgeFilter = v_uint32()


class _unnamed_29797(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DockStatus = v_uint32()
        self.ListEntry = LIST_ENTRY()
        self.SerialNumber = v_ptr32()


class MMPTE_TIMESTAMP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MustBeZero = v_uint64()


class OBJECT_NAME_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Name = UNICODE_STRING()


class OBJECT_HEADER_PROCESS_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ExclusiveProcess = v_ptr32()
        self.Reserved = v_uint32()


class KUSER_SHARED_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TickCountLowDeprecated = v_uint32()
        self.TickCountMultiplier = v_uint32()
        self.InterruptTime = KSYSTEM_TIME()
        self.SystemTime = KSYSTEM_TIME()
        self.TimeZoneBias = KSYSTEM_TIME()
        self.ImageNumberLow = v_uint16()
        self.ImageNumberHigh = v_uint16()
        self.NtSystemRoot = vstruct.VArray([ v_uint16() for i in xrange(260) ])
        self.MaxStackTraceDepth = v_uint32()
        self.CryptoExponent = v_uint32()
        self.TimeZoneId = v_uint32()
        self.LargePageMinimum = v_uint32()
        self.AitSamplingValue = v_uint32()
        self.AppCompatFlag = v_uint32()
        self.RNGSeedVersion = v_uint64()
        self.GlobalValidationRunlevel = v_uint32()
        self.TimeZoneBiasStamp = v_uint32()
        self.Reserved2 = v_uint32()
        self.NtProductType = v_uint32()
        self.ProductTypeIsValid = v_uint8()
        self.Reserved0 = vstruct.VArray([ v_uint8() for i in xrange(1) ])
        self.NativeProcessorArchitecture = v_uint16()
        self.NtMajorVersion = v_uint32()
        self.NtMinorVersion = v_uint32()
        self.ProcessorFeatures = vstruct.VArray([ v_uint8() for i in xrange(64) ])
        self.Reserved1 = v_uint32()
        self.Reserved3 = v_uint32()
        self.TimeSlip = v_uint32()
        self.AlternativeArchitecture = v_uint32()
        self.AltArchitecturePad = vstruct.VArray([ v_uint32() for i in xrange(1) ])
        self.SystemExpirationDate = LARGE_INTEGER()
        self.SuiteMask = v_uint32()
        self.KdDebuggerEnabled = v_uint8()
        self.MitigationPolicies = v_uint8()
        self.Reserved6 = vstruct.VArray([ v_uint8() for i in xrange(2) ])
        self.ActiveConsoleId = v_uint32()
        self.DismountCount = v_uint32()
        self.ComPlusPackage = v_uint32()
        self.LastSystemRITEventTickCount = v_uint32()
        self.NumberOfPhysicalPages = v_uint32()
        self.SafeBootMode = v_uint8()
        self.Reserved12 = vstruct.VArray([ v_uint8() for i in xrange(3) ])
        self.SharedDataFlags = v_uint32()
        self.DataFlagsPad = vstruct.VArray([ v_uint32() for i in xrange(1) ])
        self.TestRetInstruction = v_uint64()
        self.QpcFrequency = v_uint64()
        self.SystemCallPad = vstruct.VArray([ v_uint64() for i in xrange(3) ])
        self.TickCount = KSYSTEM_TIME()
        self.TickCountPad = vstruct.VArray([ v_uint32() for i in xrange(1) ])
        self.Cookie = v_uint32()
        self.CookiePad = vstruct.VArray([ v_uint32() for i in xrange(1) ])
        self.ConsoleSessionForegroundProcessId = v_uint64()
        self.TimeUpdateSequence = v_uint64()
        self.BaselineSystemTimeQpc = v_uint64()
        self.BaselineInterruptTimeQpc = v_uint64()
        self.QpcSystemTimeIncrement = v_uint64()
        self.QpcInterruptTimeIncrement = v_uint64()
        self.QpcSystemTimeIncrement32 = v_uint32()
        self.QpcInterruptTimeIncrement32 = v_uint32()
        self.QpcSystemTimeIncrementShift = v_uint8()
        self.QpcInterruptTimeIncrementShift = v_uint8()
        self.Reserved8 = vstruct.VArray([ v_uint8() for i in xrange(14) ])
        self.UserModeGlobalLogger = vstruct.VArray([ v_uint16() for i in xrange(16) ])
        self.ImageFileExecutionOptions = v_uint32()
        self.LangGenerationCount = v_uint32()
        self.Reserved4 = v_uint64()
        self.InterruptTimeBias = v_uint64()
        self.TscQpcBias = v_uint64()
        self.ActiveProcessorCount = v_uint32()
        self.ActiveGroupCount = v_uint8()
        self.Reserved9 = v_uint8()
        self.TscQpcData = v_uint16()
        self.TimeZoneBiasEffectiveStart = LARGE_INTEGER()
        self.TimeZoneBiasEffectiveEnd = LARGE_INTEGER()
        self.XState = XSTATE_CONFIGURATION()


class SYSTEM_POWER_STATE_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Reserved1 = v_uint32()


class SYNCH_COUNTERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SpinLockAcquireCount = v_uint32()
        self.SpinLockContentionCount = v_uint32()
        self.SpinLockSpinCount = v_uint32()
        self.IpiSendRequestBroadcastCount = v_uint32()
        self.IpiSendRequestRoutineCount = v_uint32()
        self.IpiSendSoftwareInterruptCount = v_uint32()
        self.ExInitializeResourceCount = v_uint32()
        self.ExReInitializeResourceCount = v_uint32()
        self.ExDeleteResourceCount = v_uint32()
        self.ExecutiveResourceAcquiresCount = v_uint32()
        self.ExecutiveResourceContentionsCount = v_uint32()
        self.ExecutiveResourceReleaseExclusiveCount = v_uint32()
        self.ExecutiveResourceReleaseSharedCount = v_uint32()
        self.ExecutiveResourceConvertsCount = v_uint32()
        self.ExAcqResExclusiveAttempts = v_uint32()
        self.ExAcqResExclusiveAcquiresExclusive = v_uint32()
        self.ExAcqResExclusiveAcquiresExclusiveRecursive = v_uint32()
        self.ExAcqResExclusiveWaits = v_uint32()
        self.ExAcqResExclusiveNotAcquires = v_uint32()
        self.ExAcqResSharedAttempts = v_uint32()
        self.ExAcqResSharedAcquiresExclusive = v_uint32()
        self.ExAcqResSharedAcquiresShared = v_uint32()
        self.ExAcqResSharedAcquiresSharedRecursive = v_uint32()
        self.ExAcqResSharedWaits = v_uint32()
        self.ExAcqResSharedNotAcquires = v_uint32()
        self.ExAcqResSharedStarveExclusiveAttempts = v_uint32()
        self.ExAcqResSharedStarveExclusiveAcquiresExclusive = v_uint32()
        self.ExAcqResSharedStarveExclusiveAcquiresShared = v_uint32()
        self.ExAcqResSharedStarveExclusiveAcquiresSharedRecursive = v_uint32()
        self.ExAcqResSharedStarveExclusiveWaits = v_uint32()
        self.ExAcqResSharedStarveExclusiveNotAcquires = v_uint32()
        self.ExAcqResSharedWaitForExclusiveAttempts = v_uint32()
        self.ExAcqResSharedWaitForExclusiveAcquiresExclusive = v_uint32()
        self.ExAcqResSharedWaitForExclusiveAcquiresShared = v_uint32()
        self.ExAcqResSharedWaitForExclusiveAcquiresSharedRecursive = v_uint32()
        self.ExAcqResSharedWaitForExclusiveWaits = v_uint32()
        self.ExAcqResSharedWaitForExclusiveNotAcquires = v_uint32()
        self.ExSetResOwnerPointerExclusive = v_uint32()
        self.ExSetResOwnerPointerSharedNew = v_uint32()
        self.ExSetResOwnerPointerSharedOld = v_uint32()
        self.ExTryToAcqExclusiveAttempts = v_uint32()
        self.ExTryToAcqExclusiveAcquires = v_uint32()
        self.ExBoostExclusiveOwner = v_uint32()
        self.ExBoostSharedOwners = v_uint32()
        self.ExEtwSynchTrackingNotificationsCount = v_uint32()
        self.ExEtwSynchTrackingNotificationsAccountedCount = v_uint32()


class KTM(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.cookie = v_uint32()
        self.Mutex = KMUTANT()
        self.State = v_uint32()
        self.NamespaceLink = KTMOBJECT_NAMESPACE_LINK()
        self.TmIdentity = GUID()
        self.Flags = v_uint32()
        self.VolatileFlags = v_uint32()
        self.LogFileName = UNICODE_STRING()
        self.LogFileObject = v_ptr32()
        self.MarshallingContext = v_ptr32()
        self.LogManagementContext = v_ptr32()
        self.Transactions = KTMOBJECT_NAMESPACE()
        self.ResourceManagers = KTMOBJECT_NAMESPACE()
        self.LsnOrderedMutex = KMUTANT()
        self.LsnOrderedList = LIST_ENTRY()
        self.CommitVirtualClock = LARGE_INTEGER()
        self.CommitVirtualClockMutex = FAST_MUTEX()
        self.BaseLsn = CLS_LSN()
        self.CurrentReadLsn = CLS_LSN()
        self.LastRecoveredLsn = CLS_LSN()
        self.TmRmHandle = v_ptr32()
        self.TmRm = v_ptr32()
        self.LogFullNotifyEvent = KEVENT()
        self.CheckpointWorkItem = WORK_QUEUE_ITEM()
        self.CheckpointTargetLsn = CLS_LSN()
        self.LogFullCompletedWorkItem = WORK_QUEUE_ITEM()
        self.LogWriteResource = ERESOURCE()
        self.LogFlags = v_uint32()
        self.LogFullStatus = v_uint32()
        self.RecoveryStatus = v_uint32()
        self._pad0218 = v_bytes(size=4)
        self.LastCheckBaseLsn = CLS_LSN()
        self.RestartOrderedList = LIST_ENTRY()
        self.OfflineWorkItem = WORK_QUEUE_ITEM()


class PRIVATE_CACHE_MAP_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DontUse = v_uint32()


class VF_TARGET_VERIFIED_DRIVER_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SuspectDriverEntry = v_ptr32()
        self.WMICallback = v_ptr32()
        self.EtwHandlesListHead = LIST_ENTRY()
        self.u1 = _unnamed_34363()
        self.Signature = v_uint32()
        self.PoolPageHeaders = SLIST_HEADER()
        self.PoolTrackers = SLIST_HEADER()
        self.CurrentPagedPoolAllocations = v_uint32()
        self.CurrentNonPagedPoolAllocations = v_uint32()
        self.PeakPagedPoolAllocations = v_uint32()
        self.PeakNonPagedPoolAllocations = v_uint32()
        self.PagedBytes = v_uint32()
        self.NonPagedBytes = v_uint32()
        self.PeakPagedBytes = v_uint32()
        self.PeakNonPagedBytes = v_uint32()
        self.RaiseIrqls = v_uint32()
        self.AcquireSpinLocks = v_uint32()
        self.SynchronizeExecutions = v_uint32()
        self.AllocationsWithNoTag = v_uint32()
        self.AllocationsFailed = v_uint32()
        self.AllocationsFailedDeliberately = v_uint32()
        self.LockedBytes = v_uint32()
        self.PeakLockedBytes = v_uint32()
        self.MappedLockedBytes = v_uint32()
        self.PeakMappedLockedBytes = v_uint32()
        self.MappedIoSpaceBytes = v_uint32()
        self.PeakMappedIoSpaceBytes = v_uint32()
        self.PagesForMdlBytes = v_uint32()
        self.PeakPagesForMdlBytes = v_uint32()
        self.ContiguousMemoryBytes = v_uint32()
        self.PeakContiguousMemoryBytes = v_uint32()
        self.ContiguousMemoryListHead = LIST_ENTRY()


class TEB64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NtTib = NT_TIB64()
        self.EnvironmentPointer = v_uint64()
        self.ClientId = CLIENT_ID64()
        self.ActiveRpcHandle = v_uint64()
        self.ThreadLocalStoragePointer = v_uint64()
        self.ProcessEnvironmentBlock = v_uint64()
        self.LastErrorValue = v_uint32()
        self.CountOfOwnedCriticalSections = v_uint32()
        self.CsrClientThread = v_uint64()
        self.Win32ThreadInfo = v_uint64()
        self.User32Reserved = vstruct.VArray([ v_uint32() for i in xrange(26) ])
        self.UserReserved = vstruct.VArray([ v_uint32() for i in xrange(5) ])
        self._pad0100 = v_bytes(size=4)
        self.WOW32Reserved = v_uint64()
        self.CurrentLocale = v_uint32()
        self.FpSoftwareStatusRegister = v_uint32()
        self.SystemReserved1 = vstruct.VArray([ v_uint64() for i in xrange(54) ])
        self.ExceptionCode = v_uint32()
        self._pad02c8 = v_bytes(size=4)
        self.ActivationContextStackPointer = v_uint64()
        self.SpareBytes = vstruct.VArray([ v_uint8() for i in xrange(24) ])
        self.TxFsContext = v_uint32()
        self._pad02f0 = v_bytes(size=4)
        self.GdiTebBatch = GDI_TEB_BATCH64()
        self.RealClientId = CLIENT_ID64()
        self.GdiCachedProcessHandle = v_uint64()
        self.GdiClientPID = v_uint32()
        self.GdiClientTID = v_uint32()
        self.GdiThreadLocalInfo = v_uint64()
        self.Win32ClientInfo = vstruct.VArray([ v_uint64() for i in xrange(62) ])
        self.glDispatchTable = vstruct.VArray([ v_uint64() for i in xrange(233) ])
        self.glReserved1 = vstruct.VArray([ v_uint64() for i in xrange(29) ])
        self.glReserved2 = v_uint64()
        self.glSectionInfo = v_uint64()
        self.glSection = v_uint64()
        self.glTable = v_uint64()
        self.glCurrentRC = v_uint64()
        self.glContext = v_uint64()
        self.LastStatusValue = v_uint32()
        self._pad1258 = v_bytes(size=4)
        self.StaticUnicodeString = STRING64()
        self.StaticUnicodeBuffer = vstruct.VArray([ v_uint16() for i in xrange(261) ])
        self._pad1478 = v_bytes(size=6)
        self.DeallocationStack = v_uint64()
        self.TlsSlots = vstruct.VArray([ v_uint64() for i in xrange(64) ])
        self.TlsLinks = LIST_ENTRY64()
        self.Vdm = v_uint64()
        self.ReservedForNtRpc = v_uint64()
        self.DbgSsReserved = vstruct.VArray([ v_uint64() for i in xrange(2) ])
        self.HardErrorMode = v_uint32()
        self._pad16b8 = v_bytes(size=4)
        self.Instrumentation = vstruct.VArray([ v_uint64() for i in xrange(11) ])
        self.ActivityId = GUID()
        self.SubProcessTag = v_uint64()
        self.PerflibData = v_uint64()
        self.EtwTraceData = v_uint64()
        self.WinSockData = v_uint64()
        self.GdiBatchCount = v_uint32()
        self.CurrentIdealProcessor = PROCESSOR_NUMBER()
        self.GuaranteedStackBytes = v_uint32()
        self._pad1750 = v_bytes(size=4)
        self.ReservedForPerf = v_uint64()
        self.ReservedForOle = v_uint64()
        self.WaitingOnLoaderLock = v_uint32()
        self._pad1768 = v_bytes(size=4)
        self.SavedPriorityState = v_uint64()
        self.ReservedForCodeCoverage = v_uint64()
        self.ThreadPoolData = v_uint64()
        self.TlsExpansionSlots = v_uint64()
        self.DeallocationBStore = v_uint64()
        self.BStoreLimit = v_uint64()
        self.MuiGeneration = v_uint32()
        self.IsImpersonating = v_uint32()
        self.NlsCache = v_uint64()
        self.pShimData = v_uint64()
        self.HeapVirtualAffinity = v_uint16()
        self.LowFragHeapDataSlot = v_uint16()
        self._pad17b8 = v_bytes(size=4)
        self.CurrentTransactionHandle = v_uint64()
        self.ActiveFrame = v_uint64()
        self.FlsData = v_uint64()
        self.PreferredLanguages = v_uint64()
        self.UserPrefLanguages = v_uint64()
        self.MergedPrefLanguages = v_uint64()
        self.MuiImpersonation = v_uint32()
        self.CrossTebFlags = v_uint16()
        self.SameTebFlags = v_uint16()
        self.TxnScopeEnterCallback = v_uint64()
        self.TxnScopeExitCallback = v_uint64()
        self.TxnScopeContext = v_uint64()
        self.LockCount = v_uint32()
        self.SpareUlong0 = v_uint32()
        self.ResourceRetValue = v_uint64()
        self.ReservedForWdf = v_uint64()


class HANDLE_TRACE_DEBUG_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.RefCount = v_uint32()
        self.TableSize = v_uint32()
        self.BitMaskFlags = v_uint32()
        self.CloseCompactionLock = FAST_MUTEX()
        self.CurrentStackIndex = v_uint32()
        self.TraceDb = vstruct.VArray([ HANDLE_TRACE_DB_ENTRY() for i in xrange(1) ])


class HCELL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Size = v_uint32()
        self.u = _unnamed_29247()


class CM_RESOURCE_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Count = v_uint32()
        self.List = vstruct.VArray([ CM_FULL_RESOURCE_DESCRIPTOR() for i in xrange(1) ])


class WNF_STATE_NAME(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Data = vstruct.VArray([ v_uint32() for i in xrange(2) ])


class EPROCESS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Pcb = KPROCESS()
        self.ProcessLock = EX_PUSH_LOCK()
        self._pad00a8 = v_bytes(size=4)
        self.CreateTime = LARGE_INTEGER()
        self.RundownProtect = EX_RUNDOWN_REF()
        self.UniqueProcessId = v_ptr32()
        self.ActiveProcessLinks = LIST_ENTRY()
        self.Flags2 = v_uint32()
        self.Flags = v_uint32()
        self.ProcessQuotaUsage = vstruct.VArray([ v_uint32() for i in xrange(2) ])
        self.ProcessQuotaPeak = vstruct.VArray([ v_uint32() for i in xrange(2) ])
        self.PeakVirtualSize = v_uint32()
        self.VirtualSize = v_uint32()
        self.SessionProcessLinks = LIST_ENTRY()
        self.ExceptionPortData = v_ptr32()
        self.Token = EX_FAST_REF()
        self.WorkingSetPage = v_uint32()
        self.AddressCreationLock = EX_PUSH_LOCK()
        self.RotateInProgress = v_ptr32()
        self.ForkInProgress = v_ptr32()
        self.HardwareTrigger = v_uint32()
        self.CommitChargeJob = v_ptr32()
        self.CloneRoot = v_ptr32()
        self.NumberOfPrivatePages = v_uint32()
        self.NumberOfLockedPages = v_uint32()
        self.Win32Process = v_ptr32()
        self.Job = v_ptr32()
        self.SectionObject = v_ptr32()
        self.SectionBaseAddress = v_ptr32()
        self.Cookie = v_uint32()
        self.VdmObjects = v_ptr32()
        self.WorkingSetWatch = v_ptr32()
        self.Win32WindowStation = v_ptr32()
        self.InheritedFromUniqueProcessId = v_ptr32()
        self.LdtInformation = v_ptr32()
        self.CreatorProcess = v_ptr32()
        self.Peb = v_ptr32()
        self.Session = v_ptr32()
        self.AweInfo = v_ptr32()
        self.QuotaBlock = v_ptr32()
        self.ObjectTable = v_ptr32()
        self.DebugPort = v_ptr32()
        self.PaeTop = v_ptr32()
        self.DeviceMap = v_ptr32()
        self.EtwDataSource = v_ptr32()
        self._pad0168 = v_bytes(size=4)
        self.PageDirectoryPte = v_uint64()
        self.ImageFileName = vstruct.VArray([ v_uint8() for i in xrange(15) ])
        self.PriorityClass = v_uint8()
        self.SecurityPort = v_ptr32()
        self.SeAuditProcessCreationInfo = SE_AUDIT_PROCESS_CREATION_INFO()
        self.JobLinks = LIST_ENTRY()
        self.HighestUserAddress = v_ptr32()
        self.ThreadListHead = LIST_ENTRY()
        self.ActiveThreads = v_uint32()
        self.ImagePathHash = v_uint32()
        self.DefaultHardErrorProcessing = v_uint32()
        self.LastThreadExitStatus = v_uint32()
        self.PrefetchTrace = EX_FAST_REF()
        self.LockedPagesList = v_ptr32()
        self._pad01b8 = v_bytes(size=4)
        self.ReadOperationCount = LARGE_INTEGER()
        self.WriteOperationCount = LARGE_INTEGER()
        self.OtherOperationCount = LARGE_INTEGER()
        self.ReadTransferCount = LARGE_INTEGER()
        self.WriteTransferCount = LARGE_INTEGER()
        self.OtherTransferCount = LARGE_INTEGER()
        self.CommitChargeLimit = v_uint32()
        self.CommitCharge = v_uint32()
        self.CommitChargePeak = v_uint32()
        self.Vm = MMSUPPORT()
        self.MmProcessLinks = LIST_ENTRY()
        self.ModifiedPageCount = v_uint32()
        self.ExitStatus = v_uint32()
        self.VadRoot = MM_AVL_TABLE()
        self.VadPhysicalPages = v_uint32()
        self.VadPhysicalPagesLimit = v_uint32()
        self.AlpcContext = ALPC_PROCESS_CONTEXT()
        self.TimerResolutionLink = LIST_ENTRY()
        self.TimerResolutionStackRecord = v_ptr32()
        self.RequestedTimerResolution = v_uint32()
        self.SmallestTimerResolution = v_uint32()
        self.ExitTime = LARGE_INTEGER()
        self.ActiveThreadsHighWatermark = v_uint32()
        self.LargePrivateVadCount = v_uint32()
        self.ThreadListLock = EX_PUSH_LOCK()
        self.WnfContext = v_ptr32()
        self.SectionMappingSize = v_uint32()
        self.SignatureLevel = v_uint8()
        self.SectionSignatureLevel = v_uint8()
        self.SpareByte20 = vstruct.VArray([ v_uint8() for i in xrange(2) ])
        self.KeepAliveCounter = v_uint32()
        self.DiskCounters = v_ptr32()
        self.LastFreezeInterruptTime = v_uint64()


class ALPC_PORT_ATTRIBUTES(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flags = v_uint32()
        self.SecurityQos = SECURITY_QUALITY_OF_SERVICE()
        self.MaxMessageLength = v_uint32()
        self.MemoryBandwidth = v_uint32()
        self.MaxPoolUsage = v_uint32()
        self.MaxSectionSize = v_uint32()
        self.MaxViewSize = v_uint32()
        self.MaxTotalSectionSize = v_uint32()
        self.DupObjectTypes = v_uint32()


class KSCHEDULING_GROUP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Value = v_uint16()
        self.Type = v_uint8()
        self.HardCap = v_uint8()
        self.RelativeWeight = v_uint32()
        self.QueryHistoryTimeStamp = v_uint64()
        self.NotificationCycles = v_uint64()
        self.SchedulingGroupList = LIST_ENTRY()
        self.NotificationDpc = v_ptr32()
        self._pad0040 = v_bytes(size=28)
        self.PerProcessor = vstruct.VArray([ KSCB() for i in xrange(1) ])
        self._pad0140 = v_bytes(size=48)


class _unnamed_28009(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Vpb = v_ptr32()
        self.DeviceObject = v_ptr32()


class POWER_SEQUENCE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SequenceD1 = v_uint32()
        self.SequenceD2 = v_uint32()
        self.SequenceD3 = v_uint32()


class EVENT_RECORD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.EventHeader = EVENT_HEADER()
        self.BufferContext = ETW_BUFFER_CONTEXT()
        self.ExtendedDataCount = v_uint16()
        self.UserDataLength = v_uint16()
        self.ExtendedData = v_ptr32()
        self.UserData = v_ptr32()
        self.UserContext = v_ptr32()
        self._pad0068 = v_bytes(size=4)


class IO_DRIVER_CREATE_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Size = v_uint16()
        self._pad0004 = v_bytes(size=2)
        self.ExtraCreateParameter = v_ptr32()
        self.DeviceObjectHint = v_ptr32()
        self.TxnParameters = v_ptr32()


class _unnamed_29247(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NewCell = _unnamed_34026()


class KTIMER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Header = DISPATCHER_HEADER()
        self.DueTime = ULARGE_INTEGER()
        self.TimerListEntry = LIST_ENTRY()
        self.Dpc = v_ptr32()
        self.Period = v_uint32()


class _unnamed_34689(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DataSize = v_uint32()
        self.Reserved1 = v_uint32()
        self.Reserved2 = v_uint32()


class HIVE_LIST_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.FileName = v_ptr32()
        self.BaseName = v_ptr32()
        self.RegRootName = v_ptr32()
        self.CmHive = v_ptr32()
        self.HHiveFlags = v_uint32()
        self.CmHiveFlags = v_uint32()
        self.CmKcbCacheSize = v_uint32()
        self.CmHive2 = v_ptr32()
        self.HiveMounted = v_uint8()
        self.ThreadFinished = v_uint8()
        self.ThreadStarted = v_uint8()
        self.Allocate = v_uint8()
        self.WinPERequired = v_uint8()
        self._pad0028 = v_bytes(size=3)
        self.StartEvent = KEVENT()
        self.FinishedEvent = KEVENT()
        self.MountLock = KEVENT()


class WHEA_ERROR_STATUS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ErrorStatus = v_uint64()


class CM_PARTIAL_RESOURCE_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint8()
        self.ShareDisposition = v_uint8()
        self.Flags = v_uint16()
        self.u = _unnamed_33994()


class RTLP_RANGE_LIST_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Start = v_uint64()
        self.End = v_uint64()
        self.Allocated = _unnamed_35924()
        self.Attributes = v_uint8()
        self.PublicFlags = v_uint8()
        self.PrivateFlags = v_uint16()
        self.ListEntry = LIST_ENTRY()
        self._pad0028 = v_bytes(size=4)


class EVENT_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Id = v_uint16()
        self.Version = v_uint8()
        self.Channel = v_uint8()
        self.Level = v_uint8()
        self.Opcode = v_uint8()
        self.Task = v_uint16()
        self.Keyword = v_uint64()


class WHEAP_ERROR_SOURCE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self.FailedAllocations = v_uint32()
        self.PlatformErrorSourceId = v_uint32()
        self.ErrorCount = v_uint32()
        self.RecordCount = v_uint32()
        self.RecordLength = v_uint32()
        self.PoolTag = v_uint32()
        self.Type = v_uint32()
        self.Records = v_ptr32()
        self.Context = v_ptr32()
        self.SectionCount = v_uint32()
        self.SectionLength = v_uint32()
        self._pad0038 = v_bytes(size=4)
        self.TickCountAtLastError = LARGE_INTEGER()
        self.AccumulatedErrors = v_uint32()
        self.TotalErrors = v_uint32()
        self.Deferred = v_uint8()
        self.Descriptor = WHEA_ERROR_SOURCE_DESCRIPTOR()
        self._pad0418 = v_bytes(size=3)


class OBJECT_ATTRIBUTES(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.RootDirectory = v_ptr32()
        self.ObjectName = v_ptr32()
        self.Attributes = v_uint32()
        self.SecurityDescriptor = v_ptr32()
        self.SecurityQualityOfService = v_ptr32()


class OBJECT_HEADER_AUDIT_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SecurityDescriptor = v_ptr32()
        self.Reserved = v_uint32()


class EVENT_HEADER_EXTENDED_DATA_ITEM(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Reserved1 = v_uint16()
        self.ExtType = v_uint16()
        self.Linkage = v_uint16()
        self.DataSize = v_uint16()
        self.DataPtr = v_uint64()


class _unnamed_29028(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NumberOfSystemCacheViews = v_uint32()
        self.WritableUserReferences = v_uint32()
        self.SubsectionRoot = v_ptr32()


class CM_FULL_RESOURCE_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.InterfaceType = v_uint32()
        self.BusNumber = v_uint32()
        self.PartialResourceList = CM_PARTIAL_RESOURCE_LIST()


class _unnamed_27833(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SecurityContext = v_ptr32()
        self.Options = v_uint32()
        self.FileAttributes = v_uint16()
        self.ShareAccess = v_uint16()
        self.EaLength = v_uint32()


class DBGKD_CONTEXT_EX(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Offset = v_uint32()
        self.ByteCount = v_uint32()
        self.BytesCopied = v_uint32()


class DBGKD_GET_VERSION64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MajorVersion = v_uint16()
        self.MinorVersion = v_uint16()
        self.ProtocolVersion = v_uint8()
        self.KdSecondaryVersion = v_uint8()
        self.Flags = v_uint16()
        self.MachineType = v_uint16()
        self.MaxPacketType = v_uint8()
        self.MaxStateChange = v_uint8()
        self.MaxManipulate = v_uint8()
        self.Simulation = v_uint8()
        self.Unused = vstruct.VArray([ v_uint16() for i in xrange(1) ])
        self.KernBase = v_uint64()
        self.PsLoadedModuleList = v_uint64()
        self.DebuggerDataList = v_uint64()


class POP_RW_LOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Lock = EX_PUSH_LOCK()
        self.Thread = v_ptr32()


class KTIMER_TABLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TimerExpiry = vstruct.VArray([ v_ptr32() for i in xrange(16) ])
        self.TimerEntries = vstruct.VArray([ KTIMER_TABLE_ENTRY() for i in xrange(256) ])


class PROC_IDLE_POLICY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PromotePercent = v_uint8()
        self.DemotePercent = v_uint8()
        self.PromotePercentBase = v_uint8()
        self.DemotePercentBase = v_uint8()
        self.AllowScaling = v_uint8()


class _unnamed_30828(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.s1 = _unnamed_30885()


class FAST_IO_DISPATCH(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SizeOfFastIoDispatch = v_uint32()
        self.FastIoCheckIfPossible = v_ptr32()
        self.FastIoRead = v_ptr32()
        self.FastIoWrite = v_ptr32()
        self.FastIoQueryBasicInfo = v_ptr32()
        self.FastIoQueryStandardInfo = v_ptr32()
        self.FastIoLock = v_ptr32()
        self.FastIoUnlockSingle = v_ptr32()
        self.FastIoUnlockAll = v_ptr32()
        self.FastIoUnlockAllByKey = v_ptr32()
        self.FastIoDeviceControl = v_ptr32()
        self.AcquireFileForNtCreateSection = v_ptr32()
        self.ReleaseFileForNtCreateSection = v_ptr32()
        self.FastIoDetachDevice = v_ptr32()
        self.FastIoQueryNetworkOpenInfo = v_ptr32()
        self.AcquireForModWrite = v_ptr32()
        self.MdlRead = v_ptr32()
        self.MdlReadComplete = v_ptr32()
        self.PrepareMdlWrite = v_ptr32()
        self.MdlWriteComplete = v_ptr32()
        self.FastIoReadCompressed = v_ptr32()
        self.FastIoWriteCompressed = v_ptr32()
        self.MdlReadCompleteCompressed = v_ptr32()
        self.MdlWriteCompleteCompressed = v_ptr32()
        self.FastIoQueryOpen = v_ptr32()
        self.ReleaseForModWrite = v_ptr32()
        self.AcquireForCcFlush = v_ptr32()
        self.ReleaseForCcFlush = v_ptr32()


class _unnamed_28142(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PowerState = v_uint32()


class SLIST_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Alignment = v_uint64()


class CM_KEY_CONTROL_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.RefCount = v_uint32()
        self.ExtFlags = v_uint32()
        self.DelayedDeref = v_uint32()
        self.KeyHash = CM_KEY_HASH()
        self.KcbPushlock = EX_PUSH_LOCK()
        self.Owner = v_ptr32()
        self.SlotHint = v_uint32()
        self.ParentKcb = v_ptr32()
        self.NameBlock = v_ptr32()
        self.CachedSecurity = v_ptr32()
        self.ValueCache = CACHED_CHILD_LIST()
        self.IndexHint = v_ptr32()
        self.KeyBodyListHead = LIST_ENTRY()
        self.KeyBodyArray = vstruct.VArray([ v_ptr32() for i in xrange(4) ])
        self.KcbLastWriteTime = LARGE_INTEGER()
        self.KcbMaxNameLen = v_uint16()
        self.KcbMaxValueNameLen = v_uint16()
        self.KcbMaxValueDataLen = v_uint32()
        self.KcbUserFlags = v_uint32()
        self.KCBUoWListHead = LIST_ENTRY()
        self.DelayQueueEntry = LIST_ENTRY()
        self.TransKCBOwner = v_ptr32()
        self.KCBLock = CM_INTENT_LOCK()
        self.KeyLock = CM_INTENT_LOCK()
        self.TransValueCache = CHILD_LIST()
        self.TransValueListOwner = v_ptr32()
        self.FullKCBName = v_ptr32()


class MMPFNLIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Total = v_uint32()
        self.ListName = v_uint32()
        self.Flink = v_uint32()
        self.Blink = v_uint32()
        self.Lock = v_uint32()


class NB10(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint32()
        self.Offset = v_uint32()
        self.TimeStamp = v_uint32()
        self.Age = v_uint32()
        self.PdbName = vstruct.VArray([ v_uint8() for i in xrange(1) ])
        self._pad0014 = v_bytes(size=3)


class RTL_DYNAMIC_HASH_TABLE_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ChainHead = v_ptr32()
        self.PrevLinkage = v_ptr32()
        self.Signature = v_uint32()


class MMWSL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.FirstFree = v_uint32()
        self.FirstDynamic = v_uint32()
        self.LastEntry = v_uint32()
        self.NextSlot = v_uint32()
        self.LastInitializedWsle = v_uint32()
        self.NextAgingSlot = v_uint32()
        self.NextAccessClearingSlot = v_uint32()
        self.LastAccessClearingRemainder = v_uint32()
        self.LastAgingRemainder = v_uint32()
        self.WsleSize = v_uint32()
        self.NonDirectCount = v_uint32()
        self.LowestPagableAddress = v_ptr32()
        self.NonDirectHash = v_ptr32()
        self.HashTableStart = v_ptr32()
        self.HighestPermittedHashAddress = v_ptr32()
        self.ActiveWsleCounts = vstruct.VArray([ v_uint32() for i in xrange(8) ])
        self.ActiveWsles = vstruct.VArray([ MI_ACTIVE_WSLE() for i in xrange(8) ])
        self.Wsle = v_ptr32()
        self.UserVaInfo = MI_USER_VA_INFO()


class KTMOBJECT_NAMESPACE_LINK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Links = RTL_BALANCED_LINKS()
        self.Expired = v_uint8()
        self._pad0014 = v_bytes(size=3)


class MI_IMAGE_SECURITY_REFERENCE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SecurityContext = IMAGE_SECURITY_CONTEXT()
        self.DynamicRelocations = v_ptr32()


class WHEA_MEMORY_ERROR_SECTION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ValidBits = WHEA_MEMORY_ERROR_SECTION_VALIDBITS()
        self.ErrorStatus = WHEA_ERROR_STATUS()
        self.PhysicalAddress = v_uint64()
        self.PhysicalAddressMask = v_uint64()
        self.Node = v_uint16()
        self.Card = v_uint16()
        self.Module = v_uint16()
        self.Bank = v_uint16()
        self.Device = v_uint16()
        self.Row = v_uint16()
        self.Column = v_uint16()
        self.BitPosition = v_uint16()
        self.RequesterId = v_uint64()
        self.ResponderId = v_uint64()
        self.TargetId = v_uint64()
        self.ErrorType = v_uint8()


class DBGKD_CONTINUE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ContinueStatus = v_uint32()


class PROC_IDLE_STATE_ACCOUNTING(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TotalTime = v_uint64()
        self.CancelCount = v_uint32()
        self.FailureCount = v_uint32()
        self.SuccessCount = v_uint32()
        self.InvalidBucketIndex = v_uint32()
        self.MinTime = v_uint64()
        self.MaxTime = v_uint64()
        self.IdleTimeBuckets = vstruct.VArray([ PROC_IDLE_STATE_BUCKET() for i in xrange(26) ])


class CALL_HASH_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self.CallersAddress = v_ptr32()
        self.CallersCaller = v_ptr32()
        self.CallCount = v_uint32()


class MMSESSION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SystemSpaceViewLock = FAST_MUTEX()
        self.SystemSpaceViewLockPointer = v_ptr32()
        self.SystemSpaceViewTable = v_ptr32()
        self.SystemSpaceHashSize = v_uint32()
        self.SystemSpaceHashEntries = v_uint32()
        self.SystemSpaceHashKey = v_uint32()
        self.BitmapFailures = v_uint32()


class WORK_QUEUE_ITEM(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.List = LIST_ENTRY()
        self.WorkerRoutine = v_ptr32()
        self.Parameter = v_ptr32()


class _unnamed_36838(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DeviceNumber = v_uint32()


class _unnamed_32530(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BaseMid = v_uint8()
        self.Flags1 = v_uint8()
        self.Flags2 = v_uint8()
        self.BaseHi = v_uint8()


class KSPECIAL_REGISTERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Cr0 = v_uint32()
        self.Cr2 = v_uint32()
        self.Cr3 = v_uint32()
        self.Cr4 = v_uint32()
        self.KernelDr0 = v_uint32()
        self.KernelDr1 = v_uint32()
        self.KernelDr2 = v_uint32()
        self.KernelDr3 = v_uint32()
        self.KernelDr6 = v_uint32()
        self.KernelDr7 = v_uint32()
        self.Gdtr = DESCRIPTOR()
        self.Idtr = DESCRIPTOR()
        self.Tr = v_uint16()
        self.Ldtr = v_uint16()
        self.Xcr0 = v_uint64()
        self.Reserved = vstruct.VArray([ v_uint32() for i in xrange(4) ])


class POWER_ACTION_POLICY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Action = v_uint32()
        self.Flags = v_uint32()
        self.EventCode = v_uint32()


class IMAGE_SECTION_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Name = vstruct.VArray([ v_uint8() for i in xrange(8) ])
        self.Misc = _unnamed_34731()
        self.VirtualAddress = v_uint32()
        self.SizeOfRawData = v_uint32()
        self.PointerToRawData = v_uint32()
        self.PointerToRelocations = v_uint32()
        self.PointerToLinenumbers = v_uint32()
        self.NumberOfRelocations = v_uint16()
        self.NumberOfLinenumbers = v_uint16()
        self.Characteristics = v_uint32()


class _unnamed_32122(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.FilePointerIndex = v_uint32()


class _unnamed_32123(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.FilePointerIndex = v_uint32()


class DBGKM_EXCEPTION64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ExceptionRecord = EXCEPTION_RECORD64()
        self.FirstChance = v_uint32()
        self._pad00a0 = v_bytes(size=4)


class _unnamed_29796(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NextResourceDeviceNode = v_ptr32()


class _unnamed_29795(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LegacyDeviceNode = v_ptr32()


class XSAVE_FORMAT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ControlWord = v_uint16()
        self.StatusWord = v_uint16()
        self.TagWord = v_uint8()
        self.Reserved1 = v_uint8()
        self.ErrorOpcode = v_uint16()
        self.ErrorOffset = v_uint32()
        self.ErrorSelector = v_uint16()
        self.Reserved2 = v_uint16()
        self.DataOffset = v_uint32()
        self.DataSelector = v_uint16()
        self.Reserved3 = v_uint16()
        self.MxCsr = v_uint32()
        self.MxCsr_Mask = v_uint32()
        self.FloatRegisters = vstruct.VArray([ M128A() for i in xrange(8) ])
        self.XmmRegisters = vstruct.VArray([ M128A() for i in xrange(8) ])
        self.Reserved4 = vstruct.VArray([ v_uint8() for i in xrange(220) ])
        self.Cr0NpxState = v_uint32()


class KSYSTEM_TIME(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LowPart = v_uint32()
        self.High1Time = v_uint32()
        self.High2Time = v_uint32()


class SEGMENT_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TotalNumberOfPtes4132 = v_uint16()
        self.FloppyMedia = v_uint8()
        self.ILOnly = v_uint8()


class PO_DEVICE_NOTIFY_ORDER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Locked = v_uint8()
        self._pad0004 = v_bytes(size=3)
        self.WarmEjectPdoPointer = v_ptr32()
        self.OrderLevel = vstruct.VArray([ PO_NOTIFY_ORDER_LEVEL() for i in xrange(5) ])


class PROCESSOR_IDLE_CONSTRAINTS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TotalTime = v_uint64()
        self.IdleTime = v_uint64()
        self.ExpectedIdleDuration = v_uint64()
        self.MaxIdleDuration = v_uint32()
        self.OverrideState = v_uint32()
        self.TimeCheck = v_uint32()
        self.PromotePercent = v_uint8()
        self.DemotePercent = v_uint8()
        self.Parked = v_uint8()
        self.Interruptible = v_uint8()
        self.PlatformIdle = v_uint8()
        self._pad0030 = v_bytes(size=7)


class FLOATING_SAVE_AREA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ControlWord = v_uint32()
        self.StatusWord = v_uint32()
        self.TagWord = v_uint32()
        self.ErrorOffset = v_uint32()
        self.ErrorSelector = v_uint32()
        self.DataOffset = v_uint32()
        self.DataSelector = v_uint32()
        self.RegisterArea = vstruct.VArray([ v_uint8() for i in xrange(80) ])
        self.Cr0NpxState = v_uint32()


class POP_FX_PROVIDER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Index = v_uint32()
        self.Activating = v_uint8()
        self._pad0008 = v_bytes(size=3)


class KQUEUE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Header = DISPATCHER_HEADER()
        self.EntryListHead = LIST_ENTRY()
        self.CurrentCount = v_uint32()
        self.MaximumCount = v_uint32()
        self.ThreadListHead = LIST_ENTRY()


class DEVICE_DESCRIPTION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Version = v_uint32()
        self.Master = v_uint8()
        self.ScatterGather = v_uint8()
        self.DemandMode = v_uint8()
        self.AutoInitialize = v_uint8()
        self.Dma32BitAddresses = v_uint8()
        self.IgnoreCount = v_uint8()
        self.Reserved1 = v_uint8()
        self.Dma64BitAddresses = v_uint8()
        self.BusNumber = v_uint32()
        self.DmaChannel = v_uint32()
        self.InterfaceType = v_uint32()
        self.DmaWidth = v_uint32()
        self.DmaSpeed = v_uint32()
        self.MaximumLength = v_uint32()
        self.DmaPort = v_uint32()
        self.DmaAddressWidth = v_uint32()
        self.DmaControllerInstance = v_uint32()
        self.DmaRequestLine = v_uint32()
        self._pad0038 = v_bytes(size=4)
        self.DeviceAddress = LARGE_INTEGER()


class _unnamed_29151(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Space = v_uint32()
        self.MapPoint = v_uint32()
        self.BinPoint = v_ptr32()


class _unnamed_29150(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.List = v_ptr32()
        self.Index = v_uint32()
        self.Cell = v_uint32()
        self.CellPoint = v_ptr32()


class _unnamed_29153(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.FileOffset = v_uint32()


class _unnamed_29152(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Bin = v_ptr32()
        self.CellPoint = v_ptr32()


class SEGMENT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ControlArea = v_ptr32()
        self.TotalNumberOfPtes = v_uint32()
        self.SegmentFlags = SEGMENT_FLAGS()
        self.NumberOfCommittedPages = v_uint32()
        self.SizeOfSegment = v_uint64()
        self.ExtendInfo = v_ptr32()
        self.SegmentLock = EX_PUSH_LOCK()
        self.u1 = _unnamed_28990()
        self.u2 = _unnamed_28991()
        self.PrototypePte = v_ptr32()
        self._pad0030 = v_bytes(size=4)


class _unnamed_37222(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint32()
        self.CheckSum = v_uint32()


class LUID_AND_ATTRIBUTES(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Luid = LUID()
        self.Attributes = v_uint32()


class _unnamed_37225(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DiskId = GUID()


class iobuf(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ptr = v_ptr32()
        self.cnt = v_uint32()
        self.base = v_ptr32()
        self.flag = v_uint32()
        self.file = v_uint32()
        self.charbuf = v_uint32()
        self.bufsiz = v_uint32()
        self.tmpfname = v_ptr32()


class PCW_CALLBACK_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AddCounter = PCW_COUNTER_INFORMATION()
        self._pad0020 = v_bytes(size=16)


class PCW_COUNTER_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Id = v_uint16()
        self.StructIndex = v_uint16()
        self.Offset = v_uint16()
        self.Size = v_uint16()


class MMMOD_WRITER_MDL_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Links = LIST_ENTRY()
        self.u = _unnamed_29100()
        self.Irp = v_ptr32()
        self.u1 = MODWRITER_FLAGS()
        self.ByteCount = v_uint32()
        self.PagingFile = v_ptr32()
        self.File = v_ptr32()
        self.ControlArea = v_ptr32()
        self.FileResource = v_ptr32()
        self._pad0030 = v_bytes(size=4)
        self.WriteOffset = LARGE_INTEGER()
        self.IssueTime = LARGE_INTEGER()
        self.PointerMdl = v_ptr32()
        self.Mdl = MDL()
        self.Page = vstruct.VArray([ v_uint32() for i in xrange(1) ])
        self._pad0068 = v_bytes(size=4)


class CACHED_CHILD_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Count = v_uint32()
        self.ValueList = v_uint32()


class PCW_MASK_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CounterMask = v_uint64()
        self.InstanceMask = v_ptr32()
        self.InstanceId = v_uint32()
        self.CollectMultiple = v_uint8()
        self._pad0014 = v_bytes(size=3)
        self.Buffer = v_ptr32()
        self.CancelEvent = v_ptr32()
        self._pad0020 = v_bytes(size=4)


class KTHREAD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Header = DISPATCHER_HEADER()
        self.SListFaultAddress = v_ptr32()
        self._pad0018 = v_bytes(size=4)
        self.QuantumTarget = v_uint64()
        self.InitialStack = v_ptr32()
        self.StackLimit = v_ptr32()
        self.StackBase = v_ptr32()
        self.ThreadLock = v_uint32()
        self.CycleTime = v_uint64()
        self.HighCycleTime = v_uint32()
        self.ServiceTable = v_ptr32()
        self.CurrentRunTime = v_uint32()
        self.ExpectedRunTime = v_uint32()
        self.KernelStack = v_ptr32()
        self.StateSaveArea = v_ptr32()
        self.SchedulingGroup = v_ptr32()
        self.WaitRegister = KWAIT_STATUS_REGISTER()
        self.Running = v_uint8()
        self.Alerted = vstruct.VArray([ v_uint8() for i in xrange(2) ])
        self.KernelStackResident = v_uint32()
        self.AutoAlignment = v_uint32()
        self.Spare0 = v_uint32()
        self.SystemCallNumber = v_uint32()
        self.FirstArgument = v_ptr32()
        self.TrapFrame = v_ptr32()
        self.ApcState = KAPC_STATE()
        self.UserIdealProcessor = v_uint32()
        self.ContextSwitches = v_uint32()
        self.State = v_uint8()
        self.NpxState = v_uint8()
        self.WaitIrql = v_uint8()
        self.WaitMode = v_uint8()
        self.WaitStatus = v_uint32()
        self.WaitBlockList = v_ptr32()
        self.WaitListEntry = LIST_ENTRY()
        self.Queue = v_ptr32()
        self.Teb = v_ptr32()
        self._pad00b0 = v_bytes(size=4)
        self.RelativeTimerBias = v_uint64()
        self.Timer = KTIMER()
        self.WaitBlock = vstruct.VArray([ KWAIT_BLOCK() for i in xrange(4) ])
        self.QueueListEntry = LIST_ENTRY()
        self.NextProcessor = v_uint32()
        self.DeferredProcessor = v_uint32()
        self.Process = v_ptr32()
        self.UserAffinity = GROUP_AFFINITY()
        self.Affinity = GROUP_AFFINITY()
        self.ApcStatePointer = vstruct.VArray([ v_ptr32() for i in xrange(2) ])
        self.SavedApcState = KAPC_STATE()
        self.SuspendCount = v_uint8()
        self.Saturation = v_uint8()
        self.SListFaultCount = v_uint16()
        self.SchedulerApc = KAPC()
        self.UserTime = v_uint32()
        self.SuspendEvent = KEVENT()
        self.ThreadListEntry = LIST_ENTRY()
        self.MutantListHead = LIST_ENTRY()
        self._pad01e8 = v_bytes(size=4)


class _unnamed_34124(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length40 = v_uint32()
        self.Alignment40 = v_uint32()
        self.MinimumAddress = LARGE_INTEGER()
        self.MaximumAddress = LARGE_INTEGER()


class _unnamed_34120(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Priority = v_uint32()
        self.Reserved1 = v_uint32()
        self.Reserved2 = v_uint32()


class ALPC_PORT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PortListEntry = LIST_ENTRY()
        self.CommunicationInfo = v_ptr32()
        self.OwnerProcess = v_ptr32()
        self.CompletionPort = v_ptr32()
        self.CompletionKey = v_ptr32()
        self.CompletionPacketLookaside = v_ptr32()
        self.PortContext = v_ptr32()
        self.StaticSecurity = SECURITY_CLIENT_CONTEXT()
        self.IncomingQueueLock = EX_PUSH_LOCK()
        self.MainQueue = LIST_ENTRY()
        self.LargeMessageQueue = LIST_ENTRY()
        self.PendingQueueLock = EX_PUSH_LOCK()
        self.PendingQueue = LIST_ENTRY()
        self.WaitQueueLock = EX_PUSH_LOCK()
        self.WaitQueue = LIST_ENTRY()
        self.Semaphore = v_ptr32()
        self.PortAttributes = ALPC_PORT_ATTRIBUTES()
        self.ResourceListLock = EX_PUSH_LOCK()
        self.ResourceListHead = LIST_ENTRY()
        self.PortObjectLock = EX_PUSH_LOCK()
        self.CompletionList = v_ptr32()
        self.MessageZone = v_ptr32()
        self.CallbackObject = v_ptr32()
        self.CallbackContext = v_ptr32()
        self.CanceledQueue = LIST_ENTRY()
        self.SequenceNo = v_uint32()
        self.u1 = _unnamed_30882()
        self.TargetQueuePort = v_ptr32()
        self.TargetSequencePort = v_ptr32()
        self.CachedMessage = v_ptr32()
        self.MainQueueLength = v_uint32()
        self.LargeMessageQueueLength = v_uint32()
        self.PendingQueueLength = v_uint32()
        self.CanceledQueueLength = v_uint32()
        self.WaitQueueLength = v_uint32()


class WHEAP_ERROR_RECORD_WRAPPER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.WorkEntry = LIST_ENTRY()
        self.Length = v_uint32()
        self.ProcessorNumber = v_uint32()
        self.Flags = WHEAP_ERROR_RECORD_WRAPPER_FLAGS()
        self.InUse = v_uint32()
        self.ErrorSource = v_ptr32()
        self.ErrorRecord = WHEA_ERROR_RECORD()


class ADAPTER_OBJECT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class _unnamed_34658(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Start = LARGE_INTEGER()
        self.Length = v_uint32()


class _unnamed_34129(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length48 = v_uint32()
        self.Alignment48 = v_uint32()
        self.MinimumAddress = LARGE_INTEGER()
        self.MaximumAddress = LARGE_INTEGER()


class _unnamed_28175(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SystemContext = v_uint32()
        self.Type = v_uint32()
        self.State = POWER_STATE()
        self.ShutdownType = v_uint32()


class CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ContextFlags = v_uint32()
        self.Dr0 = v_uint32()
        self.Dr1 = v_uint32()
        self.Dr2 = v_uint32()
        self.Dr3 = v_uint32()
        self.Dr6 = v_uint32()
        self.Dr7 = v_uint32()
        self.FloatSave = FLOATING_SAVE_AREA()
        self.SegGs = v_uint32()
        self.SegFs = v_uint32()
        self.SegEs = v_uint32()
        self.SegDs = v_uint32()
        self.Edi = v_uint32()
        self.Esi = v_uint32()
        self.Ebx = v_uint32()
        self.Edx = v_uint32()
        self.Ecx = v_uint32()
        self.Eax = v_uint32()
        self.Ebp = v_uint32()
        self.Eip = v_uint32()
        self.SegCs = v_uint32()
        self.EFlags = v_uint32()
        self.Esp = v_uint32()
        self.SegSs = v_uint32()
        self.ExtendedRegisters = vstruct.VArray([ v_uint8() for i in xrange(512) ])


class _unnamed_34088(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.Alignment = v_uint32()
        self.MinimumAddress = LARGE_INTEGER()
        self.MaximumAddress = LARGE_INTEGER()


class VF_TARGET_DRIVER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TreeNode = VF_AVL_TREE_NODE()
        self.u1 = _unnamed_34312()
        self.VerifiedData = v_ptr32()


class DBGKD_GET_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Unused = v_uint32()


class VACB_LEVEL_ALLOCATION_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.VacbLevelList = LIST_ENTRY()
        self.VacbLevelWithBcbListHeads = v_ptr32()
        self.VacbLevelsAllocated = v_uint32()


class KTRANSACTION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.OutcomeEvent = KEVENT()
        self.cookie = v_uint32()
        self.Mutex = KMUTANT()
        self.TreeTx = v_ptr32()
        self.GlobalNamespaceLink = KTMOBJECT_NAMESPACE_LINK()
        self.TmNamespaceLink = KTMOBJECT_NAMESPACE_LINK()
        self.UOW = GUID()
        self.State = v_uint32()
        self.Flags = v_uint32()
        self.EnlistmentHead = LIST_ENTRY()
        self.EnlistmentCount = v_uint32()
        self.RecoverableEnlistmentCount = v_uint32()
        self.PrePrepareRequiredEnlistmentCount = v_uint32()
        self.PrepareRequiredEnlistmentCount = v_uint32()
        self.OutcomeRequiredEnlistmentCount = v_uint32()
        self.PendingResponses = v_uint32()
        self.SuperiorEnlistment = v_ptr32()
        self._pad00a0 = v_bytes(size=4)
        self.LastLsn = CLS_LSN()
        self.PromotedEntry = LIST_ENTRY()
        self.PromoterTransaction = v_ptr32()
        self.PromotePropagation = v_ptr32()
        self.IsolationLevel = v_uint32()
        self.IsolationFlags = v_uint32()
        self.Timeout = LARGE_INTEGER()
        self.Description = UNICODE_STRING()
        self.RollbackThread = v_ptr32()
        self.RollbackWorkItem = WORK_QUEUE_ITEM()
        self.RollbackDpc = KDPC()
        self._pad0108 = v_bytes(size=4)
        self.RollbackTimer = KTIMER()
        self.LsnOrderedEntry = LIST_ENTRY()
        self.Outcome = v_uint32()
        self.Tm = v_ptr32()
        self.CommitReservation = v_uint64()
        self.TransactionHistory = vstruct.VArray([ KTRANSACTION_HISTORY() for i in xrange(10) ])
        self.TransactionHistoryCount = v_uint32()
        self.DTCPrivateInformation = v_ptr32()
        self.DTCPrivateInformationLength = v_uint32()
        self.DTCPrivateInformationMutex = KMUTANT()
        self.PromotedTxSelfHandle = v_ptr32()
        self.PendingPromotionCount = v_uint32()
        self.PromotionCompletedEvent = KEVENT()
        self._pad01e0 = v_bytes(size=4)


class GENERIC_MAPPING(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.GenericRead = v_uint32()
        self.GenericWrite = v_uint32()
        self.GenericExecute = v_uint32()
        self.GenericAll = v_uint32()


class _unnamed_31111(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.QueueType = v_uint32()


class DEVICE_NODE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Sibling = v_ptr32()
        self.Child = v_ptr32()
        self.Parent = v_ptr32()
        self.LastChild = v_ptr32()
        self.PhysicalDeviceObject = v_ptr32()
        self.InstancePath = UNICODE_STRING()
        self.ServiceName = UNICODE_STRING()
        self.PendingIrp = v_ptr32()
        self.Level = v_uint32()
        self.CurrentPowerState = POWER_STATE()
        self.Notify = PO_DEVICE_NOTIFY()
        self.PoIrpManager = PO_IRP_MANAGER()
        self.FxDevice = v_ptr32()
        self.FxDeviceLock = v_uint32()
        self.FxRemoveEvent = KEVENT()
        self.FxActivationCount = v_uint32()
        self.FxSleepCount = v_uint32()
        self.Plugin = v_ptr32()
        self.UniqueId = UNICODE_STRING()
        self.PowerFlags = v_uint32()
        self.State = v_uint32()
        self.PreviousState = v_uint32()
        self.StateHistory = vstruct.VArray([ PNP_DEVNODE_STATE() for i in xrange(20) ])
        self.StateHistoryEntry = v_uint32()
        self.CompletionStatus = v_uint32()
        self.Flags = v_uint32()
        self.UserFlags = v_uint32()
        self.Problem = v_uint32()
        self.ProblemStatus = v_uint32()
        self.ResourceList = v_ptr32()
        self.ResourceListTranslated = v_ptr32()
        self.DuplicatePDO = v_ptr32()
        self.ResourceRequirements = v_ptr32()
        self.InterfaceType = v_uint32()
        self.BusNumber = v_uint32()
        self.ChildInterfaceType = v_uint32()
        self.ChildBusNumber = v_uint32()
        self.ChildBusTypeIndex = v_uint16()
        self.RemovalPolicy = v_uint8()
        self.HardwareRemovalPolicy = v_uint8()
        self.TargetDeviceNotify = LIST_ENTRY()
        self.DeviceArbiterList = LIST_ENTRY()
        self.DeviceTranslatorList = LIST_ENTRY()
        self.NoTranslatorMask = v_uint16()
        self.QueryTranslatorMask = v_uint16()
        self.NoArbiterMask = v_uint16()
        self.QueryArbiterMask = v_uint16()
        self.OverUsed1 = _unnamed_29795()
        self.OverUsed2 = _unnamed_29796()
        self.BootResources = v_ptr32()
        self.BootResourcesTranslated = v_ptr32()
        self.CapabilityFlags = v_uint32()
        self.DockInfo = _unnamed_29797()
        self.DisableableDepends = v_uint32()
        self.PendedSetInterfaceState = LIST_ENTRY()
        self.LegacyBusListEntry = LIST_ENTRY()
        self.DriverUnloadRetryCount = v_uint32()
        self.PreviousParent = v_ptr32()
        self.DeletedChildren = v_uint32()
        self.NumaNodeIndex = v_uint32()
        self.ContainerID = GUID()
        self.OverrideFlags = v_uint8()
        self._pad01bc = v_bytes(size=3)
        self.DeviceIdsHash = v_uint32()
        self.RequiresUnloadedDriver = v_uint8()
        self._pad01c4 = v_bytes(size=3)
        self.PendingEjectRelations = v_ptr32()
        self.StateFlags = v_uint32()


class KALPC_MESSAGE_ATTRIBUTES(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ClientContext = v_ptr32()
        self.ServerContext = v_ptr32()
        self.PortContext = v_ptr32()
        self.CancelPortContext = v_ptr32()
        self.SecurityData = v_ptr32()
        self.View = v_ptr32()
        self.HandleData = v_ptr32()


class PPC_DBGKD_CONTROL_SET(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Continue = v_uint32()
        self.CurrentSymbolStart = v_uint32()
        self.CurrentSymbolEnd = v_uint32()


class _unnamed_31033(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.s1 = _unnamed_31111()


class PROC_PERF_LOAD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BusyPercentage = v_uint8()
        self.FrequencyPercentage = v_uint8()


class AUX_ACCESS_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PrivilegesUsed = v_ptr32()
        self.GenericMapping = GENERIC_MAPPING()
        self.AccessesToAudit = v_uint32()
        self.MaximumAuditMask = v_uint32()
        self.TransactionId = GUID()
        self.NewSecurityDescriptor = v_ptr32()
        self.ExistingSecurityDescriptor = v_ptr32()
        self.ParentSecurityDescriptor = v_ptr32()
        self.DeRefSecurityDescriptor = v_ptr32()
        self.SDLock = v_ptr32()
        self.AccessReasons = ACCESS_REASONS()
        self.GenerateStagingEvents = v_uint8()
        self._pad00c4 = v_bytes(size=3)


class SE_AUDIT_PROCESS_CREATION_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ImageFileName = v_ptr32()


class IO_RESOURCE_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Version = v_uint16()
        self.Revision = v_uint16()
        self.Count = v_uint32()
        self.Descriptors = vstruct.VArray([ IO_RESOURCE_DESCRIPTOR() for i in xrange(1) ])


class STACK_TABLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NumStackTraces = v_uint16()
        self.TraceCapacity = v_uint16()
        self.StackTrace = vstruct.VArray([ v_ptr32() for i in xrange(16) ])
        self.StackTableHash = vstruct.VArray([ v_uint16() for i in xrange(16381) ])
        self._pad8040 = v_bytes(size=2)


class _unnamed_27934(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.FileName = v_ptr32()
        self.FileInformationClass = v_uint32()
        self.FileIndex = v_uint32()


class _unnamed_37086(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ImagePteOffset = v_uint32()


class _unnamed_37087(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.e1 = MMINPAGE_FLAGS()


class OBJECT_HEADER_HANDLE_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.HandleCountDataBase = v_ptr32()
        self._pad0008 = v_bytes(size=4)


class ETW_LOGGER_HANDLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DereferenceAndLeave = v_uint8()


class IMAGE_ROM_OPTIONAL_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Magic = v_uint16()
        self.MajorLinkerVersion = v_uint8()
        self.MinorLinkerVersion = v_uint8()
        self.SizeOfCode = v_uint32()
        self.SizeOfInitializedData = v_uint32()
        self.SizeOfUninitializedData = v_uint32()
        self.AddressOfEntryPoint = v_uint32()
        self.BaseOfCode = v_uint32()
        self.BaseOfData = v_uint32()
        self.BaseOfBss = v_uint32()
        self.GprMask = v_uint32()
        self.CprMask = vstruct.VArray([ v_uint32() for i in xrange(4) ])
        self.GpValue = v_uint32()


class POP_FX_PLUGIN(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Link = LIST_ENTRY()
        self.Version = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.Flags = v_uint64()
        self.WorkOrder = POP_FX_WORK_ORDER()
        self.WorkQueue = KQUEUE()
        self.AcceptDeviceNotification = v_ptr32()
        self.AcceptProcessorNotification = v_ptr32()
        self._pad0060 = v_bytes(size=4)


class _unnamed_27993(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SecurityInformation = v_uint32()
        self.Length = v_uint32()


class HEAP_FREE_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Size = v_uint16()
        self.Flags = v_uint8()
        self.SmallTagIndex = v_uint8()
        self.PreviousSize = v_uint16()
        self.SegmentOffset = v_uint8()
        self.UnusedBytes = v_uint8()
        self.FreeList = LIST_ENTRY()


class LOGGED_STREAM_CALLBACK_V1(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LogHandle = v_ptr32()
        self.FlushToLsnRoutine = v_ptr32()


class MI_PTE_CHAIN_HEAD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flink = MMPTE()
        self.Blink = MMPTE()
        self.PteBase = v_ptr32()
        self._pad0018 = v_bytes(size=4)


class _unnamed_27996(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SecurityInformation = v_uint32()
        self.SecurityDescriptor = v_ptr32()


class POOL_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PoolType = v_uint32()
        self.PagedLock = FAST_MUTEX()
        self._pad0040 = v_bytes(size=28)
        self.RunningAllocs = v_uint32()
        self.RunningDeAllocs = v_uint32()
        self.TotalBigPages = v_uint32()
        self.ThreadsProcessingDeferrals = v_uint32()
        self.TotalBytes = v_uint32()
        self._pad0080 = v_bytes(size=44)
        self.PoolIndex = v_uint32()
        self._pad00c0 = v_bytes(size=60)
        self.TotalPages = v_uint32()
        self._pad0100 = v_bytes(size=60)
        self.PendingFrees = SINGLE_LIST_ENTRY()
        self.PendingFreeDepth = v_uint32()
        self._pad0140 = v_bytes(size=56)
        self.ListHeads = vstruct.VArray([ LIST_ENTRY() for i in xrange(512) ])


class OBJECT_REF_STACK_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Sequence = v_uint32()
        self.Index = v_uint16()
        self.NumTraces = v_uint16()
        self.Tag = v_uint32()


class PF_KERNEL_GLOBALS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AccessBufferAgeThreshold = v_uint64()
        self.AccessBufferRef = EX_RUNDOWN_REF()
        self.AccessBufferExistsEvent = KEVENT()
        self.AccessBufferMax = v_uint32()
        self.AccessBufferList = SLIST_HEADER()
        self.StreamSequenceNumber = v_uint32()
        self.Flags = v_uint32()
        self.ScenarioPrefetchCount = v_uint32()
        self._pad0040 = v_bytes(size=12)


class _unnamed_34113(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Data = vstruct.VArray([ v_uint32() for i in xrange(3) ])


class GDI_TEB_BATCH64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Offset = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.HDC = v_uint64()
        self.Buffer = vstruct.VArray([ v_uint32() for i in xrange(310) ])


class DBGKD_READ_MEMORY64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TargetBaseAddress = v_uint64()
        self.TransferCount = v_uint32()
        self.ActualBytesRead = v_uint32()


class MI_SYSTEM_PTE_TYPE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Bitmap = RTL_BITMAP()
        self.Flags = v_uint32()
        self.Hint = v_uint32()
        self.BasePte = v_ptr32()
        self.FailureCount = v_ptr32()
        self.Vm = v_ptr32()
        self.TotalSystemPtes = v_uint32()
        self.TotalFreeSystemPtes = v_uint32()
        self.CachedPteCount = v_uint32()
        self.PteFailures = v_uint32()
        self.SpinLock = v_uint32()
        self.CachedPtes = v_ptr32()


class MMPTE_HIGHLOW(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LowPart = v_uint32()
        self.HighPart = v_uint32()


class PO_MEMORY_IMAGE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint32()
        self.ImageType = v_uint32()
        self.CheckSum = v_uint32()
        self.LengthSelf = v_uint32()
        self.PageSelf = v_uint32()
        self.PageSize = v_uint32()
        self.SystemTime = LARGE_INTEGER()
        self.InterruptTime = v_uint64()
        self.FeatureFlags = v_uint32()
        self.HiberFlags = v_uint8()
        self.spare = vstruct.VArray([ v_uint8() for i in xrange(3) ])
        self.NoHiberPtes = v_uint32()
        self.HiberVa = v_uint32()
        self.NoFreePages = v_uint32()
        self.FreeMapCheck = v_uint32()
        self.WakeCheck = v_uint32()
        self._pad0048 = v_bytes(size=4)
        self.NumPagesForLoader = v_uint64()
        self.FirstBootRestorePage = v_uint32()
        self.FirstKernelRestorePage = v_uint32()
        self.PerfInfo = PO_HIBER_PERF()
        self.FirmwareRuntimeInformationPages = v_uint32()
        self.FirmwareRuntimeInformation = vstruct.VArray([ v_uint32() for i in xrange(1) ])
        self.SiLogOffset = v_uint32()
        self.NoBootLoaderLogPages = v_uint32()
        self.BootLoaderLogPages = vstruct.VArray([ v_uint32() for i in xrange(24) ])
        self.NotUsed = v_uint32()
        self.ResumeContextCheck = v_uint32()
        self.ResumeContextPages = v_uint32()
        self.Hiberboot = v_uint8()
        self._pad0280 = v_bytes(size=3)
        self.HvCr3 = v_uint64()
        self.HvEntryPoint = v_uint64()
        self.HvReservedTransitionAddress = v_uint64()
        self.HvReservedTransitionAddressSize = v_uint64()
        self.BootFlags = v_uint64()
        self.HalEntryPointPhysical = v_uint64()
        self.HighestPhysicalPage = v_uint32()
        self.BitlockerKeyPfns = vstruct.VArray([ v_uint32() for i in xrange(4) ])
        self.HardwareSignature = v_uint32()


class LOOKASIDE_LIST_EX(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.L = GENERAL_LOOKASIDE_POOL()


class ETHREAD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Tcb = KTHREAD()
        self.CreateTime = LARGE_INTEGER()
        self.ExitTime = LARGE_INTEGER()
        self.ChargeOnlySession = v_ptr32()
        self.PostBlockList = LIST_ENTRY()
        self.TerminationPort = v_ptr32()
        self.ActiveTimerListLock = v_uint32()
        self.ActiveTimerListHead = LIST_ENTRY()
        self.Cid = CLIENT_ID()
        self.KeyedWaitSemaphore = KSEMAPHORE()
        self.ClientSecurity = PS_CLIENT_SECURITY_CONTEXT()
        self.IrpList = LIST_ENTRY()
        self.TopLevelIrp = v_uint32()
        self.DeviceToVerify = v_ptr32()
        self.Win32StartAddress = v_ptr32()
        self.LegacyPowerObject = v_ptr32()
        self.ThreadListEntry = LIST_ENTRY()
        self.RundownProtect = EX_RUNDOWN_REF()
        self.ThreadLock = EX_PUSH_LOCK()
        self.ReadClusterSize = v_uint32()
        self.MmLockOrdering = v_uint32()
        self.CmLockOrdering = v_uint32()
        self.CrossThreadFlags = v_uint32()
        self.SameThreadPassiveFlags = v_uint32()
        self.SameThreadApcFlags = v_uint32()
        self.CacheManagerActive = v_uint8()
        self.DisablePageFaultClustering = v_uint8()
        self.ActiveFaultCount = v_uint8()
        self.LockOrderState = v_uint8()
        self.AlpcMessageId = v_uint32()
        self.AlpcMessage = v_ptr32()
        self.ExitStatus = v_uint32()
        self.AlpcWaitListEntry = LIST_ENTRY()
        self.CacheManagerCount = v_uint32()
        self.IoBoostCount = v_uint32()
        self.BoostList = LIST_ENTRY()
        self.DeboostList = LIST_ENTRY()
        self.BoostListLock = v_uint32()
        self.IrpListLock = v_uint32()
        self.ReservedForSynchTracking = v_ptr32()
        self.CmCallbackListHead = SINGLE_LIST_ENTRY()
        self.ActivityId = v_ptr32()
        self.WnfContext = v_ptr32()
        self.SeLearningModeListHead = SINGLE_LIST_ENTRY()
        self.KernelStackReference = v_uint32()
        self._pad02c8 = v_bytes(size=4)


class EVENT_DATA_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Ptr = v_uint64()
        self.Size = v_uint32()
        self.Reserved = v_uint32()


class TOKEN_AUDIT_POLICY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PerUserPolicy = vstruct.VArray([ v_uint8() for i in xrange(29) ])


class HHIVE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint32()
        self.GetCellRoutine = v_ptr32()
        self.Allocate = v_ptr32()
        self.Free = v_ptr32()
        self.FileWrite = v_ptr32()
        self.FileRead = v_ptr32()
        self.HiveLoadFailure = v_ptr32()
        self.BaseBlock = v_ptr32()
        self.DirtyVector = RTL_BITMAP()
        self.DirtyCount = v_uint32()
        self.DirtyAlloc = v_uint32()
        self.BaseBlockAlloc = v_uint32()
        self.Cluster = v_uint32()
        self.Flat = v_uint8()
        self.ReadOnly = v_uint8()
        self.DirtyFlag = v_uint8()
        self._pad003c = v_bytes(size=1)
        self.HvBinHeadersUse = v_uint32()
        self.HvFreeCellsUse = v_uint32()
        self.HvUsedCellsUse = v_uint32()
        self.CmUsedCellsUse = v_uint32()
        self.HiveFlags = v_uint32()
        self.CurrentLog = v_uint32()
        self.LogSize = vstruct.VArray([ v_uint32() for i in xrange(2) ])
        self.RefreshCount = v_uint32()
        self.StorageTypeCount = v_uint32()
        self.Version = v_uint32()
        self.Storage = vstruct.VArray([ DUAL() for i in xrange(2) ])


class VF_AVL_TREE_NODE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.p = v_ptr32()
        self.RangeSize = v_uint32()


class TEB_ACTIVE_FRAME_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flags = v_uint32()
        self.FrameName = v_ptr32()


class CLIENT_ID64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.UniqueProcess = v_uint64()
        self.UniqueThread = v_uint64()


class FS_FILTER_PARAMETERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AcquireForModifiedPageWriter = _unnamed_35375()
        self._pad0014 = v_bytes(size=12)


class OBJECT_SYMBOLIC_LINK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CreationTime = LARGE_INTEGER()
        self.LinkTarget = UNICODE_STRING()
        self.DosDeviceDriveIndex = v_uint32()
        self._pad0018 = v_bytes(size=4)


class HEAP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Entry = HEAP_ENTRY()
        self.SegmentSignature = v_uint32()
        self.SegmentFlags = v_uint32()
        self.SegmentListEntry = LIST_ENTRY()
        self.Heap = v_ptr32()
        self.BaseAddress = v_ptr32()
        self.NumberOfPages = v_uint32()
        self.FirstEntry = v_ptr32()
        self.LastValidEntry = v_ptr32()
        self.NumberOfUnCommittedPages = v_uint32()
        self.NumberOfUnCommittedRanges = v_uint32()
        self.SegmentAllocatorBackTraceIndex = v_uint16()
        self.Reserved = v_uint16()
        self.UCRSegmentList = LIST_ENTRY()
        self.Flags = v_uint32()
        self.ForceFlags = v_uint32()
        self.CompatibilityFlags = v_uint32()
        self.EncodeFlagMask = v_uint32()
        self.Encoding = HEAP_ENTRY()
        self.Interceptor = v_uint32()
        self.VirtualMemoryThreshold = v_uint32()
        self.Signature = v_uint32()
        self.SegmentReserve = v_uint32()
        self.SegmentCommit = v_uint32()
        self.DeCommitFreeBlockThreshold = v_uint32()
        self.DeCommitTotalFreeThreshold = v_uint32()
        self.TotalFreeSize = v_uint32()
        self.MaximumAllocationSize = v_uint32()
        self.ProcessHeapsListIndex = v_uint16()
        self.HeaderValidateLength = v_uint16()
        self.HeaderValidateCopy = v_ptr32()
        self.NextAvailableTagIndex = v_uint16()
        self.MaximumTagIndex = v_uint16()
        self.TagEntries = v_ptr32()
        self.UCRList = LIST_ENTRY()
        self.AlignRound = v_uint32()
        self.AlignMask = v_uint32()
        self.VirtualAllocdBlocks = LIST_ENTRY()
        self.SegmentList = LIST_ENTRY()
        self.AllocatorBackTraceIndex = v_uint16()
        self._pad00b0 = v_bytes(size=2)
        self.NonDedicatedListLength = v_uint32()
        self.BlocksIndex = v_ptr32()
        self.UCRIndex = v_ptr32()
        self.PseudoTagEntries = v_ptr32()
        self.FreeLists = LIST_ENTRY()
        self.LockVariable = v_ptr32()
        self.CommitRoutine = v_ptr32()
        self.FrontEndHeap = v_ptr32()
        self.FrontHeapLockCount = v_uint16()
        self.FrontEndHeapType = v_uint8()
        self.RequestedFrontEndHeapType = v_uint8()
        self.FrontEndHeapUsageData = v_ptr32()
        self.FrontEndHeapMaximumIndex = v_uint16()
        self.FrontEndHeapStatusBitmap = vstruct.VArray([ v_uint8() for i in xrange(257) ])
        self._pad01e0 = v_bytes(size=1)
        self.Counters = HEAP_COUNTERS()
        self.TuningParameters = HEAP_TUNING_PARAMETERS()
        self._pad0248 = v_bytes(size=4)


class EJOB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Event = KEVENT()
        self.JobLinks = LIST_ENTRY()
        self.ProcessListHead = LIST_ENTRY()
        self.JobLock = ERESOURCE()
        self.TotalUserTime = LARGE_INTEGER()
        self.TotalKernelTime = LARGE_INTEGER()
        self.TotalCycleTime = LARGE_INTEGER()
        self.ThisPeriodTotalUserTime = LARGE_INTEGER()
        self.ThisPeriodTotalKernelTime = LARGE_INTEGER()
        self.TotalContextSwitches = v_uint64()
        self.TotalPageFaultCount = v_uint32()
        self.TotalProcesses = v_uint32()
        self.ActiveProcesses = v_uint32()
        self.TotalTerminatedProcesses = v_uint32()
        self.PerProcessUserTimeLimit = LARGE_INTEGER()
        self.PerJobUserTimeLimit = LARGE_INTEGER()
        self.MinimumWorkingSetSize = v_uint32()
        self.MaximumWorkingSetSize = v_uint32()
        self.LimitFlags = v_uint32()
        self.ActiveProcessLimit = v_uint32()
        self.Affinity = KAFFINITY_EX()
        self.AccessState = v_ptr32()
        self.AccessStateQuotaReference = v_ptr32()
        self.UIRestrictionsClass = v_uint32()
        self.EndOfJobTimeAction = v_uint32()
        self.CompletionPort = v_ptr32()
        self.CompletionKey = v_ptr32()
        self._pad00e0 = v_bytes(size=4)
        self.CompletionCount = v_uint64()
        self.SessionId = v_uint32()
        self.SchedulingClass = v_uint32()
        self.ReadOperationCount = v_uint64()
        self.WriteOperationCount = v_uint64()
        self.OtherOperationCount = v_uint64()
        self.ReadTransferCount = v_uint64()
        self.WriteTransferCount = v_uint64()
        self.OtherTransferCount = v_uint64()
        self.DiskIoInfo = PROCESS_DISK_COUNTERS()
        self.ProcessMemoryLimit = v_uint32()
        self.JobMemoryLimit = v_uint32()
        self.PeakProcessMemoryUsed = v_uint32()
        self.PeakJobMemoryUsed = v_uint32()
        self.EffectiveAffinity = KAFFINITY_EX()
        self._pad0168 = v_bytes(size=4)
        self.EffectivePerProcessUserTimeLimit = LARGE_INTEGER()
        self.EffectiveMinimumWorkingSetSize = v_uint32()
        self.EffectiveMaximumWorkingSetSize = v_uint32()
        self.EffectiveProcessMemoryLimit = v_uint32()
        self.EffectiveProcessMemoryLimitJob = v_ptr32()
        self.EffectivePerProcessUserTimeLimitJob = v_ptr32()
        self.EffectiveLimitFlags = v_uint32()
        self.EffectiveSchedulingClass = v_uint32()
        self.EffectiveFreezeCount = v_uint32()
        self.EffectiveBackgroundCount = v_uint32()
        self.EffectiveSwapCount = v_uint32()
        self.EffectiveNotificationLimitCount = v_uint32()
        self.EffectivePriorityClass = v_uint8()
        self.PriorityClass = v_uint8()
        self.Reserved1 = vstruct.VArray([ v_uint8() for i in xrange(2) ])
        self.CompletionFilter = v_uint32()
        self._pad01a8 = v_bytes(size=4)
        self.WakeChannel = WNF_STATE_NAME()
        self._pad01f0 = v_bytes(size=64)
        self.WakeFilter = JOBOBJECT_WAKE_FILTER()
        self.LowEdgeLatchFilter = v_uint32()
        self.OwnedHighEdgeFilters = v_uint32()
        self.NotificationLink = v_ptr32()
        self._pad0208 = v_bytes(size=4)
        self.CurrentJobMemoryUsed = v_uint64()
        self.NotificationInfo = v_ptr32()
        self.NotificationInfoQuotaReference = v_ptr32()
        self.NotificationPacket = v_ptr32()
        self.CpuRateControl = v_ptr32()
        self.EffectiveSchedulingGroup = v_ptr32()
        self.MemoryLimitsLock = EX_PUSH_LOCK()
        self.SiblingJobLinks = LIST_ENTRY()
        self.ChildJobListHead = LIST_ENTRY()
        self.ParentJob = v_ptr32()
        self.RootJob = v_ptr32()
        self.IteratorListHead = LIST_ENTRY()
        self.Accounting = EPROCESS_VALUES()
        self.ShadowActiveProcessCount = v_uint32()
        self.SequenceNumber = v_uint32()
        self.TimerListLock = v_uint32()
        self.TimerListHead = LIST_ENTRY()
        self.JobFlags = v_uint32()
        self.EffectiveHighEdgeFilters = v_uint32()
        self._pad02b8 = v_bytes(size=4)


class PROCESSOR_IDLESTATE_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TimeCheck = v_uint32()
        self.DemotePercent = v_uint8()
        self.PromotePercent = v_uint8()
        self.Spare = vstruct.VArray([ v_uint8() for i in xrange(2) ])


class DBGKD_READ_WRITE_IO_EXTENDED64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DataSize = v_uint32()
        self.InterfaceType = v_uint32()
        self.BusNumber = v_uint32()
        self.AddressSpace = v_uint32()
        self.IoAddress = v_uint64()
        self.DataValue = v_uint32()
        self._pad0020 = v_bytes(size=4)


class ALPC_COMPLETION_PACKET_LOOKASIDE_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = SINGLE_LIST_ENTRY()
        self.Packet = v_ptr32()
        self.Lookaside = v_ptr32()


class IO_STATUS_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Status = v_uint32()
        self.Information = v_uint32()


class KPROCESSOR_STATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ContextFrame = CONTEXT()
        self.SpecialRegisters = KSPECIAL_REGISTERS()


class KiIoAccessMap(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DirectionMap = vstruct.VArray([ v_uint8() for i in xrange(32) ])
        self.IoMap = vstruct.VArray([ v_uint8() for i in xrange(8196) ])


class KAPC(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint8()
        self.SpareByte0 = v_uint8()
        self.Size = v_uint8()
        self.SpareByte1 = v_uint8()
        self.SpareLong0 = v_uint32()
        self.Thread = v_ptr32()
        self.ApcListEntry = LIST_ENTRY()
        self.KernelRoutine = v_ptr32()
        self.RundownRoutine = v_ptr32()
        self.NormalRoutine = v_ptr32()
        self.NormalContext = v_ptr32()
        self.SystemArgument1 = v_ptr32()
        self.SystemArgument2 = v_ptr32()
        self.ApcStateIndex = v_uint8()
        self.ApcMode = v_uint8()
        self.Inserted = v_uint8()
        self._pad0030 = v_bytes(size=1)


class ETW_BUFFER_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ProcessorNumber = v_uint8()
        self.Alignment = v_uint8()
        self.LoggerId = v_uint16()


class POOL_TRACKER_BIG_PAGES(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Va = v_uint32()
        self.Key = v_uint32()
        self.PoolType = v_uint32()
        self.NumberOfBytes = v_uint32()


class SID_IDENTIFIER_AUTHORITY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Value = vstruct.VArray([ v_uint8() for i in xrange(6) ])


class RTL_RANGE_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListHead = LIST_ENTRY()
        self.Flags = v_uint32()
        self.Count = v_uint32()
        self.Stamp = v_uint32()


class PROC_PERF_HISTORY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Count = v_uint32()
        self.Slot = v_uint32()
        self.UtilityTotal = v_uint32()
        self.AffinitizedUtilityTotal = v_uint32()
        self.FrequencyTotal = v_uint32()
        self.HistoryList = vstruct.VArray([ PROC_PERF_HISTORY_ENTRY() for i in xrange(1) ])
        self._pad001c = v_bytes(size=2)


class CM_NOTIFY_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.HiveList = LIST_ENTRY()
        self.PostList = LIST_ENTRY()
        self.KeyControlBlock = v_ptr32()
        self.KeyBody = v_ptr32()
        self.Filter = v_uint32()
        self.SubjectContext = SECURITY_SUBJECT_CONTEXT()


class _unnamed_36425(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NodeSize = v_uint32()


class DRIVER_OBJECT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Size = v_uint16()
        self.DeviceObject = v_ptr32()
        self.Flags = v_uint32()
        self.DriverStart = v_ptr32()
        self.DriverSize = v_uint32()
        self.DriverSection = v_ptr32()
        self.DriverExtension = v_ptr32()
        self.DriverName = UNICODE_STRING()
        self.HardwareDatabase = v_ptr32()
        self.FastIoDispatch = v_ptr32()
        self.DriverInit = v_ptr32()
        self.DriverStartIo = v_ptr32()
        self.DriverUnload = v_ptr32()
        self.MajorFunction = vstruct.VArray([ v_ptr32() for i in xrange(28) ])


class VI_POOL_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PageHeader = VI_POOL_PAGE_HEADER()
        self._pad0010 = v_bytes(size=4)


class POOL_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PreviousSize = v_uint16()
        self.BlockSize = v_uint16()
        self.PoolTag = v_uint32()


class SHARED_CACHE_MAP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NodeTypeCode = v_uint16()
        self.NodeByteSize = v_uint16()
        self.OpenCount = v_uint32()
        self.FileSize = LARGE_INTEGER()
        self.BcbList = LIST_ENTRY()
        self.SectionSize = LARGE_INTEGER()
        self.ValidDataLength = LARGE_INTEGER()
        self.ValidDataGoal = LARGE_INTEGER()
        self.InitialVacbs = vstruct.VArray([ v_ptr32() for i in xrange(4) ])
        self.Vacbs = v_ptr32()
        self.FileObjectFastRef = EX_FAST_REF()
        self.VacbLock = EX_PUSH_LOCK()
        self.DirtyPages = v_uint32()
        self.LoggedStreamLinks = LIST_ENTRY()
        self.SharedCacheMapLinks = LIST_ENTRY()
        self.Flags = v_uint32()
        self.Status = v_uint32()
        self.Mbcb = v_ptr32()
        self.Section = v_ptr32()
        self.CreateEvent = v_ptr32()
        self.WaitOnActiveCount = v_ptr32()
        self.PagesToWrite = v_uint32()
        self._pad0080 = v_bytes(size=4)
        self.BeyondLastFlush = v_uint64()
        self.Callbacks = v_ptr32()
        self.LazyWriteContext = v_ptr32()
        self.PrivateList = LIST_ENTRY()
        self.V1 = LOGGED_STREAM_CALLBACK_V1()
        self.LargestLSN = LARGE_INTEGER()
        self.DirtyPageThreshold = v_uint32()
        self.LazyWritePassCount = v_uint32()
        self.UninitializeEvent = v_ptr32()
        self.BcbLock = FAST_MUTEX()
        self._pad00d8 = v_bytes(size=4)
        self.LastUnmapBehindOffset = LARGE_INTEGER()
        self.Event = KEVENT()
        self.HighWaterMappingOffset = LARGE_INTEGER()
        self.PrivateCacheMap = PRIVATE_CACHE_MAP()
        self.WriteBehindWorkQueueEntry = v_ptr32()
        self.VolumeCacheMap = v_ptr32()
        self.ProcImagePathHash = v_uint32()
        self.WritesInProgress = v_uint32()


class MMPTE_PROTOTYPE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Valid = v_uint64()


class REMOTE_PORT_VIEW(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.ViewSize = v_uint32()
        self.ViewBase = v_ptr32()


class IO_MINI_COMPLETION_PACKET_USER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self.PacketType = v_uint32()
        self.KeyContext = v_ptr32()
        self.ApcContext = v_ptr32()
        self.IoStatus = v_uint32()
        self.IoStatusInformation = v_uint32()
        self.MiniPacketCallback = v_ptr32()
        self.Context = v_ptr32()
        self.Allocated = v_uint8()
        self._pad0028 = v_bytes(size=3)


class XSTATE_FEATURE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Offset = v_uint32()
        self.Size = v_uint32()


class GDI_TEB_BATCH32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Offset = v_uint32()
        self.HDC = v_uint32()
        self.Buffer = vstruct.VArray([ v_uint32() for i in xrange(310) ])


class _unnamed_28195(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Argument1 = v_ptr32()
        self.Argument2 = v_ptr32()
        self.Argument3 = v_ptr32()
        self.Argument4 = v_ptr32()


class WHEA_TIMESTAMP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Seconds = v_uint64()


class _unnamed_28190(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ProviderId = v_uint32()
        self.DataPath = v_ptr32()
        self.BufferSize = v_uint32()
        self.Buffer = v_ptr32()


class ETW_REF_CLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.StartTime = LARGE_INTEGER()
        self.StartPerfClock = LARGE_INTEGER()


class RTL_CRITICAL_SECTION_DEBUG(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.CreatorBackTraceIndex = v_uint16()
        self.CriticalSection = v_ptr32()
        self.ProcessLocksList = LIST_ENTRY()
        self.EntryCount = v_uint32()
        self.ContentionCount = v_uint32()
        self.Flags = v_uint32()
        self.CreatorBackTraceIndexHigh = v_uint16()
        self.SpareUSHORT = v_uint16()


class PNP_DEVICE_EVENT_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self.Argument = v_uint32()
        self.CallerEvent = v_ptr32()
        self.Callback = v_ptr32()
        self.Context = v_ptr32()
        self.VetoType = v_ptr32()
        self.VetoName = v_ptr32()
        self.RefCount = v_uint32()
        self.Lock = v_uint32()
        self.Cancel = v_uint8()
        self._pad002c = v_bytes(size=3)
        self.Parent = v_ptr32()
        self.Data = PLUGPLAY_EVENT_BLOCK()


class ARBITER_CONFLICT_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.OwningObject = v_ptr32()
        self._pad0008 = v_bytes(size=4)
        self.Start = v_uint64()
        self.End = v_uint64()


class KALPC_VIEW(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ViewListEntry = LIST_ENTRY()
        self.Region = v_ptr32()
        self.OwnerPort = v_ptr32()
        self.OwnerProcess = v_ptr32()
        self.Address = v_ptr32()
        self.Size = v_uint32()
        self.SecureViewHandle = v_ptr32()
        self.WriteAccessHandle = v_ptr32()
        self.u1 = _unnamed_30920()
        self.NumberOfOwnerMessages = v_uint32()
        self.ProcessViewListEntry = LIST_ENTRY()


class ETW_SESSION_PERF_COUNTERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BufferMemoryPagedPool = v_uint32()
        self.BufferMemoryNonPagedPool = v_uint32()
        self.EventsLoggedCount = v_uint64()
        self.EventsLost = v_uint32()
        self.NumConsumers = v_uint32()


class _unnamed_34685(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Start = v_uint32()
        self.Length = v_uint32()
        self.Reserved = v_uint32()


class DIRTY_PAGE_STATISTICS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DirtyPages = v_uint32()
        self.DirtyPagesLastScan = v_uint32()
        self.DirtyPagesScheduledLastScan = v_uint32()


class ARBITER_BOOT_ALLOCATION_PARAMETERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ArbitrationList = v_ptr32()


class TOKEN(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TokenSource = TOKEN_SOURCE()
        self.TokenId = LUID()
        self.AuthenticationId = LUID()
        self.ParentTokenId = LUID()
        self.ExpirationTime = LARGE_INTEGER()
        self.TokenLock = v_ptr32()
        self.ModifiedId = LUID()
        self._pad0040 = v_bytes(size=4)
        self.Privileges = SEP_TOKEN_PRIVILEGES()
        self.AuditPolicy = SEP_AUDIT_POLICY()
        self._pad0078 = v_bytes(size=2)
        self.SessionId = v_uint32()
        self.UserAndGroupCount = v_uint32()
        self.RestrictedSidCount = v_uint32()
        self.VariableLength = v_uint32()
        self.DynamicCharged = v_uint32()
        self.DynamicAvailable = v_uint32()
        self.DefaultOwnerIndex = v_uint32()
        self.UserAndGroups = v_ptr32()
        self.RestrictedSids = v_ptr32()
        self.PrimaryGroup = v_ptr32()
        self.DynamicPart = v_ptr32()
        self.DefaultDacl = v_ptr32()
        self.TokenType = v_uint32()
        self.ImpersonationLevel = v_uint32()
        self.TokenFlags = v_uint32()
        self.TokenInUse = v_uint8()
        self._pad00b8 = v_bytes(size=3)
        self.IntegrityLevelIndex = v_uint32()
        self.MandatoryPolicy = v_uint32()
        self.LogonSession = v_ptr32()
        self.OriginatingLogonSession = LUID()
        self.SidHash = SID_AND_ATTRIBUTES_HASH()
        self.RestrictedSidHash = SID_AND_ATTRIBUTES_HASH()
        self.pSecurityAttributes = v_ptr32()
        self.Package = v_ptr32()
        self.Capabilities = v_ptr32()
        self.CapabilityCount = v_uint32()
        self.CapabilitiesHash = SID_AND_ATTRIBUTES_HASH()
        self.LowboxNumberEntry = v_ptr32()
        self.LowboxHandlesEntry = v_ptr32()
        self.pClaimAttributes = v_ptr32()
        self.VariablePart = v_uint32()
        self._pad0288 = v_bytes(size=4)


class DISPATCHER_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint8()
        self.TimerControlFlags = v_uint8()
        self.ThreadControlFlags = v_uint8()
        self.TimerMiscFlags = v_uint8()
        self.SignalState = v_uint32()
        self.WaitListHead = LIST_ENTRY()


class PROCESSOR_IDLESTATE_POLICY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Revision = v_uint16()
        self.Flags = _unnamed_35941()
        self.PolicyCount = v_uint32()
        self.Policy = vstruct.VArray([ PROCESSOR_IDLESTATE_INFO() for i in xrange(3) ])


class CM_KEY_BODY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint32()
        self.KeyControlBlock = v_ptr32()
        self.NotifyBlock = v_ptr32()
        self.ProcessID = v_ptr32()
        self.KeyBodyList = LIST_ENTRY()
        self.Flags = v_uint32()
        self.KtmTrans = v_ptr32()
        self.KtmUow = v_ptr32()
        self.ContextListHead = LIST_ENTRY()


class WHEA_IPF_CMC_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Enabled = v_uint8()
        self.Reserved = v_uint8()


class _unnamed_34098(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MinimumVector = v_uint32()
        self.MaximumVector = v_uint32()
        self.AffinityPolicy = v_uint16()
        self.Group = v_uint16()
        self.PriorityPolicy = v_uint32()
        self.TargetedProcessors = v_uint32()


class KMUTANT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Header = DISPATCHER_HEADER()
        self.MutantListEntry = LIST_ENTRY()
        self.OwnerThread = v_ptr32()
        self.Abandoned = v_uint8()
        self.ApcDisable = v_uint8()
        self._pad0020 = v_bytes(size=2)


class ASSEMBLY_STORAGE_MAP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class MI_VERIFIER_POOL_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.VerifierPoolEntry = v_ptr32()


class _unnamed_36887(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PollInterval = v_uint32()
        self.Vector = v_uint32()
        self.SwitchToPollingThreshold = v_uint32()
        self.SwitchToPollingWindow = v_uint32()
        self.ErrorThreshold = v_uint32()
        self.ErrorThresholdWindow = v_uint32()


class PROCESSOR_POWER_STATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.IdleStates = v_ptr32()
        self.IdleAccounting = v_ptr32()
        self.PlatformIdleAccounting = v_ptr32()
        self._pad0010 = v_bytes(size=4)
        self.IdleTimeLast = v_uint64()
        self.IdleTimeTotal = v_uint64()
        self.IdleTimeEntry = v_uint64()
        self.Reserved = v_uint64()
        self.IdlePolicy = PROC_IDLE_POLICY()
        self._pad0038 = v_bytes(size=3)
        self.Synchronization = PPM_IDLE_SYNCHRONIZATION_STATE()
        self._pad0040 = v_bytes(size=4)
        self.PerfFeedback = PROC_FEEDBACK()
        self.Hypervisor = v_uint32()
        self.LastSysTime = v_uint32()
        self.WmiDispatchPtr = v_uint32()
        self.WmiInterfaceEnabled = v_uint32()
        self.FFHThrottleStateInfo = PPM_FFH_THROTTLE_STATE_INFO()
        self.PerfActionDpc = KDPC()
        self.PerfActionMask = v_uint32()
        self._pad0100 = v_bytes(size=4)
        self.HvIdleCheck = PROC_IDLE_SNAP()
        self.PerfCheck = PROC_PERF_SNAP()
        self.Domain = v_ptr32()
        self.PerfConstraint = v_ptr32()
        self.Concurrency = v_ptr32()
        self.Load = v_ptr32()
        self.PerfHistory = v_ptr32()
        self.GuaranteedPerformancePercent = v_uint8()
        self.HvTargetState = v_uint8()
        self.Parked = v_uint8()
        self.OverUtilized = v_uint8()
        self.LatestPerformancePercent = v_uint32()
        self.AveragePerformancePercent = v_uint32()
        self.LatestAffinitizedPercent = v_uint32()
        self.Utility = v_uint32()
        self.AffinitizedUtility = v_uint32()
        self._pad0180 = v_bytes(size=4)


class _unnamed_36885(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PollInterval = v_uint32()


class PS_WAKE_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NotificationChannel = v_uint64()
        self.WakeCounters = vstruct.VArray([ v_uint64() for i in xrange(8) ])


class SECURITY_CLIENT_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SecurityQos = SECURITY_QUALITY_OF_SERVICE()
        self.ClientToken = v_ptr32()
        self.DirectlyAccessClientToken = v_uint8()
        self.DirectAccessEffectiveOnly = v_uint8()
        self.ServerIsRemote = v_uint8()
        self._pad0014 = v_bytes(size=1)
        self.ClientTokenControl = TOKEN_CONTROL()


class _unnamed_37062(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flags = MMSECURE_FLAGS()


class SID_AND_ATTRIBUTES_HASH(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SidCount = v_uint32()
        self.SidAttr = v_ptr32()
        self.Hash = vstruct.VArray([ v_uint32() for i in xrange(32) ])


class DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Pad = v_uint16()
        self.Limit = v_uint16()
        self.Base = v_uint32()


class DBGKD_MANIPULATE_STATE64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ApiNumber = v_uint32()
        self.ProcessorLevel = v_uint16()
        self.Processor = v_uint16()
        self.ReturnStatus = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.u = _unnamed_30113()


class _unnamed_27978(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.OutputBufferLength = v_uint32()
        self.InputBufferLength = v_uint32()
        self.FsControlCode = v_uint32()
        self.Type3InputBuffer = v_ptr32()


class LPCP_PORT_QUEUE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NonPagedPortQueue = v_ptr32()
        self.Semaphore = v_ptr32()
        self.ReceiveHead = LIST_ENTRY()


class PHYSICAL_MEMORY_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NumberOfRuns = v_uint32()
        self.NumberOfPages = v_uint32()
        self.Run = vstruct.VArray([ PHYSICAL_MEMORY_RUN() for i in xrange(1) ])


class _unnamed_27975(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.FsInformationClass = v_uint32()


class MMWSLE_FREE_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MustBeZero = v_uint32()


class CACHE_UNINITIALIZE_EVENT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Next = v_ptr32()
        self.Event = KEVENT()


class JOB_ACCESS_STATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class SECURITY_QUALITY_OF_SERVICE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.ImpersonationLevel = v_uint32()
        self.ContextTrackingMode = v_uint8()
        self.EffectiveOnly = v_uint8()
        self._pad000c = v_bytes(size=2)


class RTL_ATOM_TABLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint32()
        self.ReferenceCount = v_uint32()
        self.PushLock = EX_PUSH_LOCK()
        self.ExHandleTable = v_ptr32()
        self.Flags = v_uint32()
        self.NumberOfBuckets = v_uint32()
        self.Buckets = vstruct.VArray([ v_ptr32() for i in xrange(1) ])


class WHEA_ERROR_RECORD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Header = WHEA_ERROR_RECORD_HEADER()
        self.SectionDescriptor = vstruct.VArray([ WHEA_ERROR_RECORD_SECTION_DESCRIPTOR() for i in xrange(1) ])


class CMHIVE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Hive = HHIVE()
        self.FileHandles = vstruct.VArray([ v_ptr32() for i in xrange(6) ])
        self.NotifyList = LIST_ENTRY()
        self.HiveList = LIST_ENTRY()
        self.PreloadedHiveList = LIST_ENTRY()
        self.HiveRundown = EX_RUNDOWN_REF()
        self.ParseCacheEntries = LIST_ENTRY()
        self.KcbCacheTable = v_ptr32()
        self.KcbCacheTableSize = v_uint32()
        self.DeletedKcbTable = v_ptr32()
        self.DeletedKcbTableSize = v_uint32()
        self.Identity = v_uint32()
        self.HiveLock = v_ptr32()
        self.WriterLock = v_ptr32()
        self.FlusherLock = v_ptr32()
        self.FlushDirtyVector = RTL_BITMAP()
        self.FlushOffsetArray = v_ptr32()
        self.FlushOffsetArrayCount = v_uint32()
        self.FlushBaseBlock = v_ptr32()
        self.FlushHiveTruncated = v_uint32()
        self.SecurityLock = EX_PUSH_LOCK()
        self.UseCount = v_uint32()
        self.LastShrinkHiveSize = v_uint32()
        self.ActualFileSize = LARGE_INTEGER()
        self.LogFileSizes = vstruct.VArray([ LARGE_INTEGER() for i in xrange(2) ])
        self.FileFullPath = UNICODE_STRING()
        self.FileUserName = UNICODE_STRING()
        self.HiveRootPath = UNICODE_STRING()
        self.SecurityCount = v_uint32()
        self.SecurityCacheSize = v_uint32()
        self.SecurityHitHint = v_uint32()
        self.SecurityCache = v_ptr32()
        self.SecurityHash = vstruct.VArray([ LIST_ENTRY() for i in xrange(64) ])
        self.UnloadEventCount = v_uint32()
        self.UnloadEventArray = v_ptr32()
        self.RootKcb = v_ptr32()
        self.Frozen = v_uint8()
        self._pad0670 = v_bytes(size=3)
        self.UnloadWorkItem = v_ptr32()
        self.UnloadWorkItemHolder = CM_WORKITEM()
        self.GrowOnlyMode = v_uint8()
        self._pad068c = v_bytes(size=3)
        self.GrowOffset = v_uint32()
        self.KcbConvertListHead = LIST_ENTRY()
        self.KnodeConvertListHead = LIST_ENTRY()
        self.CellRemapArray = v_ptr32()
        self.Flags = v_uint32()
        self.TrustClassEntry = LIST_ENTRY()
        self.DirtyTime = v_uint64()
        self.CmRm = v_ptr32()
        self.CmRmInitFailPoint = v_uint32()
        self.CmRmInitFailStatus = v_uint32()
        self.CreatorOwner = v_ptr32()
        self.RundownThread = v_ptr32()
        self.ActiveFlushThread = v_ptr32()
        self.FlushBoostLock = EX_PUSH_LOCK()
        self._pad06d8 = v_bytes(size=4)
        self.LastWriteTime = LARGE_INTEGER()
        self.ReferenceCount = v_uint32()
        self.FlushFlags = v_uint32()
        self.FlushWaitList = v_ptr32()
        self.UnloadHistoryIndex = v_uint32()
        self.UnloadHistory = vstruct.VArray([ v_uint32() for i in xrange(128) ])
        self.BootStart = v_uint32()
        self.UnaccessedStart = v_uint32()
        self.UnaccessedEnd = v_uint32()
        self.LoadedKeyCount = v_uint32()
        self.HandleClosePending = v_uint32()
        self.HandleClosePendingEvent = EX_PUSH_LOCK()


class POP_SHUTDOWN_BUG_CHECK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.InitiatingThread = v_ptr32()
        self.InitiatingProcess = v_ptr32()
        self.ThreadId = v_ptr32()
        self.ProcessId = v_ptr32()
        self.Code = v_uint32()
        self.Parameter1 = v_uint32()
        self.Parameter2 = v_uint32()
        self.Parameter3 = v_uint32()
        self.Parameter4 = v_uint32()


class SECTION_OBJECT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.StartingVa = v_ptr32()
        self.EndingVa = v_ptr32()
        self.Parent = v_ptr32()
        self.LeftChild = v_ptr32()
        self.RightChild = v_ptr32()
        self.Segment = v_ptr32()


class PROC_PERF_CONSTRAINT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Prcb = v_ptr32()
        self.PerfContext = v_uint32()
        self.PlatformCap = v_uint32()
        self.ThermalCap = v_uint32()
        self.LimitReasons = v_uint32()
        self._pad0018 = v_bytes(size=4)
        self.PlatformCapStartTime = v_uint64()
        self.TargetPercent = v_uint32()
        self.DesiredPercent = v_uint32()
        self.SelectedPercent = v_uint32()
        self.SelectedFrequency = v_uint32()
        self.PreviousFrequency = v_uint32()
        self.PreviousPercent = v_uint32()
        self.LatestFrequencyPercent = v_uint32()
        self._pad0040 = v_bytes(size=4)
        self.SelectedState = v_uint64()
        self.Force = v_uint8()
        self._pad0050 = v_bytes(size=7)


class ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AllocatedResources = v_ptr32()


class LUID(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LowPart = v_uint32()
        self.HighPart = v_uint32()


class TOKEN_SOURCE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SourceName = vstruct.VArray([ v_uint8() for i in xrange(8) ])
        self.SourceIdentifier = LUID()


class OBJECT_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PointerCount = v_uint32()
        self.HandleCount = v_uint32()
        self.Lock = EX_PUSH_LOCK()
        self.TypeIndex = v_uint8()
        self.TraceFlags = v_uint8()
        self.InfoMask = v_uint8()
        self.Flags = v_uint8()
        self.ObjectCreateInfo = v_ptr32()
        self.SecurityDescriptor = v_ptr32()
        self.Body = QUAD()


class RTL_DYNAMIC_HASH_TABLE_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Linkage = LIST_ENTRY()
        self.Signature = v_uint32()


class MM_PAGED_POOL_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Mutex = FAST_MUTEX()
        self.PagedPoolAllocationMap = RTL_BITMAP()
        self.FirstPteForPagedPool = v_ptr32()
        self.PagedPoolHint = v_uint32()
        self.AllocatedPagedPool = v_uint32()


class _unnamed_33994(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Generic = _unnamed_34658()


class RTL_TIME_ZONE_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Bias = v_uint32()
        self.StandardName = vstruct.VArray([ v_uint16() for i in xrange(32) ])
        self.StandardStart = TIME_FIELDS()
        self.StandardBias = v_uint32()
        self.DaylightName = vstruct.VArray([ v_uint16() for i in xrange(32) ])
        self.DaylightStart = TIME_FIELDS()
        self.DaylightBias = v_uint32()


class OBJECT_DUMP_CONTROL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Stream = v_ptr32()
        self.Detail = v_uint32()


class CACHE_MANAGER_CALLBACKS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AcquireForLazyWrite = v_ptr32()
        self.ReleaseFromLazyWrite = v_ptr32()
        self.AcquireForReadAhead = v_ptr32()
        self.ReleaseFromReadAhead = v_ptr32()


class DBGKD_CONTINUE2(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ContinueStatus = v_uint32()
        self.ControlSet = X86_DBGKD_CONTROL_SET()
        self._pad0020 = v_bytes(size=12)


class _unnamed_35377(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SyncType = v_uint32()
        self.PageProtection = v_uint32()


class HANDLE_TRACE_DB_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ClientId = CLIENT_ID()
        self.Handle = v_ptr32()
        self.Type = v_uint32()
        self.StackTrace = vstruct.VArray([ v_ptr32() for i in xrange(16) ])


class POP_FX_DEVICE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Link = LIST_ENTRY()
        self.Plugin = v_ptr32()
        self.PluginHandle = v_ptr32()
        self.MiniPlugin = v_ptr32()
        self.MiniPluginHandle = v_ptr32()
        self.DevNode = v_ptr32()
        self.DeviceObject = v_ptr32()
        self.TargetDevice = v_ptr32()
        self.Callbacks = POP_FX_DRIVER_CALLBACKS()
        self.DriverContext = v_ptr32()
        self.RemoveLock = IO_REMOVE_LOCK()
        self.WorkOrder = POP_FX_WORK_ORDER()
        self.Status = POP_FX_DEVICE_STATUS()
        self.PowerReqCall = v_uint32()
        self.PowerNotReqCall = v_uint32()
        self.IdleLock = v_uint32()
        self.IdleTimer = KTIMER()
        self.IdleDpc = KDPC()
        self.IdleTimeout = v_uint64()
        self.IdleStamp = v_uint64()
        self.Irp = v_ptr32()
        self.IrpData = v_ptr32()
        self.NextIrpDeviceObject = v_ptr32()
        self.NextIrpPowerState = POWER_STATE()
        self.NextIrpCallerCompletion = v_ptr32()
        self.NextIrpCallerContext = v_ptr32()
        self.IrpCompleteEvent = KEVENT()
        self.ComponentCount = v_uint32()
        self.Components = vstruct.VArray([ v_ptr32() for i in xrange(1) ])


class TOKEN_CONTROL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TokenId = LUID()
        self.AuthenticationId = LUID()
        self.ModifiedId = LUID()
        self.TokenSource = TOKEN_SOURCE()


class GENERAL_LOOKASIDE_POOL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListHead = SLIST_HEADER()
        self.Depth = v_uint16()
        self.MaximumDepth = v_uint16()
        self.TotalAllocates = v_uint32()
        self.AllocateMisses = v_uint32()
        self.TotalFrees = v_uint32()
        self.FreeMisses = v_uint32()
        self.Type = v_uint32()
        self.Tag = v_uint32()
        self.Size = v_uint32()
        self.AllocateEx = v_ptr32()
        self.FreeEx = v_ptr32()
        self.ListEntry = LIST_ENTRY()
        self.LastTotalAllocates = v_uint32()
        self.LastAllocateMisses = v_uint32()
        self.Future = vstruct.VArray([ v_uint32() for i in xrange(2) ])


class MM_PAGE_ACCESS_INFO_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.File = _unnamed_32122()


class LDRP_CSLIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Tail = v_ptr32()


class ALPC_DISPATCH_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PortObject = v_ptr32()
        self.Message = v_ptr32()
        self.CommunicationInfo = v_ptr32()
        self.TargetThread = v_ptr32()
        self.TargetPort = v_ptr32()
        self.Flags = v_uint32()
        self.TotalLength = v_uint16()
        self.Type = v_uint16()
        self.DataInfoOffset = v_uint16()
        self.SignalCompletion = v_uint8()
        self.PostedToCompletionList = v_uint8()


class XPF_MCE_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MCG_CapabilityRW = v_uint32()


class tagSWITCH_CONTEXT_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.guPlatform = GUID()
        self.guMinPlatform = GUID()
        self.ulElementCount = v_uint32()
        self.ulContextMinimum = v_uint16()
        self._pad0028 = v_bytes(size=2)
        self.ullOsMaxVersionTested = v_uint64()
        self.guElements = vstruct.VArray([ GUID() for i in xrange(1) ])


class LPCP_NONPAGED_PORT_QUEUE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Semaphore = KSEMAPHORE()
        self.BackPointer = v_ptr32()


class KTRANSACTION_HISTORY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.RecordType = v_uint32()
        self.Payload = v_uint32()


class RTL_SRWLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Locked = v_uint32()


class BATTERY_REPORTING_SCALE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Granularity = v_uint32()
        self.Capacity = v_uint32()


class _unnamed_35378(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NotificationType = v_uint32()
        self.SafeToRecurse = v_uint8()
        self._pad0008 = v_bytes(size=3)


class SHARED_CACHE_MAP_LIST_CURSOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SharedCacheMapLinks = LIST_ENTRY()
        self.Flags = v_uint32()


class _unnamed_36349(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Active = v_uint32()


class MSUBSECTION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ControlArea = v_ptr32()
        self.SubsectionBase = v_ptr32()
        self.NextSubsection = v_ptr32()
        self.PtesInSubsection = v_uint32()
        self.UnusedPtes = v_uint32()
        self.u = _unnamed_33507()
        self.StartingSector = v_uint32()
        self.NumberOfFullSectors = v_uint32()
        self.SubsectionNode = MM_AVL_NODE()
        self.DereferenceList = LIST_ENTRY()
        self.NumberOfMappedViews = v_uint32()
        self.NumberOfPfnReferences = v_uint32()


class _unnamed_30922(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.WriteAccess = v_uint32()


class MMVAD_FLAGS1(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CommitCharge = v_uint32()


class TP_POOL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class XPF_MC_BANK_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ClearOnInitializationRW = v_uint8()


class _unnamed_28084(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Capabilities = v_ptr32()


class _unnamed_28872(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.VirtualAddress = v_ptr32()


class CMP_OFFSET_ARRAY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.FileOffset = v_uint32()
        self.DataBuffer = v_ptr32()
        self.DataLength = v_uint32()


class MMINPAGE_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.InjectRetry = v_uint8()
        self.PrefetchSystemVmType = v_uint8()
        self.PagePriority = v_uint8()
        self.ZeroLastPage = v_uint8()


class KALPC_MESSAGE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Entry = LIST_ENTRY()
        self.PortQueue = v_ptr32()
        self.OwnerPort = v_ptr32()
        self.WaitingThread = v_ptr32()
        self.u1 = _unnamed_31033()
        self.SequenceNo = v_uint32()
        self.QuotaProcess = v_ptr32()
        self.CancelSequencePort = v_ptr32()
        self.CancelQueuePort = v_ptr32()
        self.CancelSequenceNo = v_uint32()
        self.CancelListEntry = LIST_ENTRY()
        self.Reserve = v_ptr32()
        self.MessageAttributes = KALPC_MESSAGE_ATTRIBUTES()
        self.DataUserVa = v_ptr32()
        self.DataSystemVa = v_ptr32()
        self.CommunicationInfo = v_ptr32()
        self.ConnectionPort = v_ptr32()
        self.ServerThread = v_ptr32()
        self.WakeReference = v_ptr32()
        self.ExtensionBuffer = v_ptr32()
        self.ExtensionBufferSize = v_uint32()
        self._pad0078 = v_bytes(size=4)
        self.PortMessage = PORT_MESSAGE()


class MMVAD_FLAGS2(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.FileOffset = v_uint32()


class _unnamed_35925(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListHead = LIST_ENTRY()


class _unnamed_35924(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.UserData = v_ptr32()
        self.Owner = v_ptr32()


class LIST_ENTRY32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flink = v_uint32()
        self.Blink = v_uint32()


class _unnamed_28120(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DeviceTextType = v_uint32()
        self.LocaleId = v_uint32()


class WHEA_IPF_MCA_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Enabled = v_uint8()
        self.Reserved = v_uint8()


class SINGLE_LIST_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Next = v_ptr32()


class DBGKD_QUERY_MEMORY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Address = v_uint64()
        self.Reserved = v_uint64()
        self.AddressSpace = v_uint32()
        self.Flags = v_uint32()


class MMVAD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Core = MMVAD_SHORT()
        self.u2 = _unnamed_35666()
        self.Subsection = v_ptr32()
        self.FirstPrototypePte = v_ptr32()
        self.LastContiguousPte = v_ptr32()
        self.ViewLinks = LIST_ENTRY()
        self.VadsProcess = v_ptr32()
        self.u4 = _unnamed_35669()


class VF_AVL_TREE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NodeRangeSize = v_uint32()
        self.NodeCount = v_uint32()
        self.Tables = v_ptr32()
        self.TablesNo = v_uint32()
        self.u1 = _unnamed_36425()


class VF_POOL_TRACE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Address = v_ptr32()
        self.Size = v_uint32()
        self.Thread = v_ptr32()
        self.StackTrace = vstruct.VArray([ v_ptr32() for i in xrange(13) ])


class KDEVICE_QUEUE_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DeviceListEntry = LIST_ENTRY()
        self.SortKey = v_uint32()
        self.Inserted = v_uint8()
        self._pad0010 = v_bytes(size=3)


class MMPTE_SUBSECTION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Valid = v_uint64()


class PO_DEVICE_NOTIFY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Link = LIST_ENTRY()
        self.PowerChildren = LIST_ENTRY()
        self.PowerParents = LIST_ENTRY()
        self.TargetDevice = v_ptr32()
        self.OrderLevel = v_uint8()
        self._pad0020 = v_bytes(size=3)
        self.DeviceObject = v_ptr32()
        self.DeviceName = v_ptr32()
        self.DriverName = v_ptr32()
        self.ChildCount = v_uint32()
        self.ActiveChild = v_uint32()
        self.ParentCount = v_uint32()
        self.ActiveParent = v_uint32()


class ALPC_HANDLE_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Object = v_ptr32()


class DIRTY_PAGE_THRESHOLDS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DirtyPageThreshold = v_uint32()
        self.DirtyPageThresholdTop = v_uint32()
        self.DirtyPageThresholdBottom = v_uint32()
        self.DirtyPageTarget = v_uint32()


class EXCEPTION_RECORD32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ExceptionCode = v_uint32()
        self.ExceptionFlags = v_uint32()
        self.ExceptionRecord = v_uint32()
        self.ExceptionAddress = v_uint32()
        self.NumberParameters = v_uint32()
        self.ExceptionInformation = vstruct.VArray([ v_uint32() for i in xrange(15) ])


class VI_FAULT_TRACE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Thread = v_ptr32()
        self.StackTrace = vstruct.VArray([ v_ptr32() for i in xrange(8) ])


class _unnamed_34192(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Level = v_uint32()


class KTMOBJECT_NAMESPACE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Table = RTL_AVL_TABLE()
        self.Mutex = KMUTANT()
        self.LinksOffset = v_uint16()
        self.GuidOffset = v_uint16()
        self.Expired = v_uint8()
        self._pad0060 = v_bytes(size=3)


class OBJECT_HEADER_QUOTA_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PagedPoolCharge = v_uint32()
        self.NonPagedPoolCharge = v_uint32()
        self.SecurityDescriptorCharge = v_uint32()
        self.SecurityDescriptorQuotaBlock = v_ptr32()


class _unnamed_28990(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ImageCommitment = v_uint32()


class _unnamed_28991(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ImageInformation = v_ptr32()


class DBGKD_READ_MEMORY32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TargetBaseAddress = v_uint32()
        self.TransferCount = v_uint32()
        self.ActualBytesRead = v_uint32()


class MI_CACHED_PTE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.GlobalTimeStamp = v_uint32()
        self.PteIndex = v_uint32()


class _unnamed_34464(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AsUCHAR = v_uint8()


class ARBITER_ALTERNATIVE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Minimum = v_uint64()
        self.Maximum = v_uint64()
        self.Length = v_uint64()
        self.Alignment = v_uint64()
        self.Priority = v_uint32()
        self.Flags = v_uint32()
        self.Descriptor = v_ptr32()
        self.Reserved = vstruct.VArray([ v_uint32() for i in xrange(3) ])


class HEAP_LOOKASIDE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListHead = SLIST_HEADER()
        self.Depth = v_uint16()
        self.MaximumDepth = v_uint16()
        self.TotalAllocates = v_uint32()
        self.AllocateMisses = v_uint32()
        self.TotalFrees = v_uint32()
        self.FreeMisses = v_uint32()
        self.LastTotalAllocates = v_uint32()
        self.LastAllocateMisses = v_uint32()
        self.Counters = vstruct.VArray([ v_uint32() for i in xrange(2) ])
        self._pad0030 = v_bytes(size=4)


class WHEA_PCI_SLOT_NUMBER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.u = _unnamed_34980()


class EX_FAST_REF(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Object = v_ptr32()


class HMAP_TABLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Table = vstruct.VArray([ HMAP_ENTRY() for i in xrange(512) ])


class PNP_RESOURCE_REQUEST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PhysicalDevice = v_ptr32()
        self.Flags = v_uint32()
        self.AllocationType = v_uint32()
        self.Priority = v_uint32()
        self.Position = v_uint32()
        self.ResourceRequirements = v_ptr32()
        self.ReqList = v_ptr32()
        self.ResourceAssignment = v_ptr32()
        self.TranslatedResourceAssignment = v_ptr32()
        self.Status = v_uint32()


class RTL_ACTIVATION_CONTEXT_STACK_FRAME(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Previous = v_ptr32()
        self.ActivationContext = v_ptr32()
        self.Flags = v_uint32()


class VI_DEADLOCK_GLOBALS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TimeAcquire = v_uint64()
        self.TimeRelease = v_uint64()
        self.ResourceDatabase = v_ptr32()
        self.ResourceDatabaseCount = v_uint32()
        self.ResourceAddressRange = vstruct.VArray([ VF_ADDRESS_RANGE() for i in xrange(1023) ])
        self.ThreadDatabase = v_ptr32()
        self.ThreadDatabaseCount = v_uint32()
        self.ThreadAddressRange = vstruct.VArray([ VF_ADDRESS_RANGE() for i in xrange(1023) ])
        self.AllocationFailures = v_uint32()
        self.NodesTrimmedBasedOnAge = v_uint32()
        self.NodesTrimmedBasedOnCount = v_uint32()
        self.NodesSearched = v_uint32()
        self.MaxNodesSearched = v_uint32()
        self.SequenceNumber = v_uint32()
        self.RecursionDepthLimit = v_uint32()
        self.SearchedNodesLimit = v_uint32()
        self.DepthLimitHits = v_uint32()
        self.SearchLimitHits = v_uint32()
        self.ABC_ACB_Skipped = v_uint32()
        self.OutOfOrderReleases = v_uint32()
        self.NodesReleasedOutOfOrder = v_uint32()
        self.TotalReleases = v_uint32()
        self.RootNodesDeleted = v_uint32()
        self.ForgetHistoryCounter = v_uint32()
        self.Instigator = v_ptr32()
        self.NumberOfParticipants = v_uint32()
        self.Participant = vstruct.VArray([ v_ptr32() for i in xrange(32) ])
        self.ChildrenCountWatermark = v_uint32()
        self._pad40e0 = v_bytes(size=4)


class FS_FILTER_CALLBACKS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SizeOfFsFilterCallbacks = v_uint32()
        self.Reserved = v_uint32()
        self.PreAcquireForSectionSynchronization = v_ptr32()
        self.PostAcquireForSectionSynchronization = v_ptr32()
        self.PreReleaseForSectionSynchronization = v_ptr32()
        self.PostReleaseForSectionSynchronization = v_ptr32()
        self.PreAcquireForCcFlush = v_ptr32()
        self.PostAcquireForCcFlush = v_ptr32()
        self.PreReleaseForCcFlush = v_ptr32()
        self.PostReleaseForCcFlush = v_ptr32()
        self.PreAcquireForModifiedPageWriter = v_ptr32()
        self.PostAcquireForModifiedPageWriter = v_ptr32()
        self.PreReleaseForModifiedPageWriter = v_ptr32()
        self.PostReleaseForModifiedPageWriter = v_ptr32()


class LDR_DDAG_NODE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Modules = LIST_ENTRY()
        self.ServiceTagList = v_ptr32()
        self.LoadCount = v_uint32()
        self.ReferenceCount = v_uint32()
        self.DependencyCount = v_uint32()
        self.Dependencies = LDRP_CSLIST()
        self.IncomingDependencies = LDRP_CSLIST()
        self.State = v_uint32()
        self.CondenseLink = SINGLE_LIST_ENTRY()
        self.PreorderNumber = v_uint32()
        self.LowestLink = v_uint32()


class _unnamed_28013(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Srb = v_ptr32()


class PROC_FEEDBACK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Lock = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.CyclesLast = v_uint64()
        self.CyclesActive = v_uint64()
        self.Counters = vstruct.VArray([ v_ptr32() for i in xrange(2) ])
        self.LastUpdateTime = v_uint64()
        self.UnscaledTime = v_uint64()
        self.UnaccountedTime = v_uint64()
        self.ScaledTime = vstruct.VArray([ v_uint64() for i in xrange(2) ])
        self.UnaccountedKernelTime = v_uint64()
        self.PerformanceScaledKernelTime = v_uint64()
        self.UserTimeLast = v_uint32()
        self.KernelTimeLast = v_uint32()
        self.KernelTimesIndex = v_uint8()
        self._pad0068 = v_bytes(size=7)


class ETW_PMC_SUPPORT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Source = vstruct.VArray([ KPROFILE_SOURCE() for i in xrange(4) ])
        self.HookIdCount = v_uint32()
        self.HookId = vstruct.VArray([ v_uint16() for i in xrange(4) ])
        self.CountersCount = v_uint32()
        self.ProcessorCtrs = vstruct.VArray([ v_ptr32() for i in xrange(1) ])


class DBGKD_READ_WRITE_IO64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.IoAddress = v_uint64()
        self.DataSize = v_uint32()
        self.DataValue = v_uint32()


class KENTROPY_TIMING_STATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.EntropyCount = v_uint32()
        self.Buffer = vstruct.VArray([ v_uint32() for i in xrange(64) ])
        self.Dpc = KDPC()
        self.LastDeliveredBuffer = v_uint32()


class HEAP_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Size = v_uint16()
        self.Flags = v_uint8()
        self.SmallTagIndex = v_uint8()
        self.PreviousSize = v_uint16()
        self.SegmentOffset = v_uint8()
        self.UnusedBytes = v_uint8()


class WHEA_GENERIC_ERROR_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Reserved = v_uint8()
        self.Enabled = v_uint8()
        self.ErrStatusBlockLength = v_uint32()
        self.RelatedErrorSourceId = v_uint32()
        self.ErrStatusAddressSpaceID = v_uint8()
        self.ErrStatusAddressBitWidth = v_uint8()
        self.ErrStatusAddressBitOffset = v_uint8()
        self.ErrStatusAddressAccessSize = v_uint8()
        self.ErrStatusAddress = LARGE_INTEGER()
        self.Notify = WHEA_NOTIFICATION_DESCRIPTOR()


class TIME_FIELDS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Year = v_uint16()
        self.Month = v_uint16()
        self.Day = v_uint16()
        self.Hour = v_uint16()
        self.Minute = v_uint16()
        self.Second = v_uint16()
        self.Milliseconds = v_uint16()
        self.Weekday = v_uint16()


class WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_VALIDBITS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.FRUId = v_uint8()


class _unnamed_27515(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self._pad0028 = v_bytes(size=32)


class IMAGE_OPTIONAL_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Magic = v_uint16()
        self.MajorLinkerVersion = v_uint8()
        self.MinorLinkerVersion = v_uint8()
        self.SizeOfCode = v_uint32()
        self.SizeOfInitializedData = v_uint32()
        self.SizeOfUninitializedData = v_uint32()
        self.AddressOfEntryPoint = v_uint32()
        self.BaseOfCode = v_uint32()
        self.BaseOfData = v_uint32()
        self.ImageBase = v_uint32()
        self.SectionAlignment = v_uint32()
        self.FileAlignment = v_uint32()
        self.MajorOperatingSystemVersion = v_uint16()
        self.MinorOperatingSystemVersion = v_uint16()
        self.MajorImageVersion = v_uint16()
        self.MinorImageVersion = v_uint16()
        self.MajorSubsystemVersion = v_uint16()
        self.MinorSubsystemVersion = v_uint16()
        self.Win32VersionValue = v_uint32()
        self.SizeOfImage = v_uint32()
        self.SizeOfHeaders = v_uint32()
        self.CheckSum = v_uint32()
        self.Subsystem = v_uint16()
        self.DllCharacteristics = v_uint16()
        self.SizeOfStackReserve = v_uint32()
        self.SizeOfStackCommit = v_uint32()
        self.SizeOfHeapReserve = v_uint32()
        self.SizeOfHeapCommit = v_uint32()
        self.LoaderFlags = v_uint32()
        self.NumberOfRvaAndSizes = v_uint32()
        self.DataDirectory = vstruct.VArray([ IMAGE_DATA_DIRECTORY() for i in xrange(16) ])


class SCSI_REQUEST_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class ARBITER_ADD_RESERVED_PARAMETERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ReserveDevice = v_ptr32()


class VF_ADDRESS_RANGE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Start = v_ptr32()
        self.End = v_ptr32()


class STRING64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint16()
        self.MaximumLength = v_uint16()
        self._pad0008 = v_bytes(size=4)
        self.Buffer = v_uint64()


class JOB_NOTIFICATION_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class WHEAP_WORK_QUEUE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListHead = LIST_ENTRY()
        self.ListLock = v_uint32()
        self.ItemCount = v_uint32()
        self.Dpc = KDPC()
        self.WorkItem = WORK_QUEUE_ITEM()
        self.WorkRoutine = v_ptr32()


class _unnamed_28809(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PteFrame = v_uint32()


class FAST_MUTEX(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Count = v_uint32()
        self.Owner = v_ptr32()
        self.Contention = v_uint32()
        self.Event = KEVENT()
        self.OldIrql = v_uint32()


class AER_BRIDGE_DESCRIPTOR_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.UncorrectableErrorMaskRW = v_uint16()


class MM_AVL_TABLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BalancedRoot = MM_AVL_NODE()
        self.DepthOfTree = v_uint32()
        self.NodeHint = v_ptr32()
        self.NodeFreeHint = v_ptr32()


class MM_SESSION_SPACE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ReferenceCount = v_uint32()
        self.u = _unnamed_35601()
        self.SessionId = v_uint32()
        self.ProcessReferenceToSession = v_uint32()
        self.ProcessList = LIST_ENTRY()
        self.SessionPageDirectoryIndex = v_uint32()
        self.NonPagablePages = v_uint32()
        self.CommittedPages = v_uint32()
        self.PagedPoolStart = v_ptr32()
        self.PagedPoolEnd = v_ptr32()
        self.SessionObject = v_ptr32()
        self.SessionObjectHandle = v_ptr32()
        self.SessionPoolAllocationFailures = vstruct.VArray([ v_uint32() for i in xrange(4) ])
        self.ImageList = LIST_ENTRY()
        self.LocaleId = v_uint32()
        self.AttachCount = v_uint32()
        self.AttachGate = KGATE()
        self.WsListEntry = LIST_ENTRY()
        self._pad0080 = v_bytes(size=20)
        self.Lookaside = vstruct.VArray([ GENERAL_LOOKASIDE() for i in xrange(24) ])
        self.Session = MMSESSION()
        self.PagedPoolInfo = MM_PAGED_POOL_INFO()
        self.Vm = MMSUPPORT()
        self.Wsle = v_ptr32()
        self.DriverUnload = MI_SESSION_DRIVER_UNLOAD()
        self._pad0d80 = v_bytes(size=28)
        self.PagedPool = POOL_DESCRIPTOR()
        self.PageTables = v_ptr32()
        self._pad1ec8 = v_bytes(size=4)
        self.SpecialPool = MI_SPECIAL_POOL()
        self.SessionPteLock = FAST_MUTEX()
        self.PoolBigEntriesInUse = v_uint32()
        self.PagedPoolPdeCount = v_uint32()
        self.SpecialPoolPdeCount = v_uint32()
        self.DynamicSessionPdeCount = v_uint32()
        self.SystemPteInfo = MI_SYSTEM_PTE_TYPE()
        self.PoolTrackTableExpansion = v_ptr32()
        self.PoolTrackTableExpansionSize = v_uint32()
        self.PoolTrackBigPages = v_ptr32()
        self.PoolTrackBigPagesSize = v_uint32()
        self.IoState = v_uint32()
        self.IoStateSequence = v_uint32()
        self.IoNotificationEvent = KEVENT()
        self.SessionPoolPdes = RTL_BITMAP()
        self._pad1fc0 = v_bytes(size=28)


class WHEA_ERROR_RECORD_HEADER_VALIDBITS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PlatformId = v_uint32()


class CM_NAME_CONTROL_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Compressed = v_uint32()
        self.NameHash = CM_NAME_HASH()


class _unnamed_27770(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Create = _unnamed_27833()


class KDEVICE_QUEUE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Size = v_uint16()
        self.DeviceListHead = LIST_ENTRY()
        self.Lock = v_uint32()
        self.Busy = v_uint8()
        self._pad0014 = v_bytes(size=3)


class ARBITER_RETEST_ALLOCATION_PARAMETERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ArbitrationList = v_ptr32()
        self.AllocateFromCount = v_uint32()
        self.AllocateFrom = v_ptr32()


class NT_TIB32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ExceptionList = v_uint32()
        self.StackBase = v_uint32()
        self.StackLimit = v_uint32()
        self.SubSystemTib = v_uint32()
        self.FiberData = v_uint32()
        self.ArbitraryUserPointer = v_uint32()
        self.Self = v_uint32()


class ALPC_COMPLETION_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Entry = LIST_ENTRY()
        self.OwnerProcess = v_ptr32()
        self.CompletionListLock = EX_PUSH_LOCK()
        self.Mdl = v_ptr32()
        self.UserVa = v_ptr32()
        self.UserLimit = v_ptr32()
        self.DataUserVa = v_ptr32()
        self.SystemVa = v_ptr32()
        self.TotalSize = v_uint32()
        self.Header = v_ptr32()
        self.List = v_ptr32()
        self.ListSize = v_uint32()
        self.Bitmap = v_ptr32()
        self.BitmapSize = v_uint32()
        self.Data = v_ptr32()
        self.DataSize = v_uint32()
        self.BitmapLimit = v_uint32()
        self.BitmapNextHint = v_uint32()
        self.ConcurrencyCount = v_uint32()
        self.AttributeFlags = v_uint32()
        self.AttributeSize = v_uint32()


class _unnamed_34392(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Notification = v_ptr32()


class PORT_MESSAGE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.u1 = _unnamed_30748()
        self.u2 = _unnamed_30749()
        self.ClientId = CLIENT_ID()
        self.MessageId = v_uint32()
        self.ClientViewSize = v_uint32()


class RELATIVE_SYMLINK_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ExposedNamespaceLength = v_uint16()
        self.Flags = v_uint16()
        self.DeviceNameLength = v_uint16()
        self.Reserved = v_uint16()
        self.InteriorMountPoint = v_ptr32()
        self.OpenedName = UNICODE_STRING()


class MI_VAD_EVENT_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Next = v_ptr32()
        self.WaitReason = v_uint32()
        self.Gate = KGATE()


class IO_SECURITY_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SecurityQos = v_ptr32()
        self.AccessState = v_ptr32()
        self.DesiredAccess = v_uint32()
        self.FullCreateOptions = v_uint32()


class TERMINATION_PORT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Next = v_ptr32()
        self.Port = v_ptr32()


class VF_AVL_TABLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.RtlTable = RTL_AVL_TABLE()
        self.ReservedNode = v_ptr32()
        self.NodeToFree = v_ptr32()
        self.Lock = v_uint32()
        self._pad0080 = v_bytes(size=60)


class POP_FX_DEVICE_STATUS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Value = v_uint32()


class IO_CLIENT_EXTENSION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NextExtension = v_ptr32()
        self.ClientIdentificationAddress = v_ptr32()


class INITIAL_PRIVILEGE_SET(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PrivilegeCount = v_uint32()
        self.Control = v_uint32()
        self.Privilege = vstruct.VArray([ LUID_AND_ATTRIBUTES() for i in xrange(3) ])


class OBJECT_REF_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ObjectHeader = v_ptr32()
        self.NextRef = v_ptr32()
        self.ImageFileName = vstruct.VArray([ v_uint8() for i in xrange(16) ])
        self.NextPos = v_uint16()
        self.MaxStacks = v_uint16()
        self.StackInfo = vstruct.VArray([ OBJECT_REF_STACK_INFO() for i in xrange(0) ])


class GENERAL_LOOKASIDE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListHead = SLIST_HEADER()
        self.Depth = v_uint16()
        self.MaximumDepth = v_uint16()
        self.TotalAllocates = v_uint32()
        self.AllocateMisses = v_uint32()
        self.TotalFrees = v_uint32()
        self.FreeMisses = v_uint32()
        self.Type = v_uint32()
        self.Tag = v_uint32()
        self.Size = v_uint32()
        self.AllocateEx = v_ptr32()
        self.FreeEx = v_ptr32()
        self.ListEntry = LIST_ENTRY()
        self.LastTotalAllocates = v_uint32()
        self.LastAllocateMisses = v_uint32()
        self.Future = vstruct.VArray([ v_uint32() for i in xrange(2) ])
        self._pad0080 = v_bytes(size=56)


class POP_PER_PROCESSOR_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.UncompressedData = v_ptr32()
        self.MappingVa = v_ptr32()
        self.XpressEncodeWorkspace = v_ptr32()
        self.CompressedDataBuffer = v_ptr32()
        self.CopyTicks = v_uint64()
        self.CompressTicks = v_uint64()
        self.BytesCopied = v_uint64()
        self.PagesProcessed = v_uint64()
        self.DecompressTicks = v_uint64()
        self.ResumeCopyTicks = v_uint64()
        self.SharedBufferTicks = v_uint64()
        self.DecompressTicksByMethod = vstruct.VArray([ v_uint64() for i in xrange(2) ])
        self.DecompressSizeByMethod = vstruct.VArray([ v_uint64() for i in xrange(2) ])
        self.CompressCount = v_uint32()
        self.HuffCompressCount = v_uint32()


class DBGKD_QUERY_SPECIAL_CALLS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NumberOfSpecialCalls = v_uint32()


class WHEA_ERROR_RECORD_HEADER_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Recovered = v_uint32()


class KTIMER_TABLE_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Lock = v_uint32()
        self.Entry = LIST_ENTRY()
        self._pad0010 = v_bytes(size=4)
        self.Time = ULARGE_INTEGER()


class HMAP_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BlockAddress = v_uint32()
        self.BinAddress = v_uint32()
        self.MemAlloc = v_uint32()


class DUMP_STACK_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Init = DUMP_INITIALIZATION_CONTEXT()
        self.PartitionOffset = LARGE_INTEGER()
        self.DumpPointers = v_ptr32()
        self.PointersLength = v_uint32()
        self.ModulePrefix = v_ptr32()
        self.DriverList = LIST_ENTRY()
        self.InitMsg = STRING()
        self.ProgMsg = STRING()
        self.DoneMsg = STRING()
        self.FileObject = v_ptr32()
        self.UsageType = v_uint32()
        self._pad0100 = v_bytes(size=4)


class PNP_DEVICE_EVENT_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Status = v_uint32()
        self.EventQueueMutex = KMUTANT()
        self.Lock = FAST_MUTEX()
        self.List = LIST_ENTRY()


class VF_BTS_RECORD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.JumpedFrom = v_ptr32()
        self.JumpedTo = v_ptr32()
        self.Unused1 = v_uint32()


class KWAIT_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.WaitListEntry = LIST_ENTRY()
        self.WaitType = v_uint8()
        self.BlockState = v_uint8()
        self.WaitKey = v_uint16()
        self.Thread = v_ptr32()
        self.Object = v_ptr32()
        self.SparePtr = v_ptr32()


class DBGKD_READ_WRITE_IO32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DataSize = v_uint32()
        self.IoAddress = v_uint32()
        self.DataValue = v_uint32()


class POP_HIBER_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Reset = v_uint8()
        self.HiberFlags = v_uint8()
        self.WroteHiberFile = v_uint8()
        self.VerifyKernelPhaseOnResume = v_uint8()
        self.KernelPhaseVerificationActive = v_uint8()
        self.InitializationFinished = v_uint8()
        self._pad0008 = v_bytes(size=2)
        self.NextTableLockHeld = v_uint32()
        self.BootPhaseFinishedBarrier = v_uint32()
        self.KernelResumeFinishedBarrier = v_uint32()
        self.MapFrozen = v_uint8()
        self._pad0018 = v_bytes(size=3)
        self.DiscardMap = RTL_BITMAP()
        self.BootPhaseMap = RTL_BITMAP()
        self.ClonedRanges = LIST_ENTRY()
        self.ClonedRangeCount = v_uint32()
        self._pad0038 = v_bytes(size=4)
        self.ClonedPageCount = v_uint64()
        self.CurrentMap = v_ptr32()
        self.NextCloneRange = v_ptr32()
        self.NextPreserve = v_uint32()
        self.LoaderMdl = v_ptr32()
        self.AllocatedMdl = v_ptr32()
        self._pad0058 = v_bytes(size=4)
        self.PagesOut = v_uint64()
        self.IoPages = v_ptr32()
        self.IoPagesCount = v_uint32()
        self.CurrentMcb = v_ptr32()
        self.DumpStack = v_ptr32()
        self.WakeState = v_ptr32()
        self.IoProgress = v_uint32()
        self.Status = v_uint32()
        self.GraphicsProc = v_uint32()
        self.MemoryImage = v_ptr32()
        self.PerformanceStats = v_ptr32()
        self.BootLoaderLogMdl = v_ptr32()
        self.SiLogOffset = v_uint32()
        self.FirmwareRuntimeInformationMdl = v_ptr32()
        self.FirmwareRuntimeInformationVa = v_ptr32()
        self.ResumeContext = v_ptr32()
        self.ResumeContextPages = v_uint32()
        self.ProcessorCount = v_uint32()
        self.ProcessorContext = v_ptr32()
        self.ProdConsBuffer = v_ptr32()
        self.ProdConsSize = v_uint32()
        self.MaxDataPages = v_uint32()
        self.ExtraBuffer = v_ptr32()
        self.ExtraBufferSize = v_uint32()
        self.ExtraMapVa = v_ptr32()
        self.BitlockerKeyPFN = v_uint32()
        self._pad00c8 = v_bytes(size=4)
        self.IoInfo = POP_IO_INFO()
        self.HardwareConfigurationSignature = v_uint32()
        self._pad0120 = v_bytes(size=4)


class _unnamed_33210(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DeviceClass = _unnamed_34384()
        self._pad0020 = v_bytes(size=12)


class ARMCE_DBGKD_CONTROL_SET(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Continue = v_uint32()
        self.CurrentSymbolStart = v_uint32()
        self.CurrentSymbolEnd = v_uint32()


class ACTIVATION_CONTEXT_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class MMPTE_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Valid = v_uint64()


class RTL_BALANCED_NODE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Children = vstruct.VArray([ v_ptr32() for i in xrange(2) ])
        self.Red = v_uint8()
        self._pad000c = v_bytes(size=3)


class FILE_NETWORK_OPEN_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CreationTime = LARGE_INTEGER()
        self.LastAccessTime = LARGE_INTEGER()
        self.LastWriteTime = LARGE_INTEGER()
        self.ChangeTime = LARGE_INTEGER()
        self.AllocationSize = LARGE_INTEGER()
        self.EndOfFile = LARGE_INTEGER()
        self.FileAttributes = v_uint32()
        self._pad0038 = v_bytes(size=4)


class PROCESSOR_NUMBER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Group = v_uint16()
        self.Number = v_uint8()
        self.Reserved = v_uint8()


class RTL_DRIVE_LETTER_CURDIR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flags = v_uint16()
        self.Length = v_uint16()
        self.TimeStamp = v_uint32()
        self.DosPath = STRING()


class WHEAP_ERROR_RECORD_WRAPPER_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Preallocated = v_uint32()


class VF_TRACKER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TrackerFlags = v_uint32()
        self.TrackerSize = v_uint32()
        self.TrackerIndex = v_uint32()
        self.TraceDepth = v_uint32()


class CACHE_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Level = v_uint8()
        self.Associativity = v_uint8()
        self.LineSize = v_uint16()
        self.Size = v_uint32()
        self.Type = v_uint32()


class VF_BTS_DATA_MANAGEMENT_AREA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BTSBufferBase = v_ptr32()
        self.BTSIndex = v_ptr32()
        self.BTSMax = v_ptr32()
        self.BTSInterruptThreshold = v_ptr32()
        self.PEBSBufferBase = v_ptr32()
        self.PEBSIndex = v_ptr32()
        self.PEBSMax = v_ptr32()
        self.PEBSInterruptThreshold = v_ptr32()
        self.PEBSCounterReset = vstruct.VArray([ v_ptr32() for i in xrange(2) ])
        self.Reserved = vstruct.VArray([ v_uint8() for i in xrange(12) ])


class ARBITER_QUERY_ARBITRATE_PARAMETERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ArbitrationList = v_ptr32()


class _unnamed_34134(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length64 = v_uint32()
        self.Alignment64 = v_uint32()
        self.MinimumAddress = LARGE_INTEGER()
        self.MaximumAddress = LARGE_INTEGER()


class TXN_PARAMETER_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint16()
        self.TxFsContext = v_uint16()
        self.TransactionObject = v_ptr32()


class ULARGE_INTEGER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LowPart = v_uint32()
        self.HighPart = v_uint32()


class TEB_ACTIVE_FRAME(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flags = v_uint32()
        self.Previous = v_ptr32()
        self.Context = v_ptr32()


class ETIMER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.KeTimer = KTIMER()
        self.Lock = v_uint32()
        self.TimerApc = KAPC()
        self.TimerDpc = KDPC()
        self.ActiveTimerListEntry = LIST_ENTRY()
        self.Period = v_uint32()
        self.TimerFlags = v_uint8()
        self.DueTimeType = v_uint8()
        self.Spare2 = v_uint16()
        self.WakeReason = v_ptr32()
        self.WakeTimerListEntry = LIST_ENTRY()
        self.VirtualizedTimerCookie = v_ptr32()
        self.VirtualizedTimerLinks = LIST_ENTRY()
        self._pad00a8 = v_bytes(size=4)
        self.DueTime = v_uint64()
        self.CoalescingWindow = v_uint32()
        self._pad00b8 = v_bytes(size=4)


class DBGKD_LOAD_SYMBOLS64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PathNameLength = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.BaseOfDll = v_uint64()
        self.ProcessId = v_uint64()
        self.CheckSum = v_uint32()
        self.SizeOfImage = v_uint32()
        self.UnloadSymbols = v_uint8()
        self._pad0028 = v_bytes(size=7)


class _unnamed_34139(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Class = v_uint8()
        self.Type = v_uint8()
        self.Reserved1 = v_uint8()
        self.Reserved2 = v_uint8()
        self.IdLowPart = v_uint32()
        self.IdHighPart = v_uint32()


class _unnamed_28834(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ReferenceCount = v_uint16()
        self.ShortFlags = v_uint16()


class FREE_DISPLAY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.RealVectorSize = v_uint32()
        self.Hint = v_uint32()
        self.Display = RTL_BITMAP()


class _unnamed_30210(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ReadMemory = DBGKD_READ_MEMORY32()
        self._pad0028 = v_bytes(size=28)


class POP_FX_COMPONENT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Id = GUID()
        self.Index = v_uint32()
        self.WorkOrder = POP_FX_WORK_ORDER()
        self.Device = v_ptr32()
        self.Flags = POP_FX_COMPONENT_FLAGS()
        self.Resident = v_uint32()
        self.ActiveEvent = KEVENT()
        self.IdleLock = v_uint32()
        self.IdleConditionComplete = v_uint32()
        self.IdleStateComplete = v_uint32()
        self._pad0058 = v_bytes(size=4)
        self.IdleStamp = v_uint64()
        self.CurrentIdleState = v_uint32()
        self.IdleStateCount = v_uint32()
        self.IdleStates = v_ptr32()
        self.DeepestWakeableIdleState = v_uint32()
        self.ProviderCount = v_uint32()
        self.Providers = v_ptr32()
        self.IdleProviderCount = v_uint32()
        self.DependentCount = v_uint32()
        self.Dependents = v_ptr32()
        self._pad0088 = v_bytes(size=4)


class MM_PAGE_ACCESS_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flags = MM_PAGE_ACCESS_INFO_FLAGS()
        self.PointerProtoPte = v_ptr32()


class ARBITER_ORDERING_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Count = v_uint16()
        self.Maximum = v_uint16()
        self.Orderings = v_ptr32()


class _unnamed_25455(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LowPart = v_uint32()
        self.HighPart = v_uint32()


class OBJECT_DIRECTORY_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ChainLink = v_ptr32()
        self.Object = v_ptr32()
        self.HashValue = v_uint32()


class DEVICE_OBJECT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Size = v_uint16()
        self.ReferenceCount = v_uint32()
        self.DriverObject = v_ptr32()
        self.NextDevice = v_ptr32()
        self.AttachedDevice = v_ptr32()
        self.CurrentIrp = v_ptr32()
        self.Timer = v_ptr32()
        self.Flags = v_uint32()
        self.Characteristics = v_uint32()
        self.Vpb = v_ptr32()
        self.DeviceExtension = v_ptr32()
        self.DeviceType = v_uint32()
        self.StackSize = v_uint8()
        self._pad0034 = v_bytes(size=3)
        self.Queue = _unnamed_27515()
        self.AlignmentRequirement = v_uint32()
        self.DeviceQueue = KDEVICE_QUEUE()
        self.Dpc = KDPC()
        self.ActiveThreadCount = v_uint32()
        self.SecurityDescriptor = v_ptr32()
        self.DeviceLock = KEVENT()
        self.SectorSize = v_uint16()
        self.Spare1 = v_uint16()
        self.DeviceObjectExtension = v_ptr32()
        self.Reserved = v_ptr32()


class CM_KEY_HASH(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ConvKey = v_uint32()
        self.NextHash = v_ptr32()
        self.KeyHive = v_ptr32()
        self.KeyCell = v_uint32()


class PPM_CONCURRENCY_ACCOUNTING(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Lock = v_uint32()
        self.Processors = v_uint32()
        self.ActiveProcessors = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.LastUpdateTime = v_uint64()
        self.TotalTime = v_uint64()
        self.AccumulatedTime = vstruct.VArray([ v_uint64() for i in xrange(1) ])


class KTMNOTIFICATION_PACKET(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class ARBITER_LIST_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self.AlternativeCount = v_uint32()
        self.Alternatives = v_ptr32()
        self.PhysicalDeviceObject = v_ptr32()
        self.RequestSource = v_uint32()
        self.Flags = v_uint32()
        self.WorkSpace = v_uint32()
        self.InterfaceType = v_uint32()
        self.SlotNumber = v_uint32()
        self.BusNumber = v_uint32()
        self.Assignment = v_ptr32()
        self.SelectedAlternative = v_ptr32()
        self.Result = v_uint32()


class _unnamed_30634(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CriticalSection = RTL_CRITICAL_SECTION()
        self._pad0038 = v_bytes(size=32)


class _unnamed_33507(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LongFlags = v_uint32()


class PROC_PERF_HISTORY_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Utility = v_uint16()
        self.AffinitizedUtility = v_uint16()
        self.Frequency = v_uint8()
        self.Reserved = v_uint8()


class KGDTENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LimitLow = v_uint16()
        self.BaseLow = v_uint16()
        self.HighWord = _unnamed_26252()


class MMPFNENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PageLocation = v_uint8()
        self.Priority = v_uint8()


class WHEA_IPF_CPE_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Enabled = v_uint8()
        self.Reserved = v_uint8()


class NT_TIB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ExceptionList = v_ptr32()
        self.StackBase = v_ptr32()
        self.StackLimit = v_ptr32()
        self.SubSystemTib = v_ptr32()
        self.FiberData = v_ptr32()
        self.ArbitraryUserPointer = v_ptr32()
        self.Self = v_ptr32()


class MI_SESSION_DRIVER_UNLOAD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Function = v_ptr32()


class ARBITER_TEST_ALLOCATION_PARAMETERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ArbitrationList = v_ptr32()
        self.AllocateFromCount = v_uint32()
        self.AllocateFrom = v_ptr32()


class POWER_STATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SystemState = v_uint32()


class MI_CONTROL_AREA_WAIT_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Next = v_ptr32()
        self.WaitReason = v_uint32()
        self.WaitResponse = v_uint32()
        self.Gate = KGATE()


class UNICODE_STRING(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint16()
        self.MaximumLength = v_uint16()
        self.Buffer = v_ptr32()


class CELL_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.u = u()


class NONOPAQUE_OPLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.IrpExclusiveOplock = v_ptr32()
        self.FileObject = v_ptr32()
        self.ExclusiveOplockOwner = v_ptr32()
        self.ExclusiveOplockOwnerThread = v_ptr32()
        self.WaiterPriority = v_uint8()
        self._pad0014 = v_bytes(size=3)
        self.IrpOplocksR = LIST_ENTRY()
        self.IrpOplocksRH = LIST_ENTRY()
        self.RHBreakQueue = LIST_ENTRY()
        self.WaitingIrps = LIST_ENTRY()
        self.DelayAckFileObjectQueue = LIST_ENTRY()
        self.AtomicQueue = LIST_ENTRY()
        self.DeleterParentKey = v_ptr32()
        self.OplockState = v_uint32()
        self.FastMutex = v_ptr32()


class HEAP_LIST_LOOKUP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ExtendedLookup = v_ptr32()
        self.ArraySize = v_uint32()
        self.ExtraItem = v_uint32()
        self.ItemCount = v_uint32()
        self.OutOfRangeItems = v_uint32()
        self.BaseIndex = v_uint32()
        self.ListHead = v_ptr32()
        self.ListsInUseUlong = v_ptr32()
        self.ListHints = v_ptr32()


class CM_KEY_SECURITY_CACHE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Cell = v_uint32()
        self.ConvKey = v_uint32()
        self.List = LIST_ENTRY()
        self.DescriptorLength = v_uint32()
        self.RealRefCount = v_uint32()
        self.Descriptor = SECURITY_DESCRIPTOR_RELATIVE()


class _unnamed_35601(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LongFlags = v_uint32()


class DUMMY_FILE_OBJECT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ObjectHeader = OBJECT_HEADER()
        self.FileObjectBody = vstruct.VArray([ v_uint8() for i in xrange(128) ])


class COMPRESSED_DATA_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CompressionFormatAndEngine = v_uint16()
        self.CompressionUnitShift = v_uint8()
        self.ChunkShift = v_uint8()
        self.ClusterShift = v_uint8()
        self.Reserved = v_uint8()
        self.NumberOfChunks = v_uint16()
        self.CompressedChunkSizes = vstruct.VArray([ v_uint32() for i in xrange(1) ])


class SID_AND_ATTRIBUTES(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Sid = v_ptr32()
        self.Attributes = v_uint32()


class CM_RM(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.RmListEntry = LIST_ENTRY()
        self.TransactionListHead = LIST_ENTRY()
        self.TmHandle = v_ptr32()
        self.Tm = v_ptr32()
        self.RmHandle = v_ptr32()
        self.KtmRm = v_ptr32()
        self.RefCount = v_uint32()
        self.ContainerNum = v_uint32()
        self.ContainerSize = v_uint64()
        self.CmHive = v_ptr32()
        self.LogFileObject = v_ptr32()
        self.MarshallingContext = v_ptr32()
        self.RmFlags = v_uint32()
        self.LogStartStatus1 = v_uint32()
        self.LogStartStatus2 = v_uint32()
        self.BaseLsn = v_uint64()
        self.RmLock = v_ptr32()
        self._pad0058 = v_bytes(size=4)


class MI_USER_VA_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NumberOfCommittedPageTables = v_uint32()
        self.PhysicalMappingCount = v_uint32()
        self.VadBitMapHint = v_uint32()
        self.LastAllocationSizeHint = v_uint32()
        self.LastAllocationSize = v_uint32()
        self.LowestBottomUpVadBit = v_uint32()
        self.VadBitMapSize = v_uint32()
        self.MaximumLastVadBit = v_uint32()
        self.VadsBeingDeleted = v_uint32()
        self.LastVadDeletionEvent = v_ptr32()
        self.VadBitBuffer = v_ptr32()
        self.LowestBottomUpAllocationAddress = v_ptr32()
        self.HighestTopDownAllocationAddress = v_ptr32()
        self.FreeTebHint = v_ptr32()
        self.PrivateFixupVadCount = v_uint32()
        self.UsedPageTableEntries = vstruct.VArray([ v_uint16() for i in xrange(1536) ])
        self.CommittedPageTables = vstruct.VArray([ v_uint32() for i in xrange(48) ])


class COLORED_PAGE_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BeingZeroed = v_uint32()
        self.Processor = v_uint32()
        self.PagesQueued = v_uint32()
        self.PfnAllocation = v_ptr32()


class EPROCESS_QUOTA_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class _unnamed_27849(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SecurityContext = v_ptr32()
        self.Options = v_uint32()
        self.Reserved = v_uint16()
        self.ShareAccess = v_uint16()
        self.Parameters = v_ptr32()


class PHYSICAL_MEMORY_RUN(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BasePage = v_uint32()
        self.PageCount = v_uint32()


class FILE_SEGMENT_ELEMENT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Buffer = v_ptr64()


class _unnamed_28106(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Lock = v_uint8()


class PENDING_RELATIONS_LIST_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Link = LIST_ENTRY()
        self.WorkItem = WORK_QUEUE_ITEM()
        self.DeviceEvent = v_ptr32()
        self.DeviceObject = v_ptr32()
        self.RelationsList = v_ptr32()
        self.EjectIrp = v_ptr32()
        self.Lock = v_uint32()
        self.Problem = v_uint32()
        self.ProfileChangingEject = v_uint8()
        self.DisplaySafeRemovalDialog = v_uint8()
        self._pad0034 = v_bytes(size=2)
        self.LightestSleepState = v_uint32()
        self.DockInterface = v_ptr32()


class LDRP_DLL_SNAP_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class OBJECT_HEADER_NAME_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Directory = v_ptr32()
        self.Name = UNICODE_STRING()
        self.ReferenceCount = v_uint32()


class ACCESS_REASONS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Data = vstruct.VArray([ v_uint32() for i in xrange(32) ])


class CM_KCB_UOW(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TransactionListEntry = LIST_ENTRY()
        self.KCBLock = v_ptr32()
        self.KeyLock = v_ptr32()
        self.KCBListEntry = LIST_ENTRY()
        self.KeyControlBlock = v_ptr32()
        self.Transaction = v_ptr32()
        self.UoWState = v_uint32()
        self.ActionType = v_uint32()
        self.StorageType = v_uint32()
        self._pad0030 = v_bytes(size=4)
        self.ChildKCB = v_ptr32()
        self.NewValueCell = v_uint32()


class DBGKD_ANY_CONTROL_SET(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.X86ControlSet = X86_DBGKD_CONTROL_SET()
        self._pad001c = v_bytes(size=12)


class _unnamed_28115(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.IdType = v_uint32()


class MMSUPPORT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.WorkingSetMutex = EX_PUSH_LOCK()
        self.ExitGate = v_ptr32()
        self.AccessLog = v_ptr32()
        self.WorkingSetExpansionLinks = LIST_ENTRY()
        self.AgeDistribution = vstruct.VArray([ v_uint32() for i in xrange(7) ])
        self.MinimumWorkingSetSize = v_uint32()
        self.WorkingSetSize = v_uint32()
        self.WorkingSetPrivateSize = v_uint32()
        self.MaximumWorkingSetSize = v_uint32()
        self.ChargedWslePages = v_uint32()
        self.ActualWslePages = v_uint32()
        self.WorkingSetSizeOverhead = v_uint32()
        self.PeakWorkingSetSize = v_uint32()
        self.HardFaultCount = v_uint32()
        self.VmWorkingSetList = v_ptr32()
        self.NextPageColor = v_uint16()
        self.LastTrimStamp = v_uint16()
        self.PageFaultCount = v_uint32()
        self.TrimmedPageCount = v_uint32()
        self.ForceTrimPages = v_uint32()
        self.Flags = MMSUPPORT_FLAGS()
        self.WsSwapSupport = v_ptr32()


class LOGGED_STREAM_CALLBACK_V2(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LogHandleContext = v_ptr32()


class POP_IRP_WORKER_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Link = LIST_ENTRY()
        self.Thread = v_ptr32()
        self.Irp = v_ptr32()
        self.Device = v_ptr32()
        self.Static = v_uint8()
        self._pad0018 = v_bytes(size=3)


class HBASE_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint32()
        self.Sequence1 = v_uint32()
        self.Sequence2 = v_uint32()
        self.TimeStamp = LARGE_INTEGER()
        self.Major = v_uint32()
        self.Minor = v_uint32()
        self.Type = v_uint32()
        self.Format = v_uint32()
        self.RootCell = v_uint32()
        self.Length = v_uint32()
        self.Cluster = v_uint32()
        self.FileName = vstruct.VArray([ v_uint8() for i in xrange(64) ])
        self.RmId = GUID()
        self.LogId = GUID()
        self.Flags = v_uint32()
        self.TmId = GUID()
        self.GuidSignature = v_uint32()
        self.LastReorganizeTime = v_uint64()
        self.Reserved1 = vstruct.VArray([ v_uint32() for i in xrange(83) ])
        self.CheckSum = v_uint32()
        self.Reserved2 = vstruct.VArray([ v_uint32() for i in xrange(882) ])
        self.ThawTmId = GUID()
        self.ThawRmId = GUID()
        self.ThawLogId = GUID()
        self.BootType = v_uint32()
        self.BootRecover = v_uint32()


class _unnamed_30882(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.s1 = _unnamed_30991()


class BUS_EXTENSION_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Next = v_ptr32()
        self.BusExtension = v_ptr32()


class _unnamed_30748(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.s1 = _unnamed_30750()


class _unnamed_30749(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.s2 = _unnamed_30755()


class MMVAD_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.VadType = v_uint32()


class DBGKD_GET_SET_BUS_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BusDataType = v_uint32()
        self.BusNumber = v_uint32()
        self.SlotNumber = v_uint32()
        self.Offset = v_uint32()
        self.Length = v_uint32()


class _unnamed_28101(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.WhichSpace = v_uint32()
        self.Buffer = v_ptr32()
        self.Offset = v_uint32()
        self.Length = v_uint32()


class KDPC(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint8()
        self.Importance = v_uint8()
        self.Number = v_uint16()
        self.DpcListEntry = LIST_ENTRY()
        self.DeferredRoutine = v_ptr32()
        self.DeferredContext = v_ptr32()
        self.SystemArgument1 = v_ptr32()
        self.SystemArgument2 = v_ptr32()
        self.DpcData = v_ptr32()


class EVENT_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Size = v_uint16()
        self.HeaderType = v_uint16()
        self.Flags = v_uint16()
        self.EventProperty = v_uint16()
        self.ThreadId = v_uint32()
        self.ProcessId = v_uint32()
        self.TimeStamp = LARGE_INTEGER()
        self.ProviderId = GUID()
        self.EventDescriptor = EVENT_DESCRIPTOR()
        self.KernelTime = v_uint32()
        self.UserTime = v_uint32()
        self.ActivityId = GUID()


class HAL_PMC_COUNTERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class KEVENT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Header = DISPATCHER_HEADER()


class KRESOURCEMANAGER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NotificationAvailable = KEVENT()
        self.cookie = v_uint32()
        self.State = v_uint32()
        self.Flags = v_uint32()
        self.Mutex = KMUTANT()
        self.NamespaceLink = KTMOBJECT_NAMESPACE_LINK()
        self.RmId = GUID()
        self.NotificationQueue = KQUEUE()
        self.NotificationMutex = KMUTANT()
        self.EnlistmentHead = LIST_ENTRY()
        self.EnlistmentCount = v_uint32()
        self.NotificationRoutine = v_ptr32()
        self.Key = v_ptr32()
        self.ProtocolListHead = LIST_ENTRY()
        self.PendingPropReqListHead = LIST_ENTRY()
        self.CRMListEntry = LIST_ENTRY()
        self.Tm = v_ptr32()
        self.Description = UNICODE_STRING()
        self.Enlistments = KTMOBJECT_NAMESPACE()
        self.CompletionBinding = KRESOURCEMANAGER_COMPLETION_BINDING()


class CM_NAME_HASH(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ConvKey = v_uint32()
        self.NextHash = v_ptr32()
        self.NameLength = v_uint16()
        self.Name = vstruct.VArray([ v_uint16() for i in xrange(1) ])


class MM_PAGE_ACCESS_INFO_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Link = SINGLE_LIST_ENTRY()
        self.Type = v_uint32()
        self.EmptySequenceNumber = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.CreateTime = v_uint64()
        self.EmptyTime = v_uint64()
        self.PageEntry = v_ptr32()
        self.FileEntry = v_ptr32()
        self.FirstFileEntry = v_ptr32()
        self.Process = v_ptr32()
        self.SessionId = v_uint32()
        self._pad0038 = v_bytes(size=4)


class IMAGE_DEBUG_DIRECTORY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Characteristics = v_uint32()
        self.TimeDateStamp = v_uint32()
        self.MajorVersion = v_uint16()
        self.MinorVersion = v_uint16()
        self.Type = v_uint32()
        self.SizeOfData = v_uint32()
        self.AddressOfRawData = v_uint32()
        self.PointerToRawData = v_uint32()


class MCGEN_TRACE_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.RegistrationHandle = v_uint64()
        self.Logger = v_uint64()
        self.MatchAnyKeyword = v_uint64()
        self.MatchAllKeyword = v_uint64()
        self.Flags = v_uint32()
        self.IsEnabled = v_uint32()
        self.Level = v_uint8()
        self.Reserve = v_uint8()
        self.EnableBitsCount = v_uint16()
        self.EnableBitMask = v_ptr32()
        self.EnableKeyWords = v_ptr32()
        self.EnableLevel = v_ptr32()


class _unnamed_27733(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AsynchronousParameters = _unnamed_27748()


class CM_INTENT_LOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.OwnerCount = v_uint32()
        self.OwnerTable = v_ptr32()


class KWAIT_STATUS_REGISTER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flags = v_uint8()


class _unnamed_34980(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.bits = _unnamed_36838()


class LAZY_WRITER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ScanDpc = KDPC()
        self.ScanTimer = KTIMER()
        self.ScanActive = v_uint8()
        self.OtherWork = v_uint8()
        self.PendingTeardownScan = v_uint8()
        self.PendingPeriodicScan = v_uint8()
        self.PendingLowMemoryScan = v_uint8()
        self.PendingPowerScan = v_uint8()
        self.PendingCoalescingFlushScan = v_uint8()
        self._pad0050 = v_bytes(size=1)


class KALPC_SECURITY_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.HandleTable = v_ptr32()
        self.ContextHandle = v_ptr32()
        self.OwningProcess = v_ptr32()
        self.OwnerPort = v_ptr32()
        self.DynamicSecurity = SECURITY_CLIENT_CONTEXT()
        self.u1 = _unnamed_31167()


class RELATION_LIST_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Count = v_uint32()
        self.MaxCount = v_uint32()
        self.Devices = vstruct.VArray([ v_ptr32() for i in xrange(1) ])


class DBGKD_SET_INTERNAL_BREAKPOINT32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BreakpointAddress = v_uint32()
        self.Flags = v_uint32()


class THERMAL_INFORMATION_EX(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ThermalStamp = v_uint32()
        self.ThermalConstant1 = v_uint32()
        self.ThermalConstant2 = v_uint32()
        self.SamplingPeriod = v_uint32()
        self.CurrentTemperature = v_uint32()
        self.PassiveTripPoint = v_uint32()
        self.CriticalTripPoint = v_uint32()
        self.ActiveTripPointCount = v_uint8()
        self._pad0020 = v_bytes(size=3)
        self.ActiveTripPoint = vstruct.VArray([ v_uint32() for i in xrange(10) ])
        self.S4TransitionTripPoint = v_uint32()


class POP_THERMAL_ZONE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Link = LIST_ENTRY()
        self.State = v_uint8()
        self.Flags = v_uint8()
        self.Mode = v_uint8()
        self.PendingMode = v_uint8()
        self.ActivePoint = v_uint8()
        self.PendingActivePoint = v_uint8()
        self._pad0010 = v_bytes(size=2)
        self.HighPrecisionThrottle = v_uint32()
        self.Throttle = v_uint32()
        self.PendingThrottle = v_uint32()
        self._pad0020 = v_bytes(size=4)
        self.ThrottleStartTime = v_uint64()
        self.LastTime = v_uint64()
        self.SampleRate = v_uint32()
        self.LastTemp = v_uint32()
        self.PassiveTimer = KTIMER()
        self.PassiveDpc = KDPC()
        self.OverThrottled = POP_ACTION_TRIGGER()
        self.Irp = v_ptr32()
        self.Info = THERMAL_INFORMATION_EX()
        self.InfoLastUpdateTime = LARGE_INTEGER()
        self.Metrics = POP_THERMAL_ZONE_METRICS()


class POOL_HACKER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Header = POOL_HEADER()
        self.Contents = vstruct.VArray([ v_uint32() for i in xrange(8) ])


class IO_REMOVE_LOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Common = IO_REMOVE_LOCK_COMMON_BLOCK()


class HANDLE_TABLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NextHandleNeedingPool = v_uint32()
        self.ExtraInfoPages = v_uint32()
        self.TableCode = v_uint32()
        self.QuotaProcess = v_ptr32()
        self.HandleTableList = LIST_ENTRY()
        self.UniqueProcessId = v_uint32()
        self.Flags = v_uint32()
        self.HandleContentionEvent = EX_PUSH_LOCK()
        self.HandleTableLock = EX_PUSH_LOCK()
        self.FreeLists = vstruct.VArray([ HANDLE_TABLE_FREE_LIST() for i in xrange(1) ])


class PO_HIBER_PERF(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.HiberIoTicks = v_uint64()
        self.HiberIoCpuTicks = v_uint64()
        self.HiberInitTicks = v_uint64()
        self.HiberHiberFileTicks = v_uint64()
        self.HiberCompressTicks = v_uint64()
        self.HiberSharedBufferTicks = v_uint64()
        self.TotalHibernateTime = LARGE_INTEGER()
        self.POSTTime = v_uint32()
        self.ResumeBootMgrTime = v_uint32()
        self.BootmgrUserInputTime = v_uint32()
        self._pad0048 = v_bytes(size=4)
        self.ResumeAppTicks = v_uint64()
        self.ResumeAppStartTimestamp = v_uint64()
        self.ResumeLibraryInitTicks = v_uint64()
        self.ResumeInitTicks = v_uint64()
        self.ResumeRestoreImageStartTimestamp = v_uint64()
        self.ResumeHiberFileTicks = v_uint64()
        self.ResumeIoTicks = v_uint64()
        self.ResumeDecompressTicks = v_uint64()
        self.ResumeAllocateTicks = v_uint64()
        self.ResumeUserInOutTicks = v_uint64()
        self.ResumeMapTicks = v_uint64()
        self.ResumeUnmapTicks = v_uint64()
        self.ResumeKernelSwitchTimestamp = v_uint64()
        self.WriteLogDataTimestamp = v_uint64()
        self.KernelReturnFromHandler = v_uint64()
        self.TimeStampCounterAtSwitchTime = v_uint64()
        self.HalTscOffset = v_uint64()
        self.HvlTscOffset = v_uint64()
        self.SleeperThreadEnd = v_uint64()
        self.KernelReturnSystemPowerStateTimestamp = v_uint64()
        self.IoBoundedness = v_uint64()
        self.KernelDecompressTicks = v_uint64()
        self.KernelIoTicks = v_uint64()
        self.KernelCopyTicks = v_uint64()
        self.ReadCheckCount = v_uint64()
        self.KernelInitTicks = v_uint64()
        self.KernelResumeHiberFileTicks = v_uint64()
        self.KernelIoCpuTicks = v_uint64()
        self.KernelSharedBufferTicks = v_uint64()
        self.KernelAnimationTicks = v_uint64()
        self.AnimationStart = LARGE_INTEGER()
        self.AnimationStop = LARGE_INTEGER()
        self.DeviceResumeTime = v_uint32()
        self._pad0150 = v_bytes(size=4)
        self.BootPagesProcessed = v_uint64()
        self.KernelPagesProcessed = v_uint64()
        self.BootBytesWritten = v_uint64()
        self.KernelBytesWritten = v_uint64()
        self.BootPagesWritten = v_uint64()
        self.KernelPagesWritten = v_uint64()
        self.BytesWritten = v_uint64()
        self.PagesWritten = v_uint32()
        self.FileRuns = v_uint32()
        self.NoMultiStageResumeReason = v_uint32()
        self.MaxHuffRatio = v_uint32()
        self.AdjustedTotalResumeTime = v_uint64()
        self.ResumeCompleteTimestamp = v_uint64()


class DEFERRED_WRITE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NodeTypeCode = v_uint16()
        self.NodeByteSize = v_uint16()
        self.FileObject = v_ptr32()
        self.BytesToWrite = v_uint32()
        self.DeferredWriteLinks = LIST_ENTRY()
        self.Event = v_ptr32()
        self.PostRoutine = v_ptr32()
        self.Context1 = v_ptr32()
        self.Context2 = v_ptr32()


class _unnamed_30113(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ReadMemory = DBGKD_READ_MEMORY64()
        self._pad0028 = v_bytes(size=24)


class _unnamed_34661(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Level = v_uint16()
        self.Group = v_uint16()
        self.Vector = v_uint32()
        self.Affinity = v_uint32()


class ARBITER_INSTANCE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint32()
        self.MutexEvent = v_ptr32()
        self.Name = v_ptr32()
        self.OrderingName = v_ptr32()
        self.ResourceType = v_uint32()
        self.Allocation = v_ptr32()
        self.PossibleAllocation = v_ptr32()
        self.OrderingList = ARBITER_ORDERING_LIST()
        self.ReservedList = ARBITER_ORDERING_LIST()
        self.ReferenceCount = v_uint32()
        self.Interface = v_ptr32()
        self.AllocationStackMaxSize = v_uint32()
        self.AllocationStack = v_ptr32()
        self.UnpackRequirement = v_ptr32()
        self.PackResource = v_ptr32()
        self.UnpackResource = v_ptr32()
        self.ScoreRequirement = v_ptr32()
        self.TestAllocation = v_ptr32()
        self.RetestAllocation = v_ptr32()
        self.CommitAllocation = v_ptr32()
        self.RollbackAllocation = v_ptr32()
        self.BootAllocation = v_ptr32()
        self.QueryArbitrate = v_ptr32()
        self.QueryConflict = v_ptr32()
        self.AddReserved = v_ptr32()
        self.StartArbiter = v_ptr32()
        self.PreprocessEntry = v_ptr32()
        self.AllocateEntry = v_ptr32()
        self.GetNextAllocationRange = v_ptr32()
        self.FindSuitableRange = v_ptr32()
        self.AddAllocation = v_ptr32()
        self.BacktrackAllocation = v_ptr32()
        self.OverrideConflict = v_ptr32()
        self.InitializeRangeList = v_ptr32()
        self.TransactionInProgress = v_uint8()
        self._pad0094 = v_bytes(size=3)
        self.TransactionEvent = v_ptr32()
        self.Extension = v_ptr32()
        self.BusDeviceObject = v_ptr32()
        self.ConflictCallbackContext = v_ptr32()
        self.ConflictCallback = v_ptr32()
        self.PdoDescriptionString = vstruct.VArray([ v_uint16() for i in xrange(336) ])
        self.PdoSymbolicNameString = vstruct.VArray([ v_uint8() for i in xrange(672) ])
        self.PdoAddressString = vstruct.VArray([ v_uint16() for i in xrange(1) ])
        self._pad05ec = v_bytes(size=2)


class NAMED_PIPE_CREATE_PARAMETERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NamedPipeType = v_uint32()
        self.ReadMode = v_uint32()
        self.CompletionMode = v_uint32()
        self.MaximumInstances = v_uint32()
        self.InboundQuota = v_uint32()
        self.OutboundQuota = v_uint32()
        self.DefaultTimeout = LARGE_INTEGER()
        self.TimeoutSpecified = v_uint8()
        self._pad0028 = v_bytes(size=7)


class _unnamed_28021(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.StartSid = v_ptr32()
        self.SidList = v_ptr32()
        self.SidListLength = v_uint32()


class MMSUPPORT_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.WorkingSetType = v_uint8()
        self.SessionMaster = v_uint8()
        self.MemoryPriority = v_uint8()
        self.WsleDeleted = v_uint8()


class PROC_PERF_DOMAIN(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Link = LIST_ENTRY()
        self.Master = v_ptr32()
        self.Members = KAFFINITY_EX()
        self.ProcessorCount = v_uint32()
        self.Processors = v_ptr32()
        self.GetFFHThrottleState = v_ptr32()
        self.BoostPolicyHandler = v_ptr32()
        self.BoostModeHandler = v_ptr32()
        self.PerfSelectionHandler = v_ptr32()
        self.PerfControlHandler = v_ptr32()
        self.MaxFrequency = v_uint32()
        self.NominalFrequency = v_uint32()
        self.MaxPercent = v_uint32()
        self.MinPerfPercent = v_uint32()
        self.MinThrottlePercent = v_uint32()
        self.Coordination = v_uint8()
        self.HardPlatformCap = v_uint8()
        self.AffinitizeControl = v_uint8()
        self._pad004c = v_bytes(size=1)
        self.SelectedPercent = v_uint32()
        self.SelectedFrequency = v_uint32()
        self.DesiredPercent = v_uint32()
        self.MaxPolicyPercent = v_uint32()
        self.MinPolicyPercent = v_uint32()
        self.ConstrainedMaxPercent = v_uint32()
        self.ConstrainedMinPercent = v_uint32()
        self.GuaranteedPercent = v_uint32()
        self.TolerancePercent = v_uint32()
        self.SelectedState = v_uint64()
        self.Force = v_uint8()
        self._pad0080 = v_bytes(size=7)
        self.PerfChangeTime = v_uint64()
        self.PerfChangeIntervalCount = v_uint32()
        self._pad0090 = v_bytes(size=4)


class EXCEPTION_REGISTRATION_RECORD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Next = v_ptr32()
        self.Handler = v_ptr32()


class JOB_CPU_RATE_CONTROL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class FILE_BASIC_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CreationTime = LARGE_INTEGER()
        self.LastAccessTime = LARGE_INTEGER()
        self.LastWriteTime = LARGE_INTEGER()
        self.ChangeTime = LARGE_INTEGER()
        self.FileAttributes = v_uint32()
        self._pad0028 = v_bytes(size=4)


class PLUGPLAY_EVENT_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.EventGuid = GUID()
        self.EventCategory = v_uint32()
        self.Result = v_ptr32()
        self.Flags = v_uint32()
        self.TotalSize = v_uint32()
        self.DeviceObject = v_ptr32()
        self.u = _unnamed_33210()


class LIST_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flink = v_ptr32()
        self.Blink = v_ptr32()


class M128A(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Low = v_uint64()
        self.High = v_uint64()


class WHEA_NOTIFICATION_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint8()
        self.Length = v_uint8()
        self.Flags = WHEA_NOTIFICATION_FLAGS()
        self.u = _unnamed_34035()


class CM_KEY_SECURITY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint16()
        self.Reserved = v_uint16()
        self.Flink = v_uint32()
        self.Blink = v_uint32()
        self.ReferenceCount = v_uint32()
        self.DescriptorLength = v_uint32()
        self.Descriptor = SECURITY_DESCRIPTOR_RELATIVE()


class PNP_DEVICE_COMPLETION_QUEUE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DispatchedList = LIST_ENTRY()
        self.DispatchedCount = v_uint32()
        self.CompletedList = LIST_ENTRY()
        self.CompletedSemaphore = KSEMAPHORE()
        self.SpinLock = v_uint32()


class CLIENT_ID(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.UniqueProcess = v_ptr32()
        self.UniqueThread = v_ptr32()


class POP_ACTION_TRIGGER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint32()
        self.Flags = v_uint32()
        self.Wait = v_ptr32()
        self.Battery = _unnamed_34192()


class ETW_REALTIME_CONSUMER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Links = LIST_ENTRY()
        self.ProcessHandle = v_ptr32()
        self.ProcessObject = v_ptr32()
        self.NextNotDelivered = v_ptr32()
        self.RealtimeConnectContext = v_ptr32()
        self.DisconnectEvent = v_ptr32()
        self.DataAvailableEvent = v_ptr32()
        self.UserBufferCount = v_ptr32()
        self.UserBufferListHead = v_ptr32()
        self.BuffersLost = v_uint32()
        self.EmptyBuffersCount = v_uint32()
        self.LoggerId = v_uint16()
        self.Flags = v_uint8()
        self._pad0034 = v_bytes(size=1)
        self.ReservedBufferSpaceBitMap = RTL_BITMAP()
        self.ReservedBufferSpace = v_ptr32()
        self.ReservedBufferSpaceSize = v_uint32()
        self.UserPagesAllocated = v_uint32()
        self.UserPagesReused = v_uint32()


class WHEA_ERROR_SOURCE_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.Version = v_uint32()
        self.Type = v_uint32()
        self.State = v_uint32()
        self.MaxRawDataLength = v_uint32()
        self.NumRecordsToPreallocate = v_uint32()
        self.MaxSectionsPerRecord = v_uint32()
        self.ErrorSourceId = v_uint32()
        self.PlatformErrorSourceId = v_uint32()
        self.Flags = v_uint32()
        self.Info = _unnamed_32010()


class MI_EXTRA_IMAGE_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SizeOfHeaders = v_uint32()
        self.SizeOfImage = v_uint32()


class DEVICE_MAP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DosDevicesDirectory = v_ptr32()
        self.GlobalDosDevicesDirectory = v_ptr32()
        self.DosDevicesDirectoryHandle = v_ptr32()
        self.ReferenceCount = v_uint32()
        self.DriveMap = v_uint32()
        self.DriveType = vstruct.VArray([ v_uint8() for i in xrange(32) ])


class DBGKD_SET_INTERNAL_BREAKPOINT64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BreakpointAddress = v_uint64()
        self.Flags = v_uint32()
        self._pad0010 = v_bytes(size=4)


class _unnamed_27748(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.UserApcRoutine = v_ptr32()
        self.UserApcContext = v_ptr32()


class _unnamed_30805(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.s1 = _unnamed_30806()


class VI_TRACK_IRQL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Thread = v_ptr32()
        self.OldIrql = v_uint8()
        self.NewIrql = v_uint8()
        self.Processor = v_uint16()
        self.TickCount = v_uint32()
        self.StackTrace = vstruct.VArray([ v_ptr32() for i in xrange(5) ])


class GUID(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Data1 = v_uint32()
        self.Data2 = v_uint16()
        self.Data3 = v_uint16()
        self.Data4 = vstruct.VArray([ v_uint8() for i in xrange(8) ])


class HEAP_UCR_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self.SegmentEntry = LIST_ENTRY()
        self.Address = v_ptr32()
        self.Size = v_uint32()


class _unnamed_30413(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.FileOffset = LARGE_INTEGER()


class KSTACK_COUNT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Value = v_uint32()


class POP_SYSTEM_IDLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AverageIdleness = v_uint32()
        self.LowestIdleness = v_uint32()
        self.Time = v_uint32()
        self.Timeout = v_uint32()
        self.LastUserInput = v_uint32()
        self.Action = POWER_ACTION_POLICY()
        self.MinState = v_uint32()
        self.SystemRequired = v_uint32()
        self.IdleWorker = v_uint8()
        self.Sampling = v_uint8()
        self._pad0030 = v_bytes(size=6)
        self.LastTick = v_uint64()
        self.LastSystemRequiredTime = v_uint32()
        self._pad0040 = v_bytes(size=4)


class KAPC_STATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ApcListHead = vstruct.VArray([ LIST_ENTRY() for i in xrange(2) ])
        self.Process = v_ptr32()
        self.KernelApcInProgress = v_uint8()
        self.KernelApcPending = v_uint8()
        self.UserApcPending = v_uint8()
        self._pad0018 = v_bytes(size=1)


class COUNTER_READING(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint32()
        self.Index = v_uint32()
        self.Start = v_uint64()
        self.Total = v_uint64()


class MMVAD_SHORT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.VadNode = MM_AVL_NODE()
        self.StartingVpn = v_uint32()
        self.EndingVpn = v_uint32()
        self.PushLock = EX_PUSH_LOCK()
        self.u = _unnamed_35044()
        self.u1 = _unnamed_35045()
        self.EventList = v_ptr32()
        self.ReferenceCount = v_uint32()


class DBGKD_GET_VERSION32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MajorVersion = v_uint16()
        self.MinorVersion = v_uint16()
        self.ProtocolVersion = v_uint16()
        self.Flags = v_uint16()
        self.KernBase = v_uint32()
        self.PsLoadedModuleList = v_uint32()
        self.MachineType = v_uint16()
        self.ThCallbackStack = v_uint16()
        self.NextCallback = v_uint16()
        self.FramePointer = v_uint16()
        self.KiCallUserMode = v_uint32()
        self.KeUserCallbackDispatcher = v_uint32()
        self.BreakpointWithStatus = v_uint32()
        self.DebuggerDataList = v_uint32()


class MI_PHYSMEM_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.IoTracker = v_ptr32()


class RTL_AVL_TREE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Root = v_ptr32()


class CM_CELL_REMAP_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.OldCell = v_uint32()
        self.NewCell = v_uint32()


class PEBS_DS_SAVE_AREA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BtsBufferBase = v_uint64()
        self.BtsIndex = v_uint64()
        self.BtsAbsoluteMaximum = v_uint64()
        self.BtsInterruptThreshold = v_uint64()
        self.PebsBufferBase = v_uint64()
        self.PebsIndex = v_uint64()
        self.PebsAbsoluteMaximum = v_uint64()
        self.PebsInterruptThreshold = v_uint64()
        self.PebsCounterReset0 = v_uint64()
        self.PebsCounterReset1 = v_uint64()
        self.PebsCounterReset2 = v_uint64()
        self.PebsCounterReset3 = v_uint64()


class KDPC_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DpcListHead = LIST_ENTRY()
        self.DpcLock = v_uint32()
        self.DpcQueueDepth = v_uint32()
        self.DpcCount = v_uint32()


class KIDTENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Offset = v_uint16()
        self.Selector = v_uint16()
        self.Access = v_uint16()
        self.ExtendedOffset = v_uint16()


class _unnamed_27940(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.CompletionFilter = v_uint32()


class _unnamed_27943(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.FileInformationClass = v_uint32()


class _unnamed_27946(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.FileInformationClass = v_uint32()
        self.FileObject = v_ptr32()
        self.ReplaceIfExists = v_uint8()
        self.AdvanceOnly = v_uint8()
        self._pad0010 = v_bytes(size=2)


class XSAVE_AREA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LegacyState = XSAVE_FORMAT()
        self.Header = XSAVE_AREA_HEADER()


class MMINPAGE_SUPPORT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self.Thread = v_ptr32()
        self.ListHead = LIST_ENTRY()
        self._pad0018 = v_bytes(size=4)
        self.Event = KEVENT()
        self.CollidedEvent = KEVENT()
        self.IoStatus = IO_STATUS_BLOCK()
        self.ReadOffset = LARGE_INTEGER()
        self.PteContents = MMPTE()
        self.LockedProtoPfn = v_ptr32()
        self.WaitCount = v_uint32()
        self.ByteCount = v_uint32()
        self.u3 = _unnamed_37086()
        self.u1 = _unnamed_37087()
        self.FilePointer = v_ptr32()
        self.ControlArea = v_ptr32()
        self.FaultingAddress = v_ptr32()
        self.PointerPte = v_ptr32()
        self.BasePte = v_ptr32()
        self.Pfn = v_ptr32()
        self.PrefetchMdl = v_ptr32()
        self.Mdl = MDL()
        self.Page = vstruct.VArray([ v_uint32() for i in xrange(16) ])
        self._pad00e0 = v_bytes(size=4)


class SYSTEM_POWER_POLICY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Revision = v_uint32()
        self.PowerButton = POWER_ACTION_POLICY()
        self.SleepButton = POWER_ACTION_POLICY()
        self.LidClose = POWER_ACTION_POLICY()
        self.LidOpenWake = v_uint32()
        self.Reserved = v_uint32()
        self.Idle = POWER_ACTION_POLICY()
        self.IdleTimeout = v_uint32()
        self.IdleSensitivity = v_uint8()
        self.DynamicThrottle = v_uint8()
        self.Spare2 = vstruct.VArray([ v_uint8() for i in xrange(2) ])
        self.MinSleep = v_uint32()
        self.MaxSleep = v_uint32()
        self.ReducedLatencySleep = v_uint32()
        self.WinLogonFlags = v_uint32()
        self.Spare3 = v_uint32()
        self.DozeS4Timeout = v_uint32()
        self.BroadcastCapacityResolution = v_uint32()
        self.DischargePolicy = vstruct.VArray([ SYSTEM_POWER_LEVEL() for i in xrange(4) ])
        self.VideoTimeout = v_uint32()
        self.VideoDimDisplay = v_uint8()
        self._pad00c8 = v_bytes(size=3)
        self.VideoReserved = vstruct.VArray([ v_uint32() for i in xrange(3) ])
        self.SpindownTimeout = v_uint32()
        self.OptimizeForPower = v_uint8()
        self.FanThrottleTolerance = v_uint8()
        self.ForcedThrottle = v_uint8()
        self.MinThrottle = v_uint8()
        self.OverThrottled = POWER_ACTION_POLICY()


class KRESOURCEMANAGER_COMPLETION_BINDING(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NotificationListHead = LIST_ENTRY()
        self.Port = v_ptr32()
        self.Key = v_uint32()
        self.BindingProcess = v_ptr32()


class WHEA_XPF_MC_BANK_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BankNumber = v_uint8()
        self.ClearOnInitialization = v_uint8()
        self.StatusDataFormat = v_uint8()
        self.Flags = XPF_MC_BANK_FLAGS()
        self.ControlMsr = v_uint32()
        self.StatusMsr = v_uint32()
        self.AddressMsr = v_uint32()
        self.MiscMsr = v_uint32()
        self.ControlData = v_uint64()


class KTHREAD_COUNTERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.WaitReasonBitMap = v_uint64()
        self.UserData = v_ptr32()
        self.Flags = v_uint32()
        self.ContextSwitches = v_uint32()
        self._pad0018 = v_bytes(size=4)
        self.CycleTimeBias = v_uint64()
        self.HardwareCounters = v_uint64()
        self.HwCounter = vstruct.VArray([ COUNTER_READING() for i in xrange(16) ])


class MMADDRESS_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.u1 = _unnamed_37062()
        self.EndVa = v_ptr32()


class OBJECT_REF_TRACE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.StackTrace = vstruct.VArray([ v_ptr32() for i in xrange(16) ])


class KALPC_RESERVE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.OwnerPort = v_ptr32()
        self.HandleTable = v_ptr32()
        self.Handle = v_ptr32()
        self.Message = v_ptr32()
        self.Active = v_uint32()


class KINTERRUPT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Size = v_uint16()
        self.InterruptListEntry = LIST_ENTRY()
        self.ServiceRoutine = v_ptr32()
        self.MessageServiceRoutine = v_ptr32()
        self.MessageIndex = v_uint32()
        self.ServiceContext = v_ptr32()
        self.SpinLock = v_uint32()
        self.TickCount = v_uint32()
        self.ActualLock = v_ptr32()
        self.DispatchAddress = v_ptr32()
        self.Vector = v_uint32()
        self.Irql = v_uint8()
        self.SynchronizeIrql = v_uint8()
        self.FloatingSave = v_uint8()
        self.Connected = v_uint8()
        self.Number = v_uint32()
        self.ShareVector = v_uint8()
        self._pad003a = v_bytes(size=1)
        self.ActiveCount = v_uint16()
        self.InternalState = v_uint32()
        self.Mode = v_uint32()
        self.Polarity = v_uint32()
        self.ServiceCount = v_uint32()
        self.DispatchCount = v_uint32()
        self.PassiveEvent = v_ptr32()
        self.DispatchCode = vstruct.VArray([ v_uint32() for i in xrange(145) ])
        self.DisconnectData = v_ptr32()
        self.ServiceThread = v_ptr32()


class _unnamed_33989(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Port = _unnamed_34088()


class SECURITY_DESCRIPTOR_RELATIVE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Revision = v_uint8()
        self.Sbz1 = v_uint8()
        self.Control = v_uint16()
        self.Owner = v_uint32()
        self.Group = v_uint32()
        self.Sacl = v_uint32()
        self.Dacl = v_uint32()


class DUMP_INITIALIZATION_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.Reserved = v_uint32()
        self.MemoryBlock = v_ptr32()
        self.CommonBuffer = vstruct.VArray([ v_ptr32() for i in xrange(2) ])
        self._pad0018 = v_bytes(size=4)
        self.PhysicalAddress = vstruct.VArray([ LARGE_INTEGER() for i in xrange(2) ])
        self.StallRoutine = v_ptr32()
        self.OpenRoutine = v_ptr32()
        self.WriteRoutine = v_ptr32()
        self.FinishRoutine = v_ptr32()
        self.AdapterObject = v_ptr32()
        self.MappedRegisterBase = v_ptr32()
        self.PortConfiguration = v_ptr32()
        self.CrashDump = v_uint8()
        self.MarkMemoryOnly = v_uint8()
        self.HiberResume = v_uint8()
        self.Reserved1 = v_uint8()
        self.MaximumTransferSize = v_uint32()
        self.CommonBufferSize = v_uint32()
        self.TargetAddress = v_ptr32()
        self.WritePendingRoutine = v_ptr32()
        self.PartitionStyle = v_uint32()
        self.DiskInfo = _unnamed_37043()
        self.ReadRoutine = v_ptr32()
        self.GetDriveTelemetryRoutine = v_ptr32()
        self.LogSectionTruncateSize = v_uint32()
        self.Parameters = vstruct.VArray([ v_uint32() for i in xrange(16) ])
        self.GetTransferSizesRoutine = v_ptr32()
        self.DumpNotifyRoutine = v_ptr32()


class AER_ENDPOINT_DESCRIPTOR_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.UncorrectableErrorMaskRW = v_uint16()


class VERIFIER_SHARED_EXPORT_THUNK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class FILE_GET_QUOTA_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NextEntryOffset = v_uint32()
        self.SidLength = v_uint32()
        self.Sid = SID()


class _unnamed_34368(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Balance = v_uint32()


class OBJECT_HANDLE_COUNT_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Process = v_ptr32()
        self.HandleCount = v_uint32()


class MI_REVERSE_VIEW_MAP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ViewLinks = LIST_ENTRY()
        self.SystemCacheVa = v_ptr32()
        self.Subsection = v_ptr32()
        self.SectionOffset = v_uint64()


class IRP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Size = v_uint16()
        self.MdlAddress = v_ptr32()
        self.Flags = v_uint32()
        self.AssociatedIrp = _unnamed_27730()
        self.ThreadListEntry = LIST_ENTRY()
        self.IoStatus = IO_STATUS_BLOCK()
        self.RequestorMode = v_uint8()
        self.PendingReturned = v_uint8()
        self.StackCount = v_uint8()
        self.CurrentLocation = v_uint8()
        self.Cancel = v_uint8()
        self.CancelIrql = v_uint8()
        self.ApcEnvironment = v_uint8()
        self.AllocationFlags = v_uint8()
        self.UserIosb = v_ptr32()
        self.UserEvent = v_ptr32()
        self.Overlay = _unnamed_27733()
        self.CancelRoutine = v_ptr32()
        self.UserBuffer = v_ptr32()
        self.Tail = _unnamed_27736()


class VF_KE_CRITICAL_REGION_TRACE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Thread = v_ptr32()
        self.StackTrace = vstruct.VArray([ v_ptr32() for i in xrange(7) ])


class KGATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Header = DISPATCHER_HEADER()


class IO_COMPLETION_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Port = v_ptr32()
        self.Key = v_ptr32()


class DRIVER_EXTENSION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DriverObject = v_ptr32()
        self.AddDevice = v_ptr32()
        self.Count = v_uint32()
        self.ServiceKeyName = UNICODE_STRING()
        self.ClientDriverExtension = v_ptr32()
        self.FsFilterCallbacks = v_ptr32()
        self.KseCallbacks = v_ptr32()
        self.DvCallbacks = v_ptr32()


class RTL_CRITICAL_SECTION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DebugInfo = v_ptr32()
        self.LockCount = v_uint32()
        self.RecursionCount = v_uint32()
        self.OwningThread = v_ptr32()
        self.LockSemaphore = v_ptr32()
        self.SpinCount = v_uint32()


class PLATFORM_IDLE_ACCOUNTING(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ResetCount = v_uint32()
        self.StateCount = v_uint32()
        self.TimeUnit = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.StartTime = v_uint64()
        self.State = vstruct.VArray([ PLATFORM_IDLE_STATE_ACCOUNTING() for i in xrange(1) ])


class MMPFN(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.u1 = _unnamed_28805()
        self.u2 = _unnamed_28806()
        self.PteAddress = v_ptr32()
        self.u3 = _unnamed_28808()
        self.OriginalPte = MMPTE()
        self.u4 = _unnamed_28809()


class PO_IRP_QUEUE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CurrentIrp = v_ptr32()
        self.PendingIrpList = v_ptr32()


class HIVE_LOAD_FAILURE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Hive = v_ptr32()
        self.Index = v_uint32()
        self.RecoverableIndex = v_uint32()
        self.Locations = vstruct.VArray([ _unnamed_29146() for i in xrange(8) ])
        self.RecoverableLocations = vstruct.VArray([ _unnamed_29146() for i in xrange(8) ])
        self.RegistryIO = _unnamed_29147()
        self.CheckRegistry2 = _unnamed_29148()
        self.CheckKey = _unnamed_29149()
        self.CheckValueList = _unnamed_29150()
        self.CheckHive = _unnamed_29151()
        self.CheckHive1 = _unnamed_29151()
        self.CheckBin = _unnamed_29152()
        self.RecoverData = _unnamed_29153()


class flags(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Removable = v_uint8()


class _unnamed_31167(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.s1 = _unnamed_31169()


class _unnamed_31169(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Revoked = v_uint32()


class DBGKD_SEARCH_MEMORY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SearchAddress = v_uint64()
        self.SearchLength = v_uint64()
        self.PatternLength = v_uint32()
        self._pad0018 = v_bytes(size=4)


class MI_VAD_SEQUENTIAL_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()


class _unnamed_34678(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Channel = v_uint32()
        self.RequestLine = v_uint32()
        self.TransferWidth = v_uint8()
        self.Reserved1 = v_uint8()
        self.Reserved2 = v_uint8()
        self.Reserved3 = v_uint8()


class POP_FX_IDLE_STATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TransitionLatency = v_uint64()
        self.ResidencyRequirement = v_uint64()
        self.NominalPower = v_uint32()
        self._pad0018 = v_bytes(size=4)


class ALPC_COMPLETION_PACKET_LOOKASIDE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Lock = v_uint32()
        self.Size = v_uint32()
        self.ActiveCount = v_uint32()
        self.PendingNullCount = v_uint32()
        self.PendingCheckCompletionListCount = v_uint32()
        self.PendingDelete = v_uint32()
        self.FreeListHead = SINGLE_LIST_ENTRY()
        self.CompletionPort = v_ptr32()
        self.CompletionKey = v_ptr32()
        self.Entry = vstruct.VArray([ ALPC_COMPLETION_PACKET_LOOKASIDE_ENTRY() for i in xrange(1) ])


class WHEA_PERSISTENCE_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint64()


class ETW_LAST_ENABLE_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.EnableFlags = LARGE_INTEGER()
        self.LoggerId = v_uint16()
        self.Level = v_uint8()
        self.Enabled = v_uint8()
        self._pad0010 = v_bytes(size=4)


class HEAP_VIRTUAL_ALLOC_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Entry = LIST_ENTRY()
        self.ExtraStuff = HEAP_ENTRY_EXTRA()
        self.CommitSize = v_uint32()
        self.ReserveSize = v_uint32()
        self.BusyBlock = HEAP_ENTRY()


class VI_DEADLOCK_THREAD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Thread = v_ptr32()
        self.CurrentSpinNode = v_ptr32()
        self.CurrentOtherNode = v_ptr32()
        self.ListEntry = LIST_ENTRY()
        self.NodeCount = v_uint32()
        self.PagingCount = v_uint32()
        self.ThreadUsesEresources = v_uint8()
        self._pad0020 = v_bytes(size=3)


class _unnamed_34671(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Raw = _unnamed_34666()


class VF_SUSPECT_DRIVER_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Links = LIST_ENTRY()
        self.Loads = v_uint32()
        self.Unloads = v_uint32()
        self.BaseName = UNICODE_STRING()


class _unnamed_34674(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Channel = v_uint32()
        self.Port = v_uint32()
        self.Reserved1 = v_uint32()


class _unnamed_34574(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ProviderPdo = v_ptr32()


class _unnamed_25488(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LongFunction = v_uint32()


class ARBITER_PARAMETERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Parameters = _unnamed_34931()


class EXCEPTION_RECORD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ExceptionCode = v_uint32()
        self.ExceptionFlags = v_uint32()
        self.ExceptionRecord = v_ptr32()
        self.ExceptionAddress = v_ptr32()
        self.NumberParameters = v_uint32()
        self.ExceptionInformation = vstruct.VArray([ v_uint32() for i in xrange(15) ])


class X86_DBGKD_CONTROL_SET(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TraceFlag = v_uint32()
        self.Dr7 = v_uint32()
        self.CurrentSymbolStart = v_uint32()
        self.CurrentSymbolEnd = v_uint32()


class POP_CURRENT_BROADCAST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.InProgress = v_uint8()
        self._pad0004 = v_bytes(size=3)
        self.SystemContext = SYSTEM_POWER_STATE_CONTEXT()
        self.PowerAction = v_uint32()
        self.DeviceState = v_ptr32()


class MMPTE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.u = _unnamed_28657()


class _unnamed_28098(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.IoResourceRequirementList = v_ptr32()


class VI_DEADLOCK_NODE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Parent = v_ptr32()
        self.ChildrenList = LIST_ENTRY()
        self.SiblingsList = LIST_ENTRY()
        self.ResourceList = LIST_ENTRY()
        self.Root = v_ptr32()
        self.ThreadEntry = v_ptr32()
        self.u1 = _unnamed_36349()
        self.ChildrenCount = v_uint32()
        self.StackTrace = vstruct.VArray([ v_ptr32() for i in xrange(8) ])
        self.ParentStackTrace = vstruct.VArray([ v_ptr32() for i in xrange(8) ])


class PROC_IDLE_STATE_BUCKET(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TotalTime = v_uint64()
        self.MinTime = v_uint64()
        self.MaxTime = v_uint64()
        self.Count = v_uint32()
        self._pad0020 = v_bytes(size=4)


class _unnamed_25485(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flags = v_uint32()


class tagSWITCH_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Attribute = tagSWITCH_CONTEXT_ATTRIBUTE()
        self.Data = tagSWITCH_CONTEXT_DATA()


class _unnamed_28657(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Long = v_uint64()


class VACB_ARRAY_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.VacbArrayIndex = v_uint32()
        self.MappingCount = v_uint32()
        self.HighestMappedIndex = v_uint32()
        self.Reserved = v_uint32()


class HEAP_STOP_ON_TAG(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.HeapAndTagIndex = v_uint32()


class KPCR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NtTib = NT_TIB()
        self.SelfPcr = v_ptr32()
        self.Prcb = v_ptr32()
        self.Irql = v_uint8()
        self._pad0028 = v_bytes(size=3)
        self.IRR = v_uint32()
        self.IrrActive = v_uint32()
        self.IDR = v_uint32()
        self.KdVersionBlock = v_ptr32()
        self.IDT = v_ptr32()
        self.GDT = v_ptr32()
        self.TSS = v_ptr32()
        self.MajorVersion = v_uint16()
        self.MinorVersion = v_uint16()
        self.SetMember = v_uint32()
        self.StallScaleFactor = v_uint32()
        self.SpareUnused = v_uint8()
        self.Number = v_uint8()
        self.Spare0 = v_uint8()
        self.SecondLevelCacheAssociativity = v_uint8()
        self.VdmAlert = v_uint32()
        self.KernelReserved = vstruct.VArray([ v_uint32() for i in xrange(14) ])
        self.SecondLevelCacheSize = v_uint32()
        self.HalReserved = vstruct.VArray([ v_uint32() for i in xrange(16) ])
        self.InterruptMode = v_uint32()
        self.Spare1 = v_uint8()
        self._pad00dc = v_bytes(size=3)
        self.KernelReserved2 = vstruct.VArray([ v_uint32() for i in xrange(17) ])
        self.PrcbData = KPRCB()


class RTL_RB_TREE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Root = v_ptr32()
        self.Min = v_ptr32()


class IMAGE_FILE_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Machine = v_uint16()
        self.NumberOfSections = v_uint16()
        self.TimeDateStamp = v_uint32()
        self.PointerToSymbolTable = v_uint32()
        self.NumberOfSymbols = v_uint32()
        self.SizeOfOptionalHeader = v_uint16()
        self.Characteristics = v_uint16()


class DBGKD_SET_SPECIAL_CALL64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SpecialCall = v_uint64()


class CM_KEY_INDEX(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint16()
        self.Count = v_uint16()
        self.List = vstruct.VArray([ v_uint32() for i in xrange(1) ])


class FILE_STANDARD_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AllocationSize = LARGE_INTEGER()
        self.EndOfFile = LARGE_INTEGER()
        self.NumberOfLinks = v_uint32()
        self.DeletePending = v_uint8()
        self.Directory = v_uint8()
        self._pad0018 = v_bytes(size=2)


class RELATION_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Count = v_uint32()
        self.TagCount = v_uint32()
        self.FirstLevel = v_uint32()
        self.MaxLevel = v_uint32()
        self.Entries = vstruct.VArray([ v_ptr32() for i in xrange(1) ])


class ETWP_NOTIFICATION_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NotificationType = v_uint32()
        self.NotificationSize = v_uint32()
        self.RefCount = v_uint32()
        self.ReplyRequested = v_uint8()
        self._pad0010 = v_bytes(size=3)
        self.ReplyIndex = v_uint32()
        self.ReplyCount = v_uint32()
        self.ReplyHandle = v_uint64()
        self.TargetPID = v_uint32()
        self.SourcePID = v_uint32()
        self.DestinationGuid = GUID()
        self.SourceGuid = GUID()


class PI_RESOURCE_ARBITER_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DeviceArbiterList = LIST_ENTRY()
        self.ResourceType = v_uint8()
        self._pad000c = v_bytes(size=3)
        self.ArbiterInterface = v_ptr32()
        self.DeviceNode = v_ptr32()
        self.ResourceList = LIST_ENTRY()
        self.BestResourceList = LIST_ENTRY()
        self.BestConfig = LIST_ENTRY()
        self.ActiveArbiterList = LIST_ENTRY()
        self.State = v_uint8()
        self.ResourcesChanged = v_uint8()
        self._pad0038 = v_bytes(size=2)


class AMD64_DBGKD_CONTROL_SET(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TraceFlag = v_uint32()
        self.Dr7 = v_uint64()
        self.CurrentSymbolStart = v_uint64()
        self.CurrentSymbolEnd = v_uint64()


class _unnamed_27730(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MasterIrp = v_ptr32()


class SYSPTES_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListHead = LIST_ENTRY()
        self.Count = v_uint32()
        self.NumberOfEntries = v_uint32()
        self.NumberOfEntriesPeak = v_uint32()


class _unnamed_25441(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LowPart = v_uint32()
        self.HighPart = v_uint32()


class DBGKD_READ_WRITE_IO_EXTENDED32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DataSize = v_uint32()
        self.InterfaceType = v_uint32()
        self.BusNumber = v_uint32()
        self.AddressSpace = v_uint32()
        self.IoAddress = v_uint32()
        self.DataValue = v_uint32()


class _unnamed_35222(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ProgrammedTime = v_uint64()
        self.TimerInfo = v_ptr32()
        self._pad0010 = v_bytes(size=4)


class PEB_LDR_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.Initialized = v_uint8()
        self._pad0008 = v_bytes(size=3)
        self.SsHandle = v_ptr32()
        self.InLoadOrderModuleList = LIST_ENTRY()
        self.InMemoryOrderModuleList = LIST_ENTRY()
        self.InInitializationOrderModuleList = LIST_ENTRY()
        self.EntryInProgress = v_ptr32()
        self.ShutdownInProgress = v_uint8()
        self._pad002c = v_bytes(size=3)
        self.ShutdownThreadId = v_ptr32()


class DBGKD_WRITE_BREAKPOINT64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BreakPointAddress = v_uint64()
        self.BreakPointHandle = v_uint32()
        self._pad0010 = v_bytes(size=4)


class FSRTL_ADVANCED_FCB_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NodeTypeCode = v_uint16()
        self.NodeByteSize = v_uint16()
        self.Flags = v_uint8()
        self.IsFastIoPossible = v_uint8()
        self.Flags2 = v_uint8()
        self.Reserved = v_uint8()
        self.Resource = v_ptr32()
        self.PagingIoResource = v_ptr32()
        self.AllocationSize = LARGE_INTEGER()
        self.FileSize = LARGE_INTEGER()
        self.ValidDataLength = LARGE_INTEGER()
        self.FastMutex = v_ptr32()
        self.FilterContexts = LIST_ENTRY()
        self.PushLock = EX_PUSH_LOCK()
        self.FileContextSupportPointer = v_ptr32()
        self.Oplock = v_ptr32()


class ARBITER_INTERFACE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Size = v_uint16()
        self.Version = v_uint16()
        self.Context = v_ptr32()
        self.InterfaceReference = v_ptr32()
        self.InterfaceDereference = v_ptr32()
        self.ArbiterHandler = v_ptr32()
        self.Flags = v_uint32()


class DIAGNOSTIC_BUFFER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Size = v_uint32()
        self.CallerType = v_uint32()
        self.ProcessImageNameOffset = v_uint32()
        self.ProcessId = v_uint32()
        self.ServiceTag = v_uint32()
        self.ReasonOffset = v_uint32()


class POOL_TRACKER_TABLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Key = v_uint32()
        self.NonPagedAllocs = v_uint32()
        self.NonPagedFrees = v_uint32()
        self.NonPagedBytes = v_uint32()
        self.PagedAllocs = v_uint32()
        self.PagedFrees = v_uint32()
        self.PagedBytes = v_uint32()


class _unnamed_34312(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AllSharedExportThunks = VF_TARGET_ALL_SHARED_EXPORT_THUNKS()


class PCW_BUFFER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class _unnamed_34731(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PhysicalAddress = v_uint32()


class SECURITY_SUBJECT_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ClientToken = v_ptr32()
        self.ImpersonationLevel = v_uint32()
        self.PrimaryToken = v_ptr32()
        self.ProcessAuditId = v_ptr32()


class POP_IO_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DumpMdl = v_ptr32()
        self.IoStatus = v_uint32()
        self.IoStartCount = v_uint64()
        self.IoBytesCompleted = v_uint64()
        self.IoBytesInProgress = v_uint64()
        self.RequestSize = v_uint64()
        self.IoLocation = LARGE_INTEGER()
        self.FileOffset = v_uint64()
        self.Buffer = v_ptr32()
        self.AsyncCapable = v_uint8()
        self._pad0040 = v_bytes(size=3)
        self.BytesToRead = v_uint64()
        self.Pages = v_uint32()
        self._pad0050 = v_bytes(size=4)


class HIVE_WAIT_PACKET(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.WakeEvent = KEVENT()
        self.Status = v_uint32()
        self.Next = v_ptr32()
        self.PrimaryFileWritten = v_uint8()
        self._pad001c = v_bytes(size=3)


class KALPC_REGION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.RegionListEntry = LIST_ENTRY()
        self.Section = v_ptr32()
        self.Offset = v_uint32()
        self.Size = v_uint32()
        self.ViewSize = v_uint32()
        self.u1 = _unnamed_30902()
        self.NumberOfViews = v_uint32()
        self.ViewListHead = LIST_ENTRY()
        self.ReadOnlyView = v_ptr32()
        self.ReadWriteView = v_ptr32()


class VF_TRACKER_STAMP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Thread = v_ptr32()
        self.Flags = v_uint8()
        self.OldIrql = v_uint8()
        self.NewIrql = v_uint8()
        self.Processor = v_uint8()


class POP_FX_COMPONENT_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Value = v_uint32()
        self.Value2 = v_uint32()


class KERNEL_STACK_SEGMENT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.StackBase = v_uint32()
        self.StackLimit = v_uint32()
        self.KernelStack = v_uint32()
        self.InitialStack = v_uint32()


class ALPC_MESSAGE_ATTRIBUTES(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AllocatedAttributes = v_uint32()
        self.ValidAttributes = v_uint32()


class POP_THERMAL_ZONE_METRICS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MetricsResource = ERESOURCE()
        self.ActiveCount = v_uint32()
        self.PassiveCount = v_uint32()
        self.LastActiveStartTick = LARGE_INTEGER()
        self.AverageActiveTime = LARGE_INTEGER()
        self.LastPassiveStartTick = LARGE_INTEGER()
        self.AveragePassiveTime = LARGE_INTEGER()
        self.StartTickSinceLastReset = LARGE_INTEGER()


class PCW_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Data = v_ptr32()
        self.Size = v_uint32()


class DEVICE_RELATIONS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Count = v_uint32()
        self.Objects = vstruct.VArray([ v_ptr32() for i in xrange(1) ])


class POOL_BLOCK_HEAD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Header = POOL_HEADER()
        self.List = LIST_ENTRY()


class TRACE_ENABLE_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.IsEnabled = v_uint32()
        self.Level = v_uint8()
        self.Reserved1 = v_uint8()
        self.LoggerId = v_uint16()
        self.EnableProperty = v_uint32()
        self.Reserved2 = v_uint32()
        self.MatchAnyKeyword = v_uint64()
        self.MatchAllKeyword = v_uint64()


class _unnamed_34389(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NotificationStructure = v_ptr32()
        self.DeviceId = vstruct.VArray([ v_uint16() for i in xrange(1) ])
        self._pad0008 = v_bytes(size=2)


class MMSUBSECTION_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SubsectionAccessed = v_uint16()
        self.SubsectionStatic = v_uint16()


class INTERFACE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Size = v_uint16()
        self.Version = v_uint16()
        self.Context = v_ptr32()
        self.InterfaceReference = v_ptr32()
        self.InterfaceDereference = v_ptr32()


class SYSTEM_POWER_LEVEL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Enable = v_uint8()
        self.Spare = vstruct.VArray([ v_uint8() for i in xrange(3) ])
        self.BatteryLevel = v_uint32()
        self.PowerPolicy = POWER_ACTION_POLICY()
        self.MinSystemState = v_uint32()


class _unnamed_34387(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DeviceId = vstruct.VArray([ v_uint16() for i in xrange(1) ])


class WMI_LOGGER_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LoggerId = v_uint32()
        self.BufferSize = v_uint32()
        self.MaximumEventSize = v_uint32()
        self.LoggerMode = v_uint32()
        self.AcceptNewEvents = v_uint32()
        self.EventMarker = vstruct.VArray([ v_uint32() for i in xrange(1) ])
        self.ErrorMarker = v_uint32()
        self.SizeMask = v_uint32()
        self.GetCpuClock = v_ptr32()
        self.LoggerThread = v_ptr32()
        self.LoggerStatus = v_uint32()
        self.FailureReason = v_uint32()
        self.BufferQueue = ETW_BUFFER_QUEUE()
        self.OverflowQueue = ETW_BUFFER_QUEUE()
        self.GlobalList = LIST_ENTRY()
        self.ProviderBinaryList = LIST_ENTRY()
        self.BatchedBufferList = v_ptr32()
        self.LoggerName = UNICODE_STRING()
        self.LogFileName = UNICODE_STRING()
        self.LogFilePattern = UNICODE_STRING()
        self.NewLogFileName = UNICODE_STRING()
        self.ClockType = v_uint32()
        self.LastFlushedBuffer = v_uint32()
        self.FlushTimer = v_uint32()
        self.FlushThreshold = v_uint32()
        self._pad0090 = v_bytes(size=4)
        self.ByteOffset = LARGE_INTEGER()
        self.MinimumBuffers = v_uint32()
        self.BuffersAvailable = v_uint32()
        self.NumberOfBuffers = v_uint32()
        self.MaximumBuffers = v_uint32()
        self.EventsLost = v_uint32()
        self.BuffersWritten = v_uint32()
        self.LogBuffersLost = v_uint32()
        self.RealTimeBuffersDelivered = v_uint32()
        self.RealTimeBuffersLost = v_uint32()
        self.SequencePtr = v_ptr32()
        self.LocalSequence = v_uint32()
        self.InstanceGuid = GUID()
        self.MaximumFileSize = v_uint32()
        self.FileCounter = v_uint32()
        self.PoolType = v_uint32()
        self.ReferenceTime = ETW_REF_CLOCK()
        self.CollectionOn = v_uint32()
        self.ProviderInfoSize = v_uint32()
        self.Consumers = LIST_ENTRY()
        self.NumConsumers = v_uint32()
        self.TransitionConsumer = v_ptr32()
        self.RealtimeLogfileHandle = v_ptr32()
        self.RealtimeLogfileName = UNICODE_STRING()
        self._pad0118 = v_bytes(size=4)
        self.RealtimeWriteOffset = LARGE_INTEGER()
        self.RealtimeReadOffset = LARGE_INTEGER()
        self.RealtimeLogfileSize = LARGE_INTEGER()
        self.RealtimeLogfileUsage = v_uint64()
        self.RealtimeMaximumFileSize = v_uint64()
        self.RealtimeBuffersSaved = v_uint32()
        self._pad0148 = v_bytes(size=4)
        self.RealtimeReferenceTime = ETW_REF_CLOCK()
        self.NewRTEventsLost = v_uint32()
        self.LoggerEvent = KEVENT()
        self.FlushEvent = KEVENT()
        self._pad0180 = v_bytes(size=4)
        self.FlushTimeOutTimer = KTIMER()
        self.LoggerDpc = KDPC()
        self.LoggerMutex = KMUTANT()
        self.LoggerLock = EX_PUSH_LOCK()
        self.BufferListSpinLock = v_uint32()
        self.ClientSecurityContext = SECURITY_CLIENT_CONTEXT()
        self.SecurityDescriptor = EX_FAST_REF()
        self.StartTime = LARGE_INTEGER()
        self.LogFileHandle = v_ptr32()
        self._pad0240 = v_bytes(size=4)
        self.BufferSequenceNumber = v_uint64()
        self.Flags = v_uint32()
        self.RequestFlag = v_uint32()
        self.HookIdMap = RTL_BITMAP()
        self.StackCache = v_ptr32()
        self.PmcData = v_ptr32()
        self.WinRtProviderBinaryList = LIST_ENTRY()
        self.ScratchArray = v_ptr32()
        self._pad0270 = v_bytes(size=4)


class THREAD_PERFORMANCE_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Size = v_uint16()
        self.Version = v_uint16()
        self.ProcessorNumber = PROCESSOR_NUMBER()
        self.ContextSwitches = v_uint32()
        self.HwCountersCount = v_uint32()
        self.UpdateCount = v_uint64()
        self.WaitReasonBitMap = v_uint64()
        self.HardwareCounters = v_uint64()
        self.CycleTime = COUNTER_READING()
        self.HwCounters = vstruct.VArray([ COUNTER_READING() for i in xrange(16) ])


class IO_STACK_LOCATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MajorFunction = v_uint8()
        self.MinorFunction = v_uint8()
        self.Flags = v_uint8()
        self.Control = v_uint8()
        self.Parameters = _unnamed_27770()
        self.DeviceObject = v_ptr32()
        self.FileObject = v_ptr32()
        self.CompletionRoutine = v_ptr32()
        self.Context = v_ptr32()


class DBGKD_READ_WRITE_MSR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Msr = v_uint32()
        self.DataValueLow = v_uint32()
        self.DataValueHigh = v_uint32()


class ARBITER_QUERY_CONFLICT_PARAMETERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PhysicalDeviceObject = v_ptr32()
        self.ConflictingResource = v_ptr32()
        self.ConflictCount = v_ptr32()
        self.Conflicts = v_ptr32()


class IMAGE_DATA_DIRECTORY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.VirtualAddress = v_uint32()
        self.Size = v_uint32()


class FILE_OBJECT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Size = v_uint16()
        self.DeviceObject = v_ptr32()
        self.Vpb = v_ptr32()
        self.FsContext = v_ptr32()
        self.FsContext2 = v_ptr32()
        self.SectionObjectPointer = v_ptr32()
        self.PrivateCacheMap = v_ptr32()
        self.FinalStatus = v_uint32()
        self.RelatedFileObject = v_ptr32()
        self.LockOperation = v_uint8()
        self.DeletePending = v_uint8()
        self.ReadAccess = v_uint8()
        self.WriteAccess = v_uint8()
        self.DeleteAccess = v_uint8()
        self.SharedRead = v_uint8()
        self.SharedWrite = v_uint8()
        self.SharedDelete = v_uint8()
        self.Flags = v_uint32()
        self.FileName = UNICODE_STRING()
        self.CurrentByteOffset = LARGE_INTEGER()
        self.Waiters = v_uint32()
        self.Busy = v_uint32()
        self.LastLock = v_ptr32()
        self.Lock = KEVENT()
        self.Event = KEVENT()
        self.CompletionContext = v_ptr32()
        self.IrpListLock = v_uint32()
        self.IrpList = LIST_ENTRY()
        self.FileObjectExtension = v_ptr32()


class PPM_IDLE_STATES(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ForceIdle = v_uint8()
        self.EstimateIdleDuration = v_uint8()
        self.ExitLatencyTraceEnabled = v_uint8()
        self._pad0004 = v_bytes(size=1)
        self.ExitLatencyCountdown = v_uint32()
        self.TargetState = v_uint32()
        self.ActualState = v_uint32()
        self.ActualPlatformState = v_uint32()
        self.OldState = v_uint32()
        self.OverrideIndex = v_uint32()
        self.PlatformIdleCount = v_uint32()
        self.ProcessorIdleCount = v_uint32()
        self.Type = v_uint32()
        self.ReasonFlags = v_uint32()
        self._pad0030 = v_bytes(size=4)
        self.InitiateWakeStamp = v_uint64()
        self.PreviousStatus = v_uint32()
        self.PrimaryProcessorMask = KAFFINITY_EX()
        self.SecondaryProcessorMask = KAFFINITY_EX()
        self.IdlePrepare = v_ptr32()
        self.IdleExecute = v_ptr32()
        self.IdleComplete = v_ptr32()
        self.IdleCancel = v_ptr32()
        self.IdleIsHalted = v_ptr32()
        self.IdleInitiateWake = v_ptr32()
        self._pad0070 = v_bytes(size=4)
        self.PrepareInfo = PROCESSOR_IDLE_PREPARE_INFO()
        self.State = vstruct.VArray([ PPM_IDLE_STATE() for i in xrange(1) ])


class MMPAGING_FILE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Size = v_uint32()
        self.MaximumSize = v_uint32()
        self.MinimumSize = v_uint32()
        self.FreeSpace = v_uint32()
        self.PeakUsage = v_uint32()
        self.HighestPage = v_uint32()
        self.FreeReservationSpace = v_uint32()
        self.LargestReserveCluster = v_uint32()
        self.File = v_ptr32()
        self.Entry = vstruct.VArray([ v_ptr32() for i in xrange(2) ])
        self.PageFileName = UNICODE_STRING()
        self.Bitmaps = v_ptr32()
        self.AllocationBitmapHint = v_uint32()
        self.ReservationBitmapHint = v_uint32()
        self.LargestNonReservedClusterSize = v_uint32()
        self.RefreshClusterSize = v_uint32()
        self.LastRefreshClusterSize = v_uint32()
        self.ReservedClusterSizeAggregate = v_uint32()
        self.ToBeEvictedCount = v_uint32()
        self.PageFileNumber = v_uint16()
        self.AdriftMdls = v_uint8()
        self.Spare2 = v_uint8()
        self.FileHandle = v_ptr32()
        self.Lock = v_uint32()
        self.LockOwner = v_ptr32()


class _unnamed_35986(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MissedEtwRegistration = v_uint32()


class IOV_IRP_TRACE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Irp = v_ptr32()
        self.Thread = v_ptr32()
        self.KernelApcDisable = v_uint16()
        self.SpecialApcDisable = v_uint16()
        self.Irql = v_uint8()
        self._pad0010 = v_bytes(size=3)
        self.StackTrace = vstruct.VArray([ v_ptr32() for i in xrange(12) ])


class WHEA_NOTIFICATION_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PollIntervalRW = v_uint16()


class LDR_SERVICE_TAG_RECORD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Next = v_ptr32()
        self.ServiceTag = v_uint32()


class _unnamed_34404(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PowerSettingGuid = GUID()
        self.Flags = v_uint32()
        self.SessionId = v_uint32()
        self.DataLength = v_uint32()
        self.Data = vstruct.VArray([ v_uint8() for i in xrange(1) ])
        self._pad0020 = v_bytes(size=3)


class SECTION_IMAGE_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TransferAddress = v_ptr32()
        self.ZeroBits = v_uint32()
        self.MaximumStackSize = v_uint32()
        self.CommittedStackSize = v_uint32()
        self.SubSystemType = v_uint32()
        self.SubSystemMinorVersion = v_uint16()
        self.SubSystemMajorVersion = v_uint16()
        self.GpValue = v_uint32()
        self.ImageCharacteristics = v_uint16()
        self.DllCharacteristics = v_uint16()
        self.Machine = v_uint16()
        self.ImageContainsCode = v_uint8()
        self.ImageFlags = v_uint8()
        self.LoaderFlags = v_uint32()
        self.ImageFileSize = v_uint32()
        self.CheckSum = v_uint32()


class KENLISTMENT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.cookie = v_uint32()
        self.NamespaceLink = KTMOBJECT_NAMESPACE_LINK()
        self.EnlistmentId = GUID()
        self.Mutex = KMUTANT()
        self.NextSameTx = LIST_ENTRY()
        self.NextSameRm = LIST_ENTRY()
        self.ResourceManager = v_ptr32()
        self.Transaction = v_ptr32()
        self.State = v_uint32()
        self.Flags = v_uint32()
        self.NotificationMask = v_uint32()
        self.Key = v_ptr32()
        self.KeyRefCount = v_uint32()
        self.RecoveryInformation = v_ptr32()
        self.RecoveryInformationLength = v_uint32()
        self.DynamicNameInformation = v_ptr32()
        self.DynamicNameInformationLength = v_uint32()
        self.FinalNotification = v_ptr32()
        self.SupSubEnlistment = v_ptr32()
        self.SupSubEnlHandle = v_ptr32()
        self.SubordinateTxHandle = v_ptr32()
        self.CrmEnlistmentEnId = GUID()
        self.CrmEnlistmentTmId = GUID()
        self.CrmEnlistmentRmId = GUID()
        self.NextHistory = v_uint32()
        self.History = vstruct.VArray([ KENLISTMENT_HISTORY() for i in xrange(20) ])


class STRING(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint16()
        self.MaximumLength = v_uint16()
        self.Buffer = v_ptr32()


class ERESOURCE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SystemResourcesList = LIST_ENTRY()
        self.OwnerTable = v_ptr32()
        self.ActiveCount = v_uint16()
        self.Flag = v_uint16()
        self.SharedWaiters = v_ptr32()
        self.ExclusiveWaiters = v_ptr32()
        self.OwnerEntry = OWNER_ENTRY()
        self.ActiveEntries = v_uint32()
        self.ContentionCount = v_uint32()
        self.NumberOfSharedWaiters = v_uint32()
        self.NumberOfExclusiveWaiters = v_uint32()
        self.Address = v_ptr32()
        self.SpinLock = v_uint32()


class SUBSECTION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ControlArea = v_ptr32()
        self.SubsectionBase = v_ptr32()
        self.NextSubsection = v_ptr32()
        self.PtesInSubsection = v_uint32()
        self.UnusedPtes = v_uint32()
        self.u = _unnamed_33507()
        self.StartingSector = v_uint32()
        self.NumberOfFullSectors = v_uint32()


class CM_WORKITEM(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self.Private = v_uint32()
        self.WorkerRoutine = v_ptr32()
        self.Parameter = v_ptr32()


class DBGKD_SET_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ContextFlags = v_uint32()


class LPCP_MESSAGE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Entry = LIST_ENTRY()
        self.SenderPort = v_ptr32()
        self.RepliedToThread = v_ptr32()
        self.PortContext = v_ptr32()
        self._pad0018 = v_bytes(size=4)
        self.Request = PORT_MESSAGE()


class _unnamed_34794(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.IdleTime = v_uint32()
        self.NonIdleTime = v_uint32()


class RTL_ATOM_TABLE_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.HashLink = v_ptr32()
        self.HandleIndex = v_uint16()
        self.Atom = v_uint16()
        self.Reference = RTL_ATOM_TABLE_REFERENCE()
        self.NameLength = v_uint8()
        self._pad001a = v_bytes(size=1)
        self.Name = vstruct.VArray([ v_uint16() for i in xrange(1) ])


class _unnamed_36524(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.idxRecord = v_uint32()
        self.cidContainer = v_uint32()


class TEB32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NtTib = NT_TIB32()
        self.EnvironmentPointer = v_uint32()
        self.ClientId = CLIENT_ID32()
        self.ActiveRpcHandle = v_uint32()
        self.ThreadLocalStoragePointer = v_uint32()
        self.ProcessEnvironmentBlock = v_uint32()
        self.LastErrorValue = v_uint32()
        self.CountOfOwnedCriticalSections = v_uint32()
        self.CsrClientThread = v_uint32()
        self.Win32ThreadInfo = v_uint32()
        self.User32Reserved = vstruct.VArray([ v_uint32() for i in xrange(26) ])
        self.UserReserved = vstruct.VArray([ v_uint32() for i in xrange(5) ])
        self.WOW32Reserved = v_uint32()
        self.CurrentLocale = v_uint32()
        self.FpSoftwareStatusRegister = v_uint32()
        self.SystemReserved1 = vstruct.VArray([ v_uint32() for i in xrange(54) ])
        self.ExceptionCode = v_uint32()
        self.ActivationContextStackPointer = v_uint32()
        self.SpareBytes = vstruct.VArray([ v_uint8() for i in xrange(36) ])
        self.TxFsContext = v_uint32()
        self.GdiTebBatch = GDI_TEB_BATCH32()
        self.RealClientId = CLIENT_ID32()
        self.GdiCachedProcessHandle = v_uint32()
        self.GdiClientPID = v_uint32()
        self.GdiClientTID = v_uint32()
        self.GdiThreadLocalInfo = v_uint32()
        self.Win32ClientInfo = vstruct.VArray([ v_uint32() for i in xrange(62) ])
        self.glDispatchTable = vstruct.VArray([ v_uint32() for i in xrange(233) ])
        self.glReserved1 = vstruct.VArray([ v_uint32() for i in xrange(29) ])
        self.glReserved2 = v_uint32()
        self.glSectionInfo = v_uint32()
        self.glSection = v_uint32()
        self.glTable = v_uint32()
        self.glCurrentRC = v_uint32()
        self.glContext = v_uint32()
        self.LastStatusValue = v_uint32()
        self.StaticUnicodeString = STRING32()
        self.StaticUnicodeBuffer = vstruct.VArray([ v_uint16() for i in xrange(261) ])
        self._pad0e0c = v_bytes(size=2)
        self.DeallocationStack = v_uint32()
        self.TlsSlots = vstruct.VArray([ v_uint32() for i in xrange(64) ])
        self.TlsLinks = LIST_ENTRY32()
        self.Vdm = v_uint32()
        self.ReservedForNtRpc = v_uint32()
        self.DbgSsReserved = vstruct.VArray([ v_uint32() for i in xrange(2) ])
        self.HardErrorMode = v_uint32()
        self.Instrumentation = vstruct.VArray([ v_uint32() for i in xrange(9) ])
        self.ActivityId = GUID()
        self.SubProcessTag = v_uint32()
        self.PerflibData = v_uint32()
        self.EtwTraceData = v_uint32()
        self.WinSockData = v_uint32()
        self.GdiBatchCount = v_uint32()
        self.CurrentIdealProcessor = PROCESSOR_NUMBER()
        self.GuaranteedStackBytes = v_uint32()
        self.ReservedForPerf = v_uint32()
        self.ReservedForOle = v_uint32()
        self.WaitingOnLoaderLock = v_uint32()
        self.SavedPriorityState = v_uint32()
        self.ReservedForCodeCoverage = v_uint32()
        self.ThreadPoolData = v_uint32()
        self.TlsExpansionSlots = v_uint32()
        self.MuiGeneration = v_uint32()
        self.IsImpersonating = v_uint32()
        self.NlsCache = v_uint32()
        self.pShimData = v_uint32()
        self.HeapVirtualAffinity = v_uint16()
        self.LowFragHeapDataSlot = v_uint16()
        self.CurrentTransactionHandle = v_uint32()
        self.ActiveFrame = v_uint32()
        self.FlsData = v_uint32()
        self.PreferredLanguages = v_uint32()
        self.UserPrefLanguages = v_uint32()
        self.MergedPrefLanguages = v_uint32()
        self.MuiImpersonation = v_uint32()
        self.CrossTebFlags = v_uint16()
        self.SameTebFlags = v_uint16()
        self.TxnScopeEnterCallback = v_uint32()
        self.TxnScopeExitCallback = v_uint32()
        self.TxnScopeContext = v_uint32()
        self.LockCount = v_uint32()
        self.SpareUlong0 = v_uint32()
        self.ResourceRetValue = v_uint32()
        self.ReservedForWdf = v_uint32()


class PROCESSOR_IDLE_DEPENDENCY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Processor = PROCESSOR_NUMBER()
        self.ExpectedState = v_uint8()
        self._pad0006 = v_bytes(size=1)


class PEB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.InheritedAddressSpace = v_uint8()
        self.ReadImageFileExecOptions = v_uint8()
        self.BeingDebugged = v_uint8()
        self.BitField = v_uint8()
        self.Mutant = v_ptr32()
        self.ImageBaseAddress = v_ptr32()
        self.Ldr = v_ptr32()
        self.ProcessParameters = v_ptr32()
        self.SubSystemData = v_ptr32()
        self.ProcessHeap = v_ptr32()
        self.FastPebLock = v_ptr32()
        self.AtlThunkSListPtr = v_ptr32()
        self.IFEOKey = v_ptr32()
        self.CrossProcessFlags = v_uint32()
        self.KernelCallbackTable = v_ptr32()
        self.SystemReserved = vstruct.VArray([ v_uint32() for i in xrange(1) ])
        self.AtlThunkSListPtr32 = v_uint32()
        self.ApiSetMap = v_ptr32()
        self.TlsExpansionCounter = v_uint32()
        self.TlsBitmap = v_ptr32()
        self.TlsBitmapBits = vstruct.VArray([ v_uint32() for i in xrange(2) ])
        self.ReadOnlySharedMemoryBase = v_ptr32()
        self.HotpatchInformation = v_ptr32()
        self.ReadOnlyStaticServerData = v_ptr32()
        self.AnsiCodePageData = v_ptr32()
        self.OemCodePageData = v_ptr32()
        self.UnicodeCaseTableData = v_ptr32()
        self.NumberOfProcessors = v_uint32()
        self.NtGlobalFlag = v_uint32()
        self._pad0070 = v_bytes(size=4)
        self.CriticalSectionTimeout = LARGE_INTEGER()
        self.HeapSegmentReserve = v_uint32()
        self.HeapSegmentCommit = v_uint32()
        self.HeapDeCommitTotalFreeThreshold = v_uint32()
        self.HeapDeCommitFreeBlockThreshold = v_uint32()
        self.NumberOfHeaps = v_uint32()
        self.MaximumNumberOfHeaps = v_uint32()
        self.ProcessHeaps = v_ptr32()
        self.GdiSharedHandleTable = v_ptr32()
        self.ProcessStarterHelper = v_ptr32()
        self.GdiDCAttributeList = v_uint32()
        self.LoaderLock = v_ptr32()
        self.OSMajorVersion = v_uint32()
        self.OSMinorVersion = v_uint32()
        self.OSBuildNumber = v_uint16()
        self.OSCSDVersion = v_uint16()
        self.OSPlatformId = v_uint32()
        self.ImageSubsystem = v_uint32()
        self.ImageSubsystemMajorVersion = v_uint32()
        self.ImageSubsystemMinorVersion = v_uint32()
        self.ActiveProcessAffinityMask = v_uint32()
        self.GdiHandleBuffer = vstruct.VArray([ v_uint32() for i in xrange(34) ])
        self.PostProcessInitRoutine = v_ptr32()
        self.TlsExpansionBitmap = v_ptr32()
        self.TlsExpansionBitmapBits = vstruct.VArray([ v_uint32() for i in xrange(32) ])
        self.SessionId = v_uint32()
        self.AppCompatFlags = ULARGE_INTEGER()
        self.AppCompatFlagsUser = ULARGE_INTEGER()
        self.pShimData = v_ptr32()
        self.AppCompatInfo = v_ptr32()
        self.CSDVersion = UNICODE_STRING()
        self.ActivationContextData = v_ptr32()
        self.ProcessAssemblyStorageMap = v_ptr32()
        self.SystemDefaultActivationContextData = v_ptr32()
        self.SystemAssemblyStorageMap = v_ptr32()
        self.MinimumStackCommit = v_uint32()
        self.FlsCallback = v_ptr32()
        self.FlsListHead = LIST_ENTRY()
        self.FlsBitmap = v_ptr32()
        self.FlsBitmapBits = vstruct.VArray([ v_uint32() for i in xrange(4) ])
        self.FlsHighIndex = v_uint32()
        self.WerRegistrationData = v_ptr32()
        self.WerShipAssertPtr = v_ptr32()
        self.pUnused = v_ptr32()
        self.pImageHeaderHash = v_ptr32()
        self.TracingFlags = v_uint32()
        self._pad0248 = v_bytes(size=4)
        self.CsrServerReadOnlySharedMemoryBase = v_uint64()


class WHEA_XPF_CMC_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Enabled = v_uint8()
        self.NumberOfBanks = v_uint8()
        self.Reserved = v_uint32()
        self.Notify = WHEA_NOTIFICATION_DESCRIPTOR()
        self.Banks = vstruct.VArray([ WHEA_XPF_MC_BANK_DESCRIPTOR() for i in xrange(32) ])


class KSCB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.GenerationCycles = v_uint64()
        self.UnderQuotaCycleTarget = v_uint64()
        self.RankCycleTarget = v_uint64()
        self.LongTermCycles = v_uint64()
        self.LastReportedCycles = v_uint64()
        self.OverQuotaHistory = v_uint64()
        self.PerProcessorList = LIST_ENTRY()
        self.QueueNode = RTL_BALANCED_NODE()
        self.Inserted = v_uint8()
        self.Spare2 = v_uint8()
        self.ReadySummary = v_uint16()
        self.Rank = v_uint32()
        self.ReadyListHead = vstruct.VArray([ LIST_ENTRY() for i in xrange(16) ])
        self._pad00d0 = v_bytes(size=4)


class DOCK_INTERFACE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Size = v_uint16()
        self.Version = v_uint16()
        self.Context = v_ptr32()
        self.InterfaceReference = v_ptr32()
        self.InterfaceDereference = v_ptr32()
        self.ProfileDepartureSetMode = v_ptr32()
        self.ProfileDepartureUpdate = v_ptr32()


class WHEA_AER_ROOTPORT_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Enabled = v_uint8()
        self.Reserved = v_uint8()
        self.BusNumber = v_uint32()
        self.Slot = WHEA_PCI_SLOT_NUMBER()
        self.DeviceControl = v_uint16()
        self.Flags = AER_ROOTPORT_DESCRIPTOR_FLAGS()
        self.UncorrectableErrorMask = v_uint32()
        self.UncorrectableErrorSeverity = v_uint32()
        self.CorrectableErrorMask = v_uint32()
        self.AdvancedCapsAndControl = v_uint32()
        self.RootErrorCommand = v_uint32()


class _unnamed_30920(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.s1 = _unnamed_30922()


class RTL_BALANCED_LINKS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Parent = v_ptr32()
        self.LeftChild = v_ptr32()
        self.RightChild = v_ptr32()
        self.Balance = v_uint8()
        self.Reserved = vstruct.VArray([ v_uint8() for i in xrange(3) ])


class MI_LARGEPAGE_MEMORY_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListHead = LIST_ENTRY()
        self.ColoredPageInfoBase = v_ptr32()
        self.PagesNeedZeroing = v_uint32()


class PROCESSOR_PROFILE_CONTROL_AREA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PebsDsSaveArea = PEBS_DS_SAVE_AREA()


class _unnamed_30479(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Reason = v_uint32()


class KENLISTMENT_HISTORY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Notification = v_uint32()
        self.NewState = v_uint32()


class XSTATE_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Mask = v_uint64()
        self.Length = v_uint32()
        self.Reserved1 = v_uint32()
        self.Area = v_ptr32()
        self.Reserved2 = v_uint32()
        self.Buffer = v_ptr32()
        self.Reserved3 = v_uint32()


class RSDS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint32()
        self.Guid = GUID()
        self.Age = v_uint32()
        self.PdbName = vstruct.VArray([ v_uint8() for i in xrange(1) ])
        self._pad001c = v_bytes(size=3)


class OBJECT_DIRECTORY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.HashBuckets = vstruct.VArray([ v_ptr32() for i in xrange(37) ])
        self.Lock = EX_PUSH_LOCK()
        self.DeviceMap = v_ptr32()
        self.SessionId = v_uint32()
        self.NamespaceEntry = v_ptr32()
        self.Flags = v_uint32()


class _unnamed_35044(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LongFlags = v_uint32()


class _unnamed_35045(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LongFlags1 = v_uint32()


class AER_ROOTPORT_DESCRIPTOR_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.UncorrectableErrorMaskRW = v_uint16()


class BLOB_COUNTERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CreatedObjects = v_uint32()
        self.DeletedObjects = v_uint32()


class ETW_STACK_CACHE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class MI_ACTIVE_WSLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flink = v_uint32()
        self.Blink = v_uint32()


class MMIO_TRACKER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self.PageFrameIndex = v_uint32()
        self.NumberOfPages = v_uint32()
        self.BaseVa = v_ptr32()
        self.Mdl = v_ptr32()
        self.MdlPages = v_uint32()
        self.StackTrace = vstruct.VArray([ v_ptr32() for i in xrange(6) ])
        self.CacheInfo = vstruct.VArray([ IO_CACHE_INFO() for i in xrange(1) ])
        self._pad0038 = v_bytes(size=3)


class XSAVE_AREA_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Mask = v_uint64()
        self.Reserved = vstruct.VArray([ v_uint64() for i in xrange(7) ])


class HEAP_SEGMENT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Entry = HEAP_ENTRY()
        self.SegmentSignature = v_uint32()
        self.SegmentFlags = v_uint32()
        self.SegmentListEntry = LIST_ENTRY()
        self.Heap = v_ptr32()
        self.BaseAddress = v_ptr32()
        self.NumberOfPages = v_uint32()
        self.FirstEntry = v_ptr32()
        self.LastValidEntry = v_ptr32()
        self.NumberOfUnCommittedPages = v_uint32()
        self.NumberOfUnCommittedRanges = v_uint32()
        self.SegmentAllocatorBackTraceIndex = v_uint16()
        self.Reserved = v_uint16()
        self.UCRSegmentList = LIST_ENTRY()


class _unnamed_34384(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ClassGuid = GUID()
        self.SymbolicLinkName = vstruct.VArray([ v_uint16() for i in xrange(1) ])
        self._pad0014 = v_bytes(size=2)


class HANDLE_TABLE_FREE_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.FreeListLock = EX_PUSH_LOCK()
        self.FirstFreeHandleEntry = v_ptr32()
        self.LastFreeHandleEntry = v_ptr32()
        self.HandleCount = v_uint32()
        self.HighWaterMark = v_uint32()
        self.Reserved = vstruct.VArray([ v_uint32() for i in xrange(8) ])


class WHEA_ERROR_RECORD_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint32()
        self.Revision = WHEA_REVISION()
        self.SignatureEnd = v_uint32()
        self.SectionCount = v_uint16()
        self.Severity = v_uint32()
        self.ValidBits = WHEA_ERROR_RECORD_HEADER_VALIDBITS()
        self.Length = v_uint32()
        self.Timestamp = WHEA_TIMESTAMP()
        self.PlatformId = GUID()
        self.PartitionId = GUID()
        self.CreatorId = GUID()
        self.NotifyType = GUID()
        self.RecordId = v_uint64()
        self.Flags = WHEA_ERROR_RECORD_HEADER_FLAGS()
        self.PersistenceInfo = WHEA_PERSISTENCE_INFO()
        self.Reserved = vstruct.VArray([ v_uint8() for i in xrange(12) ])


class SEP_LOWBOX_HANDLES_TABLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Lock = EX_PUSH_LOCK()
        self.HashTable = v_ptr32()


class ETW_SYSTEMTIME(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Year = v_uint16()
        self.Month = v_uint16()
        self.DayOfWeek = v_uint16()
        self.Day = v_uint16()
        self.Hour = v_uint16()
        self.Minute = v_uint16()
        self.Second = v_uint16()
        self.Milliseconds = v_uint16()


class _unnamed_28805(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flink = v_uint32()


class _unnamed_28806(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Blink = v_uint32()


class _unnamed_30473(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.FileObject = v_ptr32()


class _unnamed_34105(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MinimumChannel = v_uint32()
        self.MaximumChannel = v_uint32()


class _unnamed_34108(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.RequestLine = v_uint32()
        self.Reserved = v_uint32()
        self.Channel = v_uint32()
        self.TransferWidth = v_uint32()


class _unnamed_28808(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ReferenceCount = v_uint16()
        self.e1 = MMPFNENTRY()


class FLS_CALLBACK_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class _unnamed_36621(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Head = v_uint64()


class PPM_IDLE_SYNCHRONIZATION_STATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AsLong = v_uint32()


class MMSECURE_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ReadOnly = v_uint32()


class DBGKD_WRITE_MEMORY64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TargetBaseAddress = v_uint64()
        self.TransferCount = v_uint32()
        self.ActualBytesWritten = v_uint32()


class MI_TRIAGE_DUMP_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BadPageCount = v_uint32()
        self.BadPagesDetected = v_uint32()
        self.ZeroedPageSingleBitErrorsDetected = v_uint32()
        self.ScrubPasses = v_uint32()
        self.ScrubBadPagesFound = v_uint32()
        self.FeatureBits = v_uint32()
        self.TimeZoneId = v_uint32()


class OBJECT_HEADER_PADDING_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PaddingAmount = v_uint32()


class LIST_ENTRY64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flink = v_uint64()
        self.Blink = v_uint64()


class VACB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BaseAddress = v_ptr32()
        self.SharedCacheMap = v_ptr32()
        self.Overlay = _unnamed_30413()
        self.ArrayHead = v_ptr32()
        self._pad0018 = v_bytes(size=4)


class EXHANDLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TagBits = v_uint32()


class WAIT_CONTEXT_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.WaitQueueEntry = KDEVICE_QUEUE_ENTRY()
        self.DeviceRoutine = v_ptr32()
        self.DeviceContext = v_ptr32()
        self.NumberOfMapRegisters = v_uint32()
        self.DeviceObject = v_ptr32()
        self.CurrentIrp = v_ptr32()
        self.BufferChainingDpc = v_ptr32()


class CM_KEY_NODE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint16()
        self.Flags = v_uint16()
        self.LastWriteTime = LARGE_INTEGER()
        self.AccessBits = v_uint32()
        self.Parent = v_uint32()
        self.SubKeyCounts = vstruct.VArray([ v_uint32() for i in xrange(2) ])
        self.SubKeyLists = vstruct.VArray([ v_uint32() for i in xrange(2) ])
        self.ValueList = CHILD_LIST()
        self.Security = v_uint32()
        self.Class = v_uint32()
        self.MaxNameLen = v_uint32()
        self.MaxClassLen = v_uint32()
        self.MaxValueNameLen = v_uint32()
        self.MaxValueDataLen = v_uint32()
        self.WorkVar = v_uint32()
        self.NameLength = v_uint16()
        self.ClassLength = v_uint16()
        self.Name = vstruct.VArray([ v_uint16() for i in xrange(1) ])
        self._pad0050 = v_bytes(size=2)


class CM_KEY_VALUE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint16()
        self.NameLength = v_uint16()
        self.DataLength = v_uint32()
        self.Data = v_uint32()
        self.Type = v_uint32()
        self.Flags = v_uint16()
        self.Spare = v_uint16()
        self.Name = vstruct.VArray([ v_uint16() for i in xrange(1) ])
        self._pad0018 = v_bytes(size=2)


class _unnamed_32535(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BaseMid = v_uint32()


class PNP_PROVIDER_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self.ProviderType = v_uint8()
        self.Satisfied = v_uint8()
        self.Flags = v_uint16()
        self.u = _unnamed_34574()


class ACTIVATION_CONTEXT_STACK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ActiveFrame = v_ptr32()
        self.FrameListCache = LIST_ENTRY()
        self.Flags = v_uint32()
        self.NextCookieSequenceNumber = v_uint32()
        self.StackId = v_uint32()


class MI_PAGING_FILE_SPACE_BITMAPS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.RefCount = v_uint32()
        self.AllocationBitmap = RTL_BITMAP()
        self.ReservationBitmap = RTL_BITMAP()
        self.EvictStoreBitmap = v_ptr32()


class LDR_DATA_TABLE_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.InLoadOrderLinks = LIST_ENTRY()
        self.InMemoryOrderLinks = LIST_ENTRY()
        self.InInitializationOrderLinks = LIST_ENTRY()
        self.DllBase = v_ptr32()
        self.EntryPoint = v_ptr32()
        self.SizeOfImage = v_uint32()
        self.FullDllName = UNICODE_STRING()
        self.BaseDllName = UNICODE_STRING()
        self.FlagGroup = vstruct.VArray([ v_uint8() for i in xrange(4) ])
        self.ObsoleteLoadCount = v_uint16()
        self.TlsIndex = v_uint16()
        self.HashLinks = LIST_ENTRY()
        self.TimeDateStamp = v_uint32()
        self.EntryPointActivationContext = v_ptr32()
        self.PatchInformation = v_ptr32()
        self.DdagNode = v_ptr32()
        self.NodeModuleLink = LIST_ENTRY()
        self.SnapContext = v_ptr32()
        self.ParentDllBase = v_ptr32()
        self.SwitchBackContext = v_ptr32()
        self.BaseAddressIndexNode = RTL_BALANCED_NODE()
        self.MappingInfoIndexNode = RTL_BALANCED_NODE()
        self.OriginalBase = v_uint32()
        self._pad0088 = v_bytes(size=4)
        self.LoadTime = LARGE_INTEGER()
        self.BaseNameHashValue = v_uint32()
        self.LoadReason = v_uint32()


class SEP_AUDIT_POLICY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AdtTokenPolicy = TOKEN_AUDIT_POLICY()
        self.PolicySetStatus = v_uint8()


class TEB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NtTib = NT_TIB()
        self.EnvironmentPointer = v_ptr32()
        self.ClientId = CLIENT_ID()
        self.ActiveRpcHandle = v_ptr32()
        self.ThreadLocalStoragePointer = v_ptr32()
        self.ProcessEnvironmentBlock = v_ptr32()
        self.LastErrorValue = v_uint32()
        self.CountOfOwnedCriticalSections = v_uint32()
        self.CsrClientThread = v_ptr32()
        self.Win32ThreadInfo = v_ptr32()
        self.User32Reserved = vstruct.VArray([ v_uint32() for i in xrange(26) ])
        self.UserReserved = vstruct.VArray([ v_uint32() for i in xrange(5) ])
        self.WOW32Reserved = v_ptr32()
        self.CurrentLocale = v_uint32()
        self.FpSoftwareStatusRegister = v_uint32()
        self.SystemReserved1 = vstruct.VArray([ v_ptr32() for i in xrange(54) ])
        self.ExceptionCode = v_uint32()
        self.ActivationContextStackPointer = v_ptr32()
        self.SpareBytes = vstruct.VArray([ v_uint8() for i in xrange(36) ])
        self.TxFsContext = v_uint32()
        self.GdiTebBatch = GDI_TEB_BATCH()
        self.RealClientId = CLIENT_ID()
        self.GdiCachedProcessHandle = v_ptr32()
        self.GdiClientPID = v_uint32()
        self.GdiClientTID = v_uint32()
        self.GdiThreadLocalInfo = v_ptr32()
        self.Win32ClientInfo = vstruct.VArray([ v_uint32() for i in xrange(62) ])
        self.glDispatchTable = vstruct.VArray([ v_ptr32() for i in xrange(233) ])
        self.glReserved1 = vstruct.VArray([ v_uint32() for i in xrange(29) ])
        self.glReserved2 = v_ptr32()
        self.glSectionInfo = v_ptr32()
        self.glSection = v_ptr32()
        self.glTable = v_ptr32()
        self.glCurrentRC = v_ptr32()
        self.glContext = v_ptr32()
        self.LastStatusValue = v_uint32()
        self.StaticUnicodeString = UNICODE_STRING()
        self.StaticUnicodeBuffer = vstruct.VArray([ v_uint16() for i in xrange(261) ])
        self._pad0e0c = v_bytes(size=2)
        self.DeallocationStack = v_ptr32()
        self.TlsSlots = vstruct.VArray([ v_ptr32() for i in xrange(64) ])
        self.TlsLinks = LIST_ENTRY()
        self.Vdm = v_ptr32()
        self.ReservedForNtRpc = v_ptr32()
        self.DbgSsReserved = vstruct.VArray([ v_ptr32() for i in xrange(2) ])
        self.HardErrorMode = v_uint32()
        self.Instrumentation = vstruct.VArray([ v_ptr32() for i in xrange(9) ])
        self.ActivityId = GUID()
        self.SubProcessTag = v_ptr32()
        self.PerflibData = v_ptr32()
        self.EtwTraceData = v_ptr32()
        self.WinSockData = v_ptr32()
        self.GdiBatchCount = v_uint32()
        self.CurrentIdealProcessor = PROCESSOR_NUMBER()
        self.GuaranteedStackBytes = v_uint32()
        self.ReservedForPerf = v_ptr32()
        self.ReservedForOle = v_ptr32()
        self.WaitingOnLoaderLock = v_uint32()
        self.SavedPriorityState = v_ptr32()
        self.ReservedForCodeCoverage = v_uint32()
        self.ThreadPoolData = v_ptr32()
        self.TlsExpansionSlots = v_ptr32()
        self.MuiGeneration = v_uint32()
        self.IsImpersonating = v_uint32()
        self.NlsCache = v_ptr32()
        self.pShimData = v_ptr32()
        self.HeapVirtualAffinity = v_uint16()
        self.LowFragHeapDataSlot = v_uint16()
        self.CurrentTransactionHandle = v_ptr32()
        self.ActiveFrame = v_ptr32()
        self.FlsData = v_ptr32()
        self.PreferredLanguages = v_ptr32()
        self.UserPrefLanguages = v_ptr32()
        self.MergedPrefLanguages = v_ptr32()
        self.MuiImpersonation = v_uint32()
        self.CrossTebFlags = v_uint16()
        self.SameTebFlags = v_uint16()
        self.TxnScopeEnterCallback = v_ptr32()
        self.TxnScopeExitCallback = v_ptr32()
        self.TxnScopeContext = v_ptr32()
        self.LockCount = v_uint32()
        self.SpareUlong0 = v_uint32()
        self.ResourceRetValue = v_ptr32()
        self.ReservedForWdf = v_ptr32()


class EX_RUNDOWN_REF(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Count = v_uint32()


class POP_DEVICE_SYS_STATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.IrpMinor = v_uint8()
        self._pad0004 = v_bytes(size=3)
        self.SystemState = v_uint32()
        self.SpinLock = v_uint32()
        self.Thread = v_ptr32()
        self.AbortEvent = v_ptr32()
        self.ReadySemaphore = v_ptr32()
        self.FinishedSemaphore = v_ptr32()
        self.Order = PO_DEVICE_NOTIFY_ORDER()
        self.Pending = LIST_ENTRY()
        self.Status = v_uint32()
        self.FailedDevice = v_ptr32()
        self.Waking = v_uint8()
        self.Cancelled = v_uint8()
        self.IgnoreErrors = v_uint8()
        self.IgnoreNotImplemented = v_uint8()
        self.TimeRefreshLockAcquired = v_uint8()
        self._pad0104 = v_bytes(size=3)


class _unnamed_34035(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Polled = _unnamed_36885()
        self._pad0018 = v_bytes(size=20)


class AUTHZBASEP_SECURITY_ATTRIBUTES_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SecurityAttributeCount = v_uint32()
        self.SecurityAttributesList = LIST_ENTRY()
        self.WorkingSecurityAttributeCount = v_uint32()
        self.WorkingSecurityAttributesList = LIST_ENTRY()


class CM_BIG_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint16()
        self.Count = v_uint16()
        self.List = v_uint32()


class MMWSLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.u1 = _unnamed_28872()


class VI_POOL_PAGE_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NextPage = v_ptr32()
        self.VerifierEntry = v_ptr32()
        self.Signature = v_uint32()


class PO_DIAG_STACK_RECORD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.StackDepth = v_uint32()
        self.Stack = vstruct.VArray([ v_ptr32() for i in xrange(1) ])


class IMAGE_DOS_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.e_magic = v_uint16()
        self.e_cblp = v_uint16()
        self.e_cp = v_uint16()
        self.e_crlc = v_uint16()
        self.e_cparhdr = v_uint16()
        self.e_minalloc = v_uint16()
        self.e_maxalloc = v_uint16()
        self.e_ss = v_uint16()
        self.e_sp = v_uint16()
        self.e_csum = v_uint16()
        self.e_ip = v_uint16()
        self.e_cs = v_uint16()
        self.e_lfarlc = v_uint16()
        self.e_ovno = v_uint16()
        self.e_res = vstruct.VArray([ v_uint16() for i in xrange(4) ])
        self.e_oemid = v_uint16()
        self.e_oeminfo = v_uint16()
        self.e_res2 = vstruct.VArray([ v_uint16() for i in xrange(10) ])
        self.e_lfanew = v_uint32()


class WHEA_AER_BRIDGE_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Enabled = v_uint8()
        self.Reserved = v_uint8()
        self.BusNumber = v_uint32()
        self.Slot = WHEA_PCI_SLOT_NUMBER()
        self.DeviceControl = v_uint16()
        self.Flags = AER_BRIDGE_DESCRIPTOR_FLAGS()
        self.UncorrectableErrorMask = v_uint32()
        self.UncorrectableErrorSeverity = v_uint32()
        self.CorrectableErrorMask = v_uint32()
        self.AdvancedCapsAndControl = v_uint32()
        self.SecondaryUncorrectableErrorMask = v_uint32()
        self.SecondaryUncorrectableErrorSev = v_uint32()
        self.SecondaryCapsAndControl = v_uint32()


class DBGKD_FILL_MEMORY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Address = v_uint64()
        self.Length = v_uint32()
        self.Flags = v_uint16()
        self.PatternLength = v_uint16()


class CM_KEY_SECURITY_CACHE_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Cell = v_uint32()
        self.CachedSecurity = v_ptr32()


class MM_AVL_NODE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.u1 = _unnamed_34368()
        self.LeftChild = v_ptr32()
        self.RightChild = v_ptr32()


class SESSION_LOWBOX_MAP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self.SessionId = v_uint32()
        self.LowboxMap = SEP_LOWBOX_NUMBER_MAPPING()


class _unnamed_34744(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CellData = CELL_DATA()


class EX_PUSH_LOCK_CACHE_AWARE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Locks = vstruct.VArray([ v_ptr32() for i in xrange(32) ])


class ARBITER_ORDERING(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Start = v_uint64()
        self.End = v_uint64()


class MMVIEW(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PteOffset = v_uint64()
        self.Entry = v_uint32()
        self.u1 = MMVIEW_CONTROL_AREA()
        self.ViewLinks = LIST_ENTRY()
        self.SessionViewVa = v_ptr32()
        self.SessionId = v_uint32()
        self.SessionIdForGlobalSubsections = v_uint32()
        self._pad0028 = v_bytes(size=4)


class _unnamed_34193(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint32()


class ETW_GUID_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.GuidList = LIST_ENTRY()
        self.RefCount = v_uint32()
        self.Guid = GUID()
        self.RegListHead = LIST_ENTRY()
        self.SecurityDescriptor = v_ptr32()
        self.LastEnable = ETW_LAST_ENABLE_INFO()
        self.ProviderEnableInfo = TRACE_ENABLE_INFO()
        self.EnableInfo = vstruct.VArray([ TRACE_ENABLE_INFO() for i in xrange(8) ])
        self.FilterData = v_ptr32()
        self._pad0160 = v_bytes(size=4)


class WMI_BUFFER_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BufferSize = v_uint32()
        self.SavedOffset = v_uint32()
        self.CurrentOffset = v_uint32()
        self.ReferenceCount = v_uint32()
        self.TimeStamp = LARGE_INTEGER()
        self.SequenceNumber = v_uint64()
        self.ClockType = v_uint64()
        self.ClientContext = ETW_BUFFER_CONTEXT()
        self.State = v_uint32()
        self.Offset = v_uint32()
        self.BufferFlag = v_uint16()
        self.BufferType = v_uint16()
        self.Padding1 = vstruct.VArray([ v_uint32() for i in xrange(4) ])


class QUAD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.UseThisFieldToCopy = v_uint64()


class OBJECT_HANDLE_COUNT_DATABASE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CountEntries = v_uint32()
        self.HandleCountEntries = vstruct.VArray([ OBJECT_HANDLE_COUNT_ENTRY() for i in xrange(1) ])


class MMWSLE_HASH(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Index = v_uint32()


class PROC_PERF_SNAP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Time = v_uint64()
        self.LastTime = v_uint64()
        self.Active = v_uint64()
        self.LastActive = v_uint64()
        self.FrequencyScaledActive = v_uint64()
        self.PerformanceScaledActive = v_uint64()
        self.CyclesActive = v_uint64()
        self.CyclesAffinitized = v_uint64()


class _unnamed_35941(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AsUSHORT = v_uint16()


class HEAP_TUNING_PARAMETERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CommittThresholdShift = v_uint32()
        self.MaxPreCommittThreshold = v_uint32()


class _unnamed_30755(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.DataInfoOffset = v_uint16()


class LPCP_PORT_OBJECT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ConnectionPort = v_ptr32()
        self.ConnectedPort = v_ptr32()
        self.MsgQueue = LPCP_PORT_QUEUE()
        self.Creator = CLIENT_ID()
        self.ClientSectionBase = v_ptr32()
        self.ServerSectionBase = v_ptr32()
        self.PortContext = v_ptr32()
        self.ClientThread = v_ptr32()
        self.SecurityQos = SECURITY_QUALITY_OF_SERVICE()
        self.StaticSecurity = SECURITY_CLIENT_CONTEXT()
        self.LpcReplyChainHead = LIST_ENTRY()
        self.LpcDataInfoChainHead = LIST_ENTRY()
        self.ServerProcess = v_ptr32()
        self.MaxMessageLength = v_uint16()
        self.MaxConnectionInfoLength = v_uint16()
        self.Flags = v_uint32()
        self.WaitEvent = KEVENT()


class WHEA_XPF_MCE_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Enabled = v_uint8()
        self.NumberOfBanks = v_uint8()
        self.Flags = XPF_MCE_FLAGS()
        self.MCG_Capability = v_uint64()
        self.MCG_GlobalControl = v_uint64()
        self.Banks = vstruct.VArray([ WHEA_XPF_MC_BANK_DESCRIPTOR() for i in xrange(32) ])


class EVENT_FILTER_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Ptr = v_uint64()
        self.Size = v_uint32()
        self.Type = v_uint32()


class _unnamed_30750(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DataLength = v_uint16()
        self.TotalLength = v_uint16()


class CALL_PERFORMANCE_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SpinLock = v_uint32()
        self.HashTable = vstruct.VArray([ LIST_ENTRY() for i in xrange(64) ])


class KPRCB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MinorVersion = v_uint16()
        self.MajorVersion = v_uint16()
        self.CurrentThread = v_ptr32()
        self.NextThread = v_ptr32()
        self.IdleThread = v_ptr32()
        self.LegacyNumber = v_uint8()
        self.NestingLevel = v_uint8()
        self.BuildType = v_uint16()
        self.CpuType = v_uint8()
        self.CpuID = v_uint8()
        self.CpuStep = v_uint16()
        self.ProcessorState = KPROCESSOR_STATE()
        self.KernelReserved = vstruct.VArray([ v_uint32() for i in xrange(16) ])
        self.HalReserved = vstruct.VArray([ v_uint32() for i in xrange(16) ])
        self.CFlushSize = v_uint32()
        self.CoresPerPhysicalProcessor = v_uint8()
        self.LogicalProcessorsPerCore = v_uint8()
        self.PrcbPad0 = vstruct.VArray([ v_uint8() for i in xrange(2) ])
        self.MHz = v_uint32()
        self.CpuVendor = v_uint8()
        self.GroupIndex = v_uint8()
        self.Group = v_uint16()
        self.GroupSetMember = v_uint32()
        self.Number = v_uint32()
        self.ClockOwner = v_uint8()
        self.PendingTick = v_uint8()
        self.PrcbPad1 = vstruct.VArray([ v_uint8() for i in xrange(70) ])
        self.LockQueue = vstruct.VArray([ KSPIN_LOCK_QUEUE() for i in xrange(17) ])
        self.NpxThread = v_ptr32()
        self.InterruptCount = v_uint32()
        self.KernelTime = v_uint32()
        self.UserTime = v_uint32()
        self.DpcTime = v_uint32()
        self.DpcTimeCount = v_uint32()
        self.InterruptTime = v_uint32()
        self.AdjustDpcThreshold = v_uint32()
        self.PageColor = v_uint32()
        self.DebuggerSavedIRQL = v_uint8()
        self.NodeColor = v_uint8()
        self.PrcbPad20 = vstruct.VArray([ v_uint8() for i in xrange(2) ])
        self.NodeShiftedColor = v_uint32()
        self.ParentNode = v_ptr32()
        self.SecondaryColorMask = v_uint32()
        self.DpcTimeLimit = v_uint32()
        self.PrcbPad21 = vstruct.VArray([ v_uint32() for i in xrange(2) ])
        self.CcFastReadNoWait = v_uint32()
        self.CcFastReadWait = v_uint32()
        self.CcFastReadNotPossible = v_uint32()
        self.CcCopyReadNoWait = v_uint32()
        self.CcCopyReadWait = v_uint32()
        self.CcCopyReadNoWaitMiss = v_uint32()
        self.MmSpinLockOrdering = v_uint32()
        self.IoReadOperationCount = v_uint32()
        self.IoWriteOperationCount = v_uint32()
        self.IoOtherOperationCount = v_uint32()
        self.IoReadTransferCount = LARGE_INTEGER()
        self.IoWriteTransferCount = LARGE_INTEGER()
        self.IoOtherTransferCount = LARGE_INTEGER()
        self.CcFastMdlReadNoWait = v_uint32()
        self.CcFastMdlReadWait = v_uint32()
        self.CcFastMdlReadNotPossible = v_uint32()
        self.CcMapDataNoWait = v_uint32()
        self.CcMapDataWait = v_uint32()
        self.CcPinMappedDataCount = v_uint32()
        self.CcPinReadNoWait = v_uint32()
        self.CcPinReadWait = v_uint32()
        self.CcMdlReadNoWait = v_uint32()
        self.CcMdlReadWait = v_uint32()
        self.CcLazyWriteHotSpots = v_uint32()
        self.CcLazyWriteIos = v_uint32()
        self.CcLazyWritePages = v_uint32()
        self.CcDataFlushes = v_uint32()
        self.CcDataPages = v_uint32()
        self.CcLostDelayedWrites = v_uint32()
        self.CcFastReadResourceMiss = v_uint32()
        self.CcCopyReadWaitMiss = v_uint32()
        self.CcFastMdlReadResourceMiss = v_uint32()
        self.CcMapDataNoWaitMiss = v_uint32()
        self.CcMapDataWaitMiss = v_uint32()
        self.CcPinReadNoWaitMiss = v_uint32()
        self.CcPinReadWaitMiss = v_uint32()
        self.CcMdlReadNoWaitMiss = v_uint32()
        self.CcMdlReadWaitMiss = v_uint32()
        self.CcReadAheadIos = v_uint32()
        self.KeAlignmentFixupCount = v_uint32()
        self.KeExceptionDispatchCount = v_uint32()
        self.KeSystemCalls = v_uint32()
        self.AvailableTime = v_uint32()
        self.PrcbPad22 = vstruct.VArray([ v_uint32() for i in xrange(2) ])
        self.PPLookasideList = vstruct.VArray([ PP_LOOKASIDE_LIST() for i in xrange(16) ])
        self.PPNxPagedLookasideList = vstruct.VArray([ GENERAL_LOOKASIDE_POOL() for i in xrange(32) ])
        self.PPNPagedLookasideList = vstruct.VArray([ GENERAL_LOOKASIDE_POOL() for i in xrange(32) ])
        self.PPPagedLookasideList = vstruct.VArray([ GENERAL_LOOKASIDE_POOL() for i in xrange(32) ])
        self.PacketBarrier = v_uint32()
        self.ReverseStall = v_uint32()
        self.IpiFrame = v_ptr32()
        self.PrcbPad3 = vstruct.VArray([ v_uint8() for i in xrange(52) ])
        self.CurrentPacket = vstruct.VArray([ v_ptr32() for i in xrange(3) ])
        self.TargetSet = v_uint32()
        self.WorkerRoutine = v_ptr32()
        self.IpiFrozen = v_uint32()
        self.PrcbPad4 = vstruct.VArray([ v_uint8() for i in xrange(40) ])
        self.RequestSummary = v_uint32()
        self.SignalDone = v_ptr32()
        self.PrcbPad50 = vstruct.VArray([ v_uint8() for i in xrange(48) ])
        self.InterruptLastCount = v_uint32()
        self.InterruptRate = v_uint32()
        self.DpcData = vstruct.VArray([ KDPC_DATA() for i in xrange(2) ])
        self.DpcStack = v_ptr32()
        self.MaximumDpcQueueDepth = v_uint32()
        self.DpcRequestRate = v_uint32()
        self.MinimumDpcRate = v_uint32()
        self.DpcLastCount = v_uint32()
        self.PrcbLock = v_uint32()
        self.DpcGate = KGATE()
        self.ThreadDpcEnable = v_uint8()
        self.QuantumEnd = v_uint8()
        self.DpcRoutineActive = v_uint8()
        self.IdleSchedule = v_uint8()
        self.DpcRequestSummary = v_uint32()
        self.LastTimerHand = v_uint32()
        self.LastTick = v_uint32()
        self.PeriodicCount = v_uint32()
        self.PeriodicBias = v_uint32()
        self.ClockInterrupts = v_uint32()
        self.ReadyScanTick = v_uint32()
        self.BalanceState = v_uint8()
        self.GroupSchedulingOverQuota = v_uint8()
        self.PrcbPad41 = vstruct.VArray([ v_uint8() for i in xrange(10) ])
        self._pad2260 = v_bytes(size=4)
        self.TimerTable = KTIMER_TABLE()
        self.CallDpc = KDPC()
        self.ClockKeepAlive = v_uint32()
        self.PrcbPad6 = vstruct.VArray([ v_uint8() for i in xrange(4) ])
        self.DpcWatchdogPeriod = v_uint32()
        self.DpcWatchdogCount = v_uint32()
        self.KeSpinLockOrdering = v_uint32()
        self.PrcbPad70 = vstruct.VArray([ v_uint32() for i in xrange(1) ])
        self.QueueIndex = v_uint32()
        self.DeferredReadyListHead = SINGLE_LIST_ENTRY()
        self.WaitListHead = LIST_ENTRY()
        self.WaitLock = v_uint32()
        self.ReadySummary = v_uint32()
        self.ReadyQueueWeight = v_uint32()
        self.BuddyPrcb = v_ptr32()
        self.StartCycles = v_uint64()
        self.GenerationTarget = v_uint64()
        self.CycleTime = v_uint64()
        self.HighCycleTime = v_uint32()
        self.ScbOffset = v_uint32()
        self.AffinitizedCycles = v_uint64()
        self.DispatcherReadyListHead = vstruct.VArray([ LIST_ENTRY() for i in xrange(32) ])
        self.ChainedInterruptList = v_ptr32()
        self.LookasideIrpFloat = v_uint32()
        self.ScbQueue = RTL_RB_TREE()
        self.ScbList = LIST_ENTRY()
        self.MmPageFaultCount = v_uint32()
        self.MmCopyOnWriteCount = v_uint32()
        self.MmTransitionCount = v_uint32()
        self.MmCacheTransitionCount = v_uint32()
        self.MmDemandZeroCount = v_uint32()
        self.MmPageReadCount = v_uint32()
        self.MmPageReadIoCount = v_uint32()
        self.MmCacheReadCount = v_uint32()
        self.MmCacheIoCount = v_uint32()
        self.MmDirtyPagesWriteCount = v_uint32()
        self.MmDirtyWriteIoCount = v_uint32()
        self.MmMappedPagesWriteCount = v_uint32()
        self.MmMappedWriteIoCount = v_uint32()
        self.CachedCommit = v_uint32()
        self.CachedResidentAvailable = v_uint32()
        self.HyperPte = v_ptr32()
        self.PrcbPad8 = vstruct.VArray([ v_uint8() for i in xrange(4) ])
        self.VendorString = vstruct.VArray([ v_uint8() for i in xrange(13) ])
        self.InitialApicId = v_uint8()
        self.LogicalProcessorsPerPhysicalProcessor = v_uint8()
        self.PrcbPad9 = vstruct.VArray([ v_uint8() for i in xrange(5) ])
        self.FeatureBits = v_uint32()
        self._pad3c98 = v_bytes(size=4)
        self.UpdateSignature = LARGE_INTEGER()
        self.IsrTime = v_uint64()
        self.Stride = v_uint32()
        self.PrcbPad90 = v_uint32()
        self.PowerState = PROCESSOR_POWER_STATE()
        self.PrcbPad91 = vstruct.VArray([ v_uint32() for i in xrange(1) ])
        self.DpcWatchdogDpc = KDPC()
        self._pad3e58 = v_bytes(size=4)
        self.DpcWatchdogTimer = KTIMER()
        self.HypercallPageList = SLIST_HEADER()
        self.HypercallPageVirtual = v_ptr32()
        self.VirtualApicAssist = v_ptr32()
        self.StatisticsPage = v_ptr32()
        self.Cache = vstruct.VArray([ CACHE_DESCRIPTOR() for i in xrange(5) ])
        self.CacheCount = v_uint32()
        self.PackageProcessorSet = KAFFINITY_EX()
        self.CacheProcessorMask = vstruct.VArray([ v_uint32() for i in xrange(5) ])
        self.ScanSiblingMask = v_uint32()
        self.CoreProcessorSet = v_uint32()
        self.ScanSiblingIndex = v_uint32()
        self.LLCLevel = v_uint32()
        self.WheaInfo = v_ptr32()
        self.EtwSupport = v_ptr32()
        self._pad3f10 = v_bytes(size=4)
        self.InterruptObjectPool = SLIST_HEADER()
        self.PrcbPad92 = vstruct.VArray([ v_uint32() for i in xrange(8) ])
        self.ProcessorProfileControlArea = v_ptr32()
        self.ProfileEventIndexAddress = v_ptr32()
        self.TimerExpirationDpc = KDPC()
        self.SynchCounters = SYNCH_COUNTERS()
        self.FsCounters = FILESYSTEM_DISK_COUNTERS()
        self.Context = v_ptr32()
        self.ContextFlagsInit = v_uint32()
        self.ExtendedState = v_ptr32()
        self.EntropyTimingState = KENTROPY_TIMING_STATE()
        self._pad4160 = v_bytes(size=4)


class EXCEPTION_POINTERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ExceptionRecord = v_ptr32()
        self.ContextRecord = v_ptr32()


class PPM_FFH_THROTTLE_STATE_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.EnableLogging = v_uint8()
        self._pad0004 = v_bytes(size=3)
        self.MismatchCount = v_uint32()
        self.Initialized = v_uint8()
        self._pad0010 = v_bytes(size=7)
        self.LastValue = v_uint64()
        self.LastLogTickCount = LARGE_INTEGER()


class WHEA_XPF_NMI_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Enabled = v_uint8()


class PCW_REGISTRATION_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Version = v_uint32()
        self.Name = v_ptr32()
        self.CounterCount = v_uint32()
        self.Counters = v_ptr32()
        self.Callback = v_ptr32()
        self.CallbackContext = v_ptr32()


class IO_REMOVE_LOCK_COMMON_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Removed = v_uint8()
        self.Reserved = vstruct.VArray([ v_uint8() for i in xrange(3) ])
        self.IoCount = v_uint32()
        self.RemoveEvent = KEVENT()


class IO_CACHE_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CacheAttribute = v_uint8()


class POP_TRIGGER_WAIT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Event = KEVENT()
        self.Status = v_uint32()
        self.Link = LIST_ENTRY()
        self.Trigger = v_ptr32()


class KAFFINITY_EX(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Count = v_uint16()
        self.Size = v_uint16()
        self.Reserved = v_uint32()
        self.Bitmap = vstruct.VArray([ v_uint32() for i in xrange(1) ])


class ETW_WMITRACE_WORK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LoggerId = v_uint32()
        self.SpareUlong = v_uint32()
        self.LoggerName = vstruct.VArray([ v_uint8() for i in xrange(65) ])
        self.FileName = vstruct.VArray([ v_uint8() for i in xrange(129) ])
        self._pad00cc = v_bytes(size=2)
        self.MaximumFileSize = v_uint32()
        self.MinBuffers = v_uint32()
        self.MaxBuffers = v_uint32()
        self.BufferSize = v_uint32()
        self.Mode = v_uint32()
        self.FlushTimer = v_uint32()
        self._pad00e8 = v_bytes(size=4)
        self.Status = v_uint32()
        self._pad00f0 = v_bytes(size=4)


class PROVIDER_BINARY_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self.ConsumersNotified = v_uint8()
        self.Spare = vstruct.VArray([ v_uint8() for i in xrange(3) ])
        self.DebugIdSize = v_uint32()
        self.DebugId = CVDD()


class MMVIEW_CONTROL_AREA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ControlArea = v_ptr32()


class _unnamed_30885(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Internal = v_uint32()


class KSEMAPHORE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Header = DISPATCHER_HEADER()
        self.Limit = v_uint32()


class _unnamed_28974(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.e2 = _unnamed_29028()


class _unnamed_28971(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LongFlags = v_uint32()


class KALPC_HANDLE_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flags = v_uint32()
        self.ObjectType = v_uint32()
        self.DuplicateContext = v_ptr32()


class _unnamed_35666(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LongFlags2 = v_uint32()


class CM_CACHED_VALUE_INDEX(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CellIndex = v_uint32()
        self.Data = _unnamed_34744()


class _unnamed_34363(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flags = _unnamed_35986()


class _unnamed_30806(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ReferenceCache = v_uint8()


class LOG_HANDLE_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LogHandle = v_ptr32()
        self.FlushToLsnRoutine = v_ptr32()
        self.QueryLogHandleInfoRoutine = v_ptr32()
        self.DirtyPageStatistics = DIRTY_PAGE_STATISTICS()
        self.DirtyPageThresholds = DIRTY_PAGE_THRESHOLDS()
        self.AdditionalPagesToWrite = v_uint32()
        self.CcLWScanDPThreshold = v_uint32()
        self.LargestLsnForCurrentLWScan = LARGE_INTEGER()
        self.RelatedFileObject = v_ptr32()
        self.LargestLsnFileObjectKey = v_uint32()
        self.LastLWTimeStamp = LARGE_INTEGER()
        self.Flags = v_uint32()
        self._pad0050 = v_bytes(size=4)


class _unnamed_35669(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SequentialVa = MI_VAD_SEQUENTIAL_INFO()


class _unnamed_34699(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Start = LARGE_INTEGER()
        self.Length64 = v_uint32()


class PCW_COUNTER_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CounterMask = v_uint64()
        self.InstanceMask = v_ptr32()
        self._pad0010 = v_bytes(size=4)


class _unnamed_34693(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Start = LARGE_INTEGER()
        self.Length40 = v_uint32()


class MI_SECTION_IMAGE_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ExportedImageInformation = SECTION_IMAGE_INFORMATION()
        self.InternalImageInformation = MI_EXTRA_IMAGE_INFORMATION()


class _unnamed_34696(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Start = LARGE_INTEGER()
        self.Length48 = v_uint32()


class _unnamed_34400(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BlockedDriverGuid = GUID()


class DBGKD_WRITE_BREAKPOINT32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BreakPointAddress = v_uint32()
        self.BreakPointHandle = v_uint32()


class DBGKD_BREAKPOINTEX(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BreakPointCount = v_uint32()
        self.ContinueStatus = v_uint32()


class _unnamed_28035(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint32()


class IMAGE_NT_HEADERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint32()
        self.FileHeader = IMAGE_FILE_HEADER()
        self.OptionalHeader = IMAGE_OPTIONAL_HEADER()


class _unnamed_34402(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ParentId = vstruct.VArray([ v_uint16() for i in xrange(1) ])


class ETW_REPLY_QUEUE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Queue = KQUEUE()
        self.EventsLost = v_uint32()


class OBJECT_TYPE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TypeList = LIST_ENTRY()
        self.Name = UNICODE_STRING()
        self.DefaultObject = v_ptr32()
        self.Index = v_uint8()
        self._pad0018 = v_bytes(size=3)
        self.TotalNumberOfObjects = v_uint32()
        self.TotalNumberOfHandles = v_uint32()
        self.HighWaterNumberOfObjects = v_uint32()
        self.HighWaterNumberOfHandles = v_uint32()
        self.TypeInfo = OBJECT_TYPE_INITIALIZER()
        self.TypeLock = EX_PUSH_LOCK()
        self.Key = v_uint32()
        self.CallbackList = LIST_ENTRY()


class ALPC_MESSAGE_ZONE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Mdl = v_ptr32()
        self.UserVa = v_ptr32()
        self.UserLimit = v_ptr32()
        self.SystemVa = v_ptr32()
        self.SystemLimit = v_ptr32()
        self.Size = v_uint32()


class KNODE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DeepIdleSet = v_uint32()
        self._pad0040 = v_bytes(size=60)
        self.ProximityId = v_uint32()
        self.NodeNumber = v_uint16()
        self.PrimaryNodeNumber = v_uint16()
        self.MaximumProcessors = v_uint8()
        self.Flags = flags()
        self.Stride = v_uint8()
        self.NodePad0 = v_uint8()
        self.Affinity = GROUP_AFFINITY()
        self.IdleCpuSet = v_uint32()
        self.IdleSmtSet = v_uint32()
        self._pad0080 = v_bytes(size=32)
        self.Seed = v_uint32()
        self.Lowest = v_uint32()
        self.Highest = v_uint32()
        self.ParkLock = v_uint32()
        self.NonParkedSet = v_uint32()
        self._pad00c0 = v_bytes(size=44)


class PRIVILEGE_SET(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PrivilegeCount = v_uint32()
        self.Control = v_uint32()
        self.Privilege = vstruct.VArray([ LUID_AND_ATTRIBUTES() for i in xrange(1) ])


class ALPC_HANDLE_TABLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Handles = v_ptr32()
        self.TotalHandles = v_uint32()
        self.Flags = v_uint32()
        self.Lock = EX_PUSH_LOCK()


class _unnamed_27736(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Overlay = _unnamed_27809()
        self._pad0030 = v_bytes(size=4)


class CM_KEY_HASH_TABLE_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Lock = EX_PUSH_LOCK()
        self.Owner = v_ptr32()
        self.Entry = v_ptr32()


class HMAP_DIRECTORY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Directory = vstruct.VArray([ v_ptr32() for i in xrange(1024) ])


class IO_WORKITEM(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.WorkItem = WORK_QUEUE_ITEM()
        self.Routine = v_ptr32()
        self.IoObject = v_ptr32()
        self.Context = v_ptr32()
        self.Type = v_uint32()
        self.ActivityId = GUID()


class RTL_DYNAMIC_HASH_TABLE_ENUMERATOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.HashEntry = RTL_DYNAMIC_HASH_TABLE_ENTRY()
        self.ChainHead = v_ptr32()
        self.BucketIndex = v_uint32()


class SYSTEM_POWER_CAPABILITIES(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PowerButtonPresent = v_uint8()
        self.SleepButtonPresent = v_uint8()
        self.LidPresent = v_uint8()
        self.SystemS1 = v_uint8()
        self.SystemS2 = v_uint8()
        self.SystemS3 = v_uint8()
        self.SystemS4 = v_uint8()
        self.SystemS5 = v_uint8()
        self.HiberFilePresent = v_uint8()
        self.FullWake = v_uint8()
        self.VideoDimPresent = v_uint8()
        self.ApmPresent = v_uint8()
        self.UpsPresent = v_uint8()
        self.ThermalControl = v_uint8()
        self.ProcessorThrottle = v_uint8()
        self.ProcessorMinThrottle = v_uint8()
        self.ProcessorMaxThrottle = v_uint8()
        self.FastSystemS4 = v_uint8()
        self.Hiberboot = v_uint8()
        self.WakeAlarmPresent = v_uint8()
        self.AoAc = v_uint8()
        self.DiskSpinDown = v_uint8()
        self.spare3 = vstruct.VArray([ v_uint8() for i in xrange(8) ])
        self.SystemBatteriesPresent = v_uint8()
        self.BatteriesAreShortTerm = v_uint8()
        self.BatteryScale = vstruct.VArray([ BATTERY_REPORTING_SCALE() for i in xrange(3) ])
        self.AcOnLineWake = v_uint32()
        self.SoftLidWake = v_uint32()
        self.RtcWake = v_uint32()
        self.MinDeviceWakeState = v_uint32()
        self.DefaultLowLatencyWake = v_uint32()


class THERMAL_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ThermalStamp = v_uint32()
        self.ThermalConstant1 = v_uint32()
        self.ThermalConstant2 = v_uint32()
        self.Processors = v_uint32()
        self.SamplingPeriod = v_uint32()
        self.CurrentTemperature = v_uint32()
        self.PassiveTripPoint = v_uint32()
        self.CriticalTripPoint = v_uint32()
        self.ActiveTripPointCount = v_uint8()
        self._pad0024 = v_bytes(size=3)
        self.ActiveTripPoint = vstruct.VArray([ v_uint32() for i in xrange(10) ])


class MMEXTEND_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CommittedSize = v_uint64()
        self.ReferenceCount = v_uint32()
        self._pad0010 = v_bytes(size=4)


class VF_TARGET_ALL_SHARED_EXPORT_THUNKS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SharedExportThunks = v_ptr32()
        self.PoolSharedExportThunks = v_ptr32()
        self.OrderDependentSharedExportThunks = v_ptr32()
        self.XdvSharedExportThunks = v_ptr32()


class RTL_USER_PROCESS_PARAMETERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MaximumLength = v_uint32()
        self.Length = v_uint32()
        self.Flags = v_uint32()
        self.DebugFlags = v_uint32()
        self.ConsoleHandle = v_ptr32()
        self.ConsoleFlags = v_uint32()
        self.StandardInput = v_ptr32()
        self.StandardOutput = v_ptr32()
        self.StandardError = v_ptr32()
        self.CurrentDirectory = CURDIR()
        self.DllPath = UNICODE_STRING()
        self.ImagePathName = UNICODE_STRING()
        self.CommandLine = UNICODE_STRING()
        self.Environment = v_ptr32()
        self.StartingX = v_uint32()
        self.StartingY = v_uint32()
        self.CountX = v_uint32()
        self.CountY = v_uint32()
        self.CountCharsX = v_uint32()
        self.CountCharsY = v_uint32()
        self.FillAttribute = v_uint32()
        self.WindowFlags = v_uint32()
        self.ShowWindowFlags = v_uint32()
        self.WindowTitle = UNICODE_STRING()
        self.DesktopInfo = UNICODE_STRING()
        self.ShellInfo = UNICODE_STRING()
        self.RuntimeData = UNICODE_STRING()
        self.CurrentDirectores = vstruct.VArray([ RTL_DRIVE_LETTER_CURDIR() for i in xrange(32) ])
        self.EnvironmentSize = v_uint32()
        self.EnvironmentVersion = v_uint32()
        self.PackageDependencyData = v_ptr32()
        self.ProcessGroupId = v_uint32()


class _unnamed_34963(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.s1 = _unnamed_36621()


class ACTIVATION_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class FILESYSTEM_DISK_COUNTERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.FsBytesRead = v_uint64()
        self.FsBytesWritten = v_uint64()


class MM_DRIVER_VERIFIER_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Level = v_uint32()
        self.RaiseIrqls = v_uint32()
        self.AcquireSpinLocks = v_uint32()
        self.SynchronizeExecutions = v_uint32()
        self.AllocationsAttempted = v_uint32()
        self.AllocationsSucceeded = v_uint32()
        self.AllocationsSucceededSpecialPool = v_uint32()
        self.AllocationsWithNoTag = v_uint32()
        self.TrimRequests = v_uint32()
        self.Trims = v_uint32()
        self.AllocationsFailed = v_uint32()
        self.AllocationsFailedDeliberately = v_uint32()
        self.Loads = v_uint32()
        self.Unloads = v_uint32()
        self.UnTrackedPool = v_uint32()
        self.UserTrims = v_uint32()
        self.CurrentPagedPoolAllocations = v_uint32()
        self.CurrentNonPagedPoolAllocations = v_uint32()
        self.PeakPagedPoolAllocations = v_uint32()
        self.PeakNonPagedPoolAllocations = v_uint32()
        self.PagedBytes = v_uint32()
        self.NonPagedBytes = v_uint32()
        self.PeakPagedBytes = v_uint32()
        self.PeakNonPagedBytes = v_uint32()
        self.BurstAllocationsFailedDeliberately = v_uint32()
        self.SessionTrims = v_uint32()
        self.OptionChanges = v_uint32()
        self.VerifyMode = v_uint32()
        self.PreviousBucketName = UNICODE_STRING()
        self.ActivityCounter = v_uint32()
        self.PreviousActivityCounter = v_uint32()
        self.WorkerTrimRequests = v_uint32()


class _unnamed_37043(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Mbr = _unnamed_37222()
        self._pad0010 = v_bytes(size=8)


class SEP_LOWBOX_NUMBER_MAPPING(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Lock = EX_PUSH_LOCK()
        self.Bitmap = RTL_BITMAP()
        self.HashTable = v_ptr32()
        self.Active = v_uint8()
        self._pad0014 = v_bytes(size=3)


class IOP_IRP_EXTENSION_STATUS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flags = v_uint32()
        self.ActivityId = v_uint32()
        self.IoTracking = v_uint32()


class ALPC_COMPLETION_LIST_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.StartMagic = v_uint64()
        self.TotalSize = v_uint32()
        self.ListOffset = v_uint32()
        self.ListSize = v_uint32()
        self.BitmapOffset = v_uint32()
        self.BitmapSize = v_uint32()
        self.DataOffset = v_uint32()
        self.DataSize = v_uint32()
        self.AttributeFlags = v_uint32()
        self.AttributeSize = v_uint32()
        self._pad0040 = v_bytes(size=20)
        self.State = ALPC_COMPLETION_LIST_STATE()
        self.LastMessageId = v_uint32()
        self.LastCallbackId = v_uint32()
        self._pad0080 = v_bytes(size=48)
        self.PostCount = v_uint32()
        self._pad00c0 = v_bytes(size=60)
        self.ReturnCount = v_uint32()
        self._pad0100 = v_bytes(size=60)
        self.LogSequenceNumber = v_uint32()
        self._pad0140 = v_bytes(size=60)
        self.UserLock = RTL_SRWLOCK()
        self._pad0148 = v_bytes(size=4)
        self.EndMagic = v_uint64()
        self._pad0180 = v_bytes(size=48)


class ETW_QUEUE_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self.DataBlock = v_ptr32()
        self.RegEntry = v_ptr32()
        self.ReplyObject = v_ptr32()
        self.WakeReference = v_ptr32()
        self.RegIndex = v_uint16()
        self.ReplyIndex = v_uint16()
        self.Flags = v_uint32()


class _unnamed_27954(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.EaList = v_ptr32()
        self.EaListLength = v_uint32()
        self.EaIndex = v_uint32()


class u(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.KeyNode = CM_KEY_NODE()


class IO_RESOURCE_REQUIREMENTS_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListSize = v_uint32()
        self.InterfaceType = v_uint32()
        self.BusNumber = v_uint32()
        self.SlotNumber = v_uint32()
        self.Reserved = vstruct.VArray([ v_uint32() for i in xrange(3) ])
        self.AlternativeLists = v_uint32()
        self.List = vstruct.VArray([ IO_RESOURCE_LIST() for i in xrange(1) ])


class VF_WATCHDOG_IRP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self.Irp = v_ptr32()
        self.DueTickCount = v_uint32()
        self.Inserted = v_uint8()
        self.TrackedStackLocation = v_uint8()
        self.CancelTimeoutTicks = v_uint16()


class MMWSLE_NONDIRECT_HASH(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Key = v_ptr32()
        self.Index = v_uint32()


class _unnamed_27959(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()



