"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerImageFunction = exports.DockerImageCode = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const code_1 = require("./code");
const function_1 = require("./function");
const handler_1 = require("./handler");
const runtime_1 = require("./runtime");
/**
 * Code property for the DockerImageFunction construct
 */
class DockerImageCode {
    /**
     * Use an existing ECR image as the Lambda code.
     * @param repository the ECR repository that the image is in
     * @param props properties to further configure the selected image
     */
    static fromEcr(repository, props) {
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_EcrImageCodeProps(props);
        return {
            _bind() {
                return new code_1.EcrImageCode(repository, props);
            },
        };
    }
    /**
     * Create an ECR image from the specified asset and bind it as the Lambda code.
     * @param directory the directory from which the asset must be created
     * @param props properties to further configure the selected image
     */
    static fromImageAsset(directory, props = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_AssetImageCodeProps(props);
        return {
            _bind() {
                return new code_1.AssetImageCode(directory, props);
            },
        };
    }
}
exports.DockerImageCode = DockerImageCode;
_a = JSII_RTTI_SYMBOL_1;
DockerImageCode[_a] = { fqn: "@aws-cdk/aws-lambda.DockerImageCode", version: "1.149.0" };
/**
 * Create a lambda function where the handler is a docker image
 */
class DockerImageFunction extends function_1.Function {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            handler: handler_1.Handler.FROM_IMAGE,
            runtime: runtime_1.Runtime.FROM_IMAGE,
            code: props.code._bind(),
        });
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_DockerImageFunctionProps(props);
    }
}
exports.DockerImageFunction = DockerImageFunction;
_b = JSII_RTTI_SYMBOL_1;
DockerImageFunction[_b] = { fqn: "@aws-cdk/aws-lambda.DockerImageFunction", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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