"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogRetention = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const logs = require("@aws-cdk/aws-logs");
/**
 * Creates a custom resource to control the retention policy of a CloudWatch Logs
 * log group. The log group is created if it doesn't already exist. The policy
 * is removed when `retentionDays` is `undefined` or equal to `Infinity`.
 *
 * @deprecated use `LogRetention` from '@aws-cdk/aws-logs' instead
 */
class LogRetention extends logs.LogRetention {
    constructor(scope, id, props) {
        super(scope, id, { ...props });
        jsiiDeprecationWarnings.print("@aws-cdk/aws-lambda.LogRetention", "use `LogRetention` from '");
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_LogRetentionProps(props);
    }
}
exports.LogRetention = LogRetention;
_a = JSII_RTTI_SYMBOL_1;
LogRetention[_a] = { fqn: "@aws-cdk/aws-lambda.LogRetention", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9nLXJldGVudGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImxvZy1yZXRlbnRpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsMENBQTBDO0FBaUIxQzs7Ozs7O0dBTUc7QUFDSCxNQUFhLFlBQWEsU0FBUSxJQUFJLENBQUMsWUFBWTtJQUNqRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXdCO1FBQ2hFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsR0FBRyxLQUFLLEVBQUUsQ0FBQyxDQUFDOzs7S0FDaEM7O0FBSEgsb0NBSUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBsb2dzIGZyb20gJ0Bhd3MtY2RrL2F3cy1sb2dzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG4vKipcbiAqIFJldHJ5IG9wdGlvbnMgZm9yIGFsbCBBV1MgQVBJIGNhbGxzLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIExvZ1JldGVudGlvblJldHJ5T3B0aW9ucyBleHRlbmRzIGxvZ3MuTG9nUmV0ZW50aW9uUmV0cnlPcHRpb25zIHtcbn1cblxuLyoqXG4gKiBDb25zdHJ1Y3Rpb24gcHJvcGVydGllcyBmb3IgYSBMb2dSZXRlbnRpb24uXG4gKlxuICogQGRlcHJlY2F0ZWQgdXNlIGBMb2dSZXRlbnRpb25Qcm9wc2AgZnJvbSAnQGF3cy1jZGsvYXdzLWxvZ3MnIGluc3RlYWRcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBMb2dSZXRlbnRpb25Qcm9wcyBleHRlbmRzIGxvZ3MuTG9nUmV0ZW50aW9uUHJvcHMge1xufVxuXG4vKipcbiAqIENyZWF0ZXMgYSBjdXN0b20gcmVzb3VyY2UgdG8gY29udHJvbCB0aGUgcmV0ZW50aW9uIHBvbGljeSBvZiBhIENsb3VkV2F0Y2ggTG9nc1xuICogbG9nIGdyb3VwLiBUaGUgbG9nIGdyb3VwIGlzIGNyZWF0ZWQgaWYgaXQgZG9lc24ndCBhbHJlYWR5IGV4aXN0LiBUaGUgcG9saWN5XG4gKiBpcyByZW1vdmVkIHdoZW4gYHJldGVudGlvbkRheXNgIGlzIGB1bmRlZmluZWRgIG9yIGVxdWFsIHRvIGBJbmZpbml0eWAuXG4gKlxuICogQGRlcHJlY2F0ZWQgdXNlIGBMb2dSZXRlbnRpb25gIGZyb20gJ0Bhd3MtY2RrL2F3cy1sb2dzJyBpbnN0ZWFkXG4gKi9cbmV4cG9ydCBjbGFzcyBMb2dSZXRlbnRpb24gZXh0ZW5kcyBsb2dzLkxvZ1JldGVudGlvbiB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBMb2dSZXRlbnRpb25Qcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgeyAuLi5wcm9wcyB9KTtcbiAgfVxufVxuIl19