import Boost.Python
from _typeshed import Incomplete
from jiminy_py.core.eigenpy.eigenpy_pywrap import AngleAxis as AngleAxis, Quaternion as Quaternion
from typing import Any, ClassVar, overload

Absolute: GJKConvergenceCriterionType
BVH_BUILD_STATE_BEGUN: BVHBuildState
BVH_BUILD_STATE_EMPTY: BVHBuildState
BVH_BUILD_STATE_PROCESSED: BVHBuildState
BVH_BUILD_STATE_REPLACE_BEGUN: BVHBuildState
BVH_BUILD_STATE_UPDATED: BVHBuildState
BVH_BUILD_STATE_UPDATE_BEGUN: BVHBuildState
BVH_MODEL_POINTCLOUD: BVHModelType
BVH_MODEL_TRIANGLES: BVHModelType
BVH_MODEL_UNKNOWN: BVHModelType
BV_AABB: NODE_TYPE
BV_KDOP16: NODE_TYPE
BV_KDOP18: NODE_TYPE
BV_KDOP24: NODE_TYPE
BV_OBB: NODE_TYPE
BV_OBBRSS: NODE_TYPE
BV_RSS: NODE_TYPE
BV_UNKNOWN: NODE_TYPE
BV_kIOS: NODE_TYPE
CONTACT: CollisionRequestFlag
DISTANCE_LOWER_BOUND: CollisionRequestFlag
DefaultGJK: GJKVariant
DualityGap: GJKConvergenceCriterion
Failed: GJKStatus
GEOM_BOX: NODE_TYPE
GEOM_CAPSULE: NODE_TYPE
GEOM_CONE: NODE_TYPE
GEOM_CONVEX: NODE_TYPE
GEOM_CYLINDER: NODE_TYPE
GEOM_ELLIPSOID: NODE_TYPE
GEOM_HALFSPACE: NODE_TYPE
GEOM_OCTREE: NODE_TYPE
GEOM_PLANE: NODE_TYPE
GEOM_SPHERE: NODE_TYPE
GEOM_TRIANGLE: NODE_TYPE
HF_AABB: NODE_TYPE
HF_OBBRSS: NODE_TYPE
HPP_FCL_MAJOR_VERSION: int
HPP_FCL_MINOR_VERSION: int
HPP_FCL_PATCH_VERSION: int
Hybrid: GJKConvergenceCriterion
Inside: GJKStatus
NO_REQUEST: CollisionRequestFlag
NesterovAcceleration: GJKVariant
OT_BVH: OBJECT_TYPE
OT_GEOM: OBJECT_TYPE
OT_HFIELD: OBJECT_TYPE
OT_OCTREE: OBJECT_TYPE
OT_UNKNOWN: OBJECT_TYPE
Relative: GJKConvergenceCriterionType
VDB: GJKConvergenceCriterion
Valid: GJKStatus
__raw_version__: str
__version__: str

class AABB(Boost.Python.instance):
    __safe_for_unpickling__: ClassVar[bool] = ...
    max_: Incomplete
    min_: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def center(cls, classhpp) -> Any: ...
    @classmethod
    def contain(cls, *args, **kwargs): ...
    @classmethod
    def depth(cls, classhpp) -> Any: ...
    @classmethod
    def distance(cls, *args, **kwargs): ...
    @classmethod
    def expand(cls, classhpp, double) -> Any: ...
    @classmethod
    def height(cls, classhpp) -> Any: ...
    @classmethod
    def overlap(cls, *args, **kwargs): ...
    @classmethod
    def size(cls, classhpp) -> Any: ...
    @classmethod
    def volume(cls, classhpp) -> Any: ...
    @classmethod
    def width(cls, classhpp) -> Any: ...
    @classmethod
    def __add__(cls, other): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __iadd__(cls, structboost, classhpp) -> Any: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...

class BVHBuildState(Boost.Python.enum):
    BVH_BUILD_STATE_BEGUN: ClassVar[BVHBuildState] = ...
    BVH_BUILD_STATE_EMPTY: ClassVar[BVHBuildState] = ...
    BVH_BUILD_STATE_PROCESSED: ClassVar[BVHBuildState] = ...
    BVH_BUILD_STATE_REPLACE_BEGUN: ClassVar[BVHBuildState] = ...
    BVH_BUILD_STATE_UPDATED: ClassVar[BVHBuildState] = ...
    BVH_BUILD_STATE_UPDATE_BEGUN: ClassVar[BVHBuildState] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...

class BVHModelBase(CollisionGeometry):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def addSubModel(cls, *args, **kwargs): ...
    @classmethod
    def addTriangle(cls, *args, **kwargs): ...
    @classmethod
    def addTriangles(cls, *args, **kwargs): ...
    @classmethod
    def addVertex(cls, *args, **kwargs): ...
    @classmethod
    def addVertices(cls, *args, **kwargs): ...
    @classmethod
    def beginModel(cls, *args, **kwargs): ...
    @classmethod
    def beginReplaceModel(cls, classhpp) -> Any: ...
    @classmethod
    def buildConvexHull(cls, *args, **kwargs): ...
    @classmethod
    def buildConvexRepresentation(cls, classhpp, bool) -> Any: ...
    @classmethod
    def endModel(cls, classhpp) -> Any: ...
    @classmethod
    def endReplaceModel(cls, *args, **kwargs): ...
    @classmethod
    def getModelType(cls, classhpp) -> Any: ...
    @classmethod
    def replaceSubModel(cls, *args, **kwargs): ...
    @classmethod
    def replaceTriangle(cls, *args, **kwargs): ...
    @classmethod
    def replaceVertex(cls, *args, **kwargs): ...
    @classmethod
    def tri_indices(cls, classhpp, unsignedint) -> Any: ...
    @classmethod
    def vertex(cls, classhpp, unsignedint) -> Any: ...
    @overload
    @classmethod
    def vertices(cls, classhpp, unsignedint) -> Any: ...
    @overload
    @classmethod
    def vertices(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def build_state(self): ...
    @property
    def convex(self): ...
    @property
    def num_tris(self): ...
    @property
    def num_vertices(self): ...

class BVHModelOBB(BVHModelBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def getNumBVs(cls, classhpp) -> Any: ...
    @classmethod
    def makeParentRelative(cls, classhpp) -> Any: ...
    @classmethod
    def memUsage(cls, classhpp, bool) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class BVHModelOBBRSS(BVHModelBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def getNumBVs(cls, classhpp) -> Any: ...
    @classmethod
    def makeParentRelative(cls, classhpp) -> Any: ...
    @classmethod
    def memUsage(cls, classhpp, bool) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class BVHModelType(Boost.Python.enum):
    BVH_MODEL_POINTCLOUD: ClassVar[BVHModelType] = ...
    BVH_MODEL_TRIANGLES: ClassVar[BVHModelType] = ...
    BVH_MODEL_UNKNOWN: ClassVar[BVHModelType] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...

class Box(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    halfSide: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class BroadPhaseCollisionManager(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @overload
    @classmethod
    def clear(cls, classhpp) -> Any: ...
    @overload
    @classmethod
    def clear(cls, structhpp) -> Any: ...
    @classmethod
    def collide(cls, classhpp, structhpp) -> Any: ...
    @classmethod
    def distance(cls, classhpp, structhpp) -> Any: ...
    @overload
    @classmethod
    def empty(cls, classhpp) -> Any: ...
    @overload
    @classmethod
    def empty(cls, structhpp) -> Any: ...
    @overload
    @classmethod
    def getObjects(cls, classhpp) -> Any: ...
    @overload
    @classmethod
    def getObjects(cls, structhpp) -> Any: ...
    @classmethod
    def registerObject(cls, structhpp, classhpp) -> Any: ...
    @classmethod
    def registerObjects(cls, *args, **kwargs): ...
    @overload
    @classmethod
    def setup(cls, classhpp) -> Any: ...
    @overload
    @classmethod
    def setup(cls, structhpp) -> Any: ...
    @overload
    @classmethod
    def size(cls, classhpp) -> Any: ...
    @overload
    @classmethod
    def size(cls, structhpp) -> Any: ...
    @classmethod
    def unregisterObject(cls, structhpp, classhpp) -> Any: ...
    @overload
    @classmethod
    def update(cls, classhpp) -> Any: ...
    @overload
    @classmethod
    def update(cls, structhpp) -> Any: ...
    @overload
    @classmethod
    def update(cls, structhpp, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class CPUTimes(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clear(cls, structhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def system(self): ...
    @property
    def user(self): ...
    @property
    def wall(self): ...

class CachedMeshLoader(MeshLoader):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class Capsule(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    halfLength: Incomplete
    radius: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class CollisionCallBackBase(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def collide(cls, *args, **kwargs): ...
    @overload
    @classmethod
    def init(cls, structhpp) -> Any: ...
    @overload
    @classmethod
    def init(cls, structhpp) -> Any: ...
    @classmethod
    def __call__(cls, *args, **kwargs): ...
    @classmethod
    def __reduce__(cls): ...

class CollisionCallBackCollect(CollisionCallBackBase):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def exist(cls, structhpp, structstd, classhpp) -> Any: ...
    @classmethod
    def getCollisionPairs(cls, structhpp) -> Any: ...
    @classmethod
    def numCollisionPairs(cls, structhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class CollisionCallBackDefault(CollisionCallBackBase):
    data: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class CollisionData(Boost.Python.instance):
    done: Incomplete
    request: Incomplete
    result: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clear(cls, structhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class CollisionGeometry(Boost.Python.instance):
    aabb_center: Incomplete
    aabb_local: Incomplete
    aabb_radius: Incomplete
    cost_density: Incomplete
    threshold_free: Incomplete
    threshold_occupied: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def computeCOM(cls, classhpp) -> Any: ...
    @classmethod
    def computeLocalAABB(cls, classhpp) -> Any: ...
    @classmethod
    def computeMomentofInertia(cls, classhpp) -> Any: ...
    @classmethod
    def computeMomentofInertiaRelatedToCOM(cls, classhpp) -> Any: ...
    @classmethod
    def computeVolume(cls, classhpp) -> Any: ...
    @classmethod
    def getNodeType(cls, classhpp) -> Any: ...
    @classmethod
    def getObjectType(cls, classhpp) -> Any: ...
    @classmethod
    def isFree(cls, classhpp) -> Any: ...
    @classmethod
    def isOccupied(cls, classhpp) -> Any: ...
    @classmethod
    def isUncertain(cls, classhpp) -> Any: ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...

class CollisionObject(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def collisionGeometry(cls, classhpp) -> Any: ...
    @classmethod
    def computeAABB(cls, classhpp) -> Any: ...
    @classmethod
    def getAABB(cls, classhpp) -> Any: ...
    @classmethod
    def getNodeType(cls, classhpp) -> Any: ...
    @classmethod
    def getObjectType(cls, classhpp) -> Any: ...
    @classmethod
    def getRotation(cls, classhpp) -> Any: ...
    @classmethod
    def getTransform(cls, classhpp) -> Any: ...
    @classmethod
    def getTranslation(cls, classhpp) -> Any: ...
    @classmethod
    def isIdentityTransform(cls, classhpp) -> Any: ...
    @classmethod
    def setCollisionGeometry(cls, classhpp, classstd, bool) -> Any: ...
    @classmethod
    def setIdentityTransform(cls, classhpp) -> Any: ...
    @classmethod
    def setRotation(cls, *args, **kwargs): ...
    @classmethod
    def setTransform(cls, *args, **kwargs): ...
    @classmethod
    def setTranslation(cls, *args, **kwargs): ...
    @classmethod
    def __reduce__(cls): ...

class CollisionRequest(QueryRequest):
    break_distance: Incomplete
    distance_upper_bound: Incomplete
    enable_contact: Incomplete
    enable_distance_lower_bound: Incomplete
    num_max_contacts: Incomplete
    security_margin: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class CollisionRequestFlag(Boost.Python.enum):
    CONTACT: ClassVar[CollisionRequestFlag] = ...
    DISTANCE_LOWER_BOUND: ClassVar[CollisionRequestFlag] = ...
    NO_REQUEST: ClassVar[CollisionRequestFlag] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...

class CollisionResult(QueryResult):
    distance_lower_bound: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def addContact(cls, *args, **kwargs): ...
    @classmethod
    def clear(cls, structhpp) -> Any: ...
    @classmethod
    def getContact(cls, structhpp, unsigned__int64) -> Any: ...
    @classmethod
    def getContacts(cls, structhpp) -> Any: ...
    @classmethod
    def isCollision(cls, structhpp) -> Any: ...
    @classmethod
    def numContacts(cls, structhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class ComputeCollision(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __call__(cls, *args, **kwargs): ...
    @classmethod
    def __reduce__(cls): ...

class ComputeDistance(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __call__(cls, *args, **kwargs): ...
    @classmethod
    def __reduce__(cls): ...

class Cone(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    halfLength: Incomplete
    radius: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class Contact(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    b1: Incomplete
    b2: Incomplete
    normal: Incomplete
    penetration_depth: Incomplete
    pos: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def o1(self): ...
    @property
    def o2(self): ...

class Convex(ConvexBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def polygons(cls, classhpp, unsignedint) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def num_polygons(self): ...

class ConvexBase(ShapeBase):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @staticmethod
    def convexHull(*args, **kwargs): ...
    @classmethod
    def neighbors(cls, classhpp, unsignedint) -> Any: ...
    @classmethod
    def point(cls, classhpp, unsignedint) -> Any: ...
    @overload
    @classmethod
    def points(cls, classhpp, unsignedint) -> Any: ...
    @overload
    @classmethod
    def points(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def center(self): ...
    @property
    def num_points(self): ...

class Cylinder(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    halfLength: Incomplete
    radius: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class DistanceCallBackBase(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def distance(cls, *args, **kwargs): ...
    @overload
    @classmethod
    def init(cls, structhpp) -> Any: ...
    @overload
    @classmethod
    def init(cls, structhpp) -> Any: ...
    @classmethod
    def __call__(cls, *args, **kwargs): ...
    @classmethod
    def __reduce__(cls): ...

class DistanceCallBackDefault(DistanceCallBackBase):
    data: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class DistanceData(Boost.Python.instance):
    done: Incomplete
    request: Incomplete
    result: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clear(cls, structhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class DistanceRequest(QueryRequest):
    __instance_size__: ClassVar[int] = ...
    abs_err: Incomplete
    enable_nearest_points: Incomplete
    rel_err: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class DistanceResult(QueryResult):
    b1: Incomplete
    b2: Incomplete
    min_distance: Incomplete
    normal: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clear(cls, structhpp) -> Any: ...
    @classmethod
    def getNearestPoint1(cls, structhpp) -> Any: ...
    @classmethod
    def getNearestPoint2(cls, structhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def o1(self): ...
    @property
    def o2(self): ...

class DynamicAABBTreeArrayCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class DynamicAABBTreeCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class Ellipsoid(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    radii: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class GJK(Boost.Python.instance):
    convergence_criterion: Incomplete
    convergence_criterion_type: Incomplete
    distance: Incomplete
    gjk_variant: Incomplete
    ray: Incomplete
    support_hint: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def evaluate(cls, *args, **kwargs): ...
    @classmethod
    def getClosestPoints(cls, *args, **kwargs): ...
    @classmethod
    def getGuessFromSimplex(cls, structhpp) -> Any: ...
    @classmethod
    def getIterations(cls, structhpp) -> Any: ...
    @classmethod
    def hasClosestPoints(cls, structhpp) -> Any: ...
    @classmethod
    def hasPenetrationInformation(cls, *args, **kwargs): ...
    @classmethod
    def setDistanceEarlyBreak(cls, structhpp, double) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class GJKConvergenceCriterion(Boost.Python.enum):
    DualityGap: ClassVar[GJKConvergenceCriterion] = ...
    Hybrid: ClassVar[GJKConvergenceCriterion] = ...
    VDB: ClassVar[GJKConvergenceCriterion] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...

class GJKConvergenceCriterionType(Boost.Python.enum):
    Absolute: ClassVar[GJKConvergenceCriterionType] = ...
    Relative: ClassVar[GJKConvergenceCriterionType] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...

class GJKStatus(Boost.Python.enum):
    Failed: ClassVar[GJKStatus] = ...
    Inside: ClassVar[GJKStatus] = ...
    Valid: ClassVar[GJKStatus] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...

class GJKVariant(Boost.Python.enum):
    DefaultGJK: ClassVar[GJKVariant] = ...
    NesterovAcceleration: ClassVar[GJKVariant] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...

class Halfspace(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    d: Incomplete
    n: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class HeightFieldAABB(CollisionGeometry):
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def getBV(cls, classhpp, unsignedint) -> Any: ...
    @classmethod
    def getHeights(cls, classhpp) -> Any: ...
    @classmethod
    def getMaxHeight(cls, classhpp) -> Any: ...
    @classmethod
    def getMinHeight(cls, classhpp) -> Any: ...
    @classmethod
    def getNodeType(cls, classhpp) -> Any: ...
    @classmethod
    def getXDim(cls, classhpp) -> Any: ...
    @classmethod
    def getXGrid(cls, classhpp) -> Any: ...
    @classmethod
    def getYDim(cls, classhpp) -> Any: ...
    @classmethod
    def getYGrid(cls, classhpp) -> Any: ...
    @classmethod
    def updateHeights(cls, *args, **kwargs): ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class HeightFieldOBBRSS(CollisionGeometry):
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def getBV(cls, classhpp, unsignedint) -> Any: ...
    @classmethod
    def getHeights(cls, classhpp) -> Any: ...
    @classmethod
    def getMaxHeight(cls, classhpp) -> Any: ...
    @classmethod
    def getMinHeight(cls, classhpp) -> Any: ...
    @classmethod
    def getNodeType(cls, classhpp) -> Any: ...
    @classmethod
    def getXDim(cls, classhpp) -> Any: ...
    @classmethod
    def getXGrid(cls, classhpp) -> Any: ...
    @classmethod
    def getYDim(cls, classhpp) -> Any: ...
    @classmethod
    def getYGrid(cls, classhpp) -> Any: ...
    @classmethod
    def updateHeights(cls, *args, **kwargs): ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class IntervalTreeCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class MeshLoader(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def load(cls, *args, **kwargs): ...
    @classmethod
    def loadOctree(cls, *args, **kwargs): ...
    @classmethod
    def __reduce__(cls): ...

class MinkowskiDiff(Boost.Python.instance):
    inflation: Incomplete
    normalize_support_direction: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def set(cls, *args, **kwargs): ...
    @classmethod
    def support(cls, *args, **kwargs): ...
    @classmethod
    def support0(cls, *args, **kwargs): ...
    @classmethod
    def support1(cls, *args, **kwargs): ...
    @classmethod
    def __reduce__(cls): ...

class NODE_TYPE(Boost.Python.enum):
    BV_AABB: ClassVar[NODE_TYPE] = ...
    BV_KDOP16: ClassVar[NODE_TYPE] = ...
    BV_KDOP18: ClassVar[NODE_TYPE] = ...
    BV_KDOP24: ClassVar[NODE_TYPE] = ...
    BV_OBB: ClassVar[NODE_TYPE] = ...
    BV_OBBRSS: ClassVar[NODE_TYPE] = ...
    BV_RSS: ClassVar[NODE_TYPE] = ...
    BV_UNKNOWN: ClassVar[NODE_TYPE] = ...
    BV_kIOS: ClassVar[NODE_TYPE] = ...
    GEOM_BOX: ClassVar[NODE_TYPE] = ...
    GEOM_CAPSULE: ClassVar[NODE_TYPE] = ...
    GEOM_CONE: ClassVar[NODE_TYPE] = ...
    GEOM_CONVEX: ClassVar[NODE_TYPE] = ...
    GEOM_CYLINDER: ClassVar[NODE_TYPE] = ...
    GEOM_ELLIPSOID: ClassVar[NODE_TYPE] = ...
    GEOM_HALFSPACE: ClassVar[NODE_TYPE] = ...
    GEOM_OCTREE: ClassVar[NODE_TYPE] = ...
    GEOM_PLANE: ClassVar[NODE_TYPE] = ...
    GEOM_SPHERE: ClassVar[NODE_TYPE] = ...
    GEOM_TRIANGLE: ClassVar[NODE_TYPE] = ...
    HF_AABB: ClassVar[NODE_TYPE] = ...
    HF_OBBRSS: ClassVar[NODE_TYPE] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...

class NaiveCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class OBJECT_TYPE(Boost.Python.enum):
    OT_BVH: ClassVar[OBJECT_TYPE] = ...
    OT_GEOM: ClassVar[OBJECT_TYPE] = ...
    OT_HFIELD: ClassVar[OBJECT_TYPE] = ...
    OT_OCTREE: ClassVar[OBJECT_TYPE] = ...
    OT_UNKNOWN: ClassVar[OBJECT_TYPE] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...

class Plane(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    d: Incomplete
    n: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class QueryRequest(Boost.Python.instance):
    cached_gjk_guess: Incomplete
    cached_support_func_guess: Incomplete
    enable_cached_gjk_guess: Incomplete
    enable_timings: Incomplete
    gjk_convergence_criterion: Incomplete
    gjk_convergence_criterion_type: Incomplete
    gjk_initial_guess: Incomplete
    gjk_max_iterations: Incomplete
    gjk_tolerance: Incomplete
    gjk_variant: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def updateGuess(cls, *args, **kwargs): ...
    @classmethod
    def __reduce__(cls): ...

class QueryResult(Boost.Python.instance):
    cached_gjk_guess: Incomplete
    cached_support_func_guess: Incomplete
    timings: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class SSaPCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class SaPCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class ShapeBase(CollisionGeometry):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class SpatialHashingCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class Sphere(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    radius: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class StdVec_CollisionRequest(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls, structboost, classstd) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_CollisionResult(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls, structboost, classstd) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_Contact(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls, structboost, classstd) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_DistanceRequest(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls, structboost, classstd) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_DistanceResult(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls, structboost, classstd) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_Triangle(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls, structboost, classstd) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_Vec3f(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls): ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class Transform3f(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @staticmethod
    def Identity() -> Any: ...
    @classmethod
    def getQuatRotation(cls, classhpp) -> Any: ...
    @classmethod
    def getRotation(cls, classhpp) -> Any: ...
    @classmethod
    def getTranslation(cls, classhpp) -> Any: ...
    @classmethod
    def inverse(cls, classhpp) -> Any: ...
    @classmethod
    def inverseInPlace(cls, classhpp) -> Any: ...
    @classmethod
    def inverseTimes(cls, *args, **kwargs): ...
    @classmethod
    def isIdentity(cls, classhpp) -> Any: ...
    @classmethod
    def setIdentity(cls, classhpp) -> Any: ...
    @classmethod
    def setQuatRotation(cls, *args, **kwargs): ...
    @classmethod
    def setRotation(cls, *args, **kwargs): ...
    @classmethod
    def setTransform(cls, *args, **kwargs): ...
    @classmethod
    def setTranslation(cls, *args, **kwargs): ...
    @classmethod
    def transform(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __imul__(cls, structboost, classhpp) -> Any: ...
    @classmethod
    def __mul__(cls, other): ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...

class Triangle(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def set(cls, *args, **kwargs): ...
    @staticmethod
    def size() -> Any: ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __getitem__(cls, classhpp, int) -> Any: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, classhpp, int, unsigned__int64) -> Any: ...

class TriangleP(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    a: Incomplete
    b: Incomplete
    c: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, classhpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, classhpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

def checkVersionAtLeast(*args, **kwargs): ...
def checkVersionAtMost(*args, **kwargs): ...
def collide(*args, **kwargs): ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
@overload
def computeMemoryFootprint(classhpp) -> Any: ...
def distance(*args, **kwargs): ...
def rotate(*args, **kwargs): ...
@overload
def seed(unsignedint) -> Any: ...
@overload
def seed(unsignedint) -> Any: ...
@overload
def sharedMemory(bool) -> Any: ...
@overload
def sharedMemory() -> Any: ...
@overload
def sharedMemory(bool) -> Any: ...
@overload
def sharedMemory() -> Any: ...
def translate(*args, **kwargs): ...
