# coding: utf-8

"""
    Kinde Account API

     Provides endpoints to operate on an authenticated user.  ## Intro  ## How to use  1. Get a user access token - this can be obtained when a user signs in via the methods you've setup in Kinde (e.g. Google, passwordless, etc).  2. Call one of the endpoints below using the user access token in the Authorization header as a Bearer token. Typically, you can use the `getToken` command in the relevant SDK. 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UserProfileV2(BaseModel):
    """
    UserProfileV2
    """ # noqa: E501
    sub: Optional[StrictStr] = Field(default=None, description="Unique ID of the user in Kinde.")
    provided_id: Optional[StrictStr] = Field(default=None, description="Value of the user's ID in a third-party system when the user is imported into Kinde.")
    name: Optional[StrictStr] = Field(default=None, description="User's first and last name separated by a space.")
    given_name: Optional[StrictStr] = Field(default=None, description="User's first name.")
    family_name: Optional[StrictStr] = Field(default=None, description="User's last name.")
    updated_at: Optional[StrictInt] = Field(default=None, description="Date the user was last updated at (In Unix time).")
    email: Optional[StrictStr] = Field(default=None, description="User's email address if available.")
    email_verified: Optional[StrictBool] = Field(default=None, description="Whether the user's email address has been verified.")
    picture: Optional[StrictStr] = Field(default=None, description="URL that point's to the user's picture or avatar")
    preferred_username: Optional[StrictStr] = Field(default=None, description="User's preferred username.")
    id: Optional[StrictStr] = Field(default=None, description="Unique ID of the user in Kinde")
    __properties: ClassVar[List[str]] = ["sub", "provided_id", "name", "given_name", "family_name", "updated_at", "email", "email_verified", "picture", "preferred_username", "id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserProfileV2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if provided_id (nullable) is None
        # and model_fields_set contains the field
        if self.provided_id is None and "provided_id" in self.model_fields_set:
            _dict['provided_id'] = None

        # set to None if picture (nullable) is None
        # and model_fields_set contains the field
        if self.picture is None and "picture" in self.model_fields_set:
            _dict['picture'] = None

        # set to None if preferred_username (nullable) is None
        # and model_fields_set contains the field
        if self.preferred_username is None and "preferred_username" in self.model_fields_set:
            _dict['preferred_username'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserProfileV2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sub": obj.get("sub"),
            "provided_id": obj.get("provided_id"),
            "name": obj.get("name"),
            "given_name": obj.get("given_name"),
            "family_name": obj.get("family_name"),
            "updated_at": obj.get("updated_at"),
            "email": obj.get("email"),
            "email_verified": obj.get("email_verified"),
            "picture": obj.get("picture"),
            "preferred_username": obj.get("preferred_username"),
            "id": obj.get("id")
        })
        return _obj


