# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from kinde_sdk.management.models.get_billing_entitlements_response import GetBillingEntitlementsResponse

from kinde_sdk.management.api_client import ApiClient, RequestSerialized
from kinde_sdk.management.api_response import ApiResponse
from kinde_sdk.management.rest import RESTResponseType


class BillingEntitlementsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_billing_entitlements(
        self,
        customer_id: Annotated[StrictStr, Field(description="The ID of the billing customer to retrieve entitlements for")],
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page. Defaults to 10 if parameter not sent.")] = None,
        starting_after: Annotated[Optional[StrictStr], Field(description="The ID of the billing entitlement to start after.")] = None,
        ending_before: Annotated[Optional[StrictStr], Field(description="The ID of the billing entitlement to end before.")] = None,
        max_value: Annotated[Optional[StrictStr], Field(description="When the maximum limit of an entitlement is null, this value is returned as the maximum limit")] = None,
        expand: Annotated[Optional[StrictStr], Field(description="Specify additional plan data to retrieve. Use \"plans\".")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetBillingEntitlementsResponse:
        """Get billing entitlements

        Returns all the entitlements a billing customer currently has access to  <div>   <code>read:billing_entitlements</code> </div> 

        :param customer_id: The ID of the billing customer to retrieve entitlements for (required)
        :type customer_id: str
        :param page_size: Number of results per page. Defaults to 10 if parameter not sent.
        :type page_size: int
        :param starting_after: The ID of the billing entitlement to start after.
        :type starting_after: str
        :param ending_before: The ID of the billing entitlement to end before.
        :type ending_before: str
        :param max_value: When the maximum limit of an entitlement is null, this value is returned as the maximum limit
        :type max_value: str
        :param expand: Specify additional plan data to retrieve. Use \"plans\".
        :type expand: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_billing_entitlements_serialize(
            customer_id=customer_id,
            page_size=page_size,
            starting_after=starting_after,
            ending_before=ending_before,
            max_value=max_value,
            expand=expand,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBillingEntitlementsResponse",
            '400': "ErrorResponse",
            '403': "ErrorResponse",
            '429': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_billing_entitlements_with_http_info(
        self,
        customer_id: Annotated[StrictStr, Field(description="The ID of the billing customer to retrieve entitlements for")],
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page. Defaults to 10 if parameter not sent.")] = None,
        starting_after: Annotated[Optional[StrictStr], Field(description="The ID of the billing entitlement to start after.")] = None,
        ending_before: Annotated[Optional[StrictStr], Field(description="The ID of the billing entitlement to end before.")] = None,
        max_value: Annotated[Optional[StrictStr], Field(description="When the maximum limit of an entitlement is null, this value is returned as the maximum limit")] = None,
        expand: Annotated[Optional[StrictStr], Field(description="Specify additional plan data to retrieve. Use \"plans\".")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetBillingEntitlementsResponse]:
        """Get billing entitlements

        Returns all the entitlements a billing customer currently has access to  <div>   <code>read:billing_entitlements</code> </div> 

        :param customer_id: The ID of the billing customer to retrieve entitlements for (required)
        :type customer_id: str
        :param page_size: Number of results per page. Defaults to 10 if parameter not sent.
        :type page_size: int
        :param starting_after: The ID of the billing entitlement to start after.
        :type starting_after: str
        :param ending_before: The ID of the billing entitlement to end before.
        :type ending_before: str
        :param max_value: When the maximum limit of an entitlement is null, this value is returned as the maximum limit
        :type max_value: str
        :param expand: Specify additional plan data to retrieve. Use \"plans\".
        :type expand: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_billing_entitlements_serialize(
            customer_id=customer_id,
            page_size=page_size,
            starting_after=starting_after,
            ending_before=ending_before,
            max_value=max_value,
            expand=expand,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBillingEntitlementsResponse",
            '400': "ErrorResponse",
            '403': "ErrorResponse",
            '429': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_billing_entitlements_without_preload_content(
        self,
        customer_id: Annotated[StrictStr, Field(description="The ID of the billing customer to retrieve entitlements for")],
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page. Defaults to 10 if parameter not sent.")] = None,
        starting_after: Annotated[Optional[StrictStr], Field(description="The ID of the billing entitlement to start after.")] = None,
        ending_before: Annotated[Optional[StrictStr], Field(description="The ID of the billing entitlement to end before.")] = None,
        max_value: Annotated[Optional[StrictStr], Field(description="When the maximum limit of an entitlement is null, this value is returned as the maximum limit")] = None,
        expand: Annotated[Optional[StrictStr], Field(description="Specify additional plan data to retrieve. Use \"plans\".")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get billing entitlements

        Returns all the entitlements a billing customer currently has access to  <div>   <code>read:billing_entitlements</code> </div> 

        :param customer_id: The ID of the billing customer to retrieve entitlements for (required)
        :type customer_id: str
        :param page_size: Number of results per page. Defaults to 10 if parameter not sent.
        :type page_size: int
        :param starting_after: The ID of the billing entitlement to start after.
        :type starting_after: str
        :param ending_before: The ID of the billing entitlement to end before.
        :type ending_before: str
        :param max_value: When the maximum limit of an entitlement is null, this value is returned as the maximum limit
        :type max_value: str
        :param expand: Specify additional plan data to retrieve. Use \"plans\".
        :type expand: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_billing_entitlements_serialize(
            customer_id=customer_id,
            page_size=page_size,
            starting_after=starting_after,
            ending_before=ending_before,
            max_value=max_value,
            expand=expand,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBillingEntitlementsResponse",
            '400': "ErrorResponse",
            '403': "ErrorResponse",
            '429': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_billing_entitlements_serialize(
        self,
        customer_id,
        page_size,
        starting_after,
        ending_before,
        max_value,
        expand,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if starting_after is not None:
            
            _query_params.append(('starting_after', starting_after))
            
        if ending_before is not None:
            
            _query_params.append(('ending_before', ending_before))
            
        if customer_id is not None:
            
            _query_params.append(('customer_id', customer_id))
            
        if max_value is not None:
            
            _query_params.append(('max_value', max_value))
            
        if expand is not None:
            
            _query_params.append(('expand', expand))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json; charset=utf-8', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'kindeBearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/billing/entitlements',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


