# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CreateMeterUsageRecordRequest(BaseModel):
    """
    CreateMeterUsageRecordRequest
    """ # noqa: E501
    customer_agreement_id: StrictStr = Field(description="The billing agreement against which to record usage")
    billing_feature_code: StrictStr = Field(description="The code of the feature within the agreement against which to record usage")
    meter_value: StrictStr = Field(description="The value of usage to record")
    meter_usage_timestamp: Optional[datetime] = Field(default=None, description="The date and time the usage needs to be recorded for (defaults to current date/time)")
    meter_type_code: Optional[StrictStr] = Field(default=None, description="Absolutes overrides the current usage")
    __properties: ClassVar[List[str]] = ["customer_agreement_id", "billing_feature_code", "meter_value", "meter_usage_timestamp", "meter_type_code"]

    @field_validator('meter_type_code')
    def meter_type_code_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['absolute', 'delta']):
            raise ValueError("must be one of enum values ('absolute', 'delta')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateMeterUsageRecordRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateMeterUsageRecordRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "customer_agreement_id": obj.get("customer_agreement_id"),
            "billing_feature_code": obj.get("billing_feature_code"),
            "meter_value": obj.get("meter_value"),
            "meter_usage_timestamp": obj.get("meter_usage_timestamp"),
            "meter_type_code": obj.get("meter_type_code")
        })
        return _obj


