# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from kinde_sdk.management.models.get_api_response_api_applications_inner import GetApiResponseApiApplicationsInner
from kinde_sdk.management.models.get_api_response_api_scopes_inner import GetApiResponseApiScopesInner
from typing import Optional, Set
from typing_extensions import Self

class GetApiResponseApi(BaseModel):
    """
    GetApiResponseApi
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique ID of the API.")
    name: Optional[StrictStr] = Field(default=None, description="The API’s name.")
    audience: Optional[StrictStr] = Field(default=None, description="A unique identifier for the API - commonly the URL. This value will be used as the `audience` parameter in authorization claims.")
    is_management_api: Optional[StrictBool] = Field(default=None, description="Whether or not it is the Kinde management API.")
    scopes: Optional[List[GetApiResponseApiScopesInner]] = None
    applications: Optional[List[GetApiResponseApiApplicationsInner]] = None
    __properties: ClassVar[List[str]] = ["id", "name", "audience", "is_management_api", "scopes", "applications"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetApiResponseApi from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in scopes (list)
        _items = []
        if self.scopes:
            for _item_scopes in self.scopes:
                if _item_scopes:
                    _items.append(_item_scopes.to_dict())
            _dict['scopes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in applications (list)
        _items = []
        if self.applications:
            for _item_applications in self.applications:
                if _item_applications:
                    _items.append(_item_applications.to_dict())
            _dict['applications'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetApiResponseApi from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "audience": obj.get("audience"),
            "is_management_api": obj.get("is_management_api"),
            "scopes": [GetApiResponseApiScopesInner.from_dict(_item) for _item in obj["scopes"]] if obj.get("scopes") is not None else None,
            "applications": [GetApiResponseApiApplicationsInner.from_dict(_item) for _item in obj["applications"]] if obj.get("applications") is not None else None
        })
        return _obj


