# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from kinde_sdk.management.models.get_apis_response_apis_inner_scopes_inner import GetApisResponseApisInnerScopesInner
from typing import Optional, Set
from typing_extensions import Self

class GetApisResponseApisInner(BaseModel):
    """
    GetApisResponseApisInner
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The unique ID for the API.")
    name: Optional[StrictStr] = Field(default=None, description="The API’s name.")
    audience: Optional[StrictStr] = Field(default=None, description="A unique identifier for the API - commonly the URL. This value will be used as the `audience` parameter in authorization claims.")
    is_management_api: Optional[StrictBool] = Field(default=None, description="Whether or not it is the Kinde management API.")
    scopes: Optional[List[GetApisResponseApisInnerScopesInner]] = None
    __properties: ClassVar[List[str]] = ["id", "name", "audience", "is_management_api", "scopes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetApisResponseApisInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in scopes (list)
        _items = []
        if self.scopes:
            for _item_scopes in self.scopes:
                if _item_scopes:
                    _items.append(_item_scopes.to_dict())
            _dict['scopes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetApisResponseApisInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "audience": obj.get("audience"),
            "is_management_api": obj.get("is_management_api"),
            "scopes": [GetApisResponseApisInnerScopesInner.from_dict(_item) for _item in obj["scopes"]] if obj.get("scopes") is not None else None
        })
        return _obj


