# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class GetBusinessResponseBusiness(BaseModel):
    """
    GetBusinessResponseBusiness
    """ # noqa: E501
    code: Optional[StrictStr] = Field(default=None, description="The unique ID for the business.")
    name: Optional[StrictStr] = Field(default=None, description="Your business's name.")
    phone: Optional[StrictStr] = Field(default=None, description="Phone number associated with business.")
    email: Optional[StrictStr] = Field(default=None, description="Email address associated with business.")
    industry: Optional[StrictStr] = Field(default=None, description="The industry your business is in.")
    timezone: Optional[StrictStr] = Field(default=None, description="The timezone your business is in.")
    privacy_url: Optional[StrictStr] = Field(default=None, description="Your Privacy policy URL.")
    terms_url: Optional[StrictStr] = Field(default=None, description="Your Terms and Conditions URL.")
    has_clickwrap: Optional[StrictBool] = Field(default=None, description="Whether your business uses clickwrap agreements.")
    has_kinde_branding: Optional[StrictBool] = Field(default=None, description="Whether your business shows Kinde branding.")
    created_on: Optional[StrictStr] = Field(default=None, description="Date of business creation in ISO 8601 format.")
    __properties: ClassVar[List[str]] = ["code", "name", "phone", "email", "industry", "timezone", "privacy_url", "terms_url", "has_clickwrap", "has_kinde_branding", "created_on"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetBusinessResponseBusiness from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if phone (nullable) is None
        # and model_fields_set contains the field
        if self.phone is None and "phone" in self.model_fields_set:
            _dict['phone'] = None

        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if industry (nullable) is None
        # and model_fields_set contains the field
        if self.industry is None and "industry" in self.model_fields_set:
            _dict['industry'] = None

        # set to None if timezone (nullable) is None
        # and model_fields_set contains the field
        if self.timezone is None and "timezone" in self.model_fields_set:
            _dict['timezone'] = None

        # set to None if privacy_url (nullable) is None
        # and model_fields_set contains the field
        if self.privacy_url is None and "privacy_url" in self.model_fields_set:
            _dict['privacy_url'] = None

        # set to None if terms_url (nullable) is None
        # and model_fields_set contains the field
        if self.terms_url is None and "terms_url" in self.model_fields_set:
            _dict['terms_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetBusinessResponseBusiness from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "code": obj.get("code"),
            "name": obj.get("name"),
            "phone": obj.get("phone"),
            "email": obj.get("email"),
            "industry": obj.get("industry"),
            "timezone": obj.get("timezone"),
            "privacy_url": obj.get("privacy_url"),
            "terms_url": obj.get("terms_url"),
            "has_clickwrap": obj.get("has_clickwrap"),
            "has_kinde_branding": obj.get("has_kinde_branding"),
            "created_on": obj.get("created_on")
        })
        return _obj


