# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SetUserPasswordRequest(BaseModel):
    """
    SetUserPasswordRequest
    """ # noqa: E501
    hashed_password: StrictStr = Field(description="The hashed password.")
    hashing_method: Optional[StrictStr] = Field(default=None, description="The hashing method or algorithm used to encrypt the user’s password. Default is bcrypt.")
    salt: Optional[StrictStr] = Field(default=None, description="Extra characters added to passwords to make them stronger. Not required for bcrypt.")
    salt_position: Optional[StrictStr] = Field(default=None, description="Position of salt in password string. Not required for bcrypt.")
    is_temporary_password: Optional[StrictBool] = Field(default=None, description="The user will be prompted to set a new password after entering this one.")
    __properties: ClassVar[List[str]] = ["hashed_password", "hashing_method", "salt", "salt_position", "is_temporary_password"]

    @field_validator('hashing_method')
    def hashing_method_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['bcrypt', 'crypt', 'md5', 'wordpress']):
            raise ValueError("must be one of enum values ('bcrypt', 'crypt', 'md5', 'wordpress')")
        return value

    @field_validator('salt_position')
    def salt_position_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['prefix', 'suffix']):
            raise ValueError("must be one of enum values ('prefix', 'suffix')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SetUserPasswordRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SetUserPasswordRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "hashed_password": obj.get("hashed_password"),
            "hashing_method": obj.get("hashing_method"),
            "salt": obj.get("salt"),
            "salt_position": obj.get("salt_position"),
            "is_temporary_password": obj.get("is_temporary_password")
        })
        return _obj


