# coding: utf-8

"""
    Kinde Management API

     Provides endpoints to manage your Kinde Businesses.  ## Intro  ## How to use  1. [Set up and authorize a machine-to-machine (M2M) application](https://docs.kinde.com/developer-tools/kinde-api/connect-to-kinde-api/).  2. [Generate a test access token](https://docs.kinde.com/developer-tools/kinde-api/access-token-for-api/)  3. Test request any endpoint using the test token 

    The version of the OpenAPI document: 1
    Contact: support@kinde.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from kinde_sdk.management.models.create_connection_request_options_one_of import CreateConnectionRequestOptionsOneOf
from kinde_sdk.management.models.replace_connection_request_options_one_of1 import ReplaceConnectionRequestOptionsOneOf1
from kinde_sdk.management.models.update_connection_request_options_one_of import UpdateConnectionRequestOptionsOneOf
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

UPDATECONNECTIONREQUESTOPTIONS_ONE_OF_SCHEMAS = ["CreateConnectionRequestOptionsOneOf", "ReplaceConnectionRequestOptionsOneOf1", "UpdateConnectionRequestOptionsOneOf"]

class UpdateConnectionRequestOptions(BaseModel):
    """
    UpdateConnectionRequestOptions
    """
    # data type: CreateConnectionRequestOptionsOneOf
    oneof_schema_1_validator: Optional[CreateConnectionRequestOptionsOneOf] = None
    # data type: UpdateConnectionRequestOptionsOneOf
    oneof_schema_2_validator: Optional[UpdateConnectionRequestOptionsOneOf] = None
    # data type: ReplaceConnectionRequestOptionsOneOf1
    oneof_schema_3_validator: Optional[ReplaceConnectionRequestOptionsOneOf1] = None
    actual_instance: Optional[Union[CreateConnectionRequestOptionsOneOf, ReplaceConnectionRequestOptionsOneOf1, UpdateConnectionRequestOptionsOneOf]] = None
    one_of_schemas: Set[str] = { "CreateConnectionRequestOptionsOneOf", "ReplaceConnectionRequestOptionsOneOf1", "UpdateConnectionRequestOptionsOneOf" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = UpdateConnectionRequestOptions.model_construct()
        error_messages = []
        match = 0
        # validate data type: CreateConnectionRequestOptionsOneOf
        if not isinstance(v, CreateConnectionRequestOptionsOneOf):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CreateConnectionRequestOptionsOneOf`")
        else:
            match += 1
        # validate data type: UpdateConnectionRequestOptionsOneOf
        if not isinstance(v, UpdateConnectionRequestOptionsOneOf):
            error_messages.append(f"Error! Input type `{type(v)}` is not `UpdateConnectionRequestOptionsOneOf`")
        else:
            match += 1
        # validate data type: ReplaceConnectionRequestOptionsOneOf1
        if not isinstance(v, ReplaceConnectionRequestOptionsOneOf1):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ReplaceConnectionRequestOptionsOneOf1`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in UpdateConnectionRequestOptions with oneOf schemas: CreateConnectionRequestOptionsOneOf, ReplaceConnectionRequestOptionsOneOf1, UpdateConnectionRequestOptionsOneOf. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in UpdateConnectionRequestOptions with oneOf schemas: CreateConnectionRequestOptionsOneOf, ReplaceConnectionRequestOptionsOneOf1, UpdateConnectionRequestOptionsOneOf. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into CreateConnectionRequestOptionsOneOf
        try:
            instance.actual_instance = CreateConnectionRequestOptionsOneOf.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into UpdateConnectionRequestOptionsOneOf
        try:
            instance.actual_instance = UpdateConnectionRequestOptionsOneOf.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ReplaceConnectionRequestOptionsOneOf1
        try:
            instance.actual_instance = ReplaceConnectionRequestOptionsOneOf1.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into UpdateConnectionRequestOptions with oneOf schemas: CreateConnectionRequestOptionsOneOf, ReplaceConnectionRequestOptionsOneOf1, UpdateConnectionRequestOptionsOneOf. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into UpdateConnectionRequestOptions with oneOf schemas: CreateConnectionRequestOptionsOneOf, ReplaceConnectionRequestOptionsOneOf1, UpdateConnectionRequestOptionsOneOf. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], CreateConnectionRequestOptionsOneOf, ReplaceConnectionRequestOptionsOneOf1, UpdateConnectionRequestOptionsOneOf]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


