# Pyrogram - Telegram MTProto API Client Library for Python
# Copyright (C) 2017-2019 Dan Tès <https://github.com/delivrance>
#
# This file is part of Pyrogram.
#
# Pyrogram is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Pyrogram is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from pyrogram.api.core import *


class Contact(Object):
    """Attributes:
        ID: ``0xf911c994``

    Args:
        user_id: ``int`` ``32-bit``
        mutual: ``bool``
    """

    ID = 0xf911c994

    def __init__(self, user_id: int, mutual: bool):
        self.user_id = user_id  # int
        self.mutual = mutual  # Bool

    @staticmethod
    def read(b: BytesIO, *args) -> "Contact":
        # No flags
        
        user_id = Int.read(b)
        
        mutual = Bool.read(b)
        
        return Contact(user_id, mutual)

    def write(self) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        # No flags
        
        b.write(Int(self.user_id))
        
        b.write(Bool(self.mutual))
        
        return b.getvalue()
