import numpy as np
import panda3d_viewer.viewer_proxy
import pinocchio as pin
from _typeshed import Incomplete
from panda3d.core import DisplayRegion as DisplayRegion, Geom, Lens as Lens, NodePath
from panda3d_viewer.viewer_config import ViewerConfig
from pinocchio.visualize import BaseVisualizer
from typing import Any, Callable, Dict, Iterable, Optional, Sequence, Tuple, Union

WINDOW_SIZE_DEFAULT: Incomplete
CAMERA_POS_DEFAULT: Incomplete
LEGEND_DPI: int
LEGEND_SCALE_MAX: float
WATERMARK_SCALE_MAX: float
CLOCK_SCALE: float
WIDGET_MARGIN_REL: float
PANDA3D_FRAMERATE_MAX: int
Tuple3FType = Union[Tuple[float, float, float], np.ndarray]
Tuple4FType = Union[Tuple[float, float, float, float], np.ndarray]
ShapeType: Incomplete
FrameType = Union[Tuple[Tuple3FType, Tuple4FType], np.ndarray]

def make_gradient_skybox(sky_color: Tuple4FType, ground_color: Tuple4FType, span: float = ..., offset: float = ..., subdiv: int = ...) -> NodePath: ...
def make_cone(num_sides: int = ...) -> Geom: ...
def make_heightmap(heightmap: np.ndarray) -> Geom: ...

class Panda3dApp(panda3d_viewer.viewer_app.ViewerApp):
    buff: Incomplete
    clock: Incomplete
    framerate: Incomplete
    skybox: Incomplete
    shared_render_2d: Incomplete
    offscreen_camera_2d: Incomplete
    offAspect2d: Incomplete
    offA2dTopLeft: Incomplete
    offA2dTopRight: Incomplete
    offA2dBottomLeft: Incomplete
    offA2dBottomCenter: Incomplete
    offA2dBottomRight: Incomplete
    offscreen_graphics_lens: Incomplete
    offscreen_display_region: Incomplete
    key_map: Incomplete
    zoom_rate: float
    camera_lookat: Incomplete
    longitude_deg: float
    latitude_deg: float
    last_mouse_x: float
    last_mouse_y: float
    picker_ray: Incomplete
    picker_node: Incomplete
    picked_object: Incomplete
    click_mouse_x: float
    click_mouse_y: float
    def __init__(self, config: Optional[ViewerConfig] = ...) -> None: ...
    def has_gui(self) -> bool: ...
    windowType: str
    picker_traverser: Incomplete
    picker_queue: Incomplete
    def open_window(self) -> None: ...
    def getSize(self, win: Optional[Any] = ...) -> Tuple[int, int]: ...
    def getMousePos(self) -> Tuple[float, float]: ...
    def handle_key(self, key: str, value: bool) -> None: ...
    def click_on_node(self) -> None: ...
    def move_orbital_camera_task(self, task: Optional[Any] = ...) -> Optional[int]: ...
    def show_floor(self, show: bool) -> None: ...
    def update_floor(self, heightmap: Optional[np.ndarray] = ..., show_meshes: bool = ...) -> NodePath: ...
    def append_group(self, root_path: str, remove_if_exists: bool = ..., scale: float = ...) -> None: ...
    def append_node(self, root_path: str, name: str, node: NodePath, frame: Optional[FrameType] = ...) -> None: ...
    def highlight_node(self, root_path: str, name: str, enable: bool) -> None: ...
    def append_frame(self, root_path: str, name: str, frame: Optional[FrameType] = ...) -> None: ...
    def append_cone(self, root_path: str, name: str, radius: float, length: float, num_sides: int = ..., frame: Optional[FrameType] = ...) -> None: ...
    def append_cylinder(self, root_path: str, name: str, radius: float, length: float, anchor_bottom: bool = ..., frame: Optional[FrameType] = ...) -> None: ...
    def append_arrow(self, root_path: str, name: str, radius: float, length: float, frame: Optional[FrameType] = ...) -> None: ...
    def append_mesh(self, root_path: str, name: str, mesh_path: str, scale: Optional[Tuple3FType] = ..., frame: Optional[FrameType] = ..., no_cache: Optional[bool] = ...) -> None: ...
    def set_watermark(self, img_fullpath: Optional[str] = ..., width: Optional[int] = ..., height: Optional[int] = ...) -> None: ...
    def set_legend(self, items: Optional[Sequence[Tuple[str, Optional[Sequence[int]]]]] = ...) -> None: ...
    def set_clock(self, time: Optional[float] = ...) -> None: ...
    def set_material(self, root_path: str, name: str, color: Optional[Tuple4FType] = ..., texture_path: str = ..., disable_material: Optional[bool] = ...) -> None: ...
    def set_scale(self, root_path: str, name: str, scale: Tuple3FType) -> None: ...
    def set_scales(self, root_path: str, name_scales_dict: Dict[str, Tuple3FType]) -> None: ...
    def move_node(self, root_path: str, name: str, frame: FrameType) -> None: ...
    def remove_node(self, root_path: str, name: str) -> None: ...
    def show_node(self, root_path: str, name: str, show: bool, always_foreground: Optional[bool] = ...) -> None: ...
    def get_camera_transform(self) -> Tuple[np.ndarray, np.ndarray]: ...
    def set_camera_transform(self, pos: Tuple3FType, quat: np.ndarray, lookat: Tuple3FType = ...) -> None: ...
    def set_camera_lookat(self, pos: Tuple3FType) -> None: ...
    def set_window_size(self, width: int, height: int) -> None: ...
    def set_framerate(self, framerate: Optional[float] = ...) -> None: ...
    def get_framerate(self) -> Optional[float]: ...
    def save_screenshot(self, filename: Optional[str] = ...) -> bool: ...
    def get_screenshot(self, requested_format: str = ..., raw: bool = ...) -> Union[np.ndarray, bytes]: ...
    def enable_shadow(self, enable: bool) -> None: ...

class Panda3dProxy(panda3d_viewer.viewer_proxy.ViewerAppProxy):
    def __getattr__(self, name: str) -> Callable[..., Any]: ...
    def run(self) -> None: ...

class Panda3dViewer(panda3d_viewer.viewer.Viewer):
    def __getattr__(self, name: str) -> Any: ...
    def __dir__(self) -> Iterable[str]: ...
    def set_material(self, *args: Any, **kwargs: Any) -> None: ...
    def append_frame(self, *args: Any, **kwargs: Any) -> None: ...
    def append_cylinder(self, *args: Any, **kwargs: Any) -> None: ...
    def save_screenshot(self, filename: Optional[str] = ...) -> bool: ...
    def get_screenshot(self, requested_format: str = ..., raw: bool = ...) -> Union[np.ndarray, bytes]: ...

class Panda3dVisualizer(BaseVisualizer):
    visual_group: Incomplete
    collision_group: Incomplete
    display_visuals: bool
    display_collisions: bool
    viewer: Incomplete
    def initViewer(self, viewer: Optional[Union[Panda3dViewer, Panda3dApp]] = ..., loadModel: bool = ..., **kwargs: Any) -> None: ...
    def getViewerNodeName(self, geometry_object: pin.GeometryObject, geometry_type: pin.GeometryType) -> Tuple[str, str]: ...
    def loadViewerGeometryObject(self, geometry_object: pin.GeometryObject, geometry_type: pin.GeometryType, color: Optional[np.ndarray] = ...) -> None: ...
    root_name: Incomplete
    def loadViewerModel(self, root_node_name: str, color: Optional[np.ndarray] = ...) -> None: ...
    def display(self, q: np.ndarray) -> None: ...
    def displayCollisions(self, visibility: bool) -> None: ...
    def displayVisuals(self, visibility: bool) -> None: ...
