# coding: utf-8

"""
    Asteroid Agents API

    Version 1 of the Asteroid Agents API

    The version of the OpenAPI document: v1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from asteroid_odyssey.agents_v1_gen.models.cookie import Cookie
from asteroid_odyssey.agents_v1_gen.models.country_code import CountryCode
from asteroid_odyssey.agents_v1_gen.models.credential import Credential
from asteroid_odyssey.agents_v1_gen.models.proxy_type import ProxyType
from typing import Optional, Set
from typing_extensions import Self

class AgentProfile(BaseModel):
    """
    AgentProfile
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier for the agent profile")
    name: StrictStr = Field(description="Name of the agent profile (unique within organization)")
    description: StrictStr = Field(description="Description of the agent profile")
    organization_id: StrictStr = Field(description="The ID of the organization that the agent profile belongs to")
    proxy_cc: Optional[CountryCode] = None
    proxy_type: Optional[ProxyType] = None
    captcha_solver_active: StrictBool = Field(description="Whether the captcha solver is active for this profile")
    sticky_ip: StrictBool = Field(description="Whether the same IP address should be used for all executions of this profile")
    credentials: List[Credential] = Field(description="List of credentials associated with this agent profile")
    cookies: List[Cookie] = Field(description="List of cookies associated with this agent profile")
    created_at: datetime = Field(description="The date and time the agent profile was created")
    updated_at: datetime = Field(description="The last update time of the agent profile")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "organization_id", "proxy_cc", "proxy_type", "captcha_solver_active", "sticky_ip", "credentials", "cookies", "created_at", "updated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AgentProfile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in credentials (list)
        _items = []
        if self.credentials:
            for _item_credentials in self.credentials:
                if _item_credentials:
                    _items.append(_item_credentials.to_dict())
            _dict['credentials'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cookies (list)
        _items = []
        if self.cookies:
            for _item_cookies in self.cookies:
                if _item_cookies:
                    _items.append(_item_cookies.to_dict())
            _dict['cookies'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AgentProfile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "organization_id": obj.get("organization_id"),
            "proxy_cc": obj.get("proxy_cc"),
            "proxy_type": obj.get("proxy_type"),
            "captcha_solver_active": obj.get("captcha_solver_active"),
            "sticky_ip": obj.get("sticky_ip"),
            "credentials": [Credential.from_dict(_item) for _item in obj["credentials"]] if obj.get("credentials") is not None else None,
            "cookies": [Cookie.from_dict(_item) for _item in obj["cookies"]] if obj.get("cookies") is not None else None,
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


