# coding: utf-8

"""
    Asteroid Agents API

    Version 1 of the Asteroid Agents API

    The version of the OpenAPI document: v1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from asteroid_odyssey.agents_v1_gen.models.cookie import Cookie
from asteroid_odyssey.agents_v1_gen.models.country_code import CountryCode
from asteroid_odyssey.agents_v1_gen.models.credential import Credential
from asteroid_odyssey.agents_v1_gen.models.proxy_type import ProxyType
from typing import Optional, Set
from typing_extensions import Self

class UpdateAgentProfileRequest(BaseModel):
    """
    UpdateAgentProfileRequest
    """ # noqa: E501
    name: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=255)]] = Field(default=None, description="The name of the agent profile")
    description: Optional[Annotated[str, Field(strict=True, max_length=1000)]] = Field(default=None, description="The description of the agent profile")
    proxy_cc: Optional[CountryCode] = None
    proxy_type: Optional[ProxyType] = None
    captcha_solver_active: Optional[StrictBool] = Field(default=None, description="Whether the captcha solver should be active for this profile")
    sticky_ip: Optional[StrictBool] = Field(default=None, description="Whether the same IP address should be used for all executions of this profile")
    credentials_to_add: Optional[List[Credential]] = Field(default=None, description="List of credentials to add to the profile")
    credentials_to_delete: Optional[List[StrictStr]] = Field(default=None, description="List of credential IDs to delete from the profile")
    cookies_to_add: Optional[List[Cookie]] = Field(default=None, description="List of cookies to add to the profile")
    cookies_to_delete: Optional[List[StrictStr]] = Field(default=None, description="List of cookie IDs to delete from the profile")
    __properties: ClassVar[List[str]] = ["name", "description", "proxy_cc", "proxy_type", "captcha_solver_active", "sticky_ip", "credentials_to_add", "credentials_to_delete", "cookies_to_add", "cookies_to_delete"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateAgentProfileRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in credentials_to_add (list)
        _items = []
        if self.credentials_to_add:
            for _item_credentials_to_add in self.credentials_to_add:
                if _item_credentials_to_add:
                    _items.append(_item_credentials_to_add.to_dict())
            _dict['credentials_to_add'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cookies_to_add (list)
        _items = []
        if self.cookies_to_add:
            for _item_cookies_to_add in self.cookies_to_add:
                if _item_cookies_to_add:
                    _items.append(_item_cookies_to_add.to_dict())
            _dict['cookies_to_add'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateAgentProfileRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "proxy_cc": obj.get("proxy_cc"),
            "proxy_type": obj.get("proxy_type"),
            "captcha_solver_active": obj.get("captcha_solver_active"),
            "sticky_ip": obj.get("sticky_ip"),
            "credentials_to_add": [Credential.from_dict(_item) for _item in obj["credentials_to_add"]] if obj.get("credentials_to_add") is not None else None,
            "credentials_to_delete": obj.get("credentials_to_delete"),
            "cookies_to_add": [Cookie.from_dict(_item) for _item in obj["cookies_to_add"]] if obj.get("cookies_to_add") is not None else None,
            "cookies_to_delete": obj.get("cookies_to_delete")
        })
        return _obj


