"""
Module containing rdFreeSASA classes and functions.
"""
from __future__ import annotations
import rdkit.Chem
import typing
__all__ = ['APolar', 'CalcSASA', 'LeeRichards', 'MakeFreeSasaAPolarAtomQuery', 'MakeFreeSasaPolarAtomQuery', 'NACCESS', 'OONS', 'Polar', 'Protor', 'SASAAlgorithm', 'SASAClass', 'SASAClassifier', 'SASAOpts', 'ShrakeRupley', 'Unclassified', 'classifyAtoms']
class SASAAlgorithm(Boost.Python.enum):
    LeeRichards: typing.ClassVar[SASAAlgorithm]  # value = rdkit.Chem.rdFreeSASA.SASAAlgorithm.LeeRichards
    ShrakeRupley: typing.ClassVar[SASAAlgorithm]  # value = rdkit.Chem.rdFreeSASA.SASAAlgorithm.ShrakeRupley
    __slots__: typing.ClassVar[tuple] = tuple()
    names: typing.ClassVar[dict]  # value = {'LeeRichards': rdkit.Chem.rdFreeSASA.SASAAlgorithm.LeeRichards, 'ShrakeRupley': rdkit.Chem.rdFreeSASA.SASAAlgorithm.ShrakeRupley}
    values: typing.ClassVar[dict]  # value = {0: rdkit.Chem.rdFreeSASA.SASAAlgorithm.LeeRichards, 1: rdkit.Chem.rdFreeSASA.SASAAlgorithm.ShrakeRupley}
class SASAClass(Boost.Python.enum):
    APolar: typing.ClassVar[SASAClass]  # value = rdkit.Chem.rdFreeSASA.SASAClass.APolar
    Polar: typing.ClassVar[SASAClass]  # value = rdkit.Chem.rdFreeSASA.SASAClass.Polar
    Unclassified: typing.ClassVar[SASAClass]  # value = rdkit.Chem.rdFreeSASA.SASAClass.Unclassified
    __slots__: typing.ClassVar[tuple] = tuple()
    names: typing.ClassVar[dict]  # value = {'Unclassified': rdkit.Chem.rdFreeSASA.SASAClass.Unclassified, 'APolar': rdkit.Chem.rdFreeSASA.SASAClass.APolar, 'Polar': rdkit.Chem.rdFreeSASA.SASAClass.Polar}
    values: typing.ClassVar[dict]  # value = {0: rdkit.Chem.rdFreeSASA.SASAClass.Unclassified, 1: rdkit.Chem.rdFreeSASA.SASAClass.APolar, 2: rdkit.Chem.rdFreeSASA.SASAClass.Polar}
class SASAClassifier(Boost.Python.enum):
    NACCESS: typing.ClassVar[SASAClassifier]  # value = rdkit.Chem.rdFreeSASA.SASAClassifier.NACCESS
    OONS: typing.ClassVar[SASAClassifier]  # value = rdkit.Chem.rdFreeSASA.SASAClassifier.OONS
    Protor: typing.ClassVar[SASAClassifier]  # value = rdkit.Chem.rdFreeSASA.SASAClassifier.Protor
    __slots__: typing.ClassVar[tuple] = tuple()
    names: typing.ClassVar[dict]  # value = {'Protor': rdkit.Chem.rdFreeSASA.SASAClassifier.Protor, 'NACCESS': rdkit.Chem.rdFreeSASA.SASAClassifier.NACCESS, 'OONS': rdkit.Chem.rdFreeSASA.SASAClassifier.OONS}
    values: typing.ClassVar[dict]  # value = {0: rdkit.Chem.rdFreeSASA.SASAClassifier.Protor, 1: rdkit.Chem.rdFreeSASA.SASAClassifier.NACCESS, 2: rdkit.Chem.rdFreeSASA.SASAClassifier.OONS}
class SASAOpts(Boost.Python.instance):
    """
    """
    __instance_size__: typing.ClassVar[int] = 40
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    @typing.overload
    def __init__(self) -> None:
        """
            Constructor takes no arguments
        
            C++ signature :
                void __init__(_object*)
        """
    @typing.overload
    def __init__(self, alg: SASAAlgorithm, cls: SASAClassifier) -> None:
        """
            C++ signature :
                void __init__(_object*,FreeSASA::SASAOpts::Algorithm,FreeSASA::SASAOpts::Classifier)
        """
    @typing.overload
    def __init__(self, alg: SASAAlgorithm, cls: SASAClassifier, pr: float) -> None:
        """
            C++ signature :
                void __init__(_object*,FreeSASA::SASAOpts::Algorithm,FreeSASA::SASAOpts::Classifier,double)
        """
    @property
    def algorithm(*args, **kwargs):
        ...
    @algorithm.setter
    def algorithm(*args, **kwargs):
        ...
    @property
    def classifier(*args, **kwargs):
        ...
    @classifier.setter
    def classifier(*args, **kwargs):
        ...
    @property
    def probeRadius(*args, **kwargs):
        ...
    @probeRadius.setter
    def probeRadius(*args, **kwargs):
        ...
def CalcSASA(mol: Mol, radii: typing.Any, confIdx: int = -1, query: Atom = None, opts: SASAOpts = ...) -> float:
    """
        Compute the Solvent Accessible Surface Area using the FreeSASA library
        ARGUMENTS:
          - mol: The molecule to compute.
          - radii:  A list of atom raddii where radii[atom.GetIdx()] is the radius of the atom
                    These can be passed in or calculated with classifyAtoms for some proteins
          - confIdx: Specify the conformer to use for the 3D geometry  [default -1]
          - query: Pass along a query atom to compute the SASA for a subset of atoms.
                   precanned query atoms can be made with MakeFreeSasaPolarAtomQuery and
                   MakeFreeSasaAPolarAtomQuery for classified polar and apolar atoms respectively.
          - opts: a SASAOpts class specifying the algorithm to use
        
        RETURNS:
        The computed solvent accessible surface area.
        
    
        C++ signature :
            double CalcSASA(RDKit::ROMol,boost::python::api::object [,int=-1 [,RDKit::Atom const*=None [,FreeSASA::SASAOpts=<rdkit.Chem.rdFreeSASA.SASAOpts object at 0x10625e970>]]])
    """
def MakeFreeSasaAPolarAtomQuery() -> rdkit.Chem.QueryAtom:
    """
        Returns an APolar atom query for use with CalcSASA.  An apolar atom has the SASAClass
        and SASAClassName set to the APOLAR class.  (see classifyAtoms)
    
        C++ signature :
            RDKit::QueryAtom const* MakeFreeSasaAPolarAtomQuery()
    """
def MakeFreeSasaPolarAtomQuery() -> rdkit.Chem.QueryAtom:
    """
        Returns a polar atom query for use with CalcSASA.  An polar atom has the SASAClass
        and SASAClassName set to the POLAR class.  (see classifyAtoms)
    
        C++ signature :
            RDKit::QueryAtom const* MakeFreeSasaPolarAtomQuery()
    """
def classifyAtoms(mol: Mol, options: SASAOpts = ...) -> typing.Any:
    """
        Classify the atoms in the molecule returning their radii if possible.
        ARGUMENTS:
           - mol: molecule to classify
           - options: FreeSASA options class specifying the classification method.
                       Current classifiers are Protor, NACCESS and OONS
                       classification is stored as atom property 'SASAClass' for the integer value
                        and 'SASAClassName' for the string name of the class, Polar, APolar...
        
        RETURNS:
          list of radii where radii[atom.GetIdx()] is the radii of the atom.
          If classification fails, NONE is returned
        
    
        C++ signature :
            boost::python::api::object classifyAtoms(RDKit::ROMol {lvalue} [,FreeSASA::SASAOpts=<rdkit.Chem.rdFreeSASA.SASAOpts object at 0x10625e900>])
    """
APolar: SASAClass  # value = rdkit.Chem.rdFreeSASA.SASAClass.APolar
LeeRichards: SASAAlgorithm  # value = rdkit.Chem.rdFreeSASA.SASAAlgorithm.LeeRichards
NACCESS: SASAClassifier  # value = rdkit.Chem.rdFreeSASA.SASAClassifier.NACCESS
OONS: SASAClassifier  # value = rdkit.Chem.rdFreeSASA.SASAClassifier.OONS
Polar: SASAClass  # value = rdkit.Chem.rdFreeSASA.SASAClass.Polar
Protor: SASAClassifier  # value = rdkit.Chem.rdFreeSASA.SASAClassifier.Protor
ShrakeRupley: SASAAlgorithm  # value = rdkit.Chem.rdFreeSASA.SASAAlgorithm.ShrakeRupley
Unclassified: SASAClass  # value = rdkit.Chem.rdFreeSASA.SASAClass.Unclassified
