
"""
SIM_Machine_Model.py

Machine-generated model code

[Generated by:]
         GOV_F = GOV_LAG_F +GOV_T -GOV_DEM_GOOD                       # [F] Financial assets
     GOV_LAG_F = GOV_F (k -1 )                                        # [LAG_F] Previous periods financial assets.
         GOV_T = TF_T                                                 # [T] Tax revenue received.
   HH_AfterTax = HH_PreTax -HH_T                                      # [AfterTax] Aftertax income
   HH_AlphaFin = 0.4000                                               # [AlphaFin] Parameter for consumption out of financial assets
HH_AlphaIncome = 0.6000                                               # [AlphaIncome] Parameter for consumption out of income
   HH_DEM_GOOD = HH_AlphaIncome *HH_AfterTax +HH_AlphaFin *HH_LAG_F   # [DEM_GOOD] Expenditure on goods consumption
          HH_F = HH_LAG_F -HH_T +HH_SUP_LAB -HH_DEM_GOOD              # [F] Financial assets
      HH_LAG_F = HH_F (k -1 )                                         # [LAG_F] Previous periods financial assets.
     HH_PreTax = HH_SUP_LAB                                           # [PreTax] Pretax income
    HH_SUP_LAB = BUS_DEM_LAB                                          # [SUP_LAB] Supply of Labour
          HH_T = TF_T                                                 # [T] Taxes paid.
   BUS_DEM_LAB = GOOD_SUP_GOOD                                        # [DEM_LAB] Demand for labour
         BUS_F = BUS_LAG_F -BUS_DEM_LAB +BUS_SUP_GOOD                 # [F] Financial assets
     BUS_LAG_F = BUS_F (k -1 )                                        # [LAG_F] Previous periods financial assets.
  BUS_SUP_GOOD = GOV_DEM_GOOD +HH_DEM_GOOD                            # [SUP_GOOD] Supply of goods
          TF_T = TF_TaxRate *HH_SUP_LAB                               # [T] Taxes Paid
    TF_TaxRate = 0.2000                                               # [TaxRate] Tax rate
   LAB_DEM_LAB = BUS_DEM_LAB                                          # [DEM_LAB] Demand for Market LAB
   LAB_SUP_LAB = LAB_DEM_LAB                                          # [SUP_LAB] Supply for Market LAB
 GOOD_DEM_GOOD = GOV_DEM_GOOD +HH_DEM_GOOD                            # [DEM_GOOD] Demand for Market GOOD
 GOOD_SUP_GOOD = GOOD_DEM_GOOD                                        # [SUP_GOOD] Supply for Market GOOD

# Exogenous Variables

  GOV_DEM_GOOD =  [20. ,]*5 +[25. ,]*100                              # [DEM_GOOD] Government Consumption of Goods

MaxTime = 100
Err_Tolerance=0.001
"""

from sfc_models.base_solver import BaseSolver


class SFCModel(BaseSolver):
    """
    Model

    Implements the following system of equations.

    Endogenous variables and parameters
    ===================================
    GOV_F = GOV_LAG_F +GOV_T -GOV_DEM_GOOD,
    GOV_T = TF_T,
    HH_AfterTax = HH_PreTax -HH_T,
    HH_AlphaFin = 0.4000,
    HH_AlphaIncome = 0.6000,
    HH_DEM_GOOD = HH_AlphaIncome *HH_AfterTax +HH_AlphaFin *HH_LAG_F,
    HH_F = HH_LAG_F -HH_T +HH_SUP_LAB -HH_DEM_GOOD,
    HH_PreTax = HH_SUP_LAB,
    HH_SUP_LAB = BUS_DEM_LAB,
    HH_T = TF_T,
    BUS_DEM_LAB = GOOD_SUP_GOOD,
    BUS_F = BUS_LAG_F -BUS_DEM_LAB +BUS_SUP_GOOD,
    BUS_SUP_GOOD = GOV_DEM_GOOD +HH_DEM_GOOD,
    TF_T = TF_TaxRate *HH_SUP_LAB,
    TF_TaxRate = 0.2000,
    LAB_DEM_LAB = BUS_DEM_LAB,
    LAB_SUP_LAB = LAB_DEM_LAB,
    GOOD_DEM_GOOD = GOV_DEM_GOOD +HH_DEM_GOOD,
    GOOD_SUP_GOOD = GOOD_DEM_GOOD,
    t = t_minus_1 + 1.0.
    Where lagged variables are:
    GOV_LAG_F(t) = GOV_F(k-1),
    HH_LAG_F(t) = HH_F(k-1),
    BUS_LAG_F(t) = BUS_F(k-1),
    t_minus_1(t) = t(k-1).
    
    
    Exogenous Variables
    ===================
    GOV_DEM_GOOD.

    """
    def __init__(self):
        BaseSolver.__init__(self, ['GOV_F', 'GOV_T', 'HH_AfterTax', 'HH_AlphaFin', 'HH_AlphaIncome', 'HH_DEM_GOOD', 'HH_F', 'HH_PreTax', 'HH_SUP_LAB', 'HH_T', 'BUS_DEM_LAB', 'BUS_F', 'BUS_SUP_GOOD', 'TF_T', 'TF_TaxRate', 'LAB_DEM_LAB', 'LAB_SUP_LAB', 'GOOD_DEM_GOOD', 'GOOD_SUP_GOOD', 't', 'GOV_DEM_GOOD'])
        self.MaxIterations = 400
        self.MaxTime = 100
        # Current time step. Call this "STEP" and not time so that users
        # can create a custom time axis variable.
        self.STEP = 0
        self.Err_Tolerance = 0.001
        self.GOV_F = [0., ]
        self.GOV_T = [0., ]
        self.HH_AfterTax = [0., ]
        self.HH_AlphaFin = [0.4000, ]
        self.HH_AlphaIncome = [0.6000, ]
        self.HH_DEM_GOOD = [0., ]
        self.HH_F = [0., ]
        self.HH_PreTax = [0., ]
        self.HH_SUP_LAB = [0., ]
        self.HH_T = [0., ]
        self.BUS_DEM_LAB = [0., ]
        self.BUS_F = [0., ]
        self.BUS_SUP_GOOD = [0., ]
        self.TF_T = [0., ]
        self.TF_TaxRate = [0.2000, ]
        self.LAB_DEM_LAB = [0., ]
        self.LAB_SUP_LAB = [0., ]
        self.GOOD_DEM_GOOD = [0., ]
        self.GOOD_SUP_GOOD = [0., ]
        self.t = [0., ]
        self.GOV_DEM_GOOD = [20. ,]*5 +[25. ,]*100
        #  Make sure exogenous variables are not longer than time frame
        self.GOV_DEM_GOOD = self.GOV_DEM_GOOD[0:101]


    @staticmethod
    def Iterator(in_vec):
        GOV_F, GOV_T, HH_AfterTax, HH_AlphaFin, HH_AlphaIncome, HH_DEM_GOOD, HH_F, HH_PreTax, HH_SUP_LAB, HH_T, BUS_DEM_LAB, BUS_F, BUS_SUP_GOOD, TF_T, TF_TaxRate, LAB_DEM_LAB, LAB_SUP_LAB, GOOD_DEM_GOOD, GOOD_SUP_GOOD, t, GOV_LAG_F, HH_LAG_F, BUS_LAG_F, t_minus_1, GOV_DEM_GOOD = in_vec 
        NEW_GOV_F = GOV_LAG_F +GOV_T -GOV_DEM_GOOD
        NEW_GOV_T = TF_T
        NEW_HH_AfterTax = HH_PreTax -HH_T
        NEW_HH_AlphaFin = 0.4000
        NEW_HH_AlphaIncome = 0.6000
        NEW_HH_DEM_GOOD = HH_AlphaIncome *HH_AfterTax +HH_AlphaFin *HH_LAG_F
        NEW_HH_F = HH_LAG_F -HH_T +HH_SUP_LAB -HH_DEM_GOOD
        NEW_HH_PreTax = HH_SUP_LAB
        NEW_HH_SUP_LAB = BUS_DEM_LAB
        NEW_HH_T = TF_T
        NEW_BUS_DEM_LAB = GOOD_SUP_GOOD
        NEW_BUS_F = BUS_LAG_F -BUS_DEM_LAB +BUS_SUP_GOOD
        NEW_BUS_SUP_GOOD = GOV_DEM_GOOD +HH_DEM_GOOD
        NEW_TF_T = TF_TaxRate *HH_SUP_LAB
        NEW_TF_TaxRate = 0.2000
        NEW_LAB_DEM_LAB = BUS_DEM_LAB
        NEW_LAB_SUP_LAB = LAB_DEM_LAB
        NEW_GOOD_DEM_GOOD = GOV_DEM_GOOD +HH_DEM_GOOD
        NEW_GOOD_SUP_GOOD = GOOD_DEM_GOOD
        NEW_t = t_minus_1 + 1.0
        NEW_GOV_LAG_F = GOV_LAG_F
        NEW_HH_LAG_F = HH_LAG_F
        NEW_BUS_LAG_F = BUS_LAG_F
        NEW_t_minus_1 = t_minus_1
        NEW_GOV_DEM_GOOD = GOV_DEM_GOOD
        return NEW_GOV_F, NEW_GOV_T, NEW_HH_AfterTax, NEW_HH_AlphaFin, NEW_HH_AlphaIncome, NEW_HH_DEM_GOOD, NEW_HH_F, NEW_HH_PreTax, NEW_HH_SUP_LAB, NEW_HH_T, NEW_BUS_DEM_LAB, NEW_BUS_F, NEW_BUS_SUP_GOOD, NEW_TF_T, NEW_TF_TaxRate, NEW_LAB_DEM_LAB, NEW_LAB_SUP_LAB, NEW_GOOD_DEM_GOOD, NEW_GOOD_SUP_GOOD, NEW_t, NEW_GOV_LAG_F, NEW_HH_LAG_F, NEW_BUS_LAG_F, NEW_t_minus_1, NEW_GOV_DEM_GOOD


    def main(self):
        while self.STEP < self.MaxTime:
            self.RunOneStep()

    def RunOneStep(self):
        self.STEP += 1
        GOV_F = self.GOV_F[-1]
        GOV_T = self.GOV_T[-1]
        HH_AfterTax = self.HH_AfterTax[-1]
        HH_AlphaFin = self.HH_AlphaFin[-1]
        HH_AlphaIncome = self.HH_AlphaIncome[-1]
        HH_DEM_GOOD = self.HH_DEM_GOOD[-1]
        HH_F = self.HH_F[-1]
        HH_PreTax = self.HH_PreTax[-1]
        HH_SUP_LAB = self.HH_SUP_LAB[-1]
        HH_T = self.HH_T[-1]
        BUS_DEM_LAB = self.BUS_DEM_LAB[-1]
        BUS_F = self.BUS_F[-1]
        BUS_SUP_GOOD = self.BUS_SUP_GOOD[-1]
        TF_T = self.TF_T[-1]
        TF_TaxRate = self.TF_TaxRate[-1]
        LAB_DEM_LAB = self.LAB_DEM_LAB[-1]
        LAB_SUP_LAB = self.LAB_SUP_LAB[-1]
        GOOD_DEM_GOOD = self.GOOD_DEM_GOOD[-1]
        GOOD_SUP_GOOD = self.GOOD_SUP_GOOD[-1]
        t = self.t[-1]
        GOV_LAG_F = self.GOV_F[self.STEP -1]
        HH_LAG_F = self.HH_F[self.STEP -1]
        BUS_LAG_F = self.BUS_F[self.STEP -1]
        t_minus_1 = self.t[self.STEP -1]
        GOV_DEM_GOOD = self.GOV_DEM_GOOD[self.STEP]

        orig_vector = (GOV_F, GOV_T, HH_AfterTax, HH_AlphaFin, HH_AlphaIncome, HH_DEM_GOOD, HH_F, HH_PreTax, HH_SUP_LAB, HH_T, BUS_DEM_LAB, BUS_F, BUS_SUP_GOOD, TF_T, TF_TaxRate, LAB_DEM_LAB, LAB_SUP_LAB, GOOD_DEM_GOOD, GOOD_SUP_GOOD, t, GOV_LAG_F, HH_LAG_F, BUS_LAG_F, t_minus_1, GOV_DEM_GOOD)
        err = 1.
        cnt = 0
        while err > self.Err_Tolerance:
            new_vector = self.Iterator(orig_vector)
            err = self.CalcError(orig_vector, new_vector)
            orig_vector = new_vector
            cnt += 1
            if cnt > self.MaxIterations:
                raise ValueError('No Convergence!')
        GOV_F = orig_vector[0]
        self.GOV_F.append(GOV_F)
        GOV_T = orig_vector[1]
        self.GOV_T.append(GOV_T)
        HH_AfterTax = orig_vector[2]
        self.HH_AfterTax.append(HH_AfterTax)
        HH_AlphaFin = orig_vector[3]
        self.HH_AlphaFin.append(HH_AlphaFin)
        HH_AlphaIncome = orig_vector[4]
        self.HH_AlphaIncome.append(HH_AlphaIncome)
        HH_DEM_GOOD = orig_vector[5]
        self.HH_DEM_GOOD.append(HH_DEM_GOOD)
        HH_F = orig_vector[6]
        self.HH_F.append(HH_F)
        HH_PreTax = orig_vector[7]
        self.HH_PreTax.append(HH_PreTax)
        HH_SUP_LAB = orig_vector[8]
        self.HH_SUP_LAB.append(HH_SUP_LAB)
        HH_T = orig_vector[9]
        self.HH_T.append(HH_T)
        BUS_DEM_LAB = orig_vector[10]
        self.BUS_DEM_LAB.append(BUS_DEM_LAB)
        BUS_F = orig_vector[11]
        self.BUS_F.append(BUS_F)
        BUS_SUP_GOOD = orig_vector[12]
        self.BUS_SUP_GOOD.append(BUS_SUP_GOOD)
        TF_T = orig_vector[13]
        self.TF_T.append(TF_T)
        TF_TaxRate = orig_vector[14]
        self.TF_TaxRate.append(TF_TaxRate)
        LAB_DEM_LAB = orig_vector[15]
        self.LAB_DEM_LAB.append(LAB_DEM_LAB)
        LAB_SUP_LAB = orig_vector[16]
        self.LAB_SUP_LAB.append(LAB_SUP_LAB)
        GOOD_DEM_GOOD = orig_vector[17]
        self.GOOD_DEM_GOOD.append(GOOD_DEM_GOOD)
        GOOD_SUP_GOOD = orig_vector[18]
        self.GOOD_SUP_GOOD.append(GOOD_SUP_GOOD)
        t = orig_vector[19]
        self.t.append(t)


    @staticmethod
    def CalcError(vec1, vec2):
        err = 0.
        for val1, val2 in zip(vec1, vec2):
            err += abs(val1 - val2)
        return err

if __name__ == '__main__':
    obj = SFCModel()
    obj.main()
