
"""
SIM_model.py

Machine-generated model code

[Generated by:]
# Model SIM - Simplest model with government money.
# Chapter 3 of [G&L 2012], pages 91-92.
#
# [G&L 2012] "Monetary Economics: An Integrated Approach to credit, Money, Income, Production
# and Wealth; Second Edition", by Wynne Godley and Marc Lavoie, Palgrave Macmillan, 2012.
# ISBN 978-0-230-30184-9
Cs = Cd                             # (3.1)
Gs = Gd                             # (3.2)
Ts = Td                             # (3.3)
Ns = Nd                             # (3,4)
YD = W*Nd - Ts                      # (3.5)  [Need to specify Nd instead of N]
Td = theta*W*Ns                     # (3.6)
Cd = alpha1*YD + alpha2*LAG_Hh      # (3.7)
# -----------------------
# Where - lagged variables
LAG_Hh = Hh(k-1)                     # Def'n
LAG_Hs = Hs(k-1)                     # Def'n
# ---------------------------------------------
# Need to clean up the following
Hs = LAG_Hs + Gd - Td                # (3.8) Was: delta_Hs = Hs - LAG_Hs = Gd - Td
                                     # Government-supplied money
                                     # Note that there is no dependence upon Hs;
                                     # redundant equation.
Hh = LAG_Hh + YD - Cd                # (3.9) Was: delta_Hh = Hh- LAG_Hs = YD - Cd
#-----------------------------------------------
Y = Cs + Gs                          # (3.10)
Nd = Y/W                             # (3.11)
# Params
alpha1 = 0.6
alpha2 = 0.4
theta = 0.2
W = 1.0
# Initial conditions
Hh(0) = 80.0
Hs(0) = 80.0
# Exogenous variable
Gd = [20., ] * 35 + [25., ] * 66
# Length of simulation
MaxTime = 100

"""



class SFCModel(object):
    """
    Model

    Implements the following system of equations.

    Endogenous variables and parameters
    ===================================
    Cs = Cd,
    Gs = Gd,
    Ts = Td,
    Ns = Nd,
    YD = W*Nd - Ts,
    Td = theta*W*Ns,
    Cd = alpha1*YD + alpha2*LAG_Hh,
    Hs = LAG_Hs + Gd - Td,
    Hh = LAG_Hh + YD - Cd,
    Y = Cs + Gs,
    Nd = Y/W,
    alpha1 = 0.6,
    alpha2 = 0.4,
    theta = 0.2,
    W = 1.0,
    t = t_minus_1 + 1.0.
    Where lagged variables are:
    LAG_Hh(t) = Hh(k-1),
    LAG_Hs(t) = Hs(k-1),
    t_minus_1(t) = t(k-1).
    
    Initial Conditions:
    Hh(0) = 80.0,
    Hs(0) = 80.0.
    
    Exogenous Variables
    ===================
    Gd.

    """
    def __init__(self):
        self.MaxIterations = 400
        self.MaxTime = 100
        # Current time step. Call this "STEP" and not time so that users
        # can create a custom time axis variable.
        self.STEP = 0
        self.Err_Tolerance = .001
        self.Cs = [0., ]
        self.Gs = [0., ]
        self.Ts = [0., ]
        self.Ns = [0., ]
        self.YD = [0., ]
        self.Td = [0., ]
        self.Cd = [0., ]
        self.Hs = [80.0, ]
        self.Hh = [80.0, ]
        self.Y = [0., ]
        self.Nd = [0., ]
        self.alpha1 = [0.6, ]
        self.alpha2 = [0.4, ]
        self.theta = [0.2, ]
        self.W = [1.0, ]
        self.t = [0., ]
        self.Gd = [20., ] * 35 + [25., ] * 66
        #  Make sure exogenous variables are not longer than time frame
        self.Gd = self.Gd[0:101]


    @staticmethod
    def Iterator(in_vec):
        Cs, Gs, Ts, Ns, YD, Td, Cd, Hs, Hh, Y, Nd, alpha1, alpha2, theta, W, t, LAG_Hh, LAG_Hs, t_minus_1, Gd = in_vec 
        NEW_Cs = Cd
        NEW_Gs = Gd
        NEW_Ts = Td
        NEW_Ns = Nd
        NEW_YD = W*Nd - Ts
        NEW_Td = theta*W*Ns
        NEW_Cd = alpha1*YD + alpha2*LAG_Hh
        NEW_Hs = LAG_Hs + Gd - Td
        NEW_Hh = LAG_Hh + YD - Cd
        NEW_Y = Cs + Gs
        NEW_Nd = Y/W
        NEW_alpha1 = 0.6
        NEW_alpha2 = 0.4
        NEW_theta = 0.2
        NEW_W = 1.0
        NEW_t = t_minus_1 + 1.0
        NEW_LAG_Hh = LAG_Hh
        NEW_LAG_Hs = LAG_Hs
        NEW_t_minus_1 = t_minus_1
        NEW_Gd = Gd
        return NEW_Cs, NEW_Gs, NEW_Ts, NEW_Ns, NEW_YD, NEW_Td, NEW_Cd, NEW_Hs, NEW_Hh, NEW_Y, NEW_Nd, NEW_alpha1, NEW_alpha2, NEW_theta, NEW_W, NEW_t, NEW_LAG_Hh, NEW_LAG_Hs, NEW_t_minus_1, NEW_Gd


    def main(self):
        while self.STEP < self.MaxTime:
            self.RunOneStep()

    def RunOneStep(self):
        self.STEP += 1
        Cs = self.Cs[-1]
        Gs = self.Gs[-1]
        Ts = self.Ts[-1]
        Ns = self.Ns[-1]
        YD = self.YD[-1]
        Td = self.Td[-1]
        Cd = self.Cd[-1]
        Hs = self.Hs[-1]
        Hh = self.Hh[-1]
        Y = self.Y[-1]
        Nd = self.Nd[-1]
        alpha1 = self.alpha1[-1]
        alpha2 = self.alpha2[-1]
        theta = self.theta[-1]
        W = self.W[-1]
        t = self.t[-1]
        LAG_Hh = self.Hh[self.STEP -1]
        LAG_Hs = self.Hs[self.STEP -1]
        t_minus_1 = self.t[self.STEP -1]
        Gd = self.Gd[self.STEP]

        orig_vector = (Cs, Gs, Ts, Ns, YD, Td, Cd, Hs, Hh, Y, Nd, alpha1, alpha2, theta, W, t, LAG_Hh, LAG_Hs, t_minus_1, Gd)
        err = 1.
        cnt = 0
        while err > self.Err_Tolerance:
            new_vector = self.Iterator(orig_vector)
            err = self.CalcError(orig_vector, new_vector)
            orig_vector = new_vector
            cnt += 1
            if cnt > self.MaxIterations:
                raise ValueError('No Convergence!')
        Cs = orig_vector[0]
        self.Cs.append(Cs)
        Gs = orig_vector[1]
        self.Gs.append(Gs)
        Ts = orig_vector[2]
        self.Ts.append(Ts)
        Ns = orig_vector[3]
        self.Ns.append(Ns)
        YD = orig_vector[4]
        self.YD.append(YD)
        Td = orig_vector[5]
        self.Td.append(Td)
        Cd = orig_vector[6]
        self.Cd.append(Cd)
        Hs = orig_vector[7]
        self.Hs.append(Hs)
        Hh = orig_vector[8]
        self.Hh.append(Hh)
        Y = orig_vector[9]
        self.Y.append(Y)
        Nd = orig_vector[10]
        self.Nd.append(Nd)
        alpha1 = orig_vector[11]
        self.alpha1.append(alpha1)
        alpha2 = orig_vector[12]
        self.alpha2.append(alpha2)
        theta = orig_vector[13]
        self.theta.append(theta)
        W = orig_vector[14]
        self.W.append(W)
        t = orig_vector[15]
        self.t.append(t)


    @staticmethod
    def CalcError(vec1, vec2):
        err = 0.
        for val1, val2 in zip(vec1, vec2):
            err += abs(val1 - val2)
        return err

if __name__ == '__main__':
    obj = SFCModel()
    obj.main()
