
"""
output\unittest_output_2.py

Machine-generated model code

[Generated by:]

# Test system used in unit tests.
x = y
LAG_x = x(t-1)
y = t + 2.0
z = LAG_x + 1.0
oops
# Exogenous
G = [20., ] * 20
        
====================

Warnings generated by this code:
Ignored line: "oops"

"""

from sfc_models.base_solver import BaseSolver


class SFCModel(BaseSolver):
    """
    Model

    Implements the following system of equations.

    Endogenous variables and parameters
    ===================================
    x = y,
    y = t + 2.0,
    z = LAG_x + 1.0,
    t = t_minus_1 + 1.0.
    Where lagged variables are:
    LAG_x(t) = x(k-1),
    t_minus_1(t) = t(k-1).
    
    
    Exogenous Variables
    ===================
    G.

    """
    def __init__(self):
        BaseSolver.__init__(self, ['x', 'y', 'z', 't', 'G'])
        self.MaxIterations = 400
        self.MaxTime = 0
        # Current time step. Call this "STEP" and not time so that users
        # can create a custom time axis variable.
        self.STEP = 0
        self.Err_Tolerance = .001
        self.x = [0., ]
        self.y = [0., ]
        self.z = [0., ]
        self.t = [0., ]
        self.G = [20., ] * 20
        #  Make sure exogenous variables are not longer than time frame
        self.G = self.G[0:1]


    @staticmethod
    def Iterator(in_vec):
        x, y, z, t, LAG_x, t_minus_1, G = in_vec 
        NEW_x = y
        NEW_y = t + 2.0
        NEW_z = LAG_x + 1.0
        NEW_t = t_minus_1 + 1.0
        NEW_LAG_x = LAG_x
        NEW_t_minus_1 = t_minus_1
        NEW_G = G
        return NEW_x, NEW_y, NEW_z, NEW_t, NEW_LAG_x, NEW_t_minus_1, NEW_G


    def main(self):
        while self.STEP < self.MaxTime:
            self.RunOneStep()

    def RunOneStep(self):
        self.STEP += 1
        x = self.x[-1]
        y = self.y[-1]
        z = self.z[-1]
        t = self.t[-1]
        LAG_x = self.x[self.STEP -1]
        t_minus_1 = self.t[self.STEP -1]
        G = self.G[self.STEP]

        orig_vector = (x, y, z, t, LAG_x, t_minus_1, G)
        err = 1.
        cnt = 0
        while err > self.Err_Tolerance:
            new_vector = self.Iterator(orig_vector)
            err = self.CalcError(orig_vector, new_vector)
            orig_vector = new_vector
            cnt += 1
            if cnt > self.MaxIterations:
                raise ValueError('No Convergence!')
        x = orig_vector[0]
        self.x.append(x)
        y = orig_vector[1]
        self.y.append(y)
        z = orig_vector[2]
        self.z.append(z)
        t = orig_vector[3]
        self.t.append(t)


    @staticmethod
    def CalcError(vec1, vec2):
        err = 0.
        for val1, val2 in zip(vec1, vec2):
            err += abs(val1 - val2)
        return err

if __name__ == '__main__':
    obj = SFCModel()
    obj.main()
