# Generated by Django 5.0.7 on 2024-10-19 05:17

import django.contrib.auth.models
import django.db.models.deletion
import django.utils.timezone
import seolpyo_dstory.models.postmodel
import seolpyo_dstory.models.usermodel
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=19, unique=True, verbose_name='태그명')),
            ],
            options={
                'verbose_name': '태그',
                'verbose_name_plural': '태그',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('email', models.EmailField(max_length=254, unique=True, verbose_name='로그인 이메일')),
                ('username', models.CharField(help_text='닉네임은 한글, 영어, 숫자만 사용가능합니다.', max_length=10, unique=True, validators=[seolpyo_dstory.models.usermodel.UsernameValidator()], verbose_name='닉네임')),
                ('groups', models.ManyToManyField(blank=True, related_name='seolpyo_dstory_user', to='auth.group')),
                ('user_permissions', models.ManyToManyField(blank=True, related_name='seolpyo_dstory_user', to='auth.permission')),
            ],
            options={
                'verbose_name': '디스토리/사용자',
                'verbose_name_plural': '사용자',
                'abstract': False,
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default=seolpyo_dstory.models.postmodel.default_category, max_length=10, unique=True, verbose_name='카테고리명')),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='dstory_category_children', to='seolpyo_dstory.category')),
            ],
            options={
                'verbose_name': '카테고리',
                'verbose_name_plural': '카테고리',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Post',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_pub', models.DateTimeField(default=django.utils.timezone.localtime, verbose_name='공개시간')),
                ('slug', models.CharField(max_length=99, null=True, unique=True, verbose_name='문자 주소')),
                ('password', models.CharField(blank=True, max_length=20, verbose_name='비밀번호')),
                ('is_private', models.BooleanField(default=False, verbose_name='비공개로 설정')),
                ('title', models.CharField(max_length=99, verbose_name='제목')),
                ('slug_title', models.SlugField(allow_unicode=True, editable=False, unique=True, verbose_name='문자 주소(자동생성)')),
                ('content', models.TextField(verbose_name='내용')),
                ('text', models.TextField(editable=False)),
                ('author', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.DO_NOTHING, related_name='seolpyo_dstory_post_set', to=settings.AUTH_USER_MODEL, verbose_name='작성자')),
                ('category', models.ForeignKey(blank=True, default=seolpyo_dstory.models.postmodel.default_category, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='seolpyo_dstory_post_set', to='seolpyo_dstory.category', verbose_name='카테고리')),
                ('tags', models.ManyToManyField(blank=True, related_name='seolpyo_dstory_post_set', to='seolpyo_dstory.tag', verbose_name='태그')),
            ],
            options={
                'verbose_name': '티스토리/글',
                'verbose_name_plural': '글',
                'ordering': ['-date_pub', '-pk'],
                'abstract': False,
            },
        ),
    ]
