/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2jwt;

import com.teradata.tdgss.asn1.der.DER;
import com.teradata.tdgss.jalgapi.AlgParcel;
import com.teradata.tdgss.jalgapi.AlgQop;
import com.teradata.tdgss.jalgapi.AlgQopDer;
import com.teradata.tdgss.jgssp2jwt.JwtClientInfoToken;
import com.teradata.tdgss.jgssp2jwt.JwtCredential;
import com.teradata.tdgss.jgssp2jwt.JwtDH;
import com.teradata.tdgss.jgssp2jwt.JwtDHParams;
import com.teradata.tdgss.jgssp2jwt.JwtEncryptedPayLoad;
import com.teradata.tdgss.jgssp2jwt.JwtEncryptedToken;
import com.teradata.tdgss.jgssp2jwt.JwtKeyExchange;
import com.teradata.tdgss.jgssp2jwt.JwtMechanism;
import com.teradata.tdgss.jgssp2jwt.JwtMinorStatus;
import com.teradata.tdgss.jgssp2jwt.JwtName;
import com.teradata.tdgss.jgssp2jwt.JwtServerInfoToken;
import com.teradata.tdgss.jgssp2jwt.JwtTokenHdr;
import com.teradata.tdgss.jgssp2td2.ASN1Msg;
import com.teradata.tdgss.jgssp2td2.ASN1TokenHdr;
import com.teradata.tdgss.jgssp2td2.Td2Crypto;
import com.teradata.tdgss.jgssp2td2.Td2Token;
import com.teradata.tdgss.jgssp2td2.Td2Util;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import javax.crypto.SecretKey;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class JwtContext
implements GSSContext {
    private final TdgssLogger logger;
    private static final int CTX_NEW = 0;
    private static final int CTX_SEND_JWT = 1;
    private static final int CTX_SETUP_COMPLETE = 3;
    private byte contextInit = 0;
    private int contextState = 0;
    private JwtDH dh;
    private byte[] masterKey = null;
    private byte[] publicKeybuf;
    private AlgQop[] globalQops;
    private static final byte TDGSS_CLIENT = 0;
    private Td2Crypto[] td2Crypto = new Td2Crypto[4];
    private BigInteger mySeqNum = new BigInteger("1");
    private BigInteger peerSeqNum = new BigInteger("1");
    private int peerCapabilities = 0;
    private boolean protReady = false;
    private byte server_client = 1;
    private boolean initiator;
    private JwtCredential credential;
    private JwtName targetName;
    private int lifetime;
    private short requestedServices;
    private static final byte TDGSS_SERVER = 1;
    private static final int HEADERLEN = 16;
    private static final short maxshort = Short.MAX_VALUE;

    public JwtContext(JwtCredential jwtCredential, Object[] objectArray, TdgssLogger tdgssLogger) throws GSSException {
        this.logger = tdgssLogger;
        this.credential = jwtCredential;
        this.initialiseData();
    }

    public JwtContext(JwtCredential jwtCredential, JwtName jwtName, int n, Object[] objectArray, short s, TdgssLogger tdgssLogger) throws GSSException {
        this.logger = tdgssLogger;
        this.initiator = true;
        this.credential = jwtCredential;
        this.targetName = jwtName;
        this.lifetime = n;
        this.requestedServices = s;
        this.initialiseData();
    }

    private void initialiseData() throws GSSException {
        this.contextState = 0;
        this.dh = new JwtDH(this.logger);
    }

    public byte[] acceptSecContext(byte[] byArray, int n, int n2) throws GSSException {
        throw new TdgssException(16, JwtMinorStatus.JWT_ERR_API_NOT_IMPLEMENTED);
    }

    public void acceptSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        throw new TdgssException(16, JwtMinorStatus.JWT_ERR_API_NOT_IMPLEMENTED);
    }

    public void dispose() throws GSSException {
        if (this.credential != null) {
            this.credential.dispose();
        }
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        boolean bl2 = false;
        if (!this.isProtReady()) {
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_CONTEXT_NOT_READY);
        }
        n = this.validateQop(n);
        if ((this.peerCapabilities & 0x10) == 16) {
            bl2 = true;
        }
        int n3 = this.td2Crypto[n].getWrapSizeLimit(n, bl, n2, bl2);
        return n3;
    }

    private int validateQop(int n) throws GSSException {
        if (n < 0 || n >= 4) {
            throw new TdgssException(14, JwtMinorStatus.JWT_ERR_INVALID_ARGUMENT);
        }
        return n;
    }

    public int initSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        throw new TdgssException(16, JwtMinorStatus.JWT_ERR_API_NOT_IMPLEMENTED);
    }

    public byte[] initSecContext(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = new byte[]{6, 13, 43, 6, 1, 4, 1, -127, -32, 26, 4, -126, 46, 1, 4, 0, 0, 0, 0, 21, 1};
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Context state is now " + this.contextState);
        }
        if (this.contextInit == 0) {
            this.contextInit = 1;
        }
        switch (this.contextState) {
            case 0: {
                this.server_client = 0;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Building ClientInfoToken");
                }
                byArray2 = this.buildClientInfoToken();
                int n3 = byArray2.length + byArray4.length;
                byArray3 = new byte[n3];
                System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                System.arraycopy(byArray4, 0, byArray3, byArray2.length, byArray4.length);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(TdgssUtil.dump("Successfully generated first message as", byArray3));
                }
                this.contextState = 1;
                break;
            }
            case 1: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("send the JWT Token");
                }
                byArray3 = this.buildEncryptedJwtToken(byArray, n, n2);
                this.contextState = 3;
                this.protReady = true;
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new TdgssException(11, JwtMinorStatus.JWT_ERR_NO_CONTEXT);
            }
        }
        TdgssUtil.dump("Successfully generated  message as", byArray3);
        return byArray3;
    }

    private byte[] buildEncryptedJwtToken(byte[] byArray, int n, int n2) throws GSSException {
        Object object;
        Object object2;
        Object object3;
        JwtServerInfoToken jwtServerInfoToken = new JwtServerInfoToken();
        DER dER = null;
        if (byArray == null) {
            throw new TdgssException(10, JwtMinorStatus.JWT_ERR_SERVERINFOTOKEN_EMPTY);
        }
        dER = new DER(byArray, true);
        jwtServerInfoToken.parseDERObject(dER);
        byte[] byArray2 = jwtServerInfoToken.getQopParcel();
        AlgQopDer algQopDer = new AlgQopDer(byArray2);
        this.globalQops = new AlgQop[4];
        this.globalQops[0] = algQopDer.getAlgQop(0);
        this.globalQops[1] = algQopDer.getAlgQop(1);
        this.globalQops[2] = algQopDer.getAlgQop(2);
        this.globalQops[3] = algQopDer.getAlgQop(3);
        int n3 = 0;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Generate DH Parameters ...");
        }
        JwtKeyExchange jwtKeyExchange = jwtServerInfoToken.getkeyExchange();
        JwtDHParams jwtDHParams = jwtKeyExchange.getDhParams();
        this.dh.GenerateParameters(1, jwtDHParams.getgKey(), jwtDHParams.getpKey());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Generate DH Public Key ...");
        }
        this.publicKeybuf = this.dh.GenerateKey();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Compute  DH Private Key ...");
        }
        this.masterKey = this.dh.ComputeKey(jwtDHParams.getPeerPublicKey());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(TdgssUtil.dump("The Matser Key is ***********************************", this.masterKey));
        }
        for (int i = 0; i < 4; ++i) {
            object3 = this.globalQops[i];
            int n4 = ((AlgQop)object3).getKeyLength() / 8;
            object2 = new byte[n4];
            System.arraycopy(this.masterKey, n3, object2, 0, n4);
            object = this.dh.BytetoKey(((AlgQop)object3).getConfidentialityAlgorithm(), (byte[])object2, 0, n4);
            this.peerCapabilities = jwtServerInfoToken.getTokenHeader().getCapability();
            this.td2Crypto[i] = new Td2Crypto((SecretKey)object, (byte[])object2, (AlgQop)object3, this.peerCapabilities, this.logger);
            this.td2Crypto[i].computeKeyHash();
            n3 += n4;
        }
        byte[] byArray3 = ((Object)this.credential.getName()).toString().getBytes();
        object3 = null;
        if (this.credential.getExtraLogdata() != null) {
            object3 = this.credential.getExtraLogdata().toString().getBytes();
        }
        MessageProp messageProp = new MessageProp(0, true);
        object2 = new JwtEncryptedPayLoad();
        ((JwtEncryptedPayLoad)object2).setJwtToken(byArray3);
        if (object3 != null) {
            ((JwtEncryptedPayLoad)object2).setExtraLogdata((byte[])object3);
        }
        object = ((JwtEncryptedPayLoad)object2).getDERObject().getEncodedValue();
        byte[] byArray4 = this.wrap((byte[])object, 0, ((Object)object).length, messageProp);
        JwtEncryptedToken jwtEncryptedToken = new JwtEncryptedToken();
        byte by = 0;
        JwtTokenHdr jwtTokenHdr = new JwtTokenHdr();
        jwtTokenHdr.setCapability(this.peerCapabilities);
        jwtTokenHdr.setClientorServer((byte)0);
        jwtTokenHdr.setMsgType((byte)1);
        jwtTokenHdr.setRequestFlag(by);
        jwtTokenHdr.setVersion((byte)3);
        JwtDHParams jwtDHParams2 = new JwtDHParams();
        jwtDHParams2.setPeerPublicKey(this.publicKeybuf);
        JwtKeyExchange jwtKeyExchange2 = new JwtKeyExchange();
        jwtKeyExchange2.setDhParams(jwtDHParams2);
        jwtKeyExchange2.setKeyExchangeType(0);
        jwtEncryptedToken.setTokenHeader(jwtTokenHdr);
        jwtEncryptedToken.setKeyexchgParams(jwtKeyExchange2);
        jwtEncryptedToken.setEncryptedPayLoad(byArray4);
        return jwtEncryptedToken.getDERObject().getEncodedValue();
    }

    private byte[] buildClientInfoToken() {
        byte[] byArray = AlgParcel.getCipherSuitesParcel();
        JwtClientInfoToken jwtClientInfoToken = new JwtClientInfoToken();
        jwtClientInfoToken.setCipherSuite(byArray);
        byte by = 0;
        JwtTokenHdr jwtTokenHdr = new JwtTokenHdr();
        jwtTokenHdr.setCapability(21);
        jwtTokenHdr.setClientorServer((byte)0);
        jwtTokenHdr.setMsgType((byte)1);
        jwtTokenHdr.setRequestFlag(by);
        jwtTokenHdr.setVersion((byte)1);
        jwtClientInfoToken.setTokenHeader(jwtTokenHdr);
        byte[] byArray2 = jwtClientInfoToken.getDERObject().getEncodedValue();
        return byArray2;
    }

    public boolean isEstablished() {
        return this.contextState == 3;
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, JwtMinorStatus.JWT_ERR_API_NOT_IMPLEMENTED);
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entering!");
        }
        if (!this.isProtReady()) {
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_NO_CONTEXT);
        }
        if (n < 0 || n2 < 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Argument out of Range");
            }
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INVALID_ARGUMENT);
        }
        if (byArray == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Input argument is null");
            }
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INVALID_INPUT);
        }
        if (byArray.length < n2 + n) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            }
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INVALID_ARGUMENT);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Decoding ASN1 message token!");
        }
        ASN1Msg aSN1Msg = new ASN1Msg();
        DER dER = new DER(byArray);
        aSN1Msg.parseDERObject(dER);
        ASN1TokenHdr aSN1TokenHdr = aSN1Msg.getAsn1TokenHdr();
        byArray2 = aSN1Msg.getInputMsg();
        if (aSN1Msg.isauthTagSet()) {
            byArray3 = aSN1Msg.getAuthTag();
        }
        byArray4 = aSN1Msg.getComputedMac();
        int n3 = Td2Util.ByteAtoInt(aSN1TokenHdr.getfQOP());
        byte[] byArray5 = aSN1TokenHdr.getVersion();
        byte[] byArray6 = aSN1TokenHdr.getMsgType();
        int n4 = aSN1TokenHdr.getMsgLength();
        byte[] byArray7 = aSN1TokenHdr.getFlag();
        BigInteger bigInteger = aSN1TokenHdr.getSeqNum();
        Td2Token td2Token = new Td2Token(byArray5[0], byArray6[0], 0, 0, 1, byArray7[0], n3, n4, bigInteger, this.logger);
        boolean bl5 = (byArray7[0] & 4) == 4;
        BigInteger bigInteger2 = td2Token.getSeqNumber();
        if (0 != bigInteger2.compareTo(this.peerSeqNum)) {
            JwtMinorStatus jwtMinorStatus = JwtMinorStatus.JWT_ERR_INT_FAILURE;
            if (bigInteger2.equals(this.peerSeqNum.subtract(BigInteger.ONE))) {
                bl = true;
            }
            if (bigInteger2.compareTo(this.peerSeqNum) > 0) {
                bl4 = true;
            }
            if (bigInteger2.compareTo(this.peerSeqNum) < 0) {
                bl2 = true;
                bl3 = true;
            }
            if (messageProp != null) {
                messageProp.setSupplementaryStates(bl, bl2, bl3, bl4, jwtMinorStatus.getErrorCode(), jwtMinorStatus.getErrorMessage());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Doing ASN1 unwrap");
        }
        byte[] byArray8 = this.td2Crypto[n3].newUnWrap(byArray2, 0, byArray2.length, byArray4, bl5, td2Token, byArray3);
        this.peerSeqNum = this.peerSeqNum.add(BigInteger.ONE);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Leaving!");
        }
        return byArray8;
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, JwtMinorStatus.JWT_ERR_API_NOT_IMPLEMENTED);
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entering!");
        }
        if (!this.isProtReady()) {
            throw new TdgssException(16, JwtMinorStatus.JWT_ERR_API_NOT_IMPLEMENTED);
        }
        if (n3 < 0 || n4 < 0 || n2 < 0 || n < 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Argument out of Range");
            }
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INVALID_ARGUMENT);
        }
        if (n2 + n > byArray.length || n4 + n3 > byArray2.length) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Input length  is larger than buffer size ");
            }
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INVALID_ARGUMENT);
        }
        Td2Token td2Token = this.getTokenHdr(byArray, n, n2);
        BigInteger bigInteger = td2Token.getSeqNumber();
        if (0 != bigInteger.compareTo(this.peerSeqNum)) {
            JwtMinorStatus jwtMinorStatus = JwtMinorStatus.JWT_ERR_INT_FAILURE;
            if (bigInteger.equals(this.peerSeqNum.subtract(BigInteger.ONE))) {
                bl = true;
            }
            if (bigInteger.compareTo(this.peerSeqNum) > 0) {
                bl4 = true;
            }
            if (bigInteger.compareTo(this.peerSeqNum) < 0) {
                bl2 = true;
                bl3 = true;
            }
            if (messageProp != null) {
                messageProp.setSupplementaryStates(bl, bl2, bl3, bl4, jwtMinorStatus.getErrorCode(), jwtMinorStatus.getErrorMessage());
            }
        }
        int n5 = td2Token.getQOP();
        n5 = this.validateQop(n5);
        this.td2Crypto[n5].verifyMIC(byArray, n, n2, byArray2, n3, n4, messageProp, td2Token);
        this.peerSeqNum = this.peerSeqNum.add(BigInteger.ONE);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Leaving!");
        }
    }

    private Td2Token getTokenHdr(byte[] byArray, int n, int n2) throws GSSException {
        if (n2 <= 16) {
            throw new TdgssException(10, JwtMinorStatus.JWT_ERR_WRONG_MSGINFO);
        }
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, n + n2 - 16, byArray2, 0, 16);
        Td2Token td2Token = new Td2Token(byArray2, 0, this.logger);
        return td2Token;
    }

    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, JwtMinorStatus.JWT_ERR_API_NOT_IMPLEMENTED);
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entering!");
        }
        int n3 = 0;
        boolean bl = false;
        byte by = 0;
        Td2Token td2Token = null;
        byte[] byArray2 = null;
        if (n < 0 || n2 < 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Argument out of Range");
            }
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INVALID_ARGUMENT);
        }
        if (byArray.length < n2 + n) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            }
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INVALID_ARGUMENT);
        }
        if (messageProp == null) {
            throw new TdgssException(14, JwtMinorStatus.JWT_ERR_INVALID_INPUT);
        }
        n3 = messageProp.getQOP();
        if (this.getConfState() && messageProp.getPrivacy()) {
            by = (byte)(by | 4);
            bl = true;
        }
        int n4 = 17;
        td2Token = new Td2Token(3, 7, 2, this.isServer() ? (byte)1 : 0, n4, by, n3, 0, this.mySeqNum, this.logger);
        byArray2 = this.td2Crypto[n3].newWrap(byArray, n, n2, messageProp, td2Token);
        TdgssUtil.dump(" the encrypted token is", byArray2);
        this.mySeqNum = this.mySeqNum.add(BigInteger.ONE);
        if (bl) {
            messageProp.setPrivacy(true);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Leaving!");
        }
        return byArray2;
    }

    public boolean isServer() throws GSSException {
        if (this.server_client == 1) {
            return true;
        }
        if (this.server_client == 0) {
            return false;
        }
        throw new TdgssException(11, JwtMinorStatus.JWT_ERR_NO_CONTEXT);
    }

    public byte[] export() throws GSSException {
        throw new TdgssException(16, JwtMinorStatus.JWT_ERR_API_NOT_IMPLEMENTED);
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INT_FAILURE);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 2) : (short)(this.requestedServices & 0x7FFD);
    }

    public short getRequestedServices() {
        return this.requestedServices;
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INT_FAILURE);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 4) : (short)(this.requestedServices & 0x7FFB);
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INT_FAILURE);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 8) : (short)(this.requestedServices & 0x7FF7);
    }

    public void requestCredDeleg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INT_FAILURE);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 1) : (short)(this.requestedServices & 0x7FFE);
    }

    public void requestAnonymity(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INT_FAILURE);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x10) : (short)(this.requestedServices & 0x7FEF);
    }

    public void requestConf(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INT_FAILURE);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x20) : (short)(this.requestedServices & 0x7FDF);
    }

    public void requestInteg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INT_FAILURE);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x40) : (short)(this.requestedServices & 0x7FBF);
    }

    public void requestLifetime(int n) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INT_FAILURE);
        }
        this.lifetime = n;
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        throw new TdgssException(16, JwtMinorStatus.JWT_ERR_API_NOT_IMPLEMENTED);
    }

    public boolean getCredDelegState() {
        if (this.contextInit == 0) {
            return false;
        }
        if (this.isEstablished()) {
            return (this.requestedServices & 1) != 0;
        }
        return false;
    }

    public boolean getMutualAuthState() {
        if (this.contextInit == 0) {
            return false;
        }
        return (this.requestedServices & 2) != 0;
    }

    public boolean getReplayDetState() {
        if (this.contextInit == 0) {
            return false;
        }
        return (this.requestedServices & 4) != 0;
    }

    public boolean getSequenceDetState() {
        if (this.contextInit == 0) {
            return false;
        }
        return (this.requestedServices & 8) != 0;
    }

    public boolean getAnonymityState() {
        return false;
    }

    public boolean getConfState() {
        return this.contextInit != 0;
    }

    public boolean getIntegState() {
        return this.contextInit != 0;
    }

    public int getLifetime() {
        return this.contextInit == 0 ? 0 : this.lifetime;
    }

    public boolean isTransferable() throws GSSException {
        if (this.contextInit == 0) {
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_CONTEXT_NOT_READY);
        }
        return false;
    }

    public boolean isProtReady() {
        return this.contextInit == 0 ? false : this.protReady;
    }

    public GSSName getSrcName() throws GSSException {
        if (this.credential != null) {
            return this.credential.getName();
        }
        return null;
    }

    public GSSName getTargName() throws GSSException {
        return this.targetName;
    }

    public Oid getMech() throws GSSException {
        return JwtMechanism.mechOid;
    }

    public GSSCredential getDelegCred() throws GSSException {
        throw new TdgssException(16, JwtMinorStatus.JWT_ERR_API_NOT_IMPLEMENTED);
    }

    public boolean isInitiator() throws GSSException {
        return this.initiator;
    }

    public GSSCredential getCredential() {
        return this.credential;
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, JwtMinorStatus.JWT_ERR_API_NOT_IMPLEMENTED);
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        int n3 = 0;
        Td2Token td2Token = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entering!");
        }
        if (!this.isProtReady()) {
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_CONTEXT_NOT_READY);
        }
        if (n < 0 || n2 < 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Argument out of Range");
            }
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INVALID_ARGUMENT);
        }
        if (byArray.length < n2 + n) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            }
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INVALID_ARGUMENT);
        }
        if (messageProp != null) {
            n3 = messageProp.getQOP();
        }
        n3 = this.validateQop(n3);
        byte by = 0;
        td2Token = new Td2Token(3, 8, 2, this.isServer() ? (byte)1 : 0, 1, by, n3, 0, this.mySeqNum, this.logger);
        byte[] byArray2 = this.td2Crypto[n3].getMIC(byArray, n, n2, messageProp, td2Token);
        this.mySeqNum = this.mySeqNum.add(BigInteger.ONE);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Leaving!");
        }
        return byArray2;
    }
}

