# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'VulnerabilityAuditApplicationDependencyArgs',
    'VulnerabilityAuditConfigurationArgs',
    'VulnerabilityAuditSourceArgs',
    'VulnerabilityAuditVulnerabilityArgs',
    'GetKnowledgebasesFilterArgs',
    'GetVulnerabilityAuditApplicationDependencyVulnerabilitiesFilterArgs',
    'GetVulnerabilityAuditsFilterArgs',
]

@pulumi.input_type
class VulnerabilityAuditApplicationDependencyArgs:
    def __init__(__self__, *,
                 gav: pulumi.Input[str],
                 node_id: pulumi.Input[str],
                 application_dependency_node_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] gav: Group Artifact Version (GAV) identifier (Group:Artifact:Version), e.g. org.graalvm.nativeimage:svm:21.1.0.
        :param pulumi.Input[str] node_id: Unique identifier of an Application Dependency, for example nodeId1. The nodeId can be generated by assigning a unique id to each application dependency in the tree of application dependencies. Every node, even those who share the same GAV, should have a different nodeId. The preferred way of constructing a nodeId is to assign incremental integers during a breadth first or depth first search. A nodeId can be reused only it refers to the same subtree of application dependencies. (This is not equivalent to referring to the same GAV, that is, a GAV can have multiple transitive dependencies.)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] application_dependency_node_ids: List of Application Dependencies on which this Application Dependency depends, each identified by its nodeId.
        """
        VulnerabilityAuditApplicationDependencyArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            gav=gav,
            node_id=node_id,
            application_dependency_node_ids=application_dependency_node_ids,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             gav: pulumi.Input[str],
             node_id: pulumi.Input[str],
             application_dependency_node_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("gav", gav)
        _setter("node_id", node_id)
        if application_dependency_node_ids is not None:
            _setter("application_dependency_node_ids", application_dependency_node_ids)

    @property
    @pulumi.getter
    def gav(self) -> pulumi.Input[str]:
        """
        Group Artifact Version (GAV) identifier (Group:Artifact:Version), e.g. org.graalvm.nativeimage:svm:21.1.0.
        """
        return pulumi.get(self, "gav")

    @gav.setter
    def gav(self, value: pulumi.Input[str]):
        pulumi.set(self, "gav", value)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> pulumi.Input[str]:
        """
        Unique identifier of an Application Dependency, for example nodeId1. The nodeId can be generated by assigning a unique id to each application dependency in the tree of application dependencies. Every node, even those who share the same GAV, should have a different nodeId. The preferred way of constructing a nodeId is to assign incremental integers during a breadth first or depth first search. A nodeId can be reused only it refers to the same subtree of application dependencies. (This is not equivalent to referring to the same GAV, that is, a GAV can have multiple transitive dependencies.)
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_id", value)

    @property
    @pulumi.getter(name="applicationDependencyNodeIds")
    def application_dependency_node_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Application Dependencies on which this Application Dependency depends, each identified by its nodeId.
        """
        return pulumi.get(self, "application_dependency_node_ids")

    @application_dependency_node_ids.setter
    def application_dependency_node_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "application_dependency_node_ids", value)


@pulumi.input_type
class VulnerabilityAuditConfigurationArgs:
    def __init__(__self__, *,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_permissible_cvss_v2score: Optional[pulumi.Input[float]] = None,
                 max_permissible_cvss_v3score: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclusions: A vulnerable Application Dependency is ignored if its name matches any of the items in `exclusions`.
        :param pulumi.Input[float] max_permissible_cvss_v2score: A vulnerable Application Dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        :param pulumi.Input[float] max_permissible_cvss_v3score: A vulnerable Application Dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        """
        VulnerabilityAuditConfigurationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            exclusions=exclusions,
            max_permissible_cvss_v2score=max_permissible_cvss_v2score,
            max_permissible_cvss_v3score=max_permissible_cvss_v3score,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             max_permissible_cvss_v2score: Optional[pulumi.Input[float]] = None,
             max_permissible_cvss_v3score: Optional[pulumi.Input[float]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if exclusions is not None:
            _setter("exclusions", exclusions)
        if max_permissible_cvss_v2score is not None:
            _setter("max_permissible_cvss_v2score", max_permissible_cvss_v2score)
        if max_permissible_cvss_v3score is not None:
            _setter("max_permissible_cvss_v3score", max_permissible_cvss_v3score)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A vulnerable Application Dependency is ignored if its name matches any of the items in `exclusions`.
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclusions", value)

    @property
    @pulumi.getter(name="maxPermissibleCvssV2score")
    def max_permissible_cvss_v2score(self) -> Optional[pulumi.Input[float]]:
        """
        A vulnerable Application Dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        """
        return pulumi.get(self, "max_permissible_cvss_v2score")

    @max_permissible_cvss_v2score.setter
    def max_permissible_cvss_v2score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_permissible_cvss_v2score", value)

    @property
    @pulumi.getter(name="maxPermissibleCvssV3score")
    def max_permissible_cvss_v3score(self) -> Optional[pulumi.Input[float]]:
        """
        A vulnerable Application Dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        """
        return pulumi.get(self, "max_permissible_cvss_v3score")

    @max_permissible_cvss_v3score.setter
    def max_permissible_cvss_v3score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_permissible_cvss_v3score", value)


@pulumi.input_type
class VulnerabilityAuditSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 oci_resource_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: Source type of the Vulnerability Audit.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] description: Description of the external resource source.
        :param pulumi.Input[str] oci_resource_id: The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure resource that triggered the Vulnerability Audit.
        """
        VulnerabilityAuditSourceArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            type=type,
            description=description,
            oci_resource_id=oci_resource_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             type: pulumi.Input[str],
             description: Optional[pulumi.Input[str]] = None,
             oci_resource_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("type", type)
        if description is not None:
            _setter("description", description)
        if oci_resource_id is not None:
            _setter("oci_resource_id", oci_resource_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Source type of the Vulnerability Audit.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the external resource source.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ociResourceId")
    def oci_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure resource that triggered the Vulnerability Audit.
        """
        return pulumi.get(self, "oci_resource_id")

    @oci_resource_id.setter
    def oci_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oci_resource_id", value)


@pulumi.input_type
class VulnerabilityAuditVulnerabilityArgs:
    def __init__(__self__, *,
                 cvss_v2score: Optional[pulumi.Input[float]] = None,
                 cvss_v3score: Optional[pulumi.Input[float]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 is_ignored: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[float] cvss_v2score: Common Vulnerability Scoring System (CVSS) Version 2.
        :param pulumi.Input[float] cvss_v3score: Common Vulnerability Scoring System (CVSS) Version 3.
        :param pulumi.Input[str] id: Unique vulnerability identifier, e.g. CVE-1999-0067.
        :param pulumi.Input[bool] is_ignored: Indicates if the vulnerability was ignored according to the audit configuration.
        """
        VulnerabilityAuditVulnerabilityArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cvss_v2score=cvss_v2score,
            cvss_v3score=cvss_v3score,
            id=id,
            is_ignored=is_ignored,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cvss_v2score: Optional[pulumi.Input[float]] = None,
             cvss_v3score: Optional[pulumi.Input[float]] = None,
             id: Optional[pulumi.Input[str]] = None,
             is_ignored: Optional[pulumi.Input[bool]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if cvss_v2score is not None:
            _setter("cvss_v2score", cvss_v2score)
        if cvss_v3score is not None:
            _setter("cvss_v3score", cvss_v3score)
        if id is not None:
            _setter("id", id)
        if is_ignored is not None:
            _setter("is_ignored", is_ignored)

    @property
    @pulumi.getter(name="cvssV2score")
    def cvss_v2score(self) -> Optional[pulumi.Input[float]]:
        """
        Common Vulnerability Scoring System (CVSS) Version 2.
        """
        return pulumi.get(self, "cvss_v2score")

    @cvss_v2score.setter
    def cvss_v2score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cvss_v2score", value)

    @property
    @pulumi.getter(name="cvssV3score")
    def cvss_v3score(self) -> Optional[pulumi.Input[float]]:
        """
        Common Vulnerability Scoring System (CVSS) Version 3.
        """
        return pulumi.get(self, "cvss_v3score")

    @cvss_v3score.setter
    def cvss_v3score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cvss_v3score", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique vulnerability identifier, e.g. CVE-1999-0067.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="isIgnored")
    def is_ignored(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the vulnerability was ignored according to the audit configuration.
        """
        return pulumi.get(self, "is_ignored")

    @is_ignored.setter
    def is_ignored(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_ignored", value)


@pulumi.input_type
class GetKnowledgebasesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetKnowledgebasesFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetVulnerabilityAuditApplicationDependencyVulnerabilitiesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetVulnerabilityAuditApplicationDependencyVulnerabilitiesFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetVulnerabilityAuditsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetVulnerabilityAuditsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


