# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataAssetArgs', 'DataAsset']

@pulumi.input_type
class DataAssetArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 data_source_details: pulumi.Input['DataAssetDataSourceDetailsArgs'],
                 project_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 private_endpoint_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DataAsset resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID for the data asset's compartment.
        :param pulumi.Input['DataAssetDataSourceDetailsArgs'] data_source_details: Possible data sources
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the data asset.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the Ai data asset
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] private_endpoint_id: OCID of Private Endpoint.
        """
        DataAssetArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            data_source_details=data_source_details,
            project_id=project_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            private_endpoint_id=private_endpoint_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             data_source_details: pulumi.Input['DataAssetDataSourceDetailsArgs'],
             project_id: pulumi.Input[str],
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             private_endpoint_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("data_source_details", data_source_details)
        _setter("project_id", project_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if private_endpoint_id is not None:
            _setter("private_endpoint_id", private_endpoint_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID for the data asset's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dataSourceDetails")
    def data_source_details(self) -> pulumi.Input['DataAssetDataSourceDetailsArgs']:
        """
        Possible data sources
        """
        return pulumi.get(self, "data_source_details")

    @data_source_details.setter
    def data_source_details(self, value: pulumi.Input['DataAssetDataSourceDetailsArgs']):
        pulumi.set(self, "data_source_details", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the data asset.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A short description of the Ai data asset
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of Private Endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @private_endpoint_id.setter
    def private_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_endpoint_id", value)


@pulumi.input_type
class _DataAssetState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 data_source_details: Optional[pulumi.Input['DataAssetDataSourceDetailsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 private_endpoint_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DataAsset resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID for the data asset's compartment.
        :param pulumi.Input['DataAssetDataSourceDetailsArgs'] data_source_details: Possible data sources
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the Ai data asset
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] private_endpoint_id: OCID of Private Endpoint.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the data asset.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The lifecycle state of the Data Asset.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the the DataAsset was created. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time the the DataAsset was updated. An RFC3339 formatted datetime string
        """
        _DataAssetState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            data_source_details=data_source_details,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            private_endpoint_id=private_endpoint_id,
            project_id=project_id,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             data_source_details: Optional[pulumi.Input['DataAssetDataSourceDetailsArgs']] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             private_endpoint_id: Optional[pulumi.Input[str]] = None,
             project_id: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if data_source_details is not None:
            _setter("data_source_details", data_source_details)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if private_endpoint_id is not None:
            _setter("private_endpoint_id", private_endpoint_id)
        if project_id is not None:
            _setter("project_id", project_id)
        if state is not None:
            _setter("state", state)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID for the data asset's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dataSourceDetails")
    def data_source_details(self) -> Optional[pulumi.Input['DataAssetDataSourceDetailsArgs']]:
        """
        Possible data sources
        """
        return pulumi.get(self, "data_source_details")

    @data_source_details.setter
    def data_source_details(self, value: Optional[pulumi.Input['DataAssetDataSourceDetailsArgs']]):
        pulumi.set(self, "data_source_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A short description of the Ai data asset
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of Private Endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @private_endpoint_id.setter
    def private_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_endpoint_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the data asset.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The lifecycle state of the Data Asset.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the the DataAsset was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the the DataAsset was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class DataAsset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 data_source_details: Optional[pulumi.Input[pulumi.InputType['DataAssetDataSourceDetailsArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 private_endpoint_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Data Asset resource in Oracle Cloud Infrastructure Ai Anomaly Detection service.

        Creates a new DataAsset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_data_asset = oci.ai_anomaly_detection.DataAsset("testDataAsset",
            compartment_id=var["compartment_id"],
            data_source_details=oci.ai_anomaly_detection.DataAssetDataSourceDetailsArgs(
                data_source_type=var["data_asset_data_source_details_data_source_type"],
                atp_password_secret_id=oci_vault_secret["test_secret"]["id"],
                atp_user_name=oci_identity_user["test_user"]["name"],
                bucket=var["data_asset_data_source_details_bucket"],
                cwallet_file_secret_id=oci_vault_secret["test_secret"]["id"],
                database_name=oci_database_database["test_database"]["name"],
                ewallet_file_secret_id=oci_vault_secret["test_secret"]["id"],
                key_store_file_secret_id=oci_vault_secret["test_secret"]["id"],
                measurement_name=var["data_asset_data_source_details_measurement_name"],
                namespace=var["data_asset_data_source_details_namespace"],
                object=var["data_asset_data_source_details_object"],
                ojdbc_file_secret_id=oci_vault_secret["test_secret"]["id"],
                password_secret_id=oci_vault_secret["test_secret"]["id"],
                table_name=oci_nosql_table["test_table"]["name"],
                tnsnames_file_secret_id=oci_vault_secret["test_secret"]["id"],
                truststore_file_secret_id=oci_vault_secret["test_secret"]["id"],
                url=var["data_asset_data_source_details_url"],
                user_name=oci_identity_user["test_user"]["name"],
                version_specific_details=oci.ai_anomaly_detection.DataAssetDataSourceDetailsVersionSpecificDetailsArgs(
                    influx_version=var["data_asset_data_source_details_version_specific_details_influx_version"],
                    bucket=var["data_asset_data_source_details_version_specific_details_bucket"],
                    database_name=oci_database_database["test_database"]["name"],
                    organization_name=var["data_asset_data_source_details_version_specific_details_organization_name"],
                    retention_policy_name=oci_identity_policy["test_policy"]["name"],
                ),
                wallet_password_secret_id=oci_vault_secret["test_secret"]["id"],
            ),
            project_id=oci_ai_anomaly_detection_project["test_project"]["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=var["data_asset_description"],
            display_name=var["data_asset_display_name"],
            freeform_tags={
                "bar-key": "value",
            },
            private_endpoint_id=oci_dataflow_private_endpoint["test_private_endpoint"]["id"])
        ```

        ## Import

        DataAssets can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:AiAnomalyDetection/dataAsset:DataAsset test_data_asset "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID for the data asset's compartment.
        :param pulumi.Input[pulumi.InputType['DataAssetDataSourceDetailsArgs']] data_source_details: Possible data sources
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the Ai data asset
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] private_endpoint_id: OCID of Private Endpoint.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the data asset.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataAssetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Data Asset resource in Oracle Cloud Infrastructure Ai Anomaly Detection service.

        Creates a new DataAsset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_data_asset = oci.ai_anomaly_detection.DataAsset("testDataAsset",
            compartment_id=var["compartment_id"],
            data_source_details=oci.ai_anomaly_detection.DataAssetDataSourceDetailsArgs(
                data_source_type=var["data_asset_data_source_details_data_source_type"],
                atp_password_secret_id=oci_vault_secret["test_secret"]["id"],
                atp_user_name=oci_identity_user["test_user"]["name"],
                bucket=var["data_asset_data_source_details_bucket"],
                cwallet_file_secret_id=oci_vault_secret["test_secret"]["id"],
                database_name=oci_database_database["test_database"]["name"],
                ewallet_file_secret_id=oci_vault_secret["test_secret"]["id"],
                key_store_file_secret_id=oci_vault_secret["test_secret"]["id"],
                measurement_name=var["data_asset_data_source_details_measurement_name"],
                namespace=var["data_asset_data_source_details_namespace"],
                object=var["data_asset_data_source_details_object"],
                ojdbc_file_secret_id=oci_vault_secret["test_secret"]["id"],
                password_secret_id=oci_vault_secret["test_secret"]["id"],
                table_name=oci_nosql_table["test_table"]["name"],
                tnsnames_file_secret_id=oci_vault_secret["test_secret"]["id"],
                truststore_file_secret_id=oci_vault_secret["test_secret"]["id"],
                url=var["data_asset_data_source_details_url"],
                user_name=oci_identity_user["test_user"]["name"],
                version_specific_details=oci.ai_anomaly_detection.DataAssetDataSourceDetailsVersionSpecificDetailsArgs(
                    influx_version=var["data_asset_data_source_details_version_specific_details_influx_version"],
                    bucket=var["data_asset_data_source_details_version_specific_details_bucket"],
                    database_name=oci_database_database["test_database"]["name"],
                    organization_name=var["data_asset_data_source_details_version_specific_details_organization_name"],
                    retention_policy_name=oci_identity_policy["test_policy"]["name"],
                ),
                wallet_password_secret_id=oci_vault_secret["test_secret"]["id"],
            ),
            project_id=oci_ai_anomaly_detection_project["test_project"]["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=var["data_asset_description"],
            display_name=var["data_asset_display_name"],
            freeform_tags={
                "bar-key": "value",
            },
            private_endpoint_id=oci_dataflow_private_endpoint["test_private_endpoint"]["id"])
        ```

        ## Import

        DataAssets can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:AiAnomalyDetection/dataAsset:DataAsset test_data_asset "id"
        ```

        :param str resource_name: The name of the resource.
        :param DataAssetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataAssetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            DataAssetArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 data_source_details: Optional[pulumi.Input[pulumi.InputType['DataAssetDataSourceDetailsArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 private_endpoint_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataAssetArgs.__new__(DataAssetArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if data_source_details is not None and not isinstance(data_source_details, DataAssetDataSourceDetailsArgs):
                data_source_details = data_source_details or {}
                def _setter(key, value):
                    data_source_details[key] = value
                DataAssetDataSourceDetailsArgs._configure(_setter, **data_source_details)
            if data_source_details is None and not opts.urn:
                raise TypeError("Missing required property 'data_source_details'")
            __props__.__dict__["data_source_details"] = data_source_details
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["private_endpoint_id"] = private_endpoint_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(DataAsset, __self__).__init__(
            'oci:AiAnomalyDetection/dataAsset:DataAsset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            data_source_details: Optional[pulumi.Input[pulumi.InputType['DataAssetDataSourceDetailsArgs']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            private_endpoint_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'DataAsset':
        """
        Get an existing DataAsset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID for the data asset's compartment.
        :param pulumi.Input[pulumi.InputType['DataAssetDataSourceDetailsArgs']] data_source_details: Possible data sources
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the Ai data asset
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] private_endpoint_id: OCID of Private Endpoint.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the data asset.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The lifecycle state of the Data Asset.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the the DataAsset was created. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time the the DataAsset was updated. An RFC3339 formatted datetime string
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataAssetState.__new__(_DataAssetState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["data_source_details"] = data_source_details
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["private_endpoint_id"] = private_endpoint_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return DataAsset(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID for the data asset's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataSourceDetails")
    def data_source_details(self) -> pulumi.Output['outputs.DataAssetDataSourceDetails']:
        """
        Possible data sources
        """
        return pulumi.get(self, "data_source_details")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) A short description of the Ai data asset
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> pulumi.Output[str]:
        """
        OCID of Private Endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the data asset.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The lifecycle state of the Data Asset.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the the DataAsset was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the the DataAsset was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

