# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDetectionDataAssetResult',
    'AwaitableGetDetectionDataAssetResult',
    'get_detection_data_asset',
    'get_detection_data_asset_output',
]

@pulumi.output_type
class GetDetectionDataAssetResult:
    """
    A collection of values returned by getDetectionDataAsset.
    """
    def __init__(__self__, compartment_id=None, data_asset_id=None, data_source_details=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, private_endpoint_id=None, project_id=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if data_asset_id and not isinstance(data_asset_id, str):
            raise TypeError("Expected argument 'data_asset_id' to be a str")
        pulumi.set(__self__, "data_asset_id", data_asset_id)
        if data_source_details and not isinstance(data_source_details, list):
            raise TypeError("Expected argument 'data_source_details' to be a list")
        pulumi.set(__self__, "data_source_details", data_source_details)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if private_endpoint_id and not isinstance(private_endpoint_id, str):
            raise TypeError("Expected argument 'private_endpoint_id' to be a str")
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the DataAsset.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataAssetId")
    def data_asset_id(self) -> str:
        return pulumi.get(self, "data_asset_id")

    @property
    @pulumi.getter(name="dataSourceDetails")
    def data_source_details(self) -> Sequence['outputs.GetDetectionDataAssetDataSourceDetailResult']:
        """
        Possible data sources
        """
        return pulumi.get(self, "data_source_details")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A short description of the data asset.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Unique Oracle ID (OCID) that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> str:
        """
        OCID of Private Endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The Unique project id which is created at project creation that is immutable on creation.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The lifecycle state of the Data Asset.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the DataAsset was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the the DataAsset was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetDetectionDataAssetResult(GetDetectionDataAssetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDetectionDataAssetResult(
            compartment_id=self.compartment_id,
            data_asset_id=self.data_asset_id,
            data_source_details=self.data_source_details,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            private_endpoint_id=self.private_endpoint_id,
            project_id=self.project_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_detection_data_asset(data_asset_id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDetectionDataAssetResult:
    """
    This data source provides details about a specific Data Asset resource in Oracle Cloud Infrastructure Ai Anomaly Detection service.

    Gets a DataAsset by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_asset = oci.AiAnomalyDetection.get_detection_data_asset(data_asset_id=oci_ai_anomaly_detection_data_asset["test_data_asset"]["id"])
    ```


    :param str data_asset_id: The OCID of the Data Asset.
    """
    __args__ = dict()
    __args__['dataAssetId'] = data_asset_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:AiAnomalyDetection/getDetectionDataAsset:getDetectionDataAsset', __args__, opts=opts, typ=GetDetectionDataAssetResult).value

    return AwaitableGetDetectionDataAssetResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        data_asset_id=pulumi.get(__ret__, 'data_asset_id'),
        data_source_details=pulumi.get(__ret__, 'data_source_details'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        private_endpoint_id=pulumi.get(__ret__, 'private_endpoint_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_detection_data_asset)
def get_detection_data_asset_output(data_asset_id: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDetectionDataAssetResult]:
    """
    This data source provides details about a specific Data Asset resource in Oracle Cloud Infrastructure Ai Anomaly Detection service.

    Gets a DataAsset by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_asset = oci.AiAnomalyDetection.get_detection_data_asset(data_asset_id=oci_ai_anomaly_detection_data_asset["test_data_asset"]["id"])
    ```


    :param str data_asset_id: The OCID of the Data Asset.
    """
    ...
