# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ModelEvaluationResult',
    'ModelEvaluationResultClassMetric',
    'ModelEvaluationResultEntityMetric',
    'ModelEvaluationResultMetric',
    'ModelModelDetails',
    'ModelModelDetailsClassificationMode',
    'ModelTestStrategy',
    'ModelTestStrategyTestingDataset',
    'ModelTestStrategyTestingDatasetLocationDetails',
    'ModelTestStrategyValidationDataset',
    'ModelTestStrategyValidationDatasetLocationDetails',
    'ModelTrainingDataset',
    'ModelTrainingDatasetLocationDetails',
    'GetEndpointsEndpointCollectionResult',
    'GetEndpointsEndpointCollectionItemResult',
    'GetEndpointsFilterResult',
    'GetModelEvaluationResultResult',
    'GetModelEvaluationResultClassMetricResult',
    'GetModelEvaluationResultEntityMetricResult',
    'GetModelEvaluationResultMetricResult',
    'GetModelEvaluationResultsEvaluationResultCollectionResult',
    'GetModelEvaluationResultsEvaluationResultCollectionItemResult',
    'GetModelEvaluationResultsEvaluationResultCollectionItemPredictedEntityResult',
    'GetModelEvaluationResultsEvaluationResultCollectionItemTrueEntityResult',
    'GetModelEvaluationResultsFilterResult',
    'GetModelModelDetailResult',
    'GetModelModelDetailClassificationModeResult',
    'GetModelTestStrategyResult',
    'GetModelTestStrategyTestingDatasetResult',
    'GetModelTestStrategyTestingDatasetLocationDetailResult',
    'GetModelTestStrategyValidationDatasetResult',
    'GetModelTestStrategyValidationDatasetLocationDetailResult',
    'GetModelTrainingDatasetResult',
    'GetModelTrainingDatasetLocationDetailResult',
    'GetModelsFilterResult',
    'GetModelsModelCollectionResult',
    'GetModelsModelCollectionItemResult',
    'GetModelsModelCollectionItemEvaluationResultResult',
    'GetModelsModelCollectionItemEvaluationResultClassMetricResult',
    'GetModelsModelCollectionItemEvaluationResultEntityMetricResult',
    'GetModelsModelCollectionItemEvaluationResultMetricResult',
    'GetModelsModelCollectionItemModelDetailResult',
    'GetModelsModelCollectionItemModelDetailClassificationModeResult',
    'GetModelsModelCollectionItemTestStrategyResult',
    'GetModelsModelCollectionItemTestStrategyTestingDatasetResult',
    'GetModelsModelCollectionItemTestStrategyTestingDatasetLocationDetailResult',
    'GetModelsModelCollectionItemTestStrategyValidationDatasetResult',
    'GetModelsModelCollectionItemTestStrategyValidationDatasetLocationDetailResult',
    'GetModelsModelCollectionItemTrainingDatasetResult',
    'GetModelsModelCollectionItemTrainingDatasetLocationDetailResult',
    'GetProjectsFilterResult',
    'GetProjectsProjectCollectionResult',
    'GetProjectsProjectCollectionItemResult',
]

@pulumi.output_type
class ModelEvaluationResult(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "classMetrics":
            suggest = "class_metrics"
        elif key == "confusionMatrix":
            suggest = "confusion_matrix"
        elif key == "entityMetrics":
            suggest = "entity_metrics"
        elif key == "modelType":
            suggest = "model_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelEvaluationResult. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelEvaluationResult.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelEvaluationResult.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 class_metrics: Optional[Sequence['outputs.ModelEvaluationResultClassMetric']] = None,
                 confusion_matrix: Optional[str] = None,
                 entity_metrics: Optional[Sequence['outputs.ModelEvaluationResultEntityMetric']] = None,
                 labels: Optional[Sequence[str]] = None,
                 metrics: Optional[Sequence['outputs.ModelEvaluationResultMetric']] = None,
                 model_type: Optional[str] = None):
        """
        :param Sequence['ModelEvaluationResultClassMetricArgs'] class_metrics: List of text classification metrics
        :param str confusion_matrix: class level confusion matrix
        :param Sequence['ModelEvaluationResultEntityMetricArgs'] entity_metrics: List of entity metrics
        :param Sequence[str] labels: labels
        :param Sequence['ModelEvaluationResultMetricArgs'] metrics: Model level named entity recognition metrics
        :param str model_type: Model type
        """
        ModelEvaluationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            class_metrics=class_metrics,
            confusion_matrix=confusion_matrix,
            entity_metrics=entity_metrics,
            labels=labels,
            metrics=metrics,
            model_type=model_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             class_metrics: Optional[Sequence['outputs.ModelEvaluationResultClassMetric']] = None,
             confusion_matrix: Optional[str] = None,
             entity_metrics: Optional[Sequence['outputs.ModelEvaluationResultEntityMetric']] = None,
             labels: Optional[Sequence[str]] = None,
             metrics: Optional[Sequence['outputs.ModelEvaluationResultMetric']] = None,
             model_type: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if class_metrics is not None:
            _setter("class_metrics", class_metrics)
        if confusion_matrix is not None:
            _setter("confusion_matrix", confusion_matrix)
        if entity_metrics is not None:
            _setter("entity_metrics", entity_metrics)
        if labels is not None:
            _setter("labels", labels)
        if metrics is not None:
            _setter("metrics", metrics)
        if model_type is not None:
            _setter("model_type", model_type)

    @property
    @pulumi.getter(name="classMetrics")
    def class_metrics(self) -> Optional[Sequence['outputs.ModelEvaluationResultClassMetric']]:
        """
        List of text classification metrics
        """
        return pulumi.get(self, "class_metrics")

    @property
    @pulumi.getter(name="confusionMatrix")
    def confusion_matrix(self) -> Optional[str]:
        """
        class level confusion matrix
        """
        return pulumi.get(self, "confusion_matrix")

    @property
    @pulumi.getter(name="entityMetrics")
    def entity_metrics(self) -> Optional[Sequence['outputs.ModelEvaluationResultEntityMetric']]:
        """
        List of entity metrics
        """
        return pulumi.get(self, "entity_metrics")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Sequence[str]]:
        """
        labels
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.ModelEvaluationResultMetric']]:
        """
        Model level named entity recognition metrics
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[str]:
        """
        Model type
        """
        return pulumi.get(self, "model_type")


@pulumi.output_type
class ModelEvaluationResultClassMetric(dict):
    def __init__(__self__, *,
                 f1: Optional[float] = None,
                 label: Optional[str] = None,
                 precision: Optional[float] = None,
                 recall: Optional[float] = None,
                 support: Optional[float] = None):
        """
        :param float f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param str label: Entity label
        :param float precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param float recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param float support: number of samples in the test set
        """
        ModelEvaluationResultClassMetric._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            f1=f1,
            label=label,
            precision=precision,
            recall=recall,
            support=support,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             f1: Optional[float] = None,
             label: Optional[str] = None,
             precision: Optional[float] = None,
             recall: Optional[float] = None,
             support: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if f1 is not None:
            _setter("f1", f1)
        if label is not None:
            _setter("label", label)
        if precision is not None:
            _setter("precision", precision)
        if recall is not None:
            _setter("recall", recall)
        if support is not None:
            _setter("support", support)

    @property
    @pulumi.getter
    def f1(self) -> Optional[float]:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "f1")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        Entity label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def precision(self) -> Optional[float]:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> Optional[float]:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "recall")

    @property
    @pulumi.getter
    def support(self) -> Optional[float]:
        """
        number of samples in the test set
        """
        return pulumi.get(self, "support")


@pulumi.output_type
class ModelEvaluationResultEntityMetric(dict):
    def __init__(__self__, *,
                 f1: Optional[float] = None,
                 label: Optional[str] = None,
                 precision: Optional[float] = None,
                 recall: Optional[float] = None):
        """
        :param float f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param str label: Entity label
        :param float precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param float recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        ModelEvaluationResultEntityMetric._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            f1=f1,
            label=label,
            precision=precision,
            recall=recall,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             f1: Optional[float] = None,
             label: Optional[str] = None,
             precision: Optional[float] = None,
             recall: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if f1 is not None:
            _setter("f1", f1)
        if label is not None:
            _setter("label", label)
        if precision is not None:
            _setter("precision", precision)
        if recall is not None:
            _setter("recall", recall)

    @property
    @pulumi.getter
    def f1(self) -> Optional[float]:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "f1")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        Entity label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def precision(self) -> Optional[float]:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> Optional[float]:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "recall")


@pulumi.output_type
class ModelEvaluationResultMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "macroF1":
            suggest = "macro_f1"
        elif key == "macroPrecision":
            suggest = "macro_precision"
        elif key == "macroRecall":
            suggest = "macro_recall"
        elif key == "microF1":
            suggest = "micro_f1"
        elif key == "microPrecision":
            suggest = "micro_precision"
        elif key == "microRecall":
            suggest = "micro_recall"
        elif key == "weightedF1":
            suggest = "weighted_f1"
        elif key == "weightedPrecision":
            suggest = "weighted_precision"
        elif key == "weightedRecall":
            suggest = "weighted_recall"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelEvaluationResultMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelEvaluationResultMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelEvaluationResultMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accuracy: Optional[float] = None,
                 macro_f1: Optional[float] = None,
                 macro_precision: Optional[float] = None,
                 macro_recall: Optional[float] = None,
                 micro_f1: Optional[float] = None,
                 micro_precision: Optional[float] = None,
                 micro_recall: Optional[float] = None,
                 weighted_f1: Optional[float] = None,
                 weighted_precision: Optional[float] = None,
                 weighted_recall: Optional[float] = None):
        """
        :param float accuracy: The fraction of the labels that were correctly recognised .
        :param float macro_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param float macro_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param float macro_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param float micro_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param float micro_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param float micro_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param float weighted_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param float weighted_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param float weighted_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        ModelEvaluationResultMetric._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            accuracy=accuracy,
            macro_f1=macro_f1,
            macro_precision=macro_precision,
            macro_recall=macro_recall,
            micro_f1=micro_f1,
            micro_precision=micro_precision,
            micro_recall=micro_recall,
            weighted_f1=weighted_f1,
            weighted_precision=weighted_precision,
            weighted_recall=weighted_recall,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             accuracy: Optional[float] = None,
             macro_f1: Optional[float] = None,
             macro_precision: Optional[float] = None,
             macro_recall: Optional[float] = None,
             micro_f1: Optional[float] = None,
             micro_precision: Optional[float] = None,
             micro_recall: Optional[float] = None,
             weighted_f1: Optional[float] = None,
             weighted_precision: Optional[float] = None,
             weighted_recall: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if accuracy is not None:
            _setter("accuracy", accuracy)
        if macro_f1 is not None:
            _setter("macro_f1", macro_f1)
        if macro_precision is not None:
            _setter("macro_precision", macro_precision)
        if macro_recall is not None:
            _setter("macro_recall", macro_recall)
        if micro_f1 is not None:
            _setter("micro_f1", micro_f1)
        if micro_precision is not None:
            _setter("micro_precision", micro_precision)
        if micro_recall is not None:
            _setter("micro_recall", micro_recall)
        if weighted_f1 is not None:
            _setter("weighted_f1", weighted_f1)
        if weighted_precision is not None:
            _setter("weighted_precision", weighted_precision)
        if weighted_recall is not None:
            _setter("weighted_recall", weighted_recall)

    @property
    @pulumi.getter
    def accuracy(self) -> Optional[float]:
        """
        The fraction of the labels that were correctly recognised .
        """
        return pulumi.get(self, "accuracy")

    @property
    @pulumi.getter(name="macroF1")
    def macro_f1(self) -> Optional[float]:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "macro_f1")

    @property
    @pulumi.getter(name="macroPrecision")
    def macro_precision(self) -> Optional[float]:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "macro_precision")

    @property
    @pulumi.getter(name="macroRecall")
    def macro_recall(self) -> Optional[float]:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "macro_recall")

    @property
    @pulumi.getter(name="microF1")
    def micro_f1(self) -> Optional[float]:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "micro_f1")

    @property
    @pulumi.getter(name="microPrecision")
    def micro_precision(self) -> Optional[float]:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "micro_precision")

    @property
    @pulumi.getter(name="microRecall")
    def micro_recall(self) -> Optional[float]:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "micro_recall")

    @property
    @pulumi.getter(name="weightedF1")
    def weighted_f1(self) -> Optional[float]:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "weighted_f1")

    @property
    @pulumi.getter(name="weightedPrecision")
    def weighted_precision(self) -> Optional[float]:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "weighted_precision")

    @property
    @pulumi.getter(name="weightedRecall")
    def weighted_recall(self) -> Optional[float]:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "weighted_recall")


@pulumi.output_type
class ModelModelDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modelType":
            suggest = "model_type"
        elif key == "classificationMode":
            suggest = "classification_mode"
        elif key == "languageCode":
            suggest = "language_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelModelDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelModelDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelModelDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 model_type: str,
                 classification_mode: Optional['outputs.ModelModelDetailsClassificationMode'] = None,
                 language_code: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str model_type: Model type
        :param 'ModelModelDetailsClassificationModeArgs' classification_mode: classification Modes
        :param str language_code: supported language default value is en
        :param str version: Optional pre trained model version. if nothing specified latest pre trained model will be used.  Supported versions can be found at /modelTypes/{modelType}
        """
        ModelModelDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            model_type=model_type,
            classification_mode=classification_mode,
            language_code=language_code,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             model_type: str,
             classification_mode: Optional['outputs.ModelModelDetailsClassificationMode'] = None,
             language_code: Optional[str] = None,
             version: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("model_type", model_type)
        if classification_mode is not None:
            _setter("classification_mode", classification_mode)
        if language_code is not None:
            _setter("language_code", language_code)
        if version is not None:
            _setter("version", version)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> str:
        """
        Model type
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="classificationMode")
    def classification_mode(self) -> Optional['outputs.ModelModelDetailsClassificationMode']:
        """
        classification Modes
        """
        return pulumi.get(self, "classification_mode")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[str]:
        """
        supported language default value is en
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Optional pre trained model version. if nothing specified latest pre trained model will be used.  Supported versions can be found at /modelTypes/{modelType}
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ModelModelDetailsClassificationMode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "classificationMode":
            suggest = "classification_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelModelDetailsClassificationMode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelModelDetailsClassificationMode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelModelDetailsClassificationMode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 classification_mode: str,
                 version: Optional[str] = None):
        """
        :param str classification_mode: classification Modes
        :param str version: Optional pre trained model version. if nothing specified latest pre trained model will be used.  Supported versions can be found at /modelTypes/{modelType}
        """
        ModelModelDetailsClassificationMode._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            classification_mode=classification_mode,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             classification_mode: str,
             version: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("classification_mode", classification_mode)
        if version is not None:
            _setter("version", version)

    @property
    @pulumi.getter(name="classificationMode")
    def classification_mode(self) -> str:
        """
        classification Modes
        """
        return pulumi.get(self, "classification_mode")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Optional pre trained model version. if nothing specified latest pre trained model will be used.  Supported versions can be found at /modelTypes/{modelType}
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ModelTestStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "strategyType":
            suggest = "strategy_type"
        elif key == "testingDataset":
            suggest = "testing_dataset"
        elif key == "validationDataset":
            suggest = "validation_dataset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTestStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTestStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTestStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 strategy_type: str,
                 testing_dataset: 'outputs.ModelTestStrategyTestingDataset',
                 validation_dataset: Optional['outputs.ModelTestStrategyValidationDataset'] = None):
        """
        :param str strategy_type: This information will define the test strategy different datasets for test and validation(optional) dataset.
        :param 'ModelTestStrategyTestingDatasetArgs' testing_dataset: Possible data set type
        :param 'ModelTestStrategyValidationDatasetArgs' validation_dataset: Possible data set type
        """
        ModelTestStrategy._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            strategy_type=strategy_type,
            testing_dataset=testing_dataset,
            validation_dataset=validation_dataset,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             strategy_type: str,
             testing_dataset: 'outputs.ModelTestStrategyTestingDataset',
             validation_dataset: Optional['outputs.ModelTestStrategyValidationDataset'] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("strategy_type", strategy_type)
        _setter("testing_dataset", testing_dataset)
        if validation_dataset is not None:
            _setter("validation_dataset", validation_dataset)

    @property
    @pulumi.getter(name="strategyType")
    def strategy_type(self) -> str:
        """
        This information will define the test strategy different datasets for test and validation(optional) dataset.
        """
        return pulumi.get(self, "strategy_type")

    @property
    @pulumi.getter(name="testingDataset")
    def testing_dataset(self) -> 'outputs.ModelTestStrategyTestingDataset':
        """
        Possible data set type
        """
        return pulumi.get(self, "testing_dataset")

    @property
    @pulumi.getter(name="validationDataset")
    def validation_dataset(self) -> Optional['outputs.ModelTestStrategyValidationDataset']:
        """
        Possible data set type
        """
        return pulumi.get(self, "validation_dataset")


@pulumi.output_type
class ModelTestStrategyTestingDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetType":
            suggest = "dataset_type"
        elif key == "datasetId":
            suggest = "dataset_id"
        elif key == "locationDetails":
            suggest = "location_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTestStrategyTestingDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTestStrategyTestingDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTestStrategyTestingDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_type: str,
                 dataset_id: Optional[str] = None,
                 location_details: Optional['outputs.ModelTestStrategyTestingDatasetLocationDetails'] = None):
        """
        :param str dataset_type: Possible data sets
        :param str dataset_id: Data Science Labelling Service OCID
        :param 'ModelTestStrategyTestingDatasetLocationDetailsArgs' location_details: Possible object storage location types
        """
        ModelTestStrategyTestingDataset._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dataset_type=dataset_type,
            dataset_id=dataset_id,
            location_details=location_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dataset_type: str,
             dataset_id: Optional[str] = None,
             location_details: Optional['outputs.ModelTestStrategyTestingDatasetLocationDetails'] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("dataset_type", dataset_type)
        if dataset_id is not None:
            _setter("dataset_id", dataset_id)
        if location_details is not None:
            _setter("location_details", location_details)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[str]:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Optional['outputs.ModelTestStrategyTestingDatasetLocationDetails']:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")


@pulumi.output_type
class ModelTestStrategyTestingDatasetLocationDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "locationType":
            suggest = "location_type"
        elif key == "objectNames":
            suggest = "object_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTestStrategyTestingDatasetLocationDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTestStrategyTestingDatasetLocationDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTestStrategyTestingDatasetLocationDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 location_type: str,
                 namespace: str,
                 object_names: Sequence[str]):
        """
        :param str bucket: Object storage bucket name
        :param str location_type: Possible object storage location types
        :param str namespace: Object storage namespace
        :param Sequence[str] object_names: Array of files which need to be processed in the bucket
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ModelTestStrategyTestingDatasetLocationDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            location_type=location_type,
            namespace=namespace,
            object_names=object_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             location_type: str,
             namespace: str,
             object_names: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("location_type", location_type)
        _setter("namespace", namespace)
        _setter("object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> str:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> Sequence[str]:
        """
        Array of files which need to be processed in the bucket


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "object_names")


@pulumi.output_type
class ModelTestStrategyValidationDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetType":
            suggest = "dataset_type"
        elif key == "datasetId":
            suggest = "dataset_id"
        elif key == "locationDetails":
            suggest = "location_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTestStrategyValidationDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTestStrategyValidationDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTestStrategyValidationDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_type: str,
                 dataset_id: Optional[str] = None,
                 location_details: Optional['outputs.ModelTestStrategyValidationDatasetLocationDetails'] = None):
        """
        :param str dataset_type: Possible data sets
        :param str dataset_id: Data Science Labelling Service OCID
        :param 'ModelTestStrategyValidationDatasetLocationDetailsArgs' location_details: Possible object storage location types
        """
        ModelTestStrategyValidationDataset._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dataset_type=dataset_type,
            dataset_id=dataset_id,
            location_details=location_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dataset_type: str,
             dataset_id: Optional[str] = None,
             location_details: Optional['outputs.ModelTestStrategyValidationDatasetLocationDetails'] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("dataset_type", dataset_type)
        if dataset_id is not None:
            _setter("dataset_id", dataset_id)
        if location_details is not None:
            _setter("location_details", location_details)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[str]:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Optional['outputs.ModelTestStrategyValidationDatasetLocationDetails']:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")


@pulumi.output_type
class ModelTestStrategyValidationDatasetLocationDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "locationType":
            suggest = "location_type"
        elif key == "objectNames":
            suggest = "object_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTestStrategyValidationDatasetLocationDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTestStrategyValidationDatasetLocationDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTestStrategyValidationDatasetLocationDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 location_type: str,
                 namespace: str,
                 object_names: Sequence[str]):
        """
        :param str bucket: Object storage bucket name
        :param str location_type: Possible object storage location types
        :param str namespace: Object storage namespace
        :param Sequence[str] object_names: Array of files which need to be processed in the bucket
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ModelTestStrategyValidationDatasetLocationDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            location_type=location_type,
            namespace=namespace,
            object_names=object_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             location_type: str,
             namespace: str,
             object_names: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("location_type", location_type)
        _setter("namespace", namespace)
        _setter("object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> str:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> Sequence[str]:
        """
        Array of files which need to be processed in the bucket


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "object_names")


@pulumi.output_type
class ModelTrainingDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetType":
            suggest = "dataset_type"
        elif key == "datasetId":
            suggest = "dataset_id"
        elif key == "locationDetails":
            suggest = "location_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTrainingDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTrainingDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTrainingDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_type: str,
                 dataset_id: Optional[str] = None,
                 location_details: Optional['outputs.ModelTrainingDatasetLocationDetails'] = None):
        """
        :param str dataset_type: Possible data sets
        :param str dataset_id: Data Science Labelling Service OCID
        :param 'ModelTrainingDatasetLocationDetailsArgs' location_details: Possible object storage location types
        """
        ModelTrainingDataset._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dataset_type=dataset_type,
            dataset_id=dataset_id,
            location_details=location_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dataset_type: str,
             dataset_id: Optional[str] = None,
             location_details: Optional['outputs.ModelTrainingDatasetLocationDetails'] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("dataset_type", dataset_type)
        if dataset_id is not None:
            _setter("dataset_id", dataset_id)
        if location_details is not None:
            _setter("location_details", location_details)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[str]:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Optional['outputs.ModelTrainingDatasetLocationDetails']:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")


@pulumi.output_type
class ModelTrainingDatasetLocationDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "locationType":
            suggest = "location_type"
        elif key == "objectNames":
            suggest = "object_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTrainingDatasetLocationDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTrainingDatasetLocationDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTrainingDatasetLocationDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 location_type: str,
                 namespace: str,
                 object_names: Sequence[str]):
        """
        :param str bucket: Object storage bucket name
        :param str location_type: Possible object storage location types
        :param str namespace: Object storage namespace
        :param Sequence[str] object_names: Array of files which need to be processed in the bucket
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ModelTrainingDatasetLocationDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            location_type=location_type,
            namespace=namespace,
            object_names=object_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             location_type: str,
             namespace: str,
             object_names: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("location_type", location_type)
        _setter("namespace", namespace)
        _setter("object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> str:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> Sequence[str]:
        """
        Array of files which need to be processed in the bucket


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "object_names")


@pulumi.output_type
class GetEndpointsEndpointCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetEndpointsEndpointCollectionItemResult']):
        GetEndpointsEndpointCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetEndpointsEndpointCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetEndpointsEndpointCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetEndpointsEndpointCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 inference_units: int,
                 lifecycle_details: str,
                 model_id: str,
                 project_id: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: A short description of the endpoint.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: Unique identifier endpoint OCID of an endpoint that is immutable on creation.
        :param int inference_units: Number of replicas required for this endpoint.
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in failed state.
        :param str model_id: The ID of the trained model for which to list the endpoints.
        :param str project_id: The ID of the project for which to list the objects.
        :param str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time the the endpoint was created. An RFC3339 formatted datetime string.
        :param str time_updated: The time the endpoint was updated. An RFC3339 formatted datetime string.
        """
        GetEndpointsEndpointCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            inference_units=inference_units,
            lifecycle_details=lifecycle_details,
            model_id=model_id,
            project_id=project_id,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             inference_units: int,
             lifecycle_details: str,
             model_id: str,
             project_id: str,
             state: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("inference_units", inference_units)
        _setter("lifecycle_details", lifecycle_details)
        _setter("model_id", model_id)
        _setter("project_id", project_id)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A short description of the endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier endpoint OCID of an endpoint that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inferenceUnits")
    def inference_units(self) -> int:
        """
        Number of replicas required for this endpoint.
        """
        return pulumi.get(self, "inference_units")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> str:
        """
        The ID of the trained model for which to list the endpoints.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project for which to list the objects.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the endpoint was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the endpoint was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetEndpointsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetModelEvaluationResultResult(dict):
    def __init__(__self__, *,
                 class_metrics: Sequence['outputs.GetModelEvaluationResultClassMetricResult'],
                 confusion_matrix: str,
                 entity_metrics: Sequence['outputs.GetModelEvaluationResultEntityMetricResult'],
                 labels: Sequence[str],
                 metrics: Sequence['outputs.GetModelEvaluationResultMetricResult'],
                 model_type: str):
        """
        :param Sequence['GetModelEvaluationResultClassMetricArgs'] class_metrics: List of text classification metrics
        :param str confusion_matrix: class level confusion matrix
        :param Sequence['GetModelEvaluationResultEntityMetricArgs'] entity_metrics: List of entity metrics
        :param Sequence[str] labels: labels
        :param Sequence['GetModelEvaluationResultMetricArgs'] metrics: Model level named entity recognition metrics
        :param str model_type: Model type
        """
        GetModelEvaluationResultResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            class_metrics=class_metrics,
            confusion_matrix=confusion_matrix,
            entity_metrics=entity_metrics,
            labels=labels,
            metrics=metrics,
            model_type=model_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             class_metrics: Sequence['outputs.GetModelEvaluationResultClassMetricResult'],
             confusion_matrix: str,
             entity_metrics: Sequence['outputs.GetModelEvaluationResultEntityMetricResult'],
             labels: Sequence[str],
             metrics: Sequence['outputs.GetModelEvaluationResultMetricResult'],
             model_type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("class_metrics", class_metrics)
        _setter("confusion_matrix", confusion_matrix)
        _setter("entity_metrics", entity_metrics)
        _setter("labels", labels)
        _setter("metrics", metrics)
        _setter("model_type", model_type)

    @property
    @pulumi.getter(name="classMetrics")
    def class_metrics(self) -> Sequence['outputs.GetModelEvaluationResultClassMetricResult']:
        """
        List of text classification metrics
        """
        return pulumi.get(self, "class_metrics")

    @property
    @pulumi.getter(name="confusionMatrix")
    def confusion_matrix(self) -> str:
        """
        class level confusion matrix
        """
        return pulumi.get(self, "confusion_matrix")

    @property
    @pulumi.getter(name="entityMetrics")
    def entity_metrics(self) -> Sequence['outputs.GetModelEvaluationResultEntityMetricResult']:
        """
        List of entity metrics
        """
        return pulumi.get(self, "entity_metrics")

    @property
    @pulumi.getter
    def labels(self) -> Sequence[str]:
        """
        labels
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetModelEvaluationResultMetricResult']:
        """
        Model level named entity recognition metrics
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> str:
        """
        Model type
        """
        return pulumi.get(self, "model_type")


@pulumi.output_type
class GetModelEvaluationResultClassMetricResult(dict):
    def __init__(__self__, *,
                 f1: float,
                 label: str,
                 precision: float,
                 recall: float,
                 support: float):
        """
        :param float f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param str label: Entity label
        :param float precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param float recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param float support: number of samples in the test set
        """
        GetModelEvaluationResultClassMetricResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            f1=f1,
            label=label,
            precision=precision,
            recall=recall,
            support=support,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             f1: float,
             label: str,
             precision: float,
             recall: float,
             support: float,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("f1", f1)
        _setter("label", label)
        _setter("precision", precision)
        _setter("recall", recall)
        _setter("support", support)

    @property
    @pulumi.getter
    def f1(self) -> float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "f1")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Entity label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def precision(self) -> float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "recall")

    @property
    @pulumi.getter
    def support(self) -> float:
        """
        number of samples in the test set
        """
        return pulumi.get(self, "support")


@pulumi.output_type
class GetModelEvaluationResultEntityMetricResult(dict):
    def __init__(__self__, *,
                 f1: float,
                 label: str,
                 precision: float,
                 recall: float):
        """
        :param float f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param str label: Entity label
        :param float precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param float recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        GetModelEvaluationResultEntityMetricResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            f1=f1,
            label=label,
            precision=precision,
            recall=recall,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             f1: float,
             label: str,
             precision: float,
             recall: float,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("f1", f1)
        _setter("label", label)
        _setter("precision", precision)
        _setter("recall", recall)

    @property
    @pulumi.getter
    def f1(self) -> float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "f1")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Entity label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def precision(self) -> float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "recall")


@pulumi.output_type
class GetModelEvaluationResultMetricResult(dict):
    def __init__(__self__, *,
                 accuracy: float,
                 macro_f1: float,
                 macro_precision: float,
                 macro_recall: float,
                 micro_f1: float,
                 micro_precision: float,
                 micro_recall: float,
                 weighted_f1: float,
                 weighted_precision: float,
                 weighted_recall: float):
        """
        :param float accuracy: The fraction of the labels that were correctly recognised .
        :param float macro_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param float macro_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param float macro_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param float micro_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param float micro_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param float micro_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param float weighted_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param float weighted_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param float weighted_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        GetModelEvaluationResultMetricResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            accuracy=accuracy,
            macro_f1=macro_f1,
            macro_precision=macro_precision,
            macro_recall=macro_recall,
            micro_f1=micro_f1,
            micro_precision=micro_precision,
            micro_recall=micro_recall,
            weighted_f1=weighted_f1,
            weighted_precision=weighted_precision,
            weighted_recall=weighted_recall,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             accuracy: float,
             macro_f1: float,
             macro_precision: float,
             macro_recall: float,
             micro_f1: float,
             micro_precision: float,
             micro_recall: float,
             weighted_f1: float,
             weighted_precision: float,
             weighted_recall: float,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("accuracy", accuracy)
        _setter("macro_f1", macro_f1)
        _setter("macro_precision", macro_precision)
        _setter("macro_recall", macro_recall)
        _setter("micro_f1", micro_f1)
        _setter("micro_precision", micro_precision)
        _setter("micro_recall", micro_recall)
        _setter("weighted_f1", weighted_f1)
        _setter("weighted_precision", weighted_precision)
        _setter("weighted_recall", weighted_recall)

    @property
    @pulumi.getter
    def accuracy(self) -> float:
        """
        The fraction of the labels that were correctly recognised .
        """
        return pulumi.get(self, "accuracy")

    @property
    @pulumi.getter(name="macroF1")
    def macro_f1(self) -> float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "macro_f1")

    @property
    @pulumi.getter(name="macroPrecision")
    def macro_precision(self) -> float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "macro_precision")

    @property
    @pulumi.getter(name="macroRecall")
    def macro_recall(self) -> float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "macro_recall")

    @property
    @pulumi.getter(name="microF1")
    def micro_f1(self) -> float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "micro_f1")

    @property
    @pulumi.getter(name="microPrecision")
    def micro_precision(self) -> float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "micro_precision")

    @property
    @pulumi.getter(name="microRecall")
    def micro_recall(self) -> float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "micro_recall")

    @property
    @pulumi.getter(name="weightedF1")
    def weighted_f1(self) -> float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "weighted_f1")

    @property
    @pulumi.getter(name="weightedPrecision")
    def weighted_precision(self) -> float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "weighted_precision")

    @property
    @pulumi.getter(name="weightedRecall")
    def weighted_recall(self) -> float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "weighted_recall")


@pulumi.output_type
class GetModelEvaluationResultsEvaluationResultCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetModelEvaluationResultsEvaluationResultCollectionItemResult']):
        """
        :param Sequence['GetModelEvaluationResultsEvaluationResultCollectionItemArgs'] items: List of model evaluation analysis
        """
        GetModelEvaluationResultsEvaluationResultCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetModelEvaluationResultsEvaluationResultCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetModelEvaluationResultsEvaluationResultCollectionItemResult']:
        """
        List of model evaluation analysis
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetModelEvaluationResultsEvaluationResultCollectionItemResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, Any],
                 freeform_tags: Mapping[str, Any],
                 location: str,
                 model_type: str,
                 predicted_entities: Sequence['outputs.GetModelEvaluationResultsEvaluationResultCollectionItemPredictedEntityResult'],
                 predicted_labels: Sequence[str],
                 record: str,
                 true_entities: Sequence['outputs.GetModelEvaluationResultsEvaluationResultCollectionItemTrueEntityResult'],
                 true_labels: Sequence[str]):
        """
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str location: For CSV format location is rowId(1 is header) and for JSONL location is jsonL line sequence(1 is metadata)
        :param str model_type: Model type
        :param Sequence['GetModelEvaluationResultsEvaluationResultCollectionItemPredictedEntityArgs'] predicted_entities: List of true(actual) entities in test data for NER model
        :param Sequence[str] predicted_labels: List of predicted labels by custom multi class or multi label TextClassification model
        :param str record: For CSV format location is rowId(1 is header) and for JSONL location is jsonL line sequence(1 is metadata)
        :param Sequence['GetModelEvaluationResultsEvaluationResultCollectionItemTrueEntityArgs'] true_entities: List of true(actual) entities in test data for NER model
        :param Sequence[str] true_labels: List of true(actual) labels in test data for multi class or multi label TextClassification
        """
        GetModelEvaluationResultsEvaluationResultCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            location=location,
            model_type=model_type,
            predicted_entities=predicted_entities,
            predicted_labels=predicted_labels,
            record=record,
            true_entities=true_entities,
            true_labels=true_labels,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             defined_tags: Mapping[str, Any],
             freeform_tags: Mapping[str, Any],
             location: str,
             model_type: str,
             predicted_entities: Sequence['outputs.GetModelEvaluationResultsEvaluationResultCollectionItemPredictedEntityResult'],
             predicted_labels: Sequence[str],
             record: str,
             true_entities: Sequence['outputs.GetModelEvaluationResultsEvaluationResultCollectionItemTrueEntityResult'],
             true_labels: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("defined_tags", defined_tags)
        _setter("freeform_tags", freeform_tags)
        _setter("location", location)
        _setter("model_type", model_type)
        _setter("predicted_entities", predicted_entities)
        _setter("predicted_labels", predicted_labels)
        _setter("record", record)
        _setter("true_entities", true_entities)
        _setter("true_labels", true_labels)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        For CSV format location is rowId(1 is header) and for JSONL location is jsonL line sequence(1 is metadata)
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> str:
        """
        Model type
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="predictedEntities")
    def predicted_entities(self) -> Sequence['outputs.GetModelEvaluationResultsEvaluationResultCollectionItemPredictedEntityResult']:
        """
        List of true(actual) entities in test data for NER model
        """
        return pulumi.get(self, "predicted_entities")

    @property
    @pulumi.getter(name="predictedLabels")
    def predicted_labels(self) -> Sequence[str]:
        """
        List of predicted labels by custom multi class or multi label TextClassification model
        """
        return pulumi.get(self, "predicted_labels")

    @property
    @pulumi.getter
    def record(self) -> str:
        """
        For CSV format location is rowId(1 is header) and for JSONL location is jsonL line sequence(1 is metadata)
        """
        return pulumi.get(self, "record")

    @property
    @pulumi.getter(name="trueEntities")
    def true_entities(self) -> Sequence['outputs.GetModelEvaluationResultsEvaluationResultCollectionItemTrueEntityResult']:
        """
        List of true(actual) entities in test data for NER model
        """
        return pulumi.get(self, "true_entities")

    @property
    @pulumi.getter(name="trueLabels")
    def true_labels(self) -> Sequence[str]:
        """
        List of true(actual) labels in test data for multi class or multi label TextClassification
        """
        return pulumi.get(self, "true_labels")


@pulumi.output_type
class GetModelEvaluationResultsEvaluationResultCollectionItemPredictedEntityResult(dict):
    def __init__(__self__, *,
                 length: int,
                 offset: int,
                 type: str):
        """
        :param int length: Length of text
        :param int offset: Starting index on text.
        :param str type: Type of entity text like PER, LOC, GPE, NOPE etc.
        """
        GetModelEvaluationResultsEvaluationResultCollectionItemPredictedEntityResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            length=length,
            offset=offset,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             length: int,
             offset: int,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("length", length)
        _setter("offset", offset)
        _setter("type", type)

    @property
    @pulumi.getter
    def length(self) -> int:
        """
        Length of text
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def offset(self) -> int:
        """
        Starting index on text.
        """
        return pulumi.get(self, "offset")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of entity text like PER, LOC, GPE, NOPE etc.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetModelEvaluationResultsEvaluationResultCollectionItemTrueEntityResult(dict):
    def __init__(__self__, *,
                 length: int,
                 offset: int,
                 type: str):
        """
        :param int length: Length of text
        :param int offset: Starting index on text.
        :param str type: Type of entity text like PER, LOC, GPE, NOPE etc.
        """
        GetModelEvaluationResultsEvaluationResultCollectionItemTrueEntityResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            length=length,
            offset=offset,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             length: int,
             offset: int,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("length", length)
        _setter("offset", offset)
        _setter("type", type)

    @property
    @pulumi.getter
    def length(self) -> int:
        """
        Length of text
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def offset(self) -> int:
        """
        Starting index on text.
        """
        return pulumi.get(self, "offset")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of entity text like PER, LOC, GPE, NOPE etc.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetModelEvaluationResultsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetModelEvaluationResultsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetModelModelDetailResult(dict):
    def __init__(__self__, *,
                 classification_modes: Sequence['outputs.GetModelModelDetailClassificationModeResult'],
                 language_code: str,
                 model_type: str,
                 version: str):
        """
        :param Sequence['GetModelModelDetailClassificationModeArgs'] classification_modes: classification Modes
        :param str language_code: supported language default value is en
        :param str model_type: Model type
        :param str version: For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        GetModelModelDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            classification_modes=classification_modes,
            language_code=language_code,
            model_type=model_type,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             classification_modes: Sequence['outputs.GetModelModelDetailClassificationModeResult'],
             language_code: str,
             model_type: str,
             version: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("classification_modes", classification_modes)
        _setter("language_code", language_code)
        _setter("model_type", model_type)
        _setter("version", version)

    @property
    @pulumi.getter(name="classificationModes")
    def classification_modes(self) -> Sequence['outputs.GetModelModelDetailClassificationModeResult']:
        """
        classification Modes
        """
        return pulumi.get(self, "classification_modes")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        supported language default value is en
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> str:
        """
        Model type
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetModelModelDetailClassificationModeResult(dict):
    def __init__(__self__, *,
                 classification_mode: str,
                 version: str):
        """
        :param str classification_mode: classification Modes
        :param str version: For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        GetModelModelDetailClassificationModeResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            classification_mode=classification_mode,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             classification_mode: str,
             version: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("classification_mode", classification_mode)
        _setter("version", version)

    @property
    @pulumi.getter(name="classificationMode")
    def classification_mode(self) -> str:
        """
        classification Modes
        """
        return pulumi.get(self, "classification_mode")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetModelTestStrategyResult(dict):
    def __init__(__self__, *,
                 strategy_type: str,
                 testing_datasets: Sequence['outputs.GetModelTestStrategyTestingDatasetResult'],
                 validation_datasets: Sequence['outputs.GetModelTestStrategyValidationDatasetResult']):
        """
        :param str strategy_type: This information will define the test strategy different datasets for test and validation(optional) dataset.
        :param Sequence['GetModelTestStrategyTestingDatasetArgs'] testing_datasets: Possible data set type
        :param Sequence['GetModelTestStrategyValidationDatasetArgs'] validation_datasets: Possible data set type
        """
        GetModelTestStrategyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            strategy_type=strategy_type,
            testing_datasets=testing_datasets,
            validation_datasets=validation_datasets,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             strategy_type: str,
             testing_datasets: Sequence['outputs.GetModelTestStrategyTestingDatasetResult'],
             validation_datasets: Sequence['outputs.GetModelTestStrategyValidationDatasetResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("strategy_type", strategy_type)
        _setter("testing_datasets", testing_datasets)
        _setter("validation_datasets", validation_datasets)

    @property
    @pulumi.getter(name="strategyType")
    def strategy_type(self) -> str:
        """
        This information will define the test strategy different datasets for test and validation(optional) dataset.
        """
        return pulumi.get(self, "strategy_type")

    @property
    @pulumi.getter(name="testingDatasets")
    def testing_datasets(self) -> Sequence['outputs.GetModelTestStrategyTestingDatasetResult']:
        """
        Possible data set type
        """
        return pulumi.get(self, "testing_datasets")

    @property
    @pulumi.getter(name="validationDatasets")
    def validation_datasets(self) -> Sequence['outputs.GetModelTestStrategyValidationDatasetResult']:
        """
        Possible data set type
        """
        return pulumi.get(self, "validation_datasets")


@pulumi.output_type
class GetModelTestStrategyTestingDatasetResult(dict):
    def __init__(__self__, *,
                 dataset_id: str,
                 dataset_type: str,
                 location_details: Sequence['outputs.GetModelTestStrategyTestingDatasetLocationDetailResult']):
        """
        :param str dataset_id: Data Science Labelling Service OCID
        :param str dataset_type: Possible data sets
        :param Sequence['GetModelTestStrategyTestingDatasetLocationDetailArgs'] location_details: Possible object storage location types
        """
        GetModelTestStrategyTestingDatasetResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dataset_id=dataset_id,
            dataset_type=dataset_type,
            location_details=location_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dataset_id: str,
             dataset_type: str,
             location_details: Sequence['outputs.GetModelTestStrategyTestingDatasetLocationDetailResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("dataset_id", dataset_id)
        _setter("dataset_type", dataset_type)
        _setter("location_details", location_details)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Sequence['outputs.GetModelTestStrategyTestingDatasetLocationDetailResult']:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")


@pulumi.output_type
class GetModelTestStrategyTestingDatasetLocationDetailResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 location_type: str,
                 namespace: str,
                 object_names: Sequence[str]):
        """
        :param str bucket: Object storage bucket name
        :param str location_type: Possible object storage location types
        :param str namespace: Object storage namespace
        :param Sequence[str] object_names: Array of files which need to be processed in the bucket
        """
        GetModelTestStrategyTestingDatasetLocationDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            location_type=location_type,
            namespace=namespace,
            object_names=object_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             location_type: str,
             namespace: str,
             object_names: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("location_type", location_type)
        _setter("namespace", namespace)
        _setter("object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> str:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> Sequence[str]:
        """
        Array of files which need to be processed in the bucket
        """
        return pulumi.get(self, "object_names")


@pulumi.output_type
class GetModelTestStrategyValidationDatasetResult(dict):
    def __init__(__self__, *,
                 dataset_id: str,
                 dataset_type: str,
                 location_details: Sequence['outputs.GetModelTestStrategyValidationDatasetLocationDetailResult']):
        """
        :param str dataset_id: Data Science Labelling Service OCID
        :param str dataset_type: Possible data sets
        :param Sequence['GetModelTestStrategyValidationDatasetLocationDetailArgs'] location_details: Possible object storage location types
        """
        GetModelTestStrategyValidationDatasetResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dataset_id=dataset_id,
            dataset_type=dataset_type,
            location_details=location_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dataset_id: str,
             dataset_type: str,
             location_details: Sequence['outputs.GetModelTestStrategyValidationDatasetLocationDetailResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("dataset_id", dataset_id)
        _setter("dataset_type", dataset_type)
        _setter("location_details", location_details)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Sequence['outputs.GetModelTestStrategyValidationDatasetLocationDetailResult']:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")


@pulumi.output_type
class GetModelTestStrategyValidationDatasetLocationDetailResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 location_type: str,
                 namespace: str,
                 object_names: Sequence[str]):
        """
        :param str bucket: Object storage bucket name
        :param str location_type: Possible object storage location types
        :param str namespace: Object storage namespace
        :param Sequence[str] object_names: Array of files which need to be processed in the bucket
        """
        GetModelTestStrategyValidationDatasetLocationDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            location_type=location_type,
            namespace=namespace,
            object_names=object_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             location_type: str,
             namespace: str,
             object_names: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("location_type", location_type)
        _setter("namespace", namespace)
        _setter("object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> str:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> Sequence[str]:
        """
        Array of files which need to be processed in the bucket
        """
        return pulumi.get(self, "object_names")


@pulumi.output_type
class GetModelTrainingDatasetResult(dict):
    def __init__(__self__, *,
                 dataset_id: str,
                 dataset_type: str,
                 location_details: Sequence['outputs.GetModelTrainingDatasetLocationDetailResult']):
        """
        :param str dataset_id: Data Science Labelling Service OCID
        :param str dataset_type: Possible data sets
        :param Sequence['GetModelTrainingDatasetLocationDetailArgs'] location_details: Possible object storage location types
        """
        GetModelTrainingDatasetResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dataset_id=dataset_id,
            dataset_type=dataset_type,
            location_details=location_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dataset_id: str,
             dataset_type: str,
             location_details: Sequence['outputs.GetModelTrainingDatasetLocationDetailResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("dataset_id", dataset_id)
        _setter("dataset_type", dataset_type)
        _setter("location_details", location_details)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Sequence['outputs.GetModelTrainingDatasetLocationDetailResult']:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")


@pulumi.output_type
class GetModelTrainingDatasetLocationDetailResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 location_type: str,
                 namespace: str,
                 object_names: Sequence[str]):
        """
        :param str bucket: Object storage bucket name
        :param str location_type: Possible object storage location types
        :param str namespace: Object storage namespace
        :param Sequence[str] object_names: Array of files which need to be processed in the bucket
        """
        GetModelTrainingDatasetLocationDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            location_type=location_type,
            namespace=namespace,
            object_names=object_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             location_type: str,
             namespace: str,
             object_names: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("location_type", location_type)
        _setter("namespace", namespace)
        _setter("object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> str:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> Sequence[str]:
        """
        Array of files which need to be processed in the bucket
        """
        return pulumi.get(self, "object_names")


@pulumi.output_type
class GetModelsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetModelsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetModelsModelCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetModelsModelCollectionItemResult']):
        GetModelsModelCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetModelsModelCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetModelsModelCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetModelsModelCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 evaluation_results: Sequence['outputs.GetModelsModelCollectionItemEvaluationResultResult'],
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 lifecycle_details: str,
                 model_details: Sequence['outputs.GetModelsModelCollectionItemModelDetailResult'],
                 project_id: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 test_strategies: Sequence['outputs.GetModelsModelCollectionItemTestStrategyResult'],
                 time_created: str,
                 time_updated: str,
                 training_datasets: Sequence['outputs.GetModelsModelCollectionItemTrainingDatasetResult'],
                 version: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: A short description of the Model.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Sequence['GetModelsModelCollectionItemEvaluationResultArgs'] evaluation_results: model training results of different models
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: Unique identifier model OCID of a model that is immutable on creation
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in failed state.
        :param Sequence['GetModelsModelCollectionItemModelDetailArgs'] model_details: Possible model types
        :param str project_id: The ID of the project for which to list the objects.
        :param str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param Sequence['GetModelsModelCollectionItemTestStrategyArgs'] test_strategies: Possible strategy as testing and validation(optional) dataset.
        :param str time_created: The time the the model was created. An RFC3339 formatted datetime string.
        :param str time_updated: The time the model was updated. An RFC3339 formatted datetime string.
        :param Sequence['GetModelsModelCollectionItemTrainingDatasetArgs'] training_datasets: Possible data set type
        :param str version: For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        GetModelsModelCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            evaluation_results=evaluation_results,
            freeform_tags=freeform_tags,
            id=id,
            lifecycle_details=lifecycle_details,
            model_details=model_details,
            project_id=project_id,
            state=state,
            system_tags=system_tags,
            test_strategies=test_strategies,
            time_created=time_created,
            time_updated=time_updated,
            training_datasets=training_datasets,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             evaluation_results: Sequence['outputs.GetModelsModelCollectionItemEvaluationResultResult'],
             freeform_tags: Mapping[str, Any],
             id: str,
             lifecycle_details: str,
             model_details: Sequence['outputs.GetModelsModelCollectionItemModelDetailResult'],
             project_id: str,
             state: str,
             system_tags: Mapping[str, Any],
             test_strategies: Sequence['outputs.GetModelsModelCollectionItemTestStrategyResult'],
             time_created: str,
             time_updated: str,
             training_datasets: Sequence['outputs.GetModelsModelCollectionItemTrainingDatasetResult'],
             version: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("evaluation_results", evaluation_results)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("lifecycle_details", lifecycle_details)
        _setter("model_details", model_details)
        _setter("project_id", project_id)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("test_strategies", test_strategies)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("training_datasets", training_datasets)
        _setter("version", version)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A short description of the Model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="evaluationResults")
    def evaluation_results(self) -> Sequence['outputs.GetModelsModelCollectionItemEvaluationResultResult']:
        """
        model training results of different models
        """
        return pulumi.get(self, "evaluation_results")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier model OCID of a model that is immutable on creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="modelDetails")
    def model_details(self) -> Sequence['outputs.GetModelsModelCollectionItemModelDetailResult']:
        """
        Possible model types
        """
        return pulumi.get(self, "model_details")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project for which to list the objects.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="testStrategies")
    def test_strategies(self) -> Sequence['outputs.GetModelsModelCollectionItemTestStrategyResult']:
        """
        Possible strategy as testing and validation(optional) dataset.
        """
        return pulumi.get(self, "test_strategies")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the model was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the model was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="trainingDatasets")
    def training_datasets(self) -> Sequence['outputs.GetModelsModelCollectionItemTrainingDatasetResult']:
        """
        Possible data set type
        """
        return pulumi.get(self, "training_datasets")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetModelsModelCollectionItemEvaluationResultResult(dict):
    def __init__(__self__, *,
                 class_metrics: Sequence['outputs.GetModelsModelCollectionItemEvaluationResultClassMetricResult'],
                 confusion_matrix: str,
                 entity_metrics: Sequence['outputs.GetModelsModelCollectionItemEvaluationResultEntityMetricResult'],
                 labels: Sequence[str],
                 metrics: Sequence['outputs.GetModelsModelCollectionItemEvaluationResultMetricResult'],
                 model_type: str):
        """
        :param Sequence['GetModelsModelCollectionItemEvaluationResultClassMetricArgs'] class_metrics: List of text classification metrics
        :param str confusion_matrix: class level confusion matrix
        :param Sequence['GetModelsModelCollectionItemEvaluationResultEntityMetricArgs'] entity_metrics: List of entity metrics
        :param Sequence[str] labels: labels
        :param Sequence['GetModelsModelCollectionItemEvaluationResultMetricArgs'] metrics: Model level named entity recognition metrics
        :param str model_type: Model type
        """
        GetModelsModelCollectionItemEvaluationResultResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            class_metrics=class_metrics,
            confusion_matrix=confusion_matrix,
            entity_metrics=entity_metrics,
            labels=labels,
            metrics=metrics,
            model_type=model_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             class_metrics: Sequence['outputs.GetModelsModelCollectionItemEvaluationResultClassMetricResult'],
             confusion_matrix: str,
             entity_metrics: Sequence['outputs.GetModelsModelCollectionItemEvaluationResultEntityMetricResult'],
             labels: Sequence[str],
             metrics: Sequence['outputs.GetModelsModelCollectionItemEvaluationResultMetricResult'],
             model_type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("class_metrics", class_metrics)
        _setter("confusion_matrix", confusion_matrix)
        _setter("entity_metrics", entity_metrics)
        _setter("labels", labels)
        _setter("metrics", metrics)
        _setter("model_type", model_type)

    @property
    @pulumi.getter(name="classMetrics")
    def class_metrics(self) -> Sequence['outputs.GetModelsModelCollectionItemEvaluationResultClassMetricResult']:
        """
        List of text classification metrics
        """
        return pulumi.get(self, "class_metrics")

    @property
    @pulumi.getter(name="confusionMatrix")
    def confusion_matrix(self) -> str:
        """
        class level confusion matrix
        """
        return pulumi.get(self, "confusion_matrix")

    @property
    @pulumi.getter(name="entityMetrics")
    def entity_metrics(self) -> Sequence['outputs.GetModelsModelCollectionItemEvaluationResultEntityMetricResult']:
        """
        List of entity metrics
        """
        return pulumi.get(self, "entity_metrics")

    @property
    @pulumi.getter
    def labels(self) -> Sequence[str]:
        """
        labels
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetModelsModelCollectionItemEvaluationResultMetricResult']:
        """
        Model level named entity recognition metrics
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> str:
        """
        Model type
        """
        return pulumi.get(self, "model_type")


@pulumi.output_type
class GetModelsModelCollectionItemEvaluationResultClassMetricResult(dict):
    def __init__(__self__, *,
                 f1: float,
                 label: str,
                 precision: float,
                 recall: float,
                 support: float):
        """
        :param float f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param str label: Entity label
        :param float precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param float recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param float support: number of samples in the test set
        """
        GetModelsModelCollectionItemEvaluationResultClassMetricResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            f1=f1,
            label=label,
            precision=precision,
            recall=recall,
            support=support,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             f1: float,
             label: str,
             precision: float,
             recall: float,
             support: float,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("f1", f1)
        _setter("label", label)
        _setter("precision", precision)
        _setter("recall", recall)
        _setter("support", support)

    @property
    @pulumi.getter
    def f1(self) -> float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "f1")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Entity label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def precision(self) -> float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "recall")

    @property
    @pulumi.getter
    def support(self) -> float:
        """
        number of samples in the test set
        """
        return pulumi.get(self, "support")


@pulumi.output_type
class GetModelsModelCollectionItemEvaluationResultEntityMetricResult(dict):
    def __init__(__self__, *,
                 f1: float,
                 label: str,
                 precision: float,
                 recall: float):
        """
        :param float f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param str label: Entity label
        :param float precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param float recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        GetModelsModelCollectionItemEvaluationResultEntityMetricResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            f1=f1,
            label=label,
            precision=precision,
            recall=recall,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             f1: float,
             label: str,
             precision: float,
             recall: float,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("f1", f1)
        _setter("label", label)
        _setter("precision", precision)
        _setter("recall", recall)

    @property
    @pulumi.getter
    def f1(self) -> float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "f1")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Entity label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def precision(self) -> float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "recall")


@pulumi.output_type
class GetModelsModelCollectionItemEvaluationResultMetricResult(dict):
    def __init__(__self__, *,
                 accuracy: float,
                 macro_f1: float,
                 macro_precision: float,
                 macro_recall: float,
                 micro_f1: float,
                 micro_precision: float,
                 micro_recall: float,
                 weighted_f1: float,
                 weighted_precision: float,
                 weighted_recall: float):
        """
        :param float accuracy: The fraction of the labels that were correctly recognised .
        :param float macro_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param float macro_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param float macro_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param float micro_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param float micro_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param float micro_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param float weighted_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param float weighted_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param float weighted_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        GetModelsModelCollectionItemEvaluationResultMetricResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            accuracy=accuracy,
            macro_f1=macro_f1,
            macro_precision=macro_precision,
            macro_recall=macro_recall,
            micro_f1=micro_f1,
            micro_precision=micro_precision,
            micro_recall=micro_recall,
            weighted_f1=weighted_f1,
            weighted_precision=weighted_precision,
            weighted_recall=weighted_recall,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             accuracy: float,
             macro_f1: float,
             macro_precision: float,
             macro_recall: float,
             micro_f1: float,
             micro_precision: float,
             micro_recall: float,
             weighted_f1: float,
             weighted_precision: float,
             weighted_recall: float,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("accuracy", accuracy)
        _setter("macro_f1", macro_f1)
        _setter("macro_precision", macro_precision)
        _setter("macro_recall", macro_recall)
        _setter("micro_f1", micro_f1)
        _setter("micro_precision", micro_precision)
        _setter("micro_recall", micro_recall)
        _setter("weighted_f1", weighted_f1)
        _setter("weighted_precision", weighted_precision)
        _setter("weighted_recall", weighted_recall)

    @property
    @pulumi.getter
    def accuracy(self) -> float:
        """
        The fraction of the labels that were correctly recognised .
        """
        return pulumi.get(self, "accuracy")

    @property
    @pulumi.getter(name="macroF1")
    def macro_f1(self) -> float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "macro_f1")

    @property
    @pulumi.getter(name="macroPrecision")
    def macro_precision(self) -> float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "macro_precision")

    @property
    @pulumi.getter(name="macroRecall")
    def macro_recall(self) -> float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "macro_recall")

    @property
    @pulumi.getter(name="microF1")
    def micro_f1(self) -> float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "micro_f1")

    @property
    @pulumi.getter(name="microPrecision")
    def micro_precision(self) -> float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "micro_precision")

    @property
    @pulumi.getter(name="microRecall")
    def micro_recall(self) -> float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "micro_recall")

    @property
    @pulumi.getter(name="weightedF1")
    def weighted_f1(self) -> float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "weighted_f1")

    @property
    @pulumi.getter(name="weightedPrecision")
    def weighted_precision(self) -> float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "weighted_precision")

    @property
    @pulumi.getter(name="weightedRecall")
    def weighted_recall(self) -> float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "weighted_recall")


@pulumi.output_type
class GetModelsModelCollectionItemModelDetailResult(dict):
    def __init__(__self__, *,
                 classification_modes: Sequence['outputs.GetModelsModelCollectionItemModelDetailClassificationModeResult'],
                 language_code: str,
                 model_type: str,
                 version: str):
        """
        :param Sequence['GetModelsModelCollectionItemModelDetailClassificationModeArgs'] classification_modes: classification Modes
        :param str language_code: supported language default value is en
        :param str model_type: Model type
        :param str version: For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        GetModelsModelCollectionItemModelDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            classification_modes=classification_modes,
            language_code=language_code,
            model_type=model_type,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             classification_modes: Sequence['outputs.GetModelsModelCollectionItemModelDetailClassificationModeResult'],
             language_code: str,
             model_type: str,
             version: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("classification_modes", classification_modes)
        _setter("language_code", language_code)
        _setter("model_type", model_type)
        _setter("version", version)

    @property
    @pulumi.getter(name="classificationModes")
    def classification_modes(self) -> Sequence['outputs.GetModelsModelCollectionItemModelDetailClassificationModeResult']:
        """
        classification Modes
        """
        return pulumi.get(self, "classification_modes")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        supported language default value is en
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> str:
        """
        Model type
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetModelsModelCollectionItemModelDetailClassificationModeResult(dict):
    def __init__(__self__, *,
                 classification_mode: str,
                 version: str):
        """
        :param str classification_mode: classification Modes
        :param str version: For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        GetModelsModelCollectionItemModelDetailClassificationModeResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            classification_mode=classification_mode,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             classification_mode: str,
             version: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("classification_mode", classification_mode)
        _setter("version", version)

    @property
    @pulumi.getter(name="classificationMode")
    def classification_mode(self) -> str:
        """
        classification Modes
        """
        return pulumi.get(self, "classification_mode")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetModelsModelCollectionItemTestStrategyResult(dict):
    def __init__(__self__, *,
                 strategy_type: str,
                 testing_datasets: Sequence['outputs.GetModelsModelCollectionItemTestStrategyTestingDatasetResult'],
                 validation_datasets: Sequence['outputs.GetModelsModelCollectionItemTestStrategyValidationDatasetResult']):
        """
        :param str strategy_type: This information will define the test strategy different datasets for test and validation(optional) dataset.
        :param Sequence['GetModelsModelCollectionItemTestStrategyTestingDatasetArgs'] testing_datasets: Possible data set type
        :param Sequence['GetModelsModelCollectionItemTestStrategyValidationDatasetArgs'] validation_datasets: Possible data set type
        """
        GetModelsModelCollectionItemTestStrategyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            strategy_type=strategy_type,
            testing_datasets=testing_datasets,
            validation_datasets=validation_datasets,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             strategy_type: str,
             testing_datasets: Sequence['outputs.GetModelsModelCollectionItemTestStrategyTestingDatasetResult'],
             validation_datasets: Sequence['outputs.GetModelsModelCollectionItemTestStrategyValidationDatasetResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("strategy_type", strategy_type)
        _setter("testing_datasets", testing_datasets)
        _setter("validation_datasets", validation_datasets)

    @property
    @pulumi.getter(name="strategyType")
    def strategy_type(self) -> str:
        """
        This information will define the test strategy different datasets for test and validation(optional) dataset.
        """
        return pulumi.get(self, "strategy_type")

    @property
    @pulumi.getter(name="testingDatasets")
    def testing_datasets(self) -> Sequence['outputs.GetModelsModelCollectionItemTestStrategyTestingDatasetResult']:
        """
        Possible data set type
        """
        return pulumi.get(self, "testing_datasets")

    @property
    @pulumi.getter(name="validationDatasets")
    def validation_datasets(self) -> Sequence['outputs.GetModelsModelCollectionItemTestStrategyValidationDatasetResult']:
        """
        Possible data set type
        """
        return pulumi.get(self, "validation_datasets")


@pulumi.output_type
class GetModelsModelCollectionItemTestStrategyTestingDatasetResult(dict):
    def __init__(__self__, *,
                 dataset_id: str,
                 dataset_type: str,
                 location_details: Sequence['outputs.GetModelsModelCollectionItemTestStrategyTestingDatasetLocationDetailResult']):
        """
        :param str dataset_id: Data Science Labelling Service OCID
        :param str dataset_type: Possible data sets
        :param Sequence['GetModelsModelCollectionItemTestStrategyTestingDatasetLocationDetailArgs'] location_details: Possible object storage location types
        """
        GetModelsModelCollectionItemTestStrategyTestingDatasetResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dataset_id=dataset_id,
            dataset_type=dataset_type,
            location_details=location_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dataset_id: str,
             dataset_type: str,
             location_details: Sequence['outputs.GetModelsModelCollectionItemTestStrategyTestingDatasetLocationDetailResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("dataset_id", dataset_id)
        _setter("dataset_type", dataset_type)
        _setter("location_details", location_details)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Sequence['outputs.GetModelsModelCollectionItemTestStrategyTestingDatasetLocationDetailResult']:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")


@pulumi.output_type
class GetModelsModelCollectionItemTestStrategyTestingDatasetLocationDetailResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 location_type: str,
                 namespace: str,
                 object_names: Sequence[str]):
        """
        :param str bucket: Object storage bucket name
        :param str location_type: Possible object storage location types
        :param str namespace: Object storage namespace
        :param Sequence[str] object_names: Array of files which need to be processed in the bucket
        """
        GetModelsModelCollectionItemTestStrategyTestingDatasetLocationDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            location_type=location_type,
            namespace=namespace,
            object_names=object_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             location_type: str,
             namespace: str,
             object_names: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("location_type", location_type)
        _setter("namespace", namespace)
        _setter("object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> str:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> Sequence[str]:
        """
        Array of files which need to be processed in the bucket
        """
        return pulumi.get(self, "object_names")


@pulumi.output_type
class GetModelsModelCollectionItemTestStrategyValidationDatasetResult(dict):
    def __init__(__self__, *,
                 dataset_id: str,
                 dataset_type: str,
                 location_details: Sequence['outputs.GetModelsModelCollectionItemTestStrategyValidationDatasetLocationDetailResult']):
        """
        :param str dataset_id: Data Science Labelling Service OCID
        :param str dataset_type: Possible data sets
        :param Sequence['GetModelsModelCollectionItemTestStrategyValidationDatasetLocationDetailArgs'] location_details: Possible object storage location types
        """
        GetModelsModelCollectionItemTestStrategyValidationDatasetResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dataset_id=dataset_id,
            dataset_type=dataset_type,
            location_details=location_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dataset_id: str,
             dataset_type: str,
             location_details: Sequence['outputs.GetModelsModelCollectionItemTestStrategyValidationDatasetLocationDetailResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("dataset_id", dataset_id)
        _setter("dataset_type", dataset_type)
        _setter("location_details", location_details)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Sequence['outputs.GetModelsModelCollectionItemTestStrategyValidationDatasetLocationDetailResult']:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")


@pulumi.output_type
class GetModelsModelCollectionItemTestStrategyValidationDatasetLocationDetailResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 location_type: str,
                 namespace: str,
                 object_names: Sequence[str]):
        """
        :param str bucket: Object storage bucket name
        :param str location_type: Possible object storage location types
        :param str namespace: Object storage namespace
        :param Sequence[str] object_names: Array of files which need to be processed in the bucket
        """
        GetModelsModelCollectionItemTestStrategyValidationDatasetLocationDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            location_type=location_type,
            namespace=namespace,
            object_names=object_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             location_type: str,
             namespace: str,
             object_names: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("location_type", location_type)
        _setter("namespace", namespace)
        _setter("object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> str:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> Sequence[str]:
        """
        Array of files which need to be processed in the bucket
        """
        return pulumi.get(self, "object_names")


@pulumi.output_type
class GetModelsModelCollectionItemTrainingDatasetResult(dict):
    def __init__(__self__, *,
                 dataset_id: str,
                 dataset_type: str,
                 location_details: Sequence['outputs.GetModelsModelCollectionItemTrainingDatasetLocationDetailResult']):
        """
        :param str dataset_id: Data Science Labelling Service OCID
        :param str dataset_type: Possible data sets
        :param Sequence['GetModelsModelCollectionItemTrainingDatasetLocationDetailArgs'] location_details: Possible object storage location types
        """
        GetModelsModelCollectionItemTrainingDatasetResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dataset_id=dataset_id,
            dataset_type=dataset_type,
            location_details=location_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dataset_id: str,
             dataset_type: str,
             location_details: Sequence['outputs.GetModelsModelCollectionItemTrainingDatasetLocationDetailResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("dataset_id", dataset_id)
        _setter("dataset_type", dataset_type)
        _setter("location_details", location_details)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Sequence['outputs.GetModelsModelCollectionItemTrainingDatasetLocationDetailResult']:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")


@pulumi.output_type
class GetModelsModelCollectionItemTrainingDatasetLocationDetailResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 location_type: str,
                 namespace: str,
                 object_names: Sequence[str]):
        """
        :param str bucket: Object storage bucket name
        :param str location_type: Possible object storage location types
        :param str namespace: Object storage namespace
        :param Sequence[str] object_names: Array of files which need to be processed in the bucket
        """
        GetModelsModelCollectionItemTrainingDatasetLocationDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            location_type=location_type,
            namespace=namespace,
            object_names=object_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             location_type: str,
             namespace: str,
             object_names: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("location_type", location_type)
        _setter("namespace", namespace)
        _setter("object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> str:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> Sequence[str]:
        """
        Array of files which need to be processed in the bucket
        """
        return pulumi.get(self, "object_names")


@pulumi.output_type
class GetProjectsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetProjectsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetProjectsProjectCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProjectsProjectCollectionItemResult']):
        GetProjectsProjectCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetProjectsProjectCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProjectsProjectCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProjectsProjectCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 lifecycle_details: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: A short description of a project.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: Unique identifier OCID of the project
        :param str lifecycle_details: A message describing the current state in more detail.
        :param str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param str time_updated: The date and time the resource was updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        GetProjectsProjectCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            lifecycle_details=lifecycle_details,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             lifecycle_details: str,
             state: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("lifecycle_details", lifecycle_details)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A short description of a project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier OCID of the project
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the resource was updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")


