# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAutoScalingConfigurationResult',
    'AwaitableGetAutoScalingConfigurationResult',
    'get_auto_scaling_configuration',
    'get_auto_scaling_configuration_output',
]

@pulumi.output_type
class GetAutoScalingConfigurationResult:
    """
    A collection of values returned by getAutoScalingConfiguration.
    """
    def __init__(__self__, auto_scaling_configuration_id=None, auto_scaling_resources=None, compartment_id=None, cool_down_in_seconds=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, is_enabled=None, max_resource_count=None, min_resource_count=None, policies=None, time_created=None):
        if auto_scaling_configuration_id and not isinstance(auto_scaling_configuration_id, str):
            raise TypeError("Expected argument 'auto_scaling_configuration_id' to be a str")
        pulumi.set(__self__, "auto_scaling_configuration_id", auto_scaling_configuration_id)
        if auto_scaling_resources and not isinstance(auto_scaling_resources, list):
            raise TypeError("Expected argument 'auto_scaling_resources' to be a list")
        pulumi.set(__self__, "auto_scaling_resources", auto_scaling_resources)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if cool_down_in_seconds and not isinstance(cool_down_in_seconds, int):
            raise TypeError("Expected argument 'cool_down_in_seconds' to be a int")
        pulumi.set(__self__, "cool_down_in_seconds", cool_down_in_seconds)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_enabled and not isinstance(is_enabled, bool):
            raise TypeError("Expected argument 'is_enabled' to be a bool")
        pulumi.set(__self__, "is_enabled", is_enabled)
        if max_resource_count and not isinstance(max_resource_count, int):
            raise TypeError("Expected argument 'max_resource_count' to be a int")
        pulumi.set(__self__, "max_resource_count", max_resource_count)
        if min_resource_count and not isinstance(min_resource_count, int):
            raise TypeError("Expected argument 'min_resource_count' to be a int")
        pulumi.set(__self__, "min_resource_count", min_resource_count)
        if policies and not isinstance(policies, list):
            raise TypeError("Expected argument 'policies' to be a list")
        pulumi.set(__self__, "policies", policies)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="autoScalingConfigurationId")
    def auto_scaling_configuration_id(self) -> str:
        return pulumi.get(self, "auto_scaling_configuration_id")

    @property
    @pulumi.getter(name="autoScalingResources")
    def auto_scaling_resources(self) -> Sequence['outputs.GetAutoScalingConfigurationAutoScalingResourceResult']:
        """
        A resource that is managed by an autoscaling configuration. The only supported type is `instancePool`.
        """
        return pulumi.get(self, "auto_scaling_resources")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the autoscaling configuration.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="coolDownInSeconds")
    def cool_down_in_seconds(self) -> int:
        """
        For threshold-based autoscaling policies, this value is the minimum period of time to wait between scaling actions. The cooldown period gives the system time to stabilize before rescaling. The minimum value is 300 seconds, which is also the default. The cooldown period starts when the instance pool reaches the running state.
        """
        return pulumi.get(self, "cool_down_in_seconds")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether the autoscaling policy is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="maxResourceCount")
    def max_resource_count(self) -> int:
        """
        The maximum number of resources to scale out to.
        """
        return pulumi.get(self, "max_resource_count")

    @property
    @pulumi.getter(name="minResourceCount")
    def min_resource_count(self) -> int:
        """
        The minimum number of resources to scale in to.
        """
        return pulumi.get(self, "min_resource_count")

    @property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyResult']:
        """
        Autoscaling policy definitions for the autoscaling configuration. An autoscaling policy defines the criteria that trigger autoscaling actions and the actions to take.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


class AwaitableGetAutoScalingConfigurationResult(GetAutoScalingConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutoScalingConfigurationResult(
            auto_scaling_configuration_id=self.auto_scaling_configuration_id,
            auto_scaling_resources=self.auto_scaling_resources,
            compartment_id=self.compartment_id,
            cool_down_in_seconds=self.cool_down_in_seconds,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_enabled=self.is_enabled,
            max_resource_count=self.max_resource_count,
            min_resource_count=self.min_resource_count,
            policies=self.policies,
            time_created=self.time_created)


def get_auto_scaling_configuration(auto_scaling_configuration_id: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutoScalingConfigurationResult:
    """
    This data source provides details about a specific Auto Scaling Configuration resource in Oracle Cloud Infrastructure Auto Scaling service.

    Gets information about the specified autoscaling configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_auto_scaling_configuration = oci.Autoscaling.get_auto_scaling_configuration(auto_scaling_configuration_id=oci_autoscaling_auto_scaling_configuration["test_auto_scaling_configuration"]["id"])
    ```


    :param str auto_scaling_configuration_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the autoscaling configuration.
    """
    __args__ = dict()
    __args__['autoScalingConfigurationId'] = auto_scaling_configuration_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Autoscaling/getAutoScalingConfiguration:getAutoScalingConfiguration', __args__, opts=opts, typ=GetAutoScalingConfigurationResult).value

    return AwaitableGetAutoScalingConfigurationResult(
        auto_scaling_configuration_id=pulumi.get(__ret__, 'auto_scaling_configuration_id'),
        auto_scaling_resources=pulumi.get(__ret__, 'auto_scaling_resources'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        cool_down_in_seconds=pulumi.get(__ret__, 'cool_down_in_seconds'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_enabled=pulumi.get(__ret__, 'is_enabled'),
        max_resource_count=pulumi.get(__ret__, 'max_resource_count'),
        min_resource_count=pulumi.get(__ret__, 'min_resource_count'),
        policies=pulumi.get(__ret__, 'policies'),
        time_created=pulumi.get(__ret__, 'time_created'))


@_utilities.lift_output_func(get_auto_scaling_configuration)
def get_auto_scaling_configuration_output(auto_scaling_configuration_id: Optional[pulumi.Input[str]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAutoScalingConfigurationResult]:
    """
    This data source provides details about a specific Auto Scaling Configuration resource in Oracle Cloud Infrastructure Auto Scaling service.

    Gets information about the specified autoscaling configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_auto_scaling_configuration = oci.Autoscaling.get_auto_scaling_configuration(auto_scaling_configuration_id=oci_autoscaling_auto_scaling_configuration["test_auto_scaling_configuration"]["id"])
    ```


    :param str auto_scaling_configuration_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the autoscaling configuration.
    """
    ...
