# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutoScalingConfigurationArgs', 'AutoScalingConfiguration']

@pulumi.input_type
class AutoScalingConfigurationArgs:
    def __init__(__self__, *,
                 bds_instance_id: pulumi.Input[str],
                 cluster_admin_password: pulumi.Input[str],
                 is_enabled: pulumi.Input[bool],
                 node_type: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input['AutoScalingConfigurationPolicyArgs']] = None,
                 policy_details: Optional[pulumi.Input['AutoScalingConfigurationPolicyDetailsArgs']] = None):
        """
        The set of arguments for constructing a AutoScalingConfiguration resource.
        :param pulumi.Input[str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[str] cluster_admin_password: (Updatable) Base-64 encoded password for the cluster (and Cloudera Manager) admin user.
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether the autoscale configuration is enabled.
        :param pulumi.Input[str] node_type: A node type that is managed by an autoscale configuration. The only supported types are WORKER, COMPUTE_ONLY_WORKER and KAFKA_BROKER.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        :param pulumi.Input['AutoScalingConfigurationPolicyArgs'] policy: (Updatable) This model for autoscaling policy is deprecated and not supported for ODH clusters. Use the `AutoScalePolicyDetails` model to manage autoscale policy details for ODH clusters.
        :param pulumi.Input['AutoScalingConfigurationPolicyDetailsArgs'] policy_details: (Updatable) Policy definition for the autoscale configuration.
               
               An autoscaling policy is part of an autoscaling configuration. For more information, see [Autoscaling](https://docs.cloud.oracle.com/iaas/Content/bigdata/create-cluster.htm#cluster-autoscale)
               
               You can create following type of autoscaling policies:
               * **MetricBasedVerticalScalingPolicy:** Vertical autoscaling action is triggered when a performance metric exceeds a threshold
               * **MetricBasedHorizontalScalingPolicy:** Horizontal autoscaling action is triggered when a performance metric exceeds a threshold
               * **ScheduleBasedVerticalScalingPolicy:** Vertical autoscaling action is triggered at the specific times that you schedule.
               * **ScheduleBasedHorizontalScalingPolicy:** Horizontal autoscaling action is triggered at the specific times that you schedule.
               
               An autoscaling configuration can have one of above supported policies.
        """
        AutoScalingConfigurationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bds_instance_id=bds_instance_id,
            cluster_admin_password=cluster_admin_password,
            is_enabled=is_enabled,
            node_type=node_type,
            display_name=display_name,
            policy=policy,
            policy_details=policy_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bds_instance_id: pulumi.Input[str],
             cluster_admin_password: pulumi.Input[str],
             is_enabled: pulumi.Input[bool],
             node_type: pulumi.Input[str],
             display_name: Optional[pulumi.Input[str]] = None,
             policy: Optional[pulumi.Input['AutoScalingConfigurationPolicyArgs']] = None,
             policy_details: Optional[pulumi.Input['AutoScalingConfigurationPolicyDetailsArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bds_instance_id", bds_instance_id)
        _setter("cluster_admin_password", cluster_admin_password)
        _setter("is_enabled", is_enabled)
        _setter("node_type", node_type)
        if display_name is not None:
            _setter("display_name", display_name)
        if policy is not None:
            _setter("policy", policy)
        if policy_details is not None:
            _setter("policy_details", policy_details)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Input[str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "bds_instance_id", value)

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Input[str]:
        """
        (Updatable) Base-64 encoded password for the cluster (and Cloudera Manager) admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_admin_password", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        (Updatable) Whether the autoscale configuration is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[str]:
        """
        A node type that is managed by an autoscale configuration. The only supported types are WORKER, COMPUTE_ONLY_WORKER and KAFKA_BROKER.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['AutoScalingConfigurationPolicyArgs']]:
        """
        (Updatable) This model for autoscaling policy is deprecated and not supported for ODH clusters. Use the `AutoScalePolicyDetails` model to manage autoscale policy details for ODH clusters.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['AutoScalingConfigurationPolicyArgs']]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="policyDetails")
    def policy_details(self) -> Optional[pulumi.Input['AutoScalingConfigurationPolicyDetailsArgs']]:
        """
        (Updatable) Policy definition for the autoscale configuration.

        An autoscaling policy is part of an autoscaling configuration. For more information, see [Autoscaling](https://docs.cloud.oracle.com/iaas/Content/bigdata/create-cluster.htm#cluster-autoscale)

        You can create following type of autoscaling policies:
        * **MetricBasedVerticalScalingPolicy:** Vertical autoscaling action is triggered when a performance metric exceeds a threshold
        * **MetricBasedHorizontalScalingPolicy:** Horizontal autoscaling action is triggered when a performance metric exceeds a threshold
        * **ScheduleBasedVerticalScalingPolicy:** Vertical autoscaling action is triggered at the specific times that you schedule.
        * **ScheduleBasedHorizontalScalingPolicy:** Horizontal autoscaling action is triggered at the specific times that you schedule.

        An autoscaling configuration can have one of above supported policies.
        """
        return pulumi.get(self, "policy_details")

    @policy_details.setter
    def policy_details(self, value: Optional[pulumi.Input['AutoScalingConfigurationPolicyDetailsArgs']]):
        pulumi.set(self, "policy_details", value)


@pulumi.input_type
class _AutoScalingConfigurationState:
    def __init__(__self__, *,
                 bds_instance_id: Optional[pulumi.Input[str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input['AutoScalingConfigurationPolicyArgs']] = None,
                 policy_details: Optional[pulumi.Input['AutoScalingConfigurationPolicyDetailsArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AutoScalingConfiguration resources.
        :param pulumi.Input[str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[str] cluster_admin_password: (Updatable) Base-64 encoded password for the cluster (and Cloudera Manager) admin user.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether the autoscale configuration is enabled.
        :param pulumi.Input[str] node_type: A node type that is managed by an autoscale configuration. The only supported types are WORKER, COMPUTE_ONLY_WORKER and KAFKA_BROKER.
        :param pulumi.Input['AutoScalingConfigurationPolicyArgs'] policy: (Updatable) This model for autoscaling policy is deprecated and not supported for ODH clusters. Use the `AutoScalePolicyDetails` model to manage autoscale policy details for ODH clusters.
        :param pulumi.Input['AutoScalingConfigurationPolicyDetailsArgs'] policy_details: (Updatable) Policy definition for the autoscale configuration.
               
               An autoscaling policy is part of an autoscaling configuration. For more information, see [Autoscaling](https://docs.cloud.oracle.com/iaas/Content/bigdata/create-cluster.htm#cluster-autoscale)
               
               You can create following type of autoscaling policies:
               * **MetricBasedVerticalScalingPolicy:** Vertical autoscaling action is triggered when a performance metric exceeds a threshold
               * **MetricBasedHorizontalScalingPolicy:** Horizontal autoscaling action is triggered when a performance metric exceeds a threshold
               * **ScheduleBasedVerticalScalingPolicy:** Vertical autoscaling action is triggered at the specific times that you schedule.
               * **ScheduleBasedHorizontalScalingPolicy:** Horizontal autoscaling action is triggered at the specific times that you schedule.
               
               An autoscaling configuration can have one of above supported policies.
        :param pulumi.Input[str] state: The state of the autoscale configuration.
        :param pulumi.Input[str] time_created: The time the cluster was created, shown as an RFC 3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time the autoscale configuration was updated, shown as an RFC 3339 formatted datetime string.
        """
        _AutoScalingConfigurationState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bds_instance_id=bds_instance_id,
            cluster_admin_password=cluster_admin_password,
            display_name=display_name,
            is_enabled=is_enabled,
            node_type=node_type,
            policy=policy,
            policy_details=policy_details,
            state=state,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bds_instance_id: Optional[pulumi.Input[str]] = None,
             cluster_admin_password: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             is_enabled: Optional[pulumi.Input[bool]] = None,
             node_type: Optional[pulumi.Input[str]] = None,
             policy: Optional[pulumi.Input['AutoScalingConfigurationPolicyArgs']] = None,
             policy_details: Optional[pulumi.Input['AutoScalingConfigurationPolicyDetailsArgs']] = None,
             state: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if bds_instance_id is not None:
            _setter("bds_instance_id", bds_instance_id)
        if cluster_admin_password is not None:
            _setter("cluster_admin_password", cluster_admin_password)
        if display_name is not None:
            _setter("display_name", display_name)
        if is_enabled is not None:
            _setter("is_enabled", is_enabled)
        if node_type is not None:
            _setter("node_type", node_type)
        if policy is not None:
            _setter("policy", policy)
        if policy_details is not None:
            _setter("policy_details", policy_details)
        if state is not None:
            _setter("state", state)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bds_instance_id", value)

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Base-64 encoded password for the cluster (and Cloudera Manager) admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_admin_password", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether the autoscale configuration is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[str]]:
        """
        A node type that is managed by an autoscale configuration. The only supported types are WORKER, COMPUTE_ONLY_WORKER and KAFKA_BROKER.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['AutoScalingConfigurationPolicyArgs']]:
        """
        (Updatable) This model for autoscaling policy is deprecated and not supported for ODH clusters. Use the `AutoScalePolicyDetails` model to manage autoscale policy details for ODH clusters.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['AutoScalingConfigurationPolicyArgs']]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="policyDetails")
    def policy_details(self) -> Optional[pulumi.Input['AutoScalingConfigurationPolicyDetailsArgs']]:
        """
        (Updatable) Policy definition for the autoscale configuration.

        An autoscaling policy is part of an autoscaling configuration. For more information, see [Autoscaling](https://docs.cloud.oracle.com/iaas/Content/bigdata/create-cluster.htm#cluster-autoscale)

        You can create following type of autoscaling policies:
        * **MetricBasedVerticalScalingPolicy:** Vertical autoscaling action is triggered when a performance metric exceeds a threshold
        * **MetricBasedHorizontalScalingPolicy:** Horizontal autoscaling action is triggered when a performance metric exceeds a threshold
        * **ScheduleBasedVerticalScalingPolicy:** Vertical autoscaling action is triggered at the specific times that you schedule.
        * **ScheduleBasedHorizontalScalingPolicy:** Horizontal autoscaling action is triggered at the specific times that you schedule.

        An autoscaling configuration can have one of above supported policies.
        """
        return pulumi.get(self, "policy_details")

    @policy_details.setter
    def policy_details(self, value: Optional[pulumi.Input['AutoScalingConfigurationPolicyDetailsArgs']]):
        pulumi.set(self, "policy_details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the autoscale configuration.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the cluster was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the autoscale configuration was updated, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class AutoScalingConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bds_instance_id: Optional[pulumi.Input[str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[pulumi.InputType['AutoScalingConfigurationPolicyArgs']]] = None,
                 policy_details: Optional[pulumi.Input[pulumi.InputType['AutoScalingConfigurationPolicyDetailsArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Auto Scaling Configuration resource in Oracle Cloud Infrastructure Big Data Service service.

        Add an autoscale configuration to the cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_auto_scaling_configuration = oci.big_data_service.AutoScalingConfiguration("testAutoScalingConfiguration",
            bds_instance_id=oci_bds_bds_instance["test_bds_instance"]["id"],
            cluster_admin_password=var["auto_scaling_configuration_cluster_admin_password"],
            is_enabled=var["auto_scaling_configuration_is_enabled"],
            node_type=var["auto_scaling_configuration_node_type"],
            display_name=var["auto_scaling_configuration_display_name"],
            policy_details=oci.big_data_service.AutoScalingConfigurationPolicyDetailsArgs(
                policy_type=var["auto_scaling_configuration_policy_details_policy_type"],
                scale_down_config=oci.big_data_service.AutoScalingConfigurationPolicyDetailsScaleDownConfigArgs(
                    memory_step_size=var["auto_scaling_configuration_policy_details_scale_down_config_memory_step_size"],
                    metric=oci.big_data_service.AutoScalingConfigurationPolicyDetailsScaleDownConfigMetricArgs(
                        metric_type=var["auto_scaling_configuration_policy_details_scale_down_config_metric_metric_type"],
                        threshold=oci.big_data_service.AutoScalingConfigurationPolicyDetailsScaleDownConfigMetricThresholdArgs(
                            duration_in_minutes=var["auto_scaling_configuration_policy_details_scale_down_config_metric_threshold_duration_in_minutes"],
                            operator=var["auto_scaling_configuration_policy_details_scale_down_config_metric_threshold_operator"],
                            value=var["auto_scaling_configuration_policy_details_scale_down_config_metric_threshold_value"],
                        ),
                    ),
                    min_memory_per_node=var["auto_scaling_configuration_policy_details_scale_down_config_min_memory_per_node"],
                    min_ocpus_per_node=var["auto_scaling_configuration_policy_details_scale_down_config_min_ocpus_per_node"],
                    ocpu_step_size=var["auto_scaling_configuration_policy_details_scale_down_config_ocpu_step_size"],
                ),
                scale_up_config=oci.big_data_service.AutoScalingConfigurationPolicyDetailsScaleUpConfigArgs(
                    max_memory_per_node=var["auto_scaling_configuration_policy_details_scale_up_config_max_memory_per_node"],
                    max_ocpus_per_node=var["auto_scaling_configuration_policy_details_scale_up_config_max_ocpus_per_node"],
                    memory_step_size=var["auto_scaling_configuration_policy_details_scale_up_config_memory_step_size"],
                    metric=oci.big_data_service.AutoScalingConfigurationPolicyDetailsScaleUpConfigMetricArgs(
                        metric_type=var["auto_scaling_configuration_policy_details_scale_up_config_metric_metric_type"],
                        threshold=oci.big_data_service.AutoScalingConfigurationPolicyDetailsScaleUpConfigMetricThresholdArgs(
                            duration_in_minutes=var["auto_scaling_configuration_policy_details_scale_up_config_metric_threshold_duration_in_minutes"],
                            operator=var["auto_scaling_configuration_policy_details_scale_up_config_metric_threshold_operator"],
                            value=var["auto_scaling_configuration_policy_details_scale_up_config_metric_threshold_value"],
                        ),
                    ),
                    ocpu_step_size=var["auto_scaling_configuration_policy_details_scale_up_config_ocpu_step_size"],
                ),
            ))
        ```

        ## Import

        AutoScalingConfiguration can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:BigDataService/autoScalingConfiguration:AutoScalingConfiguration test_auto_scaling_configuration "bdsInstances/{bdsInstanceId}/autoScalingConfiguration/{autoScalingConfigurationId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[str] cluster_admin_password: (Updatable) Base-64 encoded password for the cluster (and Cloudera Manager) admin user.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether the autoscale configuration is enabled.
        :param pulumi.Input[str] node_type: A node type that is managed by an autoscale configuration. The only supported types are WORKER, COMPUTE_ONLY_WORKER and KAFKA_BROKER.
        :param pulumi.Input[pulumi.InputType['AutoScalingConfigurationPolicyArgs']] policy: (Updatable) This model for autoscaling policy is deprecated and not supported for ODH clusters. Use the `AutoScalePolicyDetails` model to manage autoscale policy details for ODH clusters.
        :param pulumi.Input[pulumi.InputType['AutoScalingConfigurationPolicyDetailsArgs']] policy_details: (Updatable) Policy definition for the autoscale configuration.
               
               An autoscaling policy is part of an autoscaling configuration. For more information, see [Autoscaling](https://docs.cloud.oracle.com/iaas/Content/bigdata/create-cluster.htm#cluster-autoscale)
               
               You can create following type of autoscaling policies:
               * **MetricBasedVerticalScalingPolicy:** Vertical autoscaling action is triggered when a performance metric exceeds a threshold
               * **MetricBasedHorizontalScalingPolicy:** Horizontal autoscaling action is triggered when a performance metric exceeds a threshold
               * **ScheduleBasedVerticalScalingPolicy:** Vertical autoscaling action is triggered at the specific times that you schedule.
               * **ScheduleBasedHorizontalScalingPolicy:** Horizontal autoscaling action is triggered at the specific times that you schedule.
               
               An autoscaling configuration can have one of above supported policies.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutoScalingConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Auto Scaling Configuration resource in Oracle Cloud Infrastructure Big Data Service service.

        Add an autoscale configuration to the cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_auto_scaling_configuration = oci.big_data_service.AutoScalingConfiguration("testAutoScalingConfiguration",
            bds_instance_id=oci_bds_bds_instance["test_bds_instance"]["id"],
            cluster_admin_password=var["auto_scaling_configuration_cluster_admin_password"],
            is_enabled=var["auto_scaling_configuration_is_enabled"],
            node_type=var["auto_scaling_configuration_node_type"],
            display_name=var["auto_scaling_configuration_display_name"],
            policy_details=oci.big_data_service.AutoScalingConfigurationPolicyDetailsArgs(
                policy_type=var["auto_scaling_configuration_policy_details_policy_type"],
                scale_down_config=oci.big_data_service.AutoScalingConfigurationPolicyDetailsScaleDownConfigArgs(
                    memory_step_size=var["auto_scaling_configuration_policy_details_scale_down_config_memory_step_size"],
                    metric=oci.big_data_service.AutoScalingConfigurationPolicyDetailsScaleDownConfigMetricArgs(
                        metric_type=var["auto_scaling_configuration_policy_details_scale_down_config_metric_metric_type"],
                        threshold=oci.big_data_service.AutoScalingConfigurationPolicyDetailsScaleDownConfigMetricThresholdArgs(
                            duration_in_minutes=var["auto_scaling_configuration_policy_details_scale_down_config_metric_threshold_duration_in_minutes"],
                            operator=var["auto_scaling_configuration_policy_details_scale_down_config_metric_threshold_operator"],
                            value=var["auto_scaling_configuration_policy_details_scale_down_config_metric_threshold_value"],
                        ),
                    ),
                    min_memory_per_node=var["auto_scaling_configuration_policy_details_scale_down_config_min_memory_per_node"],
                    min_ocpus_per_node=var["auto_scaling_configuration_policy_details_scale_down_config_min_ocpus_per_node"],
                    ocpu_step_size=var["auto_scaling_configuration_policy_details_scale_down_config_ocpu_step_size"],
                ),
                scale_up_config=oci.big_data_service.AutoScalingConfigurationPolicyDetailsScaleUpConfigArgs(
                    max_memory_per_node=var["auto_scaling_configuration_policy_details_scale_up_config_max_memory_per_node"],
                    max_ocpus_per_node=var["auto_scaling_configuration_policy_details_scale_up_config_max_ocpus_per_node"],
                    memory_step_size=var["auto_scaling_configuration_policy_details_scale_up_config_memory_step_size"],
                    metric=oci.big_data_service.AutoScalingConfigurationPolicyDetailsScaleUpConfigMetricArgs(
                        metric_type=var["auto_scaling_configuration_policy_details_scale_up_config_metric_metric_type"],
                        threshold=oci.big_data_service.AutoScalingConfigurationPolicyDetailsScaleUpConfigMetricThresholdArgs(
                            duration_in_minutes=var["auto_scaling_configuration_policy_details_scale_up_config_metric_threshold_duration_in_minutes"],
                            operator=var["auto_scaling_configuration_policy_details_scale_up_config_metric_threshold_operator"],
                            value=var["auto_scaling_configuration_policy_details_scale_up_config_metric_threshold_value"],
                        ),
                    ),
                    ocpu_step_size=var["auto_scaling_configuration_policy_details_scale_up_config_ocpu_step_size"],
                ),
            ))
        ```

        ## Import

        AutoScalingConfiguration can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:BigDataService/autoScalingConfiguration:AutoScalingConfiguration test_auto_scaling_configuration "bdsInstances/{bdsInstanceId}/autoScalingConfiguration/{autoScalingConfigurationId}"
        ```

        :param str resource_name: The name of the resource.
        :param AutoScalingConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutoScalingConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            AutoScalingConfigurationArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bds_instance_id: Optional[pulumi.Input[str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[pulumi.InputType['AutoScalingConfigurationPolicyArgs']]] = None,
                 policy_details: Optional[pulumi.Input[pulumi.InputType['AutoScalingConfigurationPolicyDetailsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutoScalingConfigurationArgs.__new__(AutoScalingConfigurationArgs)

            if bds_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'bds_instance_id'")
            __props__.__dict__["bds_instance_id"] = bds_instance_id
            if cluster_admin_password is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_admin_password'")
            __props__.__dict__["cluster_admin_password"] = None if cluster_admin_password is None else pulumi.Output.secret(cluster_admin_password)
            __props__.__dict__["display_name"] = display_name
            if is_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'is_enabled'")
            __props__.__dict__["is_enabled"] = is_enabled
            if node_type is None and not opts.urn:
                raise TypeError("Missing required property 'node_type'")
            __props__.__dict__["node_type"] = node_type
            if policy is not None and not isinstance(policy, AutoScalingConfigurationPolicyArgs):
                policy = policy or {}
                def _setter(key, value):
                    policy[key] = value
                AutoScalingConfigurationPolicyArgs._configure(_setter, **policy)
            __props__.__dict__["policy"] = policy
            if policy_details is not None and not isinstance(policy_details, AutoScalingConfigurationPolicyDetailsArgs):
                policy_details = policy_details or {}
                def _setter(key, value):
                    policy_details[key] = value
                AutoScalingConfigurationPolicyDetailsArgs._configure(_setter, **policy_details)
            __props__.__dict__["policy_details"] = policy_details
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clusterAdminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AutoScalingConfiguration, __self__).__init__(
            'oci:BigDataService/autoScalingConfiguration:AutoScalingConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bds_instance_id: Optional[pulumi.Input[str]] = None,
            cluster_admin_password: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            is_enabled: Optional[pulumi.Input[bool]] = None,
            node_type: Optional[pulumi.Input[str]] = None,
            policy: Optional[pulumi.Input[pulumi.InputType['AutoScalingConfigurationPolicyArgs']]] = None,
            policy_details: Optional[pulumi.Input[pulumi.InputType['AutoScalingConfigurationPolicyDetailsArgs']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'AutoScalingConfiguration':
        """
        Get an existing AutoScalingConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[str] cluster_admin_password: (Updatable) Base-64 encoded password for the cluster (and Cloudera Manager) admin user.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether the autoscale configuration is enabled.
        :param pulumi.Input[str] node_type: A node type that is managed by an autoscale configuration. The only supported types are WORKER, COMPUTE_ONLY_WORKER and KAFKA_BROKER.
        :param pulumi.Input[pulumi.InputType['AutoScalingConfigurationPolicyArgs']] policy: (Updatable) This model for autoscaling policy is deprecated and not supported for ODH clusters. Use the `AutoScalePolicyDetails` model to manage autoscale policy details for ODH clusters.
        :param pulumi.Input[pulumi.InputType['AutoScalingConfigurationPolicyDetailsArgs']] policy_details: (Updatable) Policy definition for the autoscale configuration.
               
               An autoscaling policy is part of an autoscaling configuration. For more information, see [Autoscaling](https://docs.cloud.oracle.com/iaas/Content/bigdata/create-cluster.htm#cluster-autoscale)
               
               You can create following type of autoscaling policies:
               * **MetricBasedVerticalScalingPolicy:** Vertical autoscaling action is triggered when a performance metric exceeds a threshold
               * **MetricBasedHorizontalScalingPolicy:** Horizontal autoscaling action is triggered when a performance metric exceeds a threshold
               * **ScheduleBasedVerticalScalingPolicy:** Vertical autoscaling action is triggered at the specific times that you schedule.
               * **ScheduleBasedHorizontalScalingPolicy:** Horizontal autoscaling action is triggered at the specific times that you schedule.
               
               An autoscaling configuration can have one of above supported policies.
        :param pulumi.Input[str] state: The state of the autoscale configuration.
        :param pulumi.Input[str] time_created: The time the cluster was created, shown as an RFC 3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time the autoscale configuration was updated, shown as an RFC 3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutoScalingConfigurationState.__new__(_AutoScalingConfigurationState)

        __props__.__dict__["bds_instance_id"] = bds_instance_id
        __props__.__dict__["cluster_admin_password"] = cluster_admin_password
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["policy"] = policy
        __props__.__dict__["policy_details"] = policy_details
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return AutoScalingConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Output[str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Output[str]:
        """
        (Updatable) Base-64 encoded password for the cluster (and Cloudera Manager) admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Whether the autoscale configuration is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[str]:
        """
        A node type that is managed by an autoscale configuration. The only supported types are WORKER, COMPUTE_ONLY_WORKER and KAFKA_BROKER.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Output['outputs.AutoScalingConfigurationPolicy']:
        """
        (Updatable) This model for autoscaling policy is deprecated and not supported for ODH clusters. Use the `AutoScalePolicyDetails` model to manage autoscale policy details for ODH clusters.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="policyDetails")
    def policy_details(self) -> pulumi.Output['outputs.AutoScalingConfigurationPolicyDetails']:
        """
        (Updatable) Policy definition for the autoscale configuration.

        An autoscaling policy is part of an autoscaling configuration. For more information, see [Autoscaling](https://docs.cloud.oracle.com/iaas/Content/bigdata/create-cluster.htm#cluster-autoscale)

        You can create following type of autoscaling policies:
        * **MetricBasedVerticalScalingPolicy:** Vertical autoscaling action is triggered when a performance metric exceeds a threshold
        * **MetricBasedHorizontalScalingPolicy:** Horizontal autoscaling action is triggered when a performance metric exceeds a threshold
        * **ScheduleBasedVerticalScalingPolicy:** Vertical autoscaling action is triggered at the specific times that you schedule.
        * **ScheduleBasedHorizontalScalingPolicy:** Horizontal autoscaling action is triggered at the specific times that you schedule.

        An autoscaling configuration can have one of above supported policies.
        """
        return pulumi.get(self, "policy_details")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the autoscale configuration.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the cluster was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the autoscale configuration was updated, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

