# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BootVolumeBackupArgs', 'BootVolumeBackup']

@pulumi.input_type
class BootVolumeBackupArgs:
    def __init__(__self__, *,
                 boot_volume_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 source_details: Optional[pulumi.Input['BootVolumeBackupSourceDetailsArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BootVolumeBackup resource.
        :param pulumi.Input[str] boot_volume_id: The OCID of the boot volume that needs to be backed up. Cannot be defined if `source_details` is defined.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the boot volume backup.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] kms_key_id: The OCID of the KMS key in the destination region which will be the master encryption key for the copied volume backup.
        :param pulumi.Input['BootVolumeBackupSourceDetailsArgs'] source_details: Details of the volume backup source in the cloud. Cannot be defined if `boot_volume_id` is defined.
        :param pulumi.Input[str] type: The type of backup to create. If omitted, defaults to incremental. Supported values are 'FULL' or 'INCREMENTAL'.
        """
        BootVolumeBackupArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            boot_volume_id=boot_volume_id,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            kms_key_id=kms_key_id,
            source_details=source_details,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             boot_volume_id: Optional[pulumi.Input[str]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             kms_key_id: Optional[pulumi.Input[str]] = None,
             source_details: Optional[pulumi.Input['BootVolumeBackupSourceDetailsArgs']] = None,
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if boot_volume_id is not None:
            _setter("boot_volume_id", boot_volume_id)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if kms_key_id is not None:
            _setter("kms_key_id", kms_key_id)
        if source_details is not None:
            _setter("source_details", source_details)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter(name="bootVolumeId")
    def boot_volume_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the boot volume that needs to be backed up. Cannot be defined if `source_details` is defined.
        """
        return pulumi.get(self, "boot_volume_id")

    @boot_volume_id.setter
    def boot_volume_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_volume_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment that contains the boot volume backup.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the KMS key in the destination region which will be the master encryption key for the copied volume backup.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Optional[pulumi.Input['BootVolumeBackupSourceDetailsArgs']]:
        """
        Details of the volume backup source in the cloud. Cannot be defined if `boot_volume_id` is defined.
        """
        return pulumi.get(self, "source_details")

    @source_details.setter
    def source_details(self, value: Optional[pulumi.Input['BootVolumeBackupSourceDetailsArgs']]):
        pulumi.set(self, "source_details", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of backup to create. If omitted, defaults to incremental. Supported values are 'FULL' or 'INCREMENTAL'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _BootVolumeBackupState:
    def __init__(__self__, *,
                 boot_volume_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 size_in_gbs: Optional[pulumi.Input[str]] = None,
                 source_boot_volume_backup_id: Optional[pulumi.Input[str]] = None,
                 source_details: Optional[pulumi.Input['BootVolumeBackupSourceDetailsArgs']] = None,
                 source_type: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_request_received: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 unique_size_in_gbs: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering BootVolumeBackup resources.
        :param pulumi.Input[str] boot_volume_id: The OCID of the boot volume that needs to be backed up. Cannot be defined if `source_details` is defined.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the boot volume backup.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] expiration_time: The date and time the volume backup will expire and be automatically deleted. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). This parameter will always be present for backups that were created automatically by a scheduled-backup policy. For manually created backups, it will be absent, signifying that there is no expiration time and the backup will last forever until manually deleted.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] image_id: The image OCID used to create the boot volume the backup is taken from.
        :param pulumi.Input[str] kms_key_id: The OCID of the KMS key in the destination region which will be the master encryption key for the copied volume backup.
        :param pulumi.Input[str] size_in_gbs: The size of the boot volume, in GBs.
        :param pulumi.Input[str] source_boot_volume_backup_id: The OCID of the source boot volume backup.
        :param pulumi.Input['BootVolumeBackupSourceDetailsArgs'] source_details: Details of the volume backup source in the cloud. Cannot be defined if `boot_volume_id` is defined.
        :param pulumi.Input[str] source_type: Specifies whether the backup was created manually, or via scheduled backup policy.
        :param pulumi.Input[str] state: The current state of a boot volume backup.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] time_created: The date and time the boot volume backup was created. This is the time the actual point-in-time image of the volume data was taken. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_request_received: The date and time the request to create the boot volume backup was received. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] type: The type of backup to create. If omitted, defaults to incremental. Supported values are 'FULL' or 'INCREMENTAL'.
        :param pulumi.Input[str] unique_size_in_gbs: The size used by the backup, in GBs. It is typically smaller than sizeInGBs, depending on the space consumed on the boot volume and whether the backup is full or incremental.
        """
        _BootVolumeBackupState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            boot_volume_id=boot_volume_id,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            expiration_time=expiration_time,
            freeform_tags=freeform_tags,
            image_id=image_id,
            kms_key_id=kms_key_id,
            size_in_gbs=size_in_gbs,
            source_boot_volume_backup_id=source_boot_volume_backup_id,
            source_details=source_details,
            source_type=source_type,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_request_received=time_request_received,
            type=type,
            unique_size_in_gbs=unique_size_in_gbs,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             boot_volume_id: Optional[pulumi.Input[str]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             expiration_time: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             image_id: Optional[pulumi.Input[str]] = None,
             kms_key_id: Optional[pulumi.Input[str]] = None,
             size_in_gbs: Optional[pulumi.Input[str]] = None,
             source_boot_volume_backup_id: Optional[pulumi.Input[str]] = None,
             source_details: Optional[pulumi.Input['BootVolumeBackupSourceDetailsArgs']] = None,
             source_type: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_request_received: Optional[pulumi.Input[str]] = None,
             type: Optional[pulumi.Input[str]] = None,
             unique_size_in_gbs: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if boot_volume_id is not None:
            _setter("boot_volume_id", boot_volume_id)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if expiration_time is not None:
            _setter("expiration_time", expiration_time)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if image_id is not None:
            _setter("image_id", image_id)
        if kms_key_id is not None:
            _setter("kms_key_id", kms_key_id)
        if size_in_gbs is not None:
            _setter("size_in_gbs", size_in_gbs)
        if source_boot_volume_backup_id is not None:
            _setter("source_boot_volume_backup_id", source_boot_volume_backup_id)
        if source_details is not None:
            _setter("source_details", source_details)
        if source_type is not None:
            _setter("source_type", source_type)
        if state is not None:
            _setter("state", state)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_request_received is not None:
            _setter("time_request_received", time_request_received)
        if type is not None:
            _setter("type", type)
        if unique_size_in_gbs is not None:
            _setter("unique_size_in_gbs", unique_size_in_gbs)

    @property
    @pulumi.getter(name="bootVolumeId")
    def boot_volume_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the boot volume that needs to be backed up. Cannot be defined if `source_details` is defined.
        """
        return pulumi.get(self, "boot_volume_id")

    @boot_volume_id.setter
    def boot_volume_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_volume_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment that contains the boot volume backup.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the volume backup will expire and be automatically deleted. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). This parameter will always be present for backups that were created automatically by a scheduled-backup policy. For manually created backups, it will be absent, signifying that there is no expiration time and the backup will last forever until manually deleted.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The image OCID used to create the boot volume the backup is taken from.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the KMS key in the destination region which will be the master encryption key for the copied volume backup.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="sizeInGbs")
    def size_in_gbs(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the boot volume, in GBs.
        """
        return pulumi.get(self, "size_in_gbs")

    @size_in_gbs.setter
    def size_in_gbs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_in_gbs", value)

    @property
    @pulumi.getter(name="sourceBootVolumeBackupId")
    def source_boot_volume_backup_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the source boot volume backup.
        """
        return pulumi.get(self, "source_boot_volume_backup_id")

    @source_boot_volume_backup_id.setter
    def source_boot_volume_backup_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_boot_volume_backup_id", value)

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Optional[pulumi.Input['BootVolumeBackupSourceDetailsArgs']]:
        """
        Details of the volume backup source in the cloud. Cannot be defined if `boot_volume_id` is defined.
        """
        return pulumi.get(self, "source_details")

    @source_details.setter
    def source_details(self, value: Optional[pulumi.Input['BootVolumeBackupSourceDetailsArgs']]):
        pulumi.set(self, "source_details", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the backup was created manually, or via scheduled backup policy.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of a boot volume backup.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the boot volume backup was created. This is the time the actual point-in-time image of the volume data was taken. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeRequestReceived")
    def time_request_received(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the request to create the boot volume backup was received. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_request_received")

    @time_request_received.setter
    def time_request_received(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_request_received", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of backup to create. If omitted, defaults to incremental. Supported values are 'FULL' or 'INCREMENTAL'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="uniqueSizeInGbs")
    def unique_size_in_gbs(self) -> Optional[pulumi.Input[str]]:
        """
        The size used by the backup, in GBs. It is typically smaller than sizeInGBs, depending on the space consumed on the boot volume and whether the backup is full or incremental.
        """
        return pulumi.get(self, "unique_size_in_gbs")

    @unique_size_in_gbs.setter
    def unique_size_in_gbs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unique_size_in_gbs", value)


class BootVolumeBackup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 boot_volume_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 source_details: Optional[pulumi.Input[pulumi.InputType['BootVolumeBackupSourceDetailsArgs']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Boot Volume Backup resource in Oracle Cloud Infrastructure Core service.

        Creates a new boot volume backup of the specified boot volume. For general information about boot volume backups,
        see [Overview of Boot Volume Backups](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/bootvolumebackups.htm)

        When the request is received, the backup object is in a REQUEST_RECEIVED state.
        When the data is imaged, it goes into a CREATING state.
        After the backup is fully uploaded to the cloud, it goes into an AVAILABLE state.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_boot_volume_backup = oci.core.BootVolumeBackup("testBootVolumeBackup",
            boot_volume_id=oci_core_boot_volume["test_boot_volume"]["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=var["boot_volume_backup_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            kms_key_id=oci_kms_key["test_key"]["id"],
            type=var["boot_volume_backup_type"])
        ```

        ## Import

        BootVolumeBackups can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Core/bootVolumeBackup:BootVolumeBackup test_boot_volume_backup "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] boot_volume_id: The OCID of the boot volume that needs to be backed up. Cannot be defined if `source_details` is defined.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the boot volume backup.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] kms_key_id: The OCID of the KMS key in the destination region which will be the master encryption key for the copied volume backup.
        :param pulumi.Input[pulumi.InputType['BootVolumeBackupSourceDetailsArgs']] source_details: Details of the volume backup source in the cloud. Cannot be defined if `boot_volume_id` is defined.
        :param pulumi.Input[str] type: The type of backup to create. If omitted, defaults to incremental. Supported values are 'FULL' or 'INCREMENTAL'.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BootVolumeBackupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Boot Volume Backup resource in Oracle Cloud Infrastructure Core service.

        Creates a new boot volume backup of the specified boot volume. For general information about boot volume backups,
        see [Overview of Boot Volume Backups](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/bootvolumebackups.htm)

        When the request is received, the backup object is in a REQUEST_RECEIVED state.
        When the data is imaged, it goes into a CREATING state.
        After the backup is fully uploaded to the cloud, it goes into an AVAILABLE state.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_boot_volume_backup = oci.core.BootVolumeBackup("testBootVolumeBackup",
            boot_volume_id=oci_core_boot_volume["test_boot_volume"]["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=var["boot_volume_backup_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            kms_key_id=oci_kms_key["test_key"]["id"],
            type=var["boot_volume_backup_type"])
        ```

        ## Import

        BootVolumeBackups can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Core/bootVolumeBackup:BootVolumeBackup test_boot_volume_backup "id"
        ```

        :param str resource_name: The name of the resource.
        :param BootVolumeBackupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BootVolumeBackupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            BootVolumeBackupArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 boot_volume_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 source_details: Optional[pulumi.Input[pulumi.InputType['BootVolumeBackupSourceDetailsArgs']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BootVolumeBackupArgs.__new__(BootVolumeBackupArgs)

            __props__.__dict__["boot_volume_id"] = boot_volume_id
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["kms_key_id"] = kms_key_id
            if source_details is not None and not isinstance(source_details, BootVolumeBackupSourceDetailsArgs):
                source_details = source_details or {}
                def _setter(key, value):
                    source_details[key] = value
                BootVolumeBackupSourceDetailsArgs._configure(_setter, **source_details)
            __props__.__dict__["source_details"] = source_details
            __props__.__dict__["type"] = type
            __props__.__dict__["expiration_time"] = None
            __props__.__dict__["image_id"] = None
            __props__.__dict__["size_in_gbs"] = None
            __props__.__dict__["source_boot_volume_backup_id"] = None
            __props__.__dict__["source_type"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_request_received"] = None
            __props__.__dict__["unique_size_in_gbs"] = None
        super(BootVolumeBackup, __self__).__init__(
            'oci:Core/bootVolumeBackup:BootVolumeBackup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            boot_volume_id: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            expiration_time: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            size_in_gbs: Optional[pulumi.Input[str]] = None,
            source_boot_volume_backup_id: Optional[pulumi.Input[str]] = None,
            source_details: Optional[pulumi.Input[pulumi.InputType['BootVolumeBackupSourceDetailsArgs']]] = None,
            source_type: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_request_received: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            unique_size_in_gbs: Optional[pulumi.Input[str]] = None) -> 'BootVolumeBackup':
        """
        Get an existing BootVolumeBackup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] boot_volume_id: The OCID of the boot volume that needs to be backed up. Cannot be defined if `source_details` is defined.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the boot volume backup.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] expiration_time: The date and time the volume backup will expire and be automatically deleted. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). This parameter will always be present for backups that were created automatically by a scheduled-backup policy. For manually created backups, it will be absent, signifying that there is no expiration time and the backup will last forever until manually deleted.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] image_id: The image OCID used to create the boot volume the backup is taken from.
        :param pulumi.Input[str] kms_key_id: The OCID of the KMS key in the destination region which will be the master encryption key for the copied volume backup.
        :param pulumi.Input[str] size_in_gbs: The size of the boot volume, in GBs.
        :param pulumi.Input[str] source_boot_volume_backup_id: The OCID of the source boot volume backup.
        :param pulumi.Input[pulumi.InputType['BootVolumeBackupSourceDetailsArgs']] source_details: Details of the volume backup source in the cloud. Cannot be defined if `boot_volume_id` is defined.
        :param pulumi.Input[str] source_type: Specifies whether the backup was created manually, or via scheduled backup policy.
        :param pulumi.Input[str] state: The current state of a boot volume backup.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] time_created: The date and time the boot volume backup was created. This is the time the actual point-in-time image of the volume data was taken. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_request_received: The date and time the request to create the boot volume backup was received. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] type: The type of backup to create. If omitted, defaults to incremental. Supported values are 'FULL' or 'INCREMENTAL'.
        :param pulumi.Input[str] unique_size_in_gbs: The size used by the backup, in GBs. It is typically smaller than sizeInGBs, depending on the space consumed on the boot volume and whether the backup is full or incremental.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BootVolumeBackupState.__new__(_BootVolumeBackupState)

        __props__.__dict__["boot_volume_id"] = boot_volume_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["expiration_time"] = expiration_time
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["size_in_gbs"] = size_in_gbs
        __props__.__dict__["source_boot_volume_backup_id"] = source_boot_volume_backup_id
        __props__.__dict__["source_details"] = source_details
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_request_received"] = time_request_received
        __props__.__dict__["type"] = type
        __props__.__dict__["unique_size_in_gbs"] = unique_size_in_gbs
        return BootVolumeBackup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bootVolumeId")
    def boot_volume_id(self) -> pulumi.Output[str]:
        """
        The OCID of the boot volume that needs to be backed up. Cannot be defined if `source_details` is defined.
        """
        return pulumi.get(self, "boot_volume_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment that contains the boot volume backup.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> pulumi.Output[str]:
        """
        The date and time the volume backup will expire and be automatically deleted. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). This parameter will always be present for backups that were created automatically by a scheduled-backup policy. For manually created backups, it will be absent, signifying that there is no expiration time and the backup will last forever until manually deleted.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        The image OCID used to create the boot volume the backup is taken from.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        The OCID of the KMS key in the destination region which will be the master encryption key for the copied volume backup.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="sizeInGbs")
    def size_in_gbs(self) -> pulumi.Output[str]:
        """
        The size of the boot volume, in GBs.
        """
        return pulumi.get(self, "size_in_gbs")

    @property
    @pulumi.getter(name="sourceBootVolumeBackupId")
    def source_boot_volume_backup_id(self) -> pulumi.Output[str]:
        """
        The OCID of the source boot volume backup.
        """
        return pulumi.get(self, "source_boot_volume_backup_id")

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> pulumi.Output[Optional['outputs.BootVolumeBackupSourceDetails']]:
        """
        Details of the volume backup source in the cloud. Cannot be defined if `boot_volume_id` is defined.
        """
        return pulumi.get(self, "source_details")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[str]:
        """
        Specifies whether the backup was created manually, or via scheduled backup policy.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of a boot volume backup.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the boot volume backup was created. This is the time the actual point-in-time image of the volume data was taken. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeRequestReceived")
    def time_request_received(self) -> pulumi.Output[str]:
        """
        The date and time the request to create the boot volume backup was received. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_request_received")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of backup to create. If omitted, defaults to incremental. Supported values are 'FULL' or 'INCREMENTAL'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="uniqueSizeInGbs")
    def unique_size_in_gbs(self) -> pulumi.Output[str]:
        """
        The size used by the backup, in GBs. It is typically smaller than sizeInGBs, depending on the space consumed on the boot volume and whether the backup is full or incremental.
        """
        return pulumi.get(self, "unique_size_in_gbs")

