# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetIpsecConnectionTunnelResult',
    'AwaitableGetIpsecConnectionTunnelResult',
    'get_ipsec_connection_tunnel',
    'get_ipsec_connection_tunnel_output',
]

@pulumi.output_type
class GetIpsecConnectionTunnelResult:
    """
    A collection of values returned by getIpsecConnectionTunnel.
    """
    def __init__(__self__, bgp_session_infos=None, compartment_id=None, cpe_ip=None, display_name=None, encryption_domain_configs=None, id=None, ike_version=None, ipsec_id=None, routing=None, state=None, status=None, time_created=None, time_status_updated=None, tunnel_id=None, vpn_ip=None):
        if bgp_session_infos and not isinstance(bgp_session_infos, list):
            raise TypeError("Expected argument 'bgp_session_infos' to be a list")
        pulumi.set(__self__, "bgp_session_infos", bgp_session_infos)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if cpe_ip and not isinstance(cpe_ip, str):
            raise TypeError("Expected argument 'cpe_ip' to be a str")
        pulumi.set(__self__, "cpe_ip", cpe_ip)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if encryption_domain_configs and not isinstance(encryption_domain_configs, list):
            raise TypeError("Expected argument 'encryption_domain_configs' to be a list")
        pulumi.set(__self__, "encryption_domain_configs", encryption_domain_configs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ike_version and not isinstance(ike_version, str):
            raise TypeError("Expected argument 'ike_version' to be a str")
        pulumi.set(__self__, "ike_version", ike_version)
        if ipsec_id and not isinstance(ipsec_id, str):
            raise TypeError("Expected argument 'ipsec_id' to be a str")
        pulumi.set(__self__, "ipsec_id", ipsec_id)
        if routing and not isinstance(routing, str):
            raise TypeError("Expected argument 'routing' to be a str")
        pulumi.set(__self__, "routing", routing)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_status_updated and not isinstance(time_status_updated, str):
            raise TypeError("Expected argument 'time_status_updated' to be a str")
        pulumi.set(__self__, "time_status_updated", time_status_updated)
        if tunnel_id and not isinstance(tunnel_id, str):
            raise TypeError("Expected argument 'tunnel_id' to be a str")
        pulumi.set(__self__, "tunnel_id", tunnel_id)
        if vpn_ip and not isinstance(vpn_ip, str):
            raise TypeError("Expected argument 'vpn_ip' to be a str")
        pulumi.set(__self__, "vpn_ip", vpn_ip)

    @property
    @pulumi.getter(name="bgpSessionInfos")
    def bgp_session_infos(self) -> Sequence['outputs.GetIpsecConnectionTunnelBgpSessionInfoResult']:
        """
        Information needed to establish a BGP Session on an interface.
        """
        return pulumi.get(self, "bgp_session_infos")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the tunnel.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cpeIp")
    def cpe_ip(self) -> str:
        """
        The IP address of Cpe headend.  Example: `129.146.17.50`
        """
        return pulumi.get(self, "cpe_ip")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="encryptionDomainConfigs")
    def encryption_domain_configs(self) -> Sequence['outputs.GetIpsecConnectionTunnelEncryptionDomainConfigResult']:
        """
        Configuration information used by the encryption domain policy.
        """
        return pulumi.get(self, "encryption_domain_configs")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> str:
        """
        Internet Key Exchange protocol version.
        """
        return pulumi.get(self, "ike_version")

    @property
    @pulumi.getter(name="ipsecId")
    def ipsec_id(self) -> str:
        return pulumi.get(self, "ipsec_id")

    @property
    @pulumi.getter
    def routing(self) -> str:
        """
        the routing strategy used for this tunnel, either static route or BGP dynamic routing
        """
        return pulumi.get(self, "routing")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The IPSec connection's tunnel's lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The tunnel's current state.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the IPSec connection tunnel was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeStatusUpdated")
    def time_status_updated(self) -> str:
        """
        When the status of the tunnel last changed, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_status_updated")

    @property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> str:
        return pulumi.get(self, "tunnel_id")

    @property
    @pulumi.getter(name="vpnIp")
    def vpn_ip(self) -> str:
        """
        The IP address of Oracle's VPN headend.  Example: `129.146.17.50`
        """
        return pulumi.get(self, "vpn_ip")


class AwaitableGetIpsecConnectionTunnelResult(GetIpsecConnectionTunnelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpsecConnectionTunnelResult(
            bgp_session_infos=self.bgp_session_infos,
            compartment_id=self.compartment_id,
            cpe_ip=self.cpe_ip,
            display_name=self.display_name,
            encryption_domain_configs=self.encryption_domain_configs,
            id=self.id,
            ike_version=self.ike_version,
            ipsec_id=self.ipsec_id,
            routing=self.routing,
            state=self.state,
            status=self.status,
            time_created=self.time_created,
            time_status_updated=self.time_status_updated,
            tunnel_id=self.tunnel_id,
            vpn_ip=self.vpn_ip)


def get_ipsec_connection_tunnel(ipsec_id: Optional[str] = None,
                                tunnel_id: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpsecConnectionTunnelResult:
    """
    This data source provides details about a specific Ip Sec Connection Tunnel resource in Oracle Cloud Infrastructure Core service.

    Gets the specified IPSec connection's specified tunnel basic information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ip_sec_connection_tunnel = oci.Core.get_ipsec_connection_tunnel(ipsec_id=oci_core_ipsec["test_ipsec"]["id"],
        tunnel_id=data["oci_core_ipsec_connection_tunnels"]["test_ip_sec_connection_tunnels"]["ip_sec_connection_tunnels"][0]["id"])
    ```


    :param str ipsec_id: The OCID of the IPSec connection.
    :param str tunnel_id: The OCID of the IPSec connection's tunnel.
    """
    __args__ = dict()
    __args__['ipsecId'] = ipsec_id
    __args__['tunnelId'] = tunnel_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getIpsecConnectionTunnel:getIpsecConnectionTunnel', __args__, opts=opts, typ=GetIpsecConnectionTunnelResult).value

    return AwaitableGetIpsecConnectionTunnelResult(
        bgp_session_infos=pulumi.get(__ret__, 'bgp_session_infos'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        cpe_ip=pulumi.get(__ret__, 'cpe_ip'),
        display_name=pulumi.get(__ret__, 'display_name'),
        encryption_domain_configs=pulumi.get(__ret__, 'encryption_domain_configs'),
        id=pulumi.get(__ret__, 'id'),
        ike_version=pulumi.get(__ret__, 'ike_version'),
        ipsec_id=pulumi.get(__ret__, 'ipsec_id'),
        routing=pulumi.get(__ret__, 'routing'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_status_updated=pulumi.get(__ret__, 'time_status_updated'),
        tunnel_id=pulumi.get(__ret__, 'tunnel_id'),
        vpn_ip=pulumi.get(__ret__, 'vpn_ip'))


@_utilities.lift_output_func(get_ipsec_connection_tunnel)
def get_ipsec_connection_tunnel_output(ipsec_id: Optional[pulumi.Input[str]] = None,
                                       tunnel_id: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIpsecConnectionTunnelResult]:
    """
    This data source provides details about a specific Ip Sec Connection Tunnel resource in Oracle Cloud Infrastructure Core service.

    Gets the specified IPSec connection's specified tunnel basic information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ip_sec_connection_tunnel = oci.Core.get_ipsec_connection_tunnel(ipsec_id=oci_core_ipsec["test_ipsec"]["id"],
        tunnel_id=data["oci_core_ipsec_connection_tunnels"]["test_ip_sec_connection_tunnels"]["ip_sec_connection_tunnels"][0]["id"])
    ```


    :param str ipsec_id: The OCID of the IPSec connection.
    :param str tunnel_id: The OCID of the IPSec connection's tunnel.
    """
    ...
