# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ExternalContainerDatabaseManagementArgs', 'ExternalContainerDatabaseManagement']

@pulumi.input_type
class ExternalContainerDatabaseManagementArgs:
    def __init__(__self__, *,
                 enable_management: pulumi.Input[bool],
                 external_container_database_id: pulumi.Input[str],
                 external_database_connector_id: pulumi.Input[str],
                 license_model: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ExternalContainerDatabaseManagement resource.
        :param pulumi.Input[str] external_container_database_id: The ExternalContainerDatabase [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] external_database_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        :param pulumi.Input[str] license_model: The Oracle license model that applies to the external database. Required only for enabling database management.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ExternalContainerDatabaseManagementArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            enable_management=enable_management,
            external_container_database_id=external_container_database_id,
            external_database_connector_id=external_database_connector_id,
            license_model=license_model,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             enable_management: pulumi.Input[bool],
             external_container_database_id: pulumi.Input[str],
             external_database_connector_id: pulumi.Input[str],
             license_model: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("enable_management", enable_management)
        _setter("external_container_database_id", external_container_database_id)
        _setter("external_database_connector_id", external_database_connector_id)
        if license_model is not None:
            _setter("license_model", license_model)

    @property
    @pulumi.getter(name="enableManagement")
    def enable_management(self) -> pulumi.Input[bool]:
        return pulumi.get(self, "enable_management")

    @enable_management.setter
    def enable_management(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_management", value)

    @property
    @pulumi.getter(name="externalContainerDatabaseId")
    def external_container_database_id(self) -> pulumi.Input[str]:
        """
        The ExternalContainerDatabase [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "external_container_database_id")

    @external_container_database_id.setter
    def external_container_database_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "external_container_database_id", value)

    @property
    @pulumi.getter(name="externalDatabaseConnectorId")
    def external_database_connector_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        """
        return pulumi.get(self, "external_database_connector_id")

    @external_database_connector_id.setter
    def external_database_connector_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "external_database_connector_id", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle license model that applies to the external database. Required only for enabling database management.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)


@pulumi.input_type
class _ExternalContainerDatabaseManagementState:
    def __init__(__self__, *,
                 enable_management: Optional[pulumi.Input[bool]] = None,
                 external_container_database_id: Optional[pulumi.Input[str]] = None,
                 external_database_connector_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ExternalContainerDatabaseManagement resources.
        :param pulumi.Input[str] external_container_database_id: The ExternalContainerDatabase [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] external_database_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        :param pulumi.Input[str] license_model: The Oracle license model that applies to the external database. Required only for enabling database management.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        _ExternalContainerDatabaseManagementState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            enable_management=enable_management,
            external_container_database_id=external_container_database_id,
            external_database_connector_id=external_database_connector_id,
            license_model=license_model,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             enable_management: Optional[pulumi.Input[bool]] = None,
             external_container_database_id: Optional[pulumi.Input[str]] = None,
             external_database_connector_id: Optional[pulumi.Input[str]] = None,
             license_model: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if enable_management is not None:
            _setter("enable_management", enable_management)
        if external_container_database_id is not None:
            _setter("external_container_database_id", external_container_database_id)
        if external_database_connector_id is not None:
            _setter("external_database_connector_id", external_database_connector_id)
        if license_model is not None:
            _setter("license_model", license_model)

    @property
    @pulumi.getter(name="enableManagement")
    def enable_management(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enable_management")

    @enable_management.setter
    def enable_management(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_management", value)

    @property
    @pulumi.getter(name="externalContainerDatabaseId")
    def external_container_database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ExternalContainerDatabase [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "external_container_database_id")

    @external_container_database_id.setter
    def external_container_database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_container_database_id", value)

    @property
    @pulumi.getter(name="externalDatabaseConnectorId")
    def external_database_connector_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        """
        return pulumi.get(self, "external_database_connector_id")

    @external_database_connector_id.setter
    def external_database_connector_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_database_connector_id", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle license model that applies to the external database. Required only for enabling database management.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)


class ExternalContainerDatabaseManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_management: Optional[pulumi.Input[bool]] = None,
                 external_container_database_id: Optional[pulumi.Input[str]] = None,
                 external_database_connector_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the External Container Database Management resource in Oracle Cloud Infrastructure Database service.

        Enables Database Management Service for the external container database.
        For more information about the Database Management Service, see
        [Database Management Service](https://docs.cloud.oracle.com/iaas/Content/ExternalDatabase/Concepts/databasemanagementservice.htm).

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] external_container_database_id: The ExternalContainerDatabase [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] external_database_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        :param pulumi.Input[str] license_model: The Oracle license model that applies to the external database. Required only for enabling database management.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalContainerDatabaseManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the External Container Database Management resource in Oracle Cloud Infrastructure Database service.

        Enables Database Management Service for the external container database.
        For more information about the Database Management Service, see
        [Database Management Service](https://docs.cloud.oracle.com/iaas/Content/ExternalDatabase/Concepts/databasemanagementservice.htm).

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param ExternalContainerDatabaseManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalContainerDatabaseManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ExternalContainerDatabaseManagementArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_management: Optional[pulumi.Input[bool]] = None,
                 external_container_database_id: Optional[pulumi.Input[str]] = None,
                 external_database_connector_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalContainerDatabaseManagementArgs.__new__(ExternalContainerDatabaseManagementArgs)

            if enable_management is None and not opts.urn:
                raise TypeError("Missing required property 'enable_management'")
            __props__.__dict__["enable_management"] = enable_management
            if external_container_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'external_container_database_id'")
            __props__.__dict__["external_container_database_id"] = external_container_database_id
            if external_database_connector_id is None and not opts.urn:
                raise TypeError("Missing required property 'external_database_connector_id'")
            __props__.__dict__["external_database_connector_id"] = external_database_connector_id
            __props__.__dict__["license_model"] = license_model
        super(ExternalContainerDatabaseManagement, __self__).__init__(
            'oci:Database/externalContainerDatabaseManagement:ExternalContainerDatabaseManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_management: Optional[pulumi.Input[bool]] = None,
            external_container_database_id: Optional[pulumi.Input[str]] = None,
            external_database_connector_id: Optional[pulumi.Input[str]] = None,
            license_model: Optional[pulumi.Input[str]] = None) -> 'ExternalContainerDatabaseManagement':
        """
        Get an existing ExternalContainerDatabaseManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] external_container_database_id: The ExternalContainerDatabase [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] external_database_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        :param pulumi.Input[str] license_model: The Oracle license model that applies to the external database. Required only for enabling database management.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalContainerDatabaseManagementState.__new__(_ExternalContainerDatabaseManagementState)

        __props__.__dict__["enable_management"] = enable_management
        __props__.__dict__["external_container_database_id"] = external_container_database_id
        __props__.__dict__["external_database_connector_id"] = external_database_connector_id
        __props__.__dict__["license_model"] = license_model
        return ExternalContainerDatabaseManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enableManagement")
    def enable_management(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "enable_management")

    @property
    @pulumi.getter(name="externalContainerDatabaseId")
    def external_container_database_id(self) -> pulumi.Output[str]:
        """
        The ExternalContainerDatabase [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "external_container_database_id")

    @property
    @pulumi.getter(name="externalDatabaseConnectorId")
    def external_database_connector_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        """
        return pulumi.get(self, "external_database_connector_id")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[str]:
        """
        The Oracle license model that applies to the external database. Required only for enabling database management.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "license_model")

