# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAutonomousVirtualMachineResult',
    'AwaitableGetAutonomousVirtualMachineResult',
    'get_autonomous_virtual_machine',
    'get_autonomous_virtual_machine_output',
]

@pulumi.output_type
class GetAutonomousVirtualMachineResult:
    """
    A collection of values returned by getAutonomousVirtualMachine.
    """
    def __init__(__self__, autonomous_virtual_machine_id=None, autonomous_vm_cluster_id=None, client_ip_address=None, compartment_id=None, cpu_core_count=None, db_node_storage_size_in_gbs=None, db_server_display_name=None, db_server_id=None, defined_tags=None, freeform_tags=None, id=None, memory_size_in_gbs=None, state=None, vm_name=None):
        if autonomous_virtual_machine_id and not isinstance(autonomous_virtual_machine_id, str):
            raise TypeError("Expected argument 'autonomous_virtual_machine_id' to be a str")
        pulumi.set(__self__, "autonomous_virtual_machine_id", autonomous_virtual_machine_id)
        if autonomous_vm_cluster_id and not isinstance(autonomous_vm_cluster_id, str):
            raise TypeError("Expected argument 'autonomous_vm_cluster_id' to be a str")
        pulumi.set(__self__, "autonomous_vm_cluster_id", autonomous_vm_cluster_id)
        if client_ip_address and not isinstance(client_ip_address, str):
            raise TypeError("Expected argument 'client_ip_address' to be a str")
        pulumi.set(__self__, "client_ip_address", client_ip_address)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if cpu_core_count and not isinstance(cpu_core_count, int):
            raise TypeError("Expected argument 'cpu_core_count' to be a int")
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if db_node_storage_size_in_gbs and not isinstance(db_node_storage_size_in_gbs, int):
            raise TypeError("Expected argument 'db_node_storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_server_display_name and not isinstance(db_server_display_name, str):
            raise TypeError("Expected argument 'db_server_display_name' to be a str")
        pulumi.set(__self__, "db_server_display_name", db_server_display_name)
        if db_server_id and not isinstance(db_server_id, str):
            raise TypeError("Expected argument 'db_server_id' to be a str")
        pulumi.set(__self__, "db_server_id", db_server_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if memory_size_in_gbs and not isinstance(memory_size_in_gbs, int):
            raise TypeError("Expected argument 'memory_size_in_gbs' to be a int")
        pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vm_name and not isinstance(vm_name, str):
            raise TypeError("Expected argument 'vm_name' to be a str")
        pulumi.set(__self__, "vm_name", vm_name)

    @property
    @pulumi.getter(name="autonomousVirtualMachineId")
    def autonomous_virtual_machine_id(self) -> str:
        return pulumi.get(self, "autonomous_virtual_machine_id")

    @property
    @pulumi.getter(name="autonomousVmClusterId")
    def autonomous_vm_cluster_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous VM Cluster associated with the Autonomous Virtual Machine.
        """
        return pulumi.get(self, "autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="clientIpAddress")
    def client_ip_address(self) -> str:
        """
        Client IP Address.
        """
        return pulumi.get(self, "client_ip_address")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> int:
        """
        The number of CPU cores enabled on the Autonomous Virtual Machine.
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> int:
        """
        The allocated local node storage in GBs on the Autonomous Virtual Machine.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @property
    @pulumi.getter(name="dbServerDisplayName")
    def db_server_display_name(self) -> str:
        """
        The display name of the dbServer associated with the Autonomous Virtual Machine.
        """
        return pulumi.get(self, "db_server_display_name")

    @property
    @pulumi.getter(name="dbServerId")
    def db_server_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Db server associated with the Autonomous Virtual Machine.
        """
        return pulumi.get(self, "db_server_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> int:
        """
        The allocated memory in GBs on the Autonomous Virtual Machine.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Autonomous Virtual Machine.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vmName")
    def vm_name(self) -> str:
        """
        The name of the Autonomous Virtual Machine.
        """
        return pulumi.get(self, "vm_name")


class AwaitableGetAutonomousVirtualMachineResult(GetAutonomousVirtualMachineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousVirtualMachineResult(
            autonomous_virtual_machine_id=self.autonomous_virtual_machine_id,
            autonomous_vm_cluster_id=self.autonomous_vm_cluster_id,
            client_ip_address=self.client_ip_address,
            compartment_id=self.compartment_id,
            cpu_core_count=self.cpu_core_count,
            db_node_storage_size_in_gbs=self.db_node_storage_size_in_gbs,
            db_server_display_name=self.db_server_display_name,
            db_server_id=self.db_server_id,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            id=self.id,
            memory_size_in_gbs=self.memory_size_in_gbs,
            state=self.state,
            vm_name=self.vm_name)


def get_autonomous_virtual_machine(autonomous_virtual_machine_id: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousVirtualMachineResult:
    """
    This data source provides details about a specific Autonomous Virtual Machine resource in Oracle Cloud Infrastructure Database service.

    Gets the details of specific Autonomous Virtual Machine.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_virtual_machine = oci.Database.get_autonomous_virtual_machine(autonomous_virtual_machine_id=oci_database_autonomous_virtual_machine["test_autonomous_virtual_machine"]["id"])
    ```


    :param str autonomous_virtual_machine_id: The Autonomous Virtual machine [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousVirtualMachineId'] = autonomous_virtual_machine_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousVirtualMachine:getAutonomousVirtualMachine', __args__, opts=opts, typ=GetAutonomousVirtualMachineResult).value

    return AwaitableGetAutonomousVirtualMachineResult(
        autonomous_virtual_machine_id=pulumi.get(__ret__, 'autonomous_virtual_machine_id'),
        autonomous_vm_cluster_id=pulumi.get(__ret__, 'autonomous_vm_cluster_id'),
        client_ip_address=pulumi.get(__ret__, 'client_ip_address'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        cpu_core_count=pulumi.get(__ret__, 'cpu_core_count'),
        db_node_storage_size_in_gbs=pulumi.get(__ret__, 'db_node_storage_size_in_gbs'),
        db_server_display_name=pulumi.get(__ret__, 'db_server_display_name'),
        db_server_id=pulumi.get(__ret__, 'db_server_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        memory_size_in_gbs=pulumi.get(__ret__, 'memory_size_in_gbs'),
        state=pulumi.get(__ret__, 'state'),
        vm_name=pulumi.get(__ret__, 'vm_name'))


@_utilities.lift_output_func(get_autonomous_virtual_machine)
def get_autonomous_virtual_machine_output(autonomous_virtual_machine_id: Optional[pulumi.Input[str]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAutonomousVirtualMachineResult]:
    """
    This data source provides details about a specific Autonomous Virtual Machine resource in Oracle Cloud Infrastructure Database service.

    Gets the details of specific Autonomous Virtual Machine.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_virtual_machine = oci.Database.get_autonomous_virtual_machine(autonomous_virtual_machine_id=oci_database_autonomous_virtual_machine["test_autonomous_virtual_machine"]["id"])
    ```


    :param str autonomous_virtual_machine_id: The Autonomous Virtual machine [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
