# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagedDatabaseSqlTuningAdvisorTaskResult',
    'AwaitableGetManagedDatabaseSqlTuningAdvisorTaskResult',
    'get_managed_database_sql_tuning_advisor_task',
    'get_managed_database_sql_tuning_advisor_task_output',
]

@pulumi.output_type
class GetManagedDatabaseSqlTuningAdvisorTaskResult:
    """
    A collection of values returned by getManagedDatabaseSqlTuningAdvisorTask.
    """
    def __init__(__self__, id=None, items=None, managed_database_id=None, name=None, status=None, time_greater_than_or_equal_to=None, time_less_than_or_equal_to=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if time_greater_than_or_equal_to and not isinstance(time_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_greater_than_or_equal_to", time_greater_than_or_equal_to)
        if time_less_than_or_equal_to and not isinstance(time_less_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_less_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_less_than_or_equal_to", time_less_than_or_equal_to)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetManagedDatabaseSqlTuningAdvisorTaskItemResult']:
        """
        A list of SQL Tuning Advisor tasks.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> str:
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the SQL Tuning Advisor task.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeGreaterThanOrEqualTo")
    def time_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeLessThanOrEqualTo")
    def time_less_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_less_than_or_equal_to")


class AwaitableGetManagedDatabaseSqlTuningAdvisorTaskResult(GetManagedDatabaseSqlTuningAdvisorTaskResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseSqlTuningAdvisorTaskResult(
            id=self.id,
            items=self.items,
            managed_database_id=self.managed_database_id,
            name=self.name,
            status=self.status,
            time_greater_than_or_equal_to=self.time_greater_than_or_equal_to,
            time_less_than_or_equal_to=self.time_less_than_or_equal_to)


def get_managed_database_sql_tuning_advisor_task(managed_database_id: Optional[str] = None,
                                                 name: Optional[str] = None,
                                                 status: Optional[str] = None,
                                                 time_greater_than_or_equal_to: Optional[str] = None,
                                                 time_less_than_or_equal_to: Optional[str] = None,
                                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseSqlTuningAdvisorTaskResult:
    """
    This data source provides details about a specific Managed Database Sql Tuning Advisor Task resource in Oracle Cloud Infrastructure Database Management service.

    Lists the SQL Tuning Advisor tasks for the specified Managed Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_sql_tuning_advisor_task = oci.DatabaseManagement.get_managed_database_sql_tuning_advisor_task(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        name=var["managed_database_sql_tuning_advisor_task_name"],
        status=var["managed_database_sql_tuning_advisor_task_status"],
        time_greater_than_or_equal_to=var["managed_database_sql_tuning_advisor_task_time_greater_than_or_equal_to"],
        time_less_than_or_equal_to=var["managed_database_sql_tuning_advisor_task_time_less_than_or_equal_to"])
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str name: The optional query parameter to filter the SQL Tuning Advisor task list by name.
    :param str status: The optional query parameter to filter the SQL Tuning Advisor task list by status.
    :param str time_greater_than_or_equal_to: The optional greater than or equal to query parameter to filter the timestamp.
    :param str time_less_than_or_equal_to: The optional less than or equal to query parameter to filter the timestamp.
    """
    __args__ = dict()
    __args__['managedDatabaseId'] = managed_database_id
    __args__['name'] = name
    __args__['status'] = status
    __args__['timeGreaterThanOrEqualTo'] = time_greater_than_or_equal_to
    __args__['timeLessThanOrEqualTo'] = time_less_than_or_equal_to
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabaseSqlTuningAdvisorTask:getManagedDatabaseSqlTuningAdvisorTask', __args__, opts=opts, typ=GetManagedDatabaseSqlTuningAdvisorTaskResult).value

    return AwaitableGetManagedDatabaseSqlTuningAdvisorTaskResult(
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        name=pulumi.get(__ret__, 'name'),
        status=pulumi.get(__ret__, 'status'),
        time_greater_than_or_equal_to=pulumi.get(__ret__, 'time_greater_than_or_equal_to'),
        time_less_than_or_equal_to=pulumi.get(__ret__, 'time_less_than_or_equal_to'))


@_utilities.lift_output_func(get_managed_database_sql_tuning_advisor_task)
def get_managed_database_sql_tuning_advisor_task_output(managed_database_id: Optional[pulumi.Input[str]] = None,
                                                        name: Optional[pulumi.Input[Optional[str]]] = None,
                                                        status: Optional[pulumi.Input[Optional[str]]] = None,
                                                        time_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                                        time_less_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabaseSqlTuningAdvisorTaskResult]:
    """
    This data source provides details about a specific Managed Database Sql Tuning Advisor Task resource in Oracle Cloud Infrastructure Database Management service.

    Lists the SQL Tuning Advisor tasks for the specified Managed Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_sql_tuning_advisor_task = oci.DatabaseManagement.get_managed_database_sql_tuning_advisor_task(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        name=var["managed_database_sql_tuning_advisor_task_name"],
        status=var["managed_database_sql_tuning_advisor_task_status"],
        time_greater_than_or_equal_to=var["managed_database_sql_tuning_advisor_task_time_greater_than_or_equal_to"],
        time_less_than_or_equal_to=var["managed_database_sql_tuning_advisor_task_time_less_than_or_equal_to"])
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str name: The optional query parameter to filter the SQL Tuning Advisor task list by name.
    :param str status: The optional query parameter to filter the SQL Tuning Advisor task list by status.
    :param str time_greater_than_or_equal_to: The optional greater than or equal to query parameter to filter the timestamp.
    :param str time_less_than_or_equal_to: The optional less than or equal to query parameter to filter the timestamp.
    """
    ...
